/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.TypesafeMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashableCoreMap
extends ArrayCoreMap {
    private final Set<Class<? extends TypesafeMap.Key<CoreMap, ?>>> immutableKeys;
    private final int hashcode;
    private static final long serialVersionUID = 1L;

    public HashableCoreMap(Map<Class<? extends TypesafeMap.Key<CoreMap, ?>>, Object> hashkey) {
        int keyHashcode = 0;
        int valueHashcode = 0;
        for (Map.Entry<Class<TypesafeMap.Key<CoreMap, ?>>, Object> entry : hashkey.entrySet()) {
            keyHashcode += entry.getKey().hashCode();
            valueHashcode += entry.getValue().hashCode();
            super.set(entry.getKey(), entry.getValue());
        }
        this.immutableKeys = hashkey.keySet();
        this.hashcode = keyHashcode * 31 + valueHashcode;
    }

    public HashableCoreMap(ArrayCoreMap other, Set<Class<? extends TypesafeMap.Key<CoreMap, ?>>> hashkey) {
        super(other);
        int keyHashcode = 0;
        int valueHashcode = 0;
        for (Class<TypesafeMap.Key<CoreMap, ?>> key : hashkey) {
            keyHashcode += key.hashCode();
            valueHashcode += super.get(key).hashCode();
        }
        this.immutableKeys = hashkey;
        this.hashcode = keyHashcode * 31 + valueHashcode;
    }

    @Override
    public <VALUEBASE, VALUE extends VALUEBASE, KEY extends TypesafeMap.Key<CoreMap, VALUEBASE>> VALUE set(Class<KEY> key, VALUE value) {
        if (this.immutableKeys.contains(key)) {
            throw new HashableCoreMapException("Attempt to change value of immutable field " + key.getSimpleName());
        }
        return super.set(key, value);
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof HashableCoreMap) {
            HashableCoreMap other = (HashableCoreMap)o;
            if (!((Object)other.immutableKeys).equals(this.immutableKeys)) {
                return false;
            }
            for (Class<? extends TypesafeMap.Key<CoreMap, ?>> clazz : this.immutableKeys) {
                if (this.get(clazz).equals(other.get(clazz))) continue;
                return false;
            }
            return true;
        }
        return super.equals(o);
    }

    public static class HashableCoreMapException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public HashableCoreMapException(String message) {
            super(message);
        }
    }
}

