# This Makefile.PL for App-s2p was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.48.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT" => "a stream editor",
  "AUTHOR" => "Leon Timmermans <leont\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "App-s2p",
  "EXE_FILES" => [
    "script/psed",
    "script/s2p"
  ],
  "LICENSE" => "unrestricted",
  "NAME" => "App::s2p",
  "PREREQ_PM" => {
    "Symbol" => 0,
    "integer" => 0,
    "strict" => 0,
    "vars" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Devel::FindPerl" => "0.009",
    "File::Copy" => 0,
    "File::Spec" => 0,
    "IO::Handle" => 0,
    "IPC::Open2" => 0,
    "IPC::Open3" => 0,
    "Test::More" => 0,
    "blib" => "1.01"
  },
  "VERSION" => "1.003",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Devel::FindPerl" => "0.009",
  "File::Copy" => 0,
  "File::Spec" => 0,
  "IO::Handle" => 0,
  "IPC::Open2" => 0,
  "IPC::Open3" => 0,
  "Symbol" => 0,
  "Test::More" => 0,
  "blib" => "1.01",
  "integer" => 0,
  "strict" => 0,
  "vars" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

package MY;

use File::Spec;

sub postamble {
	my $self = shift;

	my ($s2p, $psed) = map { File::Spec->catfile('script', $_) } qw/s2p psed/;
	return $self->SUPER::postamble . <<"END";
$psed: $s2p
	\$(CP) $s2p $psed

END
}
