# This Makefile.PL for Crypt-SecretBuffer was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

use lib "./inc";
our %PREREQ_PM;
BEGIN {
   %PREREQ_PM= (
      #'ExtUtils::Depends' => '0.405',
      'ExtUtils::CBuilder' => '0.2800',
   );
   # If the prereqs for this script are missing,
   # write out a Makefile that tells CPAN to install them
   my $use_prereqs_code= join('', map { "use $_ $PREREQ_PM{$_}; " } keys %PREREQ_PM).'1;';
   print $use_prereqs_code."\n";
   unless (eval $use_prereqs_code) {
      warn "$@\n";
      WriteMakefile(
         NAME         => 'Crypt::SecretBuffer',
         PREREQ_FATAL => 1,
         PREREQ_PM    => \%PREREQ_PM,
      );
      exit 1; # not reached
   }
}

require ExtUtils::Depends;
require ExtUtils::CFeatureTest;

my $dep= ExtUtils::Depends->new('Crypt::SecretBuffer');
my $test= ExtUtils::CFeatureTest->new;

if ($^O eq 'MSWin32') {
   $test->require_header('windows.h');
   $test->header('wincrypt.h');
} else {
   $test->require_header('unistd.h');
   $test->require_header('fcntl.h');
   $test->require_header('termios.h');
   $test->require_feature(HAVE_PTHREAD => 'pthread_detach', { h => 'pthread.h', -l => 'pthread' });
   $test->require_feature(HAVE_CLOCK_GETTIME => 'clock_gettime', { h => 'time.h', -l => 'rt' });

   $test->feature(HAVE_MINCORE   => 'mincore',   { h => 'sys/mman.h' });
   $test->feature(HAVE_GETRANDOM => 'getrandom', { h => 'sys/random.h' });
}

$test->header('stdbool.h');
$test->feature(HAVE_BOOL      => 'bool x= true; return x == false;');

$test->feature(HAVE_LIBSSL    => 'unsigned char buf[1]; return RAND_bytes(buf, 1) == 1? 0 : 1;',
               { h => 'openssl/rand.h', -l => 'ssl' });

$test->header('string.h');
$test->feature(HAVE_EXPLICIT_BZERO => 'char buf[1]= { 1 }; explicit_bzero(buf, 1); return buf[0];');
$test->feature(HAVE_MEMMEM         => 'return memmem("foo", 3, "bar", 3)? 1 : 0;');

$test->write_config_header('SecretBuffer_config.h');
$test->export_deps($dep);

my @exports= `$^X build-manual-linkage-header.pl --list-prototypes < SecretBuffer.h`;
chomp(@exports);
$dep->add_exported_c_api($_) for @exports;

$dep->install('SecretBuffer.h', 'SecretBufferManualLinkage.h');
$dep->add_xs('SecretBuffer.xs');
$dep->add_pm(map { my $n= $_; $n =~ s/^lib/\$(INST_LIB)/; $_ => $n } <lib/*/*.pm>, <lib/*/*/*.pm>);
$dep->add_typemaps('typemap');
$dep->save_config('InstallFiles.pm');

sub MY::postamble {
   return <<LITERAL;

SecretBufferManualLinkage.h: SecretBuffer.h
\t\$(PERL) build-manual-linkage-header.pl < SecretBuffer.h > SecretBufferManualLinkage.h

SecretBuffer.c: SecretBufferManualLinkage.h

LITERAL
}

my %WriteMakefileArgs = (
  "ABSTRACT" => "Prevent accidentally copying a string of sensitive data",
  "AUTHOR" => "Michael Conrad <mike\@nrdvana.net>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::CBuilder" => "0.2800",
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Crypt-SecretBuffer",
  "LICENSE" => "perl",
  "NAME" => "Crypt::SecretBuffer",
  "PREREQ_PM" => {
    "Carp" => 0,
    "DynaLoader" => 0,
    "Exporter" => 0,
    "File::Spec" => 0,
    "File::Temp" => 0,
    "Scalar::Util" => 0,
    "overload" => 0,
    "parent" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Data::Dumper" => 0,
    "Encode" => 0,
    "FindBin" => 0,
    "IO::Handle" => 0,
    "POSIX" => 0,
    "Test2::Suite" => "0.000139",
    "Test2::Tools::Subtest" => 0,
    "Test2::V0" => 0,
    "Time::HiRes" => 0,
    "lib" => 0
  },
  "VERSION" => "0.011",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    $dep->get_makefile_vars,
);

my %FallbackPrereqs = (
  "Carp" => 0,
  "Data::Dumper" => 0,
  "DynaLoader" => 0,
  "Encode" => 0,
  "Exporter" => 0,
  "File::Spec" => 0,
  "File::Temp" => 0,
  "FindBin" => 0,
  "IO::Handle" => 0,
  "POSIX" => 0,
  "Scalar::Util" => 0,
  "Test2::Suite" => "0.000139",
  "Test2::Tools::Subtest" => 0,
  "Test2::V0" => 0,
  "Time::HiRes" => 0,
  "lib" => 0,
  "overload" => 0,
  "parent" => 0,
  "strict" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
