#!/usr/bin/perl

package eBay::API::XML::Call::GetProducts::GetProductsRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetProductsRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetProducts::GetProductsRequestType

=head1 DESCRIPTION

Searches for stock information and reviews for certain kinds of products,
such as a particular digital camera model.
<p>
GetProducts is designed to be useful to applications that support
shopping comparison, product reviews, or basic supply and
demand data.
</p>
<p>
GetProducts also supports tracking so that members of the
eBay Affiliates Program can get commissions for driving traffic to eBay.
</p>
<p class="tablenote"><b>Note:</b>
For selling use cases, use GetProductSearchResults and
GetProductSellingPages instead.
</p>
<p>
To use this call, you typically pass in keywords, and GetProducts finds
products with matching words in the product title, description, and/or
Item Specifics.
<p>
For each product of interest, you call GetProducts again to retrieve
additional details that would be useful to buyers:
</p>
<ul>
<li>Top reviews of the product by eBay members,
including part of the review text, plus links to the full text on the
eBay Web site.</li>
<li>Relevant buying guides (shopping advice) written by
eBay members and by eBay staff, including part of the guide text,
plus links to the full text
on the eBay Web site.</li>
<li>Up to 200 matching items on eBay (if any). (To find more matching
items, use GetSearchResults.)</li>
</ul>
<p>
<span class="tablenote"><b>Note:</b>
As catalog queries can take longer than item queries,
GetProducts can be slower than GetSearchResults.
Also, due to the way product data is cached, you may get a faster response
when you run the same query a second time.</span>



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetProducts::GetProductsRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::AffiliateTrackingDetailsType;
use eBay::API::XML::DataType::ProductSearchType;
use eBay::API::XML::DataType::Enum::ProductSortCodeType;


my @gaProperties = ( [ 'AffiliateTrackingDetails', 'ns:AffiliateTrackingDetailsType', ''
	     ,'eBay::API::XML::DataType::AffiliateTrackingDetailsType', '1' ]
	, [ 'IncludeBuyingGuideDetails', 'xs:boolean', '', '', '' ]
	, [ 'IncludeHistogram', 'xs:boolean', '', '', '' ]
	, [ 'IncludeItemArray', 'xs:boolean', '', '', '' ]
	, [ 'IncludeReviewDetails', 'xs:boolean', '', '', '' ]
	, [ 'ProductSearch', 'ns:ProductSearchType', ''
	     ,'eBay::API::XML::DataType::ProductSearchType', '1' ]
	, [ 'ProductSort', 'ns:ProductSortCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ProductSortCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAffiliateTrackingDetails()

See the 
<a href="https://www.ebaypartnernetwork.com/" target="_blank">eBay Partner Network</a>.
eBay uses the specified details to build a View Item URL
string in the response that includes your
affiliate tracking information in the correct format.
When a user clicks through the URL to eBay and performs
certain tasks, you may get a commission (see the URL above).
Only applicable when IncludeItemArray is specified
(because the View Item URL is only returned in item information,
not in product information).

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AffiliateTrackingConcepts
Title: Affiliate Tracking Concepts

  RequiredInput: No
#    Argument: 'ns:AffiliateTrackingDetailsType'

=cut

sub setAffiliateTrackingDetails {
  my $self = shift;
  $self->{'AffiliateTrackingDetails'} = shift
}

=head2 getAffiliateTrackingDetails()

#    Returns: 'ns:AffiliateTrackingDetailsType'

=cut

sub getAffiliateTrackingDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AffiliateTrackingDetails'
		,'eBay::API::XML::DataType::AffiliateTrackingDetailsType');
}


=head2 setIncludeBuyingGuideDetails()

If true, the response includes up to 5 buying guides (if any)
for the product specified in ExternalProductID or
ProductReferenceID.
Not applicable with QueryKeywords.

  RequiredInput: No
  Default: false
#    Argument: 'xs:boolean'

=cut

sub setIncludeBuyingGuideDetails {
  my $self = shift;
  $self->{'IncludeBuyingGuideDetails'} = shift
}

=head2 isIncludeBuyingGuideDetails()

#    Returns: 'xs:boolean'

=cut

sub isIncludeBuyingGuideDetails {
  my $self = shift;
  return $self->{'IncludeBuyingGuideDetails'};
}


=head2 setIncludeHistogram()

If true, the response includes a histogram that lists the
number of matching products found and the domains in which
they were found. (A domain is like a high-level category.)
Including the histogram can affect the call's performance.
You may see significantly slower response times when many
matching products are found.

  RequiredInput: No
  Default: false
#    Argument: 'xs:boolean'

=cut

sub setIncludeHistogram {
  my $self = shift;
  $self->{'IncludeHistogram'} = shift
}

=head2 isIncludeHistogram()

#    Returns: 'xs:boolean'

=cut

sub isIncludeHistogram {
  my $self = shift;
  return $self->{'IncludeHistogram'};
}


=head2 setIncludeItemArray()

If true, the response includes items (if any) that match the
product specified in ExternalProductID or ProductReferenceID.
Not applicable with QueryKeywords.

  RequiredInput: No
  Default: false
#    Argument: 'xs:boolean'

=cut

sub setIncludeItemArray {
  my $self = shift;
  $self->{'IncludeItemArray'} = shift
}

=head2 isIncludeItemArray()

#    Returns: 'xs:boolean'

=cut

sub isIncludeItemArray {
  my $self = shift;
  return $self->{'IncludeItemArray'};
}


=head2 setIncludeReviewDetails()

If true, the response includes up to 20 reviews (if any)
for the product specified in ExternalProductID or
ProductReferenceID.
The reviews are sorted by most helpful (most votes) first.
When you include review details, please note that
response times may be longer than 60 seconds.
Not applicable with QueryKeywords.

  RequiredInput: No
  Default: false
#    Argument: 'xs:boolean'

=cut

sub setIncludeReviewDetails {
  my $self = shift;
  $self->{'IncludeReviewDetails'} = shift
}

=head2 isIncludeReviewDetails()

#    Returns: 'xs:boolean'

=cut

sub isIncludeReviewDetails {
  my $self = shift;
  return $self->{'IncludeReviewDetails'};
}


=head2 setProductSearch()

Contains the fields that form the search query. You can query
against keywords, an eBay product reference ID (not to be confused
with an eBay product ID), or external product ID (like an ISBN).

  RequiredInput: Yes
#    Argument: 'ns:ProductSearchType'

=cut

sub setProductSearch {
  my $self = shift;
  $self->{'ProductSearch'} = shift
}

=head2 getProductSearch()

#    Returns: 'ns:ProductSearchType'

=cut

sub getProductSearch {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ProductSearch'
		,'eBay::API::XML::DataType::ProductSearchType');
}


=head2 setProductSort()

Sorts the list of products returned. This is mostly only useful
with QueryKeywords. (When you use ExternalProductID or
ProductReferenceID, eBay usually only returns one product.)

  RequiredInput: No
#    Argument: 'ns:ProductSortCodeType'

=cut

sub setProductSort {
  my $self = shift;
  $self->{'ProductSort'} = shift
}

=head2 getProductSort()

#    Returns: 'ns:ProductSortCodeType'

=cut

sub getProductSort {
  my $self = shift;
  return $self->{'ProductSort'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
