#!/usr/bin/perl

package eBay::API::XML::DataType::PromotionalSaleType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. PromotionalSaleType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::PromotionalSaleType

=head1 DESCRIPTION

Details for a single promotional sale.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::PromotionalSaleType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ItemIDArrayType;
use eBay::API::XML::DataType::Enum::DiscountCodeType;
use eBay::API::XML::DataType::Enum::PromotionalSaleStatusCodeType;
use eBay::API::XML::DataType::Enum::PromotionalSaleTypeCodeType;


my @gaProperties = ( [ 'DiscountType', 'ns:DiscountCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::DiscountCodeType', '' ]
	, [ 'DiscountValue', 'xs:double', '', '', '' ]
	, [ 'PromotionalSaleEndTime', 'xs:dateTime', '', '', '' ]
	, [ 'PromotionalSaleID', 'xs:long', '', '', '' ]
	, [ 'PromotionalSaleItemIDArray', 'ns:ItemIDArrayType', ''
	     ,'eBay::API::XML::DataType::ItemIDArrayType', '1' ]
	, [ 'PromotionalSaleName', 'xs:string', '', '', '' ]
	, [ 'PromotionalSaleStartTime', 'xs:dateTime', '', '', '' ]
	, [ 'PromotionalSaleType', 'ns:PromotionalSaleTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::PromotionalSaleTypeCodeType', '' ]
	, [ 'Status', 'ns:PromotionalSaleStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::PromotionalSaleStatusCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDiscountType()

Type of a promotional sale discount for items (for example, percentage). 
Applies to price discount sales only.

  Calls: SetPromotionalSale
  RequiredInput: Conditionally

#    Argument: 'ns:DiscountCodeType'

=cut

sub setDiscountType {
  my $self = shift;
  $self->{'DiscountType'} = shift
}

=head2 getDiscountType()

  Calls: GetPromotionalSaleDetails
  Returned: Conditionally

#    Returns: 'ns:DiscountCodeType'

=cut

sub getDiscountType {
  my $self = shift;
  return $self->{'DiscountType'};
}


=head2 setDiscountValue()

Value of a promotional sale discount for items, a percentage discount 
or a fixed amount reduction. Percentage discounts must be at least 5% and 
cannot exceed 75% of the original listing price. Fixed amount discounts 
will be in the currency of the original listing. 
Applies to price discount sales only.

  Calls: SetPromotionalSale
  RequiredInput: Conditionally

#    Argument: 'xs:double'

=cut

sub setDiscountValue {
  my $self = shift;
  $self->{'DiscountValue'} = shift
}

=head2 getDiscountValue()

  Calls: GetPromotionalSaleDetails
  Returned: Conditionally

#    Returns: 'xs:double'

=cut

sub getDiscountValue {
  my $self = shift;
  return $self->{'DiscountValue'};
}


=head2 setPromotionalSaleEndTime()

End date of a promotional sale discount for items. Maximum listing durations
vary by site from 14 days to 45 days. The minimum promotional sale duration is 1 day for most sites, but 3 days on some sites.

  Calls: SetPromotionalSale
  RequiredInput: Conditionally

#    Argument: 'xs:dateTime'

=cut

sub setPromotionalSaleEndTime {
  my $self = shift;
  $self->{'PromotionalSaleEndTime'} = shift
}

=head2 getPromotionalSaleEndTime()

  Calls: GetPromotionalSaleDetails
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getPromotionalSaleEndTime {
  my $self = shift;
  return $self->{'PromotionalSaleEndTime'};
}


=head2 setPromotionalSaleID()

Unique ID of a promotional sale (discount and/or free shipping) for items.
This field is an input field only for the SetPromotionalSale call
and only if you are not adding a new promotional sale.

  Calls: SetPromotionalSale
  RequiredInput: Conditionally

#    Argument: 'xs:long'

=cut

sub setPromotionalSaleID {
  my $self = shift;
  $self->{'PromotionalSaleID'} = shift
}

=head2 getPromotionalSaleID()

  Calls: GetPromotionalSaleDetails
  Returned: Conditionally

#    Returns: 'xs:long'

=cut

sub getPromotionalSaleID {
  my $self = shift;
  return $self->{'PromotionalSaleID'};
}


=head2 setPromotionalSaleItemIDArray()

Items covered by a promotional sale.

#    Argument: 'ns:ItemIDArrayType'

=cut

sub setPromotionalSaleItemIDArray {
  my $self = shift;
  $self->{'PromotionalSaleItemIDArray'} = shift
}

=head2 getPromotionalSaleItemIDArray()

  Calls: GetPromotionalSaleDetails
  Returned: Conditionally

#    Returns: 'ns:ItemIDArrayType'

=cut

sub getPromotionalSaleItemIDArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PromotionalSaleItemIDArray'
		,'eBay::API::XML::DataType::ItemIDArrayType');
}


=head2 setPromotionalSaleName()

Name of a promotional sale for items.

  Calls: SetPromotionalSale
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setPromotionalSaleName {
  my $self = shift;
  $self->{'PromotionalSaleName'} = shift
}

=head2 getPromotionalSaleName()

  Calls: GetPromotionalSaleDetails
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getPromotionalSaleName {
  my $self = shift;
  return $self->{'PromotionalSaleName'};
}


=head2 setPromotionalSaleStartTime()

Start date of a promotional sale for items. Promotional sales can start
immediately or be scheduled to start at a later date. Some sites require
items to have been listed for a specific duration before they can be added
to a promotional sale (for example, on the US site, items must have been 
listed for a day before they can be added to a promotional sale).

  Calls: SetPromotionalSale
  RequiredInput: Conditionally

#    Argument: 'xs:dateTime'

=cut

sub setPromotionalSaleStartTime {
  my $self = shift;
  $self->{'PromotionalSaleStartTime'} = shift
}

=head2 getPromotionalSaleStartTime()

  Calls: GetPromotionalSaleDetails
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getPromotionalSaleStartTime {
  my $self = shift;
  return $self->{'PromotionalSaleStartTime'};
}


=head2 setPromotionalSaleType()

Type of promotional sale: price discount, free shipping, or both.

  Calls: SetPromotionalSale
  RequiredInput: Conditionally

#    Argument: 'ns:PromotionalSaleTypeCodeType'

=cut

sub setPromotionalSaleType {
  my $self = shift;
  $self->{'PromotionalSaleType'} = shift
}

=head2 getPromotionalSaleType()

  Calls: GetPromotionalSaleDetails
  Returned: Conditionally

#    Returns: 'ns:PromotionalSaleTypeCodeType'

=cut

sub getPromotionalSaleType {
  my $self = shift;
  return $self->{'PromotionalSaleType'};
}


=head2 setStatus()

Status of a promotional sale for items.

#    Argument: 'ns:PromotionalSaleStatusCodeType'

=cut

sub setStatus {
  my $self = shift;
  $self->{'Status'} = shift
}

=head2 getStatus()

  Calls: GetPromotionalSaleDetails
  Returned: Conditionally

#    Returns: 'ns:PromotionalSaleStatusCodeType'

=cut

sub getStatus {
  my $self = shift;
  return $self->{'Status'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
