#!/usr/bin/perl

package eBay::API::XML::DataType::VeROReportItemType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. VeROReportItemType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::VeROReportItemType

=head1 DESCRIPTION

Contains the item information to report.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::VeROReportItemType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ItemIDType;


my @gaProperties = ( [ 'CopyEmailToRightsOwner', 'xs:boolean', '', '', '' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'MessageToSeller', 'xs:string', '', '', '' ]
	, [ 'VeROReasonCodeID', 'xs:long', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCopyEmailToRightsOwner()

When set to true, this specifies that the VeRO Program member be copied on 
the Notice of Claimed Infringement (NOCI) email sent to sellers of reported 
items.

Default: true

  Calls: VeROReportItems
  RequiredInput: Conditionally

#    Argument: 'xs:boolean'

=cut

sub setCopyEmailToRightsOwner {
  my $self = shift;
  $self->{'CopyEmailToRightsOwner'} = shift
}

=head2 isCopyEmailToRightsOwner()

#    Returns: 'xs:boolean'

=cut

sub isCopyEmailToRightsOwner {
  my $self = shift;
  return $self->{'CopyEmailToRightsOwner'};
}


=head2 setItemID()

The item ID for the item being reported for alleged infringement.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  Calls: VeROReportItems
  RequiredInput: Yes

#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setMessageToSeller()

Message from the VeRO Program member to the seller of the item being reported.

MaxLength: 1000

  Calls: VeROReportItems
  RequiredInput: Yes

#    Argument: 'xs:string'

=cut

sub setMessageToSeller {
  my $self = shift;
  $self->{'MessageToSeller'} = shift
}

=head2 getMessageToSeller()

#    Returns: 'xs:string'

=cut

sub getMessageToSeller {
  my $self = shift;
  return $self->{'MessageToSeller'};
}


=head2 setVeROReasonCodeID()

The resaon code identifier for the type of claimed infringement. Use 
GetVeROReasonCodeDetails to retrieve a list of reason codes for a given site 
or all sites.

Max: Min: 
  Calls: VeROReportItems
  RequiredInput: Yes

#    Argument: 'xs:long'

=cut

sub setVeROReasonCodeID {
  my $self = shift;
  $self->{'VeROReasonCodeID'} = shift
}

=head2 getVeROReasonCodeID()

#    Returns: 'xs:long'

=cut

sub getVeROReasonCodeID {
  my $self = shift;
  return $self->{'VeROReasonCodeID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
