######## GeoData for Geo::Location::TimeZone - Check main library for copyright.
######## Roughly GMT -8
package Geo::Location::TimeZone::U;
use Class::Singleton;
use Geo::Location::TimeZone;
@ISA = qw(Class::Singleton Geo::Location::TimeZone);
# Coordinates are X,Y, NOT lat,lon
# Output of partial data at 1172109537
my $data = {
	# Longitude -127.5 to -112.5
	"-8" => {
		# Grid -8:-6 ; 2 records
		"-6" => {
			"def_z" => "Antartica/South_Pole",
			"61" => {
				"z" => "Etc/GMT-7",
				"c" => "ESRI",
				"s" => "8,1",
				"p" => [[-126.239463806152,-82.5],[-112.5,-82.5],[-112.5,-90],[-112.503349304199,-90],[-112.503186940136,-82.5],[-124.871658325195,-82.5],[-126.239463806152,-82.5],],
			},
		},
		# Grid -8:-5 ; 1 records
		"-5" => {
			"62" => {
				"z" => "Etc/GMT-7",
				"c" => "ESRI",
				"s" => "8,1",
				"p" => [[-126.239463806152,-67.5],[-112.5,-67.5],[-112.5,-82.5],[-112.503186940136,-82.5],[-112.503036499023,-75.5507507324219],[-112.502863748695,-67.5],[-124.871658325195,-67.5],[-126.239463806152,-67.5],],
			},
		},
		# Grid -8:-4 ; 1 records
		"-4" => {
			"63" => {
				"z" => "Etc/GMT-7",
				"c" => "ESRI",
				"s" => "8,1",
				"p" => [[-126.239463806152,-52.5],[-112.5,-52.5],[-112.5,-67.5],[-112.502863748695,-67.5],[-112.50269317627,-59.5507469177246],[-112.50254198312,-52.5],[-124.871658325195,-52.5],[-126.239463806152,-52.5],],
			},
		},
		# Grid -8:-3 ; 1 records
		"-3" => {
			"64" => {
				"z" => "Etc/GMT-7",
				"c" => "ESRI",
				"s" => "8,1",
				"p" => [[-126.239463806152,-37.5],[-112.5,-37.5],[-112.5,-52.5],[-112.50254198312,-52.5],[-112.502220329645,-37.5],[-124.871658325195,-37.5],[-126.239463806152,-37.5],],
			},
		},
		# Grid -8:-2 ; 2 records
		"-2" => {
			"def_z" => "Pacific/Marquesas",
			"65" => {
				"z" => "Etc/GMT-7",
				"c" => "ESRI",
				"s" => "8,1",
				"p" => [[-126.239463806152,-22.5],[-112.5,-22.5],[-112.5,-37.5],[-112.502220329645,-37.5],[-112.501968383789,-25.7507476806641],[-112.501897729099,-22.5],[-124.871658325195,-22.5],[-126.239463806152,-22.5],],
			},
		},
		# Grid -8:-1 ; 1 records
		"-1" => {
			"66" => {
				"z" => "Etc/GMT-7",
				"c" => "ESRI",
				"s" => "8,1",
				"p" => [[-126.239463806152,-7.5],[-112.5,-7.5],[-112.5,-22.5],[-112.501897729099,-22.5],[-112.501594543457,-8.55074882507324],[-112.501571919987,-7.5],[-124.871658325195,-7.5],[-126.239463806152,-7.5],],
			},
		},
		# Grid -8:0 ; 1 records
		"0" => {
			"67" => {
				"z" => "Etc/GMT-7",
				"c" => "ESRI",
				"s" => "8,1",
				"p" => [[-126.239463806152,7.5],[-112.5,7.5],[-112.5,-7.5],[-112.501571919987,-7.5],[-112.501248957891,7.5],[-124.871658325195,7.5],[-126.239463806152,7.5],],
			},
		},
		# Grid -8:1 ; 1 records
		"1" => {
			"68" => {
				"z" => "Etc/GMT-7",
				"c" => "ESRI",
				"s" => "8,1",
				"p" => [[-112.5,17.9208297729492],[-112.5,7.5],[-112.501248957891,7.5],[-112.500925995795,22.5],[-112.5,22.5],[-112.5,19.0952758789062],[-112.5,17.9208297729492],],
			},
		},
		# Grid -8:2 ; 2 records
		"2" => {
			"def_z" => "America/Tijuana",
			"69" => {
				"z" => "Etc/GMT-7",
				"c" => "ESRI",
				"s" => "8,1",
				"p" => [[-112.5,24.2847213745117],[-112.5,22.5],[-112.500925995795,22.5],[-112.50089263916,24.0492515563965],[-116.90470123291,24.0525932312012],[-116.90470123291,28.0067138671875],[-114.207672119141,28.0002746582031],[-114.161582946777,28.0005531311035],[-112.723281860352,27.9997406005859],[-112.5,27.9999207012133],[-112.5,28.4614516360345],[-115.017242431641,31.9544296264648],[-114.998901367188,32.1361083984375],[-115.041519165039,32.2546691894531],[-114.964172363281,32.3686065673828],[-114.936683654785,32.4730529785156],[-114.809829711914,32.5069885253906],[-114.795562744141,32.609992980957],[-114.719093322754,32.7184562683105],[-114.689987182617,32.7427673339844],[-114.54167175293,32.7272109985352],[-114.526947021484,32.8008270263672],[-114.458053588867,32.8602752685547],[-114.464447021484,32.9716567993164],[-114.508903503418,33.0224914550781],[-114.660827636719,33.0419387817383],[-114.696113586426,33.0869369506836],[-114.667770385742,33.2155456542969],[-114.728607177734,33.3074951171875],[-114.699157714844,33.3605499267578],[-114.726097106934,33.4080429077148],[-114.636672973633,33.4199905395508],[-114.526397705078,33.5616607666016],[-114.522506713867,33.6841583251953],[-114.48388671875,33.7219314575195],[-114.51611328125,33.8249969482422],[-114.48860168457,33.8924942016602],[-114.522506713867,33.9502716064453],[-114.422782897949,34.0263824462891],[-114.390289306641,34.1097183227539],[-114.114723205566,34.2824935913086],[-114.167221069336,34.3574981689453],[-114.373321533203,34.4730453491211],[-114.369720458984,34.5291595458984],[-114.456123352051,34.698600769043],[-114.622222900391,34.8849945068359],[-114.621932983398,34.9921493530273],[-114.633331298828,35.047492980957],[-114.607498168945,35.0822143554688],[-114.63639831543,35.1252670288086],[-114.579452514648,35.144157409668],[-114.568618774414,35.2233200073242],[-114.583892822266,35.3411026000977],[-114.668327331543,35.5102767944336],[-114.643890380859,35.6266555786133],[-114.690277099609,35.7249908447266],[-114.691673278809,35.8149948120117],[-114.660278320312,35.8819351196289],[-114.740547180176,35.9861068725586],[-114.726387023926,36.0827713012695],[-114.550552368164,36.1619338989258],[-114.451400756836,36.1277694702148],[-114.357498168945,36.1461029052734],[-114.237213134766,36.0258255004883],[-114.120826721191,36.0583267211914],[-114.041946411133,36.1997146606445],[-114.040283203125,37.0031204223633],[-114.040514801002,37.5],[-112.5,37.5],[-112.5,27.0613861083984],[-112.5,24.2847213745117],],
			},
		},
		# Grid -8:3 ; 2 records
		"3" => {
			"def_z" => "America/Vancouver",
			"70" => {
				"z" => "Etc/GMT-7",
				"c" => "ESRI",
				"s" => "8,1",
				"p" => [[-112.5,44.7655639648438],[-112.5,37.5],[-114.040514801002,37.5],[-114.042610168457,41.9954872131348],[-116.984909057617,42],[-117.016883850098,42.586009979248],[-118.206558227539,42.5925827026367],[-118.20760345459,42.8133506774902],[-117.970695495605,42.8133506774902],[-117.970695495605,43.0973472595215],[-118.219100952148,43.0973472595215],[-118.22875213623,44.2465133666992],[-118.150527954102,44.2613410949707],[-118.010627746582,44.4229507446289],[-117.962875366211,44.4388046264648],[-117.589889526367,44.4400672912598],[-117.484527587891,44.3798522949219],[-117.482032775879,44.2987213134766],[-117.198547363281,44.3009185791016],[-117.212219238281,44.4824905395508],[-117.13362121582,44.5438842773438],[-117.027786254883,44.7463836669922],[-116.895843505859,44.8311080932617],[-116.837783813477,44.9244384765625],[-116.837219238281,45.0255508422852],[-116.711402893066,45.1702728271484],[-116.650283813477,45.3563842773438],[-116.453338623047,45.6069412231445],[-116.546112060547,45.7622146606445],[-116.779251098633,45.8615684509277],[-116.728332519531,45.8933258056641],[-116.717498779297,45.9733200073242],[-116.621658325195,46.0066604614258],[-116.612213134766,46.0419387817383],[-116.292221069336,45.8930511474609],[-116.27278137207,45.8605499267578],[-116.299163818359,45.6913757324219],[-116.258346557617,45.619987487793],[-116.299163818359,45.4586029052734],[-116.281112670898,45.4244384765625],[-116.198333740234,45.4052658081055],[-115.79638671875,45.4694366455078],[-115.478057861328,45.3886032104492],[-115.177490234375,45.5822143554688],[-114.751068115234,45.4053382873535],[-114.798011779785,45.4340438842773],[-114.78099822998,45.4963912963867],[-114.661239624023,45.4632835388184],[-114.539527893066,45.5670166015625],[-114.544998168945,45.6277694702148],[-114.490829467773,45.7102737426758],[-114.554718017578,45.7794342041016],[-114.496109008789,45.8447113037109],[-114.381942749023,45.8924942016602],[-114.416397094727,45.9288787841797],[-114.402221679688,45.9880447387695],[-114.474166870117,46.0019378662109],[-114.485282897949,46.0497207641602],[-114.449996948242,46.1091613769531],[-114.504463195801,46.1597137451172],[-114.431953430176,46.190544128418],[-114.456123352051,46.2699890136719],[-114.370826721191,46.4536056518555],[-114.400283813477,46.5055541992188],[-114.336669921875,46.5358276367188],[-114.325012207031,46.6691589355469],[-114.576400756836,46.6444396972656],[-114.636672973633,46.6738815307617],[-114.617767333984,46.7174911499023],[-114.669448852539,46.751106262207],[-114.765007019043,46.714714050293],[-114.765556335449,46.7763824462891],[-114.906387329102,46.8413772583008],[-114.915557861328,46.9238815307617],[-115.044998168945,46.9886016845703],[-115.318336486816,47.256103515625],[-115.495826721191,47.3011016845703],[-115.580291748047,47.3852691650391],[-115.72501373291,47.4372100830078],[-115.634742736816,47.4844360351562],[-115.737503051758,47.5558242797852],[-115.674156188965,47.609992980957],[-115.720840454102,47.7080459594727],[-116.049156188965,47.9933242797852],[-116.04833984375,48.9997177124023],[-116.533241271973,49.0012474060059],[-116.561126708984,49.1127777099609],[-116.66707611084,49.2871704101562],[-116.747177124023,49.3398933410645],[-116.835891723633,49.5923538208008],[-116.896728515625,49.640007019043],[-116.876953125,49.7981758117676],[-116.697494506836,49.8569831848145],[-116.711181640625,49.8843574523926],[-116.470886230469,49.8975372314453],[-116.443511962891,49.9816932678223],[-116.49927520752,50.0638198852539],[-116.452133178711,50.1550712585449],[-116.561630249023,50.2138748168945],[-116.54084777832,50.3183097839355],[-116.617904663086,50.3162803649902],[-116.639198303223,50.4095611572266],[-116.722839355469,50.4602546691895],[-116.689384460449,50.4815483093262],[-116.655921936035,50.601188659668],[-116.583938598633,50.6478271484375],[-116.781143188477,50.699535369873],[-116.828796386719,50.7522583007812],[-116.813583374023,50.785717010498],[-116.914978027344,50.7705078125],[-116.963134765625,50.8110656738281],[-117.039176940918,50.8151206970215],[-117.043235778809,50.8556785583496],[-117.085815429688,50.864803314209],[-117.038162231445,50.9570693969727],[-117.165916442871,50.9793739318848],[-117.137023925781,51.0179023742676],[-117.168449401855,51.0249977111816],[-117.422431945801,51.4092674255371],[-117.739280700684,51.4224472045898],[-117.851318359375,51.5167427062988],[-117.800621032715,51.5664215087891],[-117.846244812012,51.5816307067871],[-117.817855834961,51.6313133239746],[-117.838134765625,51.6586875915527],[-117.935470581055,51.6181335449219],[-117.97501373291,51.6536178588867],[-118.066261291504,51.6597023010254],[-118.044464111328,51.7621078491211],[-118.104286193848,51.8553848266602],[-118.616302490234,52.0632362365723],[-118.762306213379,52.1798362731934],[-118.675109863281,52.1534729003906],[-118.586898803711,52.1909866333008],[-118.563583374023,52.2650032043457],[-118.493621826172,52.3136711120605],[-118.356742858887,52.3663940429688],[-118.291854858398,52.338005065918],[-118.227561950684,52.3791732788086],[-118.259742736816,52.4422149658203],[-118.208343505859,52.4808197021484],[-118.240451960274,52.5],[-112.5,52.5],[-112.5,47.2981224060059],[-112.5,44.7655639648438],],
			},
		},
		# Grid -8:4 ; 1 records
		"4" => {
			"71" => {
				"z1" => "-113.5,53.55,America/Edmonton",
				"z0" => "-114.35,62.45,America/Yellowknife",
				"c" => "ESRI",
				"s" => "8,1",
				"p" => [[-127.5,67.5],[-112.5,67.5],[-112.5,52.5],[-118.240451960274,52.5],[-118.28694152832,52.5277709960938],[-118.281677246094,52.5652694702148],[-118.349990844727,52.618049621582],[-118.304992675781,52.6747131347656],[-118.346122741699,52.7433242797852],[-118.42887878418,52.7861099243164],[-118.415557861328,52.8363800048828],[-118.49137878418,52.8977737426758],[-118.625,52.884162902832],[-118.679718017578,52.9705429077148],[-118.663330078125,53.0155487060547],[-118.727493286133,53.0613784790039],[-118.781112670898,53.0558242797852],[-118.754997253418,53.1208267211914],[-118.959732055664,53.2333297729492],[-119.012222290039,53.2230453491211],[-119.013633728027,53.1447143554688],[-119.037780761719,53.1358261108398],[-119.265556335449,53.1966552734375],[-119.352783203125,53.2791595458984],[-119.385833740234,53.3616638183594],[-119.598892211914,53.3788757324219],[-119.636947631836,53.3516616821289],[-119.738052368164,53.3949966430664],[-119.815277099609,53.4997177124023],[-119.902496337891,53.5202713012695],[-119.882766723633,53.5602722167969],[-119.932220458984,53.6072158813477],[-119.768623352051,53.6033248901367],[-119.735282897949,53.6349945068359],[-119.810272216797,53.7077713012695],[-119.921112060547,53.7183227539062],[-119.904716491699,53.7786026000977],[-119.978332519531,53.7888870239258],[-120.000274658203,53.8302230834961],[-120.900596618652,54.2009429931641],[-121.215690612793,54.4810256958008],[-121.6533203125,54.5335426330566],[-122.861183166504,55.4263076782227],[-123.596405029297,55.8989486694336],[-124.121559143066,56.8617362976074],[-124.096885681152,57.0344390869141],[-123.944030761719,57.1224403381348],[-123.75447845459,57.1279907226562],[-123.58878326416,57.3354835510254],[-123.515045166016,57.3666458129883],[-123.4541015625,57.3212966918945],[-123.415283203125,57.1446418762207],[-122.202606201172,56.932315826416],[-122.115257263184,56.9519004821777],[-122.028564453125,57.0169906616211],[-121.840560913086,56.996826171875],[-121.70987701416,57.0243644714355],[-121.280326843262,57.2445411682129],[-120.841461181641,57.2317123413086],[-120.344360351562,57.4780006408691],[-120.216346740723,57.4591598510742],[-120,57.2625045776367],[-120.000007629395,60],[-123.815727233887,60.0000038146973],[-123.97428894043,60.0923767089844],[-124.195266723633,60.3288803100586],[-124.206390380859,60.4572143554688],[-124.418327331543,60.4791564941406],[-124.459442138672,60.5697174072266],[-124.614166259766,60.6686019897461],[-124.619163513184,60.709716796875],[-124.476936340332,60.7905502319336],[-124.591949462891,60.9605484008789],[-124.813049316406,60.9724884033203],[-124.877777099609,60.9172134399414],[-124.871658325195,60.8580474853516],[-125.174728393555,60.8505401611328],[-125.349197387695,60.7834014892578],[-125.711959838867,60.827262878418],[-125.887237548828,60.8969421386719],[-125.956970214844,60.8772354125977],[-126.009201049805,60.8034057617188],[-126.107238769531,60.817008972168],[-126.107513427734,60.8589324951172],[-126.170852661133,60.8658676147461],[-126.239463806152,60.8566970825195],[-126.222793579102,60.8028335571289],[-126.272796630859,60.7853317260742],[-126.394470214844,60.7766799926758],[-126.520278930664,60.8144149780273],[-126.672233581543,60.7434692382812],[-126.776397705078,60.785270690918],[-126.839996337891,60.7572174072266],[-126.886947631836,60.7824935913086],[-126.879707336426,60.8299942016602],[-126.925277709961,60.8622131347656],[-126.898902893066,60.9416580200195],[-126.939437866211,61.0024948120117],[-126.935272216797,61.0591583251953],[-127.05583190918,61.0399932861328],[-127.101936340332,61.0708312988281],[-127.010833740234,61.134162902832],[-127.064437866211,61.3724899291992],[-127.125,61.4011001586914],[-127.141677856445,61.4666595458984],[-127.288330078125,61.519157409668],[-127.379173278809,61.5072174072266],[-127.5,61.5101590128702],[-127.5,67.5],],
			},
		},
		# Grid -8:5 ; 1 records
		"5" => {
			"72" => {
				"z" => "Etc/GMT-7",
				"c" => "ESRI",
				"s" => "8,1",
				"p" => [[-112.5,67.5],[-127.5,67.5],[-127.5,70.5153414516374],[-126.162406921387,71.8960800170898],[-124.809715270996,73.5978546142578],[-125.07152557373,74.1651077270508],[-124.853355407715,74.4705581665039],[-123.195220947266,75.9541549682617],[-123.151580810547,76.3032302856445],[-121.973434448242,76.6086807250977],[-120.577110290527,76.9141235351562],[-118.962608337402,77.437744140625],[-116.9990234375,77.6559219360352],[-114.075469970703,78.3977203369141],[-112.504608154297,78.6158981323242],[-112.504608154297,82.5],[-112.5,82.5],[-112.5,72.7117691040039],[-112.5,67.5],],
			},
		},
		# Grid -8:6 ; 1 records
		"6" => {
			"73" => {
				"z" => "Etc/GMT-7",
				"c" => "ESRI",
				"s" => "8,1",
				"p" => [[-126.239463806152,82.5],[-112.504608154297,82.5],[-112.504608154297,90],[-112.5,90],[-112.5,82.5],[-124.871658325195,82.5],[-126.239463806152,82.5],],
			},
		},
	},
};

# Used by Class::Singleton
sub _new_instance
{
	return shift->_init( @_, data => $data );
}

1;
