package Google::Ads::AdWords::v201302::BudgetOptimizerAdGroupBids;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201302' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201302::AdGroupBids);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %interactionBids_of :ATTR(:get<interactionBids>);
my %AdGroupBids__Type_of :ATTR(:get<AdGroupBids__Type>);
my %proxyKeywordMaxCpc_of :ATTR(:get<proxyKeywordMaxCpc>);
my %enhancedCpcEnabled_of :ATTR(:get<enhancedCpcEnabled>);

__PACKAGE__->_factory(
    [ qw(        interactionBids
        AdGroupBids__Type
        proxyKeywordMaxCpc
        enhancedCpcEnabled

    ) ],
    {
        'interactionBids' => \%interactionBids_of,
        'AdGroupBids__Type' => \%AdGroupBids__Type_of,
        'proxyKeywordMaxCpc' => \%proxyKeywordMaxCpc_of,
        'enhancedCpcEnabled' => \%enhancedCpcEnabled_of,
    },
    {
        'interactionBids' => 'Google::Ads::AdWords::v201302::InteractionBid',
        'AdGroupBids__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'proxyKeywordMaxCpc' => 'Google::Ads::AdWords::v201302::Bid',
        'enhancedCpcEnabled' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    },
    {

        'interactionBids' => 'interactionBids',
        'AdGroupBids__Type' => 'AdGroupBids.Type',
        'proxyKeywordMaxCpc' => 'proxyKeywordMaxCpc',
        'enhancedCpcEnabled' => 'enhancedCpcEnabled',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201302::BudgetOptimizerAdGroupBids

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
BudgetOptimizerAdGroupBids from the namespace https://adwords.google.com/api/adwords/cm/v201302.

Adgroup level bids used in budget optimizer bidding strategy. <span class="constraint AdxEnabled">This is disabled for AdX.</span> 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * proxyKeywordMaxCpc


=item * enhancedCpcEnabled




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

