package Google::Ads::AdWords::v201209::ProductConditionAndGroup;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201209' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %conditions_of :ATTR(:get<conditions>);

__PACKAGE__->_factory(
    [ qw(        conditions

    ) ],
    {
        'conditions' => \%conditions_of,
    },
    {
        'conditions' => 'Google::Ads::AdWords::v201209::ProductCondition',
    },
    {

        'conditions' => 'conditions',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201209::ProductConditionAndGroup

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ProductConditionAndGroup from the namespace https://adwords.google.com/api/adwords/cm/v201209.

Groups a list of product conditions to be evaluated together as an AND condition (ie. true if all conditions are true, false otherwise). 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * conditions




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

