#!/usr/bin/perl
#
# Name:
#	rose.app.gen.pl.

use strict;
use warnings;

use Getopt::Long;
use Pod::Usage;
use Rose::DBx::Bouquet;

# -------------------------------------------------

my($option_parser) = Getopt::Long::Parser -> new();

my(%option);

if ($option_parser -> getoptions(\%option, 'exclude:s', 'help', 'module=s', 'output_dir:s', 'remove', 'tmpl_path:s', 'verbose') )
{
	pod2usage(1) if ($option{'help'});

	exit Rose::DBx::Bouquet -> new(\%option) -> run();
}
else
{
	pod2usage(2);
}

__END__

=pod

=head1 NAME

rose.app.gen.pl - Generate a set of Rose::DB::Object- and Rose::HTML::Form-based classes

=head1 SYNOPSIS

rose.app.gen.pl [options]

	Options:
	-exclude An optional regexp of table names to exclude
	-help
	-module A mandatory module name, e.g. Local::Wine
	-output_dir The optional path to the output dir
	-remove
	-tmpl_path The optional path to Rose::DBx::Bouquet's template directory
	-verbose

Exit value: 0.

Typical usage:

Download http://savage.net.au/Perl/Local-Wine-1.06.tgz
	
	shell> cd /home/yourself/perl.modules
	shell> tar xvzf Local-Wine-1.06.tgz
	shell> less README

or examine the documentation for Rose::DBx::Bouquet.

=head1 OPTIONS

=over 4

=item -exclude A regexp (without the //) of table names to exclude

If not specified, the value defaults to the value in lib/Rose/DBx/Bouquet/.htrose.bouquet.conf.

The default value is ^(?:pg_|sql_), which suits users of Postgres.

This option is optional.

=item -help

Print help and exit.

=item -module A module name, e.g. Local::Wine

Generate a set of modules under this name. So, Local::Wine would result in:

=over 4

=item ./lib/Local/Wine/Rose/*.pm (1 per table)

=item ./lib/Local/Wine/Rose/*/Form.pm (1 per table)

=item ./lib/Local/Wine/Rose/*/Manager.pm (1 per table)

=back

These examples assume -output_dir is defaulting to ./lib.

This option defaults to 'Local::Wine', because the Rose::DBx::Bouquet distro
uses the Local::Wine distro in all its documentation.

See http://savage.net.au/Perl-modules/Local-Wine-1.06.tgz.

This option is mandatory.

=item -output_dir The optional path to the output dir

The path where the output modules will be written.

If not specified, the value defaults to the value in lib/Rose/DBx/Bouquet/.htrose.bouquet.conf.

See the discussion of -module above for more information.

The default value is ./lib.

This option is optional.

=item -remove

Remove files generated by an earlier run of this program.

The default value is 0, meaning do not remove files.

This option is optional.

=item -tmpl_path The optional path to Rose::DBx::Bouquet's template directory

If not specified, the value defaults to the value in lib/Rose/DBx/Bouquet/.htrose.bouquet.conf.

The default value is /home/ron/perl.modules/Rose-DBx-Bouquet-1.00/templates.

This option is optional.

=item -verbose

If not specified, the value defaults to the value in lib/Rose/DBx/Bouquet/.htrose.bouquet.conf.

Print verbose messages.

This option is optional.

=back

=cut
