# Generated by default/object.tt
package Paws::CodeArtifact::DomainDescription;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has AssetSizeBytes => (is => 'ro', isa => 'Int', request_name => 'assetSizeBytes', traits => ['NameInRequest']);
  has CreatedTime => (is => 'ro', isa => 'Str', request_name => 'createdTime', traits => ['NameInRequest']);
  has EncryptionKey => (is => 'ro', isa => 'Str', request_name => 'encryptionKey', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has Owner => (is => 'ro', isa => 'Str', request_name => 'owner', traits => ['NameInRequest']);
  has RepositoryCount => (is => 'ro', isa => 'Int', request_name => 'repositoryCount', traits => ['NameInRequest']);
  has S3BucketArn => (is => 'ro', isa => 'Str', request_name => 's3BucketArn', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeArtifact::DomainDescription

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeArtifact::DomainDescription object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeArtifact::DomainDescription object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Information about a domain. A domain is a container for repositories.
When you create a domain, it is empty until you add one or more
repositories.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the domain.


=head2 AssetSizeBytes => Int

The total size of all assets in the domain.


=head2 CreatedTime => Str

A timestamp that represents the date and time the domain was created.


=head2 EncryptionKey => Str

The ARN of an AWS Key Management Service (AWS KMS) key associated with
a domain.


=head2 Name => Str

The name of the domain.


=head2 Owner => Str

The AWS account ID that owns the domain.


=head2 RepositoryCount => Int

The number of repositories in the domain.


=head2 S3BucketArn => Str

The Amazon Resource Name (ARN) of the Amazon S3 bucket that is used to
store package assets in the domain.


=head2 Status => Str

The current status of a domain. The valid values are

=over

=item *

C<Active>

=item *

C<Deleted>

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeArtifact>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

