# Generated by default/object.tt
package Paws::S3Control::S3BucketDestination;
  use Moose;
  has AccountId => (is => 'ro', isa => 'Str', required => 1);
  has Arn => (is => 'ro', isa => 'Str', required => 1);
  has Encryption => (is => 'ro', isa => 'Paws::S3Control::StorageLensDataExportEncryption');
  has Format => (is => 'ro', isa => 'Str', required => 1);
  has OutputSchemaVersion => (is => 'ro', isa => 'Str', required => 1);
  has Prefix => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::S3Control::S3BucketDestination

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::S3Control::S3BucketDestination object:

  $service_obj->Method(Att1 => { AccountId => $value, ..., Prefix => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::S3Control::S3BucketDestination object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountId

=head1 DESCRIPTION

A container for the bucket where the Amazon S3 Storage Lens metrics
export files are located.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AccountId => Str

The account ID of the owner of the S3 Storage Lens metrics export
bucket.


=head2 B<REQUIRED> Arn => Str

The Amazon Resource Name (ARN) of the bucket. This property is
read-only and follows the following format: C<
arn:aws:s3:I<us-east-1>:I<example-account-id>:bucket/I<your-destination-bucket-name>>


=head2 Encryption => L<Paws::S3Control::StorageLensDataExportEncryption>

The container for the type encryption of the metrics exports in this
bucket.


=head2 B<REQUIRED> Format => Str




=head2 B<REQUIRED> OutputSchemaVersion => Str

The schema version of the export file.


=head2 Prefix => Str

The prefix of the destination bucket where the metrics export will be
delivered.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::S3Control>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

