/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchemaBasic;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.jempbox.xmp.XMPSchemaPDF;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;

public class AddMetadataFromDocInfo {
    private AddMetadataFromDocInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            AddMetadataFromDocInfo.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load(args[0]);
                if (document.isEncrypted()) {
                    System.err.println("Error: Cannot add metadata to encrypted document.");
                    System.exit(1);
                }
                PDDocumentCatalog catalog = document.getDocumentCatalog();
                PDDocumentInformation info = document.getDocumentInformation();
                XMPMetadata metadata = new XMPMetadata();
                XMPSchemaPDF pdfSchema = metadata.addPDFSchema();
                pdfSchema.setKeywords(info.getKeywords());
                pdfSchema.setProducer(info.getProducer());
                XMPSchemaBasic basicSchema = metadata.addBasicSchema();
                basicSchema.setModifyDate(info.getModificationDate());
                basicSchema.setCreateDate(info.getCreationDate());
                basicSchema.setCreatorTool(info.getCreator());
                basicSchema.setMetadataDate((Calendar)new GregorianCalendar());
                XMPSchemaDublinCore dcSchema = metadata.addDublinCoreSchema();
                dcSchema.setTitle(info.getTitle());
                dcSchema.addCreator("PDFBox");
                dcSchema.setDescription(info.getSubject());
                PDMetadata metadataStream = new PDMetadata(document);
                metadataStream.importXMPMetadata(metadata);
                catalog.setMetadata(metadataStream);
                document.save(args[1]);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.pdfbox.examples.pdmodel.AddMetadataFromDocInfo <input-pdf> <output-pdf>");
    }
}

