/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PointOpImage;

public abstract class ColormapOpImage
extends PointOpImage {
    private boolean isInitialized = false;
    private boolean isColormapAccelerated = true;

    public ColormapOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, boolean bl) {
        super(renderedImage, imageLayout, map, bl);
        Boolean bl2;
        Boolean bl3 = bl2 = map == null ? Boolean.TRUE : (Boolean)map.get(JAI.KEY_TRANSFORM_ON_COLORMAP);
        if (bl2 != null) {
            this.isColormapAccelerated = bl2;
        }
    }

    protected final boolean isColormapOperation() {
        return this.isColormapAccelerated;
    }

    protected final void initializeColormapOperation() {
        ColorModel colorModel = this.getSource(0).getColorModel();
        ColorModel colorModel2 = super.getColorModel();
        this.isColormapAccelerated &= colorModel != null && colorModel2 != null && colorModel instanceof IndexColorModel && colorModel2 instanceof IndexColorModel;
        this.isInitialized = true;
        if (this.isColormapAccelerated) {
            byte[] byArray;
            IndexColorModel indexColorModel = (IndexColorModel)colorModel2;
            int n = indexColorModel.getMapSize();
            byte[][] byArray2 = new byte[3][n];
            indexColorModel.getReds(byArray2[0]);
            indexColorModel.getGreens(byArray2[1]);
            indexColorModel.getBlues(byArray2[2]);
            this.transformColormap(byArray2);
            int n2 = 0;
            while (n2 < 3) {
                int n3 = 255 >> 8 - indexColorModel.getComponentSize(n2);
                if (n3 < 255) {
                    byArray = byArray2[n2];
                    int n4 = 0;
                    while (n4 < n) {
                        if ((byArray[n4] & 0xFF) > n3) {
                            byArray[n4] = (byte)n3;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            byte[] byArray3 = byArray2[0];
            byArray = byArray2[1];
            byte[] byArray4 = byArray2[2];
            int[] nArray = new int[n];
            if (indexColorModel.hasAlpha()) {
                byte[] byArray5 = new byte[n];
                indexColorModel.getAlphas(byArray5);
                int n5 = 0;
                while (n5 < n) {
                    nArray[n5] = (byArray5[n5] & 0xFF) << 24 | (byArray3[n5] & 0xFF) << 16 | (byArray[n5] & 0xFF) << 8 | byArray4[n5] & 0xFF;
                    ++n5;
                }
            } else {
                int n6 = 0;
                while (n6 < n) {
                    nArray[n6] = (byArray3[n6] & 0xFF) << 16 | (byArray[n6] & 0xFF) << 8 | byArray4[n6] & 0xFF;
                    ++n6;
                }
            }
            this.colorModel = new IndexColorModel(indexColorModel.getPixelSize(), n, nArray, 0, indexColorModel.hasAlpha(), indexColorModel.getTransparentPixel(), this.sampleModel.getTransferType());
        }
    }

    protected abstract void transformColormap(byte[][] var1);
}

