/*
 * Decompiled with CFR 0.152.
 */
package opennlp.common.xml;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidityErrorHandler
implements ErrorHandler {
    private int numOfErrorsReported = 0;
    private boolean isVerbose = true;

    public void error(SAXParseException ex) {
        ++this.numOfErrorsReported;
        if (this.isVerbose) {
            System.err.println(this.getMessage("Error", ex));
        }
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        ++this.numOfErrorsReported;
        if (this.isVerbose) {
            System.err.println(this.getMessage("Fatal Error", ex));
        }
    }

    private String getMessage(String errorType, SAXParseException ex) {
        StringBuffer sb = new StringBuffer();
        sb.append(errorType);
        sb.append(" in document '");
        String name = ex.getSystemId();
        if (name == null) {
            sb.append("UNKNOWN");
        } else {
            int index = name.lastIndexOf(47);
            if (index != -1) {
                name = name.substring(index + 1);
            }
            sb.append(name);
        }
        sb.append("' at line ");
        sb.append(ex.getLineNumber());
        sb.append(", column ");
        sb.append(ex.getColumnNumber());
        sb.append(":\n\t");
        sb.append(ex.getMessage());
        return sb.toString();
    }

    public int getNumOfErrors() {
        return this.numOfErrorsReported;
    }

    public void reset() {
        this.numOfErrorsReported = 0;
    }

    public void setVerbose(boolean _isVerbose) {
        this.isVerbose = _isVerbose;
    }

    public void warning(SAXParseException ex) {
        ++this.numOfErrorsReported;
        if (this.isVerbose) {
            System.err.println(this.getMessage("Warning", ex));
        }
    }
}

