
package Paws::NetworkManager::GetDevices;
  use Moose;
  has DeviceIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', traits => ['ParamInQuery'], query_name => 'deviceIds');
  has GlobalNetworkId => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'globalNetworkId', required => 1);
  has MaxResults => (is => 'ro', isa => 'Int', traits => ['ParamInQuery'], query_name => 'maxResults');
  has NextToken => (is => 'ro', isa => 'Str', traits => ['ParamInQuery'], query_name => 'nextToken');
  has SiteId => (is => 'ro', isa => 'Str', traits => ['ParamInQuery'], query_name => 'siteId');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'GetDevices');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/global-networks/{globalNetworkId}/devices');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'GET');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::NetworkManager::GetDevicesResponse');
1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkManager::GetDevices - Arguments for method GetDevices on L<Paws::NetworkManager>

=head1 DESCRIPTION

This class represents the parameters used for calling the method GetDevices on the
L<AWS Network Manager|Paws::NetworkManager> service. Use the attributes of this class
as arguments to method GetDevices.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to GetDevices.

=head1 SYNOPSIS

    my $networkmanager = Paws->service('NetworkManager');
    my $GetDevicesResponse = $networkmanager->GetDevices(
      GlobalNetworkId => 'MyString',
      DeviceIds       => [ 'MyString', ... ],    # OPTIONAL
      MaxResults      => 1,                      # OPTIONAL
      NextToken       => 'MyString',             # OPTIONAL
      SiteId          => 'MyString',             # OPTIONAL
    );

    # Results:
    my $Devices   = $GetDevicesResponse->Devices;
    my $NextToken = $GetDevicesResponse->NextToken;

    # Returns a L<Paws::NetworkManager::GetDevicesResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/networkmanager/GetDevices>

=head1 ATTRIBUTES


=head2 DeviceIds => ArrayRef[Str|Undef]

One or more device IDs. The maximum is 10.



=head2 B<REQUIRED> GlobalNetworkId => Str

The ID of the global network.



=head2 MaxResults => Int

The maximum number of results to return.



=head2 NextToken => Str

The token for the next page of results.



=head2 SiteId => Str

The ID of the site.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method GetDevices in L<Paws::NetworkManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

