# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.5
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

package Mac::FindFile;
use base qw(Exporter);
use base qw(DynaLoader);
use File::Temp qw(tempdir);
use File::Spec;
package Mac::FindFilec;
bootstrap Mac::FindFile;
package Mac::FindFile;
@EXPORT = qw(find);

sub find {

  my $dir = "/tmp";
  my $file = "mac_findfile_output.txt";
  my $path = File::Spec->catpath($volume, $dir, $file);
  if (-f $path) {
    unlink $path;   
    }
  print "Searching for file with Mac::FindFile module\n";
  &find_file;
  print "File search complete\n";

}

=head1 NAME

Mac::FindFile - Search Mac volumes/drives using native FSCatalogSearch API.

=head1 VERSION

Version 0.01

=cut

our $VERSION = '0.01';


=head1 SYNOPSIS

This module allows you to search a Mac hard drive or volume using the native FSCatalogSearch API. This API, not related to the Mac's Spotlight system, does a fast search through the file system's indexed catalog, and can search an entire hard drive in seconds (as opposed to several minutes for a directory walk such as File::Find).

    use Mac::FindFile;

    Mac::FindFile::find("png", "/");


Because the search output can be quite large, it is written to a fixed location ("/tmp/mac_findfile_output.txt") so that it can be managed more easily. The file can be read into memory, or loaded more quickly with a module such as Tie::File. 

     use Tie::File;
     my @searchoutput;
     tie @searchoutput, 'Tie::File', '/tmp/mac_findfile_output.txt' or die; 

     foreach (@searchoutput) {
     print "this item is $_\n";
     }

     untie @searchoutput;


=head1 AUTHOR

Kevin Walzer, C<< <kw at codebykevin.com> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-mac-findfile at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Mac-FindFile>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Mac::FindFile


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Mac-FindFile>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Mac-FindFile>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Mac-FindFile>

=item * Search CPAN

L<http://search.cpan.org/dist/Mac-FindFile/>

=back


=head1 ACKNOWLEDGEMENTS

Prepared with the assistance of the Simplified Wrapper and Interface Generator, http://www.swig.org.

=head1 LICENSE AND COPYRIGHT

Copyright 2015 Kevin Walzer/WordTech Communications LLC.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.


=cut


# ---------- BASE METHODS -------------

package Mac::FindFile;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Mac::FindFile;

*find_file = *Mac::FindFilec::find_file;

# ------- VARIABLE STUBS --------

package Mac::FindFile;

1;
