package App::InteractivePerlTutorial::Chapter::Hashes::Basics;

use 5.014000;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'Basics';

1;
__DATA__

=encoding utf-8

=head1 Basics

Hashes are a data structure that allow you to link a I<key> to a I<value>. Like in an array you can access the value on position 5, with a hash you can access the value with the key "John". You declare a hash by using % and to access the value of a key you use {}.

  my %hash;
  $hash{"John"}=3;
  $hash{"Roy"}="Floyd";
  $hash{3}=5;
  say $hash{"John"};

You also assign a hash by giving him the value of a list that consists of key-value pairs. The order of the key-value pairs in the hash is not kept the same.

  my %hash1;
  $hash1{'A'}=1;
  $hash1{'B'}=3;
  $hash1{5}=6;
  my %hash2=('A',1,'B',3,5,6);
  say %hash2;   #May say, for example, 'B',3,5,6,'A',1

In this example, in hash1 is the same thing as it is in hash2. Because it can be hard to see which is a key and which is a value, you can use instead of a comma a big arrow, =>, also known as fat comma because it replaces the comma and it is fat.

  my %hash3=('A' => 1,'B' => 3,5 => 6);


=cut
