use strict;
use warnings;
use Test::More;
use Digest::BLAKE qw(blake_512 blake_512_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::BLAKE->new(512)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            blake_512_hex($data), $digest,
            "blake_512_hex: $len bits of $msg"
        );
        ok(
            blake_512($data) eq pack('H*', $digest),
            "blake_512: $len bits of $msg"
        );
    }

    my $md = Digest::BLAKE->new(512)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

done_testing;

__DATA__
00|a8cfbbd73726062df0c6864dda65defe58ef0cc52a5625090fa17601e1eecd1b628e94f396ae402a00acc9eab77b4d4c2e852aaaa25a636d80af3fc7913ef5b8
00|f0a9b5b755802205fd1a1f56e7a03d7573d46e8ba5037517281560fbe6db03c174b00597fb4e1427747c7382fe63c6692f05a5e0841e99883cb7c272c2a62191
C0|777e21c87839badde651fc37334f6d7cdc8316914e7cb76dab2efab90c62ef307e590936349b85041542f00d94d870633957699e818db79e1e064b0991a9cd1a
C0|1ffb9a5c5c4c5a0cb91d806fc1398e8a49bdac2cfb549628c886bf388f5a6c6b0854bc9c68155502016592c3f0cd54ded83276463a2aed864436950d99244958
80|32ff282bc8a43dc777ab74582fc2354f4294c6d634b25c4f2f606c72e10ae41ef7f9391f3533649ce73a0dc6b5d30497f655bb87ae45aeb03c50c96d4c5218ff
48|783a1850bc31594e382e346351cc004572288f1a12d95b6b52fc47a071033efd7ad6fc0424c93b97708da15cf0482bb0afa1b289545ae6cbbcd2970611dabb46
50|fc355cd7b2f3cec08f4fbf64f8d08394c04ea80e9a6c2920312f450183c537395a6202d2532ff35597a7c2ec719c4174f347a8cf795fd71d2933a7003ecb05d0
98|85bb7f4b9119d4495805c6f5ad9d4eb5f9ee363c34741147483abd6dfd24336bd1a5fa566578f861ffaa0ad6c617491a378477d6dd3d8025ff2b9ce6cdfd0b12
CC|4f0ef594f20172d23504873f596984c64c1583c7b2abb8d8786aa2aeeae1c46c744b61893d661b0733b76d1fe19257dd68e0ef05422ca25d058dfe6c33d68709
9800|073cf7ed8216a6b27f882563986489d1c418874f2b797a9a0c5c95394f3a9dbeb7eb3e2e6598fa5f49ad10e87f4add5f08057e5c1cd0b45004f22b63f91787ad
9D40|48ec88684d8239091d13d3d1d582a1b7cb07f6b67d9e9f1759c117f8dc447d012d6802748f1c613763a88e88a996a177ec562ba15c7da086502334f0df97d1b7
AA80|635213e9c8ffb6a535e6eaae9e9231d901e07607afaecd9122e3dfbacb0f11fb388fcb91e68e1d7f05c70f1f8a5dd6549c93f87fb4f25fa31d6c6abb4b9a55c4
9830|75d769e87d7c935faf58cd93043019bae5162e6b54d3b8b4aa2ae5fda3705e721e669dce33e8d59db6db0ad2c4ba7dc5f931ecf67a3448024b1515800b777129
5030|8903efd089efa56634fa8d4bd953abcf30d72fca70ebad0ddfccbd4cda514c5679dc763291dbb888a0bc7af7964a3be07f14c37ee696b51099bd91466429b22b
4D24|9464762c5824a83eef9445571734261e57a453e30e12e9581c4b378a7ec8219bb3f25b0d900aa8dd446f2788395e4216f539ec4d3f8d41090ae7951a43bdf2ed
CBDE|ae69b3b57792c5909a8482a4006eccceeb14d1f76b15da66018586ae132adae8641890921c13bdc2164be991b1e248d66b5e647a8e4b4eef73e33d3f06a33a5c
41FB|20afd72afbb66a5a0efd8b4a627cc2c82a5e4b6c63b0c9a78735c188d248c7588fb4ee566b3b6fdcc235a498f7263feb7ab1411582a7055e3ce7a8c976e61fcc
4FF400|802ad11445c31e09a51f1431a9b735a009f631e192c78de140a484bfba91d5c5482a5539509f1b0fca92f4e5ab6040d1efdb7fe64f107b6cf5a5c79342c10491
FD0440|0e1a3fdc9506b0fb96bd69a14149fa41484c035a4867cc8f9ae8704e7fbf5b24168089c1ae654a46d6dd2375bea3c62df92b2cba320a09a642917c7c7790f199
424D00|dd05e2ca3219efe375f2bf8edb2f45c5c490fb5e06bddbb2a813e5e232c62f15b70324db66f442be5d2a437b21df736ebbd3eba0b58591550b45ef9838703054
3FDEE0|8dc0a2797160f1eb1e4fca864f99298e655572adce432a03e5ff3a5dc814bbd81e3b328bbf8191e9041c57780f27fbecc1618b3fd140da3b96e2d0f769b441a1
335768|b501b4abc63aed8c5841e691e7f5ff5b096637e19342fa44feb53ddf84f16eb8bc92730c41f2b29131f3c6701f9b3bb6dcb5af7e8a4d900243e7b136a0d60ddb
051E7C|9d28c92c6b54f7f6888b6d210029eeafde05b7ab95e2a34d1f3979d3b62c8940c4980a1a46cfead4a630cf8e5efb521b5e412059786f626d1054e62b0f2ed916
717F8C|855c53190122aec182624cd98ec4f97b362bc74c01eef9e1d140ce79ab54e1277e8b873df52585c420b8c6d99652b47e5de322225dc1792788e71aa2912861f8
1F877C|b1211367fd8a886674f74d92716e7585f9b6e933edc5ee7f974facdccc481cfa42a0532375b94f2c0dd73d6189a815c2bafb5686d784be81fbb447b0f291272b
EB35CF80|df4050f53c05fa145dd89bf9ac94dcfd81f96f984ca484dbbbf92259f7b8ae19d2fec657853bb2673ddb0ee26f298d8c4923daaeedc2926e7daf2157c697b2ed
B406C480|f507a52fb135565c74e5905fe9a43dcbfb29b39344faec39c15ad09b0a465fef0be36183433d29243d74f119b8242bd94b0e6b37c2c1039d9d7c5af316fc46d4
CEE88040|06228dc4e1b32e816c77273e5e5b66349e82f48c6c7f3eea8876efa5db32d9fcf2e26dd3eeae7355877ca9e7b31c0924c521b5e729cf08c4175dab8a451e5ad8
C584DB70|fbbbc6cb4832c6545236f9e36fc92f7a7709e38fdf7ea6cb100048409a3c5f36e8a336360e7ab5ec26a8c13d8e663f08cac2b2519f40c61cd3284b9f320463da
53587BC8|91f4c152a8f637247a1747e2ca4df130d3be99c2dc3a9f2991df7a60900b10931fe670d10dc7725dc30e068f3220575f033e8634dd58904ca3136a04158a42ed
69A305B0|5068d281c4eef98502d0d1de51b1f78764059fb599f036fd7f60c0fd4f50b634205a196306ee78eabd3ce8eb8333a6da8bf0c7176d5230bcc6af48700fd7f343
C9375ECE|3501607fa6b01de201a10bd1db756621cd2097e3476acf862e8b723d98bc439984f8de6bc8514ed800265ef21116cf36aba1f68f9f96befb9b48eafbe19bf805
C1ECFDFC|ccbcdbc1a30ebbcc4fc015fdb1caba6c0ad6719301b4bbad4b0efab1141174a15e2e8b8b8e5671c1864a0f75ecb20f76dac45159e67786d07d79a29b1827e5a4
8D73E8A280|1f41330d6ad6f6fafa54f7c1a698a03ebd96e74025d0e5476138589e02194c133fad988e47c81a0ed887943670d41e560327761f897d996dc59cb9025b095315
06F2522080|4d9fa2dc0049230afd0d72e6195a19523d3d8b4f1983d1108157b7085ae82a0f90542351fc8d66437fc9a9bc6f98807313abdc2b4c6140b819b201df6c62b1da
3EF6C36F20|cc14844fa038671773c4201fdd7e106e951d77cef951d253e9da9f07f2bb3040a2569834d6836b30b743d39bee94a7e7721672ca30fd94b1de23bdcb1c218ff5
0127A1D340|37f909daa8a5e503b8af6f0826ba02ac14a4e92221a551cbcf4128a4c867d101d4f158232de31bc4d9ed298def8e202db9490a0da1d09cb665bdf18a14f8ff4a
6A6AB6C210|4b6c339182ec57c24832313bba724aa37b2d8833e04fc31a1a869c3da3ba106136bfda897cec7aedd28227c2b118fa417c2592a71216be6e3766b26f04b4ea4d
AF3175E160|04548a4bf2fd865da48c060262bf0f17dc084c9d4162a06f2f7aad1aed7244d7422d257e54a9eef9c24c8827e88fa707c9d0ee1ac555b46b7ee8e5ecc6fa8f1d
B66609ED86|a5b8b8de6cf9c14ced277140d219755a4af5c80e0dbd67721831b1284a501c5092a669390ecf997e406c4c1a43b25903759d0ae5ac09390f5d2ed747ae1bd361
21F134AC57|ec6eaabc2a128c38dfcddf9aaad5bb6fba397aac06a4b584b2dbdeb0cd7fdb1fd248ef93c0686b73818b2b78c923c70eba63c096f33d842ada959f7674e4730c
3DC2AADFFC80|eb9dc2c740374e28d9247393afe2d713e843c289977ea48abda51fb2950c3967aea50d48e7eba75b591140062e14495d416934f9817ec832988397c3a781dfeb
9202736D2240|0c5dfdfd3167a6ca86abf804e71342e893b0270b3ef2d4c81032482538c0f5802817a16d6ec12f541ce947d5579c27b9b7a5ee424554f3fa2c78a2fa8340d444
F219BD629820|40f191621e6a183a0bd3f10df6716ddf09339fba20b48dbbb09fb44b82f15be77ad595bfdd1f1245b930334ea7042e716626d5fb49bc275df0b60639d9aea618
F3511EE2C4B0|e76cefbc4621956af8d7d5121bd10bdddaeff359ff2b988425f22bba15c8ad4dbbf70f7e8b5cf2ee044eb9625bf36ec9f910e01701bbc8541d8529a13a56cc98
3ECAB6BF7720|39b3d2f730b774e16504fd6e5b2eafca5f68c9d5022e62d3bca67793d3260f34d1dd594b95ef5a735aa9b78ff0b6028b484c34a4bcd9adb4ec5a9736ecd434eb
CD62F688F498|69b151653d645e84c6eb509665a89a075210f743f8c7218e6c98895c9436e9eedfa2094597b13533e1c3af6b21907ddf2f4c5c8379e64a71b66add2a170d5689
C2CBAA33A9F8|eac8acd05f04461d8050b53dafa99b0516adfacc8dbd3adc7dacfc7adea4ad9250fa9e10ad43602e15a762a333a2cdb1c040ede1de79ac51b484507b5ae16536
C6F50BB74E29|b6e8a7380df1f007d7c271e7255bbca7714f25029ac1fd6fe92ef74cbcd9e99c112f8ae1a45ccb566ce19d9678a122c612beff5f8eeeee3f3f402fd2781182d4
79F1B4CCC62A00|1cc9fe09100fbc45f20382353785aa753fbd19ea0ab655c0d8338e0d07154ccaa5659698a6627302c25dd54cdfde00c0ef06905abc55030563399ca8efae2c22
