# Generated by default/object.tt
package Paws::DMS::KafkaSettings;
  use Moose;
  has Broker => (is => 'ro', isa => 'Str');
  has IncludeControlDetails => (is => 'ro', isa => 'Bool');
  has IncludeNullAndEmpty => (is => 'ro', isa => 'Bool');
  has IncludePartitionValue => (is => 'ro', isa => 'Bool');
  has IncludeTableAlterOperations => (is => 'ro', isa => 'Bool');
  has IncludeTransactionDetails => (is => 'ro', isa => 'Bool');
  has MessageFormat => (is => 'ro', isa => 'Str');
  has MessageMaxBytes => (is => 'ro', isa => 'Int');
  has PartitionIncludeSchemaTable => (is => 'ro', isa => 'Bool');
  has SaslPassword => (is => 'ro', isa => 'Str');
  has SaslUsername => (is => 'ro', isa => 'Str');
  has SecurityProtocol => (is => 'ro', isa => 'Str');
  has SslCaCertificateArn => (is => 'ro', isa => 'Str');
  has SslClientCertificateArn => (is => 'ro', isa => 'Str');
  has SslClientKeyArn => (is => 'ro', isa => 'Str');
  has SslClientKeyPassword => (is => 'ro', isa => 'Str');
  has Topic => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DMS::KafkaSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DMS::KafkaSettings object:

  $service_obj->Method(Att1 => { Broker => $value, ..., Topic => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DMS::KafkaSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->Broker

=head1 DESCRIPTION

Provides information that describes an Apache Kafka endpoint. This
information includes the output format of records applied to the
endpoint and details of transaction and control table data information.

=head1 ATTRIBUTES


=head2 Broker => Str

A comma-separated list of one or more broker locations in your Kafka
cluster that host your Kafka instance. Specify each broker location in
the form C< I<broker-hostname-or-ip>:I<port> >. For example,
C<"ec2-12-345-678-901.compute-1.amazonaws.com:2345">. For more
information and examples of specifying a list of broker locations, see
Using Apache Kafka as a target for AWS Database Migration Service
(https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html)
in the I<AWS Data Migration Service User Guide>.


=head2 IncludeControlDetails => Bool

Shows detailed control information for table definition, column
definition, and table and column changes in the Kafka message output.
The default is C<false>.


=head2 IncludeNullAndEmpty => Bool

Include NULL and empty columns for records migrated to the endpoint.
The default is C<false>.


=head2 IncludePartitionValue => Bool

Shows the partition value within the Kafka message output, unless the
partition type is C<schema-table-type>. The default is C<false>.


=head2 IncludeTableAlterOperations => Bool

Includes any data definition language (DDL) operations that change the
table in the control data, such as C<rename-table>, C<drop-table>,
C<add-column>, C<drop-column>, and C<rename-column>. The default is
C<false>.


=head2 IncludeTransactionDetails => Bool

Provides detailed transaction information from the source database.
This information includes a commit timestamp, a log position, and
values for C<transaction_id>, previous C<transaction_id>, and
C<transaction_record_id> (the record offset within a transaction). The
default is C<false>.


=head2 MessageFormat => Str

The output format for the records created on the endpoint. The message
format is C<JSON> (default) or C<JSON_UNFORMATTED> (a single line with
no tab).


=head2 MessageMaxBytes => Int

The maximum size in bytes for records created on the endpoint The
default is 1,000,000.


=head2 PartitionIncludeSchemaTable => Bool

Prefixes schema and table names to partition values, when the partition
type is C<primary-key-type>. Doing this increases data distribution
among Kafka partitions. For example, suppose that a SysBench schema has
thousands of tables and each table has only limited range for a primary
key. In this case, the same primary key is sent from thousands of
tables to the same partition, which causes throttling. The default is
C<false>.


=head2 SaslPassword => Str

The secure password you created when you first set up your MSK cluster
to validate a client identity and make an encrypted connection between
server and client using SASL-SSL authentication.


=head2 SaslUsername => Str

The secure username you created when you first set up your MSK cluster
to validate a client identity and make an encrypted connection between
server and client using SASL-SSL authentication.


=head2 SecurityProtocol => Str

Set secure connection to a Kafka target endpoint using Transport Layer
Security (TLS). Options include C<ssl-encryption>,
C<ssl-authentication>, and C<sasl-ssl>. C<sasl-ssl> requires
C<SaslUsername> and C<SaslPassword>.


=head2 SslCaCertificateArn => Str

The Amazon Resource Name (ARN) for the private Certification Authority
(CA) cert that AWS DMS uses to securely connect to your Kafka target
endpoint.


=head2 SslClientCertificateArn => Str

The Amazon Resource Name (ARN) of the client certificate used to
securely connect to a Kafka target endpoint.


=head2 SslClientKeyArn => Str

The Amazon Resource Name (ARN) for the client private key used to
securely connect to a Kafka target endpoint.


=head2 SslClientKeyPassword => Str

The password for the client private key used to securely connect to a
Kafka target endpoint.


=head2 Topic => Str

The topic to which you migrate the data. If you don't specify a topic,
AWS DMS specifies C<"kafka-default-topic"> as the migration topic.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

