# Generated by default/object.tt
package Paws::GlueDataBrew::FilterExpression;
  use Moose;
  has Expression => (is => 'ro', isa => 'Str', required => 1);
  has ValuesMap => (is => 'ro', isa => 'Paws::GlueDataBrew::ValuesMap', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::FilterExpression

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::FilterExpression object:

  $service_obj->Method(Att1 => { Expression => $value, ..., ValuesMap => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::FilterExpression object:

  $result = $service_obj->Method(...);
  $result->Att1->Expression

=head1 DESCRIPTION

Represents a structure for defining parameter conditions. Supported
conditions are described here: Supported conditions for dynamic
datasets
(https://docs-aws.amazon.com/databrew/latest/dg/datasets.multiple-files.html#conditions.for.dynamic.datasets)
in the I<Glue DataBrew Developer Guide>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Expression => Str

The expression which includes condition names followed by substitution
variables, possibly grouped and combined with other conditions. For
example, "(starts_with :prefix1 or starts_with :prefix2) and (ends_with
:suffix1 or ends_with :suffix2)". Substitution variables should start
with ':' symbol.


=head2 B<REQUIRED> ValuesMap => L<Paws::GlueDataBrew::ValuesMap>

The map of substitution variable names to their values used in this
filter expression.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

