# Generated by default/object.tt
package Paws::MediaConnect::InputConfiguration;
  use Moose;
  has InputIp => (is => 'ro', isa => 'Str', request_name => 'inputIp', traits => ['NameInRequest'], required => 1);
  has InputPort => (is => 'ro', isa => 'Int', request_name => 'inputPort', traits => ['NameInRequest'], required => 1);
  has Interface => (is => 'ro', isa => 'Paws::MediaConnect::Interface', request_name => 'interface', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConnect::InputConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConnect::InputConfiguration object:

  $service_obj->Method(Att1 => { InputIp => $value, ..., Interface => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConnect::InputConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->InputIp

=head1 DESCRIPTION

The transport parameters that are associated with an incoming media
stream.

=head1 ATTRIBUTES


=head2 B<REQUIRED> InputIp => Str

The IP address that the flow listens on for incoming content for a
media stream.


=head2 B<REQUIRED> InputPort => Int

The port that the flow listens on for an incoming media stream.


=head2 B<REQUIRED> Interface => L<Paws::MediaConnect::Interface>

The VPC interface where the media stream comes in from.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConnect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

