# Generated by default/object.tt
package Paws::SSMIncidents::ItemIdentifier;
  use Moose;
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest'], required => 1);
  has Value => (is => 'ro', isa => 'Paws::SSMIncidents::ItemValue', request_name => 'value', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMIncidents::ItemIdentifier

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMIncidents::ItemIdentifier object:

  $service_obj->Method(Att1 => { Type => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMIncidents::ItemIdentifier object:

  $result = $service_obj->Method(...);
  $result->Att1->Type

=head1 DESCRIPTION

Details and type of a related item.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Type => Str

The type of related item. Incident Manager supports the following
types:

=over

=item *

C<ANALYSIS>

=item *

C<INCIDENT>

=item *

C<METRIC>

=item *

C<PARENT>

=item *

C<ATTACHMENT>

=item *

C<OTHER>

=back



=head2 B<REQUIRED> Value => L<Paws::SSMIncidents::ItemValue>

Details about the related item.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMIncidents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

