# Generated by default/object.tt
package Paws::RDS::TargetHealth;
  use Moose;
  has Description => (is => 'ro', isa => 'Str');
  has Reason => (is => 'ro', isa => 'Str');
  has State => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::RDS::TargetHealth

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::RDS::TargetHealth object:

  $service_obj->Method(Att1 => { Description => $value, ..., State => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::RDS::TargetHealth object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

Information about the connection health of an RDS Proxy target.

=head1 ATTRIBUTES


=head2 Description => Str

A description of the health of the RDS Proxy target. If the C<State> is
C<AVAILABLE>, a description is not included.


=head2 Reason => Str

The reason for the current health C<State> of the RDS Proxy target.


=head2 State => Str

The current state of the connection health lifecycle for the RDS Proxy
target. The following is a typical lifecycle example for the states of
an RDS Proxy target:

C<registering> E<gt> C<unavailable> E<gt> C<available> E<gt>
C<unavailable> E<gt> C<available>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::RDS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

