package WebService::Mattermost::V4::API::Object::TeamMember;

# ABSTRACT: A team member item.

use Moo;

extends 'WebService::Mattermost::V4::API::Object';
with    qw(
    WebService::Mattermost::V4::API::Object::Role::BelongingToUser
    WebService::Mattermost::V4::API::Object::Role::BelongingToTeam
    WebService::Mattermost::V4::API::Object::Role::Roles
);

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Object::TeamMember - A team member item.

=head1 VERSION

version 0.30

=head1 DESCRIPTION

Details a Mattermost TeamMember object.

=head1 SEE ALSO

=over 4

=item L<WebService::Mattermost::V4::API::Object::Role::BelongingToUser>

=item L<WebService::Mattermost::V4::API::Object::Role::BelongingToTeam>

=item L<WebService::Mattermost::V4::API::Object::Role::Roles>

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2023 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
