package Net::Twitter::Lite::API::V1_1;
{
  $Net::Twitter::Lite::API::V1_1::VERSION = '0.12001';
}
use warnings;
use strict;

=head1 NAME

Net::Twitter::Lite::API::V1_1 - Twitter API v1.1 method definitions

=head1 VERSION

version 0.12001

=cut

sub api_def () { +[
    [ REST => [
# Timelines
        [ 'mentions', {
            aliases         => [ qw/replies/ ],
            path            => 'statuses/mentions_timeline',
            method          => 'GET',
            params          => [ qw/count since_id max_id trim_user contributor_details include_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/trim_user contributor_details include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'user_timeline', {
            aliases         => [ qw// ],
            path            => 'statuses/user_timeline',
            method          => 'GET',
            params          => [ qw/user_id screen_name since_id count max_id trim_user exclude_replies contributor_details include_rts/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/trim_user exclude_replies contributor_details include_rts/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'home_timeline', {
            aliases         => [ qw// ],
            path            => 'statuses/home_timeline',
            method          => 'GET',
            params          => [ qw/count since_id max_id trim_user exclude_replies contributor_details include_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/trim_user exclude_replies contributor_details include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'retweets_of_me', {
            aliases         => [ qw/retweeted_of_me/ ],
            path            => 'statuses/retweets_of_me',
            method          => 'GET',
            params          => [ qw/count since_id max_id trim_user include_entities include_user_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/trim_user include_entities include_user_entities/ ],
            base_url_method => 'apiurl',
        } ],

# Tweets
        [ 'retweets', {
            aliases         => [ qw// ],
            path            => 'statuses/retweets/:id',
            method          => 'GET',
            params          => [ qw/id count trim_user/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/trim_user/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'show_status', {
            aliases         => [ qw// ],
            path            => 'statuses/show/:id',
            method          => 'GET',
            params          => [ qw/id trim_user include_my_retweet include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/trim_user include_my_retweet include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'destroy_status', {
            aliases         => [ qw// ],
            path            => 'statuses/destroy/:id',
            method          => 'POST',
            params          => [ qw/id trim_user/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/trim_user/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'update', {
            aliases         => [ qw// ],
            path            => 'statuses/update',
            method          => 'POST',
            params          => [ qw/status in_reply_to_status_id lat long place_id display_coordinates trim_user/ ],
            required        => [ qw/status/ ],
            add_source      => 1,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/display_coordinates trim_user/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'retweet', {
            aliases         => [ qw// ],
            path            => 'statuses/retweet/:id',
            method          => 'POST',
            params          => [ qw/id trim_user/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/trim_user/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_with_media', {
            aliases         => [ qw// ],
            path            => 'statuses/update_with_media',
            method          => 'POST',
            params          => [ qw/status media[] possibly_sensitive in_reply_to_status_id lat long place_id display_coordinates/ ],
            required        => [ qw/status media/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/possibly_sensitive display_coordinates/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'get_oembed', {
            aliases         => [ qw// ],
            path            => 'statuses/oembed',
            method          => 'GET',
            params          => [ qw/id url maxwidth hide_media hide_thread omit_script align related lang/ ],
            required        => [ qw/id url/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/hide_media hide_thread omit_script/ ],
            base_url_method => 'apiurl',
        } ],
# Search
        [ 'search', {
            aliases         => [ qw// ],
            path            => 'search/tweets',
            method          => 'GET',
            params          => [ qw/q geocode lang locale result_type count until since_id max_id include_entities callback/ ],
            required        => [ qw/q/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],

# Direct Messages
        [ 'direct_messages', {
            aliases         => [ qw// ],
            path            => 'direct_messages',
            method          => 'GET',
            params          => [ qw/since_id max_id count include_entities skip_status/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'sent_direct_messages', {
            aliases         => [ qw// ],
            path            => 'direct_messages/sent',
            method          => 'GET',
            params          => [ qw/since_id max_id count page include_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'show_direct_message', {
            aliases         => [ qw// ],
            path            => 'direct_messages/show',
            method          => 'GET',
            params          => [ qw/id/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'destroy_direct_message', {
            aliases         => [ qw// ],
            path            => 'direct_messages/destroy',
            method          => 'POST',
            params          => [ qw/id include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'new_direct_message', {
            aliases         => [ qw// ],
            path            => 'direct_messages/new',
            method          => 'POST',
            params          => [ qw/user_id screen_name text/ ],
            required        => [ qw/text/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],

# Friends & Followers
        [ 'no_retweet_ids', {
            aliases         => [ qw// ],
            path            => 'friendships/no_retweets/ids',
            method          => 'GET',
            params          => [ qw/stringify_ids/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/stringify_ids/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'friends_ids', {
            aliases         => [ qw/following_ids/ ],
            path            => 'friends/ids',
            method          => 'GET',
            params          => [ qw/user_id screen_name cursor stringify_ids count/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/stringify_ids/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'followers_ids', {
            aliases         => [ qw// ],
            path            => 'followers/ids',
            method          => 'GET',
            params          => [ qw/user_id screen_name cursor stringify_ids count/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/stringify_ids/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'lookup_friendships', {
            aliases         => [ qw// ],
            path            => 'friendships/lookup',
            method          => 'GET',
            params          => [ qw/screen_name user_id/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'friendships_incoming', {
            aliases         => [ qw// ],
            path            => 'friendships/incoming',
            method          => 'GET',
            params          => [ qw/cursor stringify_ids/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/stringify_ids/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'friendships_outgoing', {
            aliases         => [ qw// ],
            path            => 'friendships/outgoing',
            method          => 'GET',
            params          => [ qw/cursor stringify_ids/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/stringify_ids/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'create_friend', {
            aliases         => [ qw/follow_new/ ],
            path            => 'friendships/create',
            method          => 'POST',
            params          => [ qw/screen_name user_id follow/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/follow/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'destroy_friend', {
            aliases         => [ qw/unfollow/ ],
            path            => 'friendships/destroy',
            method          => 'POST',
            params          => [ qw/screen_name user_id/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_friendship', {
            aliases         => [ qw// ],
            path            => 'friendships/update',
            method          => 'POST',
            params          => [ qw/screen_name user_id device retweets/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/device retweets/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'show_friendship', {
            aliases         => [ qw/show_relationship/ ],
            path            => 'friendships/show',
            method          => 'GET',
            params          => [ qw/source_id source_screen_name target_id target_screen_name/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'friends', {
            aliases         => [ qw/friends_list/ ],
            path            => 'friends/list',
            method          => 'GET',
            params          => [ qw/user_id screen_name cursor skip_status include_user_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/skip_status include_user_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'followers', {
            aliases         => [ qw/followers_list/ ],
            path            => 'followers/list',
            method          => 'GET',
            params          => [ qw/user_id screen_name cursor skip_status include_user_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/skip_status include_user_entities/ ],
            base_url_method => 'apiurl',
        } ],

# Users
        [ 'account_settings', {
            aliases         => [ qw// ],
            path            => 'account/settings',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'verify_credentials', {
            aliases         => [ qw// ],
            path            => 'account/verify_credentials',
            method          => 'GET',
            params          => [ qw/include_entities skip_status/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities skip_status/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_account_settings', {
            aliases         => [ qw// ],
            path            => 'account/settings',
            method          => 'POST',
            params          => [ qw/trend_location_woeid sleep_time_enabled start_sleep_time end_sleep_time time_zone lang/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/sleep_time_enabled/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_delivery_device', {
            aliases         => [ qw// ],
            path            => 'account/update_delivery_device',
            method          => 'POST',
            params          => [ qw/device include_entities/ ],
            required        => [ qw/device/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_profile', {
            aliases         => [ qw// ],
            path            => 'account/update_profile',
            method          => 'POST',
            params          => [ qw/name url location description include_entities skip_status/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_profile_background_image', {
            aliases         => [ qw// ],
            path            => 'account/update_profile_background_image',
            method          => 'POST',
            params          => [ qw/image tile include_entities skip_status use/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_profile_colors', {
            aliases         => [ qw// ],
            path            => 'account/update_profile_colors',
            method          => 'POST',
            params          => [ qw/profile_background_color profile_link_color profile_sidebar_border_color profile_sidebar_fill_color profile_text_color include_entities skip_status/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_profile_image', {
            aliases         => [ qw// ],
            path            => 'account/update_profile_image',
            method          => 'POST',
            params          => [ qw/image include_entities skip_status/ ],
            required        => [ qw/image/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'blocking', {
            aliases         => [ qw// ],
            path            => 'blocks/list',
            method          => 'GET',
            params          => [ qw/include_entities skip_status cursor/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'blocking_ids', {
            aliases         => [ qw// ],
            path            => 'blocks/ids',
            method          => 'GET',
            params          => [ qw/stringify_ids cursor/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/stringify_ids/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'create_block', {
            aliases         => [ qw// ],
            path            => 'blocks/create',
            method          => 'POST',
            params          => [ qw/screen_name user_id include_entities skip_status/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'destroy_block', {
            aliases         => [ qw// ],
            path            => 'blocks/destroy',
            method          => 'POST',
            params          => [ qw/screen_name user_id include_entities skip_status/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'lookup_users', {
            aliases         => [ qw// ],
            path            => 'users/lookup',
            method          => 'GET',
            params          => [ qw/screen_name user_id include_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'show_user', {
            aliases         => [ qw// ],
            path            => 'users/show',
            method          => 'GET',
            params          => [ qw/user_id screen_name include_entities/ ],
            required        => [ qw/user_id screen_name/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'users_search', {
            aliases         => [ qw/find_people search_users/ ],
            path            => 'users/search',
            method          => 'GET',
            params          => [ qw/q page count include_entities/ ],
            required        => [ qw/q/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'contributees', {
            aliases         => [ qw// ],
            path            => 'users/contributees',
            method          => 'GET',
            params          => [ qw/user_id screen_name include_entities skip_status/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'contributors', {
            aliases         => [ qw// ],
            path            => 'users/contributors',
            method          => 'GET',
            params          => [ qw/user_id screen_name include_entities skip_status/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'remove_profile_banner', {
            aliases         => [ qw// ],
            path            => 'account/remove_profile_banner',
            method          => 'POST',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_profile_banner', {
            aliases         => [ qw// ],
            path            => 'account/update_profile_banner',
            method          => 'POST',
            params          => [ qw/banner width height offset_left offset_top/ ],
            required        => [ qw/banner/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'users_profile_banner', {
            aliases         => [ qw// ],
            path            => 'users/profile_banner',
            method          => 'GET',
            params          => [ qw/user_id screen_name/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],

# Suggested Users
        [ 'user_suggestions', {
            aliases         => [ qw/follow_suggestions/ ],
            path            => 'users/suggestions/:slug',
            method          => 'GET',
            params          => [ qw/slug lang/ ],
            required        => [ qw/slug/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'suggestion_categories', {
            aliases         => [ qw// ],
            path            => 'users/suggestions',
            method          => 'GET',
            params          => [ qw/lang/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'user_suggestions_statuses', {
            aliases         => [ qw// ],
            path            => 'users/suggestions/:slug/members',
            method          => 'GET',
            params          => [ qw/slug/ ],
            required        => [ qw/slug/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],

# Favorites
        [ 'favorites', {
            aliases         => [ qw// ],
            path            => 'favorites/list',
            method          => 'GET',
            params          => [ qw/user_id screen_name count since_id max_id include_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'destroy_favorite', {
            aliases         => [ qw// ],
            path            => 'favorites/destroy',
            method          => 'POST',
            params          => [ qw/id include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'create_favorite', {
            aliases         => [ qw// ],
            path            => 'favorites/create',
            method          => 'POST',
            params          => [ qw/id include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],

# Lists
        [ 'all_subscriptions', {
            aliases         => [ qw/all_lists list_subscriptions/ ],
            path            => 'lists/list',
            method          => 'GET',
            params          => [ qw/user_id screen_name/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'list_statuses', {
            aliases         => [ qw// ],
            path            => 'lists/statuses',
            method          => 'GET',
            params          => [ qw/list_id slug owner_screen_name owner_id since_id max_id count include_entities include_rts/ ],
            required        => [ qw/list_id slug/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'delete_list_member', {
            aliases         => [ qw/remove_list_member/ ],
            path            => 'lists/members/destroy',
            method          => 'POST',
            params          => [ qw/list_id slug user_id screen_name owner_screen_name owner_id/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'list_memberships', {
            aliases         => [ qw/listed_ids/ ],
            path            => 'lists/memberships',
            method          => 'GET',
            params          => [ qw/user_id screen_name cursor filter_to_owned_lists/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'list_subscribers', {
            aliases         => [ qw// ],
            path            => 'lists/subscribers',
            method          => 'GET',
            params          => [ qw/list_id slug owner_screen_name owner_id cursor include_entities skip_status/ ],
            required        => [ qw/list_id slug/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'subscribe_list', {
            aliases         => [ qw// ],
            path            => 'lists/subscribers/create',
            method          => 'POST',
            params          => [ qw/owner_screen_name owner_id list_id slug/ ],
            required        => [ qw/list_id slug/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'is_list_subscriber', {
            aliases         => [ qw/is_subscribed_list/ ],
            path            => 'lists/subscribers/show',
            method          => 'GET',
            params          => [ qw/owner_screen_name owner_id list_id slug user_id screen_name include_entities skip_status/ ],
            required        => [ qw/list_id slug user_id screen_name/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'unsubscribe_list', {
            aliases         => [ qw// ],
            path            => 'lists/subscribers/destroy',
            method          => 'POST',
            params          => [ qw/list_id slug owner_screen_name owner_id/ ],
            required        => [ qw/list_id slug/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'members_create_all', {
            aliases         => [ qw/add_list_members/ ],
            path            => 'lists/members/create_all',
            method          => 'POST',
            params          => [ qw/list_id slug user_id screen_name owner_screen_name owner_id/ ],
            required        => [ qw/list_id slug/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'is_list_member', {
            aliases         => [ qw// ],
            path            => 'lists/members/show',
            method          => 'GET',
            params          => [ qw/list_id slug user_id screen_name owner_screen_name owner_id include_entities skip_status/ ],
            required        => [ qw/list_id slug user_id screen_name/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'list_members', {
            aliases         => [ qw// ],
            path            => 'lists/members',
            method          => 'GET',
            params          => [ qw/list_id slug owner_screen_name owner_id cursor include_entities skip_status/ ],
            required        => [ qw/list_id slug/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'add_list_member', {
            aliases         => [ qw// ],
            path            => 'lists/members/create',
            method          => 'POST',
            params          => [ qw/list_id slug user_id screen_name owner_screen_name owner_id/ ],
            required        => [ qw/list_id slug user_id screen_name/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'delete_list', {
            aliases         => [ qw// ],
            path            => 'lists/destroy',
            method          => 'POST',
            params          => [ qw/owner_screen_name owner_id list_id slug/ ],
            required        => [ qw/list_id slug/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_list', {
            aliases         => [ qw// ],
            path            => 'lists/update',
            method          => 'POST',
            params          => [ qw/list_id slug name mode description owner_screen_name owner_id/ ],
            required        => [ qw/list_id slug/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'create_list', {
            aliases         => [ qw// ],
            path            => 'lists/create',
            method          => 'POST',
            params          => [ qw/name mode description/ ],
            required        => [ qw/name/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'get_list', {
            aliases         => [ qw// ],
            path            => 'lists/show',
            method          => 'GET',
            params          => [ qw/list_id slug owner_screen_name owner_id/ ],
            required        => [ qw/list_id slug/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'subscriptions', {
            aliases         => [ qw// ],
            path            => 'lists/subscriptions',
            method          => 'GET',
            params          => [ qw/user_id screen_name count cursor/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'members_destroy_all', {
            aliases         => [ qw/remove_list_members/ ],
            path            => 'lists/members/destroy_all',
            method          => 'POST',
            params          => [ qw/list_id slug user_id screen_name owner_screen_name owner_id/ ],
            required        => [ qw/list_id slug/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],

# Saved Searches
        [ 'saved_searches', {
            aliases         => [ qw// ],
            path            => 'saved_searches/list',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'show_saved_search', {
            aliases         => [ qw// ],
            path            => 'saved_searches/show/:id',
            method          => 'GET',
            params          => [ qw/id/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'create_saved_search', {
            aliases         => [ qw// ],
            path            => 'saved_searches/create',
            method          => 'POST',
            params          => [ qw/query/ ],
            required        => [ qw/query/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'destroy_saved_search', {
            aliases         => [ qw// ],
            path            => 'saved_searches/destroy/:id',
            method          => 'POST',
            params          => [ qw/id/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],

# Places & Geo
        [ 'geo_id', {
            aliases         => [ qw// ],
            path            => 'geo/id/:place_id',
            method          => 'GET',
            params          => [ qw/place_id/ ],
            required        => [ qw/place_id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'reverse_geocode', {
            aliases         => [ qw// ],
            path            => 'geo/reverse_geocode',
            method          => 'GET',
            params          => [ qw/lat long accuracy granularity max_results callback/ ],
            required        => [ qw/lat long/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'geo_search', {
            aliases         => [ qw// ],
            path            => 'geo/search',
            method          => 'GET',
            params          => [ qw/lat long query ip granularity accuracy max_results contained_within attribute:street_address callback/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'similar_places', {
            aliases         => [ qw// ],
            path            => 'geo/similar_places',
            method          => 'GET',
            params          => [ qw/lat long name contained_within attribute:street_address callback/ ],
            required        => [ qw/lat long name/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'add_place', {
            aliases         => [ qw// ],
            path            => 'geo/place',
            method          => 'POST',
            params          => [ qw/name contained_within token lat long attribute:street_address callback/ ],
            required        => [ qw/name contained_within token lat long/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],

# Trends
        [ 'trends', {
            path            => 'trends/place',
            method          => 'GET',
            params          => [ qw/id exclude/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'trends_available', {
            aliases         => [ qw// ],
            path            => 'trends/available',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'trends_closest', {
            aliases         => [ qw// ],
            path            => 'trends/closest',
            method          => 'GET',
            params          => [ qw/lat long/ ],
            required        => [ qw/lat long/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],

# Spam Reporting
        [ 'report_spam', {
            aliases         => [ qw// ],
            path            => 'users/report_spam',
            method          => 'POST',
            params          => [ qw/screen_name user_id/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],

# Help
        [ 'get_configuration', {
            aliases         => [ qw// ],
            path            => 'help/configuration',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'get_languages', {
            aliases         => [ qw// ],
            path            => 'help/languages',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'get_privacy', {
            aliases         => [ qw// ],
            path            => 'help/privacy',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'get_tos', {
            aliases         => [ qw// ],
            path            => 'help/tos',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'rate_limit_status', {
            aliases         => [ qw// ],
            path            => 'application/rate_limit_status',
            method          => 'GET',
            params          => [ qw/resources/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
    ] ],
]}

1;

__END__

=for Pod::Coverage api_def

=cut
