#!/usr/bin/perl

use strict;
use warnings;
use utf8;

use FindBin;
require "$FindBin::Bin/../../util.pl";

my $test = Net::DRI::Test->new_epp(['CNNIC::Bundling']);
my $dri = $test->dri();

use Test::More tests => 13;

####################################################################################################

my $rc;


$test->set_response('<resData><domain:infData xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"><domain:name>xn--fsq270a.example</domain:name><domain:roid>58812678-domain</domain:roid><domain:status s="ok"/><domain:registrant>123</domain:registrant><domain:contact type="admin">123</domain:contact><domain:contact type="tech">123</domain:contact><domain:ns><domain:hostObj>ns1.example.cn</domain:hostObj></domain:ns><domain:clID>ClientX</domain:clID><domain:crID>ClientY</domain:crID><domain:crDate>2011-04-03T22:00:00.0Z</domain:crDate><domain:exDate>2012-04-03T22:00:00.0Z</domain:exDate><domain:authInfo><domain:pw>2fooBAR</domain:pw></domain:authInfo></domain:infData></resData><extension><b-dn:infData xmlns:b-dn="urn:ietf:params:xml:ns:epp:b-dn"><b-dn:bundle><b-dn:rdn uLabel="实例.example">xn--fsq270a.example</b-dn:rdn><b-dn:bdn uLabel="實例.example">xn--fsqz41a.example</b-dn:bdn></b-dn:bundle></b-dn:infData></extension>');

$rc=$dri->domain_info('xn--fsq270a.example');
is_deeply($rc->get_data('domain','xn--fsq270a.example','rdn'),{alabel => 'xn--fsq270a.example', ulabel => '实例.example'},'domain_info reply rdn');
is_deeply($rc->get_data('domain','xn--fsq270a.example','bdn'),{alabel => 'xn--fsqz41a.example', ulabel => '實例.example'},'domain_info reply bdn');



$test->set_response('<resData><domain:creData xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"><domain:name>xn--fsq270a.example</domain:name><domain:crDate>1999-04-03T22:00:00.0Z</domain:crDate><domain:exDate>2001-04-03T22:00:00.0Z</domain:exDate></domain:creData></resData><extension><b-dn:creData xmlns:b-dn="urn:ietf:params:xml:ns:epp:b-dn"><b-dn:bundle><b-dn:rdn uLabel="实例.example">xn--fsq270a.example</b-dn:rdn><b-dn:bdn uLabel="實例.example">xn--fsqz41a.example</b-dn:bdn></b-dn:bundle></b-dn:creData></extension>');
my $cs=$dri->local_object('contactset');
my $c1=$dri->local_object('contact')->srid('123');
$cs->set($c1,'registrant');
$cs->set($c1,'admin');
$cs->set($c1,'tech');
$rc=$dri->domain_create('xn--fsq270a.example',{pure_create=>1,duration=>DateTime::Duration->new(years=>2),contact=>$cs,auth=>{pw=>'2fooBAR'},ulabel=>'实例.example'});
is_string($test->get_command(),'<command><create><domain:create xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"><domain:name>xn--fsq270a.example</domain:name><domain:period unit="y">2</domain:period><domain:registrant>123</domain:registrant><domain:contact type="admin">123</domain:contact><domain:contact type="tech">123</domain:contact><domain:authInfo><domain:pw>2fooBAR</domain:pw></domain:authInfo></domain:create></create><extension><b-dn:create xmlns:b-dn="urn:ietf:params:xml:ns:epp:b-dn"><b-dn:rdn uLabel="实例.example">xn--fsq270a.example</b-dn:rdn></b-dn:create></extension><clTRID>ABC-12345</clTRID></command>','domain_create build');
is_deeply($rc->get_data('domain','xn--fsq270a.example','rdn'),{alabel => 'xn--fsq270a.example', ulabel => '实例.example'},'domain_create reply rdn');
is_deeply($rc->get_data('domain','xn--fsq270a.example','bdn'),{alabel => 'xn--fsqz41a.example', ulabel => '實例.example'},'domain_create reply bdn');



$test->set_response('<extension><b-dn:delData xmlns:b-dn="urn:ietf:params:xml:ns:epp:b-dn"><b-dn:bundle><b-dn:rdn uLabel="实例.example">xn--fsq270a.example</b-dn:rdn><b-dn:bdn uLabel="實例.example">xn--fsqz41a.example</b-dn:bdn></b-dn:bundle></b-dn:delData></extension>');
$rc=$dri->domain_delete('xn--fsq270a.example');
is_deeply($rc->get_data('domain','xn--fsq270a.example','rdn'),{alabel => 'xn--fsq270a.example', ulabel => '实例.example'},'domain_delete reply rdn');
is_deeply($rc->get_data('domain','xn--fsq270a.example','bdn'),{alabel => 'xn--fsqz41a.example', ulabel => '實例.example'},'domain_delete reply bdn');



$test->set_response('<resData><domain:renData xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"><domain:name>xn--fsq270a.example</domain:name><domain:exDate>2012-04-03T22:00:00.0Z</domain:exDate></domain:renData></resData><extension><b-dn:renData xmlns:b-dn="urn:ietf:params:xml:ns:epp:b-dn"><b-dn:bundle><b-dn:rdn uLabel="实例.example">xn--fsq270a.example</b-dn:rdn><b-dn:bdn uLabel="實例.example">xn--fsqz41a.example</b-dn:bdn></b-dn:bundle></b-dn:renData></extension>');
$rc=$dri->domain_renew('xn--fsq270a.example', {current_expiration=>$dri->local_object('datetime', year => 1970, month => 1, day => 1)});
is_deeply($rc->get_data('domain','xn--fsq270a.example','rdn'),{alabel => 'xn--fsq270a.example', ulabel => '实例.example'},'domain_renew reply rdn');
is_deeply($rc->get_data('domain','xn--fsq270a.example','bdn'),{alabel => 'xn--fsqz41a.example', ulabel => '實例.example'},'domain_renew reply bdn');



$test->set_response('<resData><domain:trnData xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"><domain:name>xn--fsq270a.example</domain:name><domain:trStatus>pending</domain:trStatus><domain:reID>ClientX</domain:reID><domain:reDate>2011-04-03T22:00:00.0Z</domain:reDate><domain:acID>ClientY</domain:acID><domain:acDate>2011-04-08T22:00:00.0Z</domain:acDate><domain:exDate>2012-04-03T22:00:00.0Z</domain:exDate></domain:trnData></resData><extension><b-dn:trnData xmlns:b-dn="urn:ietf:params:xml:ns:epp:b-dn"><b-dn:bundle><b-dn:rdn uLabel="实例.example">xn--fsq270a.example</b-dn:rdn><b-dn:bdn uLabel="實例.example">xn--fsqz41a.example</b-dn:bdn></b-dn:bundle></b-dn:trnData></extension>');
$rc=$dri->domain_transfer_start('xn--fsq270a.example',{auth=>{pw=>'2fooBAR'}});
is_deeply($rc->get_data('domain','xn--fsq270a.example','rdn'),{alabel => 'xn--fsq270a.example', ulabel => '实例.example'},'domain_renew reply rdn');
is_deeply($rc->get_data('domain','xn--fsq270a.example','bdn'),{alabel => 'xn--fsqz41a.example', ulabel => '實例.example'},'domain_renew reply bdn');


$test->set_response('<extension><b-dn:upData xmlns:b-dn="urn:ietf:params:xml:ns:epp:b-dn"><b-dn:bundle><b-dn:rdn uLabel="实例.example">xn--fsq270a.example</b-dn:rdn><b-dn:bdn uLabel="實例.example">xn--fsqz41a.example</b-dn:bdn></b-dn:bundle></b-dn:upData></extension>');
my $toc=$dri->local_object('changes');
$toc->set('auth',{pw=>'2BARfoo'});
$rc=$dri->domain_update('xn--fsq270a.example', $toc);
is_deeply($rc->get_data('domain','xn--fsq270a.example','rdn'),{alabel => 'xn--fsq270a.example', ulabel => '实例.example'},'domain_renew reply rdn');
is_deeply($rc->get_data('domain','xn--fsq270a.example','bdn'),{alabel => 'xn--fsqz41a.example', ulabel => '實例.example'},'domain_renew reply bdn');

exit 0;
