package Net::Async::Spotify::Object::Generated::Followers;

use strict;
use warnings;

our $VERSION = '0.001'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::Followers - Package representing Spotify Followers Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify Followers Object attributes:

=over 4

=item href

Type:String
Description:A link to the Web API endpoint providing full details of the followers; null if not available. Please note that this will always be set to null, as the Web API does not support it at the moment.

=item total

Type:Integer
Description:The total number of followers.

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        href => 'String',
        total => 'Integer',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
