use utf8;
use strict;
use warnings;

package Number::Phone::FR::Full;

our $VERSION;
BEGIN {
    $VERSION = '0.0917109';
}

use Number::Phone::FR;

use parent 'Number::Phone::FR';
use Scalar::Util 'blessed';

sub RE_0() {
    qr/(?:(?:9(?:7(?:6(?:[06][1-9]|1[0-37]|7[1-367]|3[1-37]|4[017]|5[0-2]|2[27]|9[0-9])|8(?:[156][0-9]|2[0-3]|3[5-7]|4[0-2]|[07][0-9]|9[78])|0(?:5[0-79]|3[02-689]|[0-246-8][0-9]|9[0-9])|3(?:[1256][0-9]|[37][0-4]|8[2-7]|0[0-9])|2(?:[1-69][0-9]|7[0-3]|8[0-9]|0[09])|4(?:[24-8][0-9]|1[2-4]|9[01]|00)|7(?:[013-9][0-9]|2[0-2])|[159][0-9][0-9])|8(?:8(?:[03-5][0-9]|2[0-258]|1[0189]|6[6-8]|9[089]|8[0-9]|77)|7(?:[013-57][0-9]|6[5-7]|8[6-8]|9[89]|27)|2(?:[2-7][0-9]|1[0-2]|9[89]|05|82)|0(?:[3-9][0-9]|0[0189]|1[03])|6(?:[0-7][0-9]|8[67]|98)|5(?:[3-8][1-9]|9[0-9])|(?:9[0-5]|1[0-9])[0-9]|3(?:[02-9][0-9]|10)|4(?:[0-5][0-9]|98))|[56][0-9][0-9][0-9])|6(?:9(?:3(?:4[0-7]|9[0-479]|0[0-46]|8[0-38]|6[0-26]|1[013]|2[0-2]|3[039]|5[05]|7[07])|6(?:[0-47-9][0-9]|5[0-6]|6[0-4])|4(?:3[0-48]|[0-249][0-9])|1(?:3[0-5]|2[29]|87)|[589][0-9][0-9]|[02][0-9][0-9]|727)|3(?:9(?:0[0-79]|9[04-79]|1[019]|[26][0-9]|3[09]|7[06]|[45]0)|6(?:[5-9][0-9]|[0-4][0-9])|8(?:[1-9][0-9]|0[0-9])|[0-57][0-9][0-9])|4(?:9(?:[0-46-8][0-9]|[59][0-9])|(?:[235-8][0-9]|4[0-9])[0-9]|0(?:[1-9][0-9]|0[0-9])|1(?:[0-57-9][0-9]|6[0-9]))|0(?:(?:[137-9][0-9]|[245][0-9])[0-9]|6(?:[0-4][0-9]|[5-9][0-9]))|5(?:(?:[0-2457-9][0-9]|3[0-9])[0-9]|6(?:[0-57-9][0-9]|6[0-9]))|(?:6(?:[0-8][0-9]|9[0-9])|[1278][0-9][0-9])[0-9])|5(?:9(?:6(?:0[0-7]|4[0-246-8]|3[05-9]|9[4-8]|[5-7][0-9]|2[78]|8[09]|10)|0(?:4[0-246-9]|[02589][0-9]|3[0-289]|1[0-3]|6[0189]|7[07])|4(?:4[0346-9]|5[6-9]|6[0-3]|[023][0-9]|9[014]|1[01]|80))|3(?:2(?:8[0-8]|5[0-6]|[0-4][0-9]|6[23])|6(?:1[1-9]|3[0-8]|[024][0-9]|5[03])|[13-5][0-9][0-9])|8(?:2(?:[0-79][0-9]|8[013-9])|6(?:[0-47-9][0-9]|6[5-9])|[17][0-9][0-9])|6(?:4(?:[0-24-9][0-9]|3[013-9])|[1-357][0-9][0-9])|5(?:4(?:[0-4][0-9]|5[0-4])|[35-9][0-9][0-9])|(?:4[024-79]|(?:24|79))[0-9][0-9]|1(?:80[0-6]|[679][0-9][0-9])|08(?:4[0-24]|5[05]))|4(?:2(?:2(?:5[1-9]|8[0-46-9]|[0-4679][0-9])|0(?:5[5-9]|[01][0-9]|[2-4]0|9[45]|61|88)|8(?:[0-35-9][0-9]|4[0-24-9])|[67][0-9][0-9]|31[12])|8(?:5(?:4[0-5]|8[05-8]|[0-2][0-9]|3[08]|75)|7(?:[0-29][0-9]|3[0-2]|8[89])|[0-4689][0-9][0-9])|4(?:4(?:0[0-6]|4[3-7]|8[89]|54)|8(?:[0-7][0-9]|8[089]|9[0-2])|[23][0-9][0-9])|6(?:5(?:1[02-9]|6[5-9]|8[0-4]|[0237][0-9]|4[0-3])|[36-9][0-9][0-9])|1(?:5(?:[0-7][0-9]|8[0-5])|[13][0-9][0-9])|5(?:8(?:[0-7][0-9]|8[01])|[067][0-9][0-9])|(?:(?:3[02478]|7[0-9])|9[0-9])[0-9][0-9])|2(?:5(?:2(?:[0-79][0-9]|8[0-46-9])|5(?:5[5-9]|[6-9][0-9]|0[0-3])|80[0-7]|[013467][0-9][0-9])|6(?:2(?:0[1-9]|[1-79][0-9]|8[0-27-9])|9(?:6[0-6]|0[67]|5[01]|[78]0)|1[0-9][0-9])|7(?:9(?:8[1-9]|2[0-5]|[01][0-9]|79)|8(?:[0-689][0-9]|7[0-8])|[267][0-9][0-9])|4(?:2(?:6[0-8]|[0-5][0-9])|[013-9][0-9][0-9])|(?:(?:(?:1[48]|85)|3[0-8])|9[06-9])[0-9][0-9]|2(?:1(?:3[0-3]|[0-2][0-9])|[237-9][0-9][0-9]))|3(?:7(?:4(?:2[0-24-9]|4[0-7]|7[4-9]|[01389][0-9])|5(?:4[0-6]|[0-3][0-9])|9(?:0[0-9]|10)|[0-3][0-9][0-9])|6(?:7(?:1[0-57-9]|8[0-46-9]|9[0-5]|[02367][0-9])|[0-689][0-9][0-9])|(?:(?:(?:(?:2[0-9]|10)|4[45])|8[0-9])|9[01])[0-9][0-9]|5(?:[36](?:[0-2][0-9]|3[0-2])|[12457-9][0-9][0-9])|39(?:[0-48][0-9]|7[0-3]|[59]0))|1(?:8(?:7(?:6[0-69]|[0-5][0-9]|8[78])|5(?:[0-79][0-9]|8[0-79])|[0-46][0-9][0-9])|(?:(?:(?:(?:3[049]|4[0-9])|5[035-8])|6[0149])|7[0-9])[0-9][0-9]|(?:(?:9[01]|05)[0-9]|24[12])[0-9]))[0-9]|8(?:(?:2(?:1(?:4[02-9]|2[0-589]|3[02-46-8]|5[0-57]|6[0-256]|7[04578]|[0189][0-9])|6(?:[14][0-6]|0[0-24-9]|5[0-35-79]|8[0-24-68]|9[05-79]|[2367][0-9])|5(?:2[0-8]|4[02-57-9]|6[0235-9]|9[024578]|[01358][0-9]|7[24-7])|0(?:4[0-8]|7[0-57-9]|6[0-25-9]|[0-3589][0-9]))|6(?:0(?:0[0-24-79]|1[0-25-9]|4[0-24-7]|9[0-469]|6[0-2458]|7[014589]|8[246-8]|3[0378]|2[268]|5[17])|8(?:3[02389]|4[0-26]|9[0-29]|7[089]|8[468]|0[17]|5[27]|6[08]|11|22))|1(?:1(?:[27][0-8]|3[0-46-9]|4[0-689]|8[0-24-9]|6[024-9]|[0159][0-9])|2(?:0[0-8]|1[0-4]|2[0-2]|8[01]|34|42)|9(?:0[25]|1[09])|0[0-9][0-9])|4(?:1(?:0[013-5]|1[0-3]|4[12])|3(?:0[0-589]|99))|5(?:0[0-2469]|8[58]|[45]0|28|66)[0-9]|8428)[0-9]|9(?:(?:0(?:0[0-46-9]|3[013-69]|4[0-6]|5[04-9]|7[015-9]|2[0-5]|9[0-27-9]|8[01469]|1[0-3]|6[0145])|2(?:0[0-79]|1[02-9]|3[013-9]|4[0-35-9]|5[1-9]|6[0-689]|8[0146-9]|[279][0-9])|1(?:0[0-7]|1[0-24689]|3[035-9]|5[013-7]|2[2-6]|4[3-68]|6[0579]|7[0178]|8[049]|9[27])|9(?:[159][02-9]|2[1-9]|4[0-689]|7[0-24-9]|6[0-69]|3[346-9]|[08][0-9])|7(?:7[0-24-689]|1[0236-8]|0[0145]|2[1-4]|5[05-7]|3[7-9]|4[469]|6[569]|8[79]|97))[0-9]|5(?:6(?:9[0-24-9]|8[01])|0(?:8[0-29]|7[7-9]|20)|2(?:3[2-4]|2[67]|00)|8(?:9[5-7]|8[89])|1(?:0[0-9]|23)|7(?:0[01]|95)|[59]00)|84(?:0[124]|4[0-9])|300[0-57])|0(?:(?:5(?:4[0-79]|9[0-35-9]|6[0-3569]|7[0135-7]|8[0-2568]|[0-35][0-9])|6(?:1[0-6]|0[06-9]|[69][09]|5[04]|8[01]|23|70)|1(?:0[0-46-9]|2[036]|8[0-2]|1[01]|38|77|90)|3(?:0[1-9]|8[0-468]|3[02357])|9(?:1[0239]|0[126]|3[268]|[489]0|54)|0[0-9][0-9])[0-9]|88(?:0[015-9]|10))|36(?:(?:0[1-36-9]|4[7-9]|5[49]|6[02]|99)[0-9]|7(?:[35][0-9]|47)))|7(?:(?:5(?:0(?:[1-489][0-9]|5[0-378]|7[0-5]|[06][0-9])|7(?:[23][0-9]|[45][0-9]|0[07]|6[37]|7[79]|[18]7)|5(?:[0-47-9][0-9]|5[0-7]|6[0-46-8])|2(?:[1-9][0-9]|0[0-6])|4(?:[0-24-9][0-9]|3[0-2])|(?:[389][0-9]|[16][0-9])[0-9])|8(?:(?:4[0-8]|[1-359][0-9]|[78][0-9])[0-9]|0(?:[0-8][0-9]|9[0-9])|6(?:[1-9][0-9]|0[0-9]))|7(?:(?:[6-9][0-9]|5[0-6]|0[0-9])[0-9]|1(?:[0-46-8][0-9]|9[0-4]|5[0-9]))|6(?:(?:[1-57-9][0-9]|69)[0-9]|0(?:[1-9][0-9]|0[0-9])))[0-9]|0000[0-3]))[0-9][0-9][0-9]/
}

sub RE_SUBSCRIBER() {
    qr/\A(?:(3(?:9(?:0[0-79]|1[0-79]|3[0-35-79]|2[0-479]|4[03-689]|7[0135-79]|9[0-24579]|5[0579]|8[0189]|6[069])|6(?:2[0-689]|0[0135-9]|3[0-24-79]|5[0-24-8]|6[013-79]|9[025689]|7[067]|8[02]|1[0-9]|4[0-9])|2(?:3[0-79]|5[0-46-9]|8[02-9]|6[024-8]|9[02-49]|0[0-9]|1[0-9]|2[0-9]|4[0-9]|7[0-9])|0(?:0[0-24579]|3[0-356]|2[02356]|1[057]|8[079]|[467]0|5[05]|9[09])|4(?:9[13-79]|4[02-57]|3[03-6]|2[024]|5[046]|1[01]|04|88)|1(?:1[0-367]|0[0136]|2[013]|3[0-2]|55|90)))|(?:(?:3651)?(?:[047-9]|16(?:1[013-578]|2[1356]|6[04-6]|3[038]|5[479]|9[079]|[78]0|03|44))|(?:00|\+)33)((?:(?:9(?:7(?:6(?:[06][1-9]|1[0-37]|7[1-367]|3[1-37]|4[017]|5[0-2]|2[27]|9[0-9])|8(?:[156][0-9]|2[0-3]|3[5-7]|4[0-2]|[07][0-9]|9[78])|0(?:5[0-79]|3[02-689]|[0-246-8][0-9]|9[0-9])|3(?:[1256][0-9]|[37][0-4]|8[2-7]|0[0-9])|2(?:[1-69][0-9]|7[0-3]|8[0-9]|0[09])|4(?:[24-8][0-9]|1[2-4]|9[01]|00)|7(?:[013-9][0-9]|2[0-2])|[159][0-9][0-9])|8(?:8(?:[03-5][0-9]|2[0-258]|1[0189]|6[6-8]|9[089]|8[0-9]|77)|7(?:[013-57][0-9]|6[5-7]|8[6-8]|9[89]|27)|2(?:[2-7][0-9]|1[0-2]|9[89]|05|82)|0(?:[3-9][0-9]|0[0189]|1[03])|6(?:[0-7][0-9]|8[67]|98)|5(?:[3-8][1-9]|9[0-9])|(?:9[0-5]|1[0-9])[0-9]|3(?:[02-9][0-9]|10)|4(?:[0-5][0-9]|98))|[56][0-9][0-9][0-9])|6(?:9(?:3(?:4[0-7]|9[0-479]|0[0-46]|8[0-38]|6[0-26]|1[013]|2[0-2]|3[039]|5[05]|7[07])|6(?:[0-47-9][0-9]|5[0-6]|6[0-4])|4(?:3[0-48]|[0-249][0-9])|1(?:3[0-5]|2[29]|87)|[589][0-9][0-9]|[02][0-9][0-9]|727)|3(?:9(?:0[0-79]|9[04-79]|1[019]|[26][0-9]|3[09]|7[06]|[45]0)|6(?:[5-9][0-9]|[0-4][0-9])|8(?:[1-9][0-9]|0[0-9])|[0-57][0-9][0-9])|4(?:9(?:[0-46-8][0-9]|[59][0-9])|(?:[235-8][0-9]|4[0-9])[0-9]|0(?:[1-9][0-9]|0[0-9])|1(?:[0-57-9][0-9]|6[0-9]))|0(?:(?:[137-9][0-9]|[245][0-9])[0-9]|6(?:[0-4][0-9]|[5-9][0-9]))|5(?:(?:[0-2457-9][0-9]|3[0-9])[0-9]|6(?:[0-57-9][0-9]|6[0-9]))|(?:6(?:[0-8][0-9]|9[0-9])|[1278][0-9][0-9])[0-9])|5(?:9(?:6(?:0[0-7]|4[0-246-8]|3[05-9]|9[4-8]|[5-7][0-9]|2[78]|8[09]|10)|0(?:4[0-246-9]|[02589][0-9]|3[0-289]|1[0-3]|6[0189]|7[07])|4(?:4[0346-9]|5[6-9]|6[0-3]|[023][0-9]|9[014]|1[01]|80))|3(?:2(?:8[0-8]|5[0-6]|[0-4][0-9]|6[23])|6(?:1[1-9]|3[0-8]|[024][0-9]|5[03])|[13-5][0-9][0-9])|8(?:2(?:[0-79][0-9]|8[013-9])|6(?:[0-47-9][0-9]|6[5-9])|[17][0-9][0-9])|6(?:4(?:[0-24-9][0-9]|3[013-9])|[1-357][0-9][0-9])|5(?:4(?:[0-4][0-9]|5[0-4])|[35-9][0-9][0-9])|(?:4[024-79]|(?:24|79))[0-9][0-9]|1(?:80[0-6]|[679][0-9][0-9])|08(?:4[0-24]|5[05]))|4(?:2(?:2(?:5[1-9]|8[0-46-9]|[0-4679][0-9])|0(?:5[5-9]|[01][0-9]|[2-4]0|9[45]|61|88)|8(?:[0-35-9][0-9]|4[0-24-9])|[67][0-9][0-9]|31[12])|8(?:5(?:4[0-5]|8[05-8]|[0-2][0-9]|3[08]|75)|7(?:[0-29][0-9]|3[0-2]|8[89])|[0-4689][0-9][0-9])|4(?:4(?:0[0-6]|4[3-7]|8[89]|54)|8(?:[0-7][0-9]|8[089]|9[0-2])|[23][0-9][0-9])|6(?:5(?:1[02-9]|6[5-9]|8[0-4]|[0237][0-9]|4[0-3])|[36-9][0-9][0-9])|1(?:5(?:[0-7][0-9]|8[0-5])|[13][0-9][0-9])|5(?:8(?:[0-7][0-9]|8[01])|[067][0-9][0-9])|(?:(?:3[02478]|7[0-9])|9[0-9])[0-9][0-9])|2(?:5(?:2(?:[0-79][0-9]|8[0-46-9])|5(?:5[5-9]|[6-9][0-9]|0[0-3])|80[0-7]|[013467][0-9][0-9])|6(?:2(?:0[1-9]|[1-79][0-9]|8[0-27-9])|9(?:6[0-6]|0[67]|5[01]|[78]0)|1[0-9][0-9])|7(?:9(?:8[1-9]|2[0-5]|[01][0-9]|79)|8(?:[0-689][0-9]|7[0-8])|[267][0-9][0-9])|4(?:2(?:6[0-8]|[0-5][0-9])|[013-9][0-9][0-9])|(?:(?:(?:1[48]|85)|3[0-8])|9[06-9])[0-9][0-9]|2(?:1(?:3[0-3]|[0-2][0-9])|[237-9][0-9][0-9]))|3(?:7(?:4(?:2[0-24-9]|4[0-7]|7[4-9]|[01389][0-9])|5(?:4[0-6]|[0-3][0-9])|9(?:0[0-9]|10)|[0-3][0-9][0-9])|6(?:7(?:1[0-57-9]|8[0-46-9]|9[0-5]|[02367][0-9])|[0-689][0-9][0-9])|(?:(?:(?:(?:2[0-9]|10)|4[45])|8[0-9])|9[01])[0-9][0-9]|5(?:[36](?:[0-2][0-9]|3[0-2])|[12457-9][0-9][0-9])|39(?:[0-48][0-9]|7[0-3]|[59]0))|1(?:8(?:7(?:6[0-69]|[0-5][0-9]|8[78])|5(?:[0-79][0-9]|8[0-79])|[0-46][0-9][0-9])|(?:(?:(?:(?:3[049]|4[0-9])|5[035-8])|6[0149])|7[0-9])[0-9][0-9]|(?:(?:9[01]|05)[0-9]|24[12])[0-9]))[0-9]|8(?:(?:2(?:1(?:4[02-9]|2[0-589]|3[02-46-8]|5[0-57]|6[0-256]|7[04578]|[0189][0-9])|6(?:[14][0-6]|0[0-24-9]|5[0-35-79]|8[0-24-68]|9[05-79]|[2367][0-9])|5(?:2[0-8]|4[02-57-9]|6[0235-9]|9[024578]|[01358][0-9]|7[24-7])|0(?:4[0-8]|7[0-57-9]|6[0-25-9]|[0-3589][0-9]))|6(?:0(?:0[0-24-79]|1[0-25-9]|4[0-24-7]|9[0-469]|6[0-2458]|7[014589]|8[246-8]|3[0378]|2[268]|5[17])|8(?:3[02389]|4[0-26]|9[0-29]|7[089]|8[468]|0[17]|5[27]|6[08]|11|22))|1(?:1(?:[27][0-8]|3[0-46-9]|4[0-689]|8[0-24-9]|6[024-9]|[0159][0-9])|2(?:0[0-8]|1[0-4]|2[0-2]|8[01]|34|42)|9(?:0[25]|1[09])|0[0-9][0-9])|4(?:1(?:0[013-5]|1[0-3]|4[12])|3(?:0[0-589]|99))|5(?:0[0-2469]|8[58]|[45]0|28|66)[0-9]|8428)[0-9]|9(?:(?:0(?:0[0-46-9]|3[013-69]|4[0-6]|5[04-9]|7[015-9]|2[0-5]|9[0-27-9]|8[01469]|1[0-3]|6[0145])|2(?:0[0-79]|1[02-9]|3[013-9]|4[0-35-9]|5[1-9]|6[0-689]|8[0146-9]|[279][0-9])|1(?:0[0-7]|1[0-24689]|3[035-9]|5[013-7]|2[2-6]|4[3-68]|6[0579]|7[0178]|8[049]|9[27])|9(?:[159][02-9]|2[1-9]|4[0-689]|7[0-24-9]|6[0-69]|3[346-9]|[08][0-9])|7(?:7[0-24-689]|1[0236-8]|0[0145]|2[1-4]|5[05-7]|3[7-9]|4[469]|6[569]|8[79]|97))[0-9]|5(?:6(?:9[0-24-9]|8[01])|0(?:8[0-29]|7[7-9]|20)|2(?:3[2-4]|2[67]|00)|8(?:9[5-7]|8[89])|1(?:0[0-9]|23)|7(?:0[01]|95)|[59]00)|84(?:0[124]|4[0-9])|300[0-57])|0(?:(?:5(?:4[0-79]|9[0-35-9]|6[0-3569]|7[0135-7]|8[0-2568]|[0-35][0-9])|6(?:1[0-6]|0[06-9]|[69][09]|5[04]|8[01]|23|70)|1(?:0[0-46-9]|2[036]|8[0-2]|1[01]|38|77|90)|3(?:0[1-9]|8[0-468]|3[02357])|9(?:1[0239]|0[126]|3[268]|[489]0|54)|0[0-9][0-9])[0-9]|88(?:0[015-9]|10))|36(?:(?:0[1-36-9]|4[7-9]|5[49]|6[02]|99)[0-9]|7(?:[35][0-9]|47)))|7(?:(?:5(?:0(?:[1-489][0-9]|5[0-378]|7[0-5]|[06][0-9])|7(?:[23][0-9]|[45][0-9]|0[07]|6[37]|7[79]|[18]7)|5(?:[0-47-9][0-9]|5[0-7]|6[0-46-8])|2(?:[1-9][0-9]|0[0-6])|4(?:[0-24-9][0-9]|3[0-2])|(?:[389][0-9]|[16][0-9])[0-9])|8(?:(?:4[0-8]|[1-359][0-9]|[78][0-9])[0-9]|0(?:[0-8][0-9]|9[0-9])|6(?:[1-9][0-9]|0[0-9]))|7(?:(?:[6-9][0-9]|5[0-6]|0[0-9])[0-9]|1(?:[0-46-8][0-9]|9[0-4]|5[0-9]))|6(?:(?:[1-57-9][0-9]|69)[0-9]|0(?:[1-9][0-9]|0[0-9])))[0-9]|0000[0-3]))[0-9][0-9][0-9]))\z/
}

sub RE_FULL() {
    qr/\A(?:(?:1(?:1(?:8(?:7(?:1[0-38]|0[07])|0(?:0[0-26-8]|18)|6(?:1[128]|0[06])|8(?:1[168]|00|88)|5(?:1[58]|00|55)|2(?:00|18|22)|3(?:00|18|33)|4(?:00|18)|9(?:00|18))|[259]|6000)|0(?:1[0-8]|2[02-6]|0[157]|3[034]|6[148]|9[079]|5[57]|44|75)|[578]))|(?:3(?:9(?:0[0-79]|1[0-79]|3[0-35-79]|2[0-479]|4[03-689]|7[0135-79]|9[0-24579]|5[0579]|8[0189]|6[069])|6(?:2[0-689]|0[0135-9]|3[0-24-79]|5[0-24-8]|6[013-79]|9[025689]|7[067]|8[02]|1[0-9]|4[0-9])|2(?:3[0-79]|5[0-46-9]|8[02-9]|6[024-8]|9[02-49]|0[0-9]|1[0-9]|2[0-9]|4[0-9]|7[0-9])|0(?:0[0-24579]|3[0-356]|2[02356]|1[057]|8[079]|[467]0|5[05]|9[09])|4(?:9[13-79]|4[02-57]|3[03-6]|2[024]|5[046]|1[01]|04|88)|1(?:1[0-367]|0[0136]|2[013]|3[0-2]|55|90)))|(?:(?:(?:3651)?(?:[047-9]|16(?:1[013-578]|2[1356]|6[04-6]|3[038]|5[479]|9[079]|[78]0|03|44))|(?:00|\+)33))(?:(?:(?:(?:9(?:7(?:6(?:[06][1-9]|1[0-37]|7[1-367]|3[1-37]|4[017]|5[0-2]|2[27]|9[0-9])|8(?:[156][0-9]|2[0-3]|3[5-7]|4[0-2]|[07][0-9]|9[78])|0(?:5[0-79]|3[02-689]|[0-246-8][0-9]|9[0-9])|3(?:[1256][0-9]|[37][0-4]|8[2-7]|0[0-9])|2(?:[1-69][0-9]|7[0-3]|8[0-9]|0[09])|4(?:[24-8][0-9]|1[2-4]|9[01]|00)|7(?:[013-9][0-9]|2[0-2])|[159][0-9][0-9])|8(?:8(?:[03-5][0-9]|2[0-258]|1[0189]|6[6-8]|9[089]|8[0-9]|77)|7(?:[013-57][0-9]|6[5-7]|8[6-8]|9[89]|27)|2(?:[2-7][0-9]|1[0-2]|9[89]|05|82)|0(?:[3-9][0-9]|0[0189]|1[03])|6(?:[0-7][0-9]|8[67]|98)|5(?:[3-8][1-9]|9[0-9])|(?:9[0-5]|1[0-9])[0-9]|3(?:[02-9][0-9]|10)|4(?:[0-5][0-9]|98))|[56][0-9][0-9][0-9])|6(?:9(?:3(?:4[0-7]|9[0-479]|0[0-46]|8[0-38]|6[0-26]|1[013]|2[0-2]|3[039]|5[05]|7[07])|6(?:[0-47-9][0-9]|5[0-6]|6[0-4])|4(?:3[0-48]|[0-249][0-9])|1(?:3[0-5]|2[29]|87)|[589][0-9][0-9]|[02][0-9][0-9]|727)|3(?:9(?:0[0-79]|9[04-79]|1[019]|[26][0-9]|3[09]|7[06]|[45]0)|6(?:[5-9][0-9]|[0-4][0-9])|8(?:[1-9][0-9]|0[0-9])|[0-57][0-9][0-9])|4(?:9(?:[0-46-8][0-9]|[59][0-9])|(?:[235-8][0-9]|4[0-9])[0-9]|0(?:[1-9][0-9]|0[0-9])|1(?:[0-57-9][0-9]|6[0-9]))|0(?:(?:[137-9][0-9]|[245][0-9])[0-9]|6(?:[0-4][0-9]|[5-9][0-9]))|5(?:(?:[0-2457-9][0-9]|3[0-9])[0-9]|6(?:[0-57-9][0-9]|6[0-9]))|(?:6(?:[0-8][0-9]|9[0-9])|[1278][0-9][0-9])[0-9])|5(?:9(?:6(?:0[0-7]|4[0-246-8]|3[05-9]|9[4-8]|[5-7][0-9]|2[78]|8[09]|10)|0(?:4[0-246-9]|[02589][0-9]|3[0-289]|1[0-3]|6[0189]|7[07])|4(?:4[0346-9]|5[6-9]|6[0-3]|[023][0-9]|9[014]|1[01]|80))|3(?:2(?:8[0-8]|5[0-6]|[0-4][0-9]|6[23])|6(?:1[1-9]|3[0-8]|[024][0-9]|5[03])|[13-5][0-9][0-9])|8(?:2(?:[0-79][0-9]|8[013-9])|6(?:[0-47-9][0-9]|6[5-9])|[17][0-9][0-9])|6(?:4(?:[0-24-9][0-9]|3[013-9])|[1-357][0-9][0-9])|5(?:4(?:[0-4][0-9]|5[0-4])|[35-9][0-9][0-9])|(?:4[024-79]|(?:24|79))[0-9][0-9]|1(?:80[0-6]|[679][0-9][0-9])|08(?:4[0-24]|5[05]))|4(?:2(?:2(?:5[1-9]|8[0-46-9]|[0-4679][0-9])|0(?:5[5-9]|[01][0-9]|[2-4]0|9[45]|61|88)|8(?:[0-35-9][0-9]|4[0-24-9])|[67][0-9][0-9]|31[12])|8(?:5(?:4[0-5]|8[05-8]|[0-2][0-9]|3[08]|75)|7(?:[0-29][0-9]|3[0-2]|8[89])|[0-4689][0-9][0-9])|4(?:4(?:0[0-6]|4[3-7]|8[89]|54)|8(?:[0-7][0-9]|8[089]|9[0-2])|[23][0-9][0-9])|6(?:5(?:1[02-9]|6[5-9]|8[0-4]|[0237][0-9]|4[0-3])|[36-9][0-9][0-9])|1(?:5(?:[0-7][0-9]|8[0-5])|[13][0-9][0-9])|5(?:8(?:[0-7][0-9]|8[01])|[067][0-9][0-9])|(?:(?:3[02478]|7[0-9])|9[0-9])[0-9][0-9])|2(?:5(?:2(?:[0-79][0-9]|8[0-46-9])|5(?:5[5-9]|[6-9][0-9]|0[0-3])|80[0-7]|[013467][0-9][0-9])|6(?:2(?:0[1-9]|[1-79][0-9]|8[0-27-9])|9(?:6[0-6]|0[67]|5[01]|[78]0)|1[0-9][0-9])|7(?:9(?:8[1-9]|2[0-5]|[01][0-9]|79)|8(?:[0-689][0-9]|7[0-8])|[267][0-9][0-9])|4(?:2(?:6[0-8]|[0-5][0-9])|[013-9][0-9][0-9])|(?:(?:(?:1[48]|85)|3[0-8])|9[06-9])[0-9][0-9]|2(?:1(?:3[0-3]|[0-2][0-9])|[237-9][0-9][0-9]))|3(?:7(?:4(?:2[0-24-9]|4[0-7]|7[4-9]|[01389][0-9])|5(?:4[0-6]|[0-3][0-9])|9(?:0[0-9]|10)|[0-3][0-9][0-9])|6(?:7(?:1[0-57-9]|8[0-46-9]|9[0-5]|[02367][0-9])|[0-689][0-9][0-9])|(?:(?:(?:(?:2[0-9]|10)|4[45])|8[0-9])|9[01])[0-9][0-9]|5(?:[36](?:[0-2][0-9]|3[0-2])|[12457-9][0-9][0-9])|39(?:[0-48][0-9]|7[0-3]|[59]0))|1(?:8(?:7(?:6[0-69]|[0-5][0-9]|8[78])|5(?:[0-79][0-9]|8[0-79])|[0-46][0-9][0-9])|(?:(?:(?:(?:3[049]|4[0-9])|5[035-8])|6[0149])|7[0-9])[0-9][0-9]|(?:(?:9[01]|05)[0-9]|24[12])[0-9]))[0-9]|8(?:(?:2(?:1(?:4[02-9]|2[0-589]|3[02-46-8]|5[0-57]|6[0-256]|7[04578]|[0189][0-9])|6(?:[14][0-6]|0[0-24-9]|5[0-35-79]|8[0-24-68]|9[05-79]|[2367][0-9])|5(?:2[0-8]|4[02-57-9]|6[0235-9]|9[024578]|[01358][0-9]|7[24-7])|0(?:4[0-8]|7[0-57-9]|6[0-25-9]|[0-3589][0-9]))|6(?:0(?:0[0-24-79]|1[0-25-9]|4[0-24-7]|9[0-469]|6[0-2458]|7[014589]|8[246-8]|3[0378]|2[268]|5[17])|8(?:3[02389]|4[0-26]|9[0-29]|7[089]|8[468]|0[17]|5[27]|6[08]|11|22))|1(?:1(?:[27][0-8]|3[0-46-9]|4[0-689]|8[0-24-9]|6[024-9]|[0159][0-9])|2(?:0[0-8]|1[0-4]|2[0-2]|8[01]|34|42)|9(?:0[25]|1[09])|0[0-9][0-9])|4(?:1(?:0[013-5]|1[0-3]|4[12])|3(?:0[0-589]|99))|5(?:0[0-2469]|8[58]|[45]0|28|66)[0-9]|8428)[0-9]|9(?:(?:0(?:0[0-46-9]|3[013-69]|4[0-6]|5[04-9]|7[015-9]|2[0-5]|9[0-27-9]|8[01469]|1[0-3]|6[0145])|2(?:0[0-79]|1[02-9]|3[013-9]|4[0-35-9]|5[1-9]|6[0-689]|8[0146-9]|[279][0-9])|1(?:0[0-7]|1[0-24689]|3[035-9]|5[013-7]|2[2-6]|4[3-68]|6[0579]|7[0178]|8[049]|9[27])|9(?:[159][02-9]|2[1-9]|4[0-689]|7[0-24-9]|6[0-69]|3[346-9]|[08][0-9])|7(?:7[0-24-689]|1[0236-8]|0[0145]|2[1-4]|5[05-7]|3[7-9]|4[469]|6[569]|8[79]|97))[0-9]|5(?:6(?:9[0-24-9]|8[01])|0(?:8[0-29]|7[7-9]|20)|2(?:3[2-4]|2[67]|00)|8(?:9[5-7]|8[89])|1(?:0[0-9]|23)|7(?:0[01]|95)|[59]00)|84(?:0[124]|4[0-9])|300[0-57])|0(?:(?:5(?:4[0-79]|9[0-35-9]|6[0-3569]|7[0135-7]|8[0-2568]|[0-35][0-9])|6(?:1[0-6]|0[06-9]|[69][09]|5[04]|8[01]|23|70)|1(?:0[0-46-9]|2[036]|8[0-2]|1[01]|38|77|90)|3(?:0[1-9]|8[0-468]|3[02357])|9(?:1[0239]|0[126]|3[268]|[489]0|54)|0[0-9][0-9])[0-9]|88(?:0[015-9]|10))|36(?:(?:0[1-36-9]|4[7-9]|5[49]|6[02]|99)[0-9]|7(?:[35][0-9]|47)))|7(?:(?:5(?:0(?:[1-489][0-9]|5[0-378]|7[0-5]|[06][0-9])|7(?:[23][0-9]|[45][0-9]|0[07]|6[37]|7[79]|[18]7)|5(?:[0-47-9][0-9]|5[0-7]|6[0-46-8])|2(?:[1-9][0-9]|0[0-6])|4(?:[0-24-9][0-9]|3[0-2])|(?:[389][0-9]|[16][0-9])[0-9])|8(?:(?:4[0-8]|[1-359][0-9]|[78][0-9])[0-9]|0(?:[0-8][0-9]|9[0-9])|6(?:[1-9][0-9]|0[0-9]))|7(?:(?:[6-9][0-9]|5[0-6]|0[0-9])[0-9]|1(?:[0-46-8][0-9]|9[0-4]|5[0-9]))|6(?:(?:[1-57-9][0-9]|69)[0-9]|0(?:[1-9][0-9]|0[0-9])))[0-9]|0000[0-3]))[0-9][0-9][0-9])))\z/
}

sub RE_PFX() {
    qr/(?:(?:3651)?(?:[047-9]|16(?:1[013-578]|2[1356]|6[04-6]|3[038]|5[479]|9[079]|[78]0|03|44))|(?:00|\+)33)/
}

sub operator
{
    my $num = Number::Phone::FR::subscriber(@_);
    return unless defined $num;
    $num .= '_' x (9 - length($num));
    if ("${num}FRTESFR0COMPFREEBOUYCOLTOVH MCI EQFRUPCFLEGOPROSPHONOPENHUBTNRJ JAG ORCASRR PAOPVOXBALNIOUTRBUYCBJTPINITIPDIALPLNAVAATOWFRUNSEWAITNFMWSPNEOCMIASORIGSISTINCLTELCNWTIFUTUAXLYGIBMRMIICHMULEFRTERATHECAFINDVENCORILEONTLONPRIXEMESSENTDIABOPTIREMMAVIRBRETLISILPTLFINERHOVDAUFDIDWFRMOAFONAIEXBICSLGPHLYCANERIAVMIINNEMOQUVGSFWENGBTSIMBIUPHTEONOFTOBJ3620ABCOEASYIMSDMKSDTRATVPSLSTENSVCMAABABDMACOMCGSCOHERAVIADAICTCMRPFINGFRMTGLOBMTPEMYSTNETWWAREABPLERGAHPAFIDOMINUPIOVOMTARSPROVIMUZEOPCELYDURAEMODETOIGTPMMTPMOXTEPIOLPRODADONCLEMELOQLINKLLEILNUMMCAZNETEOPWAPRCPSTMBTRAN440HA6TEADSLANELAPWAATTGDEVOECOMEVMIEWAYFEBOFLEXGLOAGNTLGUYAGYPMHADRHALYHIGHNORNNUMENXTOPOLYPOMTSAPFSPMTTF1 W3TEYNOVZEMO123UACNCADISAMNEAPPEAPPSARAGASSAAVMMBEETBFINBUFRCALICAWICLIMCOENCOMGCPOMDFRADIMTESEYEURVEYESHEALIGWAINFSINGRIPARIPXTITLBKEYCKWAOLANELCNGLGC LUXNMAQUMDIAMTOFMUMEMUNDNEOENEOINOTLNOTONTLSODBEONETOPSTPAJAPALOPAREPFTLR188SOCTSTMASWTFSYSESYSTTDF TECHTELNTERYTRAITYLIUPSAVELDVITSWAELWEASWTRIYOOT" =~ m/^(3(?:6(?:7(?:7(?:[08][0-9][0-9][0-9][0-9].{112}|1[0-9][0-9][0-9][0-9].{468}|2[0-9][0-9][0-9][0-9].{196}|3[0-9][0-9][0-9][0-9].{316}|4[0-9][0-9][0-9][0-9].{156}|5[0-9][0-9][0-9][0-9].{288}|9[0-9][0-9][0-9][0-9].{140}|6[0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{48}|_____.{92})|2(?:[23][0-9][0-9][0-9][0-9].{108}|[01][0-9][0-9][0-9][0-9].{44}|[78][0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{184}|5[0-9][0-9][0-9][0-9].{332}|6[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{56})|8(?:[23][0-9][0-9][0-9][0-9].{56}|[48][0-9][0-9][0-9][0-9].{84}|0[0-9][0-9][0-9][0-9].{196}|6[0-9][0-9][0-9][0-9].{168}|7[0-9][0-9][0-9][0-9].{348}|9[0-9][0-9][0-9][0-9].{444}|1[0-9][0-9][0-9][0-9].{36})|1(?:[239][0-9][0-9][0-9][0-9].{44}|4[0-9][0-9][0-9][0-9].{232}|8[0-9][0-9][0-9][0-9].{148}|0[0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{40}|7[0-9][0-9][0-9][0-9].{52}|5[0-9][0-9][0-9][0-9].{8})|6(?:[2-5][0-9][0-9][0-9][0-9].{60}|[16][0-9][0-9][0-9][0-9].{56}|0[0-9][0-9][0-9][0-9].{212}|8[0-9][0-9][0-9][0-9].{340}|7[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{36}|_____.{48})|3(?:[016-8][0-9][0-9][0-9][0-9].{28}|[45][0-9][0-9][0-9][0-9].{128}|2[0-9][0-9][0-9][0-9].{392}|3[0-9][0-9][0-9][0-9].{240}|9[0-9][0-9][0-9][0-9].{272})|0(?:(?:[0-5][0-9][0-9][0-9][0-9]|_____).{4}|[89][0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{104}|7[0-9][0-9][0-9][0-9].{8})|9(?:[01][0-9][0-9][0-9][0-9].{88}|[23][0-9][0-9][0-9][0-9].{36}|5[0-9][0-9][0-9][0-9].{132}|4[0-9][0-9][0-9][0-9].{8}))|6(?:7(?:[67][0-9][0-9][0-9][0-9].{52}|[89][0-9][0-9][0-9][0-9].{48}|1[0-9][0-9][0-9][0-9].{116}|0[0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{28}|3[0-9][0-9][0-9][0-9].{40}|4[0-9][0-9][0-9][0-9].{84}|5[0-9][0-9][0-9][0-9].{88}|_____.{4})|8(?:[1-5][0-9][0-9][0-9][0-9].{48}|[89][0-9][0-9][0-9][0-9].{84}|0[0-9][0-9][0-9][0-9].{180}|6[0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{28})|2(?:[5-9][0-9][0-9][0-9][0-9].{12}|[23][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{20}|1[0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{28})|9(?:[0-5][0-9][0-9][0-9][0-9].{48}|[67][0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{180}|8[0-9][0-9][0-9][0-9].{28}|_____.{508})|6(?:[013-58][0-9][0-9][0-9][0-9].{40}|[26][0-9][0-9][0-9][0-9].{52}|[79][0-9][0-9][0-9][0-9].{68}|_____.{140})|0(?:[0-5][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{108}|_____.{4})|3(?:[014-9][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{228}|3[0-9][0-9][0-9][0-9].{48}|_____.{424})|4(?:[3-9][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{40}|_____.{380})|5(?:[0-7][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{52}|_____.{140})|1(?:[0-9][0-9][0-9][0-9][0-9].{20}|_____.{100}))|9(?:6(?:[7-9][0-9][0-9][0-9][0-9].{32}|[2-4][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{52}|5[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{44}|_____.{368})|2(?:[1378][0-9][0-9][0-9][0-9].{8}|[02][0-9][0-9][0-9][0-9].{12}|[45][0-9][0-9][0-9][0-9].{24}|[69][0-9][0-9][0-9][0-9].{40}|_____.{216})|0(?:[1-4][0-9][0-9][0-9][0-9].{40}|[578][0-9][0-9][0-9][0-9].{8}|[69][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{16}|_____.{368})|7(?:[3-69][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{32}|[27][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{40})|3(?:[124578][0-9][0-9][0-9][0-9].{8}|[06][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{16})|8(?:[03-6][0-9][0-9][0-9][0-9].{20}|[1279][0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{12}|_____.{4})|5(?:(?:[346-9][0-9][0-9][0-9][0-9]|_____).{8}|[0-2][0-9][0-9][0-9][0-9].{24}|5[0-9][0-9][0-9][0-9].{12})|9(?:[0-578][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{8}|_____.{4})|4(?:[0357-9][0-9][0-9][0-9][0-9].{8}|[14][0-9][0-9][0-9][0-9].{12}|[26][0-9][0-9][0-9][0-9].{40})|1(?:[02-8][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{40}))|2(?:8(?:[0237][0-9][0-9][0-9][0-9].{12}|[4-6][0-9][0-9][0-9][0-9].{116}|1[0-9][0-9][0-9][0-9].{132}|9[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{8}|_____.{164})|2(?:[2-58][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{300}|6[0-9][0-9][0-9][0-9].{56}|7[0-9][0-9][0-9][0-9].{52}|_____.{176})|5(?:[0359][0-9][0-9][0-9][0-9].{12}|[146][0-9][0-9][0-9][0-9].{32}|[27][0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{116}|_____.{216})|6(?:[7-9][0-9][0-9][0-9][0-9].{116}|[0-2][0-9][0-9][0-9][0-9].{12}|[3-5][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{40}|_____.{4})|9(?:[3-689][0-9][0-9][0-9][0-9].{12}|[0-2][0-9][0-9][0-9][0-9].{40}|7[0-9][0-9][0-9][0-9].{44}|_____.{216})|0(?:[13-9][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{100}|0[0-9][0-9][0-9][0-9].{16}|_____.{344})|7(?:[02-689][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{116}|7[0-9][0-9][0-9][0-9].{8})|3(?:[0-4][0-9][0-9][0-9][0-9].{16}|[5-9][0-9][0-9][0-9][0-9].{32}|_____.{176})|4(?:[0-6][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{32}|_____.{48})|1(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|_____.{216}))|8(?:6(?:[02-6][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{180}|8[0-9][0-9][0-9][0-9].{104}|1[0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{80})|3(?:[0-2][0-9][0-9][0-9][0-9].{24}|[3-5][0-9][0-9][0-9][0-9].{12}|[679][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{100})|4(?:[02-5][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{32}|[17][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{184})|5(?:[5-8][0-9][0-9][0-9][0-9].{116}|[1-4][0-9][0-9][0-9][0-9].{32}|0[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{36})|7(?:[1-5][0-9][0-9][0-9][0-9].{20}|[679][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{80}|8[0-9][0-9][0-9][0-9].{84})|9(?:[04-9][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{292}|3[0-9][0-9][0-9][0-9].{300}|2[0-9][0-9][0-9][0-9].{4})|0(?:[3-7][0-9][0-9][0-9][0-9].{8}|[089][0-9][0-9][0-9][0-9].{12}|[12][0-9][0-9][0-9][0-9].{16}|_____.{668})|2(?:[2-8][0-9][0-9][0-9][0-9].{12}|[09][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{16}|_____.{120})|1(?:[0-8][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{260})|8(?:[0-8][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{372}))|1(?:6(?:[04-6][0-9][0-9][0-9][0-9].{12}|[2378][0-9][0-9][0-9][0-9].{80}|1[0-9][0-9][0-9][0-9].{320}|9[0-9][0-9][0-9][0-9].{16}|_____.{204})|9(?:[4-9][0-9][0-9][0-9][0-9].{8}|[23][0-9][0-9][0-9][0-9].{40}|0[0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{80}|_____.{216})|3(?:[0-47][0-9][0-9][0-9][0-9].{8}|[56][0-9][0-9][0-9][0-9].{16}|[89][0-9][0-9][0-9][0-9].{40}|_____.{140})|7(?:[2-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{80}|_____.{176})|5(?:[3-9][0-9][0-9][0-9][0-9].{12}|[12][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|_____.{4})|8(?:[3-9][0-9][0-9][0-9][0-9].{8}|[02][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{80}|_____.{4})|0(?:(?:[0-69][0-9][0-9][0-9][0-9]|_____).{8}|8[0-9][0-9][0-9][0-9].{104}|7[0-9][0-9][0-9][0-9].{16})|2(?:[1-57-9][0-9][0-9][0-9][0-9].{8}|[06][0-9][0-9][0-9][0-9].{12}|_____.{140})|1(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12}|_____.{140})|4(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12}|_____.{4}))|0(?:8(?:[4-6][0-9][0-9][0-9][0-9].{84}|[78][0-9][0-9][0-9][0-9].{236}|2[0-9][0-9][0-9][0-9].{132}|0[0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{44}|1[0-9][0-9][0-9][0-9].{8}|_____.{4})|7(?:[1-4][0-9][0-9][0-9][0-9].{8}|[08][0-9][0-9][0-9][0-9].{16}|[59][0-9][0-9][0-9][0-9].{24}|[67][0-9][0-9][0-9][0-9].{12}|_____.{4})|6(?:[23689][0-9][0-9][0-9][0-9].{20}|[145][0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{80}|0[0-9][0-9][0-9][0-9].{8}|_____.{368})|5(?:[0-37][0-9][0-9][0-9][0-9].{8}|[589][0-9][0-9][0-9][0-9].{20}|[46][0-9][0-9][0-9][0-9].{12}|_____.{24})|3(?:[2-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{80}|_____.{176})|1(?:[0-4][0-9][0-9][0-9][0-9].{284}|[5-9][0-9][0-9][0-9][0-9].{8}|_____.{48})|0(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16}|_____.{176})|2(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|4(?:[0-35-9][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{12})|9(?:[0-9][0-9][0-9][0-9][0-9].{16}|_____.{4}))|5(?:6(?:[02-4][0-9][0-9][0-9][0-9].{12}|[6-8][0-9][0-9][0-9][0-9].{68}|1[0-9][0-9][0-9][0-9].{248}|9[0-9][0-9][0-9][0-9].{108}|5[0-9][0-9][0-9][0-9].{52}|_____.{232})|9(?:[1-4][0-9][0-9][0-9][0-9].{36}|[6-9][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{112}|5[0-9][0-9][0-9][0-9].{52})|1(?:[0-6][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9].{28}|_____.{4})|8(?:[0-7][0-9][0-9][0-9][0-9].{44}|8[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{28}|_____.{48})|4(?:(?:[4-9][0-9][0-9][0-9][0-9]|_____).{4}|[0-2][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{8})|7(?:[0-8][0-9][0-9][0-9][0-9].{48}|9[0-9][0-9][0-9][0-9].{108}|_____.{8})|0(?:[0-8][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{8}|_____.{48})|5(?:(?:[0-8][0-9][0-9][0-9][0-9]|_____).{4}|9[0-9][0-9][0-9][0-9].{104})|3(?:[0-7][0-9][0-9][0-9][0-9].{20}|[89][0-9][0-9][0-9][0-9].{12})|2(?:[0-9][0-9][0-9][0-9][0-9].{12}|_____.{768}))|3(?:1(?:[02-478][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{80}|9[0-9][0-9][0-9][0-9].{24}|_____.{4})|6(?:[0159][0-9][0-9][0-9][0-9].{20}|[23][0-9][0-9][0-9][0-9].{16}|[6-8][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{12}|_____.{92})|7(?:[4-8][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{12}|[23][0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{40}|_____.{4})|5(?:[0-267][0-9][0-9][0-9][0-9].{8}|[3-5][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{20}|_____.{48})|8(?:[06-9][0-9][0-9][0-9][0-9].{8}|[2-5][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{40})|0(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16}|_____.{512})|2(?:[1-9][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{12}|_____.{4})|3(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{24})|9(?:[0-9][0-9][0-9][0-9][0-9].{16}|_____.{4})|4(?:[0-9][0-9][0-9][0-9][0-9].{8}|_____.{4}))|4(?:8(?:(?:6[0-9][0-9][0-9][0-9]|_____).{8}|[1-5][0-9][0-9][0-9][0-9].{236}|[089][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{48})|4(?:[2-6][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{16}|[7-9][0-9][0-9][0-9][0-9].{8}|_____.{100})|6(?:[0-37][0-9][0-9][0-9][0-9].{236}|[4-6][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{8}|_____.{48})|9(?:[35-9][0-9][0-9][0-9][0-9].{32}|[014][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{8}|_____.{368})|2(?:[0-7][0-9][0-9][0-9][0-9].{8}|[89][0-9][0-9][0-9][0-9].{12}|_____.{24})|1(?:[2-9][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{24}|_____.{4})|7(?:(?:[1-9][0-9][0-9][0-9][0-9]|_____).{8}|0[0-9][0-9][0-9][0-9].{12})|0(?:[0-9][0-9][0-9][0-9][0-9].{24}|_____.{512})|3(?:[0-9][0-9][0-9][0-9][0-9].{12}|_____.{368})|5(?:[0-9][0-9][0-9][0-9][0-9]|_____).{8}))|5(?:9(?:6(?:[02][0-9][0-9][0-9][0-9].{32}|[39][0-9][0-9][0-9][0-9].{12}|[45][0-9][0-9][0-9][0-9].{20}|[6-8][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{128})|2(?:[0134][0-9][0-9][0-9][0-9].{20}|[56][0-9][0-9][0-9][0-9].{28}|[27][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{428}|9[0-9][0-9][0-9][0-9].{16})|3(?:[015][0-9][0-9][0-9][0-9].{12}|[2-4][0-9][0-9][0-9][0-9].{16}|[7-9][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{32})|5(?:[0-4][0-9][0-9][0-9][0-9].{8}|[67][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{32}|5[0-9][0-9][0-9][0-9].{44})|9(?:[1-4][0-9][0-9][0-9][0-9].{24}|[057][0-9][0-9][0-9][0-9].{8}|[68][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{32})|4(?:[5-8][0-9][0-9][0-9][0-9].{24}|[1-4][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{172}|9[0-9][0-9][0-9][0-9].{16})|0(?:[0-58][0-9][0-9][0-9][0-9].{8}|[67][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{12})|1(?:[03-589][0-9][0-9][0-9][0-9].{16}|[267][0-9][0-9][0-9][0-9].{20}|1[0-9][0-9][0-9][0-9].{8})|7(?:[014-9][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{20}|3[0-9][0-9][0-9][0-9].{12})|8(?:[1-8][0-9][0-9][0-9][0-9].{24}|[09][0-9][0-9][0-9][0-9].{8}))|2(?:7(?:[5-7][0-9][0-9][0-9][0-9].{36}|[03][0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{436}|1[0-9][0-9][0-9][0-9].{48}|2[0-9][0-9][0-9][0-9].{52}|4[0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{56})|5(?:[4-6][0-9][0-9][0-9][0-9].{68}|[01][0-9][0-9][0-9][0-9].{12}|[23][0-9][0-9][0-9][0-9].{52}|[78][0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{108})|8(?:[35-7][0-9][0-9][0-9][0-9].{28}|[048][0-9][0-9][0-9][0-9].{84}|1[0-9][0-9][0-9][0-9].{48}|2[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{36})|4(?:[6-9][0-9][0-9][0-9][0-9].{12}|[0-3][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{104}|5[0-9][0-9][0-9][0-9].{40})|9(?:[3-9][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{56}|1[0-9][0-9][0-9][0-9].{88}|2[0-9][0-9][0-9][0-9].{52})|6(?:[3-9][0-9][0-9][0-9][0-9].{44}|[01][0-9][0-9][0-9][0-9].{48}|2[0-9][0-9][0-9][0-9].{108})|2(?:[0-7][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{4})|0(?:[013-9][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{36})|1(?:[0-8][0-9][0-9][0-9][0-9].{20}|9[0-9][0-9][0-9][0-9].{12})|3[0-9][0-9][0-9][0-9][0-9].{4})|4(?:6(?:[4-7][0-9][0-9][0-9][0-9].{8}|[13][0-9][0-9][0-9][0-9].{20}|[89][0-9][0-9][0-9][0-9].{32}|0[0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{40})|7(?:[14578][0-9][0-9][0-9][0-9].{20}|[39][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{12})|8(?:[0-35-7][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{388}|4[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{40})|1(?:[24-689][0-9][0-9][0-9][0-9].{8}|[013][0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{56})|5(?:[1-59][0-9][0-9][0-9][0-9].{8}|[6-8][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{12})|0(?:[15-9][0-9][0-9][0-9][0-9].{16}|[02-4][0-9][0-9][0-9][0-9].{8})|2(?:[0-37-9][0-9][0-9][0-9][0-9].{8}|[4-6][0-9][0-9][0-9][0-9].{24})|4(?:[2-9][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{12})|9(?:[0-46-9][0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{8})|3[0-9][0-9][0-9][0-9][0-9].{8})|5(?:5(?:[37-9][0-9][0-9][0-9][0-9].{12}|[0-2][0-9][0-9][0-9][0-9].{24}|[45][0-9][0-9][0-9][0-9].{80}|6[0-9][0-9][0-9][0-9].{8})|7(?:[1-3][0-9][0-9][0-9][0-9].{12}|[4-68][0-9][0-9][0-9][0-9].{8}|[09][0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{40})|3(?:[124-7][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{156}|0[0-9][0-9][0-9][0-9].{8})|2(?:[5-9][0-9][0-9][0-9][0-9].{12}|[1-4][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40})|0(?:[0135-9][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{40})|6(?:[1-79][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{8})|8(?:[1-79][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{12})|1(?:[2-9][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{16})|9(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|4[0-9][0-9][0-9][0-9][0-9].{24})|7(?:5(?:[0-29][0-9][0-9][0-9][0-9].{12}|[45][0-9][0-9][0-9][0-9].{180}|[37][0-9][0-9][0-9][0-9].{40}|[68][0-9][0-9][0-9][0-9].{44})|9(?:[235-8][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{20}|9[0-9][0-9][0-9][0-9].{180}|4[0-9][0-9][0-9][0-9].{12})|7(?:[0-468][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{4})|2(?:[0-7][0-9][0-9][0-9][0-9].{32}|8[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{8})|1(?:[3-9][0-9][0-9][0-9][0-9].{32}|[0-2][0-9][0-9][0-9][0-9].{8})|3(?:[0-8][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{20})|4(?:[0-79][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{84})|0(?:[0-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{12})|6[0-9][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9][0-9].{20})|1(?:8(?:[3679][0-9][0-9][0-9][0-9].{24}|[024][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{44}|1[0-9][0-9][0-9][0-9].{8})|1(?:[014-8][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{32}|3[0-9][0-9][0-9][0-9].{80}|9[0-9][0-9][0-9][0-9].{28})|6(?:[0-49][0-9][0-9][0-9][0-9].{8}|[578][0-9][0-9][0-9][0-9].{20}|6[0-9][0-9][0-9][0-9].{24})|7(?:[13468][0-9][0-9][0-9][0-9].{20}|[2579][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{8})|0(?:[2-7][0-9][0-9][0-9][0-9].{16}|[0189][0-9][0-9][0-9][0-9].{8})|3(?:[2-46-9][0-9][0-9][0-9][0-9].{8}|[015][0-9][0-9][0-9][0-9].{12})|2(?:[0-46-9][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{128})|5(?:[0-689][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{80})|9[0-9][0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9][0-9].{8})|8(?:6(?:[5-8][0-9][0-9][0-9][0-9].{16}|[019][0-9][0-9][0-9][0-9].{12}|[2-4][0-9][0-9][0-9][0-9].{8})|4(?:[1-7][0-9][0-9][0-9][0-9].{8}|[89][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{24})|7(?:[1-6][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16})|8(?:[015-79][0-9][0-9][0-9][0-9].{8}|[238][0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{40})|9(?:[1-8][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{12})|[23][0-9][0-9][0-9][0-9][0-9].{24}|[01][0-9][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9][0-9].{12})|3(?:1(?:[5-9][0-9][0-9][0-9][0-9].{48}|[0-2][0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{112}|3[0-9][0-9][0-9][0-9].{8})|0(?:[2-9][0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{124}|0[0-9][0-9][0-9][0-9].{88})|2(?:[0-25-9][0-9][0-9][0-9][0-9].{48}|4[0-9][0-9][0-9][0-9].{132}|3[0-9][0-9][0-9][0-9].{40})|3(?:2[0-9][0-9][0-9][0-9].{272}|0[0-9][0-9][0-9][0-9].{48}|1[0-9][0-9][0-9][0-9].{8}))|6(?:1(?:[13-5][0-9][0-9][0-9][0-9].{56}|[6-9][0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9].{8})|2(?:[0-37-9][0-9][0-9][0-9][0-9].{48}|[45][0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{132})|3(?:[01][0-9][0-9][0-9][0-9].{48}|2[0-9][0-9][0-9][0-9].{8})|0[0-9][0-9][0-9][0-9][0-9].{36}))|7(?:2(?:8(?:[05][0-9][0-9][0-9][0-9].{56}|1[0-9][0-9][0-9][0-9].{356}|3[0-9][0-9][0-9][0-9].{172}|7[0-9][0-9][0-9][0-9].{340}|2[0-9][0-9][0-9][0-9].{52}|4[0-9][0-9][0-9][0-9].{88}|6[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{84}|9[0-9][0-9][0-9][0-9].{44})|4(?:[23][0-9][0-9][0-9][0-9].{108}|[4-6][0-9][0-9][0-9][0-9].{48}|[89][0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{8})|9(?:[5-8][0-9][0-9][0-9][0-9].{36}|[49][0-9][0-9][0-9][0-9].{56}|0[0-9][0-9][0-9][0-9].{88}|2[0-9][0-9][0-9][0-9].{52}|3[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{8})|6(?:[24-7][0-9][0-9][0-9][0-9].{28}|[01][0-9][0-9][0-9][0-9].{128}|8[0-9][0-9][0-9][0-9].{652}|3[0-9][0-9][0-9][0-9].{20}|9[0-9][0-9][0-9][0-9].{40})|5(?:[2-4689][0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{80}|1[0-9][0-9][0-9][0-9].{56}|5[0-9][0-9][0-9][0-9].{52})|2(?:[5689][0-9][0-9][0-9][0-9].{44}|[2-4][0-9][0-9][0-9][0-9].{68}|[01][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{304})|7(?:[5-9][0-9][0-9][0-9][0-9].{28}|[01][0-9][0-9][0-9][0-9].{168}|[23][0-9][0-9][0-9][0-9].{52}|4[0-9][0-9][0-9][0-9].{12})|1(?:[16-9][0-9][0-9][0-9][0-9].{12}|[3-5][0-9][0-9][0-9][0-9].{40}|2[0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9].{4})|3(?:[0-35-7][0-9][0-9][0-9][0-9].{44}|8[0-9][0-9][0-9][0-9].{108}|4[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{28})|0[0-9][0-9][0-9][0-9][0-9].{4})|4(?:2(?:[01][0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{112}|9[0-9][0-9][0-9][0-9].{316}|2[0-9][0-9][0-9][0-9].{56}|4[0-9][0-9][0-9][0-9].{44}|5[0-9][0-9][0-9][0-9].{88}|6[0-9][0-9][0-9][0-9].{40}|7[0-9][0-9][0-9][0-9].{12})|0(?:[1569][0-9][0-9][0-9][0-9].{28}|[23][0-9][0-9][0-9][0-9].{108}|7[0-9][0-9][0-9][0-9].{244}|8[0-9][0-9][0-9][0-9].{460}|4[0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{8})|9(?:[0-3][0-9][0-9][0-9][0-9].{60}|[78][0-9][0-9][0-9][0-9].{36}|5[0-9][0-9][0-9][0-9].{376}|4[0-9][0-9][0-9][0-9].{56}|6[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{40})|8(?:[6-9][0-9][0-9][0-9][0-9].{60}|[013][0-9][0-9][0-9][0-9].{56}|2[0-9][0-9][0-9][0-9].{164}|4[0-9][0-9][0-9][0-9].{216}|5[0-9][0-9][0-9][0-9].{416})|3(?:[3-8][0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{372}|2[0-9][0-9][0-9][0-9].{288}|9[0-9][0-9][0-9][0-9].{112}|0[0-9][0-9][0-9][0-9].{88})|7(?:[89][0-9][0-9][0-9][0-9].{56}|4[0-9][0-9][0-9][0-9].{212}|6[0-9][0-9][0-9][0-9].{168}|5[0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{28})|1(?:[2-7][0-9][0-9][0-9][0-9].{36}|[89][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{124}|1[0-9][0-9][0-9][0-9].{196})|4(?:[014-6][0-9][0-9][0-9][0-9].{8}|[23][0-9][0-9][0-9][0-9].{40}|7[0-9][0-9][0-9][0-9].{100}))|3(?:8(?:[08][0-9][0-9][0-9][0-9].{84}|[67][0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{404}|9[0-9][0-9][0-9][0-9].{104}|1[0-9][0-9][0-9][0-9].{56}|2[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{52}|5[0-9][0-9][0-9][0-9].{88})|7(?:[27][0-9][0-9][0-9][0-9].{136}|[689][0-9][0-9][0-9][0-9].{36}|[01][0-9][0-9][0-9][0-9].{28}|[34][0-9][0-9][0-9][0-9].{52}|5[0-9][0-9][0-9][0-9].{252})|9(?:[4-7][0-9][0-9][0-9][0-9].{36}|[0-2][0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{180}|3[0-9][0-9][0-9][0-9].{52}|8[0-9][0-9][0-9][0-9].{80})|2(?:[1-489][0-9][0-9][0-9][0-9].{44}|5[0-9][0-9][0-9][0-9].{104}|6[0-9][0-9][0-9][0-9].{116}|0[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{28})|5(?:[37-9][0-9][0-9][0-9][0-9].{28}|[0-2][0-9][0-9][0-9][0-9].{36}|[56][0-9][0-9][0-9][0-9].{128}|4[0-9][0-9][0-9][0-9].{408})|1(?:[4-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{104}|3[0-9][0-9][0-9][0-9].{40})|4(?:[0-4][0-9][0-9][0-9][0-9].{44}|[6-9][0-9][0-9][0-9][0-9].{48}|5[0-9][0-9][0-9][0-9].{108})|6(?:[014-9][0-9][0-9][0-9][0-9].{28}|3[0-9][0-9][0-9][0-9].{136}|2[0-9][0-9][0-9][0-9].{56})|3[0-9][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9][0-9].{4})|0(?:8(?:[1-6][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{36})|4(?:[3-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{28})|9(?:[015-8][0-9][0-9][0-9][0-9].{12}|[2-4][0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{52})|0(?:[4-9][0-9][0-9][0-9][0-9].{8}|[1-3][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{16})|2(?:[2-8][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{32})|5(?:[0-7][0-9][0-9][0-9][0-9].{20}|[89][0-9][0-9][0-9][0-9].{12})|6(?:[4-9][0-9][0-9][0-9][0-9].{4}|[0-3][0-9][0-9][0-9][0-9].{12})|7(?:[0-8][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{4})|3[0-9][0-9][0-9][0-9][0-9].{32}|1[0-9][0-9][0-9][0-9][0-9].{8})|1(?:4(?:[6-9][0-9][0-9][0-9][0-9].{20}|[0-2][0-9][0-9][0-9][0-9].{28}|[3-5][0-9][0-9][0-9][0-9].{12})|1(?:[0-46-8][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{40})|5(?:[0-5][0-9][0-9][0-9][0-9].{20}|[6-9][0-9][0-9][0-9][0-9].{12})|6(?:[2-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{20})|8(?:[0-57-9][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{36})|9(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12})|[23][0-9][0-9][0-9][0-9][0-9].{32}|7[0-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9][0-9].{8})|5(?:2(?:[147][0-9][0-9][0-9][0-9].{56}|[356][0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{124}|0[0-9][0-9][0-9][0-9].{44}|2[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{40})|4(?:[2-4][0-9][0-9][0-9][0-9].{40}|[16][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{928}|5[0-9][0-9][0-9][0-9].{44})|0(?:[1-5][0-9][0-9][0-9][0-9].{28}|[6-9][0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9].{128})|1(?:[4-689][0-9][0-9][0-9][0-9].{56}|[0-3][0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{244})|3[0-9][0-9][0-9][0-9][0-9].{36})|9(?:0(?:[0-7][0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{40})|10[0-9][0-9][0-9][0-9].{272}))|2(?:0(?:0(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{708})|2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{204})|5(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{380})|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{200})|7(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{200})|8(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{140})|1(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{48})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|9(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|3(?:[0-9][0-9][0-9][0-9][0-9]|_____).{4})|1(?:1(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{140})|3(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{200})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{204})|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{172})|9(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{100})|0(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{48})|5(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{80})|7(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{16})|8(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|2(?:[0-9][0-9][0-9][0-9][0-9]|_____).{4})|8(?:0(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{668})|2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{204})|3(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{140})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{140})|5(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{204})|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{140})|8(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{880})|9(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{204})|7(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|1[0-9][0-9][0-9][0-9][0-9].{4})|5(?:(?:8(?:[0-9][0-9][0-9][0-9][0-9]|_____)|5[0-9][0-9][0-9][0-9][0-9]).{4}|0(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{836})|2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{172})|3(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{140})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{140})|7(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{140})|9(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{140})|1(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8}))|3(?:(?:7(?:[0-9][0-9][0-9][0-9][0-9]|_____)|8[0-9][0-9][0-9][0-9][0-9]).{4}|0(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{100})|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{140})|9(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{204})|2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{24})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{48})|5(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{48})|1(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|3(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8}))|7(?:1(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{140})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{140})|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{204})|7(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{100})|8(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{100})|9(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{204})|0(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{48})|2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{48})|[35](?:[0-9][0-9][0-9][0-9][0-9]|_____).{4})|2(?:6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{216})|7(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{176})|1(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{16})|5(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{48})|8(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{48})|2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|9(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|[03](?:[0-9][0-9][0-9][0-9][0-9]|_____).{4})|4(?:2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{164})|7(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{176})|8(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{172})|9(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{368})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{16})|[0135](?:[0-9][0-9][0-9][0-9][0-9]|_____).{4}|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8}))|6(?:(?:[06](?:[0-9][0-9][0-9][0-9][0-9]|_____)|[139][0-9][0-9][0-9][0-9][0-9]).{4}|5(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{204})|7(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{380})|8(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{204})|2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{48})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{48}))|9(?:(?:2(?:[0-9][0-9][0-9][0-9][0-9]|_____)|[15-8][0-9][0-9][0-9][0-9][0-9]).{4}|0(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{380})|3(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{204})|9(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{100})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{24})))|4(?:5(?:6(?:[4689][0-9][0-9][0-9][0-9].{20}|[2357][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{16}|_____.{216})|0(?:[0135-7][0-9][0-9][0-9][0-9].{16}|[248][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{32}|_____.{48})|1(?:[02-5][0-9][0-9][0-9][0-9].{16}|[17-9][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{12})|4(?:[0-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{80}|_____.{240})|5(?:[0-579][0-9][0-9][0-9][0-9].{8}|[68][0-9][0-9][0-9][0-9].{20})|7(?:[4-9][0-9][0-9][0-9][0-9].{8}|[0-3][0-9][0-9][0-9][0-9].{20})|2(?:[0-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{340})|8(?:[0-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{12})|9[0-9][0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9][0-9].{8})|4(?:0(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{204})|2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{100})|3(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{344})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{140})|5(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{100})|7(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{200})|[1689][0-9][0-9][0-9][0-9][0-9].{4})|3(?:4_____.{176}|6_____.{240}|0_____.{48}|3_____.{8}|5_____.{4})|9(?:[3-7]_____.{308}|1_____.{164}|9_____.{4})|2(?:2_____.{472}|0_____.{4}|4_____.{8})|1(?:0_____.{140}|1_____.{4})|04_____.{176}|88_____.{472})|9(?:1(?:(?:[29](?:[0-9][0-9][0-9][0-9][0-9]|_____)|8[0-9][0-9][0-9][0-9][0-9]).{4}|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{240})|5(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{776})|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{148})|1(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{48})|3(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{24})|7(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{24})|0(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8}))|0(?:(?:[01379](?:[0-9][0-9][0-9][0-9][0-9]|_____)|8[0-9][0-9][0-9][0-9][0-9]).{4}|2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{140})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{164})|5(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8}))|3(?:[26]_____.{48}|[35]_____.{4}|0_____.{512}|1_____.{120}|7_____.{204}|9_____.{8})|2(?:[09]_____.{8}|1_____.{148}|2_____.{472}|3_____.{748}|4_____.{24}|7_____.{4})|9(?:[12]_____.{8}|7_____.{828}|9_____.{176}|0_____.{40}|5_____.{48}|4_____.{4})|4(?:[36]_____.{368}|[04]_____.{4}|5_____.{176}|8_____.{216}|9_____.{48})|7(?:[05-7]_____.{4}|[19]_____.{120}|3_____.{216})|5(?:[57]_____.{4}|9_____.{368}|0_____.{60})|8(?:[09]_____.{4}|1_____.{216}|8_____.{8})|6(?:0_____.{120}|9_____.{176}|6_____.{4}))|1(?:0(?:9(?:[17-9][0-9][0-9][0-9][0-9].{12}|[346][0-9][0-9][0-9][0-9].{28}|[25][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{236})|3(?:[2-6][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{16}|[7-9][0-9][0-9][0-9][0-9].{8}|_____.{4})|4(?:[1-46-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{56})|0(?:[0-6][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{8}|_____.{20})|6(?:[1-689][0-9][0-9][0-9][0-9].{8}|[07][0-9][0-9][0-9][0-9].{12}|_____.{20})|7(?:[0-4][0-9][0-9][0-9][0-9].{12}|[5-9][0-9][0-9][0-9][0-9].{32})|2(?:[2-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{8})|5(?:[2-9][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{12})|1(?:[0-9][0-9][0-9][0-9][0-9].{8}|_____.{140})|8[0-9][0-9][0-9][0-9][0-9].{32})|1(?:[023]_____.{4}|[17]_____.{8}|6_____.{48})|3(?:[12]_____.{4}|0_____.{20})|2(?:[01]_____.{4}|3_____.{8})|55_____.{4}|90_____.{8})|39(?:2(?:[2-4][0-9][0-9][0-9][0-9].{48}|[589][0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{108}|7[0-9][0-9][0-9][0-9].{128}|0[0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{36})|0(?:[57-9][0-9][0-9][0-9][0-9].{44}|[01][0-9][0-9][0-9][0-9].{12}|[46][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{212}|2[0-9][0-9][0-9][0-9].{8})|4(?:[2-8][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{212}|1[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{56})|7(?:2[0-9][0-9][0-9][0-9].{132}|0[0-9][0-9][0-9][0-9].{52}|1[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{8})|8(?:[4-7][0-9][0-9][0-9][0-9].{36}|[028][0-9][0-9][0-9][0-9].{84}|[139][0-9][0-9][0-9][0-9].{56})|3(?:[1-8][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{212}|9[0-9][0-9][0-9][0-9].{52})|1(?:[2-9][0-9][0-9][0-9][0-9].{44}|[01][0-9][0-9][0-9][0-9].{388})|50[0-9][0-9][0-9][0-9].{340}|90[0-9][0-9][0-9][0-9].{80})|0(?:0(?:[0157]_____.{4}|[49]_____.{8}|2_____.{24})|3(?:[256]_____.{4}|[03]_____.{8}|1_____.{48})|2(?:[023]_____.{8}|[56]_____.{4})|1(?:[05]_____.{4}|7_____.{140})|9(?:0_____.{24}|9_____.{8})|5(?:0_____.{4}|5_____.{8})|(?:8[079]|60)_____.{4}|[47]0_____.{8})|8[0-9][0-9][0-9][0-9][0-9][0-9][0-9].{4})|4(?:8(?:4(?:3(?:[26][0-9][0-9][0-9][0-9].{108}|[7-9][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{104}|1[0-9][0-9][0-9][0-9].{232}|4[0-9][0-9][0-9][0-9].{148}|3[0-9][0-9][0-9][0-9].{40}|5[0-9][0-9][0-9][0-9].{12})|8(?:[379][0-9][0-9][0-9][0-9].{28}|[45][0-9][0-9][0-9][0-9].{52}|1[0-9][0-9][0-9][0-9].{460}|2[0-9][0-9][0-9][0-9].{136}|6[0-9][0-9][0-9][0-9].{236}|8[0-9][0-9][0-9][0-9].{304}|0[0-9][0-9][0-9][0-9].{84})|4(?:[1-5][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{288}|6[0-9][0-9][0-9][0-9].{332}|7[0-9][0-9][0-9][0-9].{108}|8[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{28})|9(?:[2-7][0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{648}|9[0-9][0-9][0-9][0-9].{212}|0[0-9][0-9][0-9][0-9].{68}|8[0-9][0-9][0-9][0-9].{84})|5(?:[35-9][0-9][0-9][0-9][0-9].{60}|0[0-9][0-9][0-9][0-9].{100}|1[0-9][0-9][0-9][0-9].{28}|4[0-9][0-9][0-9][0-9].{52}|2[0-9][0-9][0-9][0-9].{8})|2(?:[0-4][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{104}|5[0-9][0-9][0-9][0-9].{28}|6[0-9][0-9][0-9][0-9].{8})|7(?:[0-3578][0-9][0-9][0-9][0-9].{60}|9[0-9][0-9][0-9][0-9].{372}|4[0-9][0-9][0-9][0-9].{52}|6[0-9][0-9][0-9][0-9].{12})|1(?:[5-9][0-9][0-9][0-9][0-9].{40}|[0-2][0-9][0-9][0-9][0-9].{4}|[34][0-9][0-9][0-9][0-9].{8})|6[0-9][0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9][0-9].{4})|6(?:8(?:[38][0-9][0-9][0-9][0-9].{132}|[59][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{228}|4[0-9][0-9][0-9][0-9].{260}|6[0-9][0-9][0-9][0-9].{320}|7[0-9][0-9][0-9][0-9].{104}|1[0-9][0-9][0-9][0-9].{40}|2[0-9][0-9][0-9][0-9].{12})|2(?:[57-9][0-9][0-9][0-9][0-9].{24}|[26][0-9][0-9][0-9][0-9].{80}|[34][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{40})|1(?:[03-5][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{156}|2[0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{80})|0(?:[02-5][0-9][0-9][0-9][0-9].{8}|[78][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{56}|6[0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{12})|6(?:[2-59][0-9][0-9][0-9][0-9].{8}|[07][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{80}|8[0-9][0-9][0-9][0-9].{52})|4(?:[1-49][0-9][0-9][0-9][0-9].{8}|[6-8][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{24})|9(?:[013479][0-9][0-9][0-9][0-9].{8}|[25][0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{16})|7(?:[1-578][0-9][0-9][0-9][0-9].{8}|[069][0-9][0-9][0-9][0-9].{12})|3(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|5(?:[0-57-9][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{8}))|3(?:8(?:[08][0-9][0-9][0-9][0-9].{12}|[34][0-9][0-9][0-9][0-9].{80}|[5-7][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{132}|2[0-9][0-9][0-9][0-9].{104}|9[0-9][0-9][0-9][0-9].{40})|5(?:[045][0-9][0-9][0-9][0-9].{40}|[1-3][0-9][0-9][0-9][0-9].{32}|6[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{84}|9[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{8})|4(?:[6-9][0-9][0-9][0-9][0-9].{32}|[01][0-9][0-9][0-9][0-9].{16}|[45][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{100}|2[0-9][0-9][0-9][0-9].{8})|3(?:[124-69][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{100}|0[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{80})|9(?:[0-2458][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{108}|3[0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{84}|9[0-9][0-9][0-9][0-9].{8})|0(?:[1-4][0-9][0-9][0-9][0-9].{16}|[57-9][0-9][0-9][0-9][0-9].{8}|[06][0-9][0-9][0-9][0-9].{12})|2(?:[2-5][0-9][0-9][0-9][0-9].{12}|[6-9][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{16})|7(?:[0-246-9][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{104}|3[0-9][0-9][0-9][0-9].{52})|6(?:[0-4][0-9][0-9][0-9][0-9].{12}|[5-9][0-9][0-9][0-9][0-9].{20})|1(?:[0-24-6][0-9][0-9][0-9][0-9].{8}|[37-9][0-9][0-9][0-9][0-9].{12}))|2(?:7(?:[0-3][0-9][0-9][0-9][0-9].{60}|[89][0-9][0-9][0-9][0-9].{172}|4[0-9][0-9][0-9][0-9].{404}|5[0-9][0-9][0-9][0-9].{248}|7[0-9][0-9][0-9][0-9].{128}|6[0-9][0-9][0-9][0-9].{12})|8(?:[579][0-9][0-9][0-9][0-9].{136}|[2-4][0-9][0-9][0-9][0-9].{52}|6[0-9][0-9][0-9][0-9].{116}|0[0-9][0-9][0-9][0-9].{24}|1[0-9][0-9][0-9][0-9].{84}|8[0-9][0-9][0-9][0-9].{12})|9(?:[3-7][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{136}|2[0-9][0-9][0-9][0-9].{52}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{8})|5(?:[5-9][0-9][0-9][0-9][0-9].{60}|[01][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{28}|4[0-9][0-9][0-9][0-9].{68})|3(?:[3-9][0-9][0-9][0-9][0-9].{40}|0[0-9][0-9][0-9][0-9].{412}|2[0-9][0-9][0-9][0-9].{52}|1[0-9][0-9][0-9][0-9].{8})|0(?:[013-6][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{136})|2(?:[0-7][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{428}|8[0-9][0-9][0-9][0-9].{8})|4(?:[2-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{40})|6(?:[013-9][0-9][0-9][0-9][0-9].{60}|2[0-9][0-9][0-9][0-9].{52})|1[0-9][0-9][0-9][0-9][0-9].{4})|8(?:5(?:[1-39][0-9][0-9][0-9][0-9].{20}|[67][0-9][0-9][0-9][0-9].{12}|[45][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{16})|6(?:[1459][0-9][0-9][0-9][0-9].{8}|[6-8][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{128}|2[0-9][0-9][0-9][0-9].{88}|3[0-9][0-9][0-9][0-9].{40})|1(?:[1268][0-9][0-9][0-9][0-9].{16}|[045][0-9][0-9][0-9][0-9].{8}|[79][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{32})|2(?:[018][0-9][0-9][0-9][0-9].{16}|[4-6][0-9][0-9][0-9][0-9].{20}|[279][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{40})|0(?:[03-589][0-9][0-9][0-9][0-9].{8}|[26][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{40})|8(?:[0-3][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{32}|[4-6][0-9][0-9][0-9][0-9].{8})|3(?:[0-58][0-9][0-9][0-9][0-9].{16}|[79][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{184})|7(?:[1-378][0-9][0-9][0-9][0-9].{12}|[4-69][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{84})|4(?:[0-4][0-9][0-9][0-9][0-9].{8}|[5-79][0-9][0-9][0-9][0-9].{20}|8[0-9][0-9][0-9][0-9].{16})|9(?:[1-8][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{32}))|9(?:6(?:[3-5][0-9][0-9][0-9][0-9].{20}|[02][0-9][0-9][0-9][0-9].{12}|[6-8][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{104}|9[0-9][0-9][0-9][0-9].{16})|5(?:[46-8][0-9][0-9][0-9][0-9].{16}|[0-2][0-9][0-9][0-9][0-9].{24}|5[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{20}|3[0-9][0-9][0-9][0-9].{8})|1(?:[01458][0-9][0-9][0-9][0-9].{8}|[369][0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{32}|7[0-9][0-9][0-9][0-9].{12})|2(?:[12459][0-9][0-9][0-9][0-9].{8}|[6-8][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{88})|3(?:[014-6][0-9][0-9][0-9][0-9].{8}|[7-9][0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9].{48}|3[0-9][0-9][0-9][0-9].{44})|9(?:[046-9][0-9][0-9][0-9][0-9].{8}|[25][0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{12})|7(?:[1247-9][0-9][0-9][0-9][0-9].{8}|[03][0-9][0-9][0-9][0-9].{12}|[56][0-9][0-9][0-9][0-9].{16})|8(?:[0135-8][0-9][0-9][0-9][0-9].{12}|[29][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{184})|0(?:[02358][0-9][0-9][0-9][0-9].{8}|[1467][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{40})|4[0-9][0-9][0-9][0-9][0-9].{24})|1(?:4(?:[4-6][0-9][0-9][0-9][0-9].{116}|[0-2][0-9][0-9][0-9][0-9].{32}|[78][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{36})|6(?:[0-5][0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{84}|9[0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{8})|0(?:[0-5][0-9][0-9][0-9][0-9].{8}|[78][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{292}|9[0-9][0-9][0-9][0-9].{112})|1(?:[2-5][0-9][0-9][0-9][0-9].{56}|[018][0-9][0-9][0-9][0-9].{8}|[67][0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{32})|8(?:[1-69][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{108}|0[0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{40})|9(?:[2-8][0-9][0-9][0-9][0-9].{12}|[09][0-9][0-9][0-9][0-9].{192}|1[0-9][0-9][0-9][0-9].{52})|3(?:[013469][0-9][0-9][0-9][0-9].{12}|[2578][0-9][0-9][0-9][0-9].{32})|5(?:[0-46-9][0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9].{32})|7(?:[1-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{44})|2[0-9][0-9][0-9][0-9][0-9].{32})|0(?:9(?:[4-68][0-9][0-9][0-9][0-9].{52}|[23][0-9][0-9][0-9][0-9].{104}|9[0-9][0-9][0-9][0-9].{192}|0[0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{8})|3(?:[3-6][0-9][0-9][0-9][0-9].{12}|[79][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{32}|1[0-9][0-9][0-9][0-9].{88}|2[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{40})|8(?:[35-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{52}|2[0-9][0-9][0-9][0-9].{288}|4[0-9][0-9][0-9][0-9].{40})|1(?:[0-245][0-9][0-9][0-9][0-9].{8}|[7-9][0-9][0-9][0-9][0-9].{32}|3[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{28})|7(?:[016-8][0-9][0-9][0-9][0-9].{12}|[2-5][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{52})|4(?:[0-8][0-9][0-9][0-9][0-9].{20}|9[0-9][0-9][0-9][0-9].{12})|2[0-9][0-9][0-9][0-9][0-9].{32}|5[0-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9][0-9].{4})|7(?:9(?:[1-3][0-9][0-9][0-9][0-9].{124}|[56][0-9][0-9][0-9][0-9].{252}|[78][0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{288}|0[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{8})|2(?:[126][0-9][0-9][0-9][0-9].{56}|[3-5][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{136}|7[0-9][0-9][0-9][0-9].{404}|8[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{20})|0(?:[5-9][0-9][0-9][0-9][0-9].{36}|[2-4][0-9][0-9][0-9][0-9].{264}|[01][0-9][0-9][0-9][0-9].{112})|8(?:8[0-9][0-9][0-9][0-9].{136}|9[0-9][0-9][0-9][0-9].{316})|3[0-2][0-9][0-9][0-9][0-9].{252}|1[0-9][0-9][0-9][0-9][0-9].{36})|5(?:4(?:[02][0-9][0-9][0-9][0-9].{56}|1[0-9][0-9][0-9][0-9].{404}|3[0-9][0-9][0-9][0-9].{272}|5[0-9][0-9][0-9][0-9].{136}|4[0-9][0-9][0-9][0-9].{84})|0(?:[0-3][0-9][0-9][0-9][0-9].{40}|[6-9][0-9][0-9][0-9][0-9].{60}|[45][0-9][0-9][0-9][0-9].{12})|8(?:[08][0-9][0-9][0-9][0-9].{84}|[67][0-9][0-9][0-9][0-9].{56}|5[0-9][0-9][0-9][0-9].{136})|1(?:[0-8][0-9][0-9][0-9][0-9].{60}|9[0-9][0-9][0-9][0-9].{108})|2(?:[0-8][0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{28})|3(?:0[0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{88})|75[0-9][0-9][0-9][0-9].{136}))|2(?:2(?:6(?:[17][0-9][0-9][0-9][0-9].{196}|[06][0-9][0-9][0-9][0-9].{56}|2[0-9][0-9][0-9][0-9].{136}|5[0-9][0-9][0-9][0-9].{468}|8[0-9][0-9][0-9][0-9].{316}|9[0-9][0-9][0-9][0-9].{156}|3[0-9][0-9][0-9][0-9].{44}|4[0-9][0-9][0-9][0-9].{36})|8(?:[89][0-9][0-9][0-9][0-9].{56}|2[0-9][0-9][0-9][0-9].{112}|6[0-9][0-9][0-9][0-9].{516}|1[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{88}|4[0-9][0-9][0-9][0-9].{84}|7[0-9][0-9][0-9][0-9].{68}|0[0-9][0-9][0-9][0-9].{8})|7(?:[08][0-9][0-9][0-9][0-9].{112}|[14][0-9][0-9][0-9][0-9].{88}|[67][0-9][0-9][0-9][0-9].{36}|[39][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{124}|5[0-9][0-9][0-9][0-9].{288})|1(?:[12][0-9][0-9][0-9][0-9].{116}|[78][0-9][0-9][0-9][0-9].{108}|[34][0-9][0-9][0-9][0-9].{28}|[06][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{80}|9[0-9][0-9][0-9][0-9].{44})|5(?:[34][0-9][0-9][0-9][0-9].{128}|[67][0-9][0-9][0-9][0-9].{28}|[89][0-9][0-9][0-9][0-9].{56}|1[0-9][0-9][0-9][0-9].{408}|2[0-9][0-9][0-9][0-9].{392}|5[0-9][0-9][0-9][0-9].{48})|2(?:[4-9][0-9][0-9][0-9][0-9].{60}|0[0-9][0-9][0-9][0-9].{212}|2[0-9][0-9][0-9][0-9].{236}|3[0-9][0-9][0-9][0-9].{52}|1[0-9][0-9][0-9][0-9].{8})|3(?:[3-7][0-9][0-9][0-9][0-9].{48}|[01][0-9][0-9][0-9][0-9].{60}|[89][0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9].{52})|4(?:[6-9][0-9][0-9][0-9][0-9].{28}|[01][0-9][0-9][0-9][0-9].{36}|[2-4][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{56})|9(?:[0-26-9][0-9][0-9][0-9][0-9].{68}|[3-5][0-9][0-9][0-9][0-9].{168})|0(?:[0-7][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{40}))|8(?:6(?:[01][0-9][0-9][0-9][0-9].{412}|[48][0-9][0-9][0-9][0-9].{56}|2[0-9][0-9][0-9][0-9].{444}|3[0-9][0-9][0-9][0-9].{164}|5[0-9][0-9][0-9][0-9].{216}|6[0-9][0-9][0-9][0-9].{416}|9[0-9][0-9][0-9][0-9].{436}|7[0-9][0-9][0-9][0-9].{24})|8(?:[568][0-9][0-9][0-9][0-9].{136}|[34][0-9][0-9][0-9][0-9].{40}|0[0-9][0-9][0-9][0-9].{392}|7[0-9][0-9][0-9][0-9].{340}|1[0-9][0-9][0-9][0-9].{88}|2[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{8})|7(?:[1-49][0-9][0-9][0-9][0-9].{56}|0[0-9][0-9][0-9][0-9].{376}|6[0-9][0-9][0-9][0-9].{112}|7[0-9][0-9][0-9][0-9].{272}|5[0-9][0-9][0-9][0-9].{80}|8[0-9][0-9][0-9][0-9].{88})|0(?:[089][0-9][0-9][0-9][0-9].{108}|[5-7][0-9][0-9][0-9][0-9].{180}|[23][0-9][0-9][0-9][0-9].{44}|1[0-9][0-9][0-9][0-9].{148}|4[0-9][0-9][0-9][0-9].{28})|2(?:[0-3][0-9][0-9][0-9][0-9].{44}|[4-6][0-9][0-9][0-9][0-9].{48}|7[0-9][0-9][0-9][0-9].{372}|8[0-9][0-9][0-9][0-9].{212}|9[0-9][0-9][0-9][0-9].{28})|3(?:[05-79][0-9][0-9][0-9][0-9].{28}|[2-4][0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{196}|8[0-9][0-9][0-9][0-9].{128})|4(?:[0-289][0-9][0-9][0-9][0-9].{28}|[67][0-9][0-9][0-9][0-9].{168}|4[0-9][0-9][0-9][0-9].{112}|5[0-9][0-9][0-9][0-9].{40})|1(?:[3-9][0-9][0-9][0-9][0-9].{44}|[12][0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{100})|5(?:[0-5][0-9][0-9][0-9][0-9].{28}|[6-9][0-9][0-9][0-9][0-9].{68})|9[0-9][0-9][0-9][0-9][0-9].{264})|6(?:7(?:[457][0-9][0-9][0-9][0-9].{40}|[0-2][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{128}|3[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{20})|8(?:[3-579][0-9][0-9][0-9][0-9].{24}|[026][0-9][0-9][0-9][0-9].{60}|1[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{56})|6(?:[0-267][0-9][0-9][0-9][0-9].{8}|[3-5][0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{32})|4(?:[0-3578][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{104}|4[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{80})|2(?:[0-248][0-9][0-9][0-9][0-9].{8}|[5-7][0-9][0-9][0-9][0-9].{32}|[39][0-9][0-9][0-9][0-9].{12})|0(?:[04-9][0-9][0-9][0-9][0-9].{8}|[12][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{32})|9(?:[1-57-9][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{40})|5(?:[1-57-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{80})|1(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|3(?:[0-57-9][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{12}))|7(?:8(?:[027][0-9][0-9][0-9][0-9].{8}|[19][0-9][0-9][0-9][0-9].{40}|[56][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{132}|4[0-9][0-9][0-9][0-9].{48}|8[0-9][0-9][0-9][0-9].{24})|7(?:[6-9][0-9][0-9][0-9][0-9].{8}|[13][0-9][0-9][0-9][0-9].{16}|[24][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{88})|3(?:[0-4][0-9][0-9][0-9][0-9].{20}|[68][0-9][0-9][0-9][0-9].{12}|[79][0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{8})|1(?:[0589][0-9][0-9][0-9][0-9].{12}|[1346][0-9][0-9][0-9][0-9].{8}|[27][0-9][0-9][0-9][0-9].{16})|0(?:[035-9][0-9][0-9][0-9][0-9].{16}|[12][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{184})|4(?:[0-589][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{16})|2(?:[0-35][0-9][0-9][0-9][0-9].{16}|[46-9][0-9][0-9][0-9][0-9].{20})|5(?:[0-689][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{16})|6(?:[0-689][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{16})|9[0-9][0-9][0-9][0-9][0-9].{16})|0(?:1(?:5[0-9][0-9][0-9][0-9].{128}|7[0-9][0-9][0-9][0-9].{356}|0[0-9][0-9][0-9][0-9].{24}|1[0-9][0-9][0-9][0-9].{48}|2[0-9][0-9][0-9][0-9].{44}|3[0-9][0-9][0-9][0-9].{28}|4[0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{56})|5(?:6[0-9][0-9][0-9][0-9].{124}|8[0-9][0-9][0-9][0-9].{112}|9[0-9][0-9][0-9][0-9].{136}|5[0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{8})|0(?:[0-46][0-9][0-9][0-9][0-9].{8}|[58][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{4})|9[45][0-9][0-9][0-9][0-9].{16}|30[0-9][0-9][0-9][0-9].{12}|40[0-9][0-9][0-9][0-9].{52}|61[0-9][0-9][0-9][0-9].{20}|88[0-9][0-9][0-9][0-9].{84}|20[0-9][0-9][0-9][0-9].{8})|31[12][0-9][0-9][0-9][0-9].{272})|6(?:5(?:3(?:[02][0-9][0-9][0-9][0-9].{56}|1[0-9][0-9][0-9][0-9].{576}|3[0-9][0-9][0-9][0-9].{140}|7[0-9][0-9][0-9][0-9].{484}|4[0-9][0-9][0-9][0-9].{48}|5[0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{8})|7(?:[3-7][0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{124}|2[0-9][0-9][0-9][0-9].{252}|8[0-9][0-9][0-9][0-9].{756}|9[0-9][0-9][0-9][0-9].{412}|0[0-9][0-9][0-9][0-9].{56})|2(?:[01][0-9][0-9][0-9][0-9].{168}|[689][0-9][0-9][0-9][0-9].{56}|[23][0-9][0-9][0-9][0-9].{28}|[45][0-9][0-9][0-9][0-9].{68}|7[0-9][0-9][0-9][0-9].{348})|0(?:[1-389][0-9][0-9][0-9][0-9].{28}|[45][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{240}|7[0-9][0-9][0-9][0-9].{128}|0[0-9][0-9][0-9][0-9].{56})|6(?:5[0-9][0-9][0-9][0-9].{340}|6[0-9][0-9][0-9][0-9].{196}|7[0-9][0-9][0-9][0-9].{112}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{56})|8(?:3[0-9][0-9][0-9][0-9].{112}|4[0-9][0-9][0-9][0-9].{100}|0[0-9][0-9][0-9][0-9].{56}|2[0-9][0-9][0-9][0-9].{88}|1[0-9][0-9][0-9][0-9].{8})|1(?:[3-8][0-9][0-9][0-9][0-9].{68}|2[0-9][0-9][0-9][0-9].{244}|9[0-9][0-9][0-9][0-9].{168}|0[0-9][0-9][0-9][0-9].{28})|4(?:0[0-9][0-9][0-9][0-9].{112}|1[0-9][0-9][0-9][0-9].{196}|2[0-9][0-9][0-9][0-9].{316}|3[0-9][0-9][0-9][0-9].{272}))|3(?:6(?:[2-46][0-9][0-9][0-9][0-9].{8}|[7-9][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{32}|1[0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{40})|5(?:[0246-8][0-9][0-9][0-9][0-9].{24}|1[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9].{8})|3(?:[05-7][0-9][0-9][0-9][0-9].{12}|[489][0-9][0-9][0-9][0-9].{24}|[13][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{16})|0(?:[236-9][0-9][0-9][0-9][0-9].{8}|[45][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{80})|7(?:[16-9][0-9][0-9][0-9][0-9].{8}|[235][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9].{24})|4(?:[25-9][0-9][0-9][0-9][0-9].{24}|[014][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{16})|2(?:[0-24-9][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{16})|[18][0-9][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9][0-9].{16})|9(?:7(?:[3479][0-9][0-9][0-9][0-9].{12}|[12][0-9][0-9][0-9][0-9].{16}|[568][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40})|9(?:[1-57][0-9][0-9][0-9][0-9].{8}|[09][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{100}|8[0-9][0-9][0-9][0-9].{300})|6(?:[1-6][0-9][0-9][0-9][0-9].{12}|[78][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{16})|4(?:[0-7][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{8})|5(?:[4-9][0-9][0-9][0-9][0-9].{12}|[0-3][0-9][0-9][0-9][0-9].{16})|1(?:[4-9][0-9][0-9][0-9][0-9].{8}|[0-3][0-9][0-9][0-9][0-9].{24})|3(?:[0-7][0-9][0-9][0-9][0-9].{8}|[89][0-9][0-9][0-9][0-9].{40})|8(?:[1-7][0-9][0-9][0-9][0-9].{8}|[089][0-9][0-9][0-9][0-9].{12})|0[0-9][0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9][0-9].{8})|[6-8][0-9][0-9][0-9][0-9][0-9][0-9].{4})|1(?:1(?:6(?:[23][0-9][0-9][0-9][0-9].{104}|[578][0-9][0-9][0-9][0-9].{40}|[01][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{8})|8(?:[024-6][0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{116}|1[0-9][0-9][0-9][0-9].{52}|8[0-9][0-9][0-9][0-9].{84}|9[0-9][0-9][0-9][0-9].{88}|3[0-9][0-9][0-9][0-9].{8})|9(?:[4-6][0-9][0-9][0-9][0-9].{108}|[028][0-9][0-9][0-9][0-9].{84}|[79][0-9][0-9][0-9][0-9].{48}|1[0-9][0-9][0-9][0-9].{52}|3[0-9][0-9][0-9][0-9].{28})|7(?:[02-4][0-9][0-9][0-9][0-9].{12}|[69][0-9][0-9][0-9][0-9].{44}|[57][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{116}|1[0-9][0-9][0-9][0-9].{52})|3(?:[35-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{20}|2[0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{44})|1(?:[1-7][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{32}|8[0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{40})|4(?:[0-7][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{4})|0[0-9][0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9][0-9].{4})|3(?:4(?:[4-9][0-9][0-9][0-9][0-9].{32}|0[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{52}|2[0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{8})|3(?:[0-24][0-9][0-9][0-9][0-9].{12}|[6-9][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{100}|5[0-9][0-9][0-9][0-9].{300})|6(?:[0-2479][0-9][0-9][0-9][0-9].{12}|[36][0-9][0-9][0-9][0-9].{40}|5[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{84})|0(?:[0-49][0-9][0-9][0-9][0-9].{12}|[5-7][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{16})|2(?:[124-8][0-9][0-9][0-9][0-9].{8}|[39][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{40})|5(?:[03-8][0-9][0-9][0-9][0-9].{12}|[12][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{8})|9(?:[0-578][0-9][0-9][0-9][0-9].{20}|6[0-9][0-9][0-9][0-9].{108}|9[0-9][0-9][0-9][0-9].{12})|8(?:[2-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{104})|1(?:[0-257-9][0-9][0-9][0-9][0-9].{8}|[346][0-9][0-9][0-9][0-9].{12})|7(?:[02-9][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{20}))|5(?:4(?:[6-9][0-9][0-9][0-9][0-9].{28}|[12][0-9][0-9][0-9][0-9].{48}|[34][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{108}|5[0-9][0-9][0-9][0-9].{52})|5(?:[36-9][0-9][0-9][0-9][0-9].{28}|[12][0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{80}|4[0-9][0-9][0-9][0-9].{56}|5[0-9][0-9][0-9][0-9].{52})|8(?:[23][0-9][0-9][0-9][0-9].{56}|5[0-9][0-9][0-9][0-9].{132}|0[0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{8})|6(?:[0-3][0-9][0-9][0-9][0-9].{28}|[47-9][0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{112}|5[0-9][0-9][0-9][0-9].{88})|3(?:[3-8][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{8})|1(?:[0-5][0-9][0-9][0-9][0-9].{12}|[6-9][0-9][0-9][0-9][0-9].{4})|0[0-9][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9][0-9].{4}))|5(?:8(?:4(?:[47][0-9][0-9][0-9][0-9].{112}|[02][0-9][0-9][0-9][0-9].{56}|3[0-9][0-9][0-9][0-9].{176}|6[0-9][0-9][0-9][0-9].{196}|8[0-9][0-9][0-9][0-9].{136}|1[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{40})|5(?:[0-2][0-9][0-9][0-9][0-9].{136}|[34][0-9][0-9][0-9][0-9].{168}|5[0-9][0-9][0-9][0-9].{340}|6[0-9][0-9][0-9][0-9].{548}|7[0-9][0-9][0-9][0-9].{56}|8[0-9][0-9][0-9][0-9].{68}|9[0-9][0-9][0-9][0-9].{36})|6(?:[3-5][0-9][0-9][0-9][0-9].{264}|[89][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{316}|2[0-9][0-9][0-9][0-9].{112}|7[0-9][0-9][0-9][0-9].{252}|1[0-9][0-9][0-9][0-9].{88}|6[0-9][0-9][0-9][0-9].{8})|1(?:[014-69][0-9][0-9][0-9][0-9].{28}|[23][0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{128}|8[0-9][0-9][0-9][0-9].{412})|0(?:[3-9][0-9][0-9][0-9][0-9].{44}|[12][0-9][0-9][0-9][0-9].{108}|0[0-9][0-9][0-9][0-9].{28})|2(?:[0-5][0-9][0-9][0-9][0-9].{28}|[6-9][0-9][0-9][0-9][0-9].{68})|7(?:[0-7][0-9][0-9][0-9][0-9].{36}|[89][0-9][0-9][0-9][0-9].{40})|3(?:[0-8][0-9][0-9][0-9][0-9].{68}|9[0-9][0-9][0-9][0-9].{56})|8(?:0[0-9][0-9][0-9][0-9].{132}|1[0-9][0-9][0-9][0-9].{112}))|6(?:4(?:[0-24][0-9][0-9][0-9][0-9].{12}|[359][0-9][0-9][0-9][0-9].{8}|[78][0-9][0-9][0-9][0-9].{20}|6[0-9][0-9][0-9][0-9].{16})|5(?:[013][0-9][0-9][0-9][0-9].{20}|[5-79][0-9][0-9][0-9][0-9].{8}|[28][0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{32})|8(?:[1256][0-9][0-9][0-9][0-9].{8}|[7-9][0-9][0-9][0-9][0-9].{60}|[34][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{12})|0(?:[0-5][0-9][0-9][0-9][0-9].{8}|[6-8][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{32})|1(?:[0-2478][0-9][0-9][0-9][0-9].{8}|[356][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{56})|3(?:[0-579][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{12})|9(?:[013-57-9][0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{20}|6[0-9][0-9][0-9][0-9].{8})|6(?:[0-578][0-9][0-9][0-9][0-9].{24}|[69][0-9][0-9][0-9][0-9].{20})|7[0-9][0-9][0-9][0-9][0-9].{40}|2[0-9][0-9][0-9][0-9][0-9].{8})|7(?:0(?:[13589][0-9][0-9][0-9][0-9].{8}|[267][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{80}|4[0-9][0-9][0-9][0-9].{12})|8(?:[0189][0-9][0-9][0-9][0-9].{12}|[4-7][0-9][0-9][0-9][0-9].{16}|[23][0-9][0-9][0-9][0-9].{8})|7(?:[2-46-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{24}|5[0-9][0-9][0-9][0-9].{80})|5(?:[0-468][0-9][0-9][0-9][0-9].{12}|[59][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{80})|3(?:[0-7][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{40})|4(?:[25-9][0-9][0-9][0-9][0-9].{12}|[0134][0-9][0-9][0-9][0-9].{8})|9(?:[0-279][0-9][0-9][0-9][0-9].{12}|[3-68][0-9][0-9][0-9][0-9].{8})|2(?:[013-9][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{16})|6[0-9][0-9][0-9][0-9][0-9].{24}|1[0-9][0-9][0-9][0-9][0-9].{8})|0[0-9][0-9][0-9][0-9][0-9][0-9].{4})|4(?:8(?:0(?:[023][0-9][0-9][0-9][0-9].{48}|[15][0-9][0-9][0-9][0-9].{44}|[67][0-9][0-9][0-9][0-9].{28}|4[0-9][0-9][0-9][0-9].{332}|9[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{8})|7(?:[0-4][0-9][0-9][0-9][0-9].{396}|[89][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{132}|6[0-9][0-9][0-9][0-9].{112}|7[0-9][0-9][0-9][0-9].{252})|5(?:[0-4][0-9][0-9][0-9][0-9].{56}|[67][0-9][0-9][0-9][0-9].{88}|8[0-9][0-9][0-9][0-9].{124}|5[0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{36})|6(?:[0-5][0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{916}|9[0-9][0-9][0-9][0-9].{396}|6[0-9][0-9][0-9][0-9].{56}|8[0-9][0-9][0-9][0-9].{8})|2(?:[0-2][0-9][0-9][0-9][0-9].{128}|[3-6][0-9][0-9][0-9][0-9].{28}|[89][0-9][0-9][0-9][0-9].{168}|7[0-9][0-9][0-9][0-9].{56})|1(?:[0-3][0-9][0-9][0-9][0-9].{36}|[4-6][0-9][0-9][0-9][0-9].{28}|[78][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{112})|3(?:[0-3][0-9][0-9][0-9][0-9].{28}|[6-9][0-9][0-9][0-9][0-9].{68}|[45][0-9][0-9][0-9][0-9].{548})|4(?:[0-7][0-9][0-9][0-9][0-9].{68}|8[0-9][0-9][0-9][0-9].{212}|9[0-9][0-9][0-9][0-9].{112})|9(?:0[0-9][0-9][0-9][0-9].{112}|2[0-9][0-9][0-9][0-9].{272}|1[0-9][0-9][0-9][0-9].{88})|8(?:0[0-9][0-9][0-9][0-9].{272}|8[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{8}))|3(?:8(?:[0-257][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{20}|4[0-9][0-9][0-9][0-9].{104}|6[0-9][0-9][0-9][0-9].{180}|3[0-9][0-9][0-9][0-9].{36})|5(?:[1-47][0-9][0-9][0-9][0-9].{8}|[06][0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{128}|8[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{32})|7(?:[036-9][0-9][0-9][0-9][0-9].{12}|[1245][0-9][0-9][0-9][0-9].{32})|1(?:[5-9][0-9][0-9][0-9][0-9].{12}|[0-4][0-9][0-9][0-9][0-9].{8})|2(?:[3-9][0-9][0-9][0-9][0-9].{8}|[0-2][0-9][0-9][0-9][0-9].{12})|4(?:[0-24-8][0-9][0-9][0-9][0-9].{8}|[39][0-9][0-9][0-9][0-9].{12})|3(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16})|6[0-9][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9][0-9].{8})|4(?:0(?:[0-2][0-9][0-9][0-9][0-9].{180}|[34][0-9][0-9][0-9][0-9].{44}|5[0-9][0-9][0-9][0-9].{28}|6[0-9][0-9][0-9][0-9].{88})|4(?:[34][0-9][0-9][0-9][0-9].{52}|[56][0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{56})|8(?:9[0-9][0-9][0-9][0-9].{272}|8[0-9][0-9][0-9][0-9].{84})|54[0-9][0-9][0-9][0-9].{136})|2[0-9][0-9][0-9][0-9][0-9][0-9].{4})|3(?:0(?:0(?:[127-9][0-9][0-9][0-9][0-9].{8}|[34][0-9][0-9][0-9][0-9].{16}|[56][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{24})|6(?:[1-36][0-9][0-9][0-9][0-9].{12}|[57-9][0-9][0-9][0-9][0-9].{8}|[04][0-9][0-9][0-9][0-9].{16})|9(?:[0-59][0-9][0-9][0-9][0-9].{12}|[78][0-9][0-9][0-9][0-9].{32}|6[0-9][0-9][0-9][0-9].{52})|1(?:[16-9][0-9][0-9][0-9][0-9].{8}|[2-5][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{40})|4(?:[0-5][0-9][0-9][0-9][0-9].{8}|[7-9][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{40})|8(?:[1-35-79][0-9][0-9][0-9][0-9].{8}|[48][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{40})|5(?:[1-35-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{40}|4[0-9][0-9][0-9][0-9].{16})|3(?:[4-9][0-9][0-9][0-9][0-9].{8}|[0-3][0-9][0-9][0-9][0-9].{24})|7(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|2[0-9][0-9][0-9][0-9][0-9].{24})|4(?:5(?:[1-368][0-9][0-9][0-9][0-9].{8}|[05][0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{20}|9[0-9][0-9][0-9][0-9].{80})|7(?:[1-35][0-9][0-9][0-9][0-9].{12}|[46][0-9][0-9][0-9][0-9].{80}|[7-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{20})|6(?:[0-3568][0-9][0-9][0-9][0-9].{20}|[47][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{80})|0(?:[0-24-8][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{32})|1(?:[0-389][0-9][0-9][0-9][0-9].{8}|[4-7][0-9][0-9][0-9][0-9].{12})|3(?:[2-9][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{16})|8(?:[02-8][0-9][0-9][0-9][0-9].{12}|[19][0-9][0-9][0-9][0-9].{8})|2(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|4(?:[0-79][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{56})|9[0-9][0-9][0-9][0-9][0-9].{16})|[278][0-9][0-9][0-9][0-9][0-9][0-9].{4})|[79][0-9][0-9][0-9][0-9][0-9][0-9][0-9].{4})|8(?:9(?:9(?:0(?:[05][0-9][0-9][0-9][0-9].{508}|2[0-9][0-9][0-9][0-9].{164}|3[0-9][0-9][0-9][0-9].{240}|4[0-9][0-9][0-9][0-9].{800}|6[0-9][0-9][0-9][0-9].{176}|7[0-9][0-9][0-9][0-9].{360}|8[0-9][0-9][0-9][0-9].{424}|1[0-9][0-9][0-9][0-9].{48}|9[0-9][0-9][0-9][0-9].{8})|8(?:[24][0-9][0-9][0-9][0-9].{176}|0[0-9][0-9][0-9][0-9].{960}|1[0-9][0-9][0-9][0-9].{148}|3[0-9][0-9][0-9][0-9].{840}|8[0-9][0-9][0-9][0-9].{600}|9[0-9][0-9][0-9][0-9].{204}|5[0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{24}|7[0-9][0-9][0-9][0-9].{8})|1(?:0[0-9][0-9][0-9][0-9].{240}|2[0-9][0-9][0-9][0-9].{644}|3[0-9][0-9][0-9][0-9].{260}|4[0-9][0-9][0-9][0-9].{184}|5[0-9][0-9][0-9][0-9].{508}|6[0-9][0-9][0-9][0-9].{200}|7[0-9][0-9][0-9][0-9].{148}|8[0-9][0-9][0-9][0-9].{164}|9[0-9][0-9][0-9][0-9].{8})|9(?:2[0-9][0-9][0-9][0-9].{464}|3[0-9][0-9][0-9][0-9].{384}|4[0-9][0-9][0-9][0-9].{104}|5[0-9][0-9][0-9][0-9].{456}|8[0-9][0-9][0-9][0-9].{120}|0[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{24}|7[0-9][0-9][0-9][0-9].{92}|9[0-9][0-9][0-9][0-9].{48})|4(?:[48][0-9][0-9][0-9][0-9].{176}|0[0-9][0-9][0-9][0-9].{120}|1[0-9][0-9][0-9][0-9].{860}|2[0-9][0-9][0-9][0-9].{432}|3[0-9][0-9][0-9][0-9].{656}|5[0-9][0-9][0-9][0-9].{212}|6[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{28})|7(?:[01][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{524}|4[0-9][0-9][0-9][0-9].{176}|5[0-9][0-9][0-9][0-9].{100}|6[0-9][0-9][0-9][0-9].{232}|9[0-9][0-9][0-9][0-9].{128}|7[0-9][0-9][0-9][0-9].{88}|8[0-9][0-9][0-9][0-9].{8})|6(?:0[0-9][0-9][0-9][0-9].{120}|1[0-9][0-9][0-9][0-9].{140}|2[0-9][0-9][0-9][0-9].{172}|3[0-9][0-9][0-9][0-9].{228}|4[0-9][0-9][0-9][0-9].{176}|6[0-9][0-9][0-9][0-9].{292}|5[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{8})|2(?:[26][0-9][0-9][0-9][0-9].{424}|[37][0-9][0-9][0-9][0-9].{24}|1[0-9][0-9][0-9][0-9].{164}|4[0-9][0-9][0-9][0-9].{140}|8[0-9][0-9][0-9][0-9].{484}|9[0-9][0-9][0-9][0-9].{512}|5[0-9][0-9][0-9][0-9].{52})|5(?:[289][0-9][0-9][0-9][0-9].{176}|0[0-9][0-9][0-9][0-9].{120}|3[0-9][0-9][0-9][0-9].{216}|4[0-9][0-9][0-9][0-9].{204}|5[0-9][0-9][0-9][0-9].{636}|7[0-9][0-9][0-9][0-9].{144}|6[0-9][0-9][0-9][0-9].{12})|3(?:3[0-9][0-9][0-9][0-9].{260}|4[0-9][0-9][0-9][0-9].{240}|6[0-9][0-9][0-9][0-9].{308}|8[0-9][0-9][0-9][0-9].{100}|7[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{8}))|2(?:9(?:[17][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{684}|3[0-9][0-9][0-9][0-9].{204}|4[0-9][0-9][0-9][0-9].{104}|8[0-9][0-9][0-9][0-9].{304}|9[0-9][0-9][0-9][0-9].{592}|2[0-9][0-9][0-9][0-9].{48}|6[0-9][0-9][0-9][0-9].{92}|5[0-9][0-9][0-9][0-9].{4})|1(?:2[0-9][0-9][0-9][0-9].{148}|4[0-9][0-9][0-9][0-9].{184}|5[0-9][0-9][0-9][0-9].{260}|6[0-9][0-9][0-9][0-9].{200}|7[0-9][0-9][0-9][0-9].{464}|8[0-9][0-9][0-9][0-9].{164}|9[0-9][0-9][0-9][0-9].{480}|3[0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{8})|2(?:[68][0-9][0-9][0-9][0-9].{424}|[25][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{132}|1[0-9][0-9][0-9][0-9].{384}|4[0-9][0-9][0-9][0-9].{140}|7[0-9][0-9][0-9][0-9].{164}|9[0-9][0-9][0-9][0-9].{600}|3[0-9][0-9][0-9][0-9].{24})|6(?:[89][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{176}|1[0-9][0-9][0-9][0-9].{400}|2[0-9][0-9][0-9][0-9].{172}|3[0-9][0-9][0-9][0-9].{184}|4[0-9][0-9][0-9][0-9].{324}|6[0-9][0-9][0-9][0-9].{164}|5[0-9][0-9][0-9][0-9].{24})|5(?:[26][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{108}|3[0-9][0-9][0-9][0-9].{332}|4[0-9][0-9][0-9][0-9].{204}|7[0-9][0-9][0-9][0-9].{144}|9[0-9][0-9][0-9][0-9].{360}|8[0-9][0-9][0-9][0-9].{88}|5[0-9][0-9][0-9][0-9].{8})|4(?:[26][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{644}|1[0-9][0-9][0-9][0-9].{176}|7[0-9][0-9][0-9][0-9].{228}|8[0-9][0-9][0-9][0-9].{100}|3[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{8})|7(?:[46][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{232}|3[0-9][0-9][0-9][0-9].{432}|5[0-9][0-9][0-9][0-9].{100}|7[0-9][0-9][0-9][0-9].{120})|8(?:0[0-9][0-9][0-9][0-9].{328}|1[0-9][0-9][0-9][0-9].{148}|4[0-9][0-9][0-9][0-9].{352}|6[0-9][0-9][0-9][0-9].{212}|7[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{48}|8[0-9][0-9][0-9][0-9].{8})|0(?:[03][0-9][0-9][0-9][0-9].{120}|[256][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{128}|7[0-9][0-9][0-9][0-9].{200}|9[0-9][0-9][0-9][0-9].{268}|1[0-9][0-9][0-9][0-9].{48})|3(?:[0469][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{344}|3[0-9][0-9][0-9][0-9].{120}|7[0-9][0-9][0-9][0-9].{292}|8[0-9][0-9][0-9][0-9].{100}|5[0-9][0-9][0-9][0-9].{4}))|0(?:0(?:[03][0-9][0-9][0-9][0-9].{148}|6[0-9][0-9][0-9][0-9].{124}|7[0-9][0-9][0-9][0-9].{308}|8[0-9][0-9][0-9][0-9].{884}|9[0-9][0-9][0-9][0-9].{348}|1[0-9][0-9][0-9][0-9].{48}|2[0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{4})|5(?:4[0-9][0-9][0-9][0-9].{324}|5[0-9][0-9][0-9][0-9].{120}|7[0-9][0-9][0-9][0-9].{144}|8[0-9][0-9][0-9][0-9].{232}|9[0-9][0-9][0-9][0-9].{596}|0[0-9][0-9][0-9][0-9].{88}|6[0-9][0-9][0-9][0-9].{12})|4(?:[26][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{440}|1[0-9][0-9][0-9][0-9].{196}|3[0-9][0-9][0-9][0-9].{240}|4[0-9][0-9][0-9][0-9].{120}|5[0-9][0-9][0-9][0-9].{464})|7(?:[01][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{100}|6[0-9][0-9][0-9][0-9].{228}|7[0-9][0-9][0-9][0-9].{384}|9[0-9][0-9][0-9][0-9].{472}|8[0-9][0-9][0-9][0-9].{8})|2(?:0[0-9][0-9][0-9][0-9].{100}|1[0-9][0-9][0-9][0-9].{240}|2[0-9][0-9][0-9][0-9].{120}|4[0-9][0-9][0-9][0-9].{140}|3[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{8})|9(?:7[0-9][0-9][0-9][0-9].{328}|8[0-9][0-9][0-9][0-9].{376}|9[0-9][0-9][0-9][0-9].{172}|0[0-9][0-9][0-9][0-9].{48}|2[0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{8})|3(?:[45][0-9][0-9][0-9][0-9].{100}|[69][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{380}|1[0-9][0-9][0-9][0-9].{568}|3[0-9][0-9][0-9][0-9].{120})|8(?:4[0-9][0-9][0-9][0-9].{352}|1[0-9][0-9][0-9][0-9].{92}|6[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{8})|1(?:1[0-9][0-9][0-9][0-9].{164}|3[0-9][0-9][0-9][0-9].{524}|0[0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9].{8})|6(?:0[0-9][0-9][0-9][0-9].{268}|1[0-9][0-9][0-9][0-9].{24}|4[0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{8}))|1(?:0(?:[02][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{148}|5[0-9][0-9][0-9][0-9].{432}|6[0-9][0-9][0-9][0-9].{604}|7[0-9][0-9][0-9][0-9].{200}|1[0-9][0-9][0-9][0-9].{48}|3[0-9][0-9][0-9][0-9].{52})|1(?:4[0-9][0-9][0-9][0-9].{184}|6[0-9][0-9][0-9][0-9].{200}|8[0-9][0-9][0-9][0-9].{384}|9[0-9][0-9][0-9][0-9].{380}|0[0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{8})|5(?:[16][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{332}|4[0-9][0-9][0-9][0-9].{324}|5[0-9][0-9][0-9][0-9].{120}|7[0-9][0-9][0-9][0-9].{144}|0[0-9][0-9][0-9][0-9].{48})|3(?:[69][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{292}|8[0-9][0-9][0-9][0-9].{100}|0[0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{88}|5[0-9][0-9][0-9][0-9].{12})|4(?:3[0-9][0-9][0-9][0-9].{184}|4[0-9][0-9][0-9][0-9].{120}|8[0-9][0-9][0-9][0-9].{100}|6[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{8})|2(?:[35][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{120}|4[0-9][0-9][0-9][0-9].{140}|6[0-9][0-9][0-9][0-9].{260})|6(?:0[0-9][0-9][0-9][0-9].{232}|5[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{4})|7(?:[01][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{120}|8[0-9][0-9][0-9][0-9].{8})|8(?:4[0-9][0-9][0-9][0-9].{352}|0[0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{4})|9(?:7[0-9][0-9][0-9][0-9].{328}|2[0-9][0-9][0-9][0-9].{92}))|7(?:7(?:[01][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{384}|4[0-9][0-9][0-9][0-9].{232}|5[0-9][0-9][0-9][0-9].{88}|6[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{92}|8[0-9][0-9][0-9][0-9].{8})|1(?:0[0-9][0-9][0-9][0-9].{100}|3[0-9][0-9][0-9][0-9].{268}|6[0-9][0-9][0-9][0-9].{200}|7[0-9][0-9][0-9][0-9].{964}|2[0-9][0-9][0-9][0-9].{24}|8[0-9][0-9][0-9][0-9].{16})|0(?:0[0-9][0-9][0-9][0-9].{120}|4[0-9][0-9][0-9][0-9].{148}|5[0-9][0-9][0-9][0-9].{360}|1[0-9][0-9][0-9][0-9].{48})|2(?:1[0-9][0-9][0-9][0-9].{164}|2[0-9][0-9][0-9][0-9].{120}|4[0-9][0-9][0-9][0-9].{140}|3[0-9][0-9][0-9][0-9].{24})|5(?:0[0-9][0-9][0-9][0-9].{100}|5[0-9][0-9][0-9][0-9].{120}|7[0-9][0-9][0-9][0-9].{144}|6[0-9][0-9][0-9][0-9].{12})|4(?:4[0-9][0-9][0-9][0-9].{120}|9[0-9][0-9][0-9][0-9].{328}|6[0-9][0-9][0-9][0-9].{12})|3(?:7[0-9][0-9][0-9][0-9].{292}|8[0-9][0-9][0-9][0-9].{100}|9[0-9][0-9][0-9][0-9].{8})|6(?:[56][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{28})|8(?:7[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{48})|97[0-9][0-9][0-9][0-9].{8})|5(?:6(?:9(?:[289][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9].{240}|1[0-9][0-9][0-9].{568}|4[0-9][0-9][0-9].{228}|5[0-9][0-9][0-9].{464}|7[0-9][0-9][0-9].{308}|6[0-9][0-9][0-9].{4})|8(?:1[0-9][0-9][0-9].{228}|0[0-9][0-9][0-9].{4}))|0(?:8(?:0[0-9][0-9][0-9].{472}|1[0-9][0-9][0-9].{716}|2[0-9][0-9][0-9].{176}|9[0-9][0-9][0-9].{172})|7(?:8[0-9][0-9][0-9].{124}|9[0-9][0-9][0-9].{596}|7[0-9][0-9][0-9].{88})|20[0-9][0-9][0-9].{216})|2(?:3(?:[24][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9].{28})|2(?:7[0-9][0-9][0-9].{848}|6[0-9][0-9][0-9].{4})|00[0-9][0-9][0-9].{100})|8(?:9(?:5[0-9][0-9][0-9].{216}|6[0-9][0-9][0-9].{200}|7[0-9][0-9][0-9].{8})|8[89][0-9][0-9][0-9].{148})|1(?:0[0-9][0-9][0-9][0-9].{140}|23[0-9][0-9][0-9].{100})|7(?:0[01][0-9][0-9][0-9].{4}|95[0-9][0-9][0-9].{52})|500[0-9][0-9][0-9].{216}|900[0-9][0-9][0-9].{200})|300(?:1[0-9][0-9][0-9].{240}|2[0-9][0-9][0-9].{656}|3[0-9][0-9][0-9].{592}|4[0-9][0-9][0-9].{636}|5[0-9][0-9][0-9].{216}|0[0-9][0-9][0-9].{48}|7[0-9][0-9][0-9].{52})|84(?:0(?:1[0-9][0-9][0-9].{216}|2[0-9][0-9][0-9].{968}|4[0-9][0-9][0-9].{48})|4[0-9][0-9][0-9][0-9].{100}))|2(?:6(?:2(?:[57][0-9][0-9][0-9][0-9].{48}|[02][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{480}|3[0-9][0-9][0-9][0-9].{308}|4[0-9][0-9][0-9][0-9].{132}|6[0-9][0-9][0-9][0-9].{120}|8[0-9][0-9][0-9][0-9].{304}|9[0-9][0-9][0-9][0-9].{164})|6(?:[7-9][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{400}|2[0-9][0-9][0-9][0-9].{172}|3[0-9][0-9][0-9][0-9].{184}|4[0-9][0-9][0-9][0-9].{324}|0[0-9][0-9][0-9][0-9].{52}|5[0-9][0-9][0-9][0-9].{24}|6[0-9][0-9][0-9][0-9].{8})|1(?:1[0-9][0-9][0-9][0-9].{120}|2[0-9][0-9][0-9][0-9].{108}|3[0-9][0-9][0-9][0-9].{560}|4[0-9][0-9][0-9][0-9].{184}|5[0-9][0-9][0-9][0-9].{332}|6[0-9][0-9][0-9][0-9].{200}|0[0-9][0-9][0-9][0-9].{24})|8(?:1[0-9][0-9][0-9][0-9].{140}|4[0-9][0-9][0-9][0-9].{560}|5[0-9][0-9][0-9][0-9].{260}|2[0-9][0-9][0-9][0-9].{48}|6[0-9][0-9][0-9][0-9].{24}|8[0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{8})|0(?:[56][0-9][0-9][0-9][0-9].{120}|[18][0-9][0-9][0-9][0-9].{48}|[02][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{128}|7[0-9][0-9][0-9][0-9].{240}|9[0-9][0-9][0-9][0-9].{12})|5(?:[1-3][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{676}|6[0-9][0-9][0-9][0-9].{148}|7[0-9][0-9][0-9][0-9].{144}|9[0-9][0-9][0-9][0-9].{232}|5[0-9][0-9][0-9][0-9].{8})|3(?:[1-6][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{164}|7[0-9][0-9][0-9][0-9].{292}|8[0-9][0-9][0-9][0-9].{100}|9[0-9][0-9][0-9][0-9].{8})|9(?:7[0-9][0-9][0-9][0-9].{104}|9[0-9][0-9][0-9][0-9].{100}|5[0-9][0-9][0-9][0-9].{52}|6[0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{8})|4(?:[1-6][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{4})|7[0-9][0-9][0-9][0-9][0-9].{12})|1(?:0(?:[18][0-9][0-9][0-9][0-9].{48}|[02][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{120}|6[0-9][0-9][0-9][0-9].{108}|3[0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{4})|3(?:[36][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{124}|7[0-9][0-9][0-9][0-9].{292}|8[0-9][0-9][0-9][0-9].{100}|0[0-9][0-9][0-9][0-9].{24}|4[0-9][0-9][0-9][0-9].{48})|1(?:[36-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{120}|2[0-9][0-9][0-9][0-9].{732}|4[0-9][0-9][0-9][0-9].{184}|5[0-9][0-9][0-9][0-9].{260})|2(?:[289][0-9][0-9][0-9][0-9].{48}|[01][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{140}|5[0-9][0-9][0-9][0-9].{260}|3[0-9][0-9][0-9][0-9].{24})|5(?:[0-2][0-9][0-9][0-9][0-9].{92}|3[0-9][0-9][0-9][0-9].{184}|4[0-9][0-9][0-9][0-9].{324}|7[0-9][0-9][0-9][0-9].{144}|5[0-9][0-9][0-9][0-9].{8})|7(?:0[0-9][0-9][0-9][0-9].{120}|5[0-9][0-9][0-9][0-9].{100}|8[0-9][0-9][0-9][0-9].{604}|4[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{88})|4(?:[5-9][0-9][0-9][0-9][0-9].{12}|[04][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{184}|2[0-9][0-9][0-9][0-9].{52})|6(?:[15][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{136}|2[0-9][0-9][0-9][0-9].{172}|6[0-9][0-9][0-9][0-9].{400})|8(?:[3-9][0-9][0-9][0-9][0-9].{12}|[02][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{52})|9(?:[0-7][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{4}))|5(?:5(?:[12][0-9][0-9][0-9][0-9].{92}|[78][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{520}|4[0-9][0-9][0-9][0-9].{324}|6[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{8})|6(?:2[0-9][0-9][0-9][0-9].{172}|3[0-9][0-9][0-9][0-9].{344}|6[0-9][0-9][0-9][0-9].{156}|8[0-9][0-9][0-9][0-9].{228}|9[0-9][0-9][0-9][0-9].{132}|5[0-9][0-9][0-9][0-9].{80}|7[0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9].{8})|4(?:3[0-9][0-9][0-9][0-9].{464}|4[0-9][0-9][0-9][0-9].{120}|7[0-9][0-9][0-9][0-9].{164}|8[0-9][0-9][0-9][0-9].{560}|9[0-9][0-9][0-9][0-9].{192}|2[0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{8})|1(?:[36][0-9][0-9][0-9][0-9].{200}|[025][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{120}|4[0-9][0-9][0-9][0-9].{100}|7[0-9][0-9][0-9][0-9].{432}|9[0-9][0-9][0-9][0-9].{492}|8[0-9][0-9][0-9][0-9].{56})|2(?:[026][0-9][0-9][0-9][0-9].{4}|[78][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{360}|4[0-9][0-9][0-9][0-9].{204}|1[0-9][0-9][0-9][0-9].{88}|5[0-9][0-9][0-9][0-9].{12})|9(?:0[0-9][0-9][0-9][0-9].{164}|4[0-9][0-9][0-9][0-9].{352}|7[0-9][0-9][0-9][0-9].{328}|2[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{88}|5[0-9][0-9][0-9][0-9].{4})|7(?:[27][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{236}|6[0-9][0-9][0-9][0-9].{524}|4[0-9][0-9][0-9][0-9].{12})|[038][0-9][0-9][0-9][0-9][0-9].{4})|0(?:9(?:[89][0-9][0-9][0-9][0-9].{48}|1[0-9][0-9][0-9][0-9].{348}|2[0-9][0-9][0-9][0-9].{132}|4[0-9][0-9][0-9][0-9].{352}|6[0-9][0-9][0-9][0-9].{440}|7[0-9][0-9][0-9][0-9].{328}|3[0-9][0-9][0-9][0-9].{88}|5[0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9].{8})|5(?:[079][0-9][0-9][0-9][0-9].{4}|[68][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{492}|2[0-9][0-9][0-9][0-9].{332}|3[0-9][0-9][0-9][0-9].{232}|4[0-9][0-9][0-9][0-9].{324}|5[0-9][0-9][0-9][0-9].{156})|4(?:[28][0-9][0-9][0-9][0-9].{12}|[67][0-9][0-9][0-9][0-9].{24}|[05][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{344}|3[0-9][0-9][0-9][0-9].{128}|4[0-9][0-9][0-9][0-9].{120})|6(?:[01][0-9][0-9][0-9][0-9].{4}|[57][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{172}|6[0-9][0-9][0-9][0-9].{192}|8[0-9][0-9][0-9][0-9].{212}|9[0-9][0-9][0-9][0-9].{28})|1(?:[02-4][0-9][0-9][0-9][0-9].{8}|[19][0-9][0-9][0-9][0-9].{120}|[56][0-9][0-9][0-9][0-9].{200}|7[0-9][0-9][0-9][0-9].{552}|8[0-9][0-9][0-9][0-9].{164})|2(?:[02579][0-9][0-9][0-9][0-9].{4}|[68][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{164}|4[0-9][0-9][0-9][0-9].{148}|1[0-9][0-9][0-9][0-9].{48})|7(?:[135][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{24}|[27][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{120}|4[0-9][0-9][0-9][0-9].{204})|[038][0-9][0-9][0-9][0-9][0-9].{4}))|0(?:5(?:3(?:1[0-9][0-9][0-9][0-9].{124}|2[0-9][0-9][0-9][0-9].{228}|3[0-9][0-9][0-9][0-9].{120}|4[0-9][0-9][0-9][0-9].{204}|8[0-9][0-9][0-9][0-9].{100}|5[0-9][0-9][0-9][0-9].{24}|6[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{56}|0[0-9][0-9][0-9][0-9].{8})|1(?:[01][0-9][0-9][0-9][0-9].{32}|3[0-9][0-9][0-9][0-9].{156}|4[0-9][0-9][0-9][0-9].{184}|6[0-9][0-9][0-9][0-9].{200}|7[0-9][0-9][0-9][0-9].{260}|9[0-9][0-9][0-9][0-9].{120}|5[0-9][0-9][0-9][0-9].{92}|8[0-9][0-9][0-9][0-9].{68}|2[0-9][0-9][0-9][0-9].{8})|2(?:[05][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{344}|3[0-9][0-9][0-9][0-9].{132}|4[0-9][0-9][0-9][0-9].{156}|6[0-9][0-9][0-9][0-9].{148}|8[0-9][0-9][0-9][0-9].{108}|9[0-9][0-9][0-9][0-9].{128}|2[0-9][0-9][0-9][0-9].{32}|7[0-9][0-9][0-9][0-9].{4})|5(?:[12][0-9][0-9][0-9][0-9].{92}|3[0-9][0-9][0-9][0-9].{232}|4[0-9][0-9][0-9][0-9].{324}|7[0-9][0-9][0-9][0-9].{144}|8[0-9][0-9][0-9][0-9].{212}|9[0-9][0-9][0-9][0-9].{136}|0[0-9][0-9][0-9][0-9].{48}|6[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{8})|4(?:[24][0-9][0-9][0-9][0-9].{120}|[06][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{184}|7[0-9][0-9][0-9][0-9].{292}|9[0-9][0-9][0-9][0-9].{148}|1[0-9][0-9][0-9][0-9].{48}|5[0-9][0-9][0-9][0-9].{24})|9(?:[19][0-9][0-9][0-9][0-9].{12}|[23][0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{104}|7[0-9][0-9][0-9][0-9].{328}|0[0-9][0-9][0-9][0-9].{48}|5[0-9][0-9][0-9][0-9].{52}|8[0-9][0-9][0-9][0-9].{36})|0(?:[1245][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{120}|3[0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{80}|8[0-9][0-9][0-9][0-9].{84}|9[0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{4})|6(?:0[0-9][0-9][0-9][0-9].{192}|2[0-9][0-9][0-9][0-9].{172}|5[0-9][0-9][0-9][0-9].{164}|1[0-9][0-9][0-9][0-9].{84}|3[0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{28}|6[0-9][0-9][0-9][0-9].{8})|8(?:[01][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{440}|6[0-9][0-9][0-9][0-9].{400}|8[0-9][0-9][0-9][0-9].{120}|5[0-9][0-9][0-9][0-9].{12})|7(?:[017][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{164}|5[0-9][0-9][0-9][0-9].{24}|6[0-9][0-9][0-9][0-9].{12}))|6(?:1(?:0[0-9][0-9][0-9][0-9].{356}|2[0-9][0-9][0-9][0-9].{200}|3[0-9][0-9][0-9][0-9].{268}|4[0-9][0-9][0-9][0-9].{304}|5[0-9][0-9][0-9][0-9].{124}|6[0-9][0-9][0-9][0-9].{360}|1[0-9][0-9][0-9][0-9].{28})|0(?:8[0-9][0-9][0-9][0-9].{164}|9[0-9][0-9][0-9][0-9].{148}|6[0-9][0-9][0-9][0-9].{48}|7[0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9].{8})|6(?:0[0-9][0-9][0-9][0-9].{232}|9[0-9][0-9][0-9][0-9].{136})|9(?:0[0-9][0-9][0-9][0-9].{172}|9[0-9][0-9][0-9][0-9].{192})|5(?:0[0-9][0-9][0-9][0-9].{440}|4[0-9][0-9][0-9][0-9].{12})|8(?:1[0-9][0-9][0-9][0-9].{88}|0[0-9][0-9][0-9][0-9].{4})|70[0-9][0-9][0-9][0-9].{128}|23[0-9][0-9][0-9][0-9].{24})|1(?:0(?:0[0-9][0-9][0-9][0-9].{360}|3[0-9][0-9][0-9][0-9].{240}|4[0-9][0-9][0-9][0-9].{156}|6[0-9][0-9][0-9][0-9].{316}|7[0-9][0-9][0-9][0-9].{304}|8[0-9][0-9][0-9][0-9].{232}|9[0-9][0-9][0-9][0-9].{356}|1[0-9][0-9][0-9][0-9].{48}|2[0-9][0-9][0-9][0-9].{44})|2(?:0[0-9][0-9][0-9][0-9].{140}|6[0-9][0-9][0-9][0-9].{476}|3[0-9][0-9][0-9][0-9].{24})|8(?:1[0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{8})|1(?:0[0-9][0-9][0-9][0-9].{268}|1[0-9][0-9][0-9][0-9].{536})|(?:38|90)[0-9][0-9][0-9][0-9].{4}|77[0-9][0-9][0-9][0-9].{88})|9(?:1(?:3[0-9][0-9][0-9][0-9].{268}|9[0-9][0-9][0-9][0-9].{88}|0[0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{8})|3(?:2[0-9][0-9][0-9][0-9].{156}|6[0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{4})|0(?:[26][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{156})|[49]0[0-9][0-9][0-9][0-9].{8}|80[0-9][0-9][0-9][0-9].{48}|54[0-9][0-9][0-9][0-9].{4})|0(?:9(?:[0189][0-9][0-9][0-9][0-9].{4}|[257][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{384}|6[0-9][0-9][0-9][0-9].{148}|4[0-9][0-9][0-9][0-9].{24})|7(?:[02579][0-9][0-9][0-9][0-9].{4}|[13][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{384}|4[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{16})|[0-68][0-9][0-9][0-9][0-9][0-9].{4})|88(?:0(?:1[0-9][0-9][0-9].{536}|5[0-9][0-9][0-9].{144}|6[0-9][0-9][0-9].{172}|8[0-9][0-9][0-9].{48}|9[0-9][0-9][0-9].{24}|0[0-9][0-9][0-9].{4}|7[0-9][0-9][0-9].{8})|10[0-9][0-9][0-9].{432})|3(?:0[1-9]|8[0-468]|3[02357])[0-9][0-9][0-9][0-9].{4})|1(?:1(?:1(?:0[0-9][0-9][0-9][0-9].{120}|2[0-9][0-9][0-9][0-9].{344}|3[0-9][0-9][0-9][0-9].{200}|4[0-9][0-9][0-9][0-9].{184}|5[0-9][0-9][0-9][0-9].{156}|7[0-9][0-9][0-9][0-9].{112}|8[0-9][0-9][0-9][0-9].{164}|9[0-9][0-9][0-9][0-9].{108}|1[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{4})|5(?:[12][0-9][0-9][0-9][0-9].{92}|3[0-9][0-9][0-9][0-9].{184}|4[0-9][0-9][0-9][0-9].{100}|7[0-9][0-9][0-9][0-9].{144}|8[0-9][0-9][0-9][0-9].{124}|9[0-9][0-9][0-9][0-9].{148}|0[0-9][0-9][0-9][0-9].{48}|6[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{8})|9(?:[23][0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{236}|7[0-9][0-9][0-9][0-9].{328}|9[0-9][0-9][0-9][0-9].{192}|1[0-9][0-9][0-9][0-9].{48}|4[0-9][0-9][0-9][0-9].{80}|5[0-9][0-9][0-9][0-9].{52}|8[0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{8})|8(?:[01][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{536}|4[0-9][0-9][0-9][0-9].{352}|5[0-9][0-9][0-9][0-9].{104}|6[0-9][0-9][0-9][0-9].{400}|7[0-9][0-9][0-9][0-9].{232}|8[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{24})|4(?:[45][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{120}|3[0-9][0-9][0-9][0-9].{184}|8[0-9][0-9][0-9][0-9].{100}|9[0-9][0-9][0-9][0-9].{148}|1[0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9].{80}|6[0-9][0-9][0-9][0-9].{12})|3(?:[27][0-9][0-9][0-9][0-9].{120}|[36][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{260}|4[0-9][0-9][0-9][0-9].{164}|8[0-9][0-9][0-9][0-9].{100}|9[0-9][0-9][0-9][0-9].{228}|0[0-9][0-9][0-9][0-9].{92})|0(?:[025][0-9][0-9][0-9][0-9].{8}|[18][0-9][0-9][0-9][0-9].{48}|4[0-9][0-9][0-9][0-9].{128}|3[0-9][0-9][0-9][0-9].{52}|6[0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{12})|6(?:[09][0-9][0-9][0-9][0-9].{28}|2[0-9][0-9][0-9][0-9].{172}|4[0-9][0-9][0-9][0-9].{324}|7[0-9][0-9][0-9][0-9].{292}|8[0-9][0-9][0-9][0-9].{100}|5[0-9][0-9][0-9][0-9].{24}|6[0-9][0-9][0-9][0-9].{88})|7(?:[57][0-9][0-9][0-9][0-9].{120}|[46][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{156}|3[0-9][0-9][0-9][0-9].{332}|8[0-9][0-9][0-9][0-9].{84})|2(?:[0245][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{132}|1[0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{24}|6[0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{4}))|2(?:0(?:[45][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{432}|3[0-9][0-9][0-9][0-9].{360}|6[0-9][0-9][0-9][0-9].{240}|7[0-9][0-9][0-9][0-9].{348}|8[0-9][0-9][0-9][0-9].{212}|0[0-9][0-9][0-9][0-9].{52}|2[0-9][0-9][0-9][0-9].{56})|1(?:0[0-9][0-9][0-9][0-9].{128}|2[0-9][0-9][0-9][0-9].{244}|4[0-9][0-9][0-9][0-9].{376}|1[0-9][0-9][0-9][0-9].{44}|3[0-9][0-9][0-9][0-9].{48})|2(?:0[0-9][0-9][0-9][0-9].{136}|1[0-9][0-9][0-9][0-9].{304}|2[0-9][0-9][0-9][0-9].{88})|8(?:0[0-9][0-9][0-9][0-9].{440}|1[0-9][0-9][0-9][0-9].{48})|42[0-9][0-9][0-9][0-9].{308}|34[0-9][0-9][0-9][0-9].{52})|9(?:1(?:9[0-9][0-9][0-9][0-9].{260}|0[0-9][0-9][0-9][0-9].{4})|0[25][0-9][0-9][0-9][0-9].{52})|0[0-9][0-9][0-9][0-9][0-9][0-9].{4})|6(?:0(?:1(?:[56][0-9][0-9][0-9][0-9].{16}|[89][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{120}|0[0-9][0-9][0-9][0-9].{24}|7[0-9][0-9][0-9][0-9].{92}|2[0-9][0-9][0-9][0-9].{8})|0(?:[19][0-9][0-9][0-9][0-9].{16}|[45][0-9][0-9][0-9][0-9].{12}|[27][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{784}|0[0-9][0-9][0-9][0-9].{4})|6(?:[45][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{736}|8[0-9][0-9][0-9][0-9].{584}|1[0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9].{16})|8(?:2[0-9][0-9][0-9][0-9].{132}|4[0-9][0-9][0-9][0-9].{352}|6[0-9][0-9][0-9][0-9].{120}|7[0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{4})|9(?:[239][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{352}|6[0-9][0-9][0-9][0-9].{48})|4(?:[256][0-9][0-9][0-9][0-9].{12}|[014][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{36})|3(?:[03][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{872}|7[0-9][0-9][0-9][0-9].{36})|2(?:8[0-9][0-9][0-9][0-9].{584}|2[0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{4})|7(?:[0189][0-9][0-9][0-9][0-9].{8}|[45][0-9][0-9][0-9][0-9].{12})|5(?:7[0-9][0-9][0-9][0-9].{144}|1[0-9][0-9][0-9][0-9].{16}))|8(?:3(?:[89][0-9][0-9][0-9][0-9].{24}|[03][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{12})|8(?:4[0-9][0-9][0-9][0-9].{352}|6[0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{4})|9(?:[29][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{8})|4(?:[0-2][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{12})|5(?:7[0-9][0-9][0-9][0-9].{144}|2[0-9][0-9][0-9][0-9].{8})|0(?:1[0-9][0-9][0-9][0-9].{48}|7[0-9][0-9][0-9][0-9].{8})|6(?:0[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{8})|(?:11|22)[0-9][0-9][0-9][0-9].{120}|7[089][0-9][0-9][0-9][0-9].{8}))|4(?:1(?:0(?:[01][0-9][0-9][0-9][0-9].{24}|4[0-9][0-9][0-9][0-9].{104}|3[0-9][0-9][0-9][0-9].{32}|5[0-9][0-9][0-9][0-9].{4})|1[0-3][0-9][0-9][0-9][0-9].{24}|4[12][0-9][0-9][0-9][0-9].{660})|3(?:0(?:[2-58][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{48}|9[0-9][0-9][0-9][0-9].{8})|99[0-9][0-9][0-9][0-9].{8}))|5(?:0(?:[249][0-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9][0-9].{4})|8(?:5[0-9][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9][0-9].{4})|[45]0[0-9][0-9][0-9][0-9][0-9].{8}|28[0-9][0-9][0-9][0-9][0-9].{324}|66[0-9][0-9][0-9][0-9][0-9].{20})|36(?:(?:(?:4[7-9]|5[49]|99)[0-9]|7(?:[35][0-9]|47))[0-9][0-9][0-9].{4}|0(?:[1-36-8][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{224})|6(?:0[0-9][0-9][0-9][0-9].{224}|2[0-9][0-9][0-9][0-9].{4}))|8428[0-9][0-9][0-9][0-9].{8})|2(?:5(?:2(?:3(?:[01][0-9][0-9][0-9][0-9].{48}|[34][0-9][0-9][0-9][0-9].{44}|[56][0-9][0-9][0-9][0-9].{28}|[89][0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9].{332}|7[0-9][0-9][0-9][0-9].{112})|5(?:[013-5][0-9][0-9][0-9][0-9].{28}|2[0-9][0-9][0-9][0-9].{212}|6[0-9][0-9][0-9][0-9].{428}|7[0-9][0-9][0-9][0-9].{540}|8[0-9][0-9][0-9][0-9].{240}|9[0-9][0-9][0-9][0-9].{128})|7(?:[47-9][0-9][0-9][0-9][0-9].{28}|[15][0-9][0-9][0-9][0-9].{56}|0[0-9][0-9][0-9][0-9].{148}|2[0-9][0-9][0-9][0-9].{136}|3[0-9][0-9][0-9][0-9].{60}|6[0-9][0-9][0-9][0-9].{12})|6(?:[3-7][0-9][0-9][0-9][0-9].{28}|[01][0-9][0-9][0-9][0-9].{128}|8[0-9][0-9][0-9][0-9].{164}|2[0-9][0-9][0-9][0-9].{20}|9[0-9][0-9][0-9][0-9].{56})|1(?:[2-7][0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{540}|1[0-9][0-9][0-9][0-9].{48}|8[0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{8})|4(?:[135-79][0-9][0-9][0-9][0-9].{28}|[28][0-9][0-9][0-9][0-9].{84}|0[0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{88})|8(?:[0-3][0-9][0-9][0-9][0-9].{28}|[468][0-9][0-9][0-9][0-9].{84}|7[0-9][0-9][0-9][0-9].{168}|9[0-9][0-9][0-9][0-9].{48})|0(?:[0-6][0-9][0-9][0-9][0-9].{60}|7[0-9][0-9][0-9][0-9].{232}|8[0-9][0-9][0-9][0-9].{84}|9[0-9][0-9][0-9][0-9].{8})|2(?:[3-9][0-9][0-9][0-9][0-9].{48}|[0-2][0-9][0-9][0-9][0-9].{108})|9(?:[0-7][0-9][0-9][0-9][0-9].{48}|[89][0-9][0-9][0-9][0-9].{56}))|7(?:2(?:[34][0-9][0-9][0-9][0-9].{108}|0[0-9][0-9][0-9][0-9].{388}|2[0-9][0-9][0-9][0-9].{148}|5[0-9][0-9][0-9][0-9].{80}|6[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{84}|9[0-9][0-9][0-9][0-9].{48}|1[0-9][0-9][0-9][0-9].{8})|5(?:[5689][0-9][0-9][0-9][0-9].{36}|[01][0-9][0-9][0-9][0-9].{44}|3[0-9][0-9][0-9][0-9].{460}|4[0-9][0-9][0-9][0-9].{196}|2[0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{52})|8(?:[0-36][0-9][0-9][0-9][0-9].{28}|[48][0-9][0-9][0-9][0-9].{84}|5[0-9][0-9][0-9][0-9].{244}|9[0-9][0-9][0-9][0-9].{48}|7[0-9][0-9][0-9][0-9].{8})|6(?:[2-59][0-9][0-9][0-9][0-9].{28}|[78][0-9][0-9][0-9][0-9].{128}|[01][0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{392})|4(?:[1-6][0-9][0-9][0-9][0-9].{48}|[08][0-9][0-9][0-9][0-9].{84}|7[0-9][0-9][0-9][0-9].{108}|9[0-9][0-9][0-9][0-9].{44})|9(?:[4-9][0-9][0-9][0-9][0-9].{56}|[0-2][0-9][0-9][0-9][0-9].{48}|3[0-9][0-9][0-9][0-9].{348})|1(?:[0-7][0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{104}|8[0-9][0-9][0-9][0-9].{28})|7(?:[0-47-9][0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{88}|6[0-9][0-9][0-9][0-9].{12})|0[0-9][0-9][0-9][0-9][0-9].{44}|3[0-9][0-9][0-9][0-9][0-9].{48})|0(?:5(?:[1-379][0-9][0-9][0-9][0-9].{8}|[568][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{40}|4[0-9][0-9][0-9][0-9].{80})|6(?:[0-4][0-9][0-9][0-9][0-9].{20}|[6-9][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{40})|7(?:[03-79][0-9][0-9][0-9][0-9].{8}|[12][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{16})|8(?:[2-79][0-9][0-9][0-9][0-9].{24}|[01][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{44})|0(?:[02-5][0-9][0-9][0-9][0-9].{16}|[16-9][0-9][0-9][0-9][0-9].{8})|4(?:[3-9][0-9][0-9][0-9][0-9].{8}|[0-2][0-9][0-9][0-9][0-9].{12})|3(?:[0-46-9][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{16})|1(?:[0-46-9][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{12})|9(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{8})|2[0-9][0-9][0-9][0-9][0-9].{8})|3(?:5(?:[0249][0-9][0-9][0-9][0-9].{12}|[68][0-9][0-9][0-9][0-9].{80}|[57][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{320}|1[0-9][0-9][0-9][0-9].{16})|4(?:[1-35][0-9][0-9][0-9][0-9].{40}|[068][0-9][0-9][0-9][0-9].{12}|[79][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{104})|9(?:[02-7][0-9][0-9][0-9][0-9].{8}|[89][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{40})|3(?:[0-46-8][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{80})|0(?:[35-9][0-9][0-9][0-9][0-9].{8}|[0-24][0-9][0-9][0-9][0-9].{12})|2(?:[346-9][0-9][0-9][0-9][0-9].{12}|[0-25][0-9][0-9][0-9][0-9].{8})|8(?:[1-8][0-9][0-9][0-9][0-9].{8}|[09][0-9][0-9][0-9][0-9].{12})|6(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|[17][0-9][0-9][0-9][0-9][0-9].{8})|5(?:6(?:[2-4][0-9][0-9][0-9][0-9].{88}|[7-9][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{196}|1[0-9][0-9][0-9][0-9].{316}|6[0-9][0-9][0-9][0-9].{288}|5[0-9][0-9][0-9][0-9].{56})|9(?:[1-4][0-9][0-9][0-9][0-9].{40}|[58][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{132}|7[0-9][0-9][0-9][0-9].{112}|9[0-9][0-9][0-9][0-9].{100}|0[0-9][0-9][0-9][0-9].{56})|5(?:6[0-9][0-9][0-9][0-9].{140}|9[0-9][0-9][0-9][0-9].{112}|5[0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{8})|0(?:1[0-9][0-9][0-9][0-9].{216}|2[0-9][0-9][0-9][0-9].{196}|3[0-9][0-9][0-9][0-9].{272}|0[0-9][0-9][0-9][0-9].{56})|8(?:[0-7][0-9][0-9][0-9][0-9].{36}|[89][0-9][0-9][0-9][0-9].{56})|7[0-9][0-9][0-9][0-9][0-9].{36})|6(?:5(?:[02-5][0-9][0-9][0-9][0-9].{8}|[67][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{40})|6(?:[4-7][0-9][0-9][0-9][0-9].{12}|[1-3][0-9][0-9][0-9][0-9].{8}|[89][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{16})|9(?:[1-358][0-9][0-9][0-9][0-9].{12}|[467][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{8})|0(?:[1457-9][0-9][0-9][0-9][0-9].{8}|[026][0-9][0-9][0-9][0-9].{80}|3[0-9][0-9][0-9][0-9].{12})|3(?:[1-46-9][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{80})|2(?:[0-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{40})|[78][0-9][0-9][0-9][0-9][0-9].{24}|[14][0-9][0-9][0-9][0-9][0-9].{8})|80(?:[0-5][0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{132}|6[0-9][0-9][0-9][0-9].{56})|[14][0-9][0-9][0-9][0-9][0-9][0-9].{4})|7(?:8(?:9(?:[01][0-9][0-9][0-9][0-9].{44}|[39][0-9][0-9][0-9][0-9].{28}|[67][0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{108}|2[0-9][0-9][0-9][0-9].{84}|5[0-9][0-9][0-9][0-9].{48}|8[0-9][0-9][0-9][0-9].{52})|7(?:[2-4][0-9][0-9][0-9][0-9].{12}|[08][0-9][0-9][0-9][0-9].{44}|[56][0-9][0-9][0-9][0-9].{68}|1[0-9][0-9][0-9][0-9].{40}|7[0-9][0-9][0-9][0-9].{28})|6(?:[13-6][0-9][0-9][0-9][0-9].{4}|[28][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{40})|2(?:[0-489][0-9][0-9][0-9][0-9].{12}|[56][0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9].{36})|0(?:[3-79][0-9][0-9][0-9][0-9].{32}|[0-2][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{52})|4(?:[1-7][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{44})|8(?:[0235-79][0-9][0-9][0-9][0-9].{44}|[48][0-9][0-9][0-9][0-9].{84}|1[0-9][0-9][0-9][0-9].{8})|5(?:[2-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{44}|1[0-9][0-9][0-9][0-9].{12})|1(?:[0-7][0-9][0-9][0-9][0-9].{32}|[89][0-9][0-9][0-9][0-9].{12})|3(?:[0-4][0-9][0-9][0-9][0-9].{20}|[5-9][0-9][0-9][0-9][0-9].{12}))|2(?:8(?:[12679][0-9][0-9][0-9][0-9].{8}|[3-5][0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{128}|0[0-9][0-9][0-9][0-9].{20})|5(?:[013478][0-9][0-9][0-9][0-9].{20}|[29][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{12})|7(?:[1347-9][0-9][0-9][0-9][0-9].{8}|[26][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{20})|1(?:[246-8][0-9][0-9][0-9][0-9].{8}|[019][0-9][0-9][0-9][0-9].{24}|[35][0-9][0-9][0-9][0-9].{16})|2(?:[13689][0-9][0-9][0-9][0-9].{16}|[027][0-9][0-9][0-9][0-9].{8}|[45][0-9][0-9][0-9][0-9].{24})|6(?:[02356][0-9][0-9][0-9][0-9].{8}|[179][0-9][0-9][0-9][0-9].{20}|[48][0-9][0-9][0-9][0-9].{12})|0(?:[3-79][0-9][0-9][0-9][0-9].{24}|[0-2][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{16})|4(?:[135-79][0-9][0-9][0-9][0-9].{20}|[048][0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{8})|3(?:[0135-9][0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{8})|9(?:[0347-9][0-9][0-9][0-9][0-9].{16}|[1256][0-9][0-9][0-9][0-9].{8}))|7(?:7(?:[2-59][0-9][0-9][0-9][0-9].{8}|[07][0-9][0-9][0-9][0-9].{80}|1[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{12})|1(?:[2-689][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{12})|8(?:[07-9][0-9][0-9][0-9][0-9].{12}|[2-6][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{132})|6(?:[1269][0-9][0-9][0-9][0-9].{12}|[3-578][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16})|0(?:[0-579][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{24})|4(?:[4-9][0-9][0-9][0-9][0-9].{12}|[0-3][0-9][0-9][0-9][0-9].{24})|2(?:[0-68][0-9][0-9][0-9][0-9].{8}|[79][0-9][0-9][0-9][0-9].{12})|5(?:[013-9][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{16})|3[0-9][0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9][0-9].{8})|6(?:8(?:[3-5][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{40}|[29][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{172}|6[0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{88})|5(?:[1348][0-9][0-9][0-9][0-9].{12}|[679][0-9][0-9][0-9][0-9].{20}|[025][0-9][0-9][0-9][0-9].{8})|6(?:[0235][0-9][0-9][0-9][0-9].{20}|[489][0-9][0-9][0-9][0-9].{12}|[167][0-9][0-9][0-9][0-9].{8})|3(?:[1-35-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{32})|0(?:[3-7][0-9][0-9][0-9][0-9].{16}|[0-289][0-9][0-9][0-9][0-9].{8})|4(?:[0-35-8][0-9][0-9][0-9][0-9].{12}|[49][0-9][0-9][0-9][0-9].{8})|7(?:[0-4][0-9][0-9][0-9][0-9].{20}|[5-9][0-9][0-9][0-9][0-9].{8})|2(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|9[0-9][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9][0-9].{8})|9(?:1(?:[1-4][0-9][0-9][0-9][0-9].{28}|[56][0-9][0-9][0-9][0-9].{56}|0[0-9][0-9][0-9][0-9].{168}|7[0-9][0-9][0-9][0-9].{444}|8[0-9][0-9][0-9][0-9].{416}|9[0-9][0-9][0-9][0-9].{88})|8(?:[4-9][0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{196}|3[0-9][0-9][0-9][0-9].{124}|2[0-9][0-9][0-9][0-9].{88})|0(?:[03-9][0-9][0-9][0-9][0-9].{28}|[12][0-9][0-9][0-9][0-9].{128})|2[0-5][0-9][0-9][0-9][0-9].{36}|79[0-9][0-9][0-9][0-9].{340}))|4(?:6(?:8(?:[0248][0-9][0-9][0-9][0-9].{84}|[19][0-9][0-9][0-9][0-9].{48}|5[0-9][0-9][0-9][0-9].{112}|3[0-9][0-9][0-9][0-9].{28}|6[0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{44})|9(?:[3-578][0-9][0-9][0-9][0-9].{36}|[26][0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{128}|0[0-9][0-9][0-9][0-9].{48}|1[0-9][0-9][0-9][0-9].{28})|0(?:[015-7][0-9][0-9][0-9][0-9].{4}|[34][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{104}|9[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{8})|6(?:[0-49][0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{408}|5[0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{84}|7[0-9][0-9][0-9][0-9].{8})|7(?:[03-578][0-9][0-9][0-9][0-9].{44}|[12][0-9][0-9][0-9][0-9].{108}|6[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{48})|2(?:[3-7][0-9][0-9][0-9][0-9].{44}|[0-2][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{60})|5(?:[0-57][0-9][0-9][0-9][0-9].{60}|[89][0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{52})|4(?:[0-589][0-9][0-9][0-9][0-9].{60}|7[0-9][0-9][0-9][0-9].{180}|6[0-9][0-9][0-9][0-9].{52})|1(?:[1-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{40})|3[0-9][0-9][0-9][0-9][0-9].{60})|9(?:8(?:[13-5][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{88}|6[0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{84}|9[0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{8})|5(?:[4-9][0-9][0-9][0-9][0-9].{20}|[01][0-9][0-9][0-9][0-9].{32}|3[0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9].{8})|2(?:[4-9][0-9][0-9][0-9][0-9].{32}|[0-2][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{116})|4(?:[0-35-8][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{300}|4[0-9][0-9][0-9][0-9].{40})|1(?:[0-69][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{292}|8[0-9][0-9][0-9][0-9].{12})|6(?:[02-9][0-9][0-9][0-9][0-9].{20}|1[0-9][0-9][0-9][0-9].{12})|7(?:[0-8][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{48})|3[0-9][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9][0-9].{8})|4(?:8(?:[1-35-79][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{100}|0[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{12})|6(?:[3-9][0-9][0-9][0-9][0-9].{12}|[12][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{8})|7(?:[2-589][0-9][0-9][0-9][0-9].{8}|[167][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{16})|5(?:[2-9][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{260}|0[0-9][0-9][0-9][0-9].{12})|2(?:[0-6][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{8})|4(?:[2-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{8})|9(?:[1-8][0-9][0-9][0-9][0-9].{8}|[09][0-9][0-9][0-9][0-9].{12})|0(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16})|1[0-9][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9][0-9].{8})|2(?:2(?:[0-4][0-9][0-9][0-9][0-9].{28}|[56][0-9][0-9][0-9][0-9].{56}|7[0-9][0-9][0-9][0-9].{156}|8[0-9][0-9][0-9][0-9].{48}|9[0-9][0-9][0-9][0-9].{88})|6(?:[0-5][0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{112}|6[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{8})|0(?:[0-49][0-9][0-9][0-9][0-9].{28}|[5-7][0-9][0-9][0-9][0-9].{56}|8[0-9][0-9][0-9][0-9].{168})|4(?:[5-9][0-9][0-9][0-9][0-9].{36}|[0-3][0-9][0-9][0-9][0-9].{48}|4[0-9][0-9][0-9][0-9].{56})|3(?:[2-9][0-9][0-9][0-9][0-9].{48}|[01][0-9][0-9][0-9][0-9].{88})|1[0-9][0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9][0-9].{36})|5(?:4(?:[0-6][0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{8})|1(?:[0-6][0-9][0-9][0-9][0-9].{32}|[7-9][0-9][0-9][0-9][0-9].{12})|2(?:[0-5][0-9][0-9][0-9][0-9].{12}|[6-9][0-9][0-9][0-9][0-9].{20})|7(?:[0-7][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{4})|3(?:[1-9][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{36})|6(?:[1-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{20})|[89][0-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9][0-9].{32}|5[0-9][0-9][0-9][0-9][0-9].{12})|[01378][0-9][0-9][0-9][0-9][0-9][0-9].{4})|3(?:0(?:9(?:[019][0-9][0-9][0-9][0-9].{52}|[2-4][0-9][0-9][0-9][0-9].{12}|[78][0-9][0-9][0-9][0-9].{44}|5[0-9][0-9][0-9][0-9].{180}|6[0-9][0-9][0-9][0-9].{28})|0(?:[5-9][0-9][0-9][0-9][0-9].{248}|[12][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{108}|0[0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{36})|8(?:[01479][0-9][0-9][0-9][0-9].{12}|[36][0-9][0-9][0-9][0-9].{40}|5[0-9][0-9][0-9][0-9].{52}|8[0-9][0-9][0-9][0-9].{84}|2[0-9][0-9][0-9][0-9].{8})|3(?:[3-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{248}|2[0-9][0-9][0-9][0-9].{228})|2(?:[5-9][0-9][0-9][0-9][0-9].{248}|[0-4][0-9][0-9][0-9][0-9].{20})|5(?:[0-5][0-9][0-9][0-9][0-9].{12}|[6-9][0-9][0-9][0-9][0-9].{4})|7(?:[0-8][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{104})|1[0-9][0-9][0-9][0-9][0-9].{20}|4[0-9][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9][0-9].{4})|6(?:5(?:[1-5][0-9][0-9][0-9][0-9].{8}|[6-8][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{24})|1(?:[4-8][0-9][0-9][0-9][0-9].{8}|[1-3][0-9][0-9][0-9][0-9].{40}|[09][0-9][0-9][0-9][0-9].{12})|6(?:[016-9][0-9][0-9][0-9][0-9].{8}|[245][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{12})|7(?:[1-79][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{12})|0(?:[1-689][0-9][0-9][0-9][0-9].{8}|[07][0-9][0-9][0-9][0-9].{12})|8(?:[02-9][0-9][0-9][0-9][0-9].{24}|1[0-9][0-9][0-9][0-9].{132})|9(?:[1-6][0-9][0-9][0-9][0-9].{24}|[07-9][0-9][0-9][0-9][0-9].{8})|3(?:[0-57-9][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{12})|4(?:[0-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{16})|2[0-9][0-9][0-9][0-9][0-9].{8})|4(?:5(?:[013479][0-9][0-9][0-9][0-9].{8}|[56][0-9][0-9][0-9][0-9].{284}|2[0-9][0-9][0-9][0-9].{128}|8[0-9][0-9][0-9][0-9].{20})|2(?:[0-367][0-9][0-9][0-9][0-9].{16}|[49][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{284}|8[0-9][0-9][0-9][0-9].{12})|6(?:[3568][0-9][0-9][0-9][0-9].{20}|[1479][0-9][0-9][0-9][0-9].{8}|[02][0-9][0-9][0-9][0-9].{80})|8(?:[04-79][0-9][0-9][0-9][0-9].{8}|[1-3][0-9][0-9][0-9][0-9].{20}|8[0-9][0-9][0-9][0-9].{304})|0(?:[02-8][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{32})|4(?:[1-57-9][0-9][0-9][0-9][0-9].{8}|[06][0-9][0-9][0-9][0-9].{28})|7(?:[013478][0-9][0-9][0-9][0-9].{8}|[2569][0-9][0-9][0-9][0-9].{20})|3(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|[19][0-9][0-9][0-9][0-9][0-9].{16})|[1-3578][0-9][0-9][0-9][0-9][0-9][0-9].{4})|6(?:1(?:8(?:[2-5][0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{388}|0[0-9][0-9][0-9][0-9].{56}|1[0-9][0-9][0-9][0-9].{52}|6[0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{88}|8[0-9][0-9][0-9][0-9].{84})|6(?:[3-6][0-9][0-9][0-9][0-9].{44}|[0-2][0-9][0-9][0-9][0-9].{48}|7[0-9][0-9][0-9][0-9].{128}|8[0-9][0-9][0-9][0-9].{372}|9[0-9][0-9][0-9][0-9].{28})|3(?:[3-7][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{68}|[01][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{40})|5(?:[4-9][0-9][0-9][0-9][0-9].{48}|[13][0-9][0-9][0-9][0-9].{28}|2[0-9][0-9][0-9][0-9].{108}|0[0-9][0-9][0-9][0-9].{44})|1(?:[3-6][0-9][0-9][0-9][0-9].{12}|[0-2][0-9][0-9][0-9][0-9].{20}|[7-9][0-9][0-9][0-9][0-9].{4})|9(?:[3-9][0-9][0-9][0-9][0-9].{36}|[12][0-9][0-9][0-9][0-9].{124}|0[0-9][0-9][0-9][0-9].{56})|7(?:[02-8][0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{56})|4(?:[1-9][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{68})|0[0-9][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9][0-9].{4})|2(?:0(?:[12][0-9][0-9][0-9][0-9].{476}|[89][0-9][0-9][0-9][0-9].{76}|7[0-9][0-9][0-9][0-9].{744}|3[0-9][0-9][0-9][0-9].{44}|4[0-9][0-9][0-9][0-9].{36}|5[0-9][0-9][0-9][0-9].{56}|6[0-9][0-9][0-9][0-9].{48})|6(?:[457-9][0-9][0-9][0-9][0-9].{144}|0[0-9][0-9][0-9][0-9].{912}|1[0-9][0-9][0-9][0-9].{476}|6[0-9][0-9][0-9][0-9].{100}|2[0-9][0-9][0-9][0-9].{52}|3[0-9][0-9][0-9][0-9].{92})|7(?:[0-5][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{328}|8[0-9][0-9][0-9][0-9].{476}|9[0-9][0-9][0-9][0-9].{108}|6[0-9][0-9][0-9][0-9].{88})|8(?:[89][0-9][0-9][0-9][0-9].{328}|0[0-9][0-9][0-9][0-9].{452}|1[0-9][0-9][0-9][0-9].{144}|2[0-9][0-9][0-9][0-9].{888}|7[0-9][0-9][0-9][0-9].{852})|1(?:[0-489][0-9][0-9][0-9][0-9].{76}|[67][0-9][0-9][0-9][0-9].{92}|5[0-9][0-9][0-9][0-9].{720})|3(?:[0-57-9][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{92})|[2459][0-9][0-9][0-9][0-9][0-9].{4})|9(?:6(?:[0-46][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{88})|5(?:0[0-9][0-9][0-9][0-9].{100}|1[0-9][0-9][0-9][0-9].{76})|0(?:6[0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{36})|80[0-9][0-9][0-9][0-9].{452}|70[0-9][0-9][0-9][0-9].{92}))|1(?:4(?:9(?:[235-8][0-9][0-9][0-9][0-9].{20}|[01][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{180}|4[0-9][0-9][0-9][0-9].{36})|6(?:[5-9][0-9][0-9][0-9][0-9].{32}|[01][0-9][0-9][0-9][0-9].{12}|[2-4][0-9][0-9][0-9][0-9].{8})|7(?:[35-9][0-9][0-9][0-9][0-9].{32}|[0-2][0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{52})|4(?:[03-9][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{12})|8(?:[05-9][0-9][0-9][0-9][0-9].{12}|[1-4][0-9][0-9][0-9][0-9].{32})|0(?:[0-7][0-9][0-9][0-9][0-9].{24}|[89][0-9][0-9][0-9][0-9].{8})|2(?:[2-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{8})|5(?:[1-46-9][0-9][0-9][0-9][0-9].{8}|[05][0-9][0-9][0-9][0-9].{12})|3(?:[0-8][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{8})|1[0-9][0-9][0-9][0-9][0-9].{8})|8(?:8(?:[3-57][0-9][0-9][0-9][0-9].{12}|[69][0-9][0-9][0-9][0-9].{32}|[02][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{52})|3(?:[1-7][0-9][0-9][0-9][0-9].{12}|[09][0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{8})|4(?:[1-5][0-9][0-9][0-9][0-9].{12}|[6-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16})|9(?:[12457-9][0-9][0-9][0-9][0-9].{32}|[036][0-9][0-9][0-9][0-9].{12})|1(?:[4-9][0-9][0-9][0-9][0-9].{12}|[0-3][0-9][0-9][0-9][0-9].{8})|2(?:[0-6][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{8})|5(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|7(?:[0-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{12})|[06][0-9][0-9][0-9][0-9][0-9].{8}))|2(?:2(?:5(?:[0-3][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{32}|[56][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{184})|9(?:[5-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{56}|[23][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{28})|1(?:[2-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{12})|7(?:[0-7][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{32})|8(?:[0-7][0-9][0-9][0-9][0-9].{32}|[89][0-9][0-9][0-9][0-9].{12})|0(?:[0-6][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{8})|2(?:[14-8][0-9][0-9][0-9][0-9].{8}|[0239][0-9][0-9][0-9][0-9].{12})|3(?:[0-246-9][0-9][0-9][0-9][0-9].{8}|[35][0-9][0-9][0-9][0-9].{12})|4(?:[0-35-9][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{100})|6(?:[0-57-9][0-9][0-9][0-9][0-9].{32}|6[0-9][0-9][0-9][0-9].{52}))|1(?:0(?:[23][0-9][0-9][0-9][0-9].{544}|[79][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{436}|1[0-9][0-9][0-9][0-9].{112}|4[0-9][0-9][0-9][0-9].{356}|5[0-9][0-9][0-9][0-9].{468}|6[0-9][0-9][0-9][0-9].{88}|8[0-9][0-9][0-9][0-9].{56})|3(?:1[0-9][0-9][0-9][0-9].{132}|2[0-9][0-9][0-9][0-9].{112}|0[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{8})|1(?:[2-9][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{124}|1[0-9][0-9][0-9][0-9].{252})|2(?:[0-6][0-9][0-9][0-9][0-9].{36}|[89][0-9][0-9][0-9][0-9].{40}|7[0-9][0-9][0-9][0-9].{8}))|[37-9][0-9][0-9][0-9][0-9][0-9][0-9].{4})|85(?:3(?:[189][0-9][0-9][0-9][0-9].{12}|[467][0-9][0-9][0-9][0-9].{40}|[23][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{104}|5[0-9][0-9][0-9][0-9].{52})|6(?:[0-46][0-9][0-9][0-9][0-9].{44}|8[0-9][0-9][0-9][0-9].{116}|5[0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{60})|7(?:[0-249][0-9][0-9][0-9][0-9].{60}|[6-8][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{172}|5[0-9][0-9][0-9][0-9].{52})|5(?:[05-9][0-9][0-9][0-9][0-9].{44}|[34][0-9][0-9][0-9][0-9].{68}|1[0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{28})|8(?:[0-3679][0-9][0-9][0-9][0-9].{60}|[48][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{52})|9(?:[0-2467][0-9][0-9][0-9][0-9].{60}|[389][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{52})|4(?:[0-46-8][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{40})|0(?:[2-9][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{12})|2(?:[0-8][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{376})|1[0-9][0-9][0-9][0-9][0-9].{4})|9(?:0(?:8(?:[13-6][0-9][0-9][0-9][0-9].{12}|[029][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{156}|8[0-9][0-9][0-9][0-9].{812})|3(?:[01679][0-9][0-9][0-9][0-9].{8}|[3-5][0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{28})|2(?:[027-9][0-9][0-9][0-9][0-9].{8}|[13-5][0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{12})|9(?:[013489][0-9][0-9][0-9][0-9].{8}|[5-7][0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{32})|0(?:[1-489][0-9][0-9][0-9][0-9].{8}|[05-7][0-9][0-9][0-9][0-9].{16})|4(?:[0-578][0-9][0-9][0-9][0-9].{8}|[69][0-9][0-9][0-9][0-9].{20})|5(?:[1-59][0-9][0-9][0-9][0-9].{20}|[06-8][0-9][0-9][0-9][0-9].{8})|6(?:[2-69][0-9][0-9][0-9][0-9].{20}|[0178][0-9][0-9][0-9][0-9].{8})|7(?:[0-47-9][0-9][0-9][0-9][0-9].{8}|[56][0-9][0-9][0-9][0-9].{12})|1(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{8}))|[6-9][0-9][0-9][0-9][0-9][0-9][0-9].{4}))|5(?:3(?:3(?:0(?:[257][0-9][0-9][0-9][0-9].{8}|[34][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{184}|6[0-9][0-9][0-9][0-9].{428}|8[0-9][0-9][0-9][0-9].{408}|9[0-9][0-9][0-9][0-9].{128}|1[0-9][0-9][0-9][0-9].{44})|5(?:[5689][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{192}|2[0-9][0-9][0-9][0-9].{84}|3[0-9][0-9][0-9][0-9].{20}|4[0-9][0-9][0-9][0-9].{32}|7[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{8})|7(?:[236-8][0-9][0-9][0-9][0-9].{12}|[45][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{192}|9[0-9][0-9][0-9][0-9].{460}|1[0-9][0-9][0-9][0-9].{32})|4(?:[1-356][0-9][0-9][0-9][0-9].{32}|[78][0-9][0-9][0-9][0-9].{40}|0[0-9][0-9][0-9][0-9].{192}|4[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{36})|1(?:[6-9][0-9][0-9][0-9][0-9].{32}|[2-4][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{300}|5[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{8})|6(?:[25-9][0-9][0-9][0-9][0-9].{12}|[04][0-9][0-9][0-9][0-9].{192}|1[0-9][0-9][0-9][0-9].{32}|3[0-9][0-9][0-9][0-9].{48})|2(?:[1-35-9][0-9][0-9][0-9][0-9].{32}|4[0-9][0-9][0-9][0-9].{192}|0[0-9][0-9][0-9][0-9].{12})|3(?:[124-9][0-9][0-9][0-9][0-9].{32}|0[0-9][0-9][0-9][0-9].{192}|3[0-9][0-9][0-9][0-9].{12})|[89][0-9][0-9][0-9][0-9][0-9].{20})|2(?:3(?:[4-8][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{288}|1[0-9][0-9][0-9][0-9].{136}|9[0-9][0-9][0-9][0-9].{112}|2[0-9][0-9][0-9][0-9].{88}|3[0-9][0-9][0-9][0-9].{44})|2(?:[1-57][0-9][0-9][0-9][0-9].{48}|6[0-9][0-9][0-9][0-9].{112}|8[0-9][0-9][0-9][0-9].{372}|0[0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{28})|0(?:[1346-8][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{304}|9[0-9][0-9][0-9][0-9].{128}|5[0-9][0-9][0-9][0-9].{48}|2[0-9][0-9][0-9][0-9].{8})|5(?:[45][0-9][0-9][0-9][0-9].{40}|[36][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{212}|1[0-9][0-9][0-9][0-9].{252}|2[0-9][0-9][0-9][0-9].{52})|4(?:[3-9][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{56}|2[0-9][0-9][0-9][0-9].{52}|1[0-9][0-9][0-9][0-9].{8})|1(?:[2-9][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{492}|1[0-9][0-9][0-9][0-9].{108})|8(?:[2-7][0-9][0-9][0-9][0-9].{36}|[08][0-9][0-9][0-9][0-9].{84}|1[0-9][0-9][0-9][0-9].{48})|6(?:3[0-9][0-9][0-9][0-9].{272}|2[0-9][0-9][0-9][0-9].{52}))|1(?:5(?:[1-3][0-9][0-9][0-9][0-9].{28}|[89][0-9][0-9][0-9][0-9].{32}|0[0-9][0-9][0-9][0-9].{300}|5[0-9][0-9][0-9][0-9].{392}|6[0-9][0-9][0-9][0-9].{240}|7[0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{8})|9(?:[0-5][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{116}|6[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{56}|8[0-9][0-9][0-9][0-9].{40})|1(?:[2-5][0-9][0-9][0-9][0-9].{12}|[189][0-9][0-9][0-9][0-9].{16}|[067][0-9][0-9][0-9][0-9].{8})|6(?:[2-9][0-9][0-9][0-9][0-9].{32}|0[0-9][0-9][0-9][0-9].{100}|1[0-9][0-9][0-9][0-9].{52})|8(?:[0-6][0-9][0-9][0-9][0-9].{192}|[7-9][0-9][0-9][0-9][0-9].{32})|7(?:[0-46-8][0-9][0-9][0-9][0-9].{12}|[59][0-9][0-9][0-9][0-9].{32})|0(?:[0-8][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{260})|3(?:[4-9][0-9][0-9][0-9][0-9].{8}|[0-3][0-9][0-9][0-9][0-9].{12})|2(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16})|4[0-9][0-9][0-9][0-9][0-9].{8})|6(?:4(?:[68][0-9][0-9][0-9][0-9].{56}|0[0-9][0-9][0-9][0-9].{196}|2[0-9][0-9][0-9][0-9].{468}|3[0-9][0-9][0-9][0-9].{316}|4[0-9][0-9][0-9][0-9].{156}|5[0-9][0-9][0-9][0-9].{112}|9[0-9][0-9][0-9][0-9].{124}|1[0-9][0-9][0-9][0-9].{88}|7[0-9][0-9][0-9][0-9].{8})|2(?:[2-4][0-9][0-9][0-9][0-9].{68}|[01][0-9][0-9][0-9][0-9].{28}|6[0-9][0-9][0-9][0-9].{348}|7[0-9][0-9][0-9][0-9].{444}|8[0-9][0-9][0-9][0-9].{164}|9[0-9][0-9][0-9][0-9].{56}|5[0-9][0-9][0-9][0-9].{8})|3(?:[0348][0-9][0-9][0-9][0-9].{56}|1[0-9][0-9][0-9][0-9].{216}|5[0-9][0-9][0-9][0-9].{112}|6[0-9][0-9][0-9][0-9].{140}|7[0-9][0-9][0-9][0-9].{196}|2[0-9][0-9][0-9][0-9].{40})|0(?:[3-8][0-9][0-9][0-9][0-9].{28}|[0-2][0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{56})|1(?:[2-9][0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{168})|5(?:0[0-9][0-9][0-9][0-9].{124}|3[0-9][0-9][0-9][0-9].{88}))|5(?:5(?:[0-2][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{60}|[35][0-9][0-9][0-9][0-9].{52}|6[0-9][0-9][0-9][0-9].{116}|4[0-9][0-9][0-9][0-9].{28})|3(?:[3-6][0-9][0-9][0-9][0-9].{12}|[189][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{104}|7[0-9][0-9][0-9][0-9].{248}|0[0-9][0-9][0-9][0-9].{4})|4(?:[2-47-9][0-9][0-9][0-9][0-9].{12}|[016][0-9][0-9][0-9][0-9].{40}|5[0-9][0-9][0-9][0-9].{52})|7(?:[02-49][0-9][0-9][0-9][0-9].{60}|[16-8][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{52})|9(?:[0-47-9][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{180}|6[0-9][0-9][0-9][0-9].{60})|8(?:[0-25689][0-9][0-9][0-9][0-9].{12}|[347][0-9][0-9][0-9][0-9].{60})|0(?:[2-9][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{12})|6(?:[0-46-9][0-9][0-9][0-9][0-9].{60}|5[0-9][0-9][0-9][0-9].{52})|[12][0-9][0-9][0-9][0-9][0-9].{4})|4[0-9][0-9][0-9][0-9][0-9][0-9].{4})|8(?:6(?:4(?:[0-4][0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{136}|8[0-9][0-9][0-9][0-9].{132}|5[0-9][0-9][0-9][0-9].{56}|7[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{48})|7(?:[0-36][0-9][0-9][0-9][0-9].{48}|[78][0-9][0-9][0-9][0-9].{88}|4[0-9][0-9][0-9][0-9].{196}|5[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{52})|8(?:[1-357][0-9][0-9][0-9][0-9].{56}|[08][0-9][0-9][0-9][0-9].{84}|4[0-9][0-9][0-9][0-9].{124}|6[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{28})|1(?:[2-5][0-9][0-9][0-9][0-9].{44}|[7-9][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{80}|1[0-9][0-9][0-9][0-9].{48}|6[0-9][0-9][0-9][0-9].{28})|0(?:[1-5][0-9][0-9][0-9][0-9].{44}|[7-9][0-9][0-9][0-9][0-9].{108}|0[0-9][0-9][0-9][0-9].{388}|6[0-9][0-9][0-9][0-9].{48})|2(?:[2-7][0-9][0-9][0-9][0-9].{28}|[01][0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{40})|3(?:[2-9][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{128}|1[0-9][0-9][0-9][0-9].{88})|9(?:[0-7][0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{112}|9[0-9][0-9][0-9][0-9].{56})|6(?:[6-9][0-9][0-9][0-9][0-9].{48}|5[0-9][0-9][0-9][0-9].{20}))|2(?:9(?:[0134][0-9][0-9][0-9][0-9].{12}|[78][0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{292}|9[0-9][0-9][0-9][0-9].{180}|2[0-9][0-9][0-9][0-9].{52}|5[0-9][0-9][0-9][0-9].{28})|7(?:[6-9][0-9][0-9][0-9][0-9].{12}|[0-2][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{40}|4[0-9][0-9][0-9][0-9].{8})|8(?:[5-79][0-9][0-9][0-9][0-9].{12}|[013][0-9][0-9][0-9][0-9].{52}|4[0-9][0-9][0-9][0-9].{228}|8[0-9][0-9][0-9][0-9].{84})|0(?:[2-6][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{116}|[7-9][0-9][0-9][0-9][0-9].{20})|3(?:[135-9][0-9][0-9][0-9][0-9].{12}|[04][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{44})|2(?:[0-7][0-9][0-9][0-9][0-9].{20}|8[0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{12})|1(?:[1-7][0-9][0-9][0-9][0-9].{20}|[089][0-9][0-9][0-9][0-9].{12})|5(?:[3-9][0-9][0-9][0-9][0-9].{4}|[0-2][0-9][0-9][0-9][0-9].{12})|4(?:[1-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{44})|6[0-9][0-9][0-9][0-9][0-9].{4})|1(?:1(?:[15-79][0-9][0-9][0-9][0-9].{8}|[24][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{80}|3[0-9][0-9][0-9][0-9].{16})|8(?:[4-9][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{132}|1[0-9][0-9][0-9][0-9].{320}|2[0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{8})|3(?:[05-9][0-9][0-9][0-9][0-9].{8}|[12][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{156}|4[0-9][0-9][0-9][0-9].{40})|9(?:[02-6][0-9][0-9][0-9][0-9].{24}|[19][0-9][0-9][0-9][0-9].{12}|[78][0-9][0-9][0-9][0-9].{8})|7(?:[013-578][0-9][0-9][0-9][0-9].{8}|[26][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{24})|0(?:[0-7][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{12})|6(?:[014-9][0-9][0-9][0-9][0-9].{8}|[23][0-9][0-9][0-9][0-9].{12})|2(?:[0-57-9][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{16})|[45][0-9][0-9][0-9][0-9][0-9].{8})|7(?:0(?:[14-68][0-9][0-9][0-9][0-9].{8}|[79][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{80}|3[0-9][0-9][0-9][0-9].{12})|2(?:[5-9][0-9][0-9][0-9][0-9].{24}|[023][0-9][0-9][0-9][0-9].{12}|[14][0-9][0-9][0-9][0-9].{8})|3(?:[4-9][0-9][0-9][0-9][0-9].{8}|[0-2][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{108})|6(?:[0136-9][0-9][0-9][0-9][0-9].{12}|[24][0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9].{8})|7(?:[2457-9][0-9][0-9][0-9][0-9].{8}|[136][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{40})|1(?:[0-36-9][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{128}|5[0-9][0-9][0-9][0-9].{28})|4(?:[0-59][0-9][0-9][0-9][0-9].{8}|[6-8][0-9][0-9][0-9][0-9].{24})|8(?:[0-26-9][0-9][0-9][0-9][0-9].{8}|[3-5][0-9][0-9][0-9][0-9].{40})|5(?:[0-79][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{20})|9[0-9][0-9][0-9][0-9][0-9].{16}))|1(?:9(?:7(?:[0-4][0-9][0-9][0-9][0-9].{44}|[56][0-9][0-9][0-9][0-9].{12}|[78][0-9][0-9][0-9][0-9].{48}|9[0-9][0-9][0-9][0-9].{52})|8(?:[1-5][0-9][0-9][0-9][0-9].{36}|[08][0-9][0-9][0-9][0-9].{84}|[79][0-9][0-9][0-9][0-9].{52}|6[0-9][0-9][0-9][0-9].{88})|5(?:[0-5][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{8})|2(?:[2-8][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{36})|6(?:[4-9][0-9][0-9][0-9][0-9].{44}|[0-2][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{68})|9(?:[0-7][0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{180}|8[0-9][0-9][0-9][0-9].{56})|0(?:[0-7][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{588}|8[0-9][0-9][0-9][0-9].{56})|4(?:[0-4][0-9][0-9][0-9][0-9].{12}|[5-9][0-9][0-9][0-9][0-9].{4})|1(?:[0-8][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{12})|3[0-9][0-9][0-9][0-9][0-9].{20})|6(?:5(?:[34689][0-9][0-9][0-9][0-9].{20}|[12][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{24})|6(?:[1479][0-9][0-9][0-9][0-9].{20}|[268][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{24}|5[0-9][0-9][0-9][0-9].{8})|0(?:[2-57-9][0-9][0-9][0-9][0-9].{8}|[16][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{16})|3(?:[124-689][0-9][0-9][0-9][0-9].{8}|[03][0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{80})|4(?:[0237][0-9][0-9][0-9][0-9].{12}|[15689][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{32})|1(?:[016-9][0-9][0-9][0-9][0-9].{8}|[2-5][0-9][0-9][0-9][0-9].{16})|2(?:[0-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{28})|8(?:[0-79][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{44})|9[0-9][0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9][0-9].{8})|7(?:8(?:[067][0-9][0-9][0-9][0-9].{12}|[589][0-9][0-9][0-9][0-9].{32}|[2-4][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{28})|5(?:[1-46][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|5[0-9][0-9][0-9][0-9].{16})|4(?:[1-7][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{12})|9(?:[4-9][0-9][0-9][0-9][0-9].{32}|[0-2][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{104})|1(?:[0-6][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{8})|3(?:[0-6][0-9][0-9][0-9][0-9].{8}|[7-9][0-9][0-9][0-9][0-9].{12})|6(?:[1-57-9][0-9][0-9][0-9][0-9].{8}|[06][0-9][0-9][0-9][0-9].{12})|7(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|0[0-9][0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9][0-9].{8})|80(?:[0-4][0-9][0-9][0-9][0-9].{36}|5[0-9][0-9][0-9][0-9].{132}|6[0-9][0-9][0-9][0-9].{112}))|6(?:4(?:3(?:[4-6][0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{112}|8[0-9][0-9][0-9][0-9].{244}|9[0-9][0-9][0-9][0-9].{168}|0[0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{56}|3[0-9][0-9][0-9][0-9].{88})|1(?:[4-8][0-9][0-9][0-9][0-9].{44}|[09][0-9][0-9][0-9][0-9].{108}|3[0-9][0-9][0-9][0-9].{148}|1[0-9][0-9][0-9][0-9].{28}|2[0-9][0-9][0-9][0-9].{8})|2(?:[0-3][0-9][0-9][0-9][0-9].{44}|[5-7][0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{196}|4[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{36})|6(?:[5-9][0-9][0-9][0-9][0-9].{68}|[12][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{212}|3[0-9][0-9][0-9][0-9].{44}|4[0-9][0-9][0-9][0-9].{8})|7(?:[0-3][0-9][0-9][0-9][0-9].{68}|[7-9][0-9][0-9][0-9][0-9].{48}|4[0-9][0-9][0-9][0-9].{56}|5[0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{12})|0(?:[0-6][0-9][0-9][0-9][0-9].{60}|7[0-9][0-9][0-9][0-9].{116}|8[0-9][0-9][0-9][0-9].{172}|9[0-9][0-9][0-9][0-9].{232})|4(?:[5-9][0-9][0-9][0-9][0-9].{28}|[01][0-9][0-9][0-9][0-9].{192}|[2-4][0-9][0-9][0-9][0-9].{48})|8(?:[0-79][0-9][0-9][0-9][0-9].{48}|8[0-9][0-9][0-9][0-9].{84})|5[0-9][0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9][0-9].{48})|7(?:2(?:[26-8][0-9][0-9][0-9][0-9].{8}|[13][0-9][0-9][0-9][0-9].{16}|[45][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{28})|7(?:[037][0-9][0-9][0-9][0-9].{12}|[125][0-9][0-9][0-9][0-9].{20}|[89][0-9][0-9][0-9][0-9].{24}|4[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{8})|6(?:[13-5][0-9][0-9][0-9][0-9].{20}|[02][0-9][0-9][0-9][0-9].{16}|[6-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{12})|0(?:[05-9][0-9][0-9][0-9][0-9].{8}|[12][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{172}|4[0-9][0-9][0-9][0-9].{12})|3(?:[025-9][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{32}|3[0-9][0-9][0-9][0-9].{8})|9(?:[016-9][0-9][0-9][0-9][0-9].{24}|[3-5][0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{8})|1(?:[02-5][0-9][0-9][0-9][0-9].{16}|[16-9][0-9][0-9][0-9][0-9].{8})|4(?:[3-9][0-9][0-9][0-9][0-9].{8}|[0-2][0-9][0-9][0-9][0-9].{16})|8(?:[0-68][0-9][0-9][0-9][0-9].{24}|[79][0-9][0-9][0-9][0-9].{8})|5(?:[0-24-9][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{20}))|[1-35][0-9][0-9][0-9][0-9][0-9][0-9].{4})|9(?:0(?:0(?:[2-4][0-9][0-9][0-9][0-9].{40}|[17][0-9][0-9][0-9][0-9].{96}|[89][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{904}|5[0-9][0-9][0-9][0-9].{940}|6[0-9][0-9][0-9][0-9].{44})|4(?:[178][0-9][0-9][0-9][0-9].{4}|[26][0-9][0-9][0-9][0-9].{92}|0[0-9][0-9][0-9][0-9].{452}|4[0-9][0-9][0-9][0-9].{268}|9[0-9][0-9][0-9][0-9].{88})|3(?:[28][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{780}|1[0-9][0-9][0-9][0-9].{108}|9[0-9][0-9][0-9][0-9].{48})|5(?:[3-57-9][0-9][0-9][0-9][0-9].{144}|[0-2][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{92})|6(?:[018][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{100})|7(?:7[0-9][0-9][0-9][0-9].{268}|0[0-9][0-9][0-9][0-9].{52})|1[0-3][0-9][0-9][0-9][0-9].{92}|[289][0-9][0-9][0-9][0-9][0-9].{4})|6(?:0(?:[034][0-9][0-9][0-9][0-9].{40}|2[0-9][0-9][0-9][0-9].{108}|1[0-9][0-9][0-9][0-9].{96}|5[0-9][0-9][0-9][0-9].{48}|6[0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{36})|3(?:[57][0-9][0-9][0-9][0-9].{144}|[089][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{92})|4(?:[026-8][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{268}|1[0-9][0-9][0-9][0-9].{88})|9(?:[5-8][0-9][0-9][0-9][0-9].{92}|4[0-9][0-9][0-9][0-9].{52})|8(?:0[0-9][0-9][0-9][0-9].{452}|9[0-9][0-9][0-9][0-9].{92})|2[78][0-9][0-9][0-9][0-9].{144}|[5-7][0-9][0-9][0-9][0-9][0-9].{4}|10[0-9][0-9][0-9][0-9].{100})|4(?:0(?:[3-57-9][0-9][0-9][0-9][0-9].{36}|[12][0-9][0-9][0-9][0-9].{96}|0[0-9][0-9][0-9][0-9].{48}|6[0-9][0-9][0-9][0-9].{44})|4(?:[6-9][0-9][0-9][0-9][0-9].{92}|0[0-9][0-9][0-9][0-9].{620}|4[0-9][0-9][0-9][0-9].{268}|3[0-9][0-9][0-9][0-9].{52})|3(?:[0-57-9][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{948})|2(?:[0-57-9][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{88})|1(?:0[0-9][0-9][0-9][0-9].{100}|1[0-9][0-9][0-9][0-9].{36})|(?:5[6-9]|6[0-3])[0-9][0-9][0-9][0-9].{144}|9[014][0-9][0-9][0-9][0-9].{92}|80[0-9][0-9][0-9][0-9].{452}))|4(?:0(?:1(?:[1459][0-9][0-9][0-9][0-9].{16}|[0238][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{32}|7[0-9][0-9][0-9][0-9].{12})|8(?:[1-4][0-9][0-9][0-9][0-9].{16}|[0679][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{60})|2(?:[4-9][0-9][0-9][0-9][0-9].{24}|[12][0-9][0-9][0-9][0-9].{16}|[03][0-9][0-9][0-9][0-9].{8})|4(?:[2479][0-9][0-9][0-9][0-9].{16}|[356][0-9][0-9][0-9][0-9].{20}|[018][0-9][0-9][0-9][0-9].{8})|5(?:[1368][0-9][0-9][0-9][0-9].{20}|[2579][0-9][0-9][0-9][0-9].{16}|[04][0-9][0-9][0-9][0-9].{8})|6(?:[1359][0-9][0-9][0-9][0-9].{20}|[2467][0-9][0-9][0-9][0-9].{16}|[08][0-9][0-9][0-9][0-9].{8})|0(?:[035-8][0-9][0-9][0-9][0-9].{8}|[249][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{12})|3(?:[3-8][0-9][0-9][0-9][0-9].{24}|[019][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{12})|7(?:[0-24-9][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{20})|9(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{8}))|7(?:5(?:[1-37-9][0-9][0-9][0-9][0-9].{24}|[56][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{180}|4[0-9][0-9][0-9][0-9].{132})|2(?:[04-6][0-9][0-9][0-9][0-9].{12}|[1378][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{80}|9[0-9][0-9][0-9][0-9].{40})|1(?:[0-469][0-9][0-9][0-9][0-9].{8}|[78][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{80})|4(?:[1-79][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{12})|6(?:[0-357-9][0-9][0-9][0-9][0-9].{24}|4[0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{8})|7(?:[1-35-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{80}|4[0-9][0-9][0-9][0-9].{52})|3(?:[0-356][0-9][0-9][0-9][0-9].{8}|[47-9][0-9][0-9][0-9][0-9].{16})|[089][0-9][0-9][0-9][0-9][0-9].{8})|[24-69][0-9][0-9][0-9][0-9][0-9][0-9].{4})|79(?:9(?:[02-46][0-9][0-9][0-9][0-9].{44}|[89][0-9][0-9][0-9][0-9].{84}|5[0-9][0-9][0-9][0-9].{180}|1[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{52})|6(?:[0-5][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{104}|7[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{40})|8(?:[1-4][0-9][0-9][0-9][0-9].{12}|[5-8][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{36})|7(?:[1-8][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{52})|0(?:[0-7][0-9][0-9][0-9][0-9].{32}|[89][0-9][0-9][0-9][0-9].{12})|3(?:[2-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{20})|4(?:[0-6][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{4})|1(?:[02-9][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{32})|2[0-9][0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9][0-9].{4})|5(?:4(?:1(?:[89][0-9][0-9][0-9][0-9].{44}|1[0-9][0-9][0-9][0-9].{356}|3[0-9][0-9][0-9][0-9].{196}|4[0-9][0-9][0-9][0-9].{316}|6[0-9][0-9][0-9][0-9].{480}|0[0-9][0-9][0-9][0-9].{40}|2[0-9][0-9][0-9][0-9].{56}|5[0-9][0-9][0-9][0-9].{48}|7[0-9][0-9][0-9][0-9].{88})|0(?:[013-58][0-9][0-9][0-9][0-9].{56}|2[0-9][0-9][0-9][0-9].{416}|6[0-9][0-9][0-9][0-9].{436}|7[0-9][0-9][0-9][0-9].{376}|9[0-9][0-9][0-9][0-9].{112})|5(?:[12][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{272}|4[0-9][0-9][0-9][0-9].{100}|0[0-9][0-9][0-9][0-9].{40})|2(?:[2-9][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{124}|1[0-9][0-9][0-9][0-9].{288})|4(?:[0-7][0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{136}|9[0-9][0-9][0-9][0-9].{8})|3[0-9][0-9][0-9][0-9][0-9].{36})|[35-9][0-9][0-9][0-9][0-9][0-9][0-9].{4})|24(?:6(?:[235-9][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{40}|4[0-9][0-9][0-9][0-9].{12})|8(?:[1-35-9][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{100}|0[0-9][0-9][0-9][0-9].{12})|5(?:[0-7][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{8})|0(?:[4-9][0-9][0-9][0-9][0-9].{8}|[0-3][0-9][0-9][0-9][0-9].{24})|3(?:[0-7][0-9][0-9][0-9][0-9].{8}|[89][0-9][0-9][0-9][0-9].{12})|9(?:[1-8][0-9][0-9][0-9][0-9].{8}|[09][0-9][0-9][0-9][0-9].{12})|7(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|[12][0-9][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9][0-9].{12})|08(?:4(?:[04][0-9][0-9][0-9][0-9].{612}|1[0-9][0-9][0-9][0-9].{664}|2[0-9][0-9][0-9][0-9].{36})|5(?:5[0-9][0-9][0-9][0-9].{664}|0[0-9][0-9][0-9][0-9].{52})))|1(?:8(?:6(?:9(?:0[0-9][0-9][0-9][0-9].{376}|2[0-9][0-9][0-9][0-9].{140}|4[0-9][0-9][0-9][0-9].{176}|6[0-9][0-9][0-9][0-9].{156}|7[0-9][0-9][0-9][0-9].{416}|8[0-9][0-9][0-9][0-9].{576}|1[0-9][0-9][0-9][0-9].{84}|5[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{8})|7(?:[34][0-9][0-9][0-9][0-9].{572}|0[0-9][0-9][0-9][0-9].{484}|7[0-9][0-9][0-9][0-9].{308}|1[0-9][0-9][0-9][0-9].{40}|2[0-9][0-9][0-9][0-9].{88}|5[0-9][0-9][0-9][0-9].{48}|6[0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{8})|6(?:[379][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{136}|1[0-9][0-9][0-9][0-9].{196}|2[0-9][0-9][0-9][0-9].{316}|4[0-9][0-9][0-9][0-9].{580}|6[0-9][0-9][0-9][0-9].{752}|8[0-9][0-9][0-9][0-9].{468}|5[0-9][0-9][0-9][0-9].{84})|2(?:[3489][0-9][0-9][0-9][0-9].{56}|2[0-9][0-9][0-9][0-9].{360}|5[0-9][0-9][0-9][0-9].{348}|7[0-9][0-9][0-9][0-9].{340}|0[0-9][0-9][0-9][0-9].{68}|6[0-9][0-9][0-9][0-9].{84}|1[0-9][0-9][0-9][0-9].{8})|8(?:[01][0-9][0-9][0-9][0-9].{356}|[2-4][0-9][0-9][0-9][0-9].{36}|[7-9][0-9][0-9][0-9][0-9].{32}|5[0-9][0-9][0-9][0-9].{724}|6[0-9][0-9][0-9][0-9].{164})|4(?:[1-5][0-9][0-9][0-9][0-9].{88}|[89][0-9][0-9][0-9][0-9].{148}|0[0-9][0-9][0-9][0-9].{216}|7[0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{8})|5(?:[2-9][0-9][0-9][0-9][0-9].{124}|[01][0-9][0-9][0-9][0-9].{148})|3(?:[02-9][0-9][0-9][0-9][0-9].{56}|1[0-9][0-9][0-9][0-9].{444})|[01][0-9][0-9][0-9][0-9][0-9].{68})|5(?:6(?:[26][0-9][0-9][0-9][0-9].{244}|[3-5][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{436}|1[0-9][0-9][0-9][0-9].{212}|8[0-9][0-9][0-9][0-9].{392}|9[0-9][0-9][0-9][0-9].{240}|7[0-9][0-9][0-9][0-9].{8})|9(?:[0-2][0-9][0-9][0-9][0-9].{112}|[6-8][0-9][0-9][0-9][0-9].{168}|3[0-9][0-9][0-9][0-9].{956}|5[0-9][0-9][0-9][0-9].{136}|4[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{68})|0(?:[0-2][0-9][0-9][0-9][0-9].{112}|[34][0-9][0-9][0-9][0-9].{244}|[89][0-9][0-9][0-9][0-9].{28}|[67][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{460})|5(?:[0-2][0-9][0-9][0-9][0-9].{28}|[5-8][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{428}|4[0-9][0-9][0-9][0-9].{408}|9[0-9][0-9][0-9][0-9].{244})|8(?:[3467][0-9][0-9][0-9][0-9].{56}|[01][0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{692}|2[0-9][0-9][0-9][0-9].{36}|5[0-9][0-9][0-9][0-9].{88})|7(?:[3468][0-9][0-9][0-9][0-9].{128}|[0-2][0-9][0-9][0-9][0-9].{244}|[79][0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{284})|3(?:[5-8][0-9][0-9][0-9][0-9].{56}|[01][0-9][0-9][0-9][0-9].{488}|[2-4][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{28})|1(?:[46-9][0-9][0-9][0-9][0-9].{36}|[0-2][0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{196}|3[0-9][0-9][0-9][0-9].{68})|2[0-9][0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9][0-9].{28})|4(?:8(?:0[0-9][0-9][0-9][0-9].{100}|3[0-9][0-9][0-9][0-9].{244}|4[0-9][0-9][0-9][0-9].{488}|5[0-9][0-9][0-9][0-9].{564}|6[0-9][0-9][0-9][0-9].{372}|7[0-9][0-9][0-9][0-9].{112}|1[0-9][0-9][0-9][0-9].{56}|8[0-9][0-9][0-9][0-9].{84}|9[0-9][0-9][0-9][0-9].{48}|2[0-9][0-9][0-9][0-9].{8})|1(?:[6-9][0-9][0-9][0-9][0-9].{28}|[12][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{100}|3[0-9][0-9][0-9][0-9].{148}|4[0-9][0-9][0-9][0-9].{196}|5[0-9][0-9][0-9][0-9].{44})|0(?:[0-4][0-9][0-9][0-9][0-9].{108}|[78][0-9][0-9][0-9][0-9].{148}|[56][0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{8})|2(?:[013-5][0-9][0-9][0-9][0-9].{28}|[6-8][0-9][0-9][0-9][0-9].{108}|9[0-9][0-9][0-9][0-9].{516}|2[0-9][0-9][0-9][0-9].{12})|7(?:[4-9][0-9][0-9][0-9][0-9].{56}|[01][0-9][0-9][0-9][0-9].{44}|2[0-9][0-9][0-9][0-9].{332}|3[0-9][0-9][0-9][0-9].{28})|6(?:[2-9][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{100}|1[0-9][0-9][0-9][0-9].{20})|3(?:[1-79][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{32}|8[0-9][0-9][0-9][0-9].{68})|9(?:[0-7][0-9][0-9][0-9][0-9].{48}|[89][0-9][0-9][0-9][0-9].{112})|5(?:[0-4][0-9][0-9][0-9][0-9].{80}|[5-9][0-9][0-9][0-9][0-9].{44})|4[0-9][0-9][0-9][0-9][0-9].{80})|3(?:7(?:[68][0-9][0-9][0-9][0-9].{44}|[24][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{388}|1[0-9][0-9][0-9][0-9].{304}|5[0-9][0-9][0-9][0-9].{112}|7[0-9][0-9][0-9][0-9].{400}|9[0-9][0-9][0-9][0-9].{108}|3[0-9][0-9][0-9][0-9].{52})|6(?:[5-8][0-9][0-9][0-9][0-9].{68}|[24][0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{108}|0[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{8})|3(?:[0-4][0-9][0-9][0-9][0-9].{60}|[79][0-9][0-9][0-9][0-9].{40}|5[0-9][0-9][0-9][0-9].{248}|8[0-9][0-9][0-9][0-9].{52}|6[0-9][0-9][0-9][0-9].{8})|8(?:[13-68][0-9][0-9][0-9][0-9].{52}|[79][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{156}|2[0-9][0-9][0-9][0-9].{48})|9(?:[124-8][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{628}|9[0-9][0-9][0-9][0-9].{180}|3[0-9][0-9][0-9][0-9].{52})|0(?:[0-5][0-9][0-9][0-9][0-9].{4}|[7-9][0-9][0-9][0-9][0-9].{60}|6[0-9][0-9][0-9][0-9].{8})|4(?:[0-24-9][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{52})|5(?:[0-24-9][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{52})|[12][0-9][0-9][0-9][0-9][0-9].{60})|0(?:4(?:[0-5][0-9][0-9][0-9][0-9].{300}|[89][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{116}|6[0-9][0-9][0-9][0-9].{8})|9(?:[4-8][0-9][0-9][0-9][0-9].{12}|[0-2][0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{116}|3[0-9][0-9][0-9][0-9].{16})|7(?:[4-79][0-9][0-9][0-9][0-9].{12}|[0-2][0-9][0-9][0-9][0-9].{116}|8[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{8})|2(?:[1-7][0-9][0-9][0-9][0-9].{116}|0[0-9][0-9][0-9][0-9].{124}|9[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{8})|1(?:[5-9][0-9][0-9][0-9][0-9].{12}|[0-3][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{292})|6(?:[3-9][0-9][0-9][0-9][0-9].{116}|[02][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{12})|3(?:[1-4][0-9][0-9][0-9][0-9].{12}|[5-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{52})|5(?:[2-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{8})|8(?:[1-9][0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9].{104})|0[0-9][0-9][0-9][0-9][0-9].{8})|7(?:2(?:[5-7][0-9][0-9][0-9][0-9].{8}|[89][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{124}|1[0-9][0-9][0-9][0-9].{288}|2[0-9][0-9][0-9][0-9].{228}|4[0-9][0-9][0-9][0-9].{252}|3[0-9][0-9][0-9][0-9].{40})|4(?:[7-9][0-9][0-9][0-9][0-9].{132}|[12][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{180}|4[0-9][0-9][0-9][0-9].{804}|6[0-9][0-9][0-9][0-9].{608}|0[0-9][0-9][0-9][0-9].{24}|5[0-9][0-9][0-9][0-9].{40})|5(?:[4-7][0-9][0-9][0-9][0-9].{252}|[01][0-9][0-9][0-9][0-9].{132}|2[0-9][0-9][0-9][0-9].{232}|3[0-9][0-9][0-9][0-9].{228}|8[0-9][0-9][0-9][0-9].{672}|9[0-9][0-9][0-9][0-9].{112})|3(?:[0-5][0-9][0-9][0-9][0-9].{36}|[67][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{24})|6(?:[0-39][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{820}|5[0-9][0-9][0-9][0-9].{272}|6[0-9][0-9][0-9][0-9].{100})|8(?:7[0-9][0-9][0-9][0-9].{380}|8[0-9][0-9][0-9][0-9].{112})|[01][0-9][0-9][0-9][0-9][0-9].{124})|2(?:8(?:[014-79][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{180}|3[0-9][0-9][0-9][0-9].{52}|8[0-9][0-9][0-9][0-9].{84})|0(?:[0-26-8][0-9][0-9][0-9][0-9].{8}|[3-5][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{40})|1(?:[0-5][0-9][0-9][0-9][0-9].{40}|[6-8][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{8})|2(?:[1-79][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{52})|6(?:[0-36-9][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{40}|4[0-9][0-9][0-9][0-9].{8})|4(?:[2-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{20})|7(?:[3-9][0-9][0-9][0-9][0-9].{4}|[0-2][0-9][0-9][0-9][0-9].{12})|3[0-9][0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9][0-9].{4})|1(?:2(?:[3-8][0-9][0-9][0-9][0-9].{116}|0[0-9][0-9][0-9][0-9].{104}|1[0-9][0-9][0-9][0-9].{244}|2[0-9][0-9][0-9][0-9].{228}|9[0-9][0-9][0-9][0-9].{40})|7(?:[02-6][0-9][0-9][0-9][0-9].{20}|[78][0-9][0-9][0-9][0-9].{104}|1[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{8})|8(?:[2-79][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{212}|1[0-9][0-9][0-9][0-9].{104}|8[0-9][0-9][0-9][0-9].{12})|9(?:[06-9][0-9][0-9][0-9][0-9].{12}|[1245][0-9][0-9][0-9][0-9].{104}|3[0-9][0-9][0-9][0-9].{20})|6(?:[02-8][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{648}|9[0-9][0-9][0-9][0-9].{20})|3(?:[0-4][0-9][0-9][0-9][0-9].{116}|[5-9][0-9][0-9][0-9][0-9].{12})|[01][0-9][0-9][0-9][0-9][0-9].{104}|[45][0-9][0-9][0-9][0-9][0-9].{12}))|7(?:4(?:9(?:[147-9][0-9][0-9][0-9][0-9].{16}|[23][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{184}|5[0-9][0-9][0-9][0-9].{364}|6[0-9][0-9][0-9][0-9].{12})|3(?:[235689][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{24}|7[0-9][0-9][0-9][0-9].{60}|4[0-9][0-9][0-9][0-9].{8})|7(?:[0-3][0-9][0-9][0-9][0-9].{12}|[6-9][0-9][0-9][0-9][0-9].{16}|[45][0-9][0-9][0-9][0-9].{20})|6(?:[1-35-7][0-9][0-9][0-9][0-9].{40}|[89][0-9][0-9][0-9][0-9].{16}|[04][0-9][0-9][0-9][0-9].{8})|8(?:[5-8][0-9][0-9][0-9][0-9].{12}|[349][0-9][0-9][0-9][0-9].{16}|[0-2][0-9][0-9][0-9][0-9].{8})|1(?:[0-37][0-9][0-9][0-9][0-9].{40}|[4-69][0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{24})|2(?:[1346-8][0-9][0-9][0-9][0-9].{16}|[259][0-9][0-9][0-9][0-9].{60}|0[0-9][0-9][0-9][0-9].{32})|0(?:[1-8][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{80}|9[0-9][0-9][0-9][0-9].{40})|5(?:[0-35][0-9][0-9][0-9][0-9].{40}|[46-9][0-9][0-9][0-9][0-9].{8})|4[0-9][0-9][0-9][0-9][0-9].{20})|6(?:2(?:[02][0-9][0-9][0-9][0-9].{68}|[78][0-9][0-9][0-9][0-9].{44}|1[0-9][0-9][0-9][0-9].{128}|3[0-9][0-9][0-9][0-9].{148}|4[0-9][0-9][0-9][0-9].{172}|5[0-9][0-9][0-9][0-9].{404}|6[0-9][0-9][0-9][0-9].{204}|9[0-9][0-9][0-9][0-9].{8})|5(?:[5-79][0-9][0-9][0-9][0-9].{16}|[38][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{100}|1[0-9][0-9][0-9][0-9].{200}|2[0-9][0-9][0-9][0-9].{20}|4[0-9][0-9][0-9][0-9].{88})|4(?:[0-46][0-9][0-9][0-9][0-9].{84}|5[0-9][0-9][0-9][0-9].{196}|7[0-9][0-9][0-9][0-9].{172}|8[0-9][0-9][0-9][0-9].{136}|9[0-9][0-9][0-9][0-9].{232})|3(?:[14-689][0-9][0-9][0-9][0-9].{84}|[237][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{68})|7(?:[0-7][0-9][0-9][0-9][0-9].{32}|8[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{16})|9(?:[02-46-9][0-9][0-9][0-9][0-9].{16}|[15][0-9][0-9][0-9][0-9].{12})|0(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{12})|1[0-9][0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9][0-9].{8})|7(?:4(?:[2-47][0-9][0-9][0-9][0-9].{156}|[589][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{520}|1[0-9][0-9][0-9][0-9].{32}|6[0-9][0-9][0-9][0-9].{40})|3(?:[5-9][0-9][0-9][0-9][0-9].{156}|[24][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{32}|3[0-9][0-9][0-9][0-9].{80})|8(?:[0-359][0-9][0-9][0-9][0-9].{8}|[78][0-9][0-9][0-9][0-9].{80}|4[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{48})|6(?:[1-35689][0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{80}|0[0-9][0-9][0-9][0-9].{8})|9(?:[1-5][0-9][0-9][0-9][0-9].{12}|[08][0-9][0-9][0-9][0-9].{80}|[679][0-9][0-9][0-9][0-9].{8})|7(?:[0-24578][0-9][0-9][0-9][0-9].{12}|[69][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{16})|5(?:[1-8][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{156}|9[0-9][0-9][0-9][0-9].{8})|0(?:[0-6][0-9][0-9][0-9][0-9].{8}|[7-9][0-9][0-9][0-9][0-9].{80})|[12][0-9][0-9][0-9][0-9][0-9].{40})|0(?:1(?:[35689][0-9][0-9][0-9][0-9].{8}|[14][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{40}|2[0-9][0-9][0-9][0-9].{32}|7[0-9][0-9][0-9][0-9].{12})|0(?:[0-2457][0-9][0-9][0-9][0-9].{40}|[89][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{60}|6[0-9][0-9][0-9][0-9].{32})|4(?:[13579][0-9][0-9][0-9][0-9].{16}|[246][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{36})|3(?:[6-9][0-9][0-9][0-9][0-9].{24}|[014][0-9][0-9][0-9][0-9].{16}|[235][0-9][0-9][0-9][0-9].{8})|6(?:[02489][0-9][0-9][0-9][0-9].{8}|[35-7][0-9][0-9][0-9][0-9].{32}|1[0-9][0-9][0-9][0-9].{104})|5(?:[135689][0-9][0-9][0-9][0-9].{8}|[247][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{40})|8(?:[1-9][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{32})|7[0-9][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9][0-9].{8})|8(?:9(?:[27-9][0-9][0-9][0-9][0-9].{8}|[56][0-9][0-9][0-9][0-9].{260}|[34][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{228}|1[0-9][0-9][0-9][0-9].{132})|8(?:[02-6][0-9][0-9][0-9][0-9].{8}|[79][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{132}|8[0-9][0-9][0-9][0-9].{40})|4(?:[3-6][0-9][0-9][0-9][0-9].{12}|[0-2][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{8})|0(?:[0-5][0-9][0-9][0-9][0-9].{8}|[6-8][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{12})|6(?:[3-689][0-9][0-9][0-9][0-9].{8}|[0-2][0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{12})|5(?:[0-4][0-9][0-9][0-9][0-9].{40}|[5-9][0-9][0-9][0-9][0-9].{16})|3(?:[5-9][0-9][0-9][0-9][0-9].{12}|[0-4][0-9][0-9][0-9][0-9].{8})|7(?:[0-689][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{132})|1[0-9][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9][0-9].{8})|9(?:3(?:[12479][0-9][0-9][0-9][0-9].{12}|[56][0-9][0-9][0-9][0-9].{108}|[03][0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{8})|9(?:[1-68][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{104}|9[0-9][0-9][0-9][0-9].{504}|0[0-9][0-9][0-9][0-9].{12})|7(?:[06-9][0-9][0-9][0-9][0-9].{12}|[235][0-9][0-9][0-9][0-9].{100}|[14][0-9][0-9][0-9][0-9].{8})|8(?:[1-467][0-9][0-9][0-9][0-9].{8}|[089][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{236})|4(?:[03-59][0-9][0-9][0-9][0-9].{12}|[1278][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{40})|5(?:[0459][0-9][0-9][0-9][0-9].{12}|[1-378][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{40})|6(?:[05-79][0-9][0-9][0-9][0-9].{12}|[1-48][0-9][0-9][0-9][0-9].{8})|0(?:[1-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{8})|[12][0-9][0-9][0-9][0-9][0-9].{12})|2(?:9(?:[2-48][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{16}|[67][0-9][0-9][0-9][0-9].{80}|[59][0-9][0-9][0-9][0-9].{8})|6(?:[0-367][0-9][0-9][0-9][0-9].{8}|[45][0-9][0-9][0-9][0-9].{16}|[89][0-9][0-9][0-9][0-9].{12})|2(?:[0-3568][0-9][0-9][0-9][0-9].{32}|[79][0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{8})|7(?:[013-7][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{32})|8(?:[3-8][0-9][0-9][0-9][0-9].{8}|[129][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{32})|3(?:[0-468][0-9][0-9][0-9][0-9].{8}|[579][0-9][0-9][0-9][0-9].{16})|4(?:[024689][0-9][0-9][0-9][0-9].{8}|[1357][0-9][0-9][0-9][0-9].{16})|5(?:[0-689][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{16})|[01][0-9][0-9][0-9][0-9][0-9].{32})|5(?:8(?:[1346-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{44})|7(?:[0-267][0-9][0-9][0-9][0-9].{12}|[3489][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{320})|5(?:[013468][0-9][0-9][0-9][0-9].{40}|[579][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{12})|4(?:[0-25-9][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{52}|4[0-9][0-9][0-9][0-9].{12})|1(?:[3-9][0-9][0-9][0-9][0-9].{8}|[0-2][0-9][0-9][0-9][0-9].{12})|6(?:[0-57-9][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{8})|9(?:[0-46-9][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{44})|[23][0-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9][0-9].{12})|3(?:6(?:[3-5][0-9][0-9][0-9][0-9].{40}|[7-9][0-9][0-9][0-9][0-9].{20}|[12][0-9][0-9][0-9][0-9].{32}|6[0-9][0-9][0-9][0-9].{80}|0[0-9][0-9][0-9][0-9].{8})|5(?:[1-35-9][0-9][0-9][0-9][0-9].{40}|0[0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9].{80})|3(?:[0-27-9][0-9][0-9][0-9][0-9].{24}|[3-6][0-9][0-9][0-9][0-9].{20})|4(?:[0-6][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{40})|9(?:[013-9][0-9][0-9][0-9][0-9].{20}|2[0-9][0-9][0-9][0-9].{16})|[0-2][0-9][0-9][0-9][0-9][0-9].{24}|8[0-9][0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9][0-9].{8})|1[0-9][0-9][0-9][0-9][0-9][0-9].{8})|4(?:8(?:6(?:[0135-9][0-9][0-9][0-9][0-9].{4}|[24][0-9][0-9][0-9][0-9].{60})|1(?:[0-57-9][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{60})|[02-57-9][0-9][0-9][0-9][0-9][0-9].{4})|9(?:7(?:[0-46-9][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{60})|[0-689][0-9][0-9][0-9][0-9][0-9].{4})|[0-7][0-9][0-9][0-9][0-9][0-9][0-9].{4})|(?:(?:(?:5[035-8]|3[049])|6[0149])[0-9][0-9]|(?:(?:9[01]|05)[0-9]|24[12])[0-9])[0-9][0-9][0-9][0-9].{4})|9(?:7(?:0(?:1(?:0[0-9][0-9][0-9][0-9].{304}|1[0-9][0-9][0-9][0-9].{120}|2[0-9][0-9][0-9][0-9].{564}|3[0-9][0-9][0-9][0-9].{488}|4[0-9][0-9][0-9][0-9].{428}|5[0-9][0-9][0-9][0-9].{148}|6[0-9][0-9][0-9][0-9].{360}|7[0-9][0-9][0-9][0-9].{172}|8[0-9][0-9][0-9][0-9].{196}|9[0-9][0-9][0-9][0-9].{56})|2(?:[78][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{236}|1[0-9][0-9][0-9][0-9].{372}|2[0-9][0-9][0-9][0-9].{856}|3[0-9][0-9][0-9][0-9].{356}|4[0-9][0-9][0-9][0-9].{128}|5[0-9][0-9][0-9][0-9].{232}|6[0-9][0-9][0-9][0-9].{108}|9[0-9][0-9][0-9][0-9].{32})|7(?:[25][0-9][0-9][0-9][0-9].{112}|0[0-9][0-9][0-9][0-9].{100}|4[0-9][0-9][0-9][0-9].{456}|6[0-9][0-9][0-9][0-9].{908}|7[0-9][0-9][0-9][0-9].{104}|8[0-9][0-9][0-9][0-9].{332}|9[0-9][0-9][0-9][0-9].{924}|1[0-9][0-9][0-9][0-9].{56}|3[0-9][0-9][0-9][0-9].{84})|5(?:0[0-9][0-9][0-9][0-9].{148}|1[0-9][0-9][0-9][0-9].{868}|2[0-9][0-9][0-9][0-9].{772}|3[0-9][0-9][0-9][0-9].{796}|4[0-9][0-9][0-9][0-9].{324}|5[0-9][0-9][0-9][0-9].{540}|6[0-9][0-9][0-9][0-9].{728}|7[0-9][0-9][0-9][0-9].{184}|9[0-9][0-9][0-9][0-9].{412})|3(?:0[0-9][0-9][0-9][0-9].{212}|3[0-9][0-9][0-9][0-9].{480}|4[0-9][0-9][0-9][0-9].{204}|5[0-9][0-9][0-9][0-9].{528}|6[0-9][0-9][0-9][0-9].{344}|8[0-9][0-9][0-9][0-9].{196}|9[0-9][0-9][0-9][0-9].{740}|2[0-9][0-9][0-9][0-9].{32})|6(?:[0-3][0-9][0-9][0-9][0-9].{32}|4[0-9][0-9][0-9][0-9].{516}|5[0-9][0-9][0-9][0-9].{180}|7[0-9][0-9][0-9][0-9].{632}|8[0-9][0-9][0-9][0-9].{244}|9[0-9][0-9][0-9][0-9].{704}|6[0-9][0-9][0-9][0-9].{68})|0(?:[2-5][0-9][0-9][0-9][0-9].{284}|7[0-9][0-9][0-9][0-9].{788}|9[0-9][0-9][0-9][0-9].{344}|0[0-9][0-9][0-9][0-9].{60}|1[0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{32}|8[0-9][0-9][0-9][0-9].{4})|9[0-9][0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9][0-9].{8})|4(?:7(?:[467][0-9][0-9][0-9][0-9].{52}|[89][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{456}|2[0-9][0-9][0-9][0-9].{652}|3[0-9][0-9][0-9][0-9].{320}|1[0-9][0-9][0-9][0-9].{80}|5[0-9][0-9][0-9][0-9].{48})|5(?:[0-245][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{528}|7[0-9][0-9][0-9][0-9].{304}|8[0-9][0-9][0-9][0-9].{124}|9[0-9][0-9][0-9][0-9].{288}|3[0-9][0-9][0-9][0-9].{28})|6(?:[2356][0-9][0-9][0-9][0-9].{12}|[018][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{320}|7[0-9][0-9][0-9][0-9].{520}|9[0-9][0-9][0-9][0-9].{4})|4(?:[0-6][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{212}|9[0-9][0-9][0-9][0-9].{316}|8[0-9][0-9][0-9][0-9].{84})|1(?:2[0-9][0-9][0-9][0-9].{416}|3[0-9][0-9][0-9][0-9].{676}|4[0-9][0-9][0-9][0-9].{456})|8(?:[0-689][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{436})|9(?:0[0-9][0-9][0-9][0-9].{348}|1[0-9][0-9][0-9][0-9].{172})|00[0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9][0-9].{8})|1(?:0(?:[45][0-9][0-9][0-9][0-9].{128}|[78][0-9][0-9][0-9][0-9].{288}|0[0-9][0-9][0-9][0-9].{180}|2[0-9][0-9][0-9][0-9].{944}|3[0-9][0-9][0-9][0-9].{408}|6[0-9][0-9][0-9][0-9].{952}|1[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{68})|1(?:[12][0-9][0-9][0-9][0-9].{552}|[3-5][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{120}|6[0-9][0-9][0-9][0-9].{112}|7[0-9][0-9][0-9][0-9].{936}|8[0-9][0-9][0-9][0-9].{580}|9[0-9][0-9][0-9][0-9].{700})|7(?:[5-9][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{212}|4[0-9][0-9][0-9][0-9].{544}|0[0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{52}|3[0-9][0-9][0-9][0-9].{12})|5(?:[0-35-9][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{876})|[2-46][0-9][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9][0-9].{8})|6(?:7(?:2[0-9][0-9][0-9][0-9].{132}|6[0-9][0-9][0-9][0-9].{320}|1[0-9][0-9][0-9][0-9].{40}|7[0-9][0-9][0-9][0-9].{48}|3[0-9][0-9][0-9][0-9].{4})|1(?:[023][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{320}|7[0-9][0-9][0-9][0-9].{48})|4(?:0[0-9][0-9][0-9][0-9].{620}|1[0-9][0-9][0-9][0-9].{896}|7[0-9][0-9][0-9][0-9].{48})|0(?:[2-9][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{132})|3(?:[1-3][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{48})|2(?:2[0-9][0-9][0-9][0-9].{320}|7[0-9][0-9][0-9][0-9].{48})|(?:6[1-9]|5[0-2]|9[0-9])[0-9][0-9][0-9][0-9].{4})|8(?:0(?:[0-25][0-9][0-9][0-9][0-9].{4}|[34][0-9][0-9][0-9][0-9].{132}|6[0-9][0-9][0-9][0-9].{228}|7[0-9][0-9][0-9][0-9].{396}|8[0-9][0-9][0-9][0-9].{376}|9[0-9][0-9][0-9][0-9].{608})|3(?:5[0-9][0-9][0-9][0-9].{248}|6[0-9][0-9][0-9][0-9].{228}|7[0-9][0-9][0-9][0-9].{672})|2(?:[0-2][0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{492})|9(?:8[0-9][0-9][0-9][0-9].{216}|7[0-9][0-9][0-9][0-9].{48})|[156][0-9][0-9][0-9][0-9][0-9].{16}|4[0-2][0-9][0-9][0-9][0-9].{532}|7[0-9][0-9][0-9][0-9][0-9].{8})|7(?:4(?:[4-9][0-9][0-9][0-9][0-9].{4}|[0-3][0-9][0-9][0-9][0-9].{24})|7(?:[0-689][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{156})|8(?:[0-79][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{392})|5(?:[0-46-9][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{84})|0(?:[02-9][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{8})|(?:2[0-2]|1[0-9])[0-9][0-9][0-9][0-9].{12}|[369][0-9][0-9][0-9][0-9][0-9].{4})|3(?:7(?:0[0-9][0-9][0-9][0-9].{816}|1[0-9][0-9][0-9][0-9].{484}|3[0-9][0-9][0-9][0-9].{456}|4[0-9][0-9][0-9][0-9].{760}|2[0-9][0-9][0-9][0-9].{84})|3(?:[04][0-9][0-9][0-9][0-9].{320}|[12][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{808})|8(?:[24-7][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{832})|[1256][0-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9][0-9].{44})|2(?:7(?:0[0-9][0-9][0-9][0-9].{308}|1[0-9][0-9][0-9][0-9].{824}|2[0-9][0-9][0-9][0-9].{48}|3[0-9][0-9][0-9][0-9].{52})|6(?:[0-6][0-9][0-9][0-9][0-9].{28}|[7-9][0-9][0-9][0-9][0-9].{12})|0(?:0[0-9][0-9][0-9][0-9].{120}|9[0-9][0-9][0-9][0-9].{80})|[1-5][0-9][0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9][0-9].{4})|5(?:1(?:[16][0-9][0-9][0-9][0-9].{640}|0[0-9][0-9][0-9][0-9].{764}|2[0-9][0-9][0-9][0-9].{228}|4[0-9][0-9][0-9][0-9].{184}|5[0-9][0-9][0-9][0-9].{200}|7[0-9][0-9][0-9][0-9].{104}|3[0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{84}|9[0-9][0-9][0-9][0-9].{80})|[2-9][0-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9][0-9].{12})|9(?:9(?:[5-79][0-9][0-9][0-9][0-9].{12}|[0-2][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{168}|8[0-9][0-9][0-9][0-9].{340}|4[0-9][0-9][0-9][0-9].{28})|[0-8][0-9][0-9][0-9][0-9][0-9].{4}))|8(?:0(?:0(?:0[0-9][0-9][0-9][0-9].{504}|1[0-9][0-9][0-9][0-9].{404}|9[0-9][0-9][0-9][0-9].{228}|8[0-9][0-9][0-9][0-9].{52})|3(?:[1-46-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{628}|5[0-9][0-9][0-9][0-9].{696})|5(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{192})|6(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{200})|7(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{116})|8(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{100})|4(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{52})|9(?:[0-79][0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{48})|1[03][0-9][0-9][0-9][0-9].{504})|8(?:1(?:[89][0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9].{932}|1[0-9][0-9][0-9][0-9].{120})|2(?:[0-2][0-9][0-9][0-9][0-9].{48}|5[0-9][0-9][0-9][0-9].{864}|8[0-9][0-9][0-9][0-9].{52})|9(?:[08][0-9][0-9][0-9][0-9].{48}|9[0-9][0-9][0-9][0-9].{52})|6(?:[78][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{52})|[03-5][0-9][0-9][0-9][0-9][0-9].{20}|77[0-9][0-9][0-9][0-9].{52}|8[0-9][0-9][0-9][0-9][0-9].{8})|7(?:6(?:6[0-9][0-9][0-9][0-9].{252}|5[0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9].{88})|8(?:[67][0-9][0-9][0-9][0-9].{136}|8[0-9][0-9][0-9][0-9].{52})|9(?:9[0-9][0-9][0-9][0-9].{588}|8[0-9][0-9][0-9][0-9].{48})|[013-57][0-9][0-9][0-9][0-9][0-9].{20}|27[0-9][0-9][0-9][0-9].{792})|2(?:1(?:[01][0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{52})|9(?:8[0-9][0-9][0-9][0-9].{200}|9[0-9][0-9][0-9][0-9].{56})|[2-7][0-9][0-9][0-9][0-9][0-9].{20}|05[0-9][0-9][0-9][0-9].{132}|82[0-9][0-9][0-9][0-9].{164})|5(?:3(?:[1-46-9][0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{164})|9(?:[0-79][0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{48})|[4-8][1-9][0-9][0-9][0-9][0-9].{16})|6(?:8(?:6[0-9][0-9][0-9][0-9].{400}|7[0-9][0-9][0-9][0-9].{52})|[0-7][0-9][0-9][0-9][0-9][0-9].{20}|98[0-9][0-9][0-9][0-9].{48})|3(?:[02-9][0-9][0-9][0-9][0-9][0-9].{20}|10[0-9][0-9][0-9][0-9].{528})|4(?:[0-5][0-9][0-9][0-9][0-9][0-9].{16}|98[0-9][0-9][0-9][0-9].{48})|9[0-5][0-9][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9][0-9][0-9].{20})|5[0-9][0-9][0-9][0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9][0-9][0-9][0-9].{4})|6(?:9(?:0(?:8(?:[0-6][0-9][0-9][0-9][0-9].{96}|7[0-9][0-9][0-9][0-9].{556}|8[0-9][0-9][0-9][0-9].{268}|9[0-9][0-9][0-9][0-9].{92})|0(?:[1-4][0-9][0-9][0-9][0-9].{496}|[6-9][0-9][0-9][0-9][0-9].{96}|[05][0-9][0-9][0-9][0-9].{92})|2(?:[013-5][0-9][0-9][0-9][0-9].{96}|[6-9][0-9][0-9][0-9][0-9].{72}|2[0-9][0-9][0-9][0-9].{268})|7(?:[0-6][0-9][0-9][0-9][0-9].{72}|[89][0-9][0-9][0-9][0-9].{92}|7[0-9][0-9][0-9][0-9].{268})|6(?:[0-578][0-9][0-9][0-9][0-9].{72}|6[0-9][0-9][0-9][0-9].{268}|9[0-9][0-9][0-9][0-9].{96})|4(?:[017-9][0-9][0-9][0-9][0-9].{72}|[2-6][0-9][0-9][0-9][0-9].{96})|1(?:[1-9][0-9][0-9][0-9][0-9].{96}|0[0-9][0-9][0-9][0-9].{556})|3(?:[0-57-9][0-9][0-9][0-9][0-9].{72}|6[0-9][0-9][0-9][0-9].{96})|5[0-9][0-9][0-9][0-9][0-9].{72}|9[0-9][0-9][0-9][0-9][0-9].{92})|3(?:6(?:[12][0-9][0-9][0-9][0-9].{680}|0[0-9][0-9][0-9][0-9].{160}|6[0-9][0-9][0-9][0-9].{4})|9(?:[0-39][0-9][0-9][0-9][0-9].{4}|[47][0-9][0-9][0-9][0-9].{76})|0(?:[1-4][0-9][0-9][0-9][0-9].{76}|[06][0-9][0-9][0-9][0-9].{4})|8(?:[0-3][0-9][0-9][0-9][0-9].{160}|8[0-9][0-9][0-9][0-9].{4})|3(?:[39][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{160})|1(?:[03][0-9][0-9][0-9][0-9].{76}|1[0-9][0-9][0-9][0-9].{4})|2(?:[12][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{76})|5(?:0[0-9][0-9][0-9][0-9].{160}|5[0-9][0-9][0-9][0-9].{4})|7(?:0[0-9][0-9][0-9][0-9].{160}|7[0-9][0-9][0-9][0-9].{4})|4[0-7][0-9][0-9][0-9][0-9].{160})|6(?:1(?:[016-9][0-9][0-9][0-9][0-9].{96}|[2-5][0-9][0-9][0-9][0-9].{500})|8(?:[0-6][0-9][0-9][0-9][0-9].{72}|[7-9][0-9][0-9][0-9][0-9].{92})|9(?:[0-8][0-9][0-9][0-9][0-9].{96}|9[0-9][0-9][0-9][0-9].{72})|5(?:[0-4][0-9][0-9][0-9][0-9].{96}|[56][0-9][0-9][0-9][0-9].{72})|(?:6[0-4]|0[0-9])[0-9][0-9][0-9][0-9].{92}|[2-4][0-9][0-9][0-9][0-9][0-9].{72}|7[0-9][0-9][0-9][0-9][0-9].{96})|4(?:1(?:[2-6][0-9][0-9][0-9][0-9].{96}|[01][0-9][0-9][0-9][0-9].{624}|[7-9][0-9][0-9][0-9][0-9].{92})|0(?:[0-7][0-9][0-9][0-9][0-9].{92}|[89][0-9][0-9][0-9][0-9].{96})|4(?:[0-589][0-9][0-9][0-9][0-9].{72}|[67][0-9][0-9][0-9][0-9].{92})|(?:3[0-48]|2[0-9])[0-9][0-9][0-9][0-9].{72}|9[0-9][0-9][0-9][0-9][0-9].{96})|2(?:9(?:[015-9][0-9][0-9][0-9][0-9].{76}|[2-4][0-9][0-9][0-9][0-9].{160})|4(?:[5-9][0-9][0-9][0-9][0-9].{76}|[0-4][0-9][0-9][0-9][0-9].{4})|0(?:[0-57-9][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{76})|[15-8][0-9][0-9][0-9][0-9][0-9].{76}|[23][0-9][0-9][0-9][0-9][0-9].{4})|1(?:3(?:[1-5][0-9][0-9][0-9][0-9].{72}|0[0-9][0-9][0-9][0-9].{96})|2(?:2[0-9][0-9][0-9][0-9].{268}|9[0-9][0-9][0-9][0-9].{96})|87[0-9][0-9][0-9][0-9].{556})|[89][0-9][0-9][0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9][0-9][0-9].{276}|727[0-9][0-9][0-9][0-9].{96})|3(?:9(?:0(?:[3-7][0-9][0-9][0-9][0-9].{160}|[0-2][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{76})|9(?:[4-7][0-9][0-9][0-9][0-9].{160}|0[0-9][0-9][0-9][0-9].{100}|9[0-9][0-9][0-9][0-9].{4})|2(?:[0-57-9][0-9][0-9][0-9][0-9].{76}|6[0-9][0-9][0-9][0-9].{160})|6(?:[5-9][0-9][0-9][0-9][0-9].{76}|[0-4][0-9][0-9][0-9][0-9].{4})|1(?:[01][0-9][0-9][0-9][0-9].{76}|9[0-9][0-9][0-9][0-9].{160})|3(?:0[0-9][0-9][0-9][0-9].{100}|9[0-9][0-9][0-9][0-9].{160})|7(?:0[0-9][0-9][0-9][0-9].{100}|6[0-9][0-9][0-9][0-9].{4})|50[0-9][0-9][0-9][0-9].{100}|40[0-9][0-9][0-9][0-9].{76})|8(?:0(?:[1-5][0-9][0-9][0-9][0-9].{220}|[7-9][0-9][0-9][0-9][0-9].{112}|0[0-9][0-9][0-9][0-9].{420}|6[0-9][0-9][0-9][0-9].{892})|[1-9][0-9][0-9][0-9][0-9][0-9].{4})|6(?:[5-9][0-9]|[0-4][0-9])[0-9][0-9][0-9][0-9].{64}|[0-37][0-9][0-9][0-9][0-9][0-9][0-9].{4}|[45][0-9][0-9][0-9][0-9][0-9][0-9].{8})|4(?:9(?:9(?:[467][0-9][0-9][0-9][0-9].{224}|[01][0-9][0-9][0-9][0-9].{156}|[58][0-9][0-9][0-9][0-9].{220}|[23][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{168})|5(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12})|[0-46-8][0-9][0-9][0-9][0-9][0-9].{4})|1(?:6(?:[6-9][0-9][0-9][0-9][0-9].{152}|[01][0-9][0-9][0-9][0-9].{64}|2[0-9][0-9][0-9][0-9].{312}|3[0-9][0-9][0-9][0-9].{900}|5[0-9][0-9][0-9][0-9].{224}|4[0-9][0-9][0-9][0-9].{44})|[0-589][0-9][0-9][0-9][0-9][0-9].{256}|7[0-9][0-9][0-9][0-9][0-9].{64})|0(?:0(?:[0-4][0-9][0-9][0-9][0-9].{420}|[5-9][0-9][0-9][0-9][0-9].{208})|[1-9][0-9][0-9][0-9][0-9][0-9].{4})|4(?:[07-9][0-9][0-9][0-9][0-9][0-9].{256}|[4-6][0-9][0-9][0-9][0-9][0-9].{364}|[1-3][0-9][0-9][0-9][0-9][0-9].{4})|[23578][0-9][0-9][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9][0-9][0-9].{8})|0(?:2(?:[23][0-9][0-9][0-9][0-9][0-9].{280}|[45][0-9][0-9][0-9][0-9][0-9].{152}|[6-9][0-9][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9][0-9].{4})|4(?:[014][0-9][0-9][0-9][0-9][0-9].{280}|[5-9][0-9][0-9][0-9][0-9][0-9].{8}|[23][0-9][0-9][0-9][0-9][0-9].{224})|6(?:[0-3][0-9][0-9][0-9][0-9][0-9].{224}|[5-9][0-9][0-9][0-9][0-9][0-9].{64}|4[0-9][0-9][0-9][0-9][0-9].{280})|5(?:[5-9][0-9][0-9][0-9][0-9][0-9].{296}|[0-4][0-9][0-9][0-9][0-9][0-9].{64})|[139][0-9][0-9][0-9][0-9][0-9][0-9].{8}|[78][0-9][0-9][0-9][0-9][0-9][0-9].{4})|5(?:6(?:6(?:[02-5][0-9][0-9][0-9][0-9].{312}|[6-9][0-9][0-9][0-9][0-9].{220}|1[0-9][0-9][0-9][0-9].{712})|[0-59][0-9][0-9][0-9][0-9][0-9].{224}|[78][0-9][0-9][0-9][0-9][0-9].{256})|3(?:[5-9][0-9][0-9][0-9][0-9][0-9].{276}|[0-4][0-9][0-9][0-9][0-9][0-9].{20})|[089][0-9][0-9][0-9][0-9][0-9][0-9].{20}|[12][0-9][0-9][0-9][0-9][0-9][0-9].{276}|7[0-9][0-9][0-9][0-9][0-9][0-9].{224}|4[0-9][0-9][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9][0-9][0-9].{8})|6(?:9(?:[0-79][0-9][0-9][0-9][0-9][0-9].{20}|8[0-9][0-9][0-9][0-9][0-9].{8})|[0-8][0-9][0-9][0-9][0-9][0-9][0-9].{20})|[12][0-9][0-9][0-9][0-9][0-9][0-9][0-9].{8}|[78][0-9][0-9][0-9][0-9][0-9][0-9][0-9].{4})|7(?:5(?:7(?:5(?:[0-6][0-9][0-9][0-9][0-9].{208}|[78][0-9][0-9][0-9][0-9].{152}|9[0-9][0-9][0-9][0-9].{104})|7(?:7[0-9][0-9][0-9][0-9].{152}|9[0-9][0-9][0-9][0-9].{632})|0(?:0[0-9][0-9][0-9][0-9].{128}|7[0-9][0-9][0-9][0-9].{52})|(?:6[37]|87)[0-9][0-9][0-9][0-9].{152}|[23][0-9][0-9][0-9][0-9][0-9].{312}|4[0-9][0-9][0-9][0-9][0-9].{208}|17[0-9][0-9][0-9][0-9].{52})|0(?:7(?:[3-5][0-9][0-9][0-9][0-9].{112}|[12][0-9][0-9][0-9][0-9].{616}|0[0-9][0-9][0-9][0-9].{152})|6(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{152})|(?:5[0-378]|0[0-9])[0-9][0-9][0-9][0-9].{152}|[1-489][0-9][0-9][0-9][0-9][0-9].{8})|4(?:3(?:0[0-9][0-9][0-9][0-9].{920}|2[0-9][0-9][0-9][0-9].{152}|1[0-9][0-9][0-9][0-9].{44})|[0-245][0-9][0-9][0-9][0-9][0-9].{188}|[89][0-9][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9][0-9].{312}|7[0-9][0-9][0-9][0-9][0-9].{688})|5(?:5(?:[0-4][0-9][0-9][0-9][0-9].{44}|[67][0-9][0-9][0-9][0-9].{156}|5[0-9][0-9][0-9][0-9].{152})|6(?:[0-4][0-9][0-9][0-9][0-9].{220}|[6-8][0-9][0-9][0-9][0-9].{152})|[0-47-9][0-9][0-9][0-9][0-9][0-9].{188})|2(?:0(?:[2-6][0-9][0-9][0-9][0-9].{220}|[01][0-9][0-9][0-9][0-9].{168})|[1-57-9][0-9][0-9][0-9][0-9][0-9].{188}|6[0-9][0-9][0-9][0-9][0-9].{8})|1(?:[0-5][0-9][0-9][0-9][0-9][0-9].{296}|[89][0-9][0-9][0-9][0-9][0-9].{188}|7[0-9][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9][0-9].{8})|6(?:[0-4][0-9][0-9][0-9][0-9][0-9].{448}|[5-9][0-9][0-9][0-9][0-9][0-9].{364})|[38][0-9][0-9][0-9][0-9][0-9][0-9].{296}|9[0-9][0-9][0-9][0-9][0-9][0-9].{844})|7(?:1(?:5(?:[5-9][0-9][0-9][0-9][0-9].{64}|[0-4][0-9][0-9][0-9][0-9].{8})|(?:[0-26-8][0-9]|9[0-4])[0-9][0-9][0-9][0-9].{64}|[34][0-9][0-9][0-9][0-9][0-9].{8})|0(?:[5-9][0-9][0-9][0-9][0-9][0-9].{64}|[0-2][0-9][0-9][0-9][0-9][0-9].{4}|[34][0-9][0-9][0-9][0-9][0-9].{8})|5(?:[0-4][0-9][0-9][0-9][0-9][0-9].{8}|[56][0-9][0-9][0-9][0-9][0-9].{312})|[6-9][0-9][0-9][0-9][0-9][0-9][0-9].{8})|8(?:0(?:[0-6][0-9][0-9][0-9][0-9][0-9].{280}|[78][0-9][0-9][0-9][0-9][0-9].{188}|9[0-9][0-9][0-9][0-9][0-9].{336})|(?:(?:[59][0-9]|[78][0-9])[0-9]|6(?:[1-9][0-9]|0[0-9]))[0-9][0-9][0-9][0-9].{4}|4(?:[0-5][0-9][0-9][0-9][0-9][0-9].{4}|[6-8][0-9][0-9][0-9][0-9][0-9].{256})|[1-3][0-9][0-9][0-9][0-9][0-9][0-9].{276})|6(?:(?:0(?:[1-9][0-9]|0[0-9])|[1-5][0-9][0-9])[0-9][0-9][0-9][0-9].{20}|(?:[7-9][0-9]|69)[0-9][0-9][0-9][0-9][0-9].{276})|0000(?:2[0-9][0-9][0-9].{312}|3[0-9][0-9][0-9].{20}|0[0-9][0-9][0-9].{4}|1[0-9][0-9][0-9].{8})))/) {
        my $op = substr($1, -4);
        $op =~ s/ *$//;
        return $op;
    }
    return undef;
}

1; # vim:set ft=perl et sw=4 sts=4:
