/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import java.security.AccessControlException;
import java.util.Date;
import java.util.Map;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.memcached.Item;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.VBucket;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class DataStore {
    private volatile long casCounter = 1L;
    private VBucket[] vBucketMap;
    private static final long THIRTY_DAYS = 2592000L;

    public DataStore(int size) {
        this.vBucketMap = new VBucket[size];
        for (int ii = 0; ii < size; ++ii) {
            this.vBucketMap[ii] = new VBucket(null);
        }
    }

    public VBucket getVBucket(short vbucket) {
        if (vbucket >= this.vBucketMap.length) {
            throw new AccessControlException("Illegal vbucket");
        }
        return this.vBucketMap[vbucket];
    }

    public Map<String, Item>[] getData() {
        Map[] res = new Map[this.vBucketMap.length];
        for (int i = 0; i < this.vBucketMap.length; ++i) {
            res[i] = this.vBucketMap[i].getMap(this.vBucketMap[i].getOwner());
        }
        return res;
    }

    private Map<String, Item> getMap(MemcachedServer server, short vbucket) throws AccessControlException {
        if (vbucket >= this.vBucketMap.length && server.getType() == Bucket.BucketType.COUCHBASE) {
            throw new AccessControlException("Illegal vbucket");
        }
        return this.vBucketMap[vbucket].getMap(server);
    }

    public void setOwnership(int vbucket, MemcachedServer server) {
        this.vBucketMap[vbucket].setOwner(server);
    }

    public ErrorCode add(MemcachedServer server, short vBucketId, Item item) {
        Map<String, Item> map = this.getMap(server, vBucketId);
        Item old = this.lookup(map, item.getKey());
        if (old != null || item.getCas() != 0L) {
            return ErrorCode.KEY_EEXISTS;
        }
        item.setCas(++this.casCounter);
        map.put(item.getKey(), item);
        return ErrorCode.SUCCESS;
    }

    public ErrorCode replace(MemcachedServer server, short vBucketId, Item item) {
        Map<String, Item> map = this.getMap(server, vBucketId);
        Item old = this.lookup(map, item.getKey());
        if (old == null) {
            return ErrorCode.KEY_ENOENT;
        }
        if (item.getCas() != old.getCas() && item.getCas() != 0L) {
            return ErrorCode.KEY_EEXISTS;
        }
        item.setCas(++this.casCounter);
        map.put(item.getKey(), item);
        return ErrorCode.SUCCESS;
    }

    public ErrorCode set(MemcachedServer server, short vBucketId, Item item) {
        Map<String, Item> map = this.getMap(server, vBucketId);
        if (item.getCas() == 0L) {
            item.setCas(++this.casCounter);
            map.put(item.getKey(), item);
            return ErrorCode.SUCCESS;
        }
        return this.replace(server, vBucketId, item);
    }

    ErrorCode delete(MemcachedServer server, short vBucketId, String key, long cas) {
        Map<String, Item> map = this.getMap(server, vBucketId);
        Item i = this.lookup(map, key);
        if (i == null) {
            return ErrorCode.KEY_ENOENT;
        }
        if (cas == 0L || cas == i.getCas()) {
            map.remove(key);
            return ErrorCode.SUCCESS;
        }
        return ErrorCode.KEY_EEXISTS;
    }

    Item get(MemcachedServer server, short vBucketId, String key) {
        Map<String, Item> map = this.getMap(server, vBucketId);
        return this.lookup(map, key);
    }

    void flush(MemcachedServer server) {
        for (VBucket b : this.vBucketMap) {
            b.flush(server);
        }
    }

    private Item lookup(Map<String, Item> map, String key) {
        Item ii = map.get(key);
        if (ii != null) {
            long now = new Date().getTime();
            if (ii.getExptime() == 0 || (long)ii.getExptime() > 2592000L && now < ii.getExptimeInMillis() || (long)ii.getExptime() <= 2592000L && now - ii.getMtime() < ii.getExptimeInMillis()) {
                return ii;
            }
            map.remove(key);
        }
        return null;
    }
}

