package Venus::Role::Unpackable;

use 5.018;

use strict;
use warnings;

use Venus::Role 'with';

# METHODS

sub unpack {
  my ($self, @args) = @_;

  require Venus::Unpack;

  my $name = (caller(1))[3] =~ s/.*::(\w+)$/$1/gr;

  return Venus::Unpack->from($self)->name($name)->do('args', @args)->all;
}

# EXPORTS

sub EXPORT {
  ['unpack']
}

1;



=head1 NAME

Venus::Role::Unpackable - Unpackable Role

=cut

=head1 ABSTRACT

Unpackable Role for Perl 5

=cut

=head1 SYNOPSIS

  package Example;

  use Venus::Class;

  with 'Venus::Role::Unpackable';

  sub execute {
    return shift;
  }

  package main;

  my $example = Example->new;

  # $example->unpack("hello", 123, 1.23)->signature(
  #   'string', 'number', 'float',
  # );

=cut

=head1 DESCRIPTION

This package modifies the consuming package and provides methods for unpacking
and validating argument lists.

=cut

=head1 METHODS

This package provides the following methods:

=cut

=head2 unpack

  unpack(Any @args) (Venus::Unpack)

The unpack method passes the arguments provided to L<Venus::Unpack> for
unpacking and validating arbitrary argument lists.

I<Since C<2.01>>

=over 4

=item unpack example 1

  package main;

  my $example = Example->new;

  my $results = $example->unpack("hello", 123, 1.23)->signature(
    'any',
  );

  # ["hello", 123, 1.23]

=back

=over 4

=item unpack example 2

  package main;

  my $example = Example->new;

  my $results = $example->unpack("hello", 123, 1.23)->signature(
    'string',
    'number | float',
  );

  # ["hello", 123, 1.23]

=back

=over 4

=item unpack example 3

  package main;

  my $example = Example->new;

  my $results = $example->unpack("hello", 123, 1.23)->signature(
    'string',
    'number',
    'float',
  );

  # ["hello", 123, 1.23]

=back

=cut

=head1 AUTHORS

Awncorp, C<awncorp@cpan.org>

=cut

=head1 LICENSE

Copyright (C) 2000, Al Newkirk.

This program is free software, you can redistribute it and/or modify it under
the terms of the Apache license version 2.0.

=cut