package WebService::FOAAS;

=encoding utf-8

=head1 NAME

WebService::FOAAS - API client for https://foaas.com

=head1 SYNOPSIS

  use WebService::FOAAS;
  print foaas_too 'MGV'; # Thanks, fuck you too. - MGV
  print foaas_cool 'MGV', {shoutcloud => 1}; # COOL STORY, BRO. - MGV

=head1 DESCRIPTION

FOAAS (Fuck Off As A Service) provides a modern, RESTful, scalable
solution to the common problem of telling people to fuck off.

C<WebService::FOAAS> is an API client for FOAAS. It provides a series
of methods for getting data from the service.

The methods are listed below, and documented on the FOAAS webpage.
Each method comes under two names, C<thing> and C<foaas_thing>.
They are identical in function, but only C<foaas_thing> is exported by
default while C<thing> is only exported on request.

=cut

use 5.014000;
use strict;
use warnings;

use HTTP::Tiny;
use URI::Escape;

use parent qw/Exporter/;

our $VERSION = '0.001001';
our $BASE = 'https://foaas.com';

our $ht = HTTP::Tiny->new;

sub request {
	my (@args) = @_;
	my @query;
	if (ref $args[$#args] eq 'HASH') {
		my $query = pop @args;
		for (keys %$query) {
			my $key = uri_escape_utf8 $_;
			my $val = uri_escape_utf8 $query->{$_};
			push @query, "$key=$val";
		}
	}

	my $query = @query ? '?'.(join '&', @query) : '';
	my $path = join '/', '', @args;
	my $final_url = $BASE.$path.$query;

	my $result = $ht->get($final_url, {headers => {Accept => 'text/plain'}});
	die $result->{reason} unless $result->{success};
	$result->{content}
}

### Start of code generated by WebService::FOAAS::Codegen->run

=head1 AVAILABLE METHODS

=over

=item foaas_anyway $company, $from

=cut

sub foaas_anyway {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'anyway', @_;
}

BEGIN { *anyway = \&foaas_anyway }

=item foaas_awesome $from

=cut

sub foaas_awesome {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'awesome', @_;
}

BEGIN { *awesome = \&foaas_awesome }

=item foaas_back $name, $from

=cut

sub foaas_back {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'back', @_;
}

BEGIN { *back = \&foaas_back }

=item foaas_bag $from

=cut

sub foaas_bag {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'bag', @_;
}

BEGIN { *bag = \&foaas_bag }

=item foaas_ballmer $name, $company, $from

=cut

sub foaas_ballmer {
	die "Expected 3 arguments" unless @_ == 3 || @_ == 4;
	request 'ballmer', @_;
}

BEGIN { *ballmer = \&foaas_ballmer }

=item foaas_bday $name, $from

=cut

sub foaas_bday {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'bday', @_;
}

BEGIN { *bday = \&foaas_bday }

=item foaas_because $from

=cut

sub foaas_because {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'because', @_;
}

BEGIN { *because = \&foaas_because }

=item foaas_blackadder $name, $from

=cut

sub foaas_blackadder {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'blackadder', @_;
}

BEGIN { *blackadder = \&foaas_blackadder }

=item foaas_bm $name, $from

=cut

sub foaas_bm {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'bm', @_;
}

BEGIN { *bm = \&foaas_bm }

=item foaas_bucket $from

=cut

sub foaas_bucket {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'bucket', @_;
}

BEGIN { *bucket = \&foaas_bucket }

=item foaas_bus $name, $from

=cut

sub foaas_bus {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'bus', @_;
}

BEGIN { *bus = \&foaas_bus }

=item foaas_bye $from

=cut

sub foaas_bye {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'bye', @_;
}

BEGIN { *bye = \&foaas_bye }

=item foaas_caniuse $tool, $from

=cut

sub foaas_caniuse {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'caniuse', @_;
}

BEGIN { *caniuse = \&foaas_caniuse }

=item foaas_chainsaw $name, $from

=cut

sub foaas_chainsaw {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'chainsaw', @_;
}

BEGIN { *chainsaw = \&foaas_chainsaw }

=item foaas_cocksplat $name, $from

=cut

sub foaas_cocksplat {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'cocksplat', @_;
}

BEGIN { *cocksplat = \&foaas_cocksplat }

=item foaas_cool $from

=cut

sub foaas_cool {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'cool', @_;
}

BEGIN { *cool = \&foaas_cool }

=item foaas_dalton $name, $from

=cut

sub foaas_dalton {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'dalton', @_;
}

BEGIN { *dalton = \&foaas_dalton }

=item foaas_deraadt $name, $from

=cut

sub foaas_deraadt {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'deraadt', @_;
}

BEGIN { *deraadt = \&foaas_deraadt }

=item foaas_diabetes $from

=cut

sub foaas_diabetes {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'diabetes', @_;
}

BEGIN { *diabetes = \&foaas_diabetes }

=item foaas_donut $name, $from

=cut

sub foaas_donut {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'donut', @_;
}

BEGIN { *donut = \&foaas_donut }

=item foaas_dosomething $do, $something, $from

=cut

sub foaas_dosomething {
	die "Expected 3 arguments" unless @_ == 3 || @_ == 4;
	request 'dosomething', @_;
}

BEGIN { *dosomething = \&foaas_dosomething }

=item foaas_everyone $from

=cut

sub foaas_everyone {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'everyone', @_;
}

BEGIN { *everyone = \&foaas_everyone }

=item foaas_everything $from

=cut

sub foaas_everything {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'everything', @_;
}

BEGIN { *everything = \&foaas_everything }

=item foaas_family $from

=cut

sub foaas_family {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'family', @_;
}

BEGIN { *family = \&foaas_family }

=item foaas_fascinating $from

=cut

sub foaas_fascinating {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'fascinating', @_;
}

BEGIN { *fascinating = \&foaas_fascinating }

=item foaas_field $name, $from, $reference

=cut

sub foaas_field {
	die "Expected 3 arguments" unless @_ == 3 || @_ == 4;
	request 'field', @_;
}

BEGIN { *field = \&foaas_field }

=item foaas_flying $from

=cut

sub foaas_flying {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'flying', @_;
}

BEGIN { *flying = \&foaas_flying }

=item foaas_gfy $name, $from

=cut

sub foaas_gfy {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'gfy', @_;
}

BEGIN { *gfy = \&foaas_gfy }

=item foaas_give $from

=cut

sub foaas_give {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'give', @_;
}

BEGIN { *give = \&foaas_give }

=item foaas_greed $noun, $from

=cut

sub foaas_greed {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'greed', @_;
}

BEGIN { *greed = \&foaas_greed }

=item foaas_horse $from

=cut

sub foaas_horse {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'horse', @_;
}

BEGIN { *horse = \&foaas_horse }

=item foaas_ing $name, $from

=cut

sub foaas_ing {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'ing', @_;
}

BEGIN { *ing = \&foaas_ing }

=item foaas_keep $name, $from

=cut

sub foaas_keep {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'keep', @_;
}

BEGIN { *keep = \&foaas_keep }

=item foaas_keepcalm $reaction, $from

=cut

sub foaas_keepcalm {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'keepcalm', @_;
}

BEGIN { *keepcalm = \&foaas_keepcalm }

=item foaas_king $name, $from

=cut

sub foaas_king {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'king', @_;
}

BEGIN { *king = \&foaas_king }

=item foaas_life $from

=cut

sub foaas_life {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'life', @_;
}

BEGIN { *life = \&foaas_life }

=item foaas_linus $name, $from

=cut

sub foaas_linus {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'linus', @_;
}

BEGIN { *linus = \&foaas_linus }

=item foaas_look $name, $from

=cut

sub foaas_look {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'look', @_;
}

BEGIN { *look = \&foaas_look }

=item foaas_looking $from

=cut

sub foaas_looking {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'looking', @_;
}

BEGIN { *looking = \&foaas_looking }

=item foaas_madison $name, $from

=cut

sub foaas_madison {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'madison', @_;
}

BEGIN { *madison = \&foaas_madison }

=item foaas_maybe $from

=cut

sub foaas_maybe {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'maybe', @_;
}

BEGIN { *maybe = \&foaas_maybe }

=item foaas_me $from

=cut

sub foaas_me {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'me', @_;
}

BEGIN { *me = \&foaas_me }

=item foaas_mornin $from

=cut

sub foaas_mornin {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'mornin', @_;
}

BEGIN { *mornin = \&foaas_mornin }

=item foaas_no $from

=cut

sub foaas_no {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'no', @_;
}

BEGIN { *no = \&foaas_no }

=item foaas_nugget $name, $from

=cut

sub foaas_nugget {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'nugget', @_;
}

BEGIN { *nugget = \&foaas_nugget }

=item foaas_off $name, $from

=cut

sub foaas_off {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'off', @_;
}

BEGIN { *off = \&foaas_off }

=item foaas_off_with $behavior, $from

=cut

sub foaas_off_with {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'off_with', @_;
}

BEGIN { *off_with = \&foaas_off_with }

=item foaas_outside $name, $from

=cut

sub foaas_outside {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'outside', @_;
}

BEGIN { *outside = \&foaas_outside }

=item foaas_particular $thing, $from

=cut

sub foaas_particular {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'particular', @_;
}

BEGIN { *particular = \&foaas_particular }

=item foaas_pink $from

=cut

sub foaas_pink {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'pink', @_;
}

BEGIN { *pink = \&foaas_pink }

=item foaas_problem $name, $from

=cut

sub foaas_problem {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'problem', @_;
}

BEGIN { *problem = \&foaas_problem }

=item foaas_pulp $language, $from

=cut

sub foaas_pulp {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'pulp', @_;
}

BEGIN { *pulp = \&foaas_pulp }

=item foaas_retard $from

=cut

sub foaas_retard {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'retard', @_;
}

BEGIN { *retard = \&foaas_retard }

=item foaas_ridiculous $from

=cut

sub foaas_ridiculous {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'ridiculous', @_;
}

BEGIN { *ridiculous = \&foaas_ridiculous }

=item foaas_rtfm $from

=cut

sub foaas_rtfm {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'rtfm', @_;
}

BEGIN { *rtfm = \&foaas_rtfm }

=item foaas_sake $from

=cut

sub foaas_sake {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'sake', @_;
}

BEGIN { *sake = \&foaas_sake }

=item foaas_shakespeare $name, $from

=cut

sub foaas_shakespeare {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'shakespeare', @_;
}

BEGIN { *shakespeare = \&foaas_shakespeare }

=item foaas_shit $from

=cut

sub foaas_shit {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'shit', @_;
}

BEGIN { *shit = \&foaas_shit }

=item foaas_shutup $name, $from

=cut

sub foaas_shutup {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'shutup', @_;
}

BEGIN { *shutup = \&foaas_shutup }

=item foaas_single $from

=cut

sub foaas_single {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'single', @_;
}

BEGIN { *single = \&foaas_single }

=item foaas_thanks $from

=cut

sub foaas_thanks {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'thanks', @_;
}

BEGIN { *thanks = \&foaas_thanks }

=item foaas_that $from

=cut

sub foaas_that {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'that', @_;
}

BEGIN { *that = \&foaas_that }

=item foaas_think $name, $from

=cut

sub foaas_think {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'think', @_;
}

BEGIN { *think = \&foaas_think }

=item foaas_thinking $name, $from

=cut

sub foaas_thinking {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'thinking', @_;
}

BEGIN { *thinking = \&foaas_thinking }

=item foaas_this $from

=cut

sub foaas_this {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'this', @_;
}

BEGIN { *this = \&foaas_this }

=item foaas_thumbs $name, $from

=cut

sub foaas_thumbs {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'thumbs', @_;
}

BEGIN { *thumbs = \&foaas_thumbs }

=item foaas_too $from

=cut

sub foaas_too {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'too', @_;
}

BEGIN { *too = \&foaas_too }

=item foaas_tucker $from

=cut

sub foaas_tucker {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'tucker', @_;
}

BEGIN { *tucker = \&foaas_tucker }

=item foaas_version 

=cut

sub foaas_version {
	die "Expected 0 arguments" unless @_ == 0 || @_ == 1;
	request 'version', @_;
}

BEGIN { *version = \&foaas_version }

=item foaas_what $from

=cut

sub foaas_what {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'what', @_;
}

BEGIN { *what = \&foaas_what }

=item foaas_xmas $name, $from

=cut

sub foaas_xmas {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'xmas', @_;
}

BEGIN { *xmas = \&foaas_xmas }

=item foaas_yoda $name, $from

=cut

sub foaas_yoda {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'yoda', @_;
}

BEGIN { *yoda = \&foaas_yoda }

=item foaas_you $name, $from

=cut

sub foaas_you {
	die "Expected 2 arguments" unless @_ == 2 || @_ == 3;
	request 'you', @_;
}

BEGIN { *you = \&foaas_you }

=item foaas_zayn $from

=cut

sub foaas_zayn {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'zayn', @_;
}

BEGIN { *zayn = \&foaas_zayn }

=item foaas_zero $from

=cut

sub foaas_zero {
	die "Expected 1 arguments" unless @_ == 1 || @_ == 2;
	request 'zero', @_;
}

BEGIN { *zero = \&foaas_zero }

BEGIN {
	our @EXPORT   = qw/foaas_anyway foaas_awesome foaas_back foaas_bag foaas_ballmer foaas_bday foaas_because foaas_blackadder foaas_bm foaas_bucket foaas_bus foaas_bye foaas_caniuse foaas_chainsaw foaas_cocksplat foaas_cool foaas_dalton foaas_deraadt foaas_diabetes foaas_donut foaas_dosomething foaas_everyone foaas_everything foaas_family foaas_fascinating foaas_field foaas_flying foaas_gfy foaas_give foaas_greed foaas_horse foaas_ing foaas_keep foaas_keepcalm foaas_king foaas_life foaas_linus foaas_look foaas_looking foaas_madison foaas_maybe foaas_me foaas_mornin foaas_no foaas_nugget foaas_off foaas_off_with foaas_outside foaas_particular foaas_pink foaas_problem foaas_pulp foaas_retard foaas_ridiculous foaas_rtfm foaas_sake foaas_shakespeare foaas_shit foaas_shutup foaas_single foaas_thanks foaas_that foaas_think foaas_thinking foaas_this foaas_thumbs foaas_too foaas_tucker foaas_version foaas_what foaas_xmas foaas_yoda foaas_you foaas_zayn foaas_zero/;
	our @EXPORT_OK = qw/foaas_anyway foaas_awesome foaas_back foaas_bag foaas_ballmer foaas_bday foaas_because foaas_blackadder foaas_bm foaas_bucket foaas_bus foaas_bye foaas_caniuse foaas_chainsaw foaas_cocksplat foaas_cool foaas_dalton foaas_deraadt foaas_diabetes foaas_donut foaas_dosomething foaas_everyone foaas_everything foaas_family foaas_fascinating foaas_field foaas_flying foaas_gfy foaas_give foaas_greed foaas_horse foaas_ing foaas_keep foaas_keepcalm foaas_king foaas_life foaas_linus foaas_look foaas_looking foaas_madison foaas_maybe foaas_me foaas_mornin foaas_no foaas_nugget foaas_off foaas_off_with foaas_outside foaas_particular foaas_pink foaas_problem foaas_pulp foaas_retard foaas_ridiculous foaas_rtfm foaas_sake foaas_shakespeare foaas_shit foaas_shutup foaas_single foaas_thanks foaas_that foaas_think foaas_thinking foaas_this foaas_thumbs foaas_too foaas_tucker foaas_version foaas_what foaas_xmas foaas_yoda foaas_you foaas_zayn foaas_zero anyway awesome back bag ballmer bday because blackadder bm bucket bus bye caniuse chainsaw cocksplat cool dalton deraadt diabetes donut dosomething everyone everything family fascinating field flying gfy give greed horse ing keep keepcalm king life linus look looking madison maybe me mornin no nugget off off_with outside particular pink problem pulp retard ridiculous rtfm sake shakespeare shit shutup single thanks that think thinking this thumbs too tucker version what xmas yoda you zayn zero/;
}

=back

=cut

### End of code generated by WebService::FOAAS::Codegen->run

1;
__END__

=head1 SEE ALSO

L<https://foaas.com>

=head1 AUTHOR

Marius Gavrilescu E<lt>marius@ieval.roE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2017 by Marius Gavrilescu

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.22.3 or,
at your option, any later version of Perl 5 you may have available.


=cut
