package Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Black;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-06'; # DATE
our $DIST = 'Graphics-ColorNamesCMYK-ToutesLesCouleursCom'; # DIST
our $VERSION = '0.001'; # VERSION

our $NAMES_CMYK_TABLE = {
  'black' => 0x00000064, # 0,0,0,100
  'crow wing' => 0x00000064, # 0,0,0,100
  'walnut brou' => 0x002e5e4b, # 0,46,94,75
  'cassis' => 0x005d4b53, # 0,93,75,83
  'cassis' => 0x00614e4d, # 0,97,78,77
  'dorian' => 0x4d1a273b, # 77,26,39,59
  'ebony' => 0x00000064, # 0,0,0,100
  'animal black' => 0x00000064, # 0,0,0,100
  'black coal' => 0x00000064, # 0,0,0,100
  'aniline black' => 0x1229005b, # 18,41,0,91
  'carbon black' => 0x001a2f5d, # 0,26,47,93
  'black smoke' => 0x001a2f5d, # 0,26,47,93
  'jet black' => 0x00000064, # 0,0,0,100
  'black ink' => 0x00000064, # 0,0,0,100
  'ivory black' => 0x00000064, # 0,0,0,100
  'noiraud' => 0x00244652, # 0,36,70,82
  'licorice' => 0x00142152, # 0,20,33,82
};


1;
# ABSTRACT: CMYK colors from http://toutes-les-couleurs.com/ (black)

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Black - CMYK colors from http://toutes-les-couleurs.com/ (black)

=head1 VERSION

This document describes version 0.001 of Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Black (from Perl distribution Graphics-ColorNamesCMYK-ToutesLesCouleursCom), released on 2024-05-06.

=head1 DESCRIPTION

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SEE ALSO

Other C<Graphics::ColorNamesCMYK::ToutesLesCoulersCom::*> modules.

Other C<Graphics::ColorNamesCMYK::*> modules.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNamesCMYK-ToutesLesCouleursCom>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
