use strict;
use warnings;
use Test::More tests => 68;
use Digest::SIMD qw(simd_224 simd_224_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::SIMD->new(224)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            simd_224_hex($data), $digest,
            "simd_224_hex: $len bits of $msg"
        );
        ok(
            simd_224($data) eq pack('H*', $digest),
            "simd_224: $len bits of $msg"
        );
    }

    my $md = Digest::SIMD->new(224)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

__DATA__
00|43E1D53656D7B85D10D5499E28AFDEF90BB497730D2853C8609B534B
00|9E275E93538D91A36DBB4D7CBA0C666ADDD91B3444C8DB70D08C0827
C0|7BBCEB6698B88F025D1A52722B6B4313303E7C9D0F15268286C8BFE4
C0|7EB0A8092A9BD0B6FC348A9A54AB700B27826C95258836BF1B6C7723
80|2B04E09064CEC993EC4CCFE8C47A705C6309FE015BFDCE69D0AF2B6A
48|DE9969063A338C82EDD4F1A07EA6B59102C123EA016B307B50A00591
50|71F15D0FDC063ABCF8E3BDBC03E1BEDC472913A3F66858CBD36FE56D
98|953B39A5AA6DBB11F7EDFC6204F68845A4657BA80127036F897CD24C
CC|1F32C0ACDCE1581C02C93AAFAC852BBA621544AAF9A9259CCE7FA169
9800|7F2973DCF2F20D84098D1E2096909A04CE420BFC42385CA986D62646
9D40|79990E68EB9E3B695EE44E5ACFC8E481C110B78C3005C8B09A9F275F
AA80|41127F932317EDC12365B5220888009BF01F5F749E90A9EFC8B38824
9830|5E3DC65A06822F1EF09FABB58B17CAB7EAFBAD225200E93FEAC35180
5030|D87150A60C963ACA205460ADD322C17581C20F33AD428B95A2973424
4D24|C69E749131C5561F2D5357B29C212BF75E5456100F7DE80DEC37E46C
CBDE|A9693EFCB5DEB100FD6F063C5D57443ADA2F3D4FEB8ED6B71F476C44
41FB|15674F75783CA50B106AEB9F0BACC8B895D9328B26677D4D84CD7700
4FF400|D355EC8B326EDF5EC4FE5F0A72D0F74396E9E40FC9099BA41901C9AE
FD0440|59B8EF7039743D9B09D3FF3FB377C4D8A67D71647C493AB576A9A04E
424D00|22356C778FE0D6E4E92C720389A703BA27C7649E8EE6B6B99F1D5CB2
3FDEE0|8C626B91DEC61523988A38FB4C4982CBCA0D8E15EF833F92BCC43300
335768|A890F93BF381DA08F130FA812A0CC75B8618052611FBDDE3CA62A175
051E7C|98A1958A1EE7558B0BF19CE710FDAD688D37A3AA31812CC66C90C591
717F8C|6CBEC6F03797E8FF5AB72DA0E987A104BD2CF80154964297BCC247B8
1F877C|962E228A4F942E51C2451198BBCE4127B571D3811B6D564EFD1F9625
EB35CF80|1E91785DB69EB1272A9621F8F114D54A8EE547F16F1B38CF6AE05A3D
B406C480|89BC9E7CF89417605A5D7388220541A77CA3E1B866E818C14DA9AA44
CEE88040|5C945C600E5F15C0F287508F2F44F8E1D8C46C8BDDA1F1167C8F85A7
C584DB70|4FBDCF910428F4EF3EE2A989BE09687FEE7CA87D692E7D9510EF88A5
53587BC8|CF54B2871A32ACF8952E067E144E958AE8859CF6F7FCF1437E53A54F
69A305B0|F93BC0797C3A27555627B1D0EC6590D38AEFA432CC0E2C70455B1996
C9375ECE|4072B5C702BD35F1B17B62D87CC29E311406842318E3CF7AE03705EC
C1ECFDFC|2B1B45A0EAEA7F2924CCE3E45337CB6815205D5B072833A8ACC0DDFA
8D73E8A280|A425B6F3BF64C1FF4B8F243B168B69B7856EB84A954089FBF8F76E44
06F2522080|F7BDCC28ABE0C9987752674A03D2D5D83F54B3D3DDDFE34FAAC14FA6
3EF6C36F20|E007A371BB850FCA749FE31D37920626BE6505075194192666FD9C1C
0127A1D340|77E3E7C4CBAF8E733D02C6455486FEF73B996452DB3085651FB80616
6A6AB6C210|636E3DD055ECC69F1855423A4FE004DA8C810EF96F7BC40A1B7AA5EF
AF3175E160|ED705FE4E137DBE53E0CCB4DF55063786307CAF96602F0D2C8DA4CB3
B66609ED86|7C3EF333A054244FD25441DA486C13D00BFDD0B9D850411127C27130
21F134AC57|622E58E3CED8FF87F56BE5FE2E7E68A0F99A327E5B6984908CC3B183
3DC2AADFFC80|854538C9AD62396D315845AF5FE9DA777418A94A1353BF88211EBC3A
9202736D2240|5F859218AA20A219B7E4785E2513495E351600BEEDCB42F547CB2B8F
F219BD629820|5DFFE2243A30F18E5982748A7D40DC13A5DDB5C8AA2FD62087501531
F3511EE2C4B0|726EAA4B8813842ECE7ECFF29189DC02912405DF0C6DC20F0F9C3B32
3ECAB6BF7720|31F1B60EE44484B551BD1FF2648CB6D86EE1DA19827E0EC237183D84
CD62F688F498|5E385DAA1297448B115326CF1471ADBE69744A52BCCBA211167B9AD2
C2CBAA33A9F8|A42D2F3E217C9CA2B2281715E4F53B7C6C21CA5E5F06283071236BD0
C6F50BB74E29|EEAF7EEFE8923F10346B339789CEC287ABDA3082A983E2940B6A48BB
79F1B4CCC62A00|56603A81FD790B8C52B968548376D109B30CEC200F18CF61498D6681
