/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached.protocol;

import java.net.ProtocolException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.couchbase.mock.memcached.KeySpec;
import org.couchbase.mock.memcached.protocol.BinaryCommand;

public class BinaryObserveCommand
extends BinaryCommand {
    private final List<KeySpec> keySpecs = new ArrayList<KeySpec>();

    protected BinaryObserveCommand(ByteBuffer header) throws ProtocolException {
        super(header);
    }

    public List<KeySpec> getKeySpecs() {
        return new ArrayList<KeySpec>(this.keySpecs);
    }

    @Override
    public void process() throws ProtocolException {
        if (this.keySpecs.size() > 0) {
            return;
        }
        this.bodyBuffer.rewind();
        while (this.bodyBuffer.hasRemaining()) {
            try {
                short vb = this.bodyBuffer.getShort();
                short keyLength = this.bodyBuffer.getShort();
                byte[] keyBuffer = new byte[keyLength];
                this.bodyBuffer.get(keyBuffer);
                String key = new String(keyBuffer);
                KeySpec ks = new KeySpec(key, vb);
                this.keySpecs.add(ks);
            }
            catch (BufferUnderflowException e) {
                throw new ProtocolException();
            }
        }
    }
}

