# Generated by default/object.tt
package Paws::LookoutMetrics::AnomalyGroupTimeSeriesFeedback;
  use Moose;
  has AnomalyGroupId => (is => 'ro', isa => 'Str', required => 1);
  has IsAnomaly => (is => 'ro', isa => 'Bool', required => 1);
  has TimeSeriesId => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutMetrics::AnomalyGroupTimeSeriesFeedback

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutMetrics::AnomalyGroupTimeSeriesFeedback object:

  $service_obj->Method(Att1 => { AnomalyGroupId => $value, ..., TimeSeriesId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutMetrics::AnomalyGroupTimeSeriesFeedback object:

  $result = $service_obj->Method(...);
  $result->Att1->AnomalyGroupId

=head1 DESCRIPTION

Feedback for an anomalous metric.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AnomalyGroupId => Str

The ID of the anomaly group.


=head2 B<REQUIRED> IsAnomaly => Bool

Feedback on whether the metric is a legitimate anomaly.


=head2 B<REQUIRED> TimeSeriesId => Str

The ID of the metric.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutMetrics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

