#!/usr/bin/perl

package eBay::API::XML::Call::GetCategories::GetCategoriesRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetCategoriesRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetCategories::GetCategoriesRequestType

=head1 DESCRIPTION

Retrieves the latest category hierarchy available on a given site.
(By default, this is the site to which you submit the request.)
You can retrieve all categories on the site, or you can use
CategoryParent to retrieve one particular category and its
subcategories.<br>
<br>
For each category, the call returns the category name, its unique ID
(within the site to which you sent the request), and meta-data that
helps you determine where the category fits in the hierarchy.
eBay requires sellers to specify a category ID for most new listings.
You can only list in leaf categories.<br>
<br>
The call also identifies a few eBay features that are only supported
in some categories. For example, some categories support
immediate payment (AutoPay), and some categories don't.
For information about additional features that vary by category,
use GetCategoryFeatures and/or GetCategory2CS.<br>
<br>
The API provides other calls that supplement GetCategories.
For example, consider using GetSuggestedCategories to help the seller
choose a category ID. In certain cases, it may be helpful to
use GetCategoryMappings to update locally stored item data
(although most applications can use the simpler
CategoryMappingAllowed flag in AddItem for this purpose).



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetCategories::GetCategoriesRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");



my @gaProperties = ( [ 'CategoryParent', 'xs:string', '1', '', '' ]
	, [ 'CategorySiteID', 'xs:string', '', '', '' ]
	, [ 'LevelLimit', 'xs:int', '', '', '' ]
	, [ 'ViewAllNodes', 'xs:boolean', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCategoryParent()

Specifies the ID of the highest-level category to return,
along with its subcategories.
If no parent category is specified, all categories are
returned for the specified site. (Please do not pass a value of 0; zero (0) is an invalid value for CategoryParent.)
To determine available category IDs, call GetCategories with
no filters and use a DetailLevel value of ReturnAll.
If you specify multiple parent categories, the hierarchy for
each one is returned.

  RequiredInput: No
  Default: 
#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setCategoryParent {
  my $self = shift;
  $self->{'CategoryParent'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getCategoryParent()

#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getCategoryParent {
  my $self = shift;
  return $self->_getDataTypeArray('CategoryParent');
}


=head2 setCategorySiteID()

Specifies the eBay site for which to retrieve the category
hierarchy.
Use the numeric site code (e.g., 77 for eBay Germany).
Only necessary if you want to retrieve category data
for a site other than the site to which you are
submitting the request.

  RequiredInput: No
  Default: The site ID of the request
#    Argument: 'xs:string'

=cut

sub setCategorySiteID {
  my $self = shift;
  $self->{'CategorySiteID'} = shift
}

=head2 getCategorySiteID()

#    Returns: 'xs:string'

=cut

sub getCategorySiteID {
  my $self = shift;
  return $self->{'CategorySiteID'};
}


=head2 setLevelLimit()

Specifies the maximum depth of the category hierarchy to retrieve,
where the top-level categories (meta-categories) are at level 1.
Retrieves all category nodes with a category level less than or
equal to this value.
If not specified, retrieves categories at all applicable levels.
As with all calls, the actual data returned will vary depending
on how you configure other fields in the request
(including DetailLevel).

  RequiredInput: No
  Default: 0
#    Argument: 'xs:int'

=cut

sub setLevelLimit {
  my $self = shift;
  $self->{'LevelLimit'} = shift
}

=head2 getLevelLimit()

#    Returns: 'xs:int'

=cut

sub getLevelLimit {
  my $self = shift;
  return $self->{'LevelLimit'};
}


=head2 setViewAllNodes()

If false or omitted, retrieves only leaf categories.
(You can only list in leaf categories.)
If true, retrieves both leaf and internal (non-leaf) categories.
As with all calls, the actual data returned will vary depending
on how you configure other fields in the request.

  RequiredInput: No
  Default: false
#    Argument: 'xs:boolean'

=cut

sub setViewAllNodes {
  my $self = shift;
  $self->{'ViewAllNodes'} = shift
}

=head2 isViewAllNodes()

#    Returns: 'xs:boolean'

=cut

sub isViewAllNodes {
  my $self = shift;
  return $self->{'ViewAllNodes'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
