/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import net.sf.saxon.event.BuilderMonitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.SameNameTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.linked.ParentNodeImpl;
import net.sf.saxon.type.SimpleType;

public class LinkedBuilderMonitor
extends BuilderMonitor {
    private LinkedTreeBuilder builder;
    private int mark = -1;
    private NodeInfo markedNode;

    public LinkedBuilderMonitor(LinkedTreeBuilder builder) {
        super(builder);
        this.builder = builder;
    }

    public void markNextNode(int nodeKind) {
        this.mark = nodeKind;
    }

    public void markAttributeNode(NodeInfo origin) {
        ParentNodeImpl element = this.builder.getCurrentParentNode();
        this.markedNode = element.iterateAxis((byte)2, new SameNameTest(origin)).next();
        this.mark = -1;
    }

    public void markNamespaceNode(NodeInfo origin) {
        ParentNodeImpl element = this.builder.getCurrentParentNode();
        NamePool pool = this.builder.getConfiguration().getNamePool();
        String prefix = origin.getLocalPart();
        this.markedNode = element.iterateAxis((byte)8, new NameTest(13, "", prefix, pool)).next();
        this.mark = -1;
    }

    public void startDocument(int properties) throws XPathException {
        super.startDocument(properties);
        if (this.mark == 9) {
            this.markedNode = this.builder.getCurrentParentNode();
        }
        this.mark = -1;
    }

    public void startContent() throws XPathException {
        super.startContent();
        if (this.mark == 1) {
            this.markedNode = this.builder.getCurrentParentNode();
        }
        this.mark = -1;
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        super.characters(chars, locationId, properties);
        if (this.mark == 3) {
            this.markedNode = this.builder.getCurrentLeafNode();
        }
        this.mark = -1;
    }

    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        super.comment(chars, locationId, properties);
        if (this.mark == 8) {
            this.markedNode = this.builder.getCurrentLeafNode();
        }
        this.mark = -1;
    }

    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        super.processingInstruction(target, data, locationId, properties);
        if (this.mark == 7) {
            this.markedNode = this.builder.getCurrentLeafNode();
        }
        this.mark = -1;
    }

    public void attribute(NodeName name, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        super.attribute(name, typeCode, value, locationId, properties);
        if (this.mark == 2) {
            ParentNodeImpl element = this.builder.getCurrentParentNode();
            this.markedNode = element.iterateAxis((byte)2, new NameTest(2, name, this.builder.getConfiguration().getNamePool())).next();
            this.mark = -1;
        }
    }

    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        super.namespace(namespaceBindings, properties);
        if (this.mark == 13) {
            for (NamespaceBinding ns : namespaceBindings) {
                ParentNodeImpl element = this.builder.getCurrentParentNode();
                NamePool pool = this.builder.getConfiguration().getNamePool();
                String prefix = ns.getPrefix();
                this.markedNode = element.iterateAxis((byte)8, new NameTest(13, "", prefix, pool)).next();
                this.mark = -1;
            }
        }
    }

    public NodeInfo getMarkedNode() {
        return this.markedNode;
    }
}

