# Generated by default/object.tt
package Paws::CloudWatchEvents::ConnectionHttpParameters;
  use Moose;
  has BodyParameters => (is => 'ro', isa => 'ArrayRef[Paws::CloudWatchEvents::ConnectionBodyParameter]');
  has HeaderParameters => (is => 'ro', isa => 'ArrayRef[Paws::CloudWatchEvents::ConnectionHeaderParameter]');
  has QueryStringParameters => (is => 'ro', isa => 'ArrayRef[Paws::CloudWatchEvents::ConnectionQueryStringParameter]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatchEvents::ConnectionHttpParameters

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatchEvents::ConnectionHttpParameters object:

  $service_obj->Method(Att1 => { BodyParameters => $value, ..., QueryStringParameters => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatchEvents::ConnectionHttpParameters object:

  $result = $service_obj->Method(...);
  $result->Att1->BodyParameters

=head1 DESCRIPTION

Contains additional parameters for the connection.

=head1 ATTRIBUTES


=head2 BodyParameters => ArrayRef[L<Paws::CloudWatchEvents::ConnectionBodyParameter>]

Contains additional body string parameters for the connection.


=head2 HeaderParameters => ArrayRef[L<Paws::CloudWatchEvents::ConnectionHeaderParameter>]

Contains additional header parameters for the connection.


=head2 QueryStringParameters => ArrayRef[L<Paws::CloudWatchEvents::ConnectionQueryStringParameter>]

Contains additional query string parameters for the connection.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatchEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

