# Generated by default/object.tt
package Paws::NimbleStudio::ComputeFarmConfiguration;
  use Moose;
  has ActiveDirectoryUser => (is => 'ro', isa => 'Str', request_name => 'activeDirectoryUser', traits => ['NameInRequest']);
  has Endpoint => (is => 'ro', isa => 'Str', request_name => 'endpoint', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NimbleStudio::ComputeFarmConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NimbleStudio::ComputeFarmConfiguration object:

  $service_obj->Method(Att1 => { ActiveDirectoryUser => $value, ..., Endpoint => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NimbleStudio::ComputeFarmConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->ActiveDirectoryUser

=head1 DESCRIPTION

The configuration for a render farm that is associated with a studio
resource.

=head1 ATTRIBUTES


=head2 ActiveDirectoryUser => Str

The name of an Active Directory user that is used on ComputeFarm worker
instances.


=head2 Endpoint => Str

The endpoint of the ComputeFarm that is accessed by the studio
component resource.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NimbleStudio>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

