use strict;
use warnings;
package IO::Iron::Applications;

# ABSTRACT: Command line tools for Iron.io services.

our $VERSION = '0.12'; # VERSION: generated by DZP::OurPkgVersion



1;

__END__

=pod

=encoding UTF-8

=head1 NAME

IO::Iron::Applications - Command line tools for Iron.io services.

=head1 VERSION

version 0.12

=head1 DESCRIPTION

IO::Iron::Applications is an auxiliary package for L<IO::Iron|IO::Iron>.
IO::Iron contains the library for using the L<Iron.io|http://www.iron.io>
cloud services in Perl programs. IO::Iron::Applications contains
command line programs to operate those services.

The Iron.io WWW interface
L<hud.iron.io Dashboard|https://hud.iron.io/dashboard> is great but
a bit slow to use when you only need to quickly change some values 
in IronCache, send a message to IronMQ, erase or empty cache 
for debugging purposes or other similar activities. With these command
line utilities the same functions can be performed fast from a normal
shell and not using a web browser.

=head2 Policies

The programs take use of the IO::Iron package feature 
L<policies|IO::Iron/"Policies"> so wildcard characters can be used in
cache names, item keys, etc.

For example, if F<iron_cache_policies.json>:

    {
        "definition":{
            "character_group":{
                "[:lim_uchar:]":"ABC",
                "[:low_digit:]":"01"
            }
        },
        "cache":{
            "name":[
                "cache_[:lim_uchar:]{1}0[:digit:]{1}"
            ],
            "item_key":[
                "item.02_[:lim_uchar:]{1,2}[:low_digit:]{1}"
            ]
        }
    }

then

    ironcache list items .* --cache cache_A01 --policies iron_cache_policies.json

would print out:

    Cache                         Item                expires
    cache_A01                     item.02_A0                               Key not exists.
    cache_A01                     item.02_A1                               Key not exists.
    cache_A01                     item.02_AA0                              Key not exists.
    cache_A01                     item.02_AA1                              Key not exists.
    cache_A01                     item.02_AB0                              Key not exists.
    cache_A01                     item.02_AB1                              Key not exists.
    cache_A01                     item.02_AC0                              Key not exists.
    cache_A01                     item.02_AC1                              Key not exists.
    cache_A01                     item.02_B0                               Key not exists.
    cache_A01                     item.02_B1                               Key not exists.
    cache_A01                     item.02_BA0                              Key not exists.
    cache_A01                     item.02_BA1                              Key not exists.
    cache_A01                     item.02_BB0                              Key not exists.
    cache_A01                     item.02_BB1                              Key not exists.
    cache_A01                     item.02_BC0                              Key not exists.
    cache_A01                     item.02_BC1                              Key not exists.
    cache_A01                     item.02_C0                               Key not exists.
    cache_A01                     item.02_C1                               Key not exists.
    cache_A01                     item.02_CA0                              Key not exists.
    cache_A01                     item.02_CA1                              Key not exists.
    cache_A01                     item.02_CB0                              Key not exists.
    cache_A01                     item.02_CB1                              Key not exists.
    cache_A01                     item.02_CC0                              Key not exists.
    cache_A01                     item.02_CC1                              Key not exists.

On the command line, all normal regular expression are allowed. E.g.

    item.02_A.{1}0

would return

    Cache                         Item                expires
    cache_A01                     item.02_AA0                              Key not exists.
    cache_A01                     item.02_AB0                              Key not exists.
    cache_A01                     item.02_AC0                              Key not exists.

N.B. When defining the policies only a subset of regular expressions
is available. Please see L<policies|IO::Iron/"Policies"> for
instructions.

=head2 Following command line programs are available:

=head3 ironcache

=over 8

=item clear: Clear a cache/caches.

=over 8

=item E.g. B<ironcache clear cache_main>

=back

=item delete: Delete item/items from cache/caches.

=over 8

=item E.g. B<ironcache delete item item_01,item_02 --cache cache_name>

=item E.g. B<ironcache delete cache cache_name>

=back

=item get: Get item/items from cache/caches.

=over 8

=item E.g. B<ironcache get item item.02_A.{2} --cache cache_A01 --config iron_cache.json --policies iron_cache_policies_test_01.json --warn>

=back

=item increment: Increment an item/items in cache/caches.

=over 8

=item E.g. B<ironcache increment item item.02_AC1,item.02_BC1 --cache cache_A01 --value 225>

=back

=item list: List caches or items in a cache/caches.

=over 8

=item E.g. B<ironcache list items .* --cache cache_A01>

=item E.g. B<ironcache list caches>

=back

=item put: Put or replace item/items to a cache/caches.

=over 8

=item E.g. B<ironcache put item item.02_CC1,item.02_CC2 --cache cache_A01 --value 123>

=back

=item show: Show the properties of a cache/caches.

=over 8

=item E.g. B<ironcache show cache cache_A01>

=back

=back

=head3 ironmq

TBA

=head3 ironworker

TBA, perhaps.

=head1 REQUIREMENTS

These programs are implemented using IO::Iron libraries. Command line
interface uses L<App::Cmd|App::Cmd> framework.

=head1 AUTHOR

Mikko Koivunalho <mikko.koivunalho AT iki.fi>

=head1 BUGS

Please report any bugs or feature requests to bug-io-iron-applications@rt.cpan.org or through the web interface at:
 http://rt.cpan.org/Public/Dist/Display.html?Name=IO-Iron-Applications

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Mikko Koivunalho.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

The full text of the license can be found in the
F<LICENSE> file included with this distribution.

=cut
