/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.AbstractMediaHeaderBox;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeTimeScaleTrack
implements Track {
    Track source;
    List<CompositionTimeToSample.Entry> ctts;
    List<TimeToSampleBox.Entry> tts;
    long timeScale;

    public ChangeTimeScaleTrack(Track source, long timeScale) {
        this.source = source;
        this.timeScale = timeScale;
        double timeScaleFactor = (double)timeScale / (double)source.getTrackMetaData().getTimescale();
        this.ctts = ChangeTimeScaleTrack.adjustCtts(source.getCompositionTimeEntries(), timeScaleFactor);
        this.tts = ChangeTimeScaleTrack.adjustTts(source.getDecodingTimeEntries(), timeScaleFactor);
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.source.getSampleDescriptionBox();
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return this.tts;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.ctts;
    }

    @Override
    public long[] getSyncSamples() {
        return this.source.getSyncSamples();
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.source.getSampleDependencies();
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        TrackMetaData trackMetaData = (TrackMetaData)this.source.getTrackMetaData().clone();
        trackMetaData.setTimescale(this.timeScale);
        return trackMetaData;
    }

    @Override
    public String getHandler() {
        return this.source.getHandler();
    }

    @Override
    public boolean isEnabled() {
        return this.source.isEnabled();
    }

    @Override
    public boolean isInMovie() {
        return this.source.isInMovie();
    }

    @Override
    public boolean isInPreview() {
        return this.source.isInPreview();
    }

    @Override
    public boolean isInPoster() {
        return this.source.isInPoster();
    }

    @Override
    public List<ByteBuffer> getSamples() {
        return this.source.getSamples();
    }

    static List<CompositionTimeToSample.Entry> adjustCtts(List<CompositionTimeToSample.Entry> source, double timeScaleFactor) {
        if (source != null) {
            ArrayList<CompositionTimeToSample.Entry> entries2 = new ArrayList<CompositionTimeToSample.Entry>(source.size());
            double deviation = 0.0;
            for (CompositionTimeToSample.Entry entry : source) {
                double d = timeScaleFactor * (double)entry.getOffset() + deviation;
                int x = (int)Math.round(d);
                deviation = d - (double)x;
                entries2.add(new CompositionTimeToSample.Entry(entry.getCount(), x));
            }
            return entries2;
        }
        return null;
    }

    static List<TimeToSampleBox.Entry> adjustTts(List<TimeToSampleBox.Entry> source, double timeScaleFactor) {
        double deviation = 0.0;
        ArrayList<TimeToSampleBox.Entry> entries2 = new ArrayList<TimeToSampleBox.Entry>(source.size());
        for (TimeToSampleBox.Entry entry : source) {
            double d = timeScaleFactor * (double)entry.getDelta() + deviation;
            long x = Math.round(d);
            deviation = d - (double)x;
            entries2.add(new TimeToSampleBox.Entry(entry.getCount(), x));
        }
        return entries2;
    }

    @Override
    public AbstractMediaHeaderBox getMediaHeaderBox() {
        return this.source.getMediaHeaderBox();
    }
}

