/*
 * Decompiled with CFR 0.152.
 */
package gma.simr;

import gma.AxisTick;
import gma.MapPoint;
import gma.simr.MappingChain;
import gma.simr.PointDisplacementComparator;
import gma.simr.SearchRectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestSearchRectangle
extends TestCase {
    private PointDisplacementComparator pointDisplacementComparator = new PointDisplacementComparator();
    private SortedSet mapPoints = new TreeSet(this.pointDisplacementComparator);
    private Map xAxisAmbiguityCounter = new HashMap();
    private Map yAxisAmbiguityCounter = new HashMap();
    private Properties properties = new Properties();
    private SearchRectangle searchRectangle = null;
    private List resultMapPoints = new ArrayList(8);
    static /* synthetic */ Class class$gma$simr$TestSearchRectangle;

    public TestSearchRectangle(String name) throws Exception {
        super(name);
    }

    protected void setUp() throws Exception {
        String axisMappings = "322,324 -- 4920.5, 4404.5;318,324 -- 4849.5, 4404.5;309,324 -- 4763.5, 4404.5;313,328 -- 4812.5, 4464.5;322,340 -- 4920.5, 4626.5;302,326 -- 4683.5, 4440.5;311,334 -- 4785.5, 4549.5;312,335 -- 4804, 4568;313,336 -- 4812.5, 4576.5;314,337 -- 4815.5, 4579.5;318,340 -- 4849.5, 4626.5;302,331 -- 4683.5, 4486.5;316,342 -- 4830.5, 4644.5;317,343 -- 4841.5, 4655.5;309,340 -- 4763.5, 4626.5;";
        StringTokenizer st = new StringTokenizer(axisMappings, " ,-;\f\n");
        Integer[] wordlist = new Integer[]{new Integer(101), new Integer(119), new Integer(114), new Integer(100)};
        ArrayList<Integer> word = new ArrayList<Integer>(Arrays.asList(wordlist));
        while (st.hasMoreTokens()) {
            int xIndex = Integer.parseInt(st.nextToken());
            int yIndex = Integer.parseInt(st.nextToken());
            float xPosition = Float.parseFloat(st.nextToken());
            float yPosition = Float.parseFloat(st.nextToken());
            AxisTick xAxisTick = new AxisTick(xIndex, xPosition, word);
            AxisTick yAxisTick = new AxisTick(yIndex, yPosition, word);
            this.updateAmbiguityCounter(this.xAxisAmbiguityCounter, xAxisTick, true);
            this.updateAmbiguityCounter(this.yAxisAmbiguityCounter, yAxisTick, true);
            MapPoint mapPoint = new MapPoint(xAxisTick, yAxisTick);
            mapPoint.computeDisplacement(0.91f);
            this.mapPoints.add(mapPoint);
        }
        String results = "4683.5, 4440.5;4785.5, 4549.5;4804, 4568;4812.5, 4576.5;4815.5, 4579.5;4830.5, 4644.5;4841.5, 4655.5;4849.5, 4626.5;";
        st = new StringTokenizer(results, " ,;\f\n");
        while (st.hasMoreTokens()) {
            float xPosition = Float.parseFloat(st.nextToken());
            float yPosition = Float.parseFloat(st.nextToken());
            AxisTick xAxisTick = new AxisTick(0, xPosition, word);
            AxisTick yAxisTick = new AxisTick(0, yPosition, word);
            MapPoint mapPoint = new MapPoint(xAxisTick, yAxisTick);
            mapPoint.computeDisplacement(0.91f);
            this.resultMapPoints.add(mapPoint);
        }
        this.properties.setProperty("matchingPredicate", "gma.simr.LcsrMatching");
        this.properties.setProperty("slope", "0.91");
        this.properties.setProperty("chainSize", "8");
        this.properties.setProperty("chainPointAmbiguity", "8");
        this.properties.setProperty("lcsrThreshold", "0.71");
        this.properties.setProperty("minimumWordLength", "4");
        this.properties.setProperty("angleDeviation", "0.17");
        this.properties.setProperty("linearRegressionError", "21");
        this.searchRectangle = new SearchRectangle(this.properties);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testFindBestChain() throws Exception {
        SortedSet noiselessMapPoints = this.removeNoise(this.mapPoints);
        List mappingChains = this.generateMappingChains(noiselessMapPoints);
        MappingChain bestChain = this.searchRectangle.findBestChain(mappingChains, noiselessMapPoints);
        boolean b = true;
        for (int index = 0; index < bestChain.getChainSize(); ++index) {
            MapPoint mapPoint = bestChain.getMapPoint(index);
            Iterator iter = this.resultMapPoints.iterator();
            boolean bool = false;
            while (iter.hasNext()) {
                MapPoint result = (MapPoint)iter.next();
                if (!result.equals(mapPoint)) continue;
                bool = true;
                break;
            }
            if (bool) continue;
            b = false;
            break;
        }
        TestSearchRectangle.assertTrue(b);
    }

    private void updateAmbiguityCounter(Map ambiguityCounter, AxisTick axisTick, boolean isIncrement) {
        int counter = this.getAmbiguityCounter(ambiguityCounter, axisTick);
        if (isIncrement) {
            ambiguityCounter.put(axisTick, new Integer(++counter));
        } else if (counter > 0) {
            ambiguityCounter.put(axisTick, new Integer(--counter));
        }
    }

    private int getAmbiguityCounter(Map ambiguityCounter, AxisTick axisTick) {
        if (ambiguityCounter.containsKey(axisTick)) {
            return (Integer)ambiguityCounter.get(axisTick);
        }
        return 0;
    }

    private int getAmbiguityCounters(MapPoint mapPoint) {
        int counter = this.getAmbiguityCounter(this.xAxisAmbiguityCounter, mapPoint.getXAxisTick());
        return (counter += this.getAmbiguityCounter(this.yAxisAmbiguityCounter, mapPoint.getYAxisTick())) - 2;
    }

    private SortedSet removeNoise(Set noiseMapPoints) {
        TreeSet<MapPoint> noiselessMapPoints = new TreeSet<MapPoint>(this.pointDisplacementComparator);
        Iterator iterator = noiseMapPoints.iterator();
        while (iterator.hasNext()) {
            MapPoint mapPoint = (MapPoint)iterator.next();
            if (this.getAmbiguityCounters(mapPoint) > 8) continue;
            noiselessMapPoints.add(mapPoint);
        }
        return noiselessMapPoints;
    }

    private List generateMappingChains(Set noiselessMapPoints) {
        ArrayList<MappingChain> mappingChains = new ArrayList<MappingChain>();
        block0: for (int outerIndex = 1; outerIndex <= noiselessMapPoints.size() - 8 + 1; ++outerIndex) {
            Iterator iterator = noiselessMapPoints.iterator();
            int innerIndex = 0;
            MappingChain mappingChain = new MappingChain(this.properties);
            while (iterator.hasNext()) {
                if (++innerIndex < outerIndex) {
                    iterator.next();
                } else {
                    mappingChain.addMapPoint((MapPoint)iterator.next(), true);
                }
                if (innerIndex < outerIndex + 8 - 1) continue;
                mappingChains.add(mappingChain);
                continue block0;
            }
        }
        return mappingChains;
    }

    public static void main(String[] args) {
        TestSuite mySuite = new TestSuite(class$gma$simr$TestSearchRectangle == null ? (class$gma$simr$TestSearchRectangle = TestSearchRectangle.class$("gma.simr.TestSearchRectangle")) : class$gma$simr$TestSearchRectangle);
        TestRunner.run((Test)mySuite);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

