/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grokkit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import opennlp.common.PipelineException;
import opennlp.common.parse.LexException;
import opennlp.grok.util.Params;
import opennlp.grokkit.gui.Parameters;

public class Run {
    static Properties DEFAULTS = new Properties();
    static Parameters PARAMS = new Parameters(DEFAULTS);

    public static void loadParameters() {
        Run.loadStandard();
    }

    public static void saveParameters() {
        Run.saveStandard();
    }

    public static void loadStandard() {
        String dir = System.getProperties().getProperty("user.home") + "/.grok";
        String file = dir + "/grok";
        try {
            PARAMS.load(new FileInputStream(file));
        }
        catch (Exception E) {
            File grokDir = new File(dir);
            grokDir.mkdir();
        }
    }

    public static void saveStandard() {
        String file = System.getProperties().getProperty("user.home") + "/.grok/grok";
        try {
            PARAMS.store(new FileOutputStream(file), "Standard Paramters for Grok");
        }
        catch (Exception E) {
            System.out.println(E);
        }
    }

    public static void init() throws IOException, LexException, PipelineException {
    }

    public static void process(String input) throws IOException, LexException {
        try {
            if (input.equals("q")) {
                System.exit(0);
            } else if (!input.equals("n")) {
                System.out.println("Parsing `" + input + "'...");
            }
            System.out.println("Syntactic Category");
            System.out.println("------------------");
            System.out.println();
            if (Params.getBoolean("Parsing:Semantics")) {
                System.out.println("Semantic Category");
                System.out.println("-----------------");
                System.out.println();
                String presups = "";
                if (!presups.equals("")) {
                    System.out.println("Presuppositions");
                    System.out.println("---------------");
                    System.out.println(presups);
                    System.out.println();
                }
                if (Params.getBoolean("Use Brain")) {
                    System.out.println("Discourse");
                    System.out.println("---------");
                    System.out.println();
                }
            }
        }
        catch (Exception pe) {
            System.out.println(pe);
        }
    }

    public static void main(String[] args) throws IOException, LexException, PipelineException {
        Run.loadParameters();
        Run.init();
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader br = new BufferedReader(isr);
        while (true) {
            System.out.print("grok> ");
            String input = br.readLine();
            Run.process(input);
        }
    }
}

