#!/usr/bin/perl

package eBay::API::XML::Call::GetAllBidders::GetAllBiddersResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetAllBiddersResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetAllBidders::GetAllBiddersResponseType

=head1 DESCRIPTION

Includes the list of bidders for the requested item as part of the general item listing data. Some bidder information is anonymous, to protect bidders from fraud. If the seller makes this API call, the actual ids of all bidders on the seller's item will be returned. If a bidder makes this API call, the bidder's actual id will be returned. Information for all competing bidders or outside watchers will be returned as anonymized userIDs. See See <a href="http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AnonymousUserInfo">Working with Anonymous User Information</a>in the eBay Web Services Guide for more information.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetAllBidders::GetAllBiddersResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::OfferArrayType;
use eBay::API::XML::DataType::UserIDType;
use eBay::API::XML::DataType::Enum::ListingStatusCodeType;


my @gaProperties = ( [ 'BidArray', 'ns:OfferArrayType', ''
	     ,'eBay::API::XML::DataType::OfferArrayType', '1' ]
	, [ 'HighBidder', 'ns:UserIDType', ''
	     ,'eBay::API::XML::DataType::UserIDType', '1' ]
	, [ 'HighestBid', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'ListingStatus', 'ns:ListingStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ListingStatusCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBidArray()

Contains a list of OfferType objects. Each
OfferType object represents the data for one bidder and bid.

#    Argument: 'ns:OfferArrayType'

=cut

sub setBidArray {
  my $self = shift;
  $self->{'BidArray'} = shift
}

=head2 getBidArray()

  Returned: Always
#    Returns: 'ns:OfferArrayType'

=cut

sub getBidArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BidArray'
		,'eBay::API::XML::DataType::OfferArrayType');
}


=head2 setHighBidder()

eBay user ID for the user with the highest bid (or the earliest timestamp, in the event of a tie); a second chance offer candidate.

#    Argument: 'ns:UserIDType'

=cut

sub setHighBidder {
  my $self = shift;
  $self->{'HighBidder'} = shift
}

=head2 getHighBidder()

  Returned: Always
#    Returns: 'ns:UserIDType'

=cut

sub getHighBidder {
  my $self = shift;
  return $self->_getDataTypeInstance( 'HighBidder'
		,'eBay::API::XML::DataType::UserIDType');
}


=head2 setHighestBid()

Bid amount offered by the HighBidder.

#    Argument: 'ns:AmountType'

=cut

sub setHighestBid {
  my $self = shift;
  $self->{'HighestBid'} = shift
}

=head2 getHighestBid()

  Returned: Always
#    Returns: 'ns:AmountType'

=cut

sub getHighestBid {
  my $self = shift;
  return $self->_getDataTypeInstance( 'HighestBid'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setListingStatus()

Specifies an active or ended listing's status in eBay's processing workflow.
If a listing ends with a sale (or sales), eBay needs to update the sale details (e.g., winning bidder) and other information. This processing
can take several minutes. If you retrieve a sold item, use this listing status information to determine whether eBay has finished processing the listing so that you can be sure the winning bidder and other details are correct and complete.

#    Argument: 'ns:ListingStatusCodeType'

=cut

sub setListingStatus {
  my $self = shift;
  $self->{'ListingStatus'} = shift
}

=head2 getListingStatus()

  Returned: Always
#    Returns: 'ns:ListingStatusCodeType'

=cut

sub getListingStatus {
  my $self = shift;
  return $self->{'ListingStatus'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
