
###########################################################################
# Copyright (c) Nate Wiger http://nateware.com. All Rights Reserved.
# Please visit http://formbuilder.org for tutorials, support, and examples.
###########################################################################

package CGI::FormBuilder::Messages::locale;

use strict;
use utf8;

our $REVISION = do { (my $r='$Revision: 100 $') =~ s/\D+//g; $r };
our $VERSION = '3.06';

# First, create a hash of messages for this language

our %MESSAGES = (
    lang                  => 'es_ES',
    charset               => 'utf-8',

    js_invalid_start      => '%s error(es) fueron encontrados en su formulario:',
    js_invalid_end        => 'Por favor corrija en el/los campo(s) e intente de nuevo\n', 
    js_invalid_input      => 'Introduzca un valor vlido para el campo: "%s"',
    js_invalid_select     => 'Escoja una opcin de la lista: "%s"', 
    js_invalid_multiple   => '- Escoja una o ms opciones de la lista: "%s"',
    js_invalid_checkbox   => '- Revise una o ms de las opciones: "%s"',
    js_invalid_radio      => '- Escoja una de las opciones de la lista: "%s"',
    js_invalid_password   => '- Valor incorrecto para el campo: "%s"',
    js_invalid_textarea   => '- Por favor, rellene el campo: "%s"',
    js_invalid_file       => '- El nombre del documento es invlido para el campo: "%s"',
    js_invalid_default    => 'Introduzca un valor vlido para el campo: "%s"',

    js_noscript           => 'Por favor habilite Javascript en su navegador o use una versin ms reciente',

    form_required_text    => 'Los campos %sresaltados%s son obligatorios',
    form_invalid_text     => 'Se encontraron %s error(es) al realizar su pedido. Por favor corrija los valores en los campos %sresaltados%s y vuelva a intentarlo.',

    form_invalid_input    => 'Valor invlido',
    form_invalid_hidden   => 'Valor invlido',
    form_invalid_select   => 'Escoja una opcin de la lista',
    form_invalid_checkbox => 'Escoja una o ms opciones',
    form_invalid_radio    => 'Escoja una opcin',
    form_invalid_password => 'Valor incorrecto',
    form_invalid_textarea => 'Por favor, rellene el campo',
    form_invalid_file     => 'Nombre del documento invlido',
    form_invalid_default  => 'Valor invlido',

    form_grow_default     => 'Ms %s',
    form_select_default   => '-Seleccione-',
    form_other_default    => 'Otro:',
    form_submit_default   => 'Enviar',
    form_reset_default    => 'Borrar',
    form_confirm_text     => 'Lo logr! El sistema ha recibido sus datos! %s.',

    mail_confirm_subject  => '%s Confirmacin de su pedido.',
    mail_confirm_text     => 'El sistema ha recibido sus datos! %s., Si desea hacer alguna pregunta, por favor responda a ste correo electrnico.',
    mail_results_subject  => '%s Resultado de su pedido.'
    );

# This method should remain unchanged
sub messages {
    return wantarray ? %MESSAGES : \%MESSAGES;
}

1;
__END__

