/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.BucketConfiguration;
import org.couchbase.mock.CouchbaseMock;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class MemcachedBucket
extends Bucket {
    public MemcachedBucket(CouchbaseMock cluster, BucketConfiguration config) throws IOException {
        super(cluster, config);
    }

    @Override
    public Map<String, Object> getConfigMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("authType", "sasl");
        map.put("bucketType", "memcached");
        map.put("flushCacheUri", "/pools/default/buckets/" + this.name + "/controller/doFlush");
        map.put("nodeLocator", "ketama");
        map.put("proxyPort", 0);
        map.put("replicaNumber", 0);
        map.put("saslPassword", this.getPassword());
        map.put("streamingUri", "/pools/default/bucketsStreaming/" + this.name);
        map.put("uri", "/pools/default/buckets/" + this.name);
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        for (MemcachedServer server : this.activeServers()) {
            nodes.add(server.toNodeConfigInfo());
        }
        map.put("nodes", nodes);
        return map;
    }

    @Override
    public Bucket.BucketType getType() {
        return Bucket.BucketType.MEMCACHED;
    }

    @Override
    public ErrorCode storeItem(String key, byte[] value) {
        throw new UnsupportedOperationException("Storing items not yet supported for memcached buckets!");
    }
}

