package Location::Area::DoCoMo::iArea::Area;

use strict;
require Location::Area::DoCoMo::iArea::Aura; 

sub seek
{
  shift;
  my $arg = shift;
  my $useAdjustedAura = shift;
  seek DATA,0,0;
  my ($aid,$said,$name,$wara,$sara,$eara,$nara,$mesh,$meshcache);
  if ($arg =~ /^\d{5}$/)
  {
    ($aid,$said) = $arg =~ /^(\d{3})(\d{2})$/;
    while (my $line = <DATA>)
    {
      my @scan = $line =~ /^$aid,$said,([^,]+),(\d{8,9}),(\d{8,9}),(\d{8,9}),(\d{8,9}),(.*)$/;
      if (@scan)
      {
        ($name,$wara,$sara,$eara,$nara,$meshcache) = @scan;
        last;
      }
    }
  }
  else
  {
    my ($m2,$m3,$m4,$m5,$m6,$m7) = $arg =~ /^(\d{6})(\d?)(\d?)(\d?)(\d?)(\d?)$/;
    while (my $line = <DATA>)
    {
      my @scan = $line =~ /^(\d{3}),(\d{2}),([^,]+),(\d{8,9}),(\d{8,9}),(\d{8,9}),(\d{8,9}),(.*,(${m2}(${m3}(${m4}(${m5}(${m6}${m7}?)?)?)?)?),.*)$/;
      if (@scan)
      {
        ($aid,$said,$name,$wara,$sara,$eara,$nara,$meshcache,$mesh) = @scan;
        last;
      }
    }
  }
  ($wara,$sara,$eara,$nara) =  Location::Area::DoCoMo::iArea::Aura->seek($aid,$said) if ($useAdjustedAura);
  return {
    areaid => $aid,
    sub_areaid => $said,
    name => $name,
    west => $wara,
    south => $sara,
    east => $eara,
    north => $nara,
    meshcache => $meshcache,
  };
}

1;
__DATA__
001,00,ȡ/,501412500,148725000,508500000,153450000,46,61,62,0,0,0,624010,624011,624020,624021,624022,624023,624032,624033,624043,624053,624054,624055,624056,624057,624064,624065,624066,624067,624074,624075,624076,624160,634003,634004,634005,634012,634013,634021,634031,634052,634062,634022,634014,634015,624150,624151,634042,634063,624044,634023,634032,634006,624077,624140,624047,624012,6240300,6240311,6240421,6240423,6240521,6240631,6240633,6240731,6240733,6241610,6340022,6340023,6340111,6340112,6340113,6340202,6340203,6340300,6340301,6340303,6340410,6340411,6340511,6340513,6340642,6340711,6340720,6340721,6340532,6340070,6240463,6240462,6240453,6240013,6240012,6240003,6239173,6239271,6239273,6239371,6239221,6239123,6239230,6239132,6340530,6340533,6340432,6340240,6340330,6340160,6241612,6241700,6241412,6240022,6240002,6239061,6240452,6239171,6239072,6239063,6239060,62404502,62416110,62416112,63406403,63406402,63400710,62417010,62417011,62416130,62403422,62403423,62401322,62401323,62401320,62401332,62400103,62400112,62400113,62400102,62391223,62391221,62392201,62392203,63400720,63400722,62414102,62414132,62404613,62404612,63401620,63401621,63401622,63401610,63401611,63401612,62400232,62400202,62393703,62393701,62392723,62392703,62392721,62392701,62391723,62400013,62400012,62390733,62391703,62391721,62390621,61397623,61397632,62390700,61397633,62390702,62391701,62390620,61397622,62390511,62390531,62390513,62390623,
001,01,/ɰ,501637500,149700000,505575000,153450000,24,59,50,0,0,0,624040,624041,624051,624061,624062,624071,624072,633927,633936,633937,633947,633957,633967,634001,634010,634040,634050,634061,633917,633923,633913,633946,633966,633924,6240301,6240302,6240303,6240310,6240312,6240313,6240420,6240422,6240501,6240503,6240520,6240522,6240523,6240630,6240632,6240730,6240732,6339033,6339042,6339140,6339142,6339262,6339263,6339561,6339563,6339761,6339770,6340001,6340003,6340020,6340021,6340110,6340200,6340201,6340302,6340412,6340413,6340510,6340512,6340600,6340601,6340710,6239373,6239471,6240500,6240601,6240603,6240701,6240703,6340002,6339261,6339032,6339760,6339250,6339252,6339350,6339351,6339253,6339143,62394731,62394733,62405021,62405023,62406001,62405020,62395711,62394730,63400003,63400001,62407023,63390733,63391631,63391633,63392603,63392601,63391613,63391632,63392602,63393531,63393533,63394511,63394513,63394531,63395601,63400002,63391412,63391410,63390313,63390312,63390303,63390302,63390402,63393410,63393401,63393411,63393400,63393311,63393310,63391233,63392211,63392213,63392231,63391231,63391213,63395603,63395621,63395623,63395600,63395622,
002,01,î/,503212500,153150000,508500000,156300000,42,58,46,8,13,85,634070,634073,644001,644002,644003,644006,644011,644012,644013,644014,644015,644016,644017,644023,644024,644025,644026,644027,644034,644035,644036,644037,644044,644045,644046,644047,644054,644055,644056,644057,644063,644064,644065,644066,644067,644073,644074,644150,644161,644160,644000,644053,6339763,6339771,6339772,6339773,6340602,6340603,6340712,6340713,6340722,6340723,6340740,6340742,6439061,6439070,6439071,6440040,6440042,6440043,6440052,6440053,6440071,6440072,6440073,6440101,6440221,6440330,6440331,6440333,6440433,6440523,6440621,6440623,6440721,6440723,6440750,6441002,6441100,6441102,6441200,6441201,6441202,6441300,6441402,6441512,6540031,6540040,6440223,6440220,6440211,6440431,6440720,6440622,6540030,6540021,6540033,6440752,6540041,6440751,64405212,64405213,64415100,64415102,64390730,64390731,64390721,64390720,64401001,64401000,64402223,64402221,64402101,64402103,64401031,64401033,63397621,63397623,64403211,64403213,64403321,64403323,64403320,64404323,64404322,64404303,64404321,64406201,64406203,64407221,64407223,65400420,65400421,65400422,65400321,65400430,65400500,64407600,64407530,64407601,64407701,64407710,64407711,64417000,64417001,64407700,644151333,644151320,644151322,644151323,644151012,644151030,644151032,644151033,6441513022,6441513000,6441513212,6441513320,6441513322,6441513323,6441511222,6441510132,6441510100,6441510102,6441510310,6441510312,6441510313,64405201333,64405203111,64405203113,64405203131,64405203133,64405203311,64405203313,64405203331,64405203333,64405210222,64405210223,64405210232,64405210233,64405210322,64405210323,64405210332,64405210333,64405211222,64405211223,64405211232,64405211233,64405211322,64405211323,64405211332,64405211333,64405221111,64405221113,64405221131,64405221133,64405221311,64405221313,64405221331,64405221333,64405223111,64405223113,64405223131,64405223133,64405223311,64405223313,64405223331,64405223333,65400201111,65400201113,65400201131,65400201133,65400201311,65400201313,65400201331,65400201333,65400203111,64415130010,64415130020,64415130022,64415130200,64415130202,64415130203,64415130230,64415130232,64415130233,64415132100,64415132102,64415132103,64415132130,64415132132,64415132133,64415133211,64415133212,64415133213,64415133121,64415133122,64415133123,64415133130,64415133132,64415133133,64415112232,64415101300,64415101302,64415101303,64415103110,64415103112,64415103113,64415101030,64415101032,64415101033,64415112202,
002,02,Ѿ/,506025000,152100000,512325000,154650000,32,51,40,0,0,0,634047,634057,634066,634067,634075,634076,634077,634140,634150,634151,634160,634161,634162,634170,634171,634172,634173,634174,634175,634176,634177,634270,644104,644105,644106,644107,644116,644117,644200,644210,644211,644221,6340372,6340373,6340561,6340562,6340563,6340643,6340652,6340653,6340741,6340743,6341302,6341412,6341522,6341632,6341672,6341673,6342602,6440041,6440050,6440051,6440070,6441000,6441001,6441003,6441010,6441012,6441020,6441030,6441031,6441033,6441101,6441103,6441110,6441261,6441263,6441270,6441272,6442010,6442012,6442013,6442120,6442122,6442201,6442220,6442222,6442310,6442311,6442320,6341663,6341633,6341630,63416623,63416622,63416533,63416432,63416423,63416422,63416420,63416312,63415232,63415233,63415202,63415203,63415230,63414133,63414132,63415200,63414102,63413030,63413032,63413033,63413003,63413002,63403713,63403712,63403703,63403711,63413000,63404633,63404631,63404613,63404632,63405603,63406513,63406511,63405533,63406512,63404611,63406412,63406413,63413031,
002,03,丫/,509400000,154200000,512550000,160050000,49,80,0,0,0,0,644136,644137,644145,644146,644147,644156,644157,644166,644167,644176,644177,644230,644240,644241,644250,644251,644260,644261,644270,644271,654105,654106,654107,654116,654117,654125,654126,654127,654135,654136,654137,654145,654146,654147,654157,654167,654200,654201,654210,654211,654212,654220,654221,654230,654240,654250,654260,654270,664241,6441271,6441273,6441351,6441352,6441353,6441441,6441551,6441552,6441553,6441650,6441651,6441653,6441751,6441752,6441753,6442200,6442202,6442203,6442312,6442313,6442322,6442420,6442622,6442720,6442722,6541151,6541153,6541341,6541342,6541343,6541440,6541441,6541551,6541560,6541561,6541563,6541770,6541771,6541773,6542020,6542022,6542023,6542220,6542222,6542310,6542311,6542312,6542320,6542410,6542412,6542510,6542512,6542610,6542710,6542712,6542713,6642001,6642003,6642010,6642012,6642101,6642103,6642110,6642112,6642201,6642203,6642210,6642212,6642301,6642303,6642310,6642312,6642313,6642322,6642401,6642403,6642420,6642501,6642510,6642511,
002,04,/,510750000,150750000,516262500,154800000,49,38,43,0,0,3,634217,634225,634226,634227,634234,634235,634236,634237,634242,634243,634244,634245,634246,634247,634251,634252,634253,634254,634255,634256,634261,634262,634263,634264,634265,634271,634272,634273,634274,634275,634301,634310,634311,634312,634320,644202,644203,644204,644205,644213,644214,644215,644223,644224,644225,644235,634302,624371,634233,6243720,6243722,6341671,6342073,6342162,6342163,6342242,6342243,6342323,6342413,6342502,6342503,6342600,6342601,6342603,6342660,6342661,6342662,6342760,6343001,6343002,6343003,6343210,6343212,6343300,6343301,6343302,6442011,6442121,6442123,6442221,6442341,6342161,6342153,6342241,6342501,6341573,6341670,63431322,63431320,62437232,62436133,62436222,62436132,62436123,62437013,62437031,62437033,62437032,63430002,63430003,63420713,63420723,63430001,62436131,62436220,62436223,62437230,63421603,63421602,63421523,63421522,63422403,63422333,63422331,63422332,63422323,63423213,63423221,63423223,63423222,63424111,63424113,63424112,63423212,63424123,63424121,63424122,63425003,63425002,63415723,63415713331,63415713333,63423133333,
002,05,̹//,508275000,153600000,510525000,154950000,7,15,5,18,22,20,644112,644113,644114,644115,644125,644124,644134,6441011,6441022,6441021,6441013,6441032,6441260,6441262,6441350,6441111,6441233,6441023,6441231,6441230,6441221,6441220,64411131,64414403,64414401,64413311,64413313,644123211,644123210,644123201,644123200,644144001,644144003,644144021,644144023,644144000,644133333,644133331,644133313,644133311,644133310,644133103,644133101,644123231,644123213,6441431133,6441232330,6441440223,6441440221,6441440021,6441440020,6441431131,6441431113,6441431111,6441431110,6441333123,6441333121,6441331233,6441331231,6441331213,6441331211,6441331021,6441331003,6441331001,6441331000,6441232333,6441232331,64414402032,64414400231,64414311123,64413333231,64413333031,64413333013,64413333011,64413333010,64413331203,64413331201,64413331200,64414402033,64414400230,64414400221,64414400220,64414400233,64414402011,64414402013,64414402031,64414311121,
002,06,ڱؼ,508837500,155006250,508907812,155043750,0,0,0,0,2,7,6441423300,6441423301,64414233100,64414231322,64414231233,64414231223,64414231232,64414231222,64414231220,
002,07,̸,508809375,154987500,508907812,155015625,0,0,0,0,2,7,6441423031,6441423120,64414231302,64414231213,64414231212,64414231320,64414231230,64414231231,64414231221,
002,08,,508865625,154978125,508907812,154996875,0,0,0,0,0,6,64414231300,64414231211,64414231210,64414231032,64414231033,64414231122,
002,09,,508865625,154931250,508921875,154978125,0,0,0,0,1,10,6441423101,64414231103,64414231102,64414231100,64414213322,64414213320,64414231030,64414231031,64414231120,64414231121,64414213233,
002,10,/߻/,508654687,154893750,508837500,155090625,0,0,0,4,18,21,644142302,644142211,644142300,644142122,6441423030,6441423032,6441423210,6441423201,6441422131,6441423012,6441423010,6441420332,6441420333,6441421232,6441421230,6441420331,6441421212,6441423212,6441423230,6441421203,6441423211,6441423033,64414221331,64414221333,64414221330,64414232031,64414232033,64414221303,64414221301,64414221033,64414221300,64414221031,64414221013,64414221011,64414203233,64414203231,64414203303,64414203301,64414221211,64414232130,64414232211,64414232213,64414232320,
002,11,,508893750,154978125,509020312,155043750,0,0,0,0,2,17,6441423311,6441432200,64414231303,64414231312,64414231330,64414231321,64414231323,64414233101,64414233102,64414233103,64414231332,64414231333,64414320222,64414322010,64414322012,64414322013,64414322102,64414231301,64414231123,
002,12,ɡ/,508753125,154800000,508893750,154987500,0,0,0,0,23,15,6441423013,6441423102,6441423011,6441423100,6441421233,6441421322,6441421321,6441421320,6441421231,6441421303,6441421302,6441421213,6441421300,6441421120,6441421102,6441421122,6441421211,6441421033,6441421031,6441421201,6441421210,6441421032,6441421023,64414213012,64414213010,64414211232,64414211230,64414211212,64414211210,64414211032,64414211002,64414211000,64414210113,64414210131,64414210133,64414213232,64414213230,64414213231,
002,13,24/,508725000,155043750,508893750,155156250,0,0,0,0,12,25,6441423303,6441423302,6441423320,6441423322,6441521100,6441521011,6441521012,6441521013,6441521102,6441521021,6441423231,6441423233,64414233212,64414233210,64414233230,64414233232,64415210101,64415210103,64415210102,64415210031,64415210033,64415211200,64415211201,64415210310,64415210311,64415210300,64415210301,64415210032,64415210201,64415210203,64415210202,64415210302,64414232321,64414232323,64414232131,64414232132,64414232133,
002,14,/ƻ,508584375,155146875,509189062,155475000,0,0,4,11,26,84,64415212,64415322,64415231,64415323,644152033,644152300,644152301,644152303,644152331,644152333,644152330,644153202,644153203,644153200,644152211,6441521033,6441521023,6441521022,6441520313,6441520311,6441520312,6441523321,6441520321,6441523020,6441523021,6441523023,6441521032,6441532122,6441630031,6441630010,6441621110,6441621111,6441521322,6441532012,6441532120,6441532123,6441522101,6441520323,6441520322,6441522100,6441522011,64415210312,64415210313,64415211202,64415211203,64415211220,64415211222,64415213000,64415213002,64415213020,64415213022,64415221310,64415221311,64415221313,64415230220,64415230221,64415232110,64415232111,64415232113,64415213202,64415213200,64415210303,64415321322,64415332022,64415332200,64416301100,64416301101,64416301011,64416301010,64416301000,64416301001,64416300111,64416300110,64416300112,64416300130,64416300132,64416300133,64416301202,64416301220,64416301221,64416301203,64416301222,64416300331,64416300123,64416300121,64416300011,64416300010,64416300001,64416300000,64415233233,64415233231,64415233230,64416211130,64416211121,64416211120,64416211011,64415213232,64415213233,64415213322,64415213323,64415320102,64415320103,64415320130,64415320132,64415320133,64415321022,64415321210,64415321212,64415321323,64415321332,64415321330,64415321333,64415201333,64415201331,64415201332,64415203101,64415203103,64415203033,64415221301,64415221033,64415221031,64415221030,64415221021,64415203203,64415202333,
002,15,,508851562,155043750,509259375,155371875,0,0,3,14,34,55,64415300,64415302,64415303,644152131,644153302,644153122,644153300,644153211,644153120,644152113,644152111,644143223,644143222,644142333,644153010,644153012,644153013,6441521321,6441521303,6441521301,6441521123,6441532011,6441521330,6441521331,6441521333,6441432202,6441432203,6441423312,6441423313,6441432213,6441432212,6441432322,6441432323,6441530110,6441530112,6441530113,6441531022,6441531020,6441533010,6441531232,6441532131,6441532100,6441532101,6441532103,6441521121,6441521103,6441521101,6441533200,6441533201,6441533203,6441532130,64414323202,64414323200,64414323203,64414323322,64415301112,64415301113,64415310020,64415310022,64415310232,64415310230,64415310023,64415310233,64415312120,64415312122,64415312300,64415312302,64415330120,64415330122,64415330300,64415330302,64415330320,64415330121,64415330322,64415332201,64415332210,64415321331,64415321020,64415321021,64415321023,64415320131,64415320100,64415320101,64415213203,64415213201,64415213023,64415213021,64415213003,64415213001,64415211223,64415211221,64414233211,64414233213,64414233231,64414233233,64415332020,64415332021,64415332023,64415213230,64415213231,64415213320,64415213321,64415321211,64415321213,64415321320,64415321321,
002,16,׻/Ȭ,508626562,154996875,508795312,155165625,0,0,0,1,16,25,644142231,6441423202,6441423200,6441422331,6441422132,6441422301,6441422123,6441423220,6441422333,6441520113,6441520111,6441423222,6441521000,6441521002,6441521001,6441520131,6441423223,64414221332,64414232030,64414232032,64414223301,64414223303,64414223300,64414223031,64414223033,64414223030,64414221221,64414221223,64414223001,64414223003,64414221203,64414221212,64414221213,64414221302,64415210100,64415201123,64415201330,64415210200,64415210030,64414232210,64414232212,64414232322,
002,17,/ܤ/,508190625,154856250,508696875,155371875,0,1,7,20,46,55,6441413,64414222,64414220,64415200,64415131,64415110,64415111,64415113,644141130,644141123,644141132,644141133,644152010,644142232,644152012,644152200,644152022,644152020,644152202,644141233,644152021,644151301,644151303,644151330,644151120,644151121,644151123,644151011,6441412311,6441412133,6441412131,6441411223,6441411033,6441411211,6441411212,6441411122,6441411123,6441411310,6441411313,6441420222,6441411312,6441411213,6441422100,6441422102,6441422302,6441520301,6441520132,6441520130,6441520110,6441422332,6441412313,6441412312,6441412303,6441412321,6441412323,6441522200,6441522030,6441522013,6441522012,6441522010,6441520232,6441520230,6441520231,6441520302,6441520300,6441513021,6441513003,6441513211,6441513311,6441513310,6441511221,6441510133,6441510131,6441510101,64415203032,64415203031,64415203102,64415203100,64415201121,64415201120,64415201122,64414223302,64414223032,64414223002,64414223000,64414221222,64414221220,64414221202,64414221200,64414221201,64414221210,64414221032,64414221030,64414221012,64414221010,64414203232,64415203030,64415203201,64415203202,64415202331,64415202332,64415221020,64415222020,64415222010,64415220320,64415220310,64415203200,64415202330,64415130013,64415130012,64415130011,64415130021,64415130023,64415130201,64415130231,64415132101,64415132131,64415133210,64415133120,64415133131,64415112230,64415112231,64415112233,64415101301,64415103111,64415101031,64415112200,64415112201,64415112203,
002,18,ʿ//,508879687,154556250,509062500,154968750,0,0,0,10,18,47,644142131,644142113,644143000,644143002,644133020,644133022,644133200,644133202,644133220,644133222,6441423111,6441421333,6441421330,6441421331,6441430202,6441430200,6441421113,6441323313,6441323331,6441323333,6441421111,6441330022,6441330023,6441332010,6441332012,6441332013,6441332030,6441430220,64414320000,64414302222,64414231101,64414213323,64414213321,64414302220,64414302032,64414302030,64414302221,64414302212,64414302210,64414213013,64414302012,64414302010,64414213011,64414211233,64414211231,64414211213,64414211211,64414211123,64414211121,64413233113,64414300322,64414300320,64414300302,64414300300,64414300122,64414300120,64413231313,64413231331,64413231333,64413233111,64413231311,64413231133,64413231131,64413231113,64413231111,64413213333,64413213331,64413213313,64413213311,64413213133,64413213131,64413213113,64413213111,64413211333,64413211331,
002,19,˭ʿ//,508921875,154387500,509343750,154996875,0,0,7,14,43,56,64413301,64413303,64413330,64413332,64413323,64414301,64413321,644133023,644133021,644133003,644123212,644123230,644123232,644133120,644133122,644133221,644133223,644143100,644143101,644143030,644143021,6441423113,6441430223,6441430230,6441430231,6441232033,6441232211,6441232213,6441232231,6441232233,6441330011,6441330013,6441332011,6441232031,6441232332,6441331002,6441331020,6441331023,6441331210,6441331212,6441331230,6441331232,6441333122,6441333300,6441333302,6441333321,6441333320,6441332031,6441331022,6441332033,6441430011,6441430013,6441430031,6441430033,6441431020,6441431021,6441431022,6441430310,6441431030,6441333322,6441332032,6441430010,6441431100,6441431101,64414231310,64414231311,64414320022,64414320020,64414320002,64414320021,64414320003,64414320001,64414302223,64414320012,64414320010,64414320011,64414302213,64414302211,64414302033,64414302031,64414302013,64414302011,64414302322,64414302321,64414303200,64414302330,64414303201,64414303120,64414303110,64414303202,64414302320,64414300323,64414300321,64414300303,64414300301,64414300123,64414300121,64414310232,64414312000,64414303111,64414303112,64414310231,64414310312,64414310330,64414310321,64414310311,64414311022,64414311021,64414311030,64413333233,64413333230,64413333232,64413333033,64413333032,64413333030,64413333012,64413331202,64414310310,64414311020,64414310230,
002,20,,508935937,154875000,509315625,155156250,0,0,1,10,23,59,64414321,644143300,644143033,644143122,644143320,644143231,644143230,644143322,644143203,644143201,644143302,6441432020,6441432023,6441432021,6441432003,6441431230,6441531001,6441531010,6441531011,6441531013,6441531003,6441531000,6441432333,6441432331,6441432330,6441432321,6441433232,6441433230,6441432211,6441430322,6441430321,6441430313,6441431202,6441430323,64414231331,64414231313,64414320220,64414320223,64414320221,64414320023,64414322011,64414320013,64414322100,64414322103,64414322101,64414302323,64414302332,64414323201,64415311023,64415311022,64415310311,64415310121,64415310122,64415310211,64415310212,64415310210,64415310021,64415301111,64415301110,64414323323,64414323321,64414323320,64415311020,64415311002,64414332333,64414332330,64414332312,64414332123,64414332120,64414332102,64414330100,64414330102,64414312322,64414312321,64414312033,64414312030,64414312012,64414312010,64414312001,64414312003,64414312002,64414303113,64414303121,64414303123,64414303122,64414303203,64414302331,64414302333,64414312032,64414312320,64414332122,64414332332,64415310120,
002,21,,509217187,154818750,509442187,155128125,0,0,1,6,20,48,64414313,644143303,644143312,644143310,644143311,644143112,644143121,6441433322,6441433320,6441440222,6441440220,6441442000,6441433131,6441433213,6441433302,6441433211,6441433013,6441433011,6441431233,6441431231,6441433012,6441433130,6441433300,6441440200,6441440202,6441431132,6441431130,64415311021,64415311030,64415311012,64415311003,64415311001,64415311010,64415311000,64414332331,64414332313,64414332311,64414332310,64414333010,64414331320,64414420021,64414420020,64414420022,64414420200,64414420202,64414402030,64414402012,64414402010,64414400232,64414400223,64414400222,64414311122,64414311120,64414311031,64414311033,64414311032,64414311023,64414310313,64414310331,64414310333,64414310332,64414310323,64414310322,64414310320,64414310233,64414312011,64414312013,64414312031,64414312323,64414330101,64414330103,64414332100,64414332101,64414332103,64414332121,
002,22,/׷,507600000,154050000,509034375,155100000,2,13,11,29,59,35,644121,644131,6441112,6441203,6441301,6441303,6441401,6441302,6441400,6441403,6441410,6441320,6441222,6441223,6441322,64411133,64411130,64411132,64414120,64414122,64413210,64413212,64413230,64413232,64414200,64414201,644123202,644141211,644141210,644141212,644123220,644123222,644133000,644132111,644132110,644132112,644132130,644132132,644132310,644132312,644132330,644132332,644142100,644141101,644141100,644141110,644141102,644141120,644142023,644142021,644142020,644142030,644141113,644141111,644142031,6441323332,6441421110,6441323330,6441323312,6441323310,6441323132,6441323130,6441323112,6441323110,6441321332,6441321330,6441321312,6441321310,6441321132,6441321130,6441321131,6441330020,6441330021,6441330012,6441330010,6441232232,6441232230,6441232212,6441232210,6441232032,6441232030,6441412322,6441412320,6441412302,6441412300,6441412301,6441412310,6441412132,6441412130,6441411222,6441411220,6441411221,6441411210,6441411032,6441411030,6441411031,6441411120,6441411121,6441421030,6441421012,6441421010,6441421101,6441411311,6441420220,6441420221,6441420223,6441420320,6441420321,6441420322,6441421202,6441421200,6441421020,6441421021,6441421022,64414211033,64414211122,64414211120,64414211030,64414211031,64414211003,64414210111,64414210110,64414210112,64414210130,64414210132,64414211001,64413233112,64413233110,64413231332,64413231312,64413231310,64413231330,64413231132,64413231130,64413231110,64413231112,64413213332,64413213330,64413213312,64413213310,64413213132,64413213130,64413213112,64413213110,64413211332,64413211330,64414203300,64414203302,64414203230,
002,23,/м,508500000,154950000,510075000,157350000,11,22,29,20,46,85,644154,644164,644173,644174,654103,654104,654113,654114,654123,654124,654133,6441443,6441550,6441652,6441721,6441750,6541150,6541152,6541340,6541421,6541430,6541431,6441631,6441632,6441633,6441620,6441622,6441623,6541123,6541221,6541321,6541323,6541223,64415223,64415331,64415333,64415313,64416302,64416303,64416210,64416212,64416213,64414421,64414422,64414423,64417201,64417200,64417230,64417231,64417233,65410211,65411211,65411213,65413223,65413221,65414201,65414203,65412223,65412203,65412221,65412201,65411223,644152212,644152320,644152322,644152323,644153321,644153323,644163002,644163013,644162112,644162113,644152221,644152222,644152223,644153111,644153112,644153113,644143331,644143333,644144201,644144203,6441523320,6441523322,6441522132,6441522133,6441523210,6441523212,6441523213,6441533011,6441533013,6441531231,6441531233,6441531210,6441531211,6441531213,6441533031,6441533033,6441533222,6441533223,6441630102,6441630103,6441630111,6441630112,6441630113,6441630002,6441630003,6441630030,6441630032,6441630121,6441630123,6441621100,6441621102,6441621103,6441522203,6441522033,6441531030,6441531032,6441531033,6441433321,6441433323,6441442001,6441442003,6441433133,6441433303,6441442021,6441442022,6441442023,64415221312,64415230222,64415230223,64415232112,64415310231,64415312121,64415312123,64415312301,64415312303,64415330123,64415330301,64415330303,64415330321,64415330323,64415332202,64415332203,64415332211,64415332212,64415332213,64416300113,64416301002,64416301003,64416301012,64416301013,64416301102,64416301103,64416300002,64416300003,64416300012,64416300013,64415233232,64416300131,64416300120,64416300122,64416301200,64416301201,64416301223,64416300330,64416300332,64416300333,64416211131,64416211132,64416211133,64416211122,64416211123,64416211010,64416211012,64416211013,64415221300,64415221302,64415221303,64415221032,64415221022,64415221023,64415220311,64415220312,64415220313,64415220321,64415220322,64415220323,64415222011,64415222012,64415222013,64415222021,64415222022,64415222023,64415310310,64415310312,64415310313,64415310123,64415310213,64415311031,64415311032,64415311033,64415311011,64415311013,64414333011,64414333012,64414333013,64414331321,64414331322,64414331323,64414420023,64414420201,64414420203,
003,00,/,511200000,154350000,515475000,161700000,86,85,0,0,0,0,644233,644243,644244,644245,644252,644253,644254,644255,644263,644264,644265,644273,644274,644275,654203,654204,654213,654214,654223,654224,654225,654233,654234,654235,654236,654237,654242,654243,654244,654245,654246,654247,654252,654253,654254,654255,654256,654257,654262,654263,654264,654265,654266,654267,654272,654273,654274,654275,654276,654330,654340,664202,664203,664204,664205,664206,664212,664213,664214,664215,664216,664222,664223,664224,664225,664226,664233,664234,664235,664243,664244,664245,664252,664253,664254,664261,664262,664263,664264,664270,664271,664272,674200,674201,674210,674220,6442223,6442321,6442323,6442340,6442342,6442343,6442421,6442422,6442423,6442620,6442621,6442623,6442721,6442723,6542021,6542050,6542051,6542052,6542150,6542152,6542153,6542221,6542223,6542260,6542262,6542263,6542272,6542273,6542313,6542321,6542322,6542323,6542411,6542413,6542511,6542513,6542611,6542612,6542613,6542711,6543202,6543310,6543312,6543410,6543412,6543602,6642011,6642013,6642111,6642113,6642211,6642213,6642311,6642320,6642321,6642323,6642360,6642362,6642421,6642422,6642423,6642460,6642462,6642503,6642512,6642513,6642550,6642551,6642560,6642561,6642601,6642603,6642730,6642731,6642732,6742020,6742021,6742022,6742030,6742110,6742111,6742112,6742120,6742210,6742212,
003,01,/ë,507262500,160500000,514462500,164025000,43,76,79,3,10,16,664274,674155,674156,674157,674161,674165,674166,674167,674175,674176,674177,674204,674205,674213,674214,674215,674222,674223,674224,674232,674233,674234,674242,674243,674250,674251,674252,674260,674261,674262,674270,674271,684105,684106,684107,684117,684200,674162,674152,674151,684100,674170,674164,6642733,6642750,6642752,6642753,6642762,6741452,6741462,6741463,6741541,6741543,6741741,6741743,6742023,6742031,6742032,6742033,6742113,6742121,6742122,6742123,6742160,6742211,6742213,6742250,6742252,6742310,6742311,6742313,6742411,6742412,6742413,6742440,6742442,6742530,6742531,6742532,6742720,6841100,6841150,6841151,6841161,6841163,6841270,6841271,6842010,6842100,6842101,6842102,6741443,6841043,6841141,6741601,6741711,6841101,6840171,6840073,6840071,6740773,6840173,6841261,6842012,6842011,6742251,6841160,6741630,6741631,6741533,6741532,6741542,6741633,6741603,6741710,6741712,6742060,6742062,6742063,67407713,67417200,67417201,67417210,67417401,67415403,67417403,68410411,68410413,68411520,68411521,68411431,68411530,67414222,67414133,67414223,67414132,67414123,67415013,67415031,67415033,67415032,67417202,67416023,67416022,68411030,68411021,68411020,67407711,68401703,68401701,68401721,68411023,68411032,68411031,68412720,68412721,68412730,68412731,68422000,68421030,67427220,67427210,67427221,67427222,67426302,67426300,67426301,67425330,67425332,67425331,67425402,67425400,67425401,67424410,67424412,67424411,67424430,67423502,67423500,67423501,67422530,67422532,67421620,67421621,67421622,67421610,67423520,67426320,68420130,68411621,67415401,67420720,68410410,68422002,67421612,67420610,67420612,67420613,674077103,674077121,674077123,6741721100,6741721102,6741721120,6741721122,6740771021,6740771023,6740771201,6740771203,6740771221,6740771223,67415011113,67415011131,67415011133,67415011311,67415011313,67415011331,67415011333,67417211010,67417211012,67417211030,67417211032,67417211210,67417211212,67417211230,67417211232,68412631111,
003,02,α˨,508500000,157350000,511875000,162300000,41,52,48,0,0,0,654153,654154,654165,654166,654175,654176,664105,664106,664107,664115,664116,664117,664125,664126,664127,664135,664136,664137,664146,664147,664156,664157,664166,664167,664176,664177,674106,674107,674116,674117,674126,674127,674136,674137,674147,674230,674240,654164,674135,664144,664145,6541423,6541432,6541433,6541442,6541443,6541521,6541523,6541550,6541552,6541553,6541562,6541631,6541741,6541772,6641551,6642000,6642002,6642100,6642102,6642200,6642202,6642300,6642302,6642400,6642402,6642500,6642502,6642600,6642602,6741253,6741450,6741451,6741453,6741460,6741461,6742312,6742410,6641553,6641521,6641530,6641520,6741251,6741153,6641651,6541743,6641433,6641531,6641550,6641432,6641423,6641422,6641343,66416531,66416533,66413413,66413411,66412433,66412431,66412413,66412411,66411433,66411431,66411413,66411411,66410411,66410413,66410431,66410433,65416331,65416301,65416300,65414221,65414223,65415201,65415203,65416303,65417401,66415321,66415320,66415230,66415221,66415231,66415330,66415220,67412521,67412523,67411511,67410533,67410531,67410513,67410511,66417533,66417531,66417513,66417511,66410410,67411513,67411512,67414413,67414411,
004,00,/̸/,513450000,156450000,523125000,160950000,105,84,52,0,0,0,654277,654327,654332,654333,654334,654337,654342,654343,654344,654345,654346,654347,654350,654351,654352,654353,654354,654355,654356,654357,654361,654362,654363,654364,654365,654366,654367,654370,654371,654372,654373,654374,654375,654376,654377,654420,654430,654431,654440,654441,654444,654445,654450,654451,654452,654453,654454,654455,654460,654461,654462,654463,654464,654465,654466,654470,654471,654472,654477,664207,664217,664227,664237,664247,664257,664265,664266,664267,664300,664301,664302,664303,664304,664305,664306,664307,664310,664311,664312,664313,664314,664315,664316,664320,664321,664322,664323,664324,664325,664330,664331,664332,664333,664340,664341,664342,664350,664400,664401,664410,664277,664351,664317,664407,664510,6543173,6543222,6543223,6543232,6543233,6543263,6543311,6543313,6543352,6543353,6543361,6543362,6543363,6543411,6543413,6543600,6543601,6543603,6544102,6544212,6544213,6544342,6544343,6544352,6544420,6544422,6544423,6544431,6544432,6544433,6544560,6544562,6544563,6544730,6544731,6544740,6544741,6544750,6544751,6544760,6544761,6544763,6642361,6642363,6642461,6642463,6642552,6642553,6642562,6642563,6642751,6642760,6642761,6643260,6643261,6643340,6643341,6643600,6643601,6644020,6644022,6644110,6644111,6644120,6645000,6645002,6645003,6645112,6645210,6645211,6645213,6645222,6645311,6645320,6645322,6643602,6643520,6643430,6644112,6544732,6644171,6645201,6642763,6742070,66436100,66437000,66437002,66436030,66436032,66437001,66436102,66436031,66436101,66435220,66435210,66434310,66434320,66433422,66433420,66433421,66433500,66432620,66432621,66432700,66432701,66432710,66441130,66441131,66441220,66441221,66440210,66440212,66440230,66440211,65447330,65447331,65447420,65447621,65447620,65447623,66440611,66440613,66440610,66441701,66441731,66452001,66452123,66452120,66452121,66453101,66453131,66454200,66454201,66453133,67420710,67420611,
005,00,ӹ/,513675000,151800000,518400000,157050000,107,47,21,0,0,0,634257,634267,634277,634322,634331,634332,634340,634341,634342,634350,634351,634352,634360,634361,634362,634363,634370,634371,634372,634373,634374,644206,644207,644216,644217,644226,644227,644236,644237,644246,644247,644256,644257,644266,644267,644276,644277,644300,644301,644302,644303,644304,644305,644310,644311,644312,644313,644314,644315,644320,644321,644322,644323,644324,644325,644330,644331,644332,644333,644334,644335,644340,644341,644342,644343,644344,644350,644351,644352,644353,644354,644355,644360,644361,644362,644363,644364,644365,644370,644371,644372,644373,644374,644375,654206,654207,654216,654217,654300,654301,654302,654303,654304,654305,654306,654310,654311,654312,654313,654314,654315,654316,654321,654324,654325,644316,634353,6342663,6342761,6342762,6342763,6343211,6343213,6343303,6343432,6343640,6343642,6343752,6443062,6443260,6443261,6443450,6443452,6443453,6443660,6443662,6443760,6443762,6443763,6542053,6542151,6542261,6542270,6542271,6543070,6543072,6543073,6543170,6543171,6543200,6543201,6543203,6543220,6543221,6543230,6543231,6543260,6543261,6543262,6543350,6543351,6543360,6543172,6343430,64430632,64430602,63437532,63437502,63436432,63436430,63436433,63437500,63437503,63435422,63435420,63434332,63434330,63433322,63433320,63432322,63432320,63432300,63432302,63433302,63433300,
006,00,ϩ,517275000,153975000,523125000,157350000,59,50,36,0,0,0,644336,644337,644346,644347,644356,644357,644367,644377,644430,644433,644434,644435,644440,644441,644442,644443,644444,644445,644446,644447,644450,644451,644452,644453,644454,644455,644456,644457,644460,644461,644462,644463,644464,644465,644466,644467,644470,644471,644472,644473,644474,644475,644540,644550,654400,654401,654402,654403,654404,654411,654412,654413,654414,654422,654423,654424,654432,654433,644327,6443262,6443263,6443451,6443661,6443663,6443761,6444202,6444312,6444313,6444322,6444323,6444372,6444373,6444760,6444761,6445302,6445412,6445512,6445513,6445522,6445600,6445601,6445603,6445610,6445611,6445612,6445620,6543071,6544050,6544052,6544100,6544101,6544103,6544150,6544152,6544153,6544210,6544211,6544250,6544340,6544341,6544421,6544430,6445510,6444321,6444310,6444360,6444362,6444363,6443172,64454132,64455110,64455112,64455113,64455202,64454102,64453032,64453002,64443713,64443712,64443703,64443702,64442622,64442533,64442623,64442532,64442523,64442522,64442422,64442423,64442333,64442332,64442323,64443112,64443113,64442032,64442033,64442002,64431732,64442632,64443610,64443612,64443613,64454130,64454103,64431702,
006,01,,520650000,155250000,525150000,159759375,36,53,49,0,0,16,644477,644563,644570,644571,644572,644574,654406,654407,654416,654417,654426,654427,654436,654437,654446,654447,654457,654467,654500,654501,654505,654506,654510,654511,654520,654521,654530,654531,654540,654550,654560,654570,664501,654522,654502,644573,6444762,6444763,6445523,6445533,6445542,6445602,6445613,6445621,6445622,6445623,6445640,6445642,6445752,6445753,6544051,6544053,6544151,6544251,6544252,6544253,6544350,6544351,6544353,6544561,6545041,6545120,6545122,6545320,6545321,6545410,6545710,6545712,6645001,6645022,6645110,6645111,6645113,6645120,6645122,6645123,6645220,6645221,6645223,6645321,6645323,6645421,6645330,6545713,6545612,6545040,6445762,6445643,6445750,66454300,66453322,66454302,66453320,66452322,66452320,66452302,66452323,66451212,66450202,66450200,66450203,65457112,65456102,65456100,65455122,65455120,65454122,65454120,65454121,65454110,65453220,65453222,65453221,65453230,65451212,65451210,65451230,65450302,65450300,65450301,65450430,65450431,65450433,64457512,64457513,64457632,64456413,64456412,64456410,64455432,64456522,64456520,64455323,64455322,65452322,65452320,65452302,65453300,66454230000,66454230001,66454230010,66454230011,66454230100,66454230101,66454230110,66454230111,66454231000,66454231001,66454231010,66454231011,66454231100,66454231101,66454231110,66454231111,
007,00,δ,506685937,139471875,509400000,141553125,13,28,49,109,268,517,584047,584057,584122,584130,584131,584132,584140,584141,584142,584150,584151,584152,584162,5840363,5840371,5840372,5840373,5840461,5840463,5840561,5840563,5840671,5841113,5841122,5841202,5841203,5841211,5841212,5841213,5841230,5841232,5841330,5841332,5841430,5841432,5841600,5841601,5841610,5841611,5841613,5841720,58402733,58403621,58403623,58403702,58403703,58404601,58405601,58405603,58405621,58405623,58406701,58406731,58411111,58411112,58411113,58411121,58411122,58411123,58411233,58411321,58411322,58411323,58412101,58412103,58412330,58412332,58413310,58413312,58413313,58413330,58413332,58414310,58414312,58414330,58414332,58415300,58415301,58415302,58415310,58416020,58416021,58416023,58416030,58416031,58416120,58416121,58416123,58417210,58417220,584027311,584027313,584027323,584036131,584036132,584036133,584036221,584036223,584037002,584037003,584037011,584037012,584037013,584046031,584046033,584046223,584046231,584046232,584046233,584056001,584056003,584056021,584056023,584056201,584056203,584056221,584066011,584066100,584066111,584067000,584067001,584067031,584067300,584067301,584067303,584110333,584111023,584111032,584111033,584111103,584111201,584111203,584112020,584112022,584112312,584112313,584112321,584112322,584112323,584113032,584113033,584113201,584113202,584113203,584113302,584113320,584113322,584121001,584121003,584121023,584123100,584123102,584123103,584123120,584123122,584123330,584123332,584123333,584133110,584133112,584133310,584133312,584143110,584143312,584143330,584143332,584153200,584153201,584153202,584153220,584153221,584153222,584160220,584160221,584160223,584160320,584160322,584161221,584161223,584163000,584163002,584163020,584163022,584163023,584163200,584163201,584163202,584170011,584171011,584171100,584171101,584171102,584171110,584171111,584172110,584172120,584172210,584172211,584172212,5840271332,5840271333,5840272323,5840272332,5840273101,5840273103,5840273121,5840273122,5840273123,5840273211,5840273213,5840273221,5840273222,5840273223,5840360233,5840360322,5840360323,5840360332,5840360333,5840361133,5840361231,5840361232,5840361233,5840361302,5840361303,5840362011,5840362013,5840362031,5840362033,5840370002,5840370003,5840370012,5840370013,5840370101,5840370102,5840370103,5840460011,5840460301,5840462110,5840462111,5840462113,5840462131,5840462132,5840462133,5840462221,5840462223,5840560001,5840560003,5840560021,5840560023,5840560201,5840560203,5840562001,5840562002,5840562003,5840562020,5840562021,5840562023,5840562231,5840562233,5840660101,5840661010,5840661012,5840661100,5840661101,5840661103,5840670021,5840670030,5840670031,5840670033,5840670211,5840670300,5840670301,5840670303,5840670330,5840670331,5840670333,5840672111,5840672113,5840673020,5840673021,5840673023,5840673210,5840673211,5840673300,5840673301,5840673310,5840673311,5841013322,5841013323,5841013332,5841103303,5841103312,5841103313,5841103321,5841103323,5841110301,5841110302,5841110303,5841110310,5841110312,5841110313,5841111011,5841111012,5841111013,5841112023,5841120002,5841120020,5841120022,5841120023,5841120230,5841120232,5841120322,5841123023,5841123031,5841123032,5841123033,5841123201,5841123202,5841123203,5841130123,5841130132,5841130233,5841130301,5841130303,5841130310,5841130312,5841130313,5841131202,5841131220,5841131222,5841132001,5841132002,5841132003,5841133000,5841133002,5841133030,5841133032,5841133210,5841133212,5841133230,5841133232,5841201101,5841201110,5841201111,5841210000,5841210001,5841210003,5841210211,5841210213,5841231010,5841231012,5841231210,5841231211,5841231212,5841231230,5841231232,5841233102,5841233122,5841233123,5841233310,5841233312,5841233313,5841331110,5841331111,5841331112,5841331130,5841331132,5841333110,5841333111,5841333112,5841333130,5841333132,5841333300,5841333301,5841333302,5841333320,5841333322,5841431120,5841431121,5841431122,5841431300,5841433100,5841433102,5841433103,5841530300,5841530301,5841530302,5841530310,5841530311,5841530320,5841530322,5841531100,5841531101,5841531200,5841531201,5841531210,5841532030,5841532031,5841532032,5841532100,5841532102,5841532230,5841532232,5841603210,5841603211,5841603212,5841603230,5841603232,5841603310,5841603311,5841612200,5841612201,5841612203,5841630010,5841630030,5841630210,5841630212,5841630213,5841630320,5841632030,5841632031,5841632200,5841632201,5841632202,5841632220,5841632221,5841632222,5841700100,5841700101,5841710011,5841710100,5841710101,5841710103,5841710121,5841710130,5841710131,5841710133,5841711030,5841711031,5841711032,5841711120,5841711121,5841711130,5841711131,5841711200,5841711201,5841711331,5841711333,5841713111,5841713113,5841713131,5841721110,5841721111,5841721112,5841721120,5841721121,5841721210,5841721211,5841721212,5841721220,5841721222,5841722130,5841722132,5841722300,5841722301,5841722310,5841730000,58402713302,58402713303,58402713312,58402713313,58402723212,58402723213,58402723223,58402723302,58402723303,58402723313,58402723331,58402723332,58402723333,58402730331,58402730332,58402730333,58402731021,58402731023,58402731201,58402731203,58402732032,58402732033,58402732103,58402732121,58402732122,58402732123,58402732202,58402732203,58403602312,58403602313,58403602321,58403602323,58403603202,58403611233,58403611311,58403611313,58403611321,58403611322,58403611323,58403612132,58403612133,58403612231,58403612233,58403612303,58403613002,58403613003,58403613011,58403613012,58403613013,58403620101,58403620103,58403620121,58403620233,58403620301,58403620303,58403620321,58403620322,58403620323,58403622011,58403622013,58403622031,58403622033,58403622211,58403622213,58403622231,58403622233,58403701001,58403701003,58404600011,58404600100,58404600101,58404600103,58404600121,58404600130,58404600131,58404603001,58404603003,58404603031,58404603033,58404603211,58404603213,58404603231,58404603233,58404621011,58404621120,58404621121,58404621302,58404621303,58404622221,58404622223,58404623031,58404623033,58405531113,58405531131,58405531133,58405531311,58405531313,58405600001,58405600003,58405600021,58405600023,58405600201,58405600203,58405602003,58405602021,58405602023,58405602201,58405602210,58405602211,58405602213,58405602231,58405602233,58405620002,58405620003,58405620221,58405620223,58405622010,58405622011,58405622013,58405622031,58405622033,58405622211,58405622300,58405622301,58405622303,58405622321,58405622323,58406600101,58406600110,58406600111,58406601000,58406601001,58406601003,58406601031,58406601033,58406610110,58406610111,58406611021,58406611023,58406700321,58406700323,58406702101,58406702130,58406702131,58406703020,58406703021,58406703210,58406703211,58406703320,58406703321,58406703323,58406721101,58406721103,58406721121,58406721123,58406721311,58406721313,58406730220,58406730221,58406732010,58406732011,58406732013,58406732031,58406732120,58406732121,58406732130,58406732131,58406733020,58406733021,58406733030,58406733031,58406733120,58406733121,58406733130,58406733131,58410132313,58410132323,58410132331,58410132332,58410132333,58410133202,58410133203,58410133212,58410133213,58410133302,58410133303,58410133312,58410133330,58410133332,58410133333,58410222222,58411033012,58411033013,58411033102,58411033103,58411033112,58411033113,58411102122,58411102123,58411102131,58411102132,58411102133,58411102213,58411102231,58411102233,58411110101,58411110102,58411110103,58411110231,58411110233,58411120011,58411120013,58411120221,58411120223,58411200000,58411200002,58411200003,58411200012,58411200030,58411200032,58411200210,58411200212,58411200320,58411200322,58411202100,58411202102,58411202120,58411202122,58411202123,58411202313,58411202331,58411202332,58411202333,58411203202,58411203203,58411203212,58411203230,58411203232,58411203233,58411203322,58411203323,58411203332,58411203333,58411230131,58411230133,58411230301,58411230303,58411231020,58411231022,58411231113,58411231131,58411231133,58411232001,58411232002,58411232003,58411301221,58411301223,58411301330,58411301332,58411302223,58411302232,58411302233,58411302303,58411302312,58411302313,58411302321,58411302322,58411302323,58411303001,58411303003,58411303021,58411303022,58411303023,58411303110,58411303112,58411312030,58411312032,58411312210,58411312212,58411320001,58411320002,58411320003,58411330330,58411330332,58411332110,58412002222,58412002223,58412002232,58412002233,58412003223,58412003232,58412003233,58412003322,58412003323,58412012233,58412012322,58412013232,58412013233,58412013322,58412013323,58412013332,58412013333,58412100021,58412100023,58412100201,58412100210,58412100211,58412100213,58412100231,58412102100,58412102101,58412102122,58412102123,58412102222,58412102223,58412102232,58412102233,58412310130,58412310132,58412311200,58412311202,58412311220,58412311222,58412312332,58412313000,58412313002,58412331000,58412331002,58412331200,58412331201,58412331202,58412331322,58412331323,58412331332,58412333110,58412333112,58412333113,58413311130,58413311131,58413311132,58413311310,58413311312,58413311330,58413311332,58413311333,58413331130,58413331131,58413331132,58413331310,58413331312,58413331330,58413331332,58413333100,58413333102,58414313020,58414313022,58414313200,58414313202,58414313220,58414313222,58414331120,58414331122,58414331300,58414331302,58414331320,58414331322,58414333100,58414333102,58414333120,58414333122,58414333300,58414333302,58414333320,58414333322,58415303030,58415303031,58415303130,58415303131,58415311020,58415311021,58415311022,58415311030,58415311031,58415311100,58415311200,58415311202,58415311220,58415311222,58415312020,58415312021,58415312030,58415321200,58415321202,58415322310,58415322311,58416022200,58416022201,58416022210,58416022211,58416022213,58416032130,58416032131,58416032132,58416032310,58416032312,58416032330,58416032332,58416033000,58416033001,58416033010,58416033011,58416033013,58416033031,58416033120,58416033121,58416033130,58416033131,58416122020,58416122021,58416122023,58416122201,58416122210,58416122211,58416300120,58416300122,58416300123,58416300320,58416300322,58416303020,58416303022,58416303220,58416303221,58416303222,58416320320,58416320321,58416320322,58416321000,58416321002,58416322030,58416322031,58416322032,58416322100,58416322102,58416322120,58416322230,58416322232,58416322300,58416322302,58417000111,58417000113,58417010000,58417010002,58417010020,58417010022,58417101231,58417101320,58417101321,58417103110,58417103111,58417110330,58417110331,58417111230,58417111231,58417111320,58417111321,58417111330,58417111331,58417112020,58417112021,58417112030,58417112031,58417112100,58417112101,58417113303,58417113321,58417113323,58417131101,58417131103,58417131121,58417131123,58417131301,58417131303,58417131321,58417131330,58417131331,58417211130,58417211132,58417211220,58417211300,58417211302,58417212130,58417212131,58417212210,58417212211,58417212300,58417212301,58417221310,58417221312,58417221330,58417221332,58417222000,58417222001,58417222010,58417222011,58417222100,58417222101,58417222110,58417222111,58417222113,58417222131,58417223020,58417223021,58417223030,58417223031,58417223110,58417223120,58417223121,
008,00,,506348437,141009375,510314062,145350000,56,49,121,279,536,1117,584077,594006,594007,594016,594017,594027,594037,594047,594057,594067,594077,594100,594101,594102,594103,594104,594110,594111,594112,594113,594114,594120,594121,594122,594123,594124,594130,594131,594132,594133,594134,594140,594141,594142,594150,594151,594152,594160,594161,594162,594170,594171,594172,594173,604007,604100,604101,604102,604103,604110,604111,604112,604121,604122,604132,604133,5840663,5840761,5840762,5840763,5841702,5841703,5841712,5841723,5841731,5841732,5841733,5841740,5841742,5841743,5841750,5940053,5940151,5940260,5940261,5940263,5940361,5940463,5941150,5941152,5941250,5941252,5941532,5941533,5941630,5941631,5941632,5941740,5941742,6040170,6040171,6040173,6040271,6041130,6041132,6041200,6041201,6041230,6041232,6041233,6041310,6041311,6041340,6041342,5941350,58406603,58406612,58406613,58406720,58406722,58406723,58407513,58407531,58407533,58407601,58407602,58407603,58416323,58416330,58416332,58416333,58417002,58417003,58417011,58417012,58417013,58417102,58417130,58417132,58417133,58417213,58417301,58417302,58417303,58417411,58417412,58417413,58417520,58417521,58417522,59400511,59400512,59400513,59401531,59401533,59402620,59402621,59402623,59403601,59403630,59403631,59403633,59404611,59404612,59404613,59405610,59405611,59405613,59405632,59405633,59406610,59406611,59406612,59410500,59410502,59410520,59410522,59411510,59411512,59412510,59412512,59412513,59414300,59414302,59414311,59414320,59414322,59414400,59414401,59415300,59415302,59415303,59415312,59416330,59416332,59416333,60401720,60401721,60401723,60402701,60402703,60402730,60410400,60410402,60410420,60411310,60411332,60412021,60412030,60412031,60412033,60412310,60412312,60412313,60412422,60412423,60412432,60413131,60413410,60414210,60414301,60414310,60414311,60414312,60414410,59414410,59414411,59414412,59413520,59413521,59413522,59413510,59413511,59413512,59412530,59412532,584066021,584066023,584066102,584066103,584066112,584066113,584066201,584066210,584066211,584066213,584066231,584066232,584066233,584067020,584067022,584067023,584067210,584067212,584067322,584067323,584067332,584067333,584075113,584075303,584075321,584076001,584076002,584076003,584160332,584160333,584163031,584163033,584163122,584163123,584163211,584163212,584163213,584163310,584163312,584164220,584164222,584164223,584164232,584170000,584170002,584170003,584170012,584170013,584170101,584170102,584170103,584171000,584171002,584171003,584171030,584171032,584171033,584171122,584171123,584171130,584171131,584171132,584171310,584171312,584172222,584172223,584172232,584172233,584173001,584173002,584173003,584174101,584174102,584174103,584175120,584175230,584175232,584175302,594005033,594005101,594005103,594005212,594005213,594005231,594005232,594005233,594015301,594025111,594025113,594025131,594025133,594025311,594025313,594026220,594026221,594026223,594036321,594036323,594046101,594046103,594046211,594046213,594046231,594056231,594056232,594056233,594056311,594056312,594056313,594066011,594066013,594066030,594066031,594066033,594066130,594066131,594066300,594076111,594076113,594076131,594076133,594076311,594076313,594076331,594076333,594105212,594105230,594105232,594105233,594105322,594105323,594105332,594105333,594115110,594115300,594115301,594115302,594115320,594115322,594125110,594125112,594125113,594143010,594143011,594143012,594143100,594143101,594143131,594144020,594144021,594144030,594144031,594144300,594153012,594153013,594153102,594153103,594153112,594153130,594153132,594153133,594154220,594154222,594163310,594163311,594163312,594164000,594164022,594164222,594164223,594164231,594164232,594164233,594174102,594174120,594174122,594174123,594174300,594174302,594174320,604006111,604006113,604006131,604006133,604006311,604006313,604006330,604006331,604006333,604016333,604017221,604017222,604017223,604027000,604027001,604027003,604027021,604027210,604027211,604027310,604027311,604027320,604027321,604104010,604104011,604104012,604104030,604104220,604104221,604113110,604113112,604113120,604113121,604113122,604113300,604113302,604113303,604113330,604113332,604120200,604120201,604120320,604120321,604120323,604123110,604123112,604124202,604124332,604130111,604130113,604130131,604131201,604131210,604131211,604131213,604131300,604131301,604131303,604131330,604131331,604134110,604134112,604134120,604134122,604134123,604134300,604134302,604134320,604134322,604142000,604142001,604142010,604142011,604142013,604142031,604142120,604143000,604143001,604143003,604143130,604143131,604143132,604144000,604144001,604144002,604144010,604144011,604144013,604144112,604144121,594144130,594144132,594135230,594135232,594135130,594125330,594125332,594125333,594125310,5840660131,5840660132,5840660133,5840661013,5840662031,5840662120,5840662121,5840662123,5840662213,5840662231,5840662232,5840662233,5840662301,5840662302,5840662303,5840670020,5840670022,5840670023,5840670212,5840670320,5840670322,5840670323,5840672130,5840672132,5840672133,5840673200,5840673202,5840751122,5840751123,5840751211,5840751233,5840753003,5840753011,5840753012,5840753013,5840753021,5840753023,5840753201,5840753203,5840753221,5840753230,5840753231,5840753233,5840760001,5840760003,5841602222,5841602223,5841603302,5841612222,5841612223,5841630303,5841630321,5841630323,5841631200,5841631202,5841631203,5841631212,5841631322,5841631323,5841632033,5841632101,5841632102,5841632103,5841632211,5841632213,5841632231,5841632232,5841632233,5841642212,5841642332,5841642333,5841643231,5841643233,5841643320,5841643322,5841643323,5841643332,5841643333,5841652220,5841652222,5841652223,5841652231,5841652232,5841652233,5841652320,5841652322,5841652323,5841700010,5841700012,5841700013,5841700102,5841700103,5841701001,5841701003,5841710010,5841710012,5841710013,5841710102,5841710120,5841710122,5841710310,5841710312,5841710313,5841711122,5841711211,5841711212,5841711213,5841721123,5841721131,5841721132,5841721133,5841721223,5841721231,5841721232,5841721233,5841722202,5841722203,5841722212,5841722313,5841730001,5841730002,5841730003,5841741002,5841741003,5841751020,5841751022,5841751023,5841751220,5841751221,5841751222,5841752310,5841752311,5841753002,5940050311,5940050312,5940050313,5940051003,5940051020,5940051021,5940051023,5940052102,5940052103,5940052111,5940052112,5940052113,5940052300,5940052301,5940052303,5940150311,5940150312,5940150313,5940150331,5940150333,5940153001,5940153003,5940153031,5940153033,5940153213,5940153231,5940153233,5940251101,5940251102,5940251103,5940251121,5940251123,5940253103,5940253121,5940253123,5940253310,5940253311,5940262221,5940360010,5940360011,5940360013,5940360031,5940360310,5940360311,5940360313,5940360331,5940363201,5940363203,5940363221,5940363223,5940460332,5940460333,5940461001,5940461003,5940461021,5940461023,5940462103,5940462121,5940462122,5940462123,5940462211,5940462300,5940462301,5940462331,5940462333,5940560111,5940560113,5940561210,5940561211,5940561213,5940561231,5940562132,5940562133,5940562303,5940563022,5940563023,5940563031,5940563032,5940563033,5940563101,5940563102,5940563103,5940660101,5940660103,5940660121,5940660122,5940660123,5940660320,5940660321,5940660323,5940661320,5940661321,5940661322,5940661330,5940661331,5940662110,5940662111,5940663010,5940663012,5940663133,5940663311,5940663313,5940663331,5940663332,5940663333,5940761323,5940763101,5940763102,5940763103,5940763120,5940763121,5940763123,5940763301,5940763303,5940763321,5940763323,5941050100,5941050102,5941050120,5941050122,5941050300,5941050302,5941050320,5941050322,5941052100,5941052102,5941052103,5941052132,5941052310,5941052312,5941052313,5941053202,5941053212,5941053213,5941053302,5941053312,5941151110,5941151111,5941151120,5941151122,5941151300,5941151302,5941151320,5941151322,5941153030,5941153032,5941153210,5941153212,5941153230,5941153232,5941153233,5941251110,5941251112,5941251113,5941430130,5941430132,5941430300,5941430301,5941430302,5941430320,5941431021,5941431030,5941431031,5941431301,5941431330,5941431331,5941440220,5941440221,5941440230,5941440231,5941440320,5941440321,5941440330,5941440331,5941440333,5941443010,5941530100,5941530102,5941530103,5941530110,5941530112,5941530113,5941531002,5941531310,5941531312,5941542000,5941542002,5941542022,5941542023,5941542032,5941542033,5941542210,5941542211,5941542212,5941542230,5941542232,5941633130,5941633132,5941640010,5941640012,5941640020,5941640021,5941640022,5941640030,5941640200,5941640202,5941640203,5941642000,5941642001,5941642200,5941642202,5941642203,5941642212,5941642302,5941642303,5941643220,5941643222,5941741002,5941741030,5941741032,5941741210,5941741212,5941743010,5941743011,5941743012,5941743030,5941743032,5941743210,5941743220,5941743221,5941743222,6040061101,6040061103,6040061301,6040061303,6040061321,6040063103,6040063121,6040063123,6040063320,6040063321,6040161111,6040161333,6040163111,6040163113,6040172200,6040172201,6040172203,6040261110,6040261111,6040261113,6040270020,6040270021,6040270023,6040270231,6040270233,6040272011,6040272013,6040272120,6040272121,6040272130,6040272131,6040272133,6040273120,6040273121,6040273122,6040273130,6040273131,6040273221,6040273230,6040273300,6040273302,6041040130,6041040132,6041040310,6041040320,6041040322,6041042100,6041042102,6041042220,6041042221,6041042230,6041042231,6041131110,6041131112,6041131130,6041131132,6041131230,6041131231,6041131232,6041131300,6041133010,6041133012,6041133013,6041133120,6041133122,6041133123,6041202031,6041202033,6041202301,6041202310,6041202311,6041203220,6041203221,6041203223,6041231110,6041231112,6041231130,6041231132,6041240222,6041242000,6041242002,6041242003,6041242012,6041242030,6041242032,6041242122,6041242123,6041243022,6041243023,6041243032,6041243302,6041243303,6041243312,6041243330,6041243332,6041301100,6041301101,6041301123,6041301301,6041301303,6041301331,6041301333,6041312120,6041312121,6041313020,6041313021,6041313321,6041313330,6041313331,6041313333,6041341110,6041341112,6041341130,6041341132,6041341210,6041341211,6041341212,6041341300,6041343010,6041343011,6041343012,6041343030,6041343032,6041343212,6041343230,6041343232,6041343233,6041411111,6041420021,6041420030,6041420031,6041420120,6041420121,6041421100,6041421101,6041421102,6041421110,6041421111,6041421210,6041421211,6041421212,6041421220,6041421221,6041430021,6041430210,6041430211,6041430213,6041430300,6041430301,6041430310,6041430311,6041430313,6041430331,6041431330,6041431331,6041431332,6041440030,6041440031,6041440032,6041440120,6041440121,6041440200,6041440201,6041440311,6041441102,6041441132,6041441200,6041441201,6041441203,6041441221,6041441230,6041441300,58406601222,58406601223,58406601232,58406601233,58406601302,58406601303,58406602011,58406602013,58406602031,58406602033,58406602211,58406602213,58406602231,58406602233,58406610112,58406610113,58406611020,58406611022,58406620011,58406620013,58406620031,58406620033,58406620301,58406620303,58406621220,58406621221,58406621223,58406622213,58406622223,58406622231,58406622232,58406622233,58406622301,58406622302,58406622303,58406623001,58406623003,58406700320,58406700322,58406702100,58406702102,58406702103,58406702132,58406702133,58406703022,58406703023,58406703212,58406703213,58406703322,58406721100,58406721102,58406721120,58406721122,58406721310,58406721312,58406730222,58406730223,58406732012,58406732030,58406732032,58406732033,58406732122,58406732123,58406732132,58406732133,58406733022,58406733023,58406733032,58406733033,58406733122,58406733123,58406733132,58406733133,58407511122,58407511123,58407511132,58407511133,58407511203,58407511212,58407511213,58407512130,58407512131,58407512312,58407512313,58407512323,58407530003,58407530012,58407530013,58407530021,58407530023,58407530101,58407530102,58407530103,58407530201,58407530221,58407530223,58407532001,58407532003,58407532021,58407532321,58407532322,58407532323,58407600001,58407600003,58407600021,58407600022,58407600023,58416022202,58416022203,58416022212,58416032133,58416032311,58416032313,58416032331,58416032333,58416033002,58416033003,58416033012,58416033030,58416033032,58416033033,58416033122,58416033123,58416033132,58416033133,58416122022,58416122200,58416122202,58416122203,58416122212,58416122213,58416303011,58416303013,58416303021,58416303023,58416303223,58416310223,58416310232,58416312010,58416312012,58416312130,58416312132,58416313200,58416313202,58416313320,58416313322,58416320323,58416321001,58416321003,58416322033,58416322101,58416322103,58416322121,58416322122,58416322123,58416322231,58416322233,58416322301,58416322303,58416331100,58416331102,58416331120,58416331122,58416331300,58416331302,58416331320,58416331322,58416423300,58416423302,58416423303,58416423312,58416423313,58416432222,58416432233,58416432303,58416432321,58416432322,58416432323,58416433210,58416433212,58416433213,58416433302,58416433303,58416433312,58416433313,58416522210,58416522212,58416522213,58416522301,58416522302,58416522303,58416523210,58416523212,58416523213,58416523302,58416523320,58416523322,58416523323,58416523332,58416523333,58417000110,58417000112,58417010001,58417010003,58417010021,58417010023,58417101230,58417101232,58417101233,58417101322,58417101323,58417103112,58417103113,58417110332,58417110333,58417111232,58417111233,58417111322,58417111323,58417111332,58417111333,58417112022,58417112023,58417112032,58417112033,58417112102,58417112103,58417113300,58417113301,58417113302,58417113320,58417113322,58417131100,58417131102,58417131120,58417131122,58417131300,58417131302,58417131320,58417131322,58417131323,58417131332,58417131333,58417211131,58417211133,58417211221,58417211222,58417211223,58417211301,58417211303,58417212132,58417212133,58417212212,58417212213,58417212302,58417212303,58417221311,58417221313,58417221331,58417221333,58417222002,58417222003,58417222012,58417222013,58417222102,58417222103,58417222112,58417222130,58417222132,58417222133,58417223022,58417223023,58417223032,58417223033,58417223111,58417223112,58417223113,58417223122,58417223123,58417410000,58417410002,58417410003,58417410011,58417410012,58417410013,58417510002,58417510020,58417510022,58417510023,58417510032,58417510210,58417510212,58417510213,58417510302,58417510320,58417510322,58417512100,58417512230,58417512232,58417523120,58417523121,58417523122,58417523130,58417523131,58417523300,58417523302,58417523320,58417523322,58417530000,58417530002,58417530003,58417530012,58417530030,58417530032,58417532000,58417532001,58417532010,58417532011,59400501133,59400501311,59400501313,59400501331,59400510012,59400510013,59400510022,59400510023,59400510220,59400510221,59400510223,59400520311,59400520313,59400520331,59400521003,59400521012,59400521013,59400521102,59400521103,59400523021,59400523022,59400523023,59401501100,59401501101,59401501110,59401501111,59401501113,59401501131,59401501133,59401501311,59401501313,59401501331,59401501333,59401503102,59401503103,59401521111,59401530000,59401530001,59401530003,59401530021,59401530210,59401530211,59401530300,59401530301,59401530303,59401530321,59401532112,59401532113,59402510110,59402510111,59402511000,59402511001,59402511003,59402511200,59402511201,59402511203,59402511221,59402511223,59402531011,59402531013,59402531021,59402531023,59402531201,59402531203,59402531221,59402531223,59402533011,59402533013,59402533131,59402533133,59402622201,59402622230,59402622231,59402622233,59403600011,59403600013,59403600031,59403600120,59403600121,59403603330,59403603331,59403603333,59403621111,59403621113,59403621131,59403621133,59403621311,59403621313,59404603113,59404603131,59404603133,59404603231,59404603233,59404603311,59404603313,59404610222,59404610223,59404620332,59404620333,59404621003,59404621011,59404621012,59404621013,59404621021,59404621023,59404621201,59404621202,59404621203,59404622130,59404622131,59404623020,59404623021,59404623030,59404623031,59404623033,59404623211,59404623300,59404623301,59405612010,59405612011,59405612013,59405612031,59405612120,59405612121,59405612123,59405612301,59405612330,59405612331,59405623011,59405623013,59405623021,59405623023,59405630123,59405630132,59405630133,59405630212,59405630213,59405630301,59405630302,59405630303,59405631001,59405631002,59405631003,59406601001,59406601003,59406601021,59406601023,59406601201,59406601203,59406603221,59406603223,59406613331,59406613333,59406621011,59406621013,59406630110,59406630112,59406630130,59406630132,59406631311,59406631313,59406631321,59406631323,59406633101,59406633103,59406633121,59406633123,59406633233,59406633301,59406633302,59406633303,59407611011,59407611013,59407611031,59407611033,59407611211,59407611213,59407611231,59407611233,59407613011,59407613013,59407613031,59407613033,59407613203,59407613211,59407613212,59407613213,59407613221,59407613223,59407631001,59407631003,59407631220,59407631221,59407631223,59407633001,59407633003,59407633021,59407633023,59407633201,59407633203,59407633221,59407633223,59410501010,59410501012,59410501030,59410501032,59410501210,59410501212,59410501230,59410503212,59410503230,59410503232,59410521010,59410521012,59410521120,59410521122,59410521300,59410521302,59410523112,59410523113,59410532002,59410532003,59410532012,59410532030,59410532032,59410532033,59410532102,59410532103,59410532112,59410532113,59410533002,59410533003,59410533012,59410533030,59410533032,59410533033,59410533102,59410533103,59410533132,59410533133,59410622202,59410622220,59410622222,59411511120,59411511121,59411511122,59411511130,59411511131,59411511210,59411511211,59411511212,59411511230,59411511232,59411511300,59411513010,59411513012,59411513030,59411513032,59411530310,59411530311,59411530312,59411530330,59411530332,59411531000,59411531001,59411532110,59411532112,59411532130,59411532132,59411532310,59411532312,59411600000,59414301310,59414301312,59414301330,59414301332,59414303220,59414303221,59414313001,59414313003,59414313031,59414313320,59414313321,59414313330,59414313331,59414321002,59414321020,59414321022,59414323000,59414323002,59414323020,59414323022,59414323200,59414323202,59414323220,59414323222,59414323223,59414323233,59414323322,59414323323,59414323332,59414402220,59414402221,59414402230,59414402231,59414402320,59414402321,59414402330,59414402331,59414403220,59414403221,59414403230,59414403231,59414403320,59414403321,59414403323,59414421101,59414421110,59414421111,59414421113,59414430110,59414430111,59414430112,59415301011,59415301012,59415301013,59415301110,59415301112,59415301113,59415310002,59415310003,59415310012,59415310030,59415310032,59415310033,59415310122,59415310123,59415310132,59415310133,59415311022,59415311023,59415311032,59415311033,59415311302,59415311320,59415311322,59415313110,59415313112,59415313130,59415313132,59415402220,59415402222,59415402223,59415402232,59415420010,59415420012,59415420030,59415420032,59415420200,59415420202,59415420203,59415420212,59415420213,59415420302,59415420303,59415422130,59415422131,59415422132,59415422310,59415422312,59415422330,59415422332,59416331310,59416331312,59416331330,59416331332,59416400230,59416400231,59416400232,59416402010,59416402012,59416422010,59416422012,59416422132,59416422133,59416432020,59416432022,59416432023,59416432032,59416432210,59416432212,59416432230,59416432232,59417410000,59417410002,59417410030,59417410032,59417410330,59417410332,59417412110,59417412112,59417412130,59417412132,59417412133,59417413022,59417413200,59417413202,59417413220,59417413222,59417430130,59417430131,59417430132,59417430310,59417430312,59417430330,59417430332,59417431000,59417431002,59417431020,59417432110,59417432230,59417432232,60400611001,60400611003,60400611021,60400611023,60400611201,60400611210,60400611211,60400611213,60400611231,60400611233,60400613001,60400613003,60400613021,60400613023,60400613201,60400613203,60400613231,60400613233,60400631011,60400631013,60400631021,60400631023,60400631201,60400631203,60400631221,60400631222,60400631223,60400633221,60400633230,60400633231,60400633233,60401611011,60401611100,60401611101,60401611103,60401611121,60401611130,60401611131,60401611133,60401611311,60401613133,60401613311,60401613313,60401613321,60401613323,60401631101,60401631103,60401631121,60401631123,60401631301,60401631310,60401631311,60401631313,60401633123,60401633132,60401633133,60401722022,60401722023,60402611120,60402611121,60402611123,60402702011,60402702013,60402702031,60402702033,60402702211,60402702300,60402702301,60402702303,60402702321,60402720101,60402720103,60402720121,60402721321,60402721323,60402731230,60402731232,60402732200,60402732201,60402732230,60402732231,60402732310,60402732311,60402732312,60402732320,60402732321,60402732330,60402733200,60402733201,60410401310,60410401311,60410403120,60410403122,60410410000,60410410001,60410410010,60410421200,60410421201,60410421202,60410421220,60410421222,60410422220,60410422221,60410422230,60410422231,60410422320,60410422321,60410422330,60410423000,60410423002,60410423020,60410423022,60410423200,60410423202,60411311110,60411311111,60411311112,60411311130,60411311132,60411311310,60411311312,60411311330,60411311332,60411312330,60411312331,60411312332,60411313020,60411313022,60411313200,60411313202,60411313220,60411330110,60411330112,60411331020,60411331022,60411331212,60411331213,60411333102,60411333120,60411333122,60411333300,60411333302,60411333320,60411333322,60412023001,60412023003,60412023030,60412023031,60412023120,60412023121,60412023130,60412023131,60412032220,60412032221,60412032223,60412311110,60412311112,60412311130,60412311132,60412311310,60412311312,60412311330,60412311332,60412311333,60412402002,60412402020,60412402022,60412402230,60412402232,60412420010,60412420012,60412420132,60412420310,60412420312,60412420330,60412420332,60412420333,60412421202,60412421203,60412421212,60412421213,60412421302,60412421320,60412421322,60412421323,60412421332,60412421333,60412430202,60412430203,60412430212,60412430213,60412430302,60412430303,60412430332,60412430333,60412431222,60412433000,60412433002,60413010001,60413010010,60413010011,60413010100,60413010101,60413010110,60413010111,60413010113,60413011031,60413011033,60413011211,60413011212,60413011213,60413013003,60413013021,60413013210,60413013211,60413013300,60413013301,60413013303,60413013321,60413031110,60413031111,60413120000,60413120001,60413120010,60413120011,60413120013,60413120031,60413120033,60413121231,60413121233,60413130220,60413130222,60413130231,60413130233,60413132101,60413132110,60413132111,60413133200,60413133201,60413133230,60413133231,60413133320,60413133321,60413133323,60413412130,60413412131,60413412132,60413413010,60413413012,60413413020,60413413200,60413413202,60413413220,60413413222,60413430132,60413430310,60413430312,60413430330,60413430332,60413431000,60413431002,60413432100,60413432101,60413432130,60413432132,60413432310,60413432312,60413433220,60413433222,60414201230,60414201231,60414201233,60414203011,60414203013,60414203031,60414203033,60414203211,60414203300,60414203301,60414203310,60414203311,60414203313,60414203331,60414211030,60414211032,60414211131,60414211133,60414211202,60414211220,60414211222,60414212130,60414212131,60414212220,60414212221,60414212230,60414212231,60414212300,60414212301,60414212302,60414212320,60414213000,60414300230,60414300231,60414302120,60414302121,60414302123,60414302301,60414302310,60414302311,60414303020,60414303021,60414303022,60414303030,60414303031,60414303120,60414303121,60414303200,60414303330,60414303331,60414303333,60414313330,60414313331,60414313332,60414400330,60414400331,60414401220,60414401221,60414401231,60414402020,60414402021,60414402022,60414402030,60414402031,60414402100,60414402101,60414402200,60414403100,60414403101,60414403103,60414403121,60414403130,60414403131,60414411000,60414411002,60414411003,60414411012,60414411030,60414411032,60414411033,60414411122,60414411300,60414411302,60414411303,60414412020,60414412021,60414412230,60414412231,60414412310,60414412311,60414412312,60414412320,60414412321,60414412323,60414412330,60414412332,60414413010,60414413011,60414413012,60414413020,60414413021,60414413022,60414413030,60414413100,60414413101,60414413200,59415420312,59415420313,
009,00,,509020312,139950000,511650000,145650000,42,48,72,141,240,572,584144,584154,584155,584166,584176,594127,594156,594165,594166,594175,594176,604105,604114,604115,604125,604135,594146,594136,594126,594145,594155,604145,604136,604126,604116,604106,594177,594167,594157,594147,594137,594220,594107,584177,584145,584146,594230,594210,584167,584157,594117,584156,5841533,5841640,5841641,5841650,5841651,5841653,5941051,5941060,5941061,5941063,5941161,5941162,5941163,5941433,5941541,5941543,5941641,6041043,6041241,5941353,6041551,6041462,6041460,6041172,6041072,6041070,6041071,5942600,5942502,5942500,5942402,5942400,5942002,5841472,5841353,5841351,5841362,5942000,5942003,5842702,5842700,5842602,5841473,5841470,5841363,5841360,5841262,6041170,58415313,58415323,58416301,58416311,58416420,58416421,58416430,58416431,58416520,58416521,58417511,58417513,58417531,58417533,59410530,59410531,59410620,59410621,59410623,59411533,59411601,59411602,59411603,59414312,59414420,59414422,59414423,59414432,59415400,59415401,59415403,59416401,59416403,59416421,59416430,59416431,59416433,59417411,59417433,60410411,60410412,60410413,60412400,60412401,60412403,60414431,59414433,59414431,59415423,59415421,60415600,60414610,60414612,60412700,60412702,60413700,60412722,60412720,59427000,59426022,59427002,59427020,59427022,60420000,60410730,59426020,58413523,58413522,58413521,58413503,58412533,58412532,584133333,584134222,584134223,584134232,584134233,584134322,584134323,584134331,584134332,584134333,584135202,584143111,584143113,584143131,584143133,584153033,584153113,584153122,584153123,584153211,584153213,584163100,584163101,584163103,584163130,584163131,584164230,584164231,584164320,584164321,584164330,584164331,584165220,584165221,584165230,584165231,584175101,584175123,584175301,584175303,584175321,584175322,584175323,594105011,594105013,594105031,594105033,594106220,594106221,594106223,594115131,594115133,594115311,594115312,594115313,594116001,594116002,594116003,594143031,594143033,594143132,594143211,594143212,594143213,594143231,594144210,594144212,594144213,594144302,594144303,594153111,594154020,594154021,594154023,594164021,594164023,594164201,594164202,594164203,594164321,594164323,594174101,594174131,594174133,594174311,594174312,594174313,594174323,604104033,604104101,604104102,604104103,604104211,604104213,604104231,604104233,604113131,604113133,604113311,604113313,604124021,604124023,604124210,604124211,604124300,604124301,604124310,604124311,604124313,604134131,604134133,604134311,604134312,604134313,604134330,604134331,604134333,604144133,604144330,604144331,604144333,604155001,604155010,604155011,604155013,604155031,594144133,594144131,594135233,594135133,594135231,594135132,594135131,594125331,594125313,594125311,594125312,594154201,584135013,584135011,584135203,5841333303,5841333312,5841333321,5841333323,5841343131,5841343132,5841343133,5841343203,5841343212,5841343213,5841343301,5841343302,5841343303,5841352002,5841352003,5841431123,5841431301,5841431303,5841431321,5841431323,5841433101,5841433110,5841433111,5841433113,5841433131,5841433133,5841433311,5841433313,5841433331,5841433333,5841530312,5841530321,5841530323,5841531111,5841531112,5841531113,5841531121,5841531123,5841531211,5841531212,5841531213,5841532033,5841532101,5841532103,5841532121,5841532122,5841532123,5841532233,5841630011,5841630013,5841630031,5841630033,5841630211,5841630300,5841631020,5841631021,5841631210,5841631211,5841631321,5841631330,5841631331,5841631333,5841633111,5841633113,5841633131,5841633133,5841642210,5841642211,5841642213,5841643220,5841643221,5841652331,5841751001,5841751031,5841751033,5841751211,5841751212,5841751213,5841752331,5841752333,5841753202,5841753203,5941050301,5941050303,5941052110,5941052111,5941052113,5941052131,5941052133,5941053311,5941062221,5941062223,5941151131,5941151132,5941151133,5941151321,5941151323,5941153101,5941153102,5941153103,5941160001,5941160002,5941160003,5941251111,5941430303,5941430321,5941430323,5941431020,5941431022,5941431023,5941431032,5941431033,5941431302,5941432101,5941432103,5941432301,5941432303,5941432321,5941432330,5941432331,5941442112,5941442113,5941443012,5941443013,5941531010,5941531011,5941531100,5941531101,5941531131,5941531133,5941540220,5941540221,5941640011,5941640013,5941640031,5941640032,5941640033,5941642002,5941642003,5941642210,5941642211,5941642300,5941642301,5941643200,5941643201,5941741001,5941741031,5941741300,5941741301,5941741303,5941741321,5941741323,5941743101,5941743103,5941743212,5941743213,6041040133,6041040311,6041040313,6041040321,6041040323,6041041002,6041041003,6041042101,6041042103,6041042121,6041042123,6041042301,6041042303,6041042321,6041042322,6041042323,6041131301,6041131303,6041131321,6041131323,6041133100,6041133101,6041133103,6041133311,6041133313,6041133331,6041133333,6041240201,6041240203,6041240220,6041240221,6041242010,6041242011,6041242131,6041243031,6041243120,6041243121,6041243123,6041243301,6041243310,6041243311,6041243313,6041243331,6041243333,6041341111,6041341113,6041341131,6041341133,6041341303,6041341321,6041341323,6041343101,6041343102,6041343103,6041343211,6041343320,6041343321,6041343323,6041441110,6041441111,6041441113,6041441131,6041441133,6041441311,6041441312,6041441313,6041441321,6041441322,6041441323,6041443011,6041443013,6041443031,6041443033,6041443211,6041443213,6041443320,6041443321,6041443323,6041541111,6041550000,6041550001,6041550121,5841352013,5841352012,58413333101,58413333103,58413333110,58413333112,58413333130,58413333132,58413422123,58413422132,58413422133,58413423022,58413423023,58413423032,58413423033,58413423122,58413423123,58413423132,58413423133,58413431131,58413431133,58413431232,58413431233,58413431301,58413431302,58413431303,58413432012,58413432013,58413432022,58413432023,58413432102,58413432103,58413432112,58413432113,58413433002,58413433003,58414313021,58414313023,58414313201,58414313203,58414313221,58414313223,58414331121,58414331123,58414331301,58414331303,58414331321,58414331323,58414333101,58414333103,58414333121,58414333123,58414333301,58414333303,58414333321,58414333323,58415303032,58415303033,58415303132,58415303133,58415311023,58415311032,58415311033,58415311101,58415311102,58415311103,58415311201,58415311203,58415311221,58415311223,58415312022,58415312023,58415312031,58415312032,58415312033,58415321201,58415321203,58415322312,58415322313,58416300121,58416300321,58416300323,58416303010,58416303012,58416310220,58416310221,58416310222,58416310230,58416310231,58416310233,58416312011,58416312013,58416312131,58416312133,58416313201,58416313203,58416313321,58416313323,58416331101,58416331103,58416331121,58416331123,58416331301,58416331303,58416331321,58416331323,58416423301,58416423310,58416423311,58416432220,58416432221,58416432223,58416432230,58416432231,58416432232,58416432300,58416432301,58416432302,58416432320,58416433211,58416433300,58416433301,58416433310,58416433311,58416522211,58416522300,58416523211,58416523300,58416523301,58416523303,58416523321,58416523330,58416523331,58417410001,58417410010,58417510000,58417510001,58417510003,58417510021,58417510030,58417510031,58417510033,58417510211,58417510300,58417510301,58417510303,58417510321,58417510323,58417512101,58417512102,58417512103,58417512231,58417512233,58417523123,58417523132,58417523133,58417523301,58417523303,58417523321,58417523323,58417530001,58417530010,58417530011,58417530013,58417530031,58417530033,58417532002,58417532003,58417532012,58417532013,59410501011,59410501013,59410501031,59410501033,59410501211,59410501213,59410501231,59410501232,59410501233,59410503210,59410503211,59410503213,59410503231,59410503233,59410521011,59410521013,59410521121,59410521123,59410521301,59410521303,59410523110,59410523111,59410532000,59410532001,59410532010,59410532011,59410532013,59410532031,59410532100,59410532101,59410532110,59410532111,59410533000,59410533001,59410533010,59410533011,59410533013,59410533031,59410533100,59410533101,59410533130,59410533131,59410622200,59410622201,59410622203,59410622221,59410622223,59411511123,59411511132,59411511133,59411511213,59411511231,59411511233,59411511301,59411511302,59411511303,59411513011,59411513013,59411513031,59411513033,59411530313,59411530331,59411530333,59411531002,59411531003,59411532111,59411532113,59411532131,59411532133,59411532311,59411532313,59411600001,59411600002,59411600003,59414301311,59414301313,59414301331,59414301333,59414303222,59414303223,59414313000,59414313002,59414313030,59414313032,59414313033,59414313322,59414313323,59414313332,59414313333,59414321000,59414321001,59414321003,59414321021,59414321023,59414323001,59414323003,59414323021,59414323023,59414323201,59414323203,59414323221,59414323230,59414323231,59414323232,59414323320,59414323321,59414323330,59414323331,59414323333,59414402222,59414402223,59414402232,59414402233,59414402322,59414402323,59414402332,59414402333,59414403222,59414403223,59414403232,59414403233,59414403322,59414421100,59414421102,59414421103,59414421112,59414430113,59415301010,59415301111,59415310000,59415310001,59415310010,59415310011,59415310013,59415310031,59415310120,59415310121,59415310130,59415310131,59415311020,59415311021,59415311030,59415311031,59415311300,59415311301,59415311303,59415311321,59415311323,59415313111,59415313113,59415313131,59415313133,59415402221,59415402230,59415402231,59415402233,59415420011,59415420013,59415420031,59415420033,59415420201,59415420210,59415420211,59415420300,59415422133,59415422311,59415422313,59415422331,59415422333,59416331311,59416331313,59416331331,59416331333,59416400233,59416402011,59416402013,59416422011,59416422013,59416422130,59416422131,59416432021,59416432030,59416432031,59416432033,59416432211,59416432213,59416432231,59416432233,59417410001,59417410003,59417410031,59417410033,59417410331,59417410333,59417412111,59417412113,59417412131,59417413020,59417413021,59417413023,59417413201,59417413203,59417413221,59417413223,59417430133,59417430311,59417430313,59417430331,59417430333,59417431001,59417431003,59417431021,59417431022,59417431023,59417432111,59417432112,59417432113,59417432231,59417432233,60410401312,60410401313,60410403121,60410403123,60410410002,60410410003,60410410011,60410410012,60410410013,60410421203,60410421221,60410421223,60410422222,60410422223,60410422232,60410422233,60410422322,60410422323,60410422331,60410422332,60410422333,60410423001,60410423003,60410423021,60410423023,60410423201,60410423203,60411311113,60411311131,60411311133,60411311311,60411311313,60411311331,60411311333,60411312333,60411313021,60411313023,60411313201,60411313203,60411313221,60411313222,60411313223,60411330111,60411330113,60411331021,60411331023,60411331210,60411331211,60411333100,60411333101,60411333103,60411333121,60411333123,60411333301,60411333303,60411333321,60411333323,60412311111,60412311113,60412311131,60412311133,60412311311,60412311313,60412311331,60412402000,60412402001,60412402003,60412402021,60412402023,60412402231,60412402233,60412420011,60412420013,60412420130,60412420131,60412420133,60412420311,60412420313,60412420331,60412421200,60412421201,60412421210,60412421211,60412421300,60412421301,60412421303,60412421321,60412421330,60412421331,60412430200,60412430201,60412430210,60412430211,60412430300,60412430301,60412430330,60412430331,60412431220,60412431221,60412431223,60412433001,60412433003,60413412133,60413413011,60413413013,60413413021,60413413022,60413413023,60413413201,60413413203,60413413221,60413413223,60413430130,60413430131,60413430133,60413430311,60413430313,60413430331,60413430333,60413431001,60413431003,60413432102,60413432103,60413432131,60413432133,60413432311,60413432313,60413433221,60413433223,60414411001,60414411010,60414411011,60414411013,60414411031,60414411120,60414411121,60414411123,60414411301,60414412313,60414412331,60414412333,60414413013,60414413023,60414413031,60414413032,60414413033,60414413102,60414413103,60414413201,60414413202,60414413203,60414430101,60414430103,60414430121,60414430123,60414430301,60414430303,60414430321,60414430323,60414432101,60414432103,60414432121,60414432310,60414432311,60415411101,60415411103,60415500031,60415500033,60415500310,60415500311,60415501200,60415501201,60415501203,60415501221,60415501230,60415501231,60415503300,60415503301,60415503310,60415503311,59415420301,59415420311,59415420310,58413520113,58413520111,
010,00,Ȭ,506587500,144787500,510187500,149625000,48,55,86,88,193,388,604067,604140,604150,604151,604152,604153,604160,604161,604162,604170,604171,604172,614077,614100,614101,614102,614111,614112,614122,614132,614142,614170,614172,624007,624100,614076,614066,614067,614160,614171,614162,604173,604163,614121,614152,624017,624101,614173,614056,614131,614161,614057,614151,614141,614150,604164,624110,624103,6040572,6040573,6040770,6040771,6041300,6041302,6041410,6041412,6041413,6041422,6041423,6041432,6041433,6041442,6041540,6041542,6041543,6141100,6141101,6141103,6240271,6240270,6240161,6240063,6240061,6240060,6241110,6241021,6241131,6141632,6141630,6141532,6141530,6141432,6141430,6141332,6141330,6141232,6141230,6141132,6141130,6141032,6141030,6141031,6041552,6141201,6241020,6240163,6241140,6241133,6241130,6241112,6241111,6241022,6141403,60403711,60403713,60403731,60403733,60405702,60405703,60405712,60405713,60407721,60407731,60407733,60412022,60413012,60413030,60413032,60413033,60413122,60413123,60414110,60414112,60414113,60414202,60415410,60415412,60415413,60415502,61400711,61400723,61400731,61400732,61400733,61401711,61411020,61411021,61411023,62410231,62410233,62410230,62412000,62402730,62402721,62402720,62402611,62400621,62400623,61406533,61406531,61406513,61406511,61405533,61405531,61405513,61407511,61407513,61416332,61416330,61416312,61416310,61415332,61415330,61415312,61415310,61412031,61410332,61410330,61411310,61411312,61411330,61411332,61414332,60417400,60417402,60416500,60416502,60416501,60415532,60415530,61412033,62410422,62410420,62410402,62412001,62412002,62402613,62401601,61414330,604027331,604027333,604037101,604037103,604037123,604037301,604047110,604047111,604047313,604047331,604047333,604057002,604057003,604057011,604057012,604057013,604057102,604057103,604057111,604057112,604057113,604066133,604066311,604076111,604076113,604077201,604077202,604077203,604077220,604077221,604077300,604077301,604077303,604120202,604120232,604120233,604130102,604130103,604130310,604130312,604130313,604131202,604131203,604131320,604131322,604131323,604141110,604141112,604141113,604142113,604142131,604142132,604142133,604143020,604143022,604144023,604144030,604144032,604144033,604144300,604144302,604144320,604144322,604154110,604154112,604154113,604155002,614007131,614007133,614007302,614007303,614017011,614017100,614017101,614017130,614017131,614017133,614017311,614110221,614110223,614120011,614120013,614120031,614120033,614120300,604155030,604155032,614120301,6040273132,6040273133,6040273301,6040273303,6040273321,6040273322,6040273323,6040371001,6040371003,6040371021,6040371210,6040371211,6040371213,6040371221,6040371223,6040373001,6040373031,6040373033,6040373211,6040373213,6040373231,6040471013,6040471031,6040471120,6040471130,6040471131,6040471133,6040471311,6040471313,6040471333,6040473111,6040473112,6040473113,6040473303,6040473321,6040473323,6040570002,6040570003,6040570012,6040570013,6040570102,6040570103,6040571002,6040571003,6040571012,6040571013,6040661311,6040661313,6040663101,6040663131,6040663132,6040663133,6040663311,6040663313,6040663331,6040663333,6040761310,6040761311,6040772000,6040772001,6040772003,6040772300,6040772301,6040772302,6040773020,6040773021,6040773023,6040773211,6040773213,6040773231,6040773233,6041202030,6041202032,6041202302,6041301002,6041301003,6041301012,6041301013,6041301102,6041301120,6041301122,6041301320,6041301322,6041301323,6041303110,6041303112,6041303113,6041312002,6041312122,6041313212,6041313213,6041313322,6041411110,6041411112,6041411113,6041420020,6041420022,6041420023,6041420032,6041420033,6041420122,6041420300,6041420302,6041420320,6041420322,6041420323,6041420332,6041421112,6041421121,6041421123,6041421231,6041421233,6041421301,6041421302,6041421303,6041430020,6041430022,6041430232,6041430233,6041430321,6041430322,6041430323,6041430330,6041430332,6041440211,6041440212,6041440213,6041440221,6041440222,6041440223,6041441220,6041441222,6041443230,6041443232,6041443233,6041443322,6041541112,6041541113,6041550002,6041550030,6041550032,6041550033,6140071233,6140071300,6140071301,6140071303,6140071321,6140071322,6140071323,6140072113,6140072122,6140072123,6140072131,6140072132,6140072133,6140072213,6140073002,6140073003,6140073011,6140073012,6140073013,6140170100,6140170101,6140170103,6140171021,6140171030,6140171031,6140171033,6140171211,6140171213,6140171320,6140171321,6140171323,6140173101,6140173103,6140173121,6140173130,6140173131,6140173133,6141102200,6141102201,6141200010,6141200011,6141200100,6141200101,6141200103,6141200121,6141200301,6141200303,6141200321,6141202111,6041550332,6041550333,60402731231,60402731233,60402732233,60402732313,60402732322,60402732323,60402732331,60402732332,60402732333,60402733202,60402733203,60403710231,60403710233,60403712011,60403712013,60403712031,60403712120,60403712121,60403712123,60403730031,60403730033,60403730301,60403730303,60403730321,60403730323,60403732101,60403732103,60403732121,60403732123,60403732301,60403732330,60403732331,60403732333,60404710111,60404710112,60404710113,60404710331,60404711210,60404711212,60404711220,60404711221,60404711321,60404711323,60404713101,60404713103,60404713121,60404713123,60404713301,60404713310,60404713311,60404713313,60404713321,60404713323,60404723322,60404723323,60404723332,60404723333,60404731101,60404731102,60404731103,60404732222,60405611113,60405611131,60405611133,60405611311,60405611313,60405611331,60405611333,60405613111,60405613113,60405613131,60405613133,60405613311,60405613313,60405613331,60405613333,60405631111,60405631113,60405631131,60405631133,60405631311,60405631313,60405631331,60405631333,60405633111,60405633113,60405633131,60405633133,60405633311,60405633313,60405700002,60405700003,60405700012,60405700013,60405700102,60405700103,60405700112,60405700113,60405701002,60405701003,60405701012,60405701013,60405710000,60405710002,60405710003,60405710012,60405710013,60405710102,60405710103,60405710112,60405710113,60405711022,60405711023,60405711032,60405711033,60406611311,60406611313,60406611331,60406611333,60406613101,60406613103,60406613121,60406613122,60406613123,60406613213,60406613223,60406613231,60406613232,60406613233,60406631001,60406631003,60406631031,60406631300,60406631301,60406631303,60406633100,60406633101,60406633103,60406633121,60406633123,60406633301,60406633303,60406633321,60406633322,60406633323,60407613131,60407613133,60407720020,60407720021,60407723100,60407723102,60407730220,60407730221,60407730222,60407732101,60407732103,60407732121,60407732123,60412023000,60412023002,60412023032,60412023033,60412023122,60412023123,60412023132,60412023133,60412032222,60413010000,60413010002,60413010003,60413010012,60413010013,60413010102,60413010103,60413010112,60413011030,60413011032,60413011210,60413013000,60413013001,60413013002,60413013020,60413013022,60413013023,60413013212,60413013213,60413013302,60413013320,60413013322,60413013323,60413031112,60413031113,60413120002,60413120003,60413120012,60413120030,60413120032,60413121230,60413121232,60413130221,60413130223,60413130230,60413130232,60413132100,60413132102,60413132103,60413132112,60413132113,60413133202,60413133203,60413133232,60413133233,60413133322,60414201232,60414203010,60414203012,60414203030,60414203032,60414203210,60414203212,60414203213,60414203302,60414203303,60414203312,60414203330,60414203332,60414203333,60414211031,60414211033,60414211130,60414211132,60414211200,60414211201,60414211203,60414211221,60414211223,60414212132,60414212133,60414212222,60414212223,60414212232,60414212233,60414212303,60414212321,60414212322,60414212323,60414213001,60414213002,60414213003,60414300232,60414300233,60414302122,60414302300,60414302302,60414302303,60414302312,60414302313,60414303023,60414303032,60414303033,60414303122,60414303123,60414303201,60414303202,60414303203,60414303332,60414313333,60414400332,60414400333,60414401222,60414401223,60414401230,60414401232,60414401233,60414402023,60414402032,60414402033,60414402102,60414402103,60414402201,60414402202,60414402203,60414403102,60414403120,60414403122,60414403123,60414403132,60414403133,60414412022,60414412023,60414412232,60414412233,60414412322,60414430100,60414430102,60414430120,60414430122,60414430300,60414430302,60414430320,60414430322,60414432100,60414432102,60414432120,60414432122,60414432123,60414432312,60414432313,60415411100,60415411102,60415500030,60415500032,60415500312,60415500313,60415501202,60415501220,60415501222,60415501223,60415501232,60415501233,61400710110,61400710111,61400710113,61400710131,61400710133,61400710311,61400710313,61400710331,61400710333,61400712111,61400712113,61400712313,61400713021,61400713023,61400713201,61400713202,61400713203,61400721121,61400721123,61400721202,61400721203,61400721212,61400721213,61400721301,61400721302,61400721303,61400722112,61400722113,61400722310,61400722311,61400730101,61400730103,61401701020,61401701021,61401710321,61401710323,61401712103,61401712121,61401712123,61401712310,61401712311,61401712313,61401712331,61401713220,61401713221,61401713223,61401731001,61401731321,61401731323,61401733111,61401733113,61411022030,61411022031,61412001232,61412001233,61412003230,61412003231,61412021100,61412021101,61412021103,60415503302,60415503303,60415503312,60415503313,61412030333,61412030331,61412030313,61412030311,
011,00,Ŀ,505181250,146156250,508050000,148650000,16,20,56,72,147,214,614006,614015,614027,614054,614016,614064,614037,614025,614026,614035,614036,614046,614047,614130,614045,614063,6040763,6140070,6140172,6140343,6140441,6140442,6140443,6140533,6140053,6140051,6140052,6140043,6140650,6140552,6140550,6141402,6141400,6141401,6140652,6140730,60407623,61400720,61401413,61401431,61401433,61401700,61401702,61401703,61401730,61401732,61402411,61402413,61402431,61402433,61403411,61403413,61403423,61404401,61404403,61405311,61405313,61405321,61405322,61405323,61412002,61412020,61412022,61412023,61400503,61400502,61400501,61400413,61400412,61400421,61401411,61412032,61407401,61407410,61407411,61406532,61406530,61406510,61406512,61405532,61405530,61405510,61405512,61405511,61407500,61407501,61407312,61407310,61407400,61407311,61407213,61407211,604076123,604076130,604076132,604076133,604077222,604077223,604077232,604077233,604077320,604077322,614007100,614007102,614007120,614007122,614007210,614007220,614007222,614014303,614014321,614014323,614017012,614017013,614017120,614017122,614017330,614017332,614017333,614024101,614024321,614034121,614034122,614034123,614043333,614044003,614044021,614044023,614053033,614053103,614053122,614053123,614053201,614053202,614053203,614062313,614062331,614110222,614120000,614120002,614120003,614120210,614120212,614120213,614120302,614053121,614005003,604075232,604075233,604075322,604075323,614004033,614004231,614014301,614014123,614014121,614014103,614014101,614014100,614062333,614072123,614072121,614072103,614072101,6040761122,6040761213,6040761312,6040762132,6040762133,6040762213,6040762223,6040762231,6040762232,6040762233,6040772303,6040772311,6040772312,6040772313,6040773230,6040773232,6140071010,6140071012,6140071030,6140071032,6140071210,6140071212,6140071213,6140071230,6140071232,6140072110,6140072111,6140072210,6140072212,6140072230,6140072232,6140072233,6140073000,6140073001,6140143021,6140143023,6140171020,6140171022,6140171023,6140171230,6140171232,6140173102,6140173120,6140173122,6140173123,6140173310,6140173312,6140173313,6140241031,6140243013,6140243031,6140243032,6140243033,6140243201,6140243230,6140243231,6140243233,6140340331,6140340333,6140341011,6140341013,6140341023,6140341031,6140341032,6140341033,6140341201,6140341202,6140341203,6140342111,6140342113,6140342123,6140342131,6140342132,6140342133,6140342231,6140342233,6140433113,6140433131,6140433133,6140433311,6140433313,6140433321,6140433322,6140433323,6140440011,6140440012,6140440013,6140440222,6140440223,6140523133,6140523311,6140523313,6140523331,6140523333,6140530233,6140530321,6140530322,6140530323,6140531011,6140531012,6140531013,6140531203,6140532003,6140621111,6140621113,6140621131,6140621133,6140621311,6140621331,6140621333,6140623111,6140623113,6140623303,6140623321,6140623322,6140623323,6141102202,6141200012,6141200013,6141200102,6141200120,6141200122,6141200300,6141200302,6141200320,6141200322,6141202112,6141202113,6141203030,6141203032,6140042331,6140042301,6140042031,6140042033,6140042300,6140040323,6140040313,6140050013,6040753322,6040753323,6040753332,6040753333,6040762222,6140623233,6140040311,6140621313,6140623232,60407611232,60407611233,60407612033,60407612112,60407612113,60407612122,60407612123,60407612211,60407612213,60407612231,60407612232,60407612233,60407613130,60407613132,60407621222,60407621223,60407621231,60407621232,60407621233,60407621311,60407621313,60407622112,60407622113,60407622123,60407622212,60407622213,60407622301,60407622302,60407622303,60407720022,60407720023,60407723101,60407723103,60407730223,60407732100,60407732102,60407732120,60407732122,61400710112,61400710130,61400710132,61400710310,61400710312,61400710330,61400710332,61400712110,61400712112,61400712310,61400712311,61400712312,61400713020,61400713022,61400713200,61400721120,61400721122,61400721200,61400721201,61400721210,61400721211,61400721300,61400722110,61400722111,61400722312,61400722313,61400730100,61400730102,61401430032,61401430033,61401701022,61401701023,61401710320,61401710322,61401712100,61401712101,61401712102,61401712120,61401712122,61401712312,61401712330,61401712332,61401712333,61401713222,61401731000,61401731002,61401731003,61401731320,61401731322,61401733110,61401733112,61402410301,61402410303,61402410331,61402410333,61402412111,61402412113,61402412131,61402412133,61402412311,61402412313,61402412331,61402412333,61402430103,61402430111,61402430112,61402430113,61402430121,61402430123,61402430232,61402430233,61402430301,61402430302,61402430303,61402432030,61402432031,61402432320,61402432321,61402432323,61403403323,61403410101,61403410103,61403410121,61403410123,61403410301,61403410303,61403412001,61403412003,61403421101,61403421103,61403421121,61403421123,61403421301,61403421303,61403422131,61403422133,61403422301,61403422303,61403422321,61403422323,61404331112,61404331113,61404332332,61404332333,61404333032,61404333033,61404333121,61404333122,61404333123,61404333202,61404333203,61404400101,61404400102,61404400103,61404402031,61404402033,61404402202,61404402203,61404402211,61404402212,61404402213,61405233101,61405233103,61405233121,61405233123,61405233301,61405233303,61405302233,61405302312,61405302313,61405302322,61405302323,61405303032,61405303033,61405303122,61405303123,61405303132,61405303133,61405303202,61405303203,61405312003,61405312012,61405312013,61405312021,61405312022,61405312023,61405320011,61405320013,61405320021,61405320023,61406231101,61406231103,61406231121,61406231123,61406232313,61406233012,61406233013,61406233202,61406233203,61411022032,61411022033,61412001230,61412001231,61412003232,61412003233,61412021102,61412030310,61412030312,61412030330,61412030332,61406232303,61406232312,61400401332,61400403101,61400403103,61406232302,
012,00,,503325000,145406250,507150000,148650000,24,41,70,124,213,389,604060,604061,604062,604063,604064,604065,604070,604071,604072,604073,604074,614002,614003,614013,614023,614033,614012,614022,614042,603977,614001,614000,603967,614032,6040502,6040512,6040513,6040522,6040533,6040542,6040543,6040550,6040552,6040553,6040562,6040660,6040662,6040760,6140140,6140142,6140240,6140242,6140430,6140431,6140432,6040750,6040751,6140110,6140101,6140100,6139073,6139071,6140113,6140520,6140513,6140522,6140511,6039763,6039761,6039663,6039573,6039572,6140111,6139070,6140521,60395713,60405031,60405032,60405033,60405102,60405103,60405112,60405113,60405202,60405203,60405212,60405230,60405232,60405233,60405322,60405323,60405401,60405402,60405403,60405412,60405413,60405512,60405513,60406610,60406612,60406630,60406632,60407610,60407620,61403400,61403401,61403402,61403420,61404330,61405300,61405301,61400410,61400411,61400422,60407520,60407521,60407522,60407530,60407531,61400400,61400402,60395712,60395703,61401121,61401120,61402111,61402113,61401030,61401021,60395702,61402131,61406201,61406203,61406221,61406223,61407201,61406111,61406200,61402110,61402133,61406230,61406210,61406212,61405230,61405232,603957103,603957112,603957113,604044231,604044232,604044233,604045221,604045223,604045230,604045232,604050002,604050003,604050020,604050022,604050023,604050113,604050131,604050133,604050302,604050303,604051102,604051103,604051112,604052312,604052313,604053122,604053123,604053131,604053132,604053133,604053212,604054002,604054003,604054102,604054103,604054112,604054113,604055102,604055103,604055110,604055112,604056020,604056022,604056023,604056033,604056322,604066110,604066112,604066130,604066312,604066330,604066332,604076110,604076210,604076211,604076220,614014120,614014122,614014320,614014322,614024100,614024102,614024120,614024122,614024300,614024322,614034030,614034031,614034032,614034100,614034210,614034220,614034222,614043310,614043312,614043320,614043321,614043322,614044000,614044002,614053020,614053021,614053100,614053102,614005000,614005002,604075230,604075231,604075320,604075321,614004030,614004232,614014102,614004200,614004201,614004202,604075330,604075331,614004010,614004011,614004012,603957102,603957013,603957012,603957003,603957002,614072100,614072102,614062320,614062321,614062322,614062310,614062312,614062130,614062132,614062110,614062112,614052330,614052332,614052310,614052311,614052312,614072120,614072122,6039571102,6039571103,6040442133,6040442231,6040442233,6040442301,6040442302,6040442303,6040443022,6040443200,6040443202,6040443220,6040452201,6040452203,6040452221,6040452223,6040452330,6040452332,6040452333,6040453222,6040453322,6040453323,6040453332,6040500003,6040500010,6040500012,6040500210,6040500212,6040500320,6040500322,6040500323,6040501233,6040501301,6040501303,6040501321,6040501322,6040501323,6040503002,6040503003,6040503011,6040503012,6040503013,6040510022,6040510023,6040510031,6040510032,6040510033,6040510120,6040510122,6040510123,6040510132,6040510133,6040511130,6040511132,6040511133,6040520023,6040520032,6040521020,6040521022,6040521023,6040521032,6040521033,6040521300,6040521302,6040521320,6040521322,6040523100,6040523102,6040523103,6040531131,6040531132,6040531133,6040531202,6040531203,6040532020,6040532022,6040532023,6040532031,6040532032,6040532033,6040532113,6040532131,6040532132,6040532133,6040540011,6040541002,6040541003,6040541103,6040541112,6040541113,6040551000,6040551002,6040551012,6040551013,6040551110,6040551112,6040551130,6040551132,6040551133,6040560022,6040560212,6040560312,6040560313,6040560320,6040560322,6040560323,6040563202,6040563230,6040563232,6040661112,6040661113,6040661130,6040661132,6040661320,6040663102,6040761120,6040761121,6040761200,6040761201,6040761202,6040761210,6040761220,6040761222,6040762120,6040762121,6040762130,6040762210,6040762220,6140143000,6140143001,6140143002,6140143020,6140143022,6140241032,6140241210,6140241212,6140241230,6140241232,6140243020,6140243021,6140243022,6140243200,6140243202,6140340330,6140341020,6140341021,6140341022,6140342120,6140342121,6140342122,6140342210,6140342211,6140342212,6140433110,6140433112,6140433130,6140433132,6140433230,6140433231,6140433232,6140433300,6140433301,6140433302,6140433310,6140440200,6140440201,6140440202,6140530220,6140530221,6140530222,6140530230,6140530300,6140530301,6140530302,6140530310,6140530311,6140531010,6140532000,6140042330,6140042332,6140042333,6140042302,6140042303,6140042030,6140042032,6140040320,6140040321,6140040322,6140040312,6140050010,6140050011,6140050012,6040753320,6040753321,6040753330,6040753331,6140040130,6140040131,6140040132,6140523131,6140523130,6140523132,6140621332,6140621330,6140623300,6140623302,6140523332,6140621110,6140621112,6140621130,6140621312,6140621310,6140621132,60395710022,60395710023,60395710032,60395710033,60395710122,60395710123,60395710133,60395711002,60395711003,60395711012,60395711013,60395711102,60395711120,60395711122,60395711123,60395711132,60395711133,60404022322,60404022323,60404022332,60404422301,60404422303,60404422321,60404422323,60404430230,60404430232,60404432010,60404432012,60404432030,60404432032,60404432210,60404432220,60404432222,60404433333,60404522203,60404522221,60404522222,60404522223,60404523310,60404523312,60404523313,60404532202,60404532203,60404533202,60404533203,60404533212,60404533213,60404533302,60404533303,60404533312,60404533330,60404533332,60405000003,60405000012,60405000013,60405000021,60405000023,60405000110,60405000112,60405000130,60405000132,60405001200,60405001202,60405001220,60405001222,60405002110,60405002111,60405002112,60405002130,60405002132,60405003000,60405003212,60405003213,60405003322,60405003323,60405003332,60405003333,60405011211,60405011213,60405011231,60405011233,60405012312,60405012313,60405012323,60405013001,60405013003,60405013021,60405013023,60405013201,60405013202,60405013203,60405030002,60405030003,60405030012,60405030013,60405030101,60405030102,60405030103,60405100200,60405100202,60405110133,60405111022,60405111023,60405111032,60405200220,60405200222,60405200330,60405200332,60405201311,60405201313,60405201331,60405201333,60405213232,60405231010,60405231012,60405231013,60405231102,60405231120,60405231122,60405311231,60405311233,60405313011,60405313013,60405313031,60405313033,60405321112,60405321113,60405400022,60405400023,60405400032,60405400033,60405400101,60405400103,60405400122,60405400123,60405400131,60405400132,60405400133,60405410000,60405410002,60405410003,60405410012,60405410013,60405410102,60405410120,60405410122,60405410123,60405410132,60405410133,60405411012,60405411013,60405411022,60405411102,60405411103,60405411111,60405411112,60405411113,60405510012,60405510030,60405510032,60405510033,60405510102,60405510103,60405510112,60405510113,60405511110,60405511112,60405511130,60405511132,60405511310,60405511312,60405600230,60405600232,60405603031,60405603033,60405603211,60405603212,60405603213,60405612202,60405612220,60405612222,60405630000,60405630002,60405630020,60405630022,60405630200,60405630202,60405630220,60405630222,60405632000,60405632002,60405632030,60405632032,60405632033,60405632122,60405632123,60405632312,60405632330,60405632332,60405632333,60405633222,60405633223,60405633232,60405633233,60405633322,60406611100,60406611102,60406611103,60406611112,60406611113,60406611310,60406611312,60406611330,60406611332,60406613100,60406613102,60406613120,60406613210,60406613211,60406613212,60406613220,60406613221,60406613222,60406613230,60406631000,60406631002,60406631030,60406631032,60406631033,60406631302,60406633102,60406633120,60406633122,60406633300,60406633302,60406633320,60407611230,60407611231,60407612030,60407612031,60407612032,60407612110,60407612111,60407612120,60407612121,60407612210,60407612212,60407612230,60407621220,60407621221,60407621230,60407621310,60407621312,60407622110,60407622111,60407622120,60407622121,60407622122,60407622210,60407622211,60407622300,61401430030,61401430031,61402410300,61402410302,61402410330,61402410332,61402412110,61402412112,61402412130,61402412132,61402412310,61402412312,61402412330,61402412332,61402430100,61402430101,61402430102,61402430110,61402430120,61402430122,61402430230,61402430231,61402430300,61402432032,61402432033,61402432322,61403403320,61403403321,61403403322,61403410100,61403410102,61403410120,61403410122,61403410300,61403410302,61403412000,61403412002,61403421100,61403421102,61403421120,61403421122,61403421300,61403421302,61403422130,61403422132,61403422300,61403422302,61403422320,61403422322,61404331110,61404331111,61404332330,61404332331,61404333030,61404333031,61404333120,61404333200,61404333201,61404400100,61404402030,61404402032,61404402200,61404402201,61404402210,61405302230,61405302231,61405302232,61405302310,61405302311,61405302320,61405302321,61405303030,61405303031,61405303120,61405303121,61405303130,61405303131,61405303200,61405303201,61405312000,61405312001,61405312002,61405312010,61405312011,61405312020,61405320010,61405320012,61405320020,61405320022,61400401330,61400401331,61400401333,61400403100,61400403102,60395701133,60395701132,60395701123,60395701122,60395701022,60395701023,60395701033,60395701032,60395700133,60395700132,60395700122,60395700123,60395700033,60395700032,60395700023,60395700022,61405233100,61405233102,61405233120,61405233122,61405233300,61405233302,61406231122,61406231120,61406231102,61406231100,61406233201,61406233200,61406232311,61406232310,61406232301,61406232300,61406233010,61406233011,
013,00,,503550000,143240625,507585937,145809375,30,32,72,179,306,706,594063,594073,594074,604002,604003,604004,604005,604010,604011,604012,604013,604014,604015,604021,604022,604023,604024,604025,604031,604032,604033,604034,604035,604036,604041,604042,604043,604046,604030,604020,5940621,5940623,5940721,5940722,5940723,6040012,6040013,6040060,6040062,6040160,6040162,6040260,6040262,6040263,6040370,6040372,6040401,6040403,6040440,6040441,6040450,6040451,6040470,6040530,6039473,6040400,6039471,6039173,6039271,6039273,6039371,6039171,59405232,59405333,59406402,59406420,59406422,59406423,59406432,59406433,59407033,59407203,59407502,59407520,59407522,59407523,59407623,59407632,60400011,60400013,60400031,60400032,60400033,60400100,60400102,60400103,60400111,60400112,60400113,60400610,60400612,60400630,60400632,60401610,60401612,60401630,60401632,60402610,60402612,60402613,60402722,60402723,60404020,60404021,60404023,60404420,60404431,60404520,60404521,60404530,60404531,60404712,60404720,60404721,60404722,60404730,60405010,60405211,60405310,60405601,60405610,60393731,60393733,60394703,60394721,60394723,60390732,60390723,60391701,60391703,60391721,60391723,60391700,60390722,594052300,594052302,594052303,594052330,594052332,594053232,594053233,594053310,594053312,594053313,594053322,594053323,594054202,594054220,594054222,594062213,594062231,594062233,594064000,594064002,594064003,594064030,594064032,594064210,594064212,594064213,594064302,594064303,594064312,594064313,594065220,594065222,594070312,594070321,594070323,594071222,594071333,594072003,594072011,594072012,594072013,594072021,594072022,594072023,594075000,594075002,594075003,594075030,594075032,594075210,594075212,594075213,594075302,594075320,594075322,594075323,594076201,594076203,594076212,594076213,594076221,594076222,594076223,594076302,594076303,603907303,603907330,603907332,604000101,604000103,604000121,604000123,604000231,604000232,604000233,604000301,604000302,604000303,604001011,604001012,604001013,604001102,604001103,604016112,604016130,604016132,604016310,604016312,604016330,604016332,604026110,604026112,604026113,604027200,604027202,604027203,604037302,604037320,604037322,604040220,604040221,604040222,604044210,604044211,604044212,604044220,604044221,604044222,604044300,604044301,604044303,604044321,604044323,604044330,604044331,604044332,604045231,604045320,604045321,604045323,604045330,604045331,604047100,604047102,604047130,604047132,604047230,604047231,604047232,604047310,604047312,604047320,604047321,604047323,604050010,604050011,604050013,604050031,604050110,604050111,604050120,604050121,604050122,604051000,604051001,604051010,604051011,604051100,604051111,604052000,604052001,604052010,604052011,604052012,604052100,604052101,604052131,604052133,604053110,604053111,604053121,604053200,604053201,604053210,604056000,604056001,604056003,604056110,604056112,604056120,604056121,604056123,604056130,604056132,604056301,604056303,604056310,604056312,604056330,5940522331,5940522332,5940522333,5940523012,5940523013,5940523120,5940523122,5940523330,5940523332,5940523333,5940532222,5940532223,5940532232,5940532233,5940532311,5940532312,5940532313,5940533033,5940533110,5940533112,5940533200,5940533202,5940533203,5940533211,5940533212,5940533213,5940542032,5940542210,5940542212,5940542230,5940620110,5940620111,5940620113,5940620133,5940620311,5940620312,5940620313,5940620330,5940620331,5940620333,5940622111,5940622112,5940622113,5940622321,5940622323,5940640122,5940642110,5940642112,5940642113,5940643102,5940643103,5940643112,5940643113,5940652020,5940652022,5940652023,5940703031,5940703032,5940703033,5940703130,5940703132,5940703133,5940703201,5940703203,5940703221,5940703223,5940712202,5940712232,5940713311,5940713312,5940713313,5940720013,5940720101,5940720102,5940720103,5940750122,5940750332,5940750333,5940752110,5940752112,5940752113,5940753002,5940753003,5940753210,5940753212,5940753213,5940753313,5940753322,5940753323,5940753331,5940753332,5940753333,5940762001,5940762002,5940762003,5940762020,5940762021,5940762023,5940762100,5940762102,5940762103,5940762112,5940762113,5940762201,5940762202,5940762203,5940763003,5940763011,5940763012,5940763013,6039073122,6039073123,6039571001,6039571010,6039571011,6039571111,6040001001,6040001003,6040001021,6040001023,6040001201,6040001203,6040001221,6040001223,6040002133,6040002223,6040002231,6040002232,6040002233,6040002302,6040002303,6040003001,6040003003,6040010100,6040010102,6040010103,6040011002,6040011003,6040011011,6040011012,6040011013,6040061122,6040061322,6040063100,6040161100,6040161102,6040161103,6040161130,6040161132,6040161133,6040161310,6040161311,6040161312,6040161330,6040163132,6040163133,6040163310,6040163311,6040270022,6040270200,6040270202,6040270220,6040270222,6040270223,6040272122,6040272123,6040273222,6040371000,6040371002,6040371020,6040371022,6040371200,6040371202,6040371220,6040371222,6040373000,6040373002,6040373232,6040402230,6040402231,6040442130,6040442131,6040442132,6040442300,6040443020,6040443021,6040443223,6040443330,6040443331,6040443332,6040452200,6040452202,6040453221,6040453223,6040471010,6040471012,6040471030,6040471032,6040471123,6040472330,6040472331,6040473220,6040473221,6040473223,6040473300,6040473301,6040473302,6040473320,6040473322,6040500121,6040500123,6040500301,6040500302,6040500303,6040500330,6040500331,6040501120,6040501122,6040501230,6040510021,6040510030,6040510121,6040510130,6040510131,6040511010,6040511011,6040511012,6040511100,6040511101,6040511131,6040520020,6040520021,6040520030,6040520031,6040520130,6040520132,6040521021,6040521030,6040521031,6040521301,6040521303,6040521321,6040523111,6040523113,6040531120,6040531121,6040531122,6040531130,6040531200,6040531201,6040531300,6040531302,6040532021,6040532030,6040532110,6040532112,6040532130,6040540000,6040540001,6040541011,6040541100,6040560020,6040560021,6040560210,6040560211,6040560213,6040560300,6040560301,6040560302,6040560310,6040560311,6040561110,6040561112,6040561130,6040561132,6040561221,6040561223,6040561310,6040561312,6040561330,6040561332,6040563001,6040563003,6040563021,6040563023,6040563110,6040563112,6040563130,6040563132,6040563201,6040563210,6040563211,6040563213,6040563310,6040563312,6040563320,6040563321,6040563330,6040563333,6040571100,6040571101,6039571000,6039570100,6039570101,6039570110,6039570111,59405203333,59405212222,59405212223,59405212232,59405212233,59405212322,59405221111,59405221113,59405221331,59405221333,59405223111,59405223113,59405223131,59405223133,59405223301,59405223302,59405223303,59405230100,59405230102,59405230103,59405230112,59405230113,59405231022,59405231023,59405231212,59405231230,59405231232,59405233100,59405233102,59405233120,59405233122,59405233310,59405233312,59405233313,59405313222,59405313223,59405313232,59405313233,59405313322,59405313323,59405322202,59405322203,59405322212,59405322213,59405322302,59405322303,59405322311,59405322312,59405322313,59405323031,59405323033,59405330133,59405330311,59405330313,59405331112,59405331130,59405331132,59405331133,59405420022,59405420023,59405420032,59405420033,59405420302,59405420303,59405422320,59405422322,59406201121,59406201123,59406201303,59406201311,59406201312,59406201313,59406201321,59406201323,59406203101,59406203103,59406203321,59406203323,59406221101,59406221102,59406221103,59406223032,59406223033,59406400100,59406400102,59406400120,59406400122,59406400123,59406400132,59406400133,59406401022,59406401200,59406401202,59406401230,59406401232,59406403322,59406403323,59406421112,59406421113,59406430002,59406430020,59406430022,59406430023,59406430032,59406430123,59406430132,59406430133,59406431002,59406431003,59406431012,59406431013,59406431102,59406431103,59406431112,59406431113,59406520022,59406520023,59406520210,59406520212,59406520320,59406520322,59406522100,59406522102,59406522120,59406522122,59406522300,59406522302,59406522320,59406522322,59407030231,59407030233,59407030301,59407030303,59407031310,59407031312,59407032003,59407032021,59407032023,59407113313,59407113331,59407113333,59407120220,59407120222,59407122000,59407122002,59407122003,59407122012,59407122030,59407122032,59407122033,59407122302,59407122303,59407122312,59407122330,59407122332,59407122333,59407123222,59407123322,59407123323,59407123332,59407123333,59407131111,59407131113,59407133101,59407133102,59407133103,59407133232,59407133233,59407200231,59407200233,59407201003,59407202011,59407202013,59407202022,59407202023,59407202031,59407202032,59407202033,59407500100,59407500102,59407500120,59407500122,59407501200,59407501202,59407503122,59407503300,59407503302,59407503303,59407503312,59407503313,59407521110,59407521112,59407521113,59407530002,59407530003,59407530012,59407530120,59407530122,59407530300,59407530302,59407530320,59407530322,59407531131,59407531133,59407531311,59407531313,59407531331,59407532110,59407532112,59407532113,59407533002,59407533020,59407533022,59407533112,59407533113,59407533200,59407533202,59407533203,59407533212,59407533213,59407533302,59407533303,59407602232,59407602233,59407602322,59407602323,59407602332,59407602333,59407603222,59407603223,59407612332,59407612333,59407613222,59407620220,59407620221,59407620223,59407621012,59407621013,59407621102,59407622001,59407622002,59407622003,59407630013,59407630102,59407630103,59407631000,59407631002,59407631222,59407633000,59407633002,59407633020,59407633022,59407633200,59407633202,59407633220,59407633222,60390731200,60390731202,60390731322,60390733100,60390733102,60390733120,60390733122,60390733300,60390733302,60390733320,60390733322,60395701131,60395710020,60395710021,60395710030,60395710031,60395710120,60395710121,60395710130,60395710131,60395710132,60395711000,60395711001,60395711010,60395711011,60395711100,60395711101,60395711103,60395711121,60395711130,60395711131,60400012223,60400021233,60400021311,60400021313,60400021322,60400021323,60400022123,60400022132,60400022133,60400022221,60400022223,60400022301,60400022302,60400022303,60400023002,60400023003,60400023011,60400023012,60400023013,60400030001,60400030003,60400030021,60400030023,60400110000,60400110002,60400611000,60400611002,60400611020,60400611022,60400611200,60400611202,60400611203,60400611212,60400611230,60400611232,60400613000,60400613002,60400613020,60400613022,60400613200,60400613202,60400613230,60400613232,60400631010,60400631012,60400631020,60400631022,60400631200,60400631202,60400631220,60400633220,60400633222,60400633223,60400633232,60401611010,60401611012,60401611013,60401611102,60401611120,60401611122,60401611123,60401611132,60401611310,60401611312,60401611313,60401613130,60401613131,60401613132,60401613310,60401613312,60401613320,60401613322,60401631100,60401631102,60401631120,60401631122,60401631300,60401631302,60401631303,60401631312,60401633120,60401633121,60401633122,60401633130,60401633131,60401722020,60401722021,60402611122,60402702010,60402702012,60402702030,60402702032,60402702210,60402702212,60402702213,60402702302,60402702320,60402702322,60402702323,60402720100,60402720102,60402720120,60402720122,60402720123,60402721320,60402721322,60402732202,60402732203,60402732232,60403710230,60403710232,60403712010,60403712012,60403712030,60403712032,60403712033,60403712122,60403730030,60403730032,60403730300,60403730302,60403730320,60403730322,60403732100,60403732102,60403732120,60403732122,60403732300,60403732302,60403732303,60403732332,60404022320,60404022321,60404022330,60404022331,60404022333,60404422300,60404422302,60404422320,60404422322,60404430231,60404430233,60404432011,60404432013,60404432031,60404432033,60404432211,60404432212,60404432213,60404432221,60404432223,60404433330,60404433331,60404433332,60404522200,60404522201,60404522202,60404522220,60404523311,60404532200,60404532201,60404533200,60404533201,60404533210,60404533211,60404533300,60404533301,60404533310,60404533311,60404533313,60404533331,60404533333,60404710110,60404710330,60404710332,60404710333,60404711211,60404711213,60404711222,60404711223,60404711320,60404711322,60404713100,60404713102,60404713120,60404713122,60404713300,60404713302,60404713303,60404713312,60404713320,60404713322,60404723320,60404723321,60404723330,60404723331,60404731100,60404732220,60404732221,60404732223,60405000000,60405000001,60405000002,60405000010,60405000011,60405000020,60405000022,60405000111,60405000113,60405000131,60405000133,60405001201,60405001203,60405001221,60405001223,60405002113,60405002131,60405002133,60405003001,60405003002,60405003003,60405003210,60405003211,60405003320,60405003321,60405003330,60405003331,60405011210,60405011212,60405011230,60405011232,60405012310,60405012311,60405012320,60405012321,60405012322,60405013000,60405013002,60405013020,60405013022,60405013200,60405030000,60405030001,60405030010,60405030011,60405030100,60405100201,60405100203,60405110130,60405110131,60405110132,60405111020,60405111021,60405111030,60405111031,60405111033,60405200221,60405200223,60405200331,60405200333,60405201310,60405201312,60405201330,60405201332,60405213230,60405213231,60405213233,60405231011,60405231100,60405231101,60405231103,60405231121,60405231123,60405311230,60405311232,60405313010,60405313012,60405313030,60405313032,60405321110,60405321111,60405400020,60405400021,60405400030,60405400031,60405400100,60405400102,60405400120,60405400121,60405400130,60405410001,60405410010,60405410011,60405410100,60405410101,60405410103,60405410121,60405410130,60405410131,60405411010,60405411011,60405411020,60405411021,60405411023,60405411100,60405411101,60405411110,60405510010,60405510011,60405510013,60405510031,60405510100,60405510101,60405510110,60405510111,60405511111,60405511113,60405511131,60405511133,60405511311,60405511313,60405600231,60405600233,60405603030,60405603032,60405603210,60405611110,60405611111,60405611112,60405611130,60405611132,60405611310,60405611312,60405611330,60405611332,60405612200,60405612201,60405612203,60405612221,60405612223,60405613110,60405613112,60405613130,60405613132,60405613310,60405613312,60405613330,60405613332,60405630001,60405630003,60405630021,60405630023,60405630201,60405630203,60405630221,60405630223,60405631110,60405631112,60405631130,60405631132,60405631310,60405631312,60405631330,60405631332,60405632001,60405632003,60405632031,60405632120,60405632121,60405632310,60405632311,60405632313,60405632331,60405633110,60405633112,60405633130,60405633132,60405633220,60405633221,60405633230,60405633231,60405633310,60405633312,60405633320,60405633321,60405633323,60405700000,60405700001,60405700010,60405700011,60405700100,60405700101,60405700110,60405700111,60405701000,60405701001,60405701010,60405701011,60405710001,60405710010,60405710011,60405710100,60405710101,60405710110,60405710111,60405711020,60405711021,60405711030,60405711031,60406611101,60406611110,60406611111,60395701020,60395701021,60395701030,60395701031,60395701120,60395701121,60395701130,
014,00,,502762500,140437500,505884375,144300000,22,35,95,161,301,546,584051,584060,584070,584071,594001,594011,594031,594041,594051,594061,593977,593976,593966,594060,594050,594040,594030,594020,594010,594000,583977,583967,5839573,5840422,5840502,5840503,5840520,5840610,5840612,5840720,5840722,5940210,5940211,5940212,5940420,5940422,5940423,5940432,5940530,5940700,5940701,5940702,5940710,6039071,6040000,6039070,5939753,5939653,6039051,5939651,5939672,5939673,5939671,5939071,5839572,5839563,5939751,58404122,58404123,58404131,58404132,58404133,58404232,58405011,58405012,58405013,58405220,58405222,58406110,58406111,58406112,58406130,58406132,58406133,58407212,58407230,59400200,59400220,59400222,59400223,59401220,59402130,59402132,59402133,59404212,59404330,59404332,59404333,59405200,59405201,59405202,59405210,59405211,59405213,59405220,59405222,59405310,59405311,59405312,59405320,59405321,59406200,59406202,59406220,59406222,59407110,59407111,59407112,59407121,59407130,59407132,60400020,60390721,60390720,60390611,60390610,60390613,59397503,59397521,59397523,60390501,59396521,59396523,59397501,60390600,60390503,59396702,59396703,59395633,59395632,59395623,59395622,59395533,59396700,59395733,59395731,59395713,59395732,59395711,59394733,59391731,59391713,59391711,59390733,59390731,58396611,58396613,58396631,58396633,58397611,59390730,59391733,583957022,583957023,583957032,583957033,583957122,583957123,583957131,583957132,583957133,584040333,584041123,584041132,584041133,584041212,584041213,584041301,584041302,584041303,584042013,584042022,584042023,584042031,584042032,584042033,584042120,584042122,584042300,584042301,584042302,584050022,584050101,584050103,584052100,584052101,584052102,584052210,584052211,584052212,584061130,584061132,584061310,584062000,584062002,584062220,584062222,584062223,584062232,584062233,584062322,584062323,584072100,584072101,584072102,584072310,584072320,584072321,584072322,594002010,594002011,594002012,594002020,594002021,594002022,594002100,594002210,594002211,594002212,594012000,594012001,594012002,594012020,594012022,594012023,594012220,594012222,594021310,594021312,594022000,594022222,594032000,594032002,594032020,594032022,594032023,594032200,594032201,594032202,594032220,594032222,594032223,594032231,594032232,594032233,594042100,594042102,594042103,594042130,594042132,594042133,594043022,594043023,594043122,594043310,594043312,594043313,594044220,594044222,594052030,594052031,594052032,594052120,594052121,594052210,594052212,594052230,594052232,594052311,594052313,594053130,594053220,594053221,594053300,594053302,594054000,594054002,594062010,594062012,594062030,594062032,594062210,594062212,594070300,594070301,594070310,594070311,594071130,594071131,594071132,594071200,594071201,594071203,594071221,594071230,594071231,594071310,594071312,594071313,594071330,594072000,603907300,603907301,603907302,603907310,603907311,604000210,604000211,604000220,583956133,583956132,583956123,583956122,5839561313,5839570202,5839570203,5839570212,5839570213,5839570302,5839570303,5839570312,5839570313,5839571202,5839571203,5839571212,5839571213,5839571301,5839571302,5839571303,5840403223,5840403232,5840403233,5840403311,5840403313,5840403322,5840403323,5840411303,5840411312,5840411313,5840412011,5840412013,5840412022,5840412023,5840412031,5840412032,5840412033,5840412100,5840412102,5840412103,5840412112,5840420123,5840420202,5840420203,5840420212,5840420213,5840420301,5840420302,5840420303,5840421020,5840421022,5840421023,5840421230,5840421232,5840421233,5840421322,5840423030,5840423031,5840423032,5840423100,5840423102,5840423302,5840423320,5840423322,5840500200,5840500202,5840500232,5840500233,5840500322,5840501001,5840501002,5840501003,5840501021,5840501023,5840521030,5840521031,5840521100,5840521200,5840521202,5840522130,5840522300,5840522302,5840522320,5840522322,5840611310,5840611311,5840611312,5840613120,5840613122,5840613123,5840613132,5840613133,5840620010,5840620011,5840620200,5840622022,5840622023,5840622210,5840622212,5840622213,5840622302,5840623320,5840623322,5840721030,5840721032,5840721033,5840721100,5840721102,5840721302,5840721320,5840721322,5840723120,5840723122,5840723230,5840723231,5840723232,5840723300,5840723302,5840723320,5940020130,5940020131,5940020132,5940020230,5940020232,5940020233,5940020322,5940020323,5940020332,5940020333,5940021010,5940021012,5940021020,5940021021,5940022130,5940022131,5940023000,5940023002,5940023003,5940023020,5940120030,5940120032,5940120033,5940120100,5940120210,5940120212,5940120320,5940120322,5940122100,5940122102,5940122210,5940122212,5940122213,5940122230,5940122231,5940122232,5940213110,5940213112,5940213130,5940213132,5940213133,5940220010,5940220020,5940320030,5940320032,5940320210,5940320212,5940320213,5940320320,5940320322,5940322030,5940322031,5940322032,5940322100,5940322102,5940322120,5940322210,5940322212,5940322213,5940322302,5940322303,5940421013,5940421102,5940421120,5940421122,5940421310,5940421312,5940421313,5940430202,5940430203,5940430212,5940430320,5940430322,5940430333,5940431232,5940431233,5940433112,5940442020,5940442022,5940442023,5940442230,5940442232,5940520330,5940520331,5940520332,5940521220,5940521221,5940521230,5940521231,5940521233,5940522110,5940522112,5940522113,5940522130,5940522131,5940522132,5940522310,5940522312,5940523100,5940523101,5940523103,5940523311,5940523313,5940531310,5940531311,5940531312,5940531320,5940531321,5940531330,5940532300,5940532301,5940532302,5940532310,5940533010,5940533011,5940533012,5940533030,5940533032,5940533201,5940533210,5940622300,5940622301,5940622302,5940622320,5940622322,5940703020,5940703021,5940703022,5940703220,5940703222,5940711330,5940711332,5940712020,5940712021,5940712023,5940712320,5940712321,5940712323,5940712330,5940712331,5940713110,5940713112,5940713113,5940713320,5940713321,5940713322,5940720010,5940720011,5940720012,5940720020,5940720021,5940720022,5940720200,6039073121,6039073130,6039073131,6039073133,6039073311,6039073313,6039073331,6039073333,6040001000,6040001002,6040001020,6040001022,6040001200,6040001202,6040001220,6040002120,6040002121,6040002122,6040002130,6040002210,6040002211,6040002220,6040002221,6040010101,6040011001,6040011010,5839561303,5839561312,5839561302,5839561213,5839561212,5839561203,5839561202,58395703113,58395711223,58395711232,58395711233,58395711322,58395711323,58395711332,58395711333,58395712002,58395712003,58395712012,58395712013,58395712102,58395712103,58395712112,58395712113,58395713001,58395713002,58395713003,58404031332,58404031333,58404033211,58404033213,58404112033,58404112122,58404112123,58404112132,58404112133,58404112211,58404112213,58404112231,58404112233,58404113003,58404113012,58404113013,58404113021,58404113022,58404113023,58404113102,58404113103,58404113112,58404113113,58404120123,58404120202,58404120203,58404120212,58404120213,58404120301,58404120302,58404120303,58404121132,58404121133,58404130011,58404130013,58404130022,58404130023,58404130031,58404130032,58404130033,58404201212,58404201213,58404201223,58404202002,58404202003,58404202012,58404202013,58404202102,58404202103,58404202112,58404202113,58404203001,58404203002,58404203003,58404210212,58404210213,58404212122,58404212123,58404212132,58404212310,58404212312,58404230330,58404230332,58404230333,58404233002,58404233003,58405000222,58405000223,58405001131,58405001133,58405001333,58405002030,58405002032,58405002300,58405002302,58405003111,58405003113,58405003131,58405003133,58405003311,58405003313,58405003331,58405003333,58405010001,58405010003,58405010201,58405010203,58405010221,58405010222,58405010223,58405211020,58405211021,58405212200,58405212201,58405212202,58405212220,58405221320,58405221322,58405223010,58406113130,58406113131,58406113300,58406113301,58406113302,58406113320,58406113322,58406131100,58406131102,58406131120,58406131122,58406131133,58406131210,58406131212,58406131213,58406131302,58406131303,58406131311,58406131312,58406131313,58406200120,58406200122,58406200300,58406200302,58406201001,58406202010,58406202011,58406202012,58406202020,58406202021,58406202030,58406220022,58406220200,58406220202,58406220203,58406220212,58406222110,58406222112,58406223030,58406223032,58406233210,58406233212,58406233230,58406233232,58407210310,58407210312,58407213232,58407213233,58407213322,58407231100,58407231102,58407231120,58407231122,58407231210,58407231211,58407231212,58407231230,58407231300,58407232330,58407232332,59400201330,59400201331,59400202310,59400202312,59400202313,59400203000,59400203001,59400203010,59400203011,59400203100,59400203101,59400203202,59400203203,59400203212,59400203213,59400203302,59400203303,59400203312,59400203313,59400210110,59400210112,59400210130,59400210132,59400210220,59400210221,59400210230,59400210231,59400212222,59400212223,59400221320,59400221321,59400221322,59400221330,59400221331,59400230012,59400230013,59400230210,59400230211,59400230220,59400230221,59400232202,59400232220,59400232222,59401200310,59401200311,59401200312,59401201010,59401201011,59401201012,59401201020,59401201021,59401201030,59401201100,59401201101,59401201110,59401201111,59401202110,59401202111,59401202112,59401202130,59401202132,59401202133,59401203022,59401203023,59401203232,59401221010,59401221200,59401221201,59401222110,59401222112,59401222113,59401222330,59401222332,59402131110,59402131111,59402131312,59402131313,59402200110,59402200112,59402200120,59402200121,59402200122,59402200130,59402200210,59402200211,59402200212,59402200220,59402200221,59402200222,59402200230,59402200300,59402202000,59402202002,59402202020,59402202022,59402202200,59402202202,59402202220,59402202222,59402220000,59402222002,59402222020,59402222022,59402222023,59402222032,59402222033,59403200120,59403200122,59403200310,59403200312,59403200330,59403200332,59403202110,59403202112,59403202113,59403203022,59403203023,59403203230,59403203232,59403220330,59403220332,59403221010,59403221012,59403221030,59403221032,59403221210,59403221212,59403221322,59403221323,59403221332,59403221333,59403222110,59403222112,59403222113,59403223002,59403223003,59403223012,59403223013,59403230222,59403232000,59403232002,59403232020,59403232022,59403232200,59403232202,59403232220,59403232222,59404210102,59404210112,59404210113,59404210120,59404210122,59404210123,59404211002,59404211003,59404211212,59404211230,59404211232,59404211233,59404211322,59404211323,59404213112,59404213113,59404302002,59404302003,59404302012,59404302013,59404302130,59404302132,59404303230,59404303232,59404303321,59404303323,59404312300,59404312302,59404313220,59404313222,59404331102,59404331103,59404331112,59404331130,59404331132,59404331133,59404420022,59404420023,59404420212,59404420213,59404420322,59404422100,59404422102,59404422120,59404422122,59405203330,59405203331,59405203332,59405212220,59405212221,59405212230,59405212231,59405212320,59405212321,59405212323,59405221110,59405221112,59405221330,59405221332,59405223110,59405223112,59405223130,59405223132,59405223300,59405230101,59405230110,59405230111,59405231020,59405231021,59405231210,59405231211,59405231213,59405231231,59405231233,59405233101,59405233103,59405233121,59405233123,59405233311,59405313130,59405313131,59405313132,59405313220,59405313221,59405313230,59405313231,59405313310,59405313312,59405313320,59405313321,59405313330,59405322200,59405322201,59405322210,59405322211,59405322300,59405322301,59405322310,59405323030,59405323032,59405330130,59405330131,59405330132,59405330310,59405330312,59405400100,59405400102,59405400120,59405400122,59405402000,59405402001,59405402002,59405402010,59405402011,59405402020,59406201120,59406201122,59406201300,59406201301,59406201302,59406201310,59406201320,59406201322,59406203100,59406203102,59406203320,59406203322,59406221100,59406223030,59406223031,59407030230,59407030232,59407030300,59407030302,59407031311,59407031313,59407032000,59407032001,59407032002,59407032020,59407032022,59407113310,59407113311,59407113312,59407113330,59407113332,59407120221,59407120223,59407122001,59407122010,59407122011,59407122013,59407122031,59407122300,59407122301,59407122310,59407122311,59407122313,59407122331,59407123220,59407123221,59407123223,59407123320,59407123321,59407123330,59407123331,59407131110,59407131112,59407133100,59407133230,59407133231,59407200230,59407200232,59407201000,59407201001,59407201002,59407202010,59407202012,59407202020,59407202021,59407202030,60390731201,60390731203,60390731320,60390731321,60390731323,60390733101,60390733103,60390733121,60390733123,60390733301,60390733303,60390733321,60390733323,60400012220,60400012221,60400012222,60400021230,60400021231,60400021232,60400021310,60400021312,60400021320,60400021321,60400022120,60400022121,60400022122,60400022130,60400022131,60400022220,60400022222,60400022300,60400023000,60400023001,60400023010,60400030000,60400030002,60400030020,60400030022,60400110001,60400110003,
015,00,,504829687,139921875,507150000,143971875,22,27,80,185,395,893,584034,584043,584044,584045,584053,584054,584063,584064,584065,584073,584074,594003,594004,594013,594014,594023,594024,594033,594034,594035,594045,594055,5840350,5840352,5840353,5840523,5840550,5840551,5840552,5840621,5840750,5840752,5940121,5940123,5940221,5940223,5940250,5940252,5940321,5940440,5940441,5940443,5940541,5940543,5940641,5940650,5940651,5940653,5940751,58402422,58402423,58402430,58402432,58402433,58402522,58403311,58403313,58403331,58403332,58403333,58403510,58403512,58404602,58404620,58405213,58405530,58405532,58405533,58406203,58406221,58406230,58406231,58407510,59400211,59400213,59400231,59400233,59400500,59400502,59400522,59401223,59401500,59401502,59401520,59401522,59401523,59402201,59402203,59402221,59402223,59402512,59402530,59402532,59403201,59403231,59403233,59403602,59403620,59403622,59403623,59404300,59404301,59404310,59404311,59404421,59404423,59404600,59404601,59404602,59405401,59405403,59405421,59405423,59405600,59405602,59405603,59405620,59405622,59406521,59406523,59406600,59406602,59406620,59406622,59406623,59406632,59407600,59407601,59407610,584023333,584024213,584024312,584024313,584025202,584025203,584025230,584025232,584025233,584033103,584033121,584033123,584033222,584033223,584033232,584033233,584033301,584033303,584035112,584035130,584035132,584035133,584036200,584042130,584042131,584042133,584042311,584042312,584042313,584042331,584042333,584046002,584046003,584046212,584046220,584046221,584052111,584052112,584052113,584052121,584052123,584052231,584052233,584055310,584055312,584062011,584062012,584062013,584062021,584062022,584062023,584062201,584062203,584062231,584062320,584062321,584062330,584062331,584062333,584066000,584066002,584066003,584066202,584066220,584072111,584072112,584072113,584072131,584072331,584072333,584075110,584075120,584075122,594002103,594002120,594002121,594002123,594002301,594002303,594002320,594002321,594002323,594005010,594005012,594005030,594005032,594005200,594005201,594005202,594012012,594012013,594012031,594012033,594012211,594012213,594015010,594015012,594015030,594015032,594015210,594015212,594015213,594015320,594015322,594022021,594022023,594022201,594022202,594022203,594022221,594022223,594025100,594025102,594025103,594025130,594025132,594025332,594025333,594032031,594032033,594032211,594032300,594032301,594032303,594032321,594032323,594036002,594036030,594036032,594036210,594036212,594042111,594043030,594043031,594043120,594043121,594043130,594043131,594043133,594044201,594046030,594046200,594046201,594046202,594046220,594046222,594046223,594054003,594054021,594054022,594054023,594054201,594056010,594056012,594056013,594056122,594056210,594056211,594056212,594056300,594064011,594064013,594064031,594065201,594066212,594066213,594066302,594066303,594066310,594066311,594066312,594066330,594075010,594075011,594075013,594075310,594075312,594076020,594076021,594076030,594076031,594076033,594076120,594076121,594076122,5840233133,5840233311,5840233313,5840233322,5840233323,5840240333,5840241222,5840242022,5840242023,5840242111,5840242112,5840242113,5840242123,5840243102,5840243103,5840252001,5840252002,5840252003,5840252010,5840252012,5840252013,5840252120,5840252122,5840252123,5840252310,5840252312,5840252313,5840253222,5840323333,5840331011,5840331013,5840332303,5840332313,5840333021,5840333023,5840351102,5840360222,5840360223,5840362020,5840362021,5840362022,5840362200,5840362202,5840362220,5840362222,5840421111,5840421113,5840421131,5840421132,5840421133,5840421320,5840421321,5840421323,5840423101,5840423103,5840423301,5840423303,5840423321,5840423323,5840460000,5840460002,5840460003,5840460302,5840460320,5840460322,5840462100,5840462102,5840462103,5840462220,5840462300,5840462301,5840462302,5840521032,5840521033,5840521101,5840521103,5840521201,5840521203,5840521221,5840521223,5840522131,5840522133,5840522303,5840522321,5840522323,5840553110,5840553112,5840553130,5840553132,5840553133,5840560022,5840560222,5840562200,5840562202,5840562220,5840562222,5840562223,5840611331,5840611333,5840613111,5840620013,5840620031,5840620032,5840620033,5840620101,5840620102,5840620103,5840622000,5840622001,5840622003,5840622300,5840622301,5840660012,5840660013,5840660102,5840660120,5840660121,5840660200,5840660202,5840660220,5840660222,5840662000,5840662002,5840662032,5840662033,5840662210,5840662211,5840662212,5840662220,5840721101,5840721103,5840721300,5840721301,5840721303,5840721321,5840721330,5840721331,5840721333,5840723111,5840723113,5840723131,5840723132,5840723133,5840723301,5840723303,5840723321,5840723322,5840723323,5840751110,5840751111,5840751210,5840751212,5840751230,5840753220,5840753222,5840753223,5940020302,5940020303,5940020311,5940020312,5940020313,5940021220,5940021221,5940021223,5940023023,5940023221,5940023223,5940050110,5940050111,5940050112,5940050130,5940050132,5940050310,5940051000,5940052030,5940052032,5940120112,5940120113,5940120300,5940120301,5940120303,5940120321,5940122103,5940122121,5940122122,5940122123,5940150112,5940150130,5940150132,5940150330,5940150332,5940152110,5940152112,5940152113,5940153020,5940153022,5940153023,5940153210,5940153212,5940153230,5940153232,5940213113,5940220031,5940220032,5940220033,5940220201,5940220203,5940220221,5940220223,5940222001,5940222002,5940222003,5940222201,5940251010,5940251012,5940251013,5940253100,5940253300,5940253302,5940253303,5940253312,5940262222,5940320010,5940320011,5940320013,5940320300,5940320301,5940320303,5940320321,5940322122,5940322123,5940322130,5940322131,5940323020,5940323021,5940323023,5940323201,5940323203,5940323221,5940323223,5940360000,5940360002,5940360030,5940360032,5940360033,5940360312,5940360330,5940360332,5940362110,5940362112,5940362130,5940362132,5940362133,5940363200,5940363202,5940363220,5940363222,5940421101,5940421103,5940421130,5940421131,5940421133,5940430210,5940430211,5940430321,5940430330,5940430331,5940431231,5940431320,5940431321,5940431323,5940442000,5940442001,5940442003,5940442030,5940442031,5940442033,5940442211,5940442213,5940442231,5940442233,5940460310,5940460312,5940460320,5940460321,5940460322,5940460330,5940461000,5940461002,5940461020,5940462030,5940462031,5940462032,5940462210,5940462212,5940462320,5940462322,5940462323,5940462332,5940540011,5940540013,5940540203,5940542000,5940542001,5940542031,5940542033,5940542211,5940542213,5940542231,5940542233,5940560110,5940560112,5940561200,5940561202,5940561232,5940562130,5940562131,5940562300,5940563010,5940563011,5940563020,5940640011,5940640100,5940640101,5940640103,5940640121,5940640330,5940640331,5940640333,5940643001,5940643010,5940643011,5940652000,5940652001,5940652003,5940652030,5940652031,5940652033,5940652211,5940652213,5940652231,5940652233,5940661323,5940661332,5940662100,5940662102,5940662103,5940662112,5940662113,5940663130,5940663320,5940663321,5940663322,5940750011,5940750013,5940750121,5940750123,5940750310,5940750311,5940750313,5940753010,5940753011,5940753013,5940753031,5940753033,5940753110,5940753111,5940753112,5940753130,5940753132,5940753301,5940753303,5940753310,5940753312,5940760220,5940760221,5940760222,5940760230,5940760231,5940760320,5940760321,5940760323,5940761100,5940761102,5940761120,5940761122,5940761230,5940761231,5940761232,5940761300,5940761302,5940762000,5940762111,5940763000,5940763002,58402332313,58402332331,58402332332,58402332333,58402333033,58402333103,58402333121,58402333122,58402333123,58402333202,58402333203,58402333211,58402333212,58402333213,58402403312,58402403313,58402412202,58402412203,58402412212,58402412230,58402412232,58402412233,58402412322,58402412323,58402420320,58402420322,58402420323,58402420331,58402420332,58402420333,58402421031,58402421033,58402421101,58402421103,58402421211,58402421213,58402421220,58402421222,58402421223,58402431000,58402431002,58402431120,58402431122,58402431131,58402431133,58402521020,58402521022,58402521320,58402521322,58402521323,58402521332,58402523110,58402523112,58402523113,58402532202,58402532203,58402532232,58402532233,58402532322,58402532323,58402532332,58403310231,58403310233,58403312011,58403312013,58403312031,58403312033,58403312211,58403312213,58403312231,58403312233,58403322022,58403322023,58403322032,58403322033,58403322122,58403322123,58403322132,58403322133,58403323012,58403323013,58403323022,58403323023,58403323112,58403323113,58403323122,58403323123,58403330011,58403330013,58403330031,58403330033,58403330201,58403330203,58403330221,58403330222,58403330223,58403511000,58403511002,58403513102,58403513120,58403513122,58403513123,58403513132,58403513133,58403602202,58403602203,58403602212,58403602213,58403602302,58403602303,58403602320,58403602322,58403620100,58403620102,58403620120,58403620122,58403620123,58403620230,58403620231,58403620232,58403620300,58403620302,58403620320,58403622010,58403622012,58403622030,58403622032,58403622210,58403622212,58403622230,58403622232,58404210333,58404211101,58404211103,58404211121,58404211123,58404211222,58404211223,58404211232,58404211233,58404211301,58404211302,58404211303,58404212102,58404212103,58404212111,58404212112,58404212113,58404212120,58404212121,58404212130,58404212131,58404212133,58404212311,58404212313,58404230331,58404233000,58404233001,58404600010,58404600012,58404600013,58404600102,58404600120,58404600122,58404600123,58404600132,58404600133,58404603000,58404603002,58404603030,58404603032,58404603210,58404603212,58404603230,58404603232,58404621010,58404621012,58404621013,58404621122,58404621123,58404621300,58404621301,58404622220,58404622222,58404623030,58404623032,58405211022,58405211023,58405212203,58405212221,58405212222,58405212223,58405221321,58405221323,58405223011,58405223012,58405223013,58405531110,58405531111,58405531112,58405531130,58405531132,58405531310,58405531312,58405600000,58405600002,58405600020,58405600022,58405600200,58405600202,58405602000,58405602001,58405602002,58405602020,58405602022,58405602200,58405602202,58405602203,58405602212,58405602230,58405602232,58405620000,58405620001,58405620220,58405620222,58405622012,58405622030,58405622032,58405622210,58405622212,58405622213,58405622302,58405622320,58405622322,58406113132,58406113133,58406113303,58406113321,58406113323,58406131101,58406131103,58406131121,58406131123,58406131130,58406131131,58406131132,58406131211,58406131300,58406131301,58406131310,58406200121,58406200123,58406200301,58406200303,58406201000,58406201002,58406201003,58406202013,58406202022,58406202023,58406202031,58406202032,58406202033,58406220020,58406220021,58406220023,58406220201,58406220210,58406220211,58406220213,58406222111,58406222113,58406223031,58406223033,58406233211,58406233213,58406233231,58406233233,58406600100,58406600102,58406600103,58406600112,58406600113,58406601002,58406601030,58406601032,58406601220,58406601221,58406601230,58406601231,58406601300,58406601301,58406602010,58406602012,58406602030,58406602032,58406602210,58406602212,58406602230,58406602232,58406620010,58406620012,58406620030,58406620032,58406620300,58406620302,58406621222,58406622210,58406622211,58406622212,58406622220,58406622221,58406622222,58406622230,58406622300,58406623000,58406623002,58407210311,58407210313,58407213230,58407213231,58407213320,58407213321,58407213323,58407231101,58407231103,58407231121,58407231123,58407231213,58407231231,58407231232,58407231233,58407231301,58407231302,58407231303,58407232331,58407232333,58407511120,58407511121,58407511130,58407511131,58407511200,58407511201,58407511202,58407511210,58407511211,58407512132,58407512133,58407512310,58407512311,58407512320,58407512321,58407512322,58407530000,58407530001,58407530002,58407530010,58407530011,58407530020,58407530022,58407530100,58407530200,58407530202,58407530203,58407530220,58407530222,58407532000,58407532002,58407532020,58407532022,58407532023,58407532320,58407600000,58407600002,58407600020,59400201332,59400201333,59400202311,59400203002,59400203003,59400203012,59400203013,59400203102,59400203103,59400203200,59400203201,59400203210,59400203211,59400203300,59400203301,59400203310,59400203311,59400210111,59400210113,59400210131,59400210133,59400210222,59400210223,59400210232,59400210233,59400212220,59400212221,59400221323,59400221332,59400221333,59400230010,59400230011,59400230212,59400230213,59400230222,59400230223,59400232200,59400232201,59400232203,59400232221,59400232223,59400501130,59400501131,59400501132,59400501310,59400501312,59400501330,59400501332,59400501333,59400510010,59400510011,59400510020,59400510021,59400510222,59400520310,59400520312,59400520330,59400520332,59400520333,59400521000,59400521001,59400521002,59400521010,59400521011,59400521100,59400521101,59400523020,59401200313,59401201013,59401201022,59401201023,59401201031,59401201032,59401201033,59401201102,59401201103,59401201112,59401201113,59401202113,59401202131,59401203020,59401203021,59401203230,59401203231,59401203233,59401221011,59401221012,59401221013,59401221202,59401221203,59401222111,59401222331,59401222333,59401501102,59401501103,59401501112,59401501130,59401501132,59401501310,59401501312,59401501330,59401501332,59401503100,59401503101,59401521110,59401521112,59401521113,59401530002,59401530020,59401530022,59401530023,59401530212,59401530213,59401530302,59401530320,59401530322,59401530323,59401532110,59401532111,59402131112,59402131113,59402131310,59402131311,59402200111,59402200113,59402200123,59402200131,59402200132,59402200133,59402200213,59402200223,59402200231,59402200232,59402200233,59402200301,59402200302,59402200303,59402202001,59402202003,59402202021,59402202023,59402202201,59402202203,59402202221,59402202223,59402220001,59402220002,59402220003,59402222000,59402222001,59402222003,59402222021,59402222030,59402222031,59402510112,59402510113,59402511002,59402511202,59402511220,59402511222,59402531010,59402531012,59402531020,59402531022,59402531200,59402531202,59402531220,59402531222,59402533010,59402533012,59402533130,59402533132,59402622200,59402622202,59402622203,59402622232,59403200121,59403200123,59403200311,59403200313,59403200331,59403200333,59403202111,59403203020,59403203021,59403203231,59403203233,59403220331,59403220333,59403221011,59403221013,59403221031,59403221033,59403221211,59403221213,59403221320,59403221321,59403221330,59403221331,59403222111,59403223000,59403223001,59403223010,59403223011,59403230220,59403230221,59403230223,59403232001,59403232003,59403232021,59403232023,59403232201,59403232203,59403232221,59403232223,59403600010,59403600012,59403600030,59403600032,59403600033,59403600122,59403600123,59403603332,59403621110,59403621112,59403621130,59403621132,59403621310,59403621312,59404210100,59404210101,59404210103,59404210110,59404210111,59404210121,59404211000,59404211001,59404211210,59404211211,59404211213,59404211231,59404211320,59404211321,59404213110,59404213111,59404302000,59404302001,59404302010,59404302011,59404302131,59404302133,59404303231,59404303233,59404303320,59404303322,59404312301,59404312303,59404313221,59404313223,59404331100,59404331101,59404331110,59404331111,59404331113,59404331131,59404420020,59404420021,59404420210,59404420211,59404420320,59404420321,59404420323,59404422101,59404422103,59404422121,59404422123,59404603110,59404603111,59404603112,59404603130,59404603132,59404603230,59404603232,59404603310,59404603312,59404610220,59404610221,59404620330,59404620331,59404621000,59404621001,59404621002,59404621010,59404621020,59404621022,59404621200,59404622132,59404622133,59404623022,59404623023,59404623032,59404623210,59404623212,59404623213,59404623302,59404623303,59405313133,59405313311,59405313313,59405313331,59405313332,59405313333,59405331110,59405331111,59405331113,59405331131,59405400101,59405400103,59405400121,59405400123,59405402003,59405402012,59405402013,59405402021,59405402022,59405402023,59405420020,59405420021,59405420030,59405420031,59405420300,59405420301,59405422321,59405422323,59405612012,59405612030,59405612032,59405612033,59405612122,59405612300,59405612302,59405612303,59405612332,59405612333,59405623010,59405623012,59405623020,59405623022,59405630120,59405630121,59405630122,59405630130,59405630131,59405630210,59405630211,59405630300,59405631000,59406400101,59406400103,59406400121,59406400130,59406400131,59406401020,59406401021,59406401023,59406401201,59406401203,59406401231,59406401233,59406403320,59406403321,59406421110,59406421111,59406430000,59406430001,59406430003,59406430021,59406430030,59406430031,59406430033,59406430120,59406430121,59406430122,59406430130,59406430131,59406431000,59406431001,59406431010,59406431011,59406431100,59406431101,59406431110,59406431111,59406520020,59406520021,59406520211,59406520213,59406520321,59406520323,59406522101,59406522103,59406522121,59406522123,59406522301,59406522303,59406522321,59406522323,59406601000,59406601002,59406601020,59406601022,59406601200,59406601202,59406603220,59406603222,59406613330,59406613332,59406621010,59406621012,59406630111,59406630113,59406630131,59406630133,59406631310,59406631312,59406631320,59406631322,59406633100,59406633102,59406633120,59406633122,59406633230,59406633231,59406633232,59406633300,59407500101,59407500103,59407500121,59407500123,59407501201,59407501203,59407503120,59407503121,59407503123,59407503301,59407503310,59407503311,59407521111,59407530000,59407530001,59407530010,59407530011,59407530013,59407530121,59407530123,59407530301,59407530303,59407530321,59407530323,59407531130,59407531132,59407531310,59407531312,59407531330,59407531332,59407531333,59407532111,59407533000,59407533001,59407533003,59407533021,59407533023,59407533110,59407533111,59407533201,59407533210,59407533211,59407533300,59407533301,59407602230,59407602231,59407602320,59407602321,59407602330,59407602331,59407603220,59407603221,59407611010,59407611012,59407611030,59407611032,59407611210,59407611212,59407611230,59407611232,59407612330,59407612331,59407613010,59407613012,59407613030,59407613032,59407613200,59407613201,59407613202,59407613210,59407613220,59407620222,59407621010,59407621011,59407621100,59407621101,59407621103,59407622000,59407630010,59407630011,59407630012,59407630100,59407630101,
016,00,ʡ,504815625,135000000,506685937,136725000,7,18,46,81,136,348,564033,564034,564042,564043,564044,564053,564054,5640233,5640240,5640242,5640243,5640252,5640323,5640521,5640523,5640550,5640552,5640621,5640623,5640630,5640631,5640632,5640640,5640641,5640650,56402233,56402313,56402321,56402322,56402323,56402410,56402412,56402413,56402502,56402503,56403203,56403211,56403212,56403213,56403223,56403500,56403501,56403502,56403520,56403522,56404500,56404502,56404520,56404522,56405201,56405203,56405223,56406201,56406203,56406221,56406223,56406330,56406331,56406332,56406420,56406421,56406430,56406431,56406520,56407201,56407203,56407210,56407211,56407300,56407301,56407310,564025302,564025320,564025322,564025323,564032211,564032212,564032213,564032223,564035030,564035031,564035032,564035100,564035101,564035102,564035110,564035210,564035212,564035230,564035232,564041113,564041131,564041133,564041311,564041313,564041333,564045010,564045032,564045210,564045212,564045230,564045232,564045233,564045322,564052000,564052001,564052003,564052021,564052211,564052213,564052223,564055100,564055101,564055110,564062001,564062003,564062021,564062023,564062201,564062203,564062221,564062223,564063330,564064220,564064221,564064230,564064231,564064320,564064321,564064322,564064330,564064331,564065210,564065211,564065212,564072120,564072121,564072122,564072130,564072131,564072201,564072210,564072211,564073020,564073021,564073023,564073030,564073031,564073032,564073120,564073121,564073201,5640251222,5640253000,5640253002,5640253212,5640253213,5640253320,5640253322,5640322101,5640322102,5640322103,5640322223,5640350330,5640350331,5640350332,5640351030,5640351031,5640351032,5640351120,5640351200,5640351202,5640351220,5640411103,5640411112,5640411113,5640411121,5640411123,5640411323,5640413101,5640413103,5640413121,5640413123,5640413311,5640413313,5640450120,5640450122,5640450300,5640450302,5640450303,5640452130,5640452132,5640452310,5640452312,5640452313,5640453230,5640453232,5640511111,5640520021,5640520023,5640520231,5640522100,5640522101,5640522103,5640522121,5640522123,5640522212,5640522213,5640551020,5640551021,5640551022,5640551110,5640551112,5640551121,5640551130,5640551200,5640551222,5640553000,5640553002,5640553003,5640553020,5640553022,5640553200,5640553202,5640553220,5640633310,5640633311,5640633312,5640633320,5640633322,5640643230,5640643330,5640643331,5640651000,5640651002,5640651020,5640651022,5640651200,5640651202,5640651220,5640652130,5640652131,5640652200,5640652201,5640652202,5640652210,5640652211,5640652300,5640652301,5640653000,5640653002,5640653020,5640720011,5640720013,5640720213,5640720231,5640720233,5640721230,5640721231,5640721232,5640721320,5640721321,5640721323,5640721330,5640721331,5640721332,5640722031,5640722120,5640722121,5640722122,5640723000,5640730220,5640730221,5640730330,5640730331,5640730332,5640731100,5640731102,5640731220,5640731221,5640731300,5640731302,5640732030,5640732031,5640732100,5640732101,5640732102,5640732120,56402512202,56402512203,56402530012,56402530030,56402530032,56402530300,56402530302,56402530320,56402530322,56402532100,56402532102,56402533020,56402533022,56402533232,56402533233,56403202333,56403220113,56403220131,56403220133,56403220311,56403220313,56403220331,56403220333,56403221001,56403221002,56403221003,56403222111,56403222113,56403222122,56403222123,56403222131,56403222132,56403222133,56403222212,56403222213,56403222222,56403222223,56403503330,56403503332,56403510330,56403510331,56403510332,56403511210,56403511211,56403511220,56403511221,56403512010,56403512011,56403512012,56403512030,56403512100,56403512101,56403512110,56403521100,56403521102,56403521120,56403521122,56403521300,56403521302,56403521320,56403521322,56403523100,56403523102,56403523120,56403523122,56404111103,56404111112,56404111113,56404113010,56404113011,56404113212,56404113213,56404133010,56404133011,56404133100,56404133101,56404133103,56404133121,56404133122,56404133123,56404501102,56404501120,56404501210,56404501211,56404503012,56404503013,56404503322,56404521100,56404521102,56404521120,56404521122,56404521310,56404521312,56404521330,56404521332,56404523110,56404523112,56404523113,56404532022,56404532023,56404532032,56404532033,56404532122,56404532123,56404532312,56404532330,56404532332,56404532333,56404533222,56404533223,56404533232,56404533233,56404533322,56405111101,56405111103,56405111121,56405111130,56405111131,56405111133,56405111311,56405200200,56405200201,56405202011,56405202013,56405202031,56405202033,56405202330,56405202331,56405202333,56405220111,56405220113,56405220131,56405220333,56405221020,56405221021,56405221203,56405221221,56405221222,56405221223,56405222033,56405222102,56405222103,56405222111,56405222112,56405222113,56405222211,56405222213,56405222231,56405222233,56405510230,56405510231,56405510300,56405510301,56405510302,56405510310,56405510311,56405510320,56405511110,56405511112,56405511130,56405511132,56405511200,56405511201,56405511203,56405511221,56405511230,56405511231,56405511310,56405511312,56405511320,56405511321,56405511330,56405512202,56405512203,56405512230,56405512232,56405530010,56405530012,56405530120,56405530122,56405530210,56405530211,56405530212,56405530230,56405530232,56405530300,56405532220,56405532221,56406200011,56406200013,56406200031,56406200033,56406200211,56406200213,56406200231,56406200233,56406202011,56406202013,56406202031,56406202033,56406202231,56406202233,56406220011,56406220013,56406220031,56406220033,56406220233,56406222011,56406222013,56406222031,56406222033,56406222211,56406222213,56406222231,56406333210,56406333211,56406333212,56406333230,56406333232,56406422300,56406422301,56406422310,56406422311,56406423200,56406423201,56406423210,56406423211,56406423300,56406423301,56406423310,56406423311,56406432310,56406432311,56406432320,56406432321,56406432322,56406433200,56406433201,56406433210,56406433211,56406433320,56406433321,56406433330,56406433331,56406510210,56406510212,56406510230,56406510232,56406512010,56406512012,56406512030,56406512032,56406512220,56406512221,56406521320,56406521322,56406530010,56406530012,56406530030,56406530032,56406530210,56406530212,56407200100,56407200101,56407200311,56407200313,56407200331,56407200333,56407202111,56407202112,56407202113,56407212330,56407212331,56407212332,56407213220,56407213221,56407213330,56407213331,56407213332,56407220331,56407220333,56407221300,56407221302,56407230010,56407230011,56407230100,56407230101,56407230110,56407231010,56407231011,56407231100,56407231101,56407231110,56407302220,56407302221,56407302230,56407302231,56407302233,56407303330,56407303331,56407311010,56407311012,56407311030,56407311032,56407311200,56407311202,56407311220,56407311222,56407311223,56407311232,56407312220,56407312221,56407312230,56407312231,56407312300,56407312301,56407312302,56407312310,56407312311,56407312320,56407313010,56407313012,56407313013,56407313030,56407313031,56407313032,56407313200,56407313201,56407313210,56407320011,56407320013,56407320031,56407320033,56407321030,56407321032,56407321100,56407321101,56407321210,56407321212,56407410000,56407410001,56407410003,56407410010,56407410011,56407410012,56407410021,56407410030,56407410100,
016,01,,503803125,132431250,507121875,135440625,20,41,71,134,303,550,554033,554042,554043,554052,554053,554060,554061,554062,554063,554071,554072,554073,554074,564001,564002,564003,564004,564012,564013,564014,5540242,5540321,5540322,5540323,5540340,5540342,5540440,5540442,5540443,5540503,5540511,5540512,5540513,5540540,5540541,5540542,5540640,5540642,5540643,5540700,5540701,5540703,5540750,5540752,5640001,5640003,5640050,5640052,5640110,5640150,5640151,5640152,5640160,5640211,5640220,5640221,5640222,5640230,5540231,5540232,5540233,55395733,55396711,55396731,55396733,55397711,55402233,55402400,55402402,55402403,55402430,55403202,55403203,55403412,55404113,55404131,55404132,55404133,55404410,55404412,55404413,55405022,55405023,55405101,55405102,55405103,55405430,55405431,55405432,55405500,55405502,55406410,55406412,55406520,55406522,55406523,55407020,55407021,55407023,55407532,56400532,56400621,56400622,56400623,56400630,56400632,56401011,56401013,56401110,56401111,56401113,56401131,56401133,56401530,56401531,56401610,56401612,56402230,56402231,56402232,56402310,56402311,56402312,56402320,56402411,56402500,56402501,56403201,56403210,55402301,55402302,55402303,553957313,553967131,553967133,553967301,553967303,553967321,553977131,553977133,554013233,554013303,554013310,554013312,554013330,554013332,554013333,554014222,554022303,554022312,554022313,554022321,554022322,554022323,554024120,554024122,554024123,554024320,554032003,554032012,554032013,554034102,554034300,554034322,554034323,554041121,554041123,554041231,554041233,554041301,554041302,554041303,554044110,554044112,554044113,554045202,554045220,554045222,554045223,554050133,554050202,554050203,554050211,554050212,554050213,554051003,554054330,554054332,554055010,554055200,554055202,554064110,554064112,554064130,554064132,554065212,554070221,554075122,564000011,564000013,564000033,564000211,564000213,564000231,564005100,564005101,564005102,564005120,564005122,564005300,564005302,564005303,564005330,564005332,564005333,564006132,564006203,564006310,564006312,564006330,564006332,564010100,564010101,564010103,564010121,564010310,564010311,564011120,564011121,564011123,564011200,564011301,564011303,564011321,564011322,564011323,564015320,564015321,564015322,564015330,564015331,564016110,564016112,564016200,564016201,564016202,564016210,564016211,564016300,564021031,564021300,564021301,564021310,564021311,564021313,564025100,564025102,564032000,564032001,564032003,564032021,554013321,554013322,554013323,554023001,554023003,5539573122,5539573123,5539573211,5539573213,5539573233,5539671011,5539671013,5539671233,5539671300,5539671301,5539671303,5539671321,5539671322,5539671323,5539673003,5539673021,5539673023,5539673231,5539771300,5539771301,5539771303,5539773111,5539773113,5539773131,5540132232,5540132233,5540132312,5540132313,5540133023,5540133132,5540133310,5540133312,5540133313,5540142202,5540142203,5540142212,5540142230,5540142232,5540142233,5540221133,5540221311,5540221313,5540221331,5540221333,5540223013,5540223102,5540223103,5540223111,5540223112,5540223113,5540223201,5540223203,5540240120,5540240122,5540240123,5540241212,5540241213,5540241322,5540243100,5540243210,5540243212,5540243220,5540243221,5540243222,5540311311,5540311313,5540311331,5540313313,5540313331,5540313333,5540320022,5540320023,5540320111,5540320112,5540320113,5540341000,5540341002,5540341032,5540343010,5540343011,5540343012,5540343020,5540343021,5540343022,5540343030,5540343200,5540343202,5540343203,5540343212,5540343322,5540411031,5540411032,5540411033,5540411120,5540411122,5540411123,5540411132,5540411133,5540411203,5540411221,5540412321,5540412322,5540412323,5540413003,5540450022,5540450200,5540450202,5540450220,5540450222,5540452000,5540452002,5540452030,5540452032,5540452210,5540452212,5540452213,5540452302,5540452320,5540452322,5540501222,5540501223,5540501232,5540501233,5540501311,5540501312,5540501313,5540501321,5540501322,5540501323,5540502012,5540502013,5540502102,5540502103,5540510011,5540510013,5540510022,5540510023,5540543310,5540543311,5540543312,5540543330,5540543332,5540550120,5540550121,5540550122,5540550300,5540550302,5540550320,5540552010,5540552012,5540552200,5540552201,5540552203,5540641331,5540641332,5540641333,5540650222,5540650223,5540652132,5540652133,5540653202,5540653220,5540653222,5540702200,5540702201,5540702203,5540702230,5540702231,5540702233,5540751000,5540751002,5540751020,5540751022,5540751200,5540751202,5540753000,5540753001,5540753002,5540753020,5540753022,5540753023,5540753300,5540753302,5540753303,5540753320,5540753322,5640000011,5640000100,5640000101,5640000103,5640000310,5640000311,5640000313,5640002330,5640002331,5640002333,5640051030,5640051032,5640051210,5640051212,5640051232,5640053010,5640053012,5640053013,5640053133,5640053311,5640053312,5640053313,5640060323,5640061232,5640061233,5640062003,5640062011,5640062012,5640062013,5640062021,5640062022,5640062023,5640063112,5640063130,5640063132,5640063310,5640063312,5640063330,5640100111,5640101021,5640101023,5640101231,5640101233,5640103011,5640103013,5640103120,5640103121,5640112010,5640112011,5640112100,5640112101,5640113020,5640113021,5640113023,5640113201,5640113202,5640113203,5640153230,5640153231,5640153232,5640153320,5640153321,5640161300,5640161302,5640161320,5640161322,5640162030,5640162031,5640162032,5640162120,5640162121,5640162122,5640162130,5640162131,5640162200,5640162201,5640163010,5640163011,5640163012,5640163020,5640210131,5640210132,5640210133,5640210330,5640210331,5640213030,5640213031,5640213121,5640213123,5640213310,5640213311,5640213313,5640213331,5640213333,5640251030,5640251032,5640251200,5640251201,5640251202,5640251210,5640311111,5640311113,5640320020,5640320021,5640320231,5540133011,5540133013,5540132322,5540132323,5540133201,5540133202,5540133203,5540230001,5540230003,5540230021,5540230022,5540230023,55395730331,55395730333,55395732101,55395732103,55395732121,55395732123,55395732303,55395732311,55395732312,55395732313,55395732321,55395732323,55396710101,55396710103,55396710121,55396710123,55396710301,55396710310,55396710311,55396710313,55396710331,55396710333,55396712313,55396712321,55396712323,55396713021,55396713023,55396713201,55396713202,55396713203,55396732301,55396732303,55396732331,55396732333,55397710111,55397710131,55397710133,55397710311,55397710313,55397710331,55397710333,55397712111,55397712113,55397713021,55397713023,55397713201,55397713210,55397713211,55397713213,55397713231,55397731100,55397731101,55397731331,55397731333,55397733111,55397733113,55401322313,55401323103,55401330213,55401333112,55401333113,55402211312,55402211313,55402213323,55402223323,55402223331,55402223332,55402223333,55402230033,55402230112,55402230113,55402230122,55402230123,55402230211,55402230213,55402230231,55402230233,55402231002,55402231003,55402231012,55402231013,55402231101,55402231102,55402231103,55402232001,55402232003,55402232021,55402232023,55402401000,55402401002,55402401020,55402401022,55402401023,55402401032,55402401210,55402401212,55402401213,55402401322,55402401323,55402401332,55402412100,55402412102,55402413200,55402413202,55402413230,55402413232,55402431010,55402431012,55402431020,55402431022,55402432230,55402432231,55402432232,55402432300,55402432301,55402432302,55402432320,55403111331,55403111333,55403113101,55403113103,55403113121,55403113123,55403113301,55403113303,55403113331,55403113333,55403131113,55403131131,55403131133,55403131311,55403131313,55403131331,55403131333,55403133111,55403133121,55403133123,55403133301,55403133303,55403133321,55403133323,55403200033,55403200122,55403200123,55403200132,55403200133,55403200211,55403200212,55403200213,55403201022,55403201023,55403201032,55403201033,55403201101,55403201102,55403201103,55403410010,55403410012,55403410030,55403410032,55403410033,55403410122,55403410300,55403410302,55403430230,55403430231,55403430232,55403430320,55403432010,55403432012,55403433202,55403433203,55403433212,55403433230,55403433232,55403433233,55404110231,55404110233,55404111111,55404111113,55404111131,55404111133,55404111210,55404111212,55404111311,55404111313,55404112011,55404112013,55404112231,55404112233,55404122332,55404122333,55404123023,55404123031,55404123032,55404123033,55404123201,55404123202,55404123203,55404130011,55404130012,55404130013,55404130022,55404130023,55404411122,55404411123,55404411132,55404411133,55404502232,55404520010,55404520012,55404520030,55404520032,55404520033,55404520122,55404520123,55404523232,55404523233,55405003313,55405003331,55405003332,55405003333,55405012202,55405012203,55405012212,55405012213,55405012302,55405012303,55405012312,55405012313,55405013023,55405013032,55405013033,55405013102,55405013103,55405013201,55405013202,55405013203,55405100121,55405100123,55405100211,55405100213,55405433130,55405433132,55405433310,55405433312,55405433330,55405433332,55405501230,55405501231,55405520300,55405520301,55405520302,55405520320,55405520322,55405522021,55405522023,55405522100,55405522102,55405522120,55405522122,55406411100,55406411102,55406411120,55406411300,55406411302,55406411320,55406411322,55406413100,55406413102,55406413120,55406413122,55406413132,55406413133,55406413300,55406413302,55406413303,55406502202,55406502203,55406502320,55406502322,55406521020,55406521022,55406521300,55406521302,55406532002,55406532003,55407022021,55407022023,55407022320,55407022321,55407022323,55407510232,55407512010,55407512012,55407512030,55407512032,55407512300,55407512302,55407512320,55407512322,55407530030,55407530031,55407530032,55407530100,55407530102,55407530120,55407530210,55407530212,55407530213,55407530302,55407530320,55407530322,55407530323,55407530332,55407530333,55407531222,55407531223,55407533012,55407533013,56400000101,56400000103,56400000121,56400000130,56400000131,56400001020,56400001021,56400001023,56400001211,56400001213,56400001231,56400001233,56400003120,56400003121,56400023320,56400023321,56400510310,56400510312,56400511000,56400511001,56400511002,56400511020,56400511022,56400512112,56400512130,56400512132,56400512300,56400512301,56400512302,56400512310,56400512330,56400512332,56400530110,56400530112,56400530113,56400531002,56400531020,56400531022,56400531200,56400531202,56400531220,56400531222,56400531223,56400531232,56400531233,56400531312,56400531313,56400533102,56400533103,56400603221,56400603223,56400603320,56400603322,56400612231,56400612233,56400613320,56400613322,56400620012,56400620013,56400620023,56400620102,56400620103,56400620201,56400620202,56400620203,56400631100,56400631102,56400631103,56400633320,56400633321,56400633322,56401001131,56401001133,56401010201,56401010203,56401012010,56401012011,56401012013,56401012031,56401012033,56401012211,56401012300,56401012301,56401012303,56401012321,56401012323,56401112200,56401112201,56401112210,56401112211,56401112213,56401112231,56401112233,56401123311,56401123313,56401123331,56401130011,56401130013,56401130022,56401130023,56401130031,56401130032,56401130033,56401532330,56401532331,56401532332,56401533220,56401533221,56401533230,56401533231,56401533300,56401533301,56401533310,56401533311,56401611100,56401611102,56401613010,56401613011,56401620330,56401620332,56401622020,56401622021,56401622030,56401622031,56401622100,56401622101,56401630130,56401630132,56401630210,56401630212,56401631000,56401631002,56402101123,56402101132,56402101133,56402101231,56402101233,56402101301,56402101302,56402101303,56402103011,56402103013,56402103031,56402103331,56402103333,56402130200,56402130201,56402130210,56402130211,56402130213,56402130231,56402130320,56402130321,56402130330,56402130331,56402131200,56402131201,56402133010,56402133011,56402133120,56402133121,56402133123,56402133301,56402133303,56402133321,56402133323,56402510100,56402510102,56402510120,56402510122,56402510123,56402512030,56402512031,56402512032,56402512120,56402512121,56402512200,56402512201,56402512210,56403111101,56403111103,56403111121,56403111123,56403111301,56403111310,56403111311,56403200220,56403200221,56403200230,56403200231,56403200233,56403202011,56403202331,55401330103,55401312331,55401312332,55401312333,55401313220,55401313222,55401313223,55401331120,55401331122,55401422002,55401422003,55401331300,55401331302,55401331303,55401323211,55401323212,55401323213,55401323033,55401332001,55401332002,55401332003,55401323112,55401323113,55401330121,55401330122,55401330123,55401323202,55401323203,55401322232,55401322233,55402300001,55402300003,55402300021,55402300023,55402300201,55402300202,55402300203,
017,00,ż㾾/¿,500990625,133059375,505026562,136275000,31,36,81,181,382,743,553954,553955,553963,553964,553965,553966,553972,553973,553974,553975,553976,563902,563903,563904,563905,563906,563907,563914,563915,563916,563917,563925,563926,563927,563935,563936,563937,563946,563947,564020,564030,5539433,5539440,5539442,5539443,5539531,5539532,5539533,5539562,5539613,5539621,5539622,5539623,5539670,5539672,5539770,5539772,5639121,5639130,5639131,5639133,5639341,5639450,5639451,5639453,5639560,5639561,5639570,5640102,5640212,5640310,5640312,5640313,5640400,5640401,5640402,5640410,55393333,55393422,55394311,55394312,55394313,55394323,55394412,55394413,55394520,55394522,55394523,55394532,55394533,55395231,55395233,55395301,55395303,55395600,55395602,55395603,55395630,55395632,55395633,55395722,55395723,55396201,55396203,55397111,55397113,55397131,55397133,55397730,55397732,56390133,56391111,56391200,56391201,56391321,56392411,56392413,56392431,56392433,56393430,56393431,56393433,56394521,56395510,56395511,56395513,56395620,56395631,56395710,56395712,56395720,56395721,56395730,56400002,56400020,56400022,56401000,56401002,56401003,56401032,56401033,56401122,56402100,56402102,56402132,56403110,56403112,56403113,56404030,56404031,56404032,56404110,56404112,56404120,56404121,56404123,56404130,56404132,553933303,553933312,553933313,553933321,553933323,553934202,553934230,553934232,553934233,553943033,553943101,553943102,553943103,553943211,553943213,553943223,553944100,553944102,553944103,553944112,553944113,553945022,553945023,553945210,553945212,553945213,553945302,553946222,553952132,553952133,553952232,553953001,553953003,553953021,553953022,553953023,553956011,553956012,553956013,553956312,553957322,553961123,553961131,553961133,553961213,553961231,553961233,553962001,553962003,553962021,553962022,553962023,553967100,553967102,553967120,553967121,553967122,553967320,553967322,553971100,553971101,553971103,553971121,553977100,553977102,553977120,553977122,553977123,553977310,553977312,553977330,553977332,553977333,554070222,563901111,563901113,563901131,563901133,563901311,563901312,563901313,563901323,563911130,563912020,563912021,563912030,563912031,563912033,563912311,563913230,563913231,563913233,563923011,563923100,563923101,563923111,563924000,563924001,563924010,563924011,563924101,563924121,563924123,563924301,563924303,563924321,563924323,563934031,563934033,563934321,563944111,563945201,563945203,563945230,563945231,563945233,563955011,563955120,563955121,563955123,563955310,563955311,563955313,563956210,563956211,563956212,563956220,563956221,563956230,563956300,563956301,563956303,563956330,563956331,563957110,563957111,563957112,563957231,563965103,564000000,564000002,564000003,564000030,564000032,564000210,564000212,564000230,564000232,564010010,564010012,564010013,564010300,564010302,564010303,564010313,564011202,564011203,564011211,564011212,564011213,564011230,564011231,564011232,564021010,564021032,564021332,564031110,564031112,564032022,564032200,564032202,564032220,564040330,564041221,564041332,564050000,564050001,564050010,564050011,564050013,564050031,5539333022,5539333023,5539333113,5539333200,5539333201,5539333203,5539333221,5539333223,5539342002,5539342032,5539342033,5539342122,5539342312,5539342313,5539343220,5539343222,5539343223,5539430312,5539430313,5539431001,5539431003,5539432211,5539432213,5539432223,5539441010,5539441012,5539450200,5539450202,5539450203,5539450212,5539450320,5539450322,5539450323,5539452110,5539452112,5539453030,5539453032,5539453033,5539462200,5539462202,5539462203,5539462230,5539462232,5539462233,5539521233,5539521312,5539521313,5539522332,5539522333,5539523011,5539523013,5539523031,5539523033,5539523211,5539523213,5539523222,5539523231,5539530001,5539530003,5539530021,5539530201,5539530203,5539560102,5539560103,5539561000,5539561001,5539561002,5539561020,5539561022,5539561023,5539561200,5539561201,5539561202,5539561220,5539561222,5539561223,5539561232,5539563102,5539563103,5539563112,5539563130,5539563132,5539563133,5539572022,5539572023,5539572122,5539572123,5539573200,5539573202,5539573203,5539611132,5539611201,5539611203,5539611210,5539611212,5539611213,5539611221,5539611222,5539611223,5539611303,5539611321,5539611322,5539611323,5539612111,5539612113,5539612301,5539612303,5539612321,5539620003,5539620021,5539620023,5539620201,5539620202,5539620203,5539671032,5539671230,5539673000,5539673001,5539673002,5539673020,5539673022,5539673232,5539710111,5539710113,5539711020,5539711021,5539711023,5539711201,5539711203,5539771010,5539771012,5539771030,5539771032,5539771210,5539771212,5539771213,5539771322,5539773112,5539773130,5539773132,5539773310,5539773312,5539773313,5639011100,5639011101,5639011103,5639013031,5639013033,5639013203,5639013211,5639013212,5639013213,5639013221,5639111011,5639111013,5639111031,5639111033,5639111310,5639111311,5639111313,5639120220,5639120320,5639120321,5639123001,5639123010,5639123100,5639123101,5639123103,5639132000,5639132001,5639132010,5639132011,5639132320,5639132321,5639132323,5639230101,5639230103,5639230131,5639231020,5639231021,5639231030,5639231031,5639231100,5639231101,5639231102,5639240020,5639240031,5639240120,5639241000,5639241001,5639241030,5639241031,5639241033,5639241221,5639241223,5639243000,5639243001,5639243003,5639243021,5639243023,5639243201,5639243203,5639243221,5639243222,5639243223,5639340131,5639340132,5639340133,5639342110,5639342111,5639342113,5639342131,5639342132,5639342133,5639342311,5639343200,5639343201,5639343203,5639343230,5639343231,5639343233,5639441101,5639441103,5639441130,5639441131,5639441133,5639452001,5639452003,5639452211,5639452321,5639452323,5639550101,5639550103,5639550130,5639550131,5639550133,5639550311,5639550313,5639551221,5639553010,5639553011,5639553121,5639553123,5639553310,5639553311,5639553313,5639553323,5639553330,5639562130,5639562131,5639562132,5639562221,5639562230,5639562231,5639562310,5639562312,5639562320,5639562321,5639563020,5639563021,5639563023,5639563210,5639563211,5639563321,5639563330,5639571300,5639571301,5639571302,5639571320,5639572200,5639572300,5639572330,5639572331,5639573200,5639573201,5639573202,5639573210,5639573211,5639573220,5639650113,5639650131,5639651002,5639651020,5639651021,5639651100,5639651102,5639651120,5639651122,5640000120,5640000122,5640100110,5640100112,5640101022,5640101200,5640101202,5640101220,5640101222,5640101223,5640103010,5640103012,5640103122,5640103123,5640111222,5640112012,5640112013,5640112102,5640112103,5640112330,5640112332,5640113000,5640113022,5640113200,5640210110,5640210111,5640210120,5640210121,5640210122,5640210300,5640210302,5640210332,5640213022,5640213122,5640213300,5640213302,5640213303,5640311132,5640311133,5640320200,5640320202,5640320203,5640320230,5640320232,5640322010,5640322012,5640322030,5640322032,5640322210,5640322220,5640403310,5640403311,5640403312,5640403320,5640403321,5640403322,5640411100,5640411101,5640411102,5640411120,5640411122,5640411300,5640411302,5640411303,5640411320,5640411322,5640412200,5640412201,5640412203,5640412230,5640412231,5640412233,5640413100,5640413102,5640413120,5640413122,5640413300,5640413302,5640413303,5640500031,5640500120,5640500121,5640500123,5640501000,5640501001,5640501002,5640501010,5640501011,5640501020,5640501022,5640510100,5640510101,5640510110,5640510111,55393330033,55393330103,55393330112,55393330121,55393330122,55393330123,55393330130,55393330132,55393330133,55393330211,55393330212,55393330213,55393331022,55393331023,55393331032,55393331033,55393331103,55393331112,55393331113,55393331121,55393331122,55393331123,55393332020,55393332021,55393420002,55393420003,55393420012,55393420030,55393420032,55393420033,55393420302,55393420303,55393420312,55393421230,55393421232,55393423100,55393423102,55393432210,55393432212,55393432213,55393432302,55393432320,55393432322,55393432323,55393432332,55394301331,55394301333,55394303033,55394303111,55394303113,55394303211,55394303213,55394303231,55394303233,55394321013,55394321031,55394321033,55394321211,55394321213,55394321231,55394321233,55394322033,55394322121,55394322122,55394322123,55394322211,55394322212,55394322213,55394410110,55394410112,55394410130,55394410132,55394410133,55394411022,55394411023,55394411032,55394411033,55394411122,55394411123,55394411132,55394411133,55394500200,55394500202,55394500220,55394500222,55394502130,55394502132,55394502133,55394503022,55394503023,55394503212,55394503213,55394503302,55394503320,55394503322,55394503323,55394521132,55394530310,55394530312,55394622120,55394622122,55394622123,55394622132,55394622310,55394622312,55394622313,55394623222,55394623233,55394623322,55394623323,55394623332,55394623333,55394632222,55394632223,55394632232,55394632233,55394632322,55395212312,55395212313,55395213013,55395213022,55395213023,55395213031,55395213032,55395213033,55395213102,55395213103,55395213112,55395213113,55395222313,55395222323,55395222331,55395222332,55395222333,55395223022,55395223023,55395223032,55395223033,55395223122,55395223300,55395223302,55395223303,55395223312,55395223313,55395230321,55395230323,55395232101,55395232103,55395232121,55395232123,55395232202,55395232203,55395232212,55395232230,55395232232,55395232233,55395232322,55395232323,55395232332,55395232333,55395300230,55395300231,55395300233,55395302001,55395302003,55395302021,55395302022,55395302023,55395601000,55395601002,55395601003,55395601011,55395601012,55395601013,55395610030,55395610032,55395610100,55395610102,55395610210,55395610212,55395610320,55395610322,55395612030,55395612032,55395612100,55395612102,55395612210,55395612212,55395612213,55395612302,55395612303,55395631000,55395631002,55395631310,55395631312,55395720320,55395720322,55395721320,55395721322,55395732010,55395732012,55395732013,55395732102,55395732120,55395732122,55395732300,55395732301,55395732302,55395732310,55395732320,55395732322,55396103331,55396103333,55396110232,55396110233,55396110322,55396110323,55396111231,55396111233,55396111330,55396111332,55396111333,55396112023,55396112112,55396112113,55396112201,55396112203,55396113002,55396113011,55396113012,55396113013,55396113020,55396113022,55396113200,55396113202,55396113203,55396121121,55396121123,55396121211,55396121213,55396121231,55396121232,55396121233,55396123231,55396123233,55396202002,55396202003,55396710100,55396710102,55396710120,55396710122,55396710300,55396710302,55396710303,55396710312,55396710330,55396710332,55396712310,55396712311,55396712312,55396712320,55396712322,55396713020,55396713022,55396713200,55396732300,55396732302,55396732330,55396732332,55397101011,55397101100,55397101101,55397101103,55397101121,55397101310,55397101311,55397101313,55397110221,55397110223,55397112001,55397112003,55397112300,55397112301,55397112310,55397112311,55397112313,55397112331,55397112333,55397130111,55397130113,55397130131,55397130133,55397130311,55397130313,55397130331,55397130333,55397710110,55397710112,55397710113,55397710130,55397710132,55397710310,55397710312,55397710330,55397710332,55397712110,55397712112,55397713020,55397713022,55397713200,55397713202,55397713203,55397713212,55397713230,55397713232,55397713233,55397731102,55397731103,55397731330,55397731332,55397733110,55397733112,55407022020,55407022022,55407022322,56390111020,56390111021,56390111211,56390111213,56390111231,56390111233,56390113011,56390113013,56390130123,56390130132,56390130133,56390130301,56390130303,56390130321,56390130323,56390131011,56390131013,56390131022,56390131023,56390131031,56390131032,56390131033,56390132101,56390132102,56390132103,56390132230,56390132231,56391110100,56391110101,56391110103,56391110121,56391110123,56391110301,56391110303,56391110321,56391110323,56391112111,56391112113,56391112131,56391113120,56391113121,56391113200,56391113201,56391113210,56391113211,56391113310,56391113311,56391113313,56391113331,56391202210,56391202211,56391202212,56391202220,56391202221,56391202230,56391202300,56391202301,56391202310,56391202311,56391202313,56391202331,56391203220,56391203221,56391203230,56391203231,56391231021,56391231023,56391323220,56391323221,56391323223,56392301001,56392301003,56392301021,56392301023,56392301301,56392301303,56392310231,56392310320,56392310321,56392310330,56392311200,56392311202,56392311311,56392311313,56392400210,56392400212,56392400301,56392400303,56392401210,56392401212,56392410031,56392410033,56392412031,56392412033,56392412222,56392412223,56392432202,56392432203,56393401301,56393401303,56393421120,56393421121,56393421123,56393421301,56393421303,56393423100,56393423101,56393423103,56393423121,56393423130,56393423131,56393432020,56393432021,56393432211,56393432213,56394411001,56394411003,56394411210,56394411211,56394411320,56394411321,56394411323,56394413101,56394413110,56394413111,56394413113,56394413131,56394413133,56394413311,56394413313,56394520000,56394520001,56394520003,56394520021,56394520023,56394520201,56394520210,56394520211,56394520213,56394520231,56394522100,56394522101,56394522131,56394522133,56394523201,56394523203,56394523221,56394523223,56395501001,56395501003,56395501021,56395501210,56395501211,56395501320,56395501321,56395501323,56395512201,56395512203,56395512231,56395530120,56395530121,56395530130,56395530131,56395530133,56395530311,56395531200,56395531201,56395531203,56395531221,56395531223,56395533011,56395533013,56395533033,56395533121,56395533122,56395533123,56395533211,56395533212,56395533213,56395533221,56395533223,56395533310,56395533312,56395533320,56395533321,56395621330,56395621332,56395622201,56395622203,56395622330,56395622331,56395623110,56395623112,56395623220,56395623221,56395623230,56395630221,56395630223,56395633310,56395633312,56395711300,56395711301,56395711302,56395711310,56395711311,56395711320,56395711322,56395713220,56395713221,56395713222,56395723010,56395723012,56395723330,56395723331,56395731000,56395731020,56395731022,56395731200,56395731202,56395732030,56395732032,56395732210,56395732212,56395732220,56395732221,56396510111,56396510113,56396510131,56396510133,56396510231,56396510233,56396511010,56396511011,56396511012,56396511030,56396511032,56396511210,56400000100,56400000102,56400000120,56400000122,56400000123,56400000132,56400000133,56400001022,56400001210,56400001212,56400001230,56400001232,56400003122,56400003123,56400023322,56400023323,56401001130,56401001132,56401010200,56401010202,56401012012,56401012030,56401012032,56401012210,56401012212,56401012213,56401012302,56401012320,56401012322,56401112202,56401112203,56401112212,56401112230,56401112232,56401123310,56401123312,56401123330,56401123332,56401123333,56401130010,56401130012,56401130020,56401130021,56401130030,56402101120,56402101121,56402101122,56402101130,56402101131,56402101230,56402101232,56402101300,56402103010,56402103012,56402103030,56402103032,56402103033,56402103330,56402103332,56402130202,56402130203,56402130212,56402130230,56402130232,56402130233,56402130322,56402130323,56402130332,56402130333,56402131202,56402131203,56402133012,56402133013,56402133122,56402133300,56402133302,56402133320,56402133322,56403111100,56403111102,56403111120,56403111122,56403111300,56403111302,56403111303,56403111312,56403111313,56403200222,56403200223,56403200232,56403202010,56403202012,56403202013,56403202330,56403202332,56403220110,56403220111,56403220112,56403220130,56403220132,56403220310,56403220312,56403220330,56403220332,56403221000,56403222110,56403222112,56403222120,56403222121,56403222130,56403222210,56403222211,56403222220,56403222221,56404033130,56404033132,56404111100,56404111101,56404111102,56404111110,56404111111,56404113012,56404113013,56404113210,56404113211,56404122211,56404122213,56404122321,56404122323,56404133012,56404133013,56404133102,56404133120,56405000200,56405000201,56405000210,56405000211,56405000300,56405000301,56405000303,56405000321,56405000330,56405000331,56405001220,56405001221,56405001223,56405003011,56405003013,56405010030,56405010031,56405010032,56405010120,56405010121,56405010130,56405010131,56405010210,56405010212,56405010230,56405011000,56405011001,56405011002,56405011020,56405100101,56405100110,56405100111,56405101020,56405101021,56405101030,56405101031,56405101120,56405101121,56405101130,56405101131,56405110000,56405110001,56405110002,56405110010,56405110011,56405110020,56405110100,56405110101,
018,00,來,506067187,132675000,508050000,136462500,23,25,73,93,206,431,554035,554036,554046,554066,554067,554076,554077,564007,564017,564026,564027,564036,564037,564046,564047,564057,554057,554047,554037,564100,554170,564110,554056,5540451,5540453,5540551,5540553,5540651,5640353,5640451,5640561,5640670,5640671,5641400,5641402,5641500,5641302,5641300,5641202,5641200,5541602,5541600,5541502,5541500,5540263,5540272,5540262,5541302,55402522,55402523,55402531,55402532,55402533,55403413,55403431,55404501,55404503,55404521,55405521,55405523,55406500,55406501,55406503,55406530,55406531,55406533,55407511,55407513,56400513,56400600,56400601,56400602,56400610,56400611,56401623,56401632,56401633,56402511,56402513,56402531,56403513,56404530,56404531,56405600,56405601,56405603,56406720,56406721,56406730,56415020,56415022,56416000,56415021,56413010,56413012,56413030,56413032,56414010,56412030,56412032,56412010,56412012,55416032,55414023,55414020,55414022,55414002,55414000,55413002,55413000,55402732,55402612,55402613,55414001,55416030,55402733,55416033,55416012,55416010,56414012,56412011,554024331,554024333,554025132,554025133,554025301,554025302,554025303,554026022,554026023,554026030,554026032,554034111,554034112,554034113,554034330,554034331,554034333,554045000,554045001,554045003,554045021,554045023,554045231,554045233,554055011,554055013,554055031,554055033,554055222,554055223,554065020,554065021,554065211,554065321,554065323,554075101,554075103,554075121,554075310,554075311,554075313,554075331,554075333,564005111,564005112,564005113,564005311,564006030,564006031,564006120,564006121,564006130,564006131,564016113,564016131,564016133,564016222,564016223,564016303,564016311,564016312,564016313,564025123,564025301,564025331,564025333,564035111,564035113,564035123,564035233,564045013,564045031,564045330,564045331,564055121,564055123,564055130,564055131,564055132,564056020,564056021,564056023,564056210,564056311,564056313,564056331,564056333,564066111,564066113,564066131,564066133,564066311,554026033,5540243323,5540251231,5540251233,5540252123,5540252131,5540252132,5540252133,5540253003,5540260203,5540260210,5540260212,5540260213,5540341101,5540341102,5540341103,5540343013,5540343031,5540343033,5540343210,5540343211,5540343213,5540441110,5540441111,5540450020,5540450021,5540450023,5540450201,5540450203,5540450221,5540452010,5540452011,5540452013,5540452031,5540452033,5540452211,5540452300,5540452301,5540452303,5540452321,5540550301,5540550303,5540550321,5540550322,5540550323,5540552011,5540552013,5540552031,5540552033,5540552211,5540552213,5540641111,5540641113,5540641131,5540641133,5540641311,5540650221,5540650230,5540650231,5540650233,5540652100,5540652101,5540652103,5540652131,5540653201,5540653203,5540653221,5540653223,5540751001,5540751003,5540751021,5540751231,5540751233,5540753011,5540753013,5540753031,5540753120,5540753121,5540753123,5540753321,5540753323,5640051033,5640051101,5640051103,5640053101,5640053103,5640053121,5640053130,5640053132,5640060320,5640060321,5640060330,5640060331,5640060333,5640061220,5640061221,5640061222,5640061230,5640061231,5640061330,5640061331,5640061333,5640062000,5640063111,5640063113,5640063131,5640063133,5640063311,5640063313,5640063331,5640063333,5640153332,5640153333,5640161111,5640161112,5640161113,5640161303,5640161321,5640161323,5640162123,5640162132,5640162133,5640162211,5640162212,5640162213,5640163022,5640163023,5640163101,5640163102,5640163103,5640251011,5640251013,5640251031,5640251033,5640251211,5640251213,5640251223,5640253031,5640253033,5640253211,5640253300,5640253301,5640253303,5640253321,5640351123,5640351212,5640351213,5640351221,5640351222,5640351223,5640352111,5640352113,5640352131,5640352133,5640352311,5640352313,5640450111,5640450113,5640450123,5640450330,5640450331,5640450333,5640452111,5640452113,5640453200,5640453201,5640453210,5640453211,5640453213,5640453320,5640453321,5640453330,5640453331,5640453333,5640551033,5640551201,5640551202,5640551203,5640551221,5640551330,5640551331,5640553010,5640553011,5640560220,5640560221,5640562010,5640562011,5640562013,5640562031,5640562110,5640562111,5640563000,5640563001,5640563010,5640661103,5640661121,5640663130,5640663131,5640663133,5640672201,5640672210,5640672211,5640672213,5640672301,5540260312,5540260311,5540260313,55402433211,55402433213,55402512321,55402512322,55402512323,55402520223,55402520232,55402520233,55402520322,55402520323,55402520332,55402520333,55402521132,55402521133,55402521203,55402521212,55402521213,55402521221,55402521222,55402521223,55402521302,55402521303,55402530012,55402530013,55402530022,55402530023,55402602011,55402602013,55402602021,55402602023,55402602110,55402602112,55402603100,55402603102,55403410113,55403410131,55403410133,55403410313,55403410331,55403410333,55403411002,55403411003,55403430233,55403430321,55403430322,55403430323,55403432011,55403432013,55403433200,55403433201,55403433210,55403433211,55403433213,55403433231,55404411120,55404411121,55404411130,55404411131,55404502230,55404502231,55404502233,55404520011,55404520013,55404520031,55404520120,55404520121,55404523230,55404523231,55405433131,55405433133,55405433311,55405433313,55405433331,55405433333,55405501232,55405501233,55405520303,55405520321,55405520323,55405522020,55405522022,55405522101,55405522103,55405522121,55405522123,55406411101,55406411103,55406411121,55406411122,55406411123,55406411301,55406411303,55406411321,55406411323,55406413101,55406413103,55406413121,55406413123,55406413130,55406413131,55406413301,55406502200,55406502201,55406502321,55406502323,55406521021,55406521023,55406521301,55406521303,55406532000,55406532001,55407510230,55407510231,55407510233,55407512011,55407512013,55407512031,55407512033,55407512301,55407512303,55407512321,55407512323,55407530033,55407530101,55407530103,55407530121,55407530122,55407530123,55407530211,55407530300,55407530301,55407530303,55407530321,55407530330,55407530331,55407531220,55407531221,55407533010,55407533011,56400510311,56400510313,56400511003,56400511021,56400511023,56400512110,56400512111,56400512113,56400512131,56400512133,56400512303,56400512311,56400512312,56400512313,56400512331,56400512333,56400530111,56400531000,56400531001,56400531003,56400531021,56400531023,56400531201,56400531203,56400531221,56400531230,56400531231,56400531310,56400531311,56400533100,56400533101,56400603220,56400603222,56400603321,56400603323,56400612230,56400612232,56400613321,56400613323,56400620010,56400620011,56400620020,56400620021,56400620022,56400620100,56400620101,56400620200,56400631101,56400633323,56401532333,56401533222,56401533223,56401533232,56401533233,56401533302,56401533303,56401533312,56401533313,56401611101,56401611103,56401613012,56401613013,56401620331,56401620333,56401622022,56401622023,56401622032,56401622033,56401622102,56401622103,56401630131,56401630133,56401630211,56401630213,56401631001,56401631003,56402510101,56402510103,56402510121,56402512033,56402512122,56402512123,56402512211,56402512212,56402512213,56402530010,56402530011,56402530013,56402530031,56402530033,56402530301,56402530303,56402530321,56402530323,56402532101,56402532103,56402533021,56402533023,56402533230,56402533231,56403503331,56403503333,56403510333,56403511212,56403511213,56403511222,56403511223,56403512013,56403512031,56403512032,56403512033,56403512102,56403512103,56403512111,56403512112,56403512113,56403521101,56403521103,56403521121,56403521123,56403521301,56403521303,56403521321,56403521323,56403523101,56403523103,56403523121,56403523123,56404501100,56404501101,56404501103,56404501121,56404501122,56404501123,56404501212,56404501213,56404503010,56404503011,56404503320,56404503321,56404503323,56404521101,56404521103,56404521121,56404521123,56404521311,56404521313,56404521331,56404521333,56404523111,56404532020,56404532021,56404532030,56404532031,56404532120,56404532121,56404532310,56404532311,56404532313,56404532331,56404533220,56404533221,56404533230,56404533231,56404533320,56404533321,56404533323,56405510232,56405510233,56405510303,56405510312,56405510313,56405510321,56405510322,56405510323,56405511111,56405511113,56405511131,56405511133,56405511202,56405511220,56405511222,56405511223,56405511232,56405511233,56405511311,56405511313,56405511322,56405511323,56405511331,56405511332,56405511333,56405512200,56405512201,56405512231,56405512233,56405513330,56405513331,56405530011,56405530013,56405530121,56405530123,56405530130,56405530131,56405530132,56405530301,56405530310,56405531000,56405531001,56405531002,56405531010,56405531011,56405531020,56405602220,56405602221,56405602231,56405602233,56405620011,56405620013,56405620031,56405620120,56405620121,56405620123,56405620301,56405621120,56405621121,56405621122,56405621130,56405621131,56405621200,56405621201,56405621202,56405621210,56405621211,56405621300,56405630020,56405630021,56405630030,56405630031,56405630110,56405630111,56405630120,56405630121,56405631000,56405631001,56405631010,56405631011,56405631013,56405631031,56405631033,56405631211,56405631213,56405631231,56405631233,56405633011,56405633013,56405633031,56405633033,56405633211,56405633213,56405633231,56405633233,56406611011,56406611013,56406611021,56406611023,56406611201,56406611203,56406611231,56406611233,56406613033,56406613211,56406613213,56406613231,56406613233,56406631011,56406631013,56406631031,56406631033,56406631211,56406631213,56406631321,56406631323,56406722121,56406722123,56406723000,56406723002,56406723020,56406723022,56406723100,56406723102,55402603103,
019,00,Լ,505687500,136425000,507937500,138656250,10,13,59,49,137,258,574026,574035,574036,574037,574045,574046,574047,574027,574017,574007,5740163,5740340,5740343,5740441,5740551,5740560,5740561,5740563,5740570,5740571,5741202,5640772,5640770,56406633,56407611,56407613,56407631,56407633,57400611,57400613,57400631,57400633,57401611,57401613,57401621,57401623,57402531,57402532,57402533,57403311,57403411,57403412,57403413,57403421,57403423,57404401,57404431,57404433,57405411,57405500,57405501,57405503,57405530,57405531,57405620,57405621,57405720,57405721,57405722,57405730,57405731,57413002,57414002,57414020,57414022,57415000,57415002,57413001,57413000,57413010,57412032,57412002,57412000,57411022,57412003,57411020,57411002,56407732,56407730,56406732,56407710,56407712,564067222,564067223,574034200,574034201,574034203,574044030,574044031,574044301,574044303,574044321,574044323,574054101,574054103,574054131,574055020,574055021,574055211,574055330,574055331,574056220,574056221,574056230,574056231,574057230,574057320,574057321,574057323,574057330,574057331,574057332,574130030,574130032,574130200,574130201,574140000,574140002,574140003,574140012,574140030,574140232,574150010,574150012,574150013,574150030,574150200,574150201,574150202,564067232,564067233,5640672200,5640672202,5640672203,5740331311,5740331313,5740331331,5740331333,5740333111,5740333113,5740342021,5740342023,5740342211,5740342233,5740440011,5740440013,5740440031,5740440033,5740440330,5740440331,5740440333,5740443001,5740443003,5740443021,5740443023,5740443201,5740443203,5740443221,5740443223,5740541211,5740541300,5740541301,5740541330,5740541331,5740550221,5740550230,5740550231,5740550233,5740552100,5740552101,5740552103,5740552130,5740552131,5740552133,5740553201,5740553210,5740553211,5740553213,5740553321,5740553330,5740553331,5740562220,5740562221,5740562230,5740562231,5740562320,5740562321,5740562330,5740562331,5740572310,5740572311,5740572320,5740572322,5740573221,5740573330,5740573331,5740573332,5740661011,5740661100,5740661101,5740661110,5740670001,5740670003,5740670010,5740670012,5740670030,5740671011,5740671100,5741300310,5741300330,5741300332,5741302020,5741302021,5741302022,5741302030,5741302031,5741302100,5741302102,5741302120,5741302200,5741302202,5741302220,5741302222,5741302223,5741400011,5741400012,5741400013,5741400100,5741400102,5741400103,5741400112,5741400113,5741400130,5741400131,5741400132,5741400310,5741400312,5741400320,5741400321,5741400330,5741402102,5741402120,5741402122,5741402300,5741402302,5741402303,5741402312,5741402330,5741402332,5741500110,5741500112,5741500113,5741500310,5741500311,5741500320,5741500322,5741501020,5741501022,5741501200,5741502030,5741502032,5741502100,5741502200,5741401002,5640672311,5640672313,5640672312,5640672303,56406722120,56406722122,57403313000,57403313001,57403313010,57403313011,57403313100,57403313101,57403313103,57403331310,57403331311,57403420200,57403420201,57403420203,57403420221,57403420223,57403422101,57403422103,57403422131,57403422133,57403422303,57403422311,57403422312,57403422313,57403422321,57403422323,57404400101,57404400103,57404400121,57404400123,57404400301,57404400303,57404400321,57404400323,57404402111,57404402113,57404403211,57404403213,57404403321,57404403323,57404421101,57404421110,57404421111,57404430000,57404430001,57404430003,57404430021,57404430023,57404430201,57405410010,57405410011,57405412101,57405412103,57405413031,57405413033,57405413320,57405413321,57405413330,57405413331,57405502200,57405502201,57405502230,57405502231,57405502320,57405502321,57405502323,57405520101,57405520110,57405520111,57405521020,57405521021,57405521023,57405521211,57405521213,57405532001,57405532003,57405532030,57405532031,57405532120,57405532121,57405532310,57405532311,57405533200,57405533201,57405533203,57405533221,57405533230,57405533231,57405533320,57405533321,57405533330,57405533331,57405622220,57405622221,57405622230,57405622231,57405622320,57405622321,57405622330,57405622331,57405623220,57405623221,57405623230,57405623231,57405623320,57405623321,57405623330,57405623331,57405623333,57405723120,57405723121,57405723122,57405723130,57405723131,57405723133,57405723210,57405723211,57405723300,57405723311,57405732200,57405732201,57405732230,57405732231,57405732233,57405733330,57405733331,57406601111,57406610000,57406610001,57406610010,57406610011,57406610100,57406610101,57406610103,57406610121,57406610130,57406610131,57406611020,57406611021,57406611030,57406611031,57406611110,57406611111,57406611120,57406611121,57406700000,57406700001,57406700110,57406700111,57406700112,57406700130,57406700132,57406700211,57406700213,57406701000,57406701001,57406710011,57406710100,57406710101,57406710103,57406710121,57406710130,57406710131,57406711010,57406711011,57406711012,57406711020,57406711021,57406711030,57406711100,57406711101,57413003120,57413003122,57413003123,57413020230,57413020231,57413020232,57413020320,57413020321,57413020330,57413020331,57413021010,57413021011,57413021012,57413021030,57413021032,57413021100,57413021210,57413021220,57413021221,57413022010,57413022012,57413022030,57413022032,57413022210,57413022212,57413022213,57414000100,57414000102,57414001010,57414001012,57414001330,57414001331,57414001332,57414003110,57414003112,57414003221,57414003230,57414003231,57414003320,57414010200,57414010202,57414010220,57414021210,57414021212,57414021230,57414021232,57414023010,57414023012,57414023013,57414023102,57414023103,57414023330,57414023332,57415001110,57415001112,57415003120,57415003122,57415003210,57415003212,57415003230,57415003232,57415010020,57415010022,57415020310,57415020312,57415020330,57415020332,57415021010,57415021012,57415021020,57415021021,57415021030,57415022010,57415022012,57415022020,57415022021,57415022022,57415022030,57415022200,57414010003,57414010002,56406723001,56406723003,56406723021,56406723023,56406723103,56406723101,
019,01,,504984375,136031250,507107812,137775000,6,19,41,57,138,299,564075,574004,574005,574014,574015,574024,5640660,5640662,5640733,5640740,5640742,5640743,5640760,5640762,5740021,5740030,5740031,5740033,5740060,5740062,5740131,5740160,5740250,5740251,5740252,56405533,56405622,56405623,56405632,56406511,56406513,56406531,56406532,56406533,56406610,56406612,56406630,56406632,56407223,56407232,56407233,56407322,56407323,56407411,56407412,56407413,56407610,56407612,56407630,56407632,57400203,57400321,57400610,57400612,57400630,57400632,57401331,57401333,57401610,57401612,57401620,57401622,57402331,57402333,57402530,57403410,564055311,564055312,564055313,564055321,564055323,564056202,564056302,564056303,564063333,564064222,564065101,564065103,564065121,564065123,564065222,564065223,564065231,564065232,564065233,564065301,564065303,564072302,564072303,564072312,564072313,564073111,564073113,564073131,564073133,564073202,564073213,564074102,564074103,574002011,574002013,574002210,574002211,574002300,574002301,574002310,574002311,574003200,574003201,574003203,574003230,574003231,574003233,574013011,574013013,574013301,574013303,574023110,574023111,574023113,574023131,574023132,574023133,5640551332,5640553032,5640553033,5640553103,5640553201,5640553203,5640553221,5640553223,5640562000,5640562002,5640562032,5640562033,5640562122,5640562123,5640562131,5640562132,5640562133,5640563013,5640563102,5640563120,5640563122,5640563300,5640563302,5640563320,5640563322,5640633313,5640642232,5640642233,5640642322,5640642323,5640642332,5640642333,5640643233,5640643322,5640643323,5640651001,5640651003,5640651221,5640651223,5640652133,5640652203,5640652212,5640652213,5640652302,5640652303,5640653022,5640653023,5640661100,5640661122,5640661300,5640661301,5640661302,5640661320,5640661322,5640663100,5640663102,5640663120,5640663122,5640663123,5640722123,5640722131,5640722132,5640722133,5640722211,5640722213,5640722231,5640723002,5640723003,5640723012,5640723013,5640723100,5640723102,5640723103,5640723112,5640723113,5640731121,5640731233,5640731322,5640731323,5640732000,5640732002,5640732032,5640732033,5640732111,5640732112,5640732113,5640732122,5640732123,5640741011,5640741012,5640741013,5740020101,5740020103,5740020121,5740020122,5740020123,5740020211,5740020213,5740020231,5740022031,5740022120,5740022121,5740022130,5740022131,5740023020,5740023021,5740023030,5740023031,5740023120,5740023121,5740023130,5740023131,5740032020,5740032021,5740032023,5740032201,5740032210,5740032211,5740032321,5740130121,5740130310,5740130311,5740130313,5740130330,5740130331,5740130333,5740132111,5740133000,5740133001,5740133003,5740133021,5740133210,5740133211,5740133213,5740231121,5740231123,5740231301,5740231303,56405513332,56405513333,56405530133,56405530213,56405530231,56405530233,56405530302,56405530303,56405530311,56405530312,56405530313,56405531003,56405531012,56405531013,56405531021,56405531022,56405531023,56405532222,56405532223,56405602222,56405602223,56405602230,56405602232,56405620010,56405620012,56405620030,56405620032,56405620033,56405620122,56405620300,56405620302,56405620303,56405621123,56405621132,56405621133,56405621203,56405621212,56405621213,56405621301,56405621302,56405621303,56405630022,56405630023,56405630032,56405630033,56405630112,56405630113,56405630122,56405630123,56405631002,56405631003,56405631012,56405631030,56405631032,56405631210,56405631212,56405631230,56405631232,56405633010,56405633012,56405633030,56405633032,56405633210,56405633212,56405633230,56405633232,56406333213,56406333231,56406333233,56406422302,56406422303,56406422312,56406422313,56406423202,56406423203,56406423212,56406423213,56406423302,56406423303,56406423312,56406423313,56406432312,56406432313,56406432323,56406433202,56406433203,56406433212,56406433213,56406433322,56406433323,56406433332,56406433333,56406510211,56406510213,56406510231,56406510233,56406512011,56406512013,56406512031,56406512033,56406512222,56406512223,56406521321,56406521323,56406530011,56406530013,56406530031,56406530033,56406530211,56406530213,56406611010,56406611012,56406611020,56406611022,56406611200,56406611202,56406611230,56406611232,56406613030,56406613031,56406613032,56406613210,56406613212,56406613230,56406613232,56406631010,56406631012,56406631030,56406631032,56406631210,56406631212,56406631320,56406631322,56407212333,56407213222,56407213223,56407213333,56407220332,56407221301,56407221303,56407222330,56407222331,56407222333,56407230012,56407230013,56407230102,56407230103,56407230111,56407230112,56407230113,56407231012,56407231013,56407231102,56407231103,56407231111,56407231112,56407231113,56407302222,56407302223,56407302232,56407303332,56407303333,56407311011,56407311013,56407311031,56407311033,56407311201,56407311203,56407311221,56407311230,56407311231,56407311233,56407312222,56407312223,56407312232,56407312233,56407312303,56407312312,56407312313,56407312321,56407312322,56407312323,56407313011,56407313033,56407313202,56407313203,56407313211,56407313212,56407313213,56407320010,56407320012,56407320030,56407320032,56407321031,56407321033,56407321102,56407321103,56407321211,56407321213,56407410002,56407410013,56407410020,56407410022,56407410023,56407410031,56407410032,56407410033,56407410101,56407410102,56407410103,57400200111,57400200313,57400200331,57400200333,57400201000,57400201001,57400201003,57400201021,57400201023,57400201201,57400201202,57400201203,57400202330,57400202331,57400202333,57400220111,57400220113,57400220131,57400220132,57400220133,57400220331,57400221220,57400221221,57400221230,57400221231,57400221320,57400320220,57400320221,57400320223,57400322001,57400322003,57400322021,57400322030,57400322031,57400322120,57400322121,57400322130,57400322131,57400322133,57400322311,57400323200,57400323201,57400323203,57400323221,57400323230,57400323231,57400323233,57401301011,57401301013,57401301031,57401301032,57401301033,57401301230,57401301231,57401301233,57401303011,57401303013,57401303031,57401303120,57401303121,57401303123,57401303211,57401303213,57401303321,57401303323,57401330021,57401330023,57401330201,57401330203,57401330221,57401330230,57401330231,57401330233,57401332011,57401332013,57401332031,57401332120,57401332121,57401332310,57401332311,57401332313,57401332331,57401332333,57402313022,57402313023,57402330331,57402330333,57402332111,57402332113,
020,00,д//,507642187,137550000,510300000,140362500,16,22,36,61,147,267,574152,584124,584104,584114,574163,574153,574134,574143,574141,574144,574154,574164,574174,584115,574133,574142,5741403,5741511,5741513,5741620,5741621,5741731,5841033,5841340,5841341,5841252,5841250,5841031,5741733,5741303,5741312,5741352,5741350,5741242,5741243,5741233,5741313,5841251,57415011,57415100,57415101,57416110,57416111,57416220,57416221,58410321,58411310,58411311,58411313,58411331,58411333,58413420,58413421,58413430,57416230,57416231,57417301,57417303,57417321,57417323,58410301,58410302,58410303,58413502,58413500,58412530,57413023,57414011,57414013,57414012,57413012,57413013,57413011,58412531,574130213,574130221,574130223,574140211,574140213,574150101,574150103,574150121,574151030,574151031,574151033,574151211,574151212,574151213,574151231,574151233,574161011,574161120,574161121,574161130,574161131,574161133,574161311,574161313,574162220,574162221,574162223,584103201,584113010,584113011,584113121,584113123,584113301,584123110,584123111,584123113,584123131,584123132,584123133,584123311,584134220,584134310,574172010,574162321,574173001,574173203,584103001,584103002,584103003,574173221,574173223,584103231,584103232,584103233,574162330,574162331,574162333,584135012,584135010,574140103,574140101,5741300313,5741300331,5741300333,5741302111,5741302112,5741302113,5741302123,5741400110,5741400313,5741400331,5741400333,5741401021,5741401023,5741402100,5741402101,5741402103,5741402311,5741402313,5741402331,5741500313,5741501000,5741501001,5741501003,5741501021,5741501023,5741501201,5741501202,5741501203,5741501300,5741501301,5741501302,5741501310,5741501311,5741501313,5741510323,5741512101,5741512103,5741512301,5741512321,5741512323,5741610101,5741610103,5741610130,5741610131,5741610133,5741610311,5741611221,5741611230,5741613310,5741613311,5741613313,5741622221,5841130121,5841130130,5841130131,5841131200,5841131201,5841131223,5841133001,5841133003,5841133031,5841133213,5841133231,5841133233,5841231011,5841231121,5841231123,5841231213,5841231231,5841231301,5841231302,5841231303,5841233101,5841233103,5841233121,5841233130,5841233131,5841342210,5841342211,5841342300,5841342301,5841342310,5841342311,5841343110,5841343111,5841343112,5841343120,5841343121,5841343122,5841343200,5841352000,5841352001,5741623200,5741623201,5741622310,5741622311,5741721110,5741721111,5741730000,5741730001,5741730003,5741730233,5841030002,5841030003,5741732221,5741732223,5741732201,5741732203,5741732011,5741732012,5741732013,5841032030,5841032031,5841032033,5841032300,5841032301,5841032303,5841032000,5841032001,5841032003,5741730030,5741730031,5741730033,5741623320,5741623321,5741623323,5741622300,5741622301,5741622302,5741622320,5741622322,5741720031,5741720011,5741720013,5741720120,5741720121,5741510210,5741510211,5741510213,5741510200,5741510201,5741510202,5841352010,5741400111,5741401001,5741401003,5741300311,57413003121,57413020233,57413020322,57413020323,57413020332,57413020333,57413021013,57413021031,57413021033,57413021101,57413021102,57413021103,57413021211,57413021212,57413021213,57413021222,57413021223,57413022011,57413022013,57413022031,57413022033,57413022211,57414000101,57414000103,57414001011,57414001013,57414001333,57414003111,57414003113,57414003220,57414003222,57414003223,57414003232,57414003233,57414003321,57414003322,57414003323,57414010201,57414010203,57414010221,57414010222,57414010223,57414021211,57414021213,57414021231,57414021233,57414023011,57414023100,57414023101,57414023331,57414023333,57415001111,57415001113,57415010021,57415010023,57415012211,57415012300,57415012301,57415012310,57415013030,57415013032,57415013121,57415013123,57415103200,57415103201,57415103210,57415103211,57415103213,57415121022,57415121023,57415123030,57415123031,57415123033,57416101211,57416101213,57416101321,57416101323,57416112221,57416112320,57416113200,57416113201,57416131011,57416133121,57416133123,57416133311,58410320201,58410320210,58410320211,58410322101,58410322110,58410322111,58410322313,58411300111,58411300113,58411300131,58411301331,58411301333,58411303111,58411303113,58411312031,58411312033,58411312211,58411312213,58411330331,58411330333,58411332111,58411332112,58411332113,58412310131,58412310133,58412311201,58412311203,58412311221,58412311223,58412312330,58412312331,58412312333,58412313001,58412313003,58412331001,58412331003,58412331203,58412331320,58412331321,58412331330,58412331331,58412331333,58412333111,58413311133,58413311311,58413311313,58413311331,58413331133,58413331311,58413331313,58413331331,58413331333,58413333111,58413333113,58413333131,58413333133,58413422120,58413422121,58413422122,58413422130,58413422131,58413423020,58413423021,58413423030,58413423031,58413423120,58413423121,58413423130,58413423131,58413431130,58413431132,58413431230,58413431231,58413431300,58413432010,58413432011,58413432020,58413432021,58413432100,58413432101,58413432110,58413432111,58413433000,58413433001,58413520110,57417322221,57417322223,57417322201,57417322203,57417322021,57417322023,57417322001,57417322003,57417320231,57417320232,57417320233,57417320101,57417320103,58410300011,58410300013,58410211333,58410213111,58410213113,58410213131,58410213133,58410213311,58410213313,58410213331,58410213333,58410231111,58410231113,58410231131,58410320321,58410320323,58410323023,58411301201,58411301203,58410320020,58410320021,58410320023,57417302311,57417302313,57417302131,57417302133,57417302111,57417302113,57417300321,57416232300,57416232301,57416232310,57416232311,57416232313,57416233220,57416233221,57416232030,57416232031,57416232033,57416223030,57416223031,57416223032,57416223210,57416223212,57416223230,57416223232,57417200321,57416222231,57417200100,57417200101,57417200103,57417200121,57417200123,57417200301,57417200303,57417201230,57417201231,57417201220,57417201221,57417200330,57417200331,57416222200,57416222201,57416113231,57416113233,57416113210,57416113211,57416113213,57416112310,57416112311,57416112230,57416112231,57415102121,57415102030,57415102032,57416103130,57416103131,57416103133,57416112200,57416112201,57416112203,58413520112,57414010000,57414010001,
021,00,,505940625,138393750,509090625,140250000,13,25,70,152,301,628,574065,574075,574076,574077,574160,574170,574171,584006,584007,584016,584017,584026,584100,5740662,5740663,5740672,5740673,5741503,5741612,5840050,5840051,5840053,5840151,5840152,5840153,5840250,5840251,5840270,5841010,5841011,5841012,5841020,5841100,5841101,5841102,5841121,5741723,5741722,57405522,57405523,57406411,57406413,57406431,57406433,57406600,57406602,57406603,57406612,57406613,57406702,57406703,57406712,57406713,57407411,57407412,57407413,57415023,57415120,57415122,57416100,57416102,57416132,58400520,58400521,58400523,58401433,58401501,58401502,58401503,58402411,58402413,58402530,58402531,58402533,58402710,58402711,58402712,58402720,58402721,58402722,58403600,58403601,58403610,58410130,58410131,58410210,58410212,58410220,58410221,58410223,58410230,58410232,58410233,58411030,58411031,58411032,58411100,58411101,58411201,58412000,58412001,58412010,57417203,57417212,57417213,57417210,57417202,57416130,574054311,574054313,574054323,574054331,574054332,574054333,574055200,574055202,574055203,574055322,574064101,574064103,574064121,574064122,574064123,574064301,574064303,574064321,574064323,574066010,574066012,574066013,574066102,574066103,574066112,574066113,574067011,574067012,574067013,574067102,574067103,574067112,574067113,574074033,574074101,574074102,574074103,574074211,574074213,574074300,574074301,574074310,574074311,574074313,574074331,574074333,574150033,574150132,574150133,574150211,574150212,574150213,574150221,574150223,574151022,574161030,574161032,574161332,574172002,584004133,584004311,584005220,584005221,584005223,584014131,584014133,584014311,584014312,584014313,584015001,584024031,584024102,584024103,584024120,584024121,584025211,584025320,584025321,584027130,584027131,584027132,584027230,584027231,584027300,584027301,584027302,584035111,584035113,584036020,584036021,584036030,584036031,584036110,584036111,584036120,584101320,584101321,584101322,584101330,584101331,584102110,584102112,584102130,584102132,584102220,584102221,584102223,584102310,584102312,584102313,584103220,584103222,584111020,584111100,584112001,584112030,584112031,584112300,584113000,584113002,584113020,584113021,584120020,584120021,584120023,584120030,584120031,584120112,584120113,584120120,584120121,584120130,584120131,584121020,574172013,574172011,574162233,574162322,574172112,574172110,574172113,574173002,574173020,574173200,574173022,584102111,584113003,574172000,574161330,574161312,574161033,574151023,5740543123,5740543203,5740543212,5740543213,5740543221,5740543223,5740543301,5740543302,5740543303,5740550222,5740552012,5740552013,5740552120,5740552122,5740552123,5740552132,5740553202,5740553230,5740553232,5740553233,5740572323,5740572332,5740572333,5740573222,5740640313,5740640331,5740640333,5740641001,5740641002,5740641003,5740641021,5740641023,5740641201,5740641202,5740641203,5740643000,5740643001,5740643003,5740643021,5740643023,5740643201,5740643203,5740643221,5740643223,5740660110,5740660112,5740660113,5740661002,5740661003,5740661113,5740670002,5740670020,5740670022,5740670023,5740670031,5740670032,5740670033,5740670101,5740670102,5740670103,5740671000,5740671002,5740671003,5740671111,5740671112,5740671113,5740740131,5740740133,5740740311,5740740313,5740740323,5740741001,5740741002,5740741003,5740742101,5740742103,5740742121,5740743020,5740743021,5740743022,5740743030,5740743120,5740743121,5740743123,5741501220,5741501222,5741501223,5741501232,5741501233,5741502221,5741502222,5741502223,5741510322,5741512100,5741512300,5741512302,5741512320,5741512322,5741610100,5741610102,5741610120,5741610122,5741610123,5741611322,5741613100,5741613102,5741613332,5741613333,5840041110,5840041111,5840041113,5840041131,5840041311,5840041313,5840043130,5840043131,5840043133,5840043311,5840043313,5840052220,5840052221,5840052223,5840141303,5840141321,5840141323,5840143101,5840143102,5840143103,5840150001,5840150003,5840150022,5840150031,5840150032,5840150033,5840240113,5840240131,5840240133,5840240301,5840240303,5840240321,5840240323,5840240330,5840240332,5840241002,5840241003,5840241011,5840241012,5840241013,5840241230,5840241231,5840241233,5840243101,5840243110,5840243111,5840252000,5840252011,5840252100,5840252101,5840252103,5840252121,5840252130,5840252131,5840253221,5840253230,5840253231,5840272320,5840273030,5840273031,5840273032,5840273100,5840273200,5840273201,5840273202,5840351101,5840351103,5840351311,5840360321,5840360330,5840360331,5840361120,5840361121,5840361122,5840361130,5840361210,5840361211,5840361212,5840361220,5840361221,5840361222,5840370000,5840370001,5840370010,5840370011,5841013230,5841021130,5841021132,5841021310,5841021312,5841021330,5841021332,5841022220,5841022221,5841022223,5841023110,5841023112,5841032022,5841032023,5841032212,5841032230,5841032232,5841103300,5841103302,5841103320,5841103322,5841110210,5841110211,5841110220,5841110222,5841110300,5841110311,5841111020,5841111021,5841111022,5841112000,5841112002,5841112003,5841112020,5841112021,5841120030,5841120031,5841120033,5841120211,5841120213,5841120330,5841120331,5841123010,5841123011,5841123012,5841123020,5841123021,5841123022,5841123100,5841123101,5841123103,5841123110,5841123112,5841130010,5841130012,5841130220,5841130221,5841200220,5841200221,5841200320,5841200321,5841200330,5841200331,5841200333,5841201100,5841201102,5841201103,5841201112,5841201113,5841201220,5841201221,5841201222,5841201230,5841201231,5841201233,5841201320,5841201321,5841201322,5841201330,5841201331,5841210022,5841210220,5841210221,5741623202,5741622313,5741622312,5741623232,5741623233,5741721112,5741721113,5741730002,5741730210,5741730212,5741730232,5741730230,5741732020,5741732021,5741732022,5841030000,5841021131,5841032213,5841032233,5741622222,5741613330,5741613103,5741611233,5741610312,5741610310,57405413231,57405413233,57405413322,57405413323,57405413332,57405413333,57405431011,57405431013,57405431031,57405431033,57405431211,57405431212,57405431213,57405432113,57405432221,57405432223,57405433002,57405433003,57405502202,57405502203,57405502232,57405502233,57405502322,57405520100,57405520102,57405520103,57405520112,57405520113,57405521022,57405521210,57405521212,57405532000,57405532002,57405532032,57405532033,57405532122,57405532123,57405532312,57405532313,57405533202,57405533220,57405533222,57405533223,57405533232,57405533233,57405533322,57405533323,57405533332,57405533333,57405622222,57405622223,57405622232,57405622233,57405622322,57405622323,57405622332,57405622333,57405623222,57405623223,57405623232,57405623233,57405623322,57405623323,57405623332,57405723123,57405723132,57405723212,57405723213,57405723301,57405723302,57405723303,57405723310,57405723312,57405723313,57405732202,57405732203,57405732232,57405733332,57405733333,57406403112,57406403113,57406410001,57406410003,57406410201,57406410203,57406410221,57406410223,57406412001,57406412002,57406412003,57406421110,57406421111,57406430021,57406430023,57406430201,57406430203,57406430221,57406430223,57406601110,57406601112,57406601113,57406610002,57406610003,57406610012,57406610013,57406610102,57406610120,57406610122,57406610123,57406610132,57406610133,57406611022,57406611023,57406611032,57406611033,57406611112,57406611113,57406611122,57406611123,57406700002,57406700003,57406700113,57406700131,57406700133,57406700210,57406700212,57406701002,57406701003,57406710010,57406710012,57406710013,57406710102,57406710120,57406710122,57406710123,57406710132,57406710133,57406711013,57406711022,57406711023,57406711031,57406711032,57406711033,57406711102,57406711103,57407401132,57407401133,57407403101,57407403103,57407403121,57407403123,57407403211,57407403213,57407410001,57407410002,57407410003,57407421230,57407421231,57407421233,57407423011,57407423100,57407423101,57407423110,57407423111,57407430230,57407432000,57407432001,57407433010,57407433011,57407433013,57407433031,57407433033,57407433211,57407433213,57407433231,57415003121,57415003123,57415003211,57415003213,57415003231,57415003233,57415012210,57415012212,57415012213,57415012302,57415012303,57415012311,57415012312,57415012313,57415013031,57415013033,57415013120,57415013122,57415020311,57415020313,57415020331,57415020333,57415021011,57415021013,57415021022,57415021023,57415021031,57415021032,57415021033,57415022011,57415022013,57415022023,57415022031,57415022032,57415022033,57415022201,57415022202,57415022203,57415103202,57415103203,57415103212,57415121020,57415121021,57415123032,57416101210,57416101212,57416101320,57416101322,57416112222,57416112323,57416113202,57416113203,57416131012,57416133122,57416133312,57416133313,58400411331,58400411333,58400413211,58400413213,58400413231,58400413233,58400431011,58400431013,58400431031,58400431033,58400431211,58400431320,58400431321,58400433311,58400433313,58400522221,58400522223,58401411331,58401411333,58401431002,58401431003,58401432133,58401432311,58401432313,58401432323,58401432331,58401432332,58401432333,58401500001,58401500003,58401500210,58401500211,58401500230,58401500232,58401500300,58401500301,58401500303,58402403310,58402403311,58402410012,58402410013,58402410101,58402410102,58402410103,58402412200,58402412201,58402412210,58402412211,58402412213,58402412231,58402412320,58402412321,58402421010,58402421011,58402421013,58402421100,58402421102,58402431001,58402431003,58402431121,58402431123,58402431130,58402431132,58402521021,58402521023,58402521321,58402521330,58402521331,58402521333,58402523111,58402532200,58402532201,58402532230,58402532231,58402532320,58402532321,58402532330,58402532331,58402532333,58402713300,58402713301,58402713310,58402713311,58402723210,58402723211,58402723220,58402723221,58402723222,58402723300,58402723301,58402723310,58402723311,58402723312,58402723330,58402730330,58402731020,58402731022,58402731200,58402731202,58402732030,58402732031,58402732100,58402732101,58402732102,58402732120,58402732200,58402732201,58403511001,58403511003,58403513100,58403513101,58403513103,58403513121,58403513130,58403513131,58403602200,58403602201,58403602210,58403602211,58403602300,58403602301,58403602310,58403602311,58403603200,58403603201,58403603203,58403611230,58403611231,58403611232,58403611310,58403611312,58403611320,58403612130,58403612131,58403612230,58403612232,58403612300,58403612301,58403612302,58403613000,58403613001,58403613010,58403701000,58403701002,58410132310,58410132311,58410132312,58410132320,58410132321,58410132322,58410132330,58410133200,58410133201,58410133210,58410133211,58410133300,58410133301,58410133310,58410133311,58410133313,58410133331,58410222220,58410222221,58410222223,58410320200,58410320202,58410320203,58410320212,58410320213,58410322102,58410322103,58410322112,58410322310,58410322312,58411033010,58411033011,58411033100,58411033101,58411033110,58411033111,58411102120,58411102121,58411102130,58411102210,58411102211,58411102212,58411102230,58411102232,58411110100,58411110230,58411110232,58411120010,58411120012,58411120220,58411120222,58411200001,58411200010,58411200011,58411200013,58411200031,58411200033,58411200211,58411200213,58411200321,58411200323,58411202101,58411202103,58411202121,58411202310,58411202311,58411202312,58411202330,58411203200,58411203201,58411203210,58411203211,58411203213,58411203231,58411203320,58411203321,58411203330,58411203331,58411230130,58411230132,58411230300,58411230302,58411231021,58411231023,58411231110,58411231111,58411231112,58411231130,58411231132,58411232000,58411300110,58411300112,58411300130,58411300132,58411301222,58411302220,58411302221,58411302222,58411302230,58411302231,58411302300,58411302301,58411302302,58411302310,58411302311,58411302320,58411303000,58411303002,58411303020,58411320000,58412002220,58412002221,58412002230,58412002231,58412003220,58412003221,58412003222,58412003230,58412003231,58412003320,58412003321,58412012230,58412012231,58412012232,58412012320,58412012321,58412012323,58412013230,58412013231,58412013320,58412013321,58412013330,58412013331,58412100020,58412100022,58412100200,58412100202,58412100203,58412100212,58412100230,58412100232,58412100233,58412102102,58412102103,58412102120,58412102121,58412102220,58412102221,58412102230,58412102231,57417322222,57417322220,57417322202,57417322200,57417322022,57417322020,57417322002,57417322000,57417320230,57417320100,57417320102,58410300010,58410300012,58410211330,58410211331,58410211332,58410213110,58410213112,58410213130,58410213132,58410213310,58410213312,58410213330,58410213332,58410231110,58410231112,58410231130,58410231132,58410322100,58410320322,58410320320,58410323020,58410323021,58410323022,58410322311,58410322113,58411301220,58411301202,58411301200,58411300133,58410231133,58410320022,57417302312,57417302310,57417302132,57417302112,57417302130,57417302110,57417300322,57417300323,57417300320,57416232302,57416232303,57416232312,57416233222,57416233223,57416232032,57416223033,57416223211,57416223213,57416223231,57416223233,57417200322,57417200320,57416222232,57416222233,57417200102,57417200120,57417200122,57417200300,57417200302,57417200323,57417201233,57417201232,57417201223,57417201222,57417200333,57417200332,57416222230,57416222202,57416222203,57416133310,57416133120,57416131013,57416131010,57416113232,57416113230,57416113212,57416112313,57416112312,57416112321,57416112322,57416112233,57416112232,57416112223,57416112220,57415102122,57415102033,57415102031,57415102120,57415102123,57416103132,57416112202,
022,00,,502650000,135843750,505040625,137793750,15,18,32,115,253,465,563966,563967,563976,563977,564060,564061,564070,564071,573906,573907,573916,573917,574000,574001,574010,5639653,5639751,5639753,5640502,5640503,5640512,5640513,5739051,5739053,5739153,5739261,5739270,5740110,5740112,5740200,5740201,5740203,5740210,56395733,56396512,56396513,56396521,56396523,56397501,56397503,56397521,56397523,56405002,56405012,56405013,56405102,56405103,56405112,56405113,57390501,57391510,57391511,57391513,57392511,57392600,57392601,57392710,57392712,57392720,57392721,57392722,57401110,57402021,57402120,57402122,563956233,563956320,563956322,563956323,563957131,563957133,563957221,563957222,563957223,563957232,563957311,563957313,563957323,563965031,563965032,563965033,563965111,563965113,563965201,563965203,563965221,563965222,563965223,563975001,563975003,563975021,563975023,563975201,563975203,563975221,564040333,564050032,564050033,564050103,564050111,564050112,564050113,564051000,564051002,564051003,564051012,564051013,564051102,564051103,564051110,564051112,564052022,564052200,564052202,564072000,564072002,564072020,564072022,564072200,564072202,564072220,564072222,573905030,573905031,573905033,573905233,573915011,573915121,573915122,573915123,573925100,573925101,573925103,573925121,573925130,573925131,573926021,573926031,573926301,573926310,573926311,573926313,573927110,573927111,573927230,573927231,573927232,573937000,573937001,573937003,573937010,573937012,574002000,574002002,574002020,574002022,574002200,574002202,574002220,574011110,574011120,574011302,574011320,574011322,574020200,574020201,574020203,574020221,574020230,574020231,574020233,574021100,574021102,574021120,574021122,574021210,574021211,574021212,574021230,574030100,5639553333,5639562222,5639562223,5639562232,5639562313,5639563212,5639563213,5639563320,5639563322,5639563323,5639563332,5639563333,5639571133,5639571303,5639571321,5639571323,5639572201,5639572202,5639572203,5639572302,5639572303,5639572332,5639573101,5639573103,5639573121,5639573122,5639573123,5639573212,5639573213,5639573223,5639650132,5639650133,5639650231,5639650232,5639650233,5639650301,5639650302,5639650303,5639651022,5639651123,5639652003,5639652021,5639652022,5639652023,5639652201,5639652202,5639652203,5639750000,5639750001,5639750003,5639750021,5639752230,5639752231,5640403323,5640412202,5640412220,5640412222,5640412223,5640500022,5640500023,5640500300,5640500302,5640500303,5640501101,5640501103,5640510012,5640510013,5640511003,5640511011,5640511012,5640511013,5640511130,5640511132,5640511133,5640520022,5640520200,5640520202,5640520230,5640520232,5640522010,5640522012,5640522030,5640522031,5640522032,5640522200,5640522201,5640522202,5640522220,5640522222,5640620000,5640620002,5640620020,5640620022,5640620200,5640620202,5640620220,5640620221,5640620222,5640622000,5640622002,5640622020,5640622021,5640622022,5640622200,5640622202,5640622220,5640622222,5640720012,5640720030,5640720032,5640720210,5640720212,5640720230,5640720232,5640722030,5640722032,5640722210,5640722212,5640722230,5640722232,5739050320,5739050321,5739050323,5739052111,5739052113,5739052313,5739150131,5739150133,5739150311,5739151200,5739151201,5739151203,5739152313,5739152331,5739152333,5739250111,5739250113,5739251021,5739251023,5739251230,5739251231,5739251233,5739251320,5739251321,5739251322,5739251330,5739260200,5739260201,5739260300,5739260301,5739260303,5739260330,5739260331,5739260333,5739263000,5739263001,5739263120,5739263121,5739263311,5739263313,5739263331,5739263333,5739271120,5739271121,5739271122,5739271130,5739271131,5739271133,5739271300,5739271311,5739271312,5739271313,5739271331,5739271333,5739273000,5739273002,5739273003,5739273020,5739273022,5739273111,5739273200,5739370021,5739370112,5739370211,5739370300,5740020010,5740020012,5740020013,5740020030,5740020032,5740020210,5740020212,5740020230,5740020232,5740022010,5740022012,5740022030,5740022032,5740022220,5740111110,5740111112,5740111113,5740111120,5740111121,5740111130,5740111210,5740111211,5740111212,5740111220,5740111221,5740113002,5740113003,5740113012,5740113030,5740113031,5740113032,5740113210,5740113212,5740113230,5740113232,5740202020,5740202021,5740202023,5740202201,5740202203,5740202230,5740202231,5740202233,5740202320,5740202321,5740202322,5740211010,5740211012,5740211030,5740212130,5740212132,5740212310,5740212312,5740212320,5740212321,5740213000,5740213001,5740300110,5740300111,5740300113,5740301010,5740301012,5740301020,5740301021,5740301111,5740310000,5740310001,5740310010,56395533311,56395533313,56395533322,56395533323,56395621331,56395621333,56395622200,56395622202,56395622332,56395622333,56395623111,56395623113,56395623222,56395623223,56395623231,56395623232,56395623233,56395630220,56395630222,56395633311,56395633313,56395711303,56395711312,56395711313,56395711321,56395711323,56395713223,56395723011,56395723013,56395723332,56395723333,56395731001,56395731002,56395731003,56395731021,56395731023,56395731201,56395731203,56395732031,56395732033,56395732211,56395732213,56395732222,56395732223,56396501223,56396501232,56396501233,56396501301,56396501302,56396501303,56396502113,56396502131,56396502133,56396503001,56396503002,56396503003,56396510230,56396510232,56396511013,56396511031,56396511033,56396511211,56396511212,56396511213,56396520011,56396520013,56396520021,56396520023,56396520201,56396520202,56396520203,56396522001,56396522002,56396522003,56397500020,56397500021,56397500023,56397500201,56397500203,56397500231,56397500233,56397502011,56397502013,56397502031,56397502033,56397502211,56397502213,56397502231,56397520013,56397520031,56397520033,56397520211,56397520213,56397520233,56397522011,56397522013,56397522031,56397522320,56397522321,56397522330,56397522331,56397522333,56404033131,56404033133,56404122210,56404122212,56404122320,56404122322,56405000202,56405000203,56405000212,56405000213,56405000302,56405000320,56405000322,56405000323,56405000332,56405000333,56405001222,56405003010,56405003012,56405010033,56405010122,56405010123,56405010132,56405010133,56405010211,56405010213,56405010231,56405010232,56405010233,56405011003,56405011021,56405011022,56405011023,56405100100,56405100102,56405100103,56405100112,56405100113,56405101022,56405101023,56405101032,56405101033,56405101122,56405101123,56405101132,56405101133,56405110003,56405110012,56405110013,56405110021,56405110022,56405110023,56405110102,56405110103,56405111100,56405111102,56405111120,56405111122,56405111123,56405111132,56405111310,56405111312,56405111313,56405200202,56405200203,56405202010,56405202012,56405202030,56405202032,56405202332,56405220110,56405220112,56405220130,56405220132,56405220133,56405220330,56405220331,56405220332,56405221022,56405221023,56405221200,56405221201,56405221202,56405221220,56405222030,56405222031,56405222032,56405222100,56405222101,56405222110,56405222210,56405222212,56405222230,56405222232,56406200010,56406200012,56406200030,56406200032,56406200210,56406200212,56406200230,56406200232,56406202010,56406202012,56406202030,56406202032,56406202230,56406202232,56406220010,56406220012,56406220030,56406220032,56406220230,56406220231,56406220232,56406222010,56406222012,56406222030,56406222032,56406222210,56406222212,56406222230,56406222232,56406222233,56407200102,56407200103,56407200310,56407200312,56407200330,56407200332,56407202110,56407220330,56407222332,57390500111,57390500113,57390500131,57390500133,57390500311,57390500313,57390500331,57390500333,57390502111,57390502113,57390502131,57390502133,57390502311,57390502313,57390502331,57390503220,57390503221,57390523121,57390523123,57391501301,57391501303,57391501321,57391501323,57391503101,57391503130,57391503131,57391512020,57391512021,57391512023,57392510200,57392510201,57392510203,57392510221,57392510223,57392512001,57392512010,57392512011,57392512013,57392512031,57392512033,57392512211,57392512213,57392513230,57392513232,57392513310,57392513312,57392602020,57392602021,57392602022,57392602030,57392602031,57392602033,57392603020,57392603021,57392603022,57392603211,57392603213,57392603321,57392603323,57392630021,57392630030,57392630031,57392630300,57392630301,57392630310,57392630311,57392630313,57392630331,57392631220,57392631221,57392631230,57392631231,57392631233,57392633011,57392633100,57392633101,57392633103,57392633121,57392633123,57392633301,57392633303,57392711230,57392711231,57392711320,57392711321,57392713020,57392713021,57392723300,57392723302,57392723320,57392723322,57392730010,57392730012,57392730120,57392730122,57392730210,57392730211,57392730212,57392730230,57392730232,57392730300,57392731131,57392731133,57392731311,57392731313,57392731331,57392732010,57393611111,57393611113,57393611131,57393611133,57393611311,57393700200,57393700201,57393700230,57393700231,57393701100,57393701102,57393701130,57393701132,57393701300,57393701301,57393701302,57393701310,57393701320,57393702100,57393702101,57393702103,57393703010,57393703011,57393703012,57400200110,57400200112,57400200113,57400200310,57400200311,57400200312,57400200330,57400200332,57400201002,57400201020,57400201022,57400201200,57400202332,57400220110,57400220112,57400220130,57400220330,57400220332,57400222100,57400222101,57400222102,57400222110,57400222120,57400222122,57400222210,57400222211,57400222212,57400222220,57400222221,57400222230,57400222300,57401111112,57401111113,57401112130,57401112131,57401112220,57401112222,57401112300,57401112301,57401130000,57401130002,57401130003,57401130012,57401130013,57401130102,57401130103,57401130132,57401130330,57401130331,57401130332,57401132110,57401132130,57401132132,57401132310,57401132312,57401132330,57401132332,57402020220,57402020221,57402023231,57402023233,57402110320,57402110321,57402121310,57402121311,57402123220,57402123222,57402130020,57402130021,57402130022,57402130030,57402130200,57403001120,57403001121,57403001310,57403001311,57403001313,57403001331,57403010110,57403010112,57403010220,57403010221,57403010230,57403010231,57403010300,57403010301,57403011011,57403011013,57403011100,57403011102,57403011131,57403100020,57403100021,57403100030,57403100031,57403100110,57403100112,57403100120,57403100121,
023,00,,503535937,137006250,506193750,139387500,12,23,71,110,284,514,574012,574022,574032,574040,574041,574042,574043,574051,574052,574053,574063,574073,5739371,5739373,5739471,5739473,5739571,5739573,5740230,5740232,5740302,5740303,5740311,5740312,5740313,5740330,5740332,5740500,5740501,5740540,5740542,5740620,5740621,5740623,5740721,57392733,57393721,57393723,57394701,57396711,57400223,57400232,57400233,57401113,57401131,57401133,57401300,57401302,57401320,57401322,57401323,57402111,57402113,57402131,57402132,57402133,57402310,57402312,57403000,57403002,57403003,57403012,57403013,57403101,57403102,57403103,57403310,57403312,57403330,57403332,57403333,57404420,57404422,57404423,57405020,57405021,57405022,57405030,57405031,57405032,57405430,57406000,57406101,57406110,57406111,57406113,57406220,57406221,57406223,57406400,57406401,57406402,57407231,57407233,57407400,57407402,57407420,57407422,58400301,58400310,58400311,58400312,58400400,57406420,57406422,57406423,573927132,573927310,573927312,573927321,573927322,573927323,573937031,573937032,573937033,573937201,573937202,573937203,573937221,573937223,573947031,573947033,573947211,573947213,573947231,573947233,573967101,573967131,574003222,574013210,574013212,574013213,574013322,574020222,574021121,574021123,574021233,574021301,574021303,574023300,574023301,574023302,574023320,574023322,574023323,574030010,574030012,574030112,574030113,574031002,574031003,574033132,574033310,574033312,574034220,574034222,574044000,574044002,574044020,574044022,574044023,574044210,574044212,574044213,574050230,574050231,574050232,574050330,574050331,574050332,574054102,574054120,574054122,574054123,574060010,574060012,574060020,574060021,574060023,574060030,574060101,574061001,574061031,574061120,574061121,574061311,574061313,574062220,574062221,574062223,574064030,574064032,574072010,574072011,574072013,574072300,574072301,574072303,574072321,574072323,574074030,574074232,584002101,584002110,584002111,584003000,584003001,584003003,584003030,584003031,584004010,574074010,574074012,574064210,574064212,574064213,5739271301,5739271303,5739271310,5739271330,5739271332,5739272331,5739272333,5739273010,5739273011,5739273013,5739273031,5739273032,5739273033,5739273110,5739273112,5739273130,5739273132,5739273202,5739273203,5739370111,5739370133,5739370213,5739370231,5739370233,5739370302,5739370303,5739372001,5739372003,5739372200,5739372201,5739372203,5739372221,5739470300,5739470301,5739470303,5739470321,5739470322,5739470323,5739472100,5739472101,5739472103,5739472303,5739472321,5739472323,5739570110,5739570111,5739570113,5739570131,5739570133,5739570311,5739570313,5739570330,5739570331,5739570333,5739572110,5739572111,5739572113,5739572131,5739572132,5739572133,5739572311,5739572331,5739572333,5739671000,5739671001,5739671003,5739671030,5739671031,5739671300,5739671301,5739671331,5740022133,5740022213,5740022231,5740022232,5740022233,5740023022,5740023023,5740023032,5740023033,5740023122,5740023123,5740023132,5740023133,5740032230,5740032232,5740032233,5740111122,5740111123,5740111131,5740111132,5740111133,5740111223,5740111231,5740111232,5740111233,5740113011,5740130100,5740130102,5740130120,5740130122,5740130300,5740130302,5740130320,5740130322,5740130323,5740132110,5740132112,5740132113,5740133200,5740133202,5740133230,5740133232,5740202200,5740202202,5740202232,5740211011,5740211013,5740211031,5740211033,5740212133,5740212311,5740212313,5740212323,5740213021,5740213022,5740213023,5740231120,5740231122,5740231300,5740233030,5740233031,5740233032,5740233210,5740233212,5740233213,5740300130,5740300132,5740301013,5740301031,5740301032,5740301033,5740301100,5740301102,5740301103,5740301112,5740310013,5740331302,5740331303,5740331312,5740331330,5740331332,5740333110,5740333112,5740333130,5740333132,5740333133,5740342212,5740440210,5740440212,5740440213,5740440320,5740440322,5740440323,5740442112,5740442113,5740443022,5740443200,5740443202,5740443220,5740443222,5740502330,5740502331,5740502333,5740503330,5740503331,5740541000,5740541002,5740541003,5740541212,5740541213,5740541302,5740543120,5740543122,5740543210,5740543220,5740600220,5740600221,5740600223,5740600320,5740600322,5740601001,5740601100,5740601101,5740601102,5740602011,5740610000,5740610001,5740610031,5740610033,5740610300,5740610301,5740611231,5740611233,5740613100,5740613101,5740613103,5740613311,5740622221,5740640310,5740640312,5740640330,5740640332,5740643220,5740643222,5740720011,5740720013,5740720120,5740720121,5740720123,5740720310,5740720311,5740720313,5740720331,5740720333,5740722111,5740722113,5740722131,5740723020,5740723021,5740723023,5740723201,5740723203,5740723221,5740723223,5740742100,5740742102,5740742120,5740742122,5840021001,5840021003,5840021120,5840021121,5840021123,5840021130,5840021131,5840030020,5840030021,5840030023,5840030210,5840030211,5840030213,5840030331,5840031300,5840031301,5840031302,5840033001,5840033010,5840040120,5840040200,5840040211,5740742300,5740742302,5740742303,5740740320,5740740322,5740740130,5740740132,5740643200,5740643202,5740740110,5740740111,5740740112,5740642110,5740642112,5740642113,5740543200,5740543201,5740543202,5740541320,5740541321,5740541322,5740543100,5740543102,57392711232,57392711233,57392711322,57392711323,57392713022,57392713023,57392723301,57392723303,57392723321,57392723323,57392730011,57392730013,57392730121,57392730123,57392730213,57392730231,57392730233,57392730301,57392730302,57392730303,57392731130,57392731132,57392731310,57392731312,57392731330,57392731332,57392731333,57392732011,57392732012,57392732013,57393631311,57393631313,57393631331,57393631333,57393633111,57393633113,57393701101,57393701103,57393701131,57393701133,57393701303,57393701311,57393701312,57393701313,57393701321,57393701322,57393701323,57393702121,57393702123,57393702301,57393702303,57393702321,57393702322,57393702323,57393703013,57393720021,57393720023,57393722021,57393722023,57393722201,57393722203,57394700101,57394700110,57394700111,57394700113,57394700131,57394700133,57394700311,57394700313,57394700331,57394721020,57394721021,57394721210,57394721211,57394721213,57394721231,57394721233,57394723011,57394723012,57394723013,57395701010,57395701011,57395701120,57395701121,57395703122,57395703123,57395703320,57395703321,57395721120,57395721121,57395721302,57395721303,57395723131,57395723133,57396701110,57396701111,57396701113,57396701131,57396710020,57396710021,57396710331,57396710333,57396713031,57396713300,57396713301,57396713330,57396713331,57400220333,57400221222,57400221223,57400221232,57400221233,57400221321,57400221322,57400221323,57400222103,57400222111,57400222112,57400222113,57400222121,57400222123,57400222213,57400222222,57400222223,57400222231,57400222232,57400222233,57400222301,57400222302,57400222303,57400320222,57400322000,57400322002,57400322020,57400322022,57400322023,57400322032,57400322033,57400322122,57400322123,57400322132,57400322310,57400322312,57400322313,57400323202,57400323220,57400323222,57400323223,57400323232,57401111110,57401111111,57401112132,57401112133,57401112221,57401112223,57401112302,57401112303,57401130001,57401130010,57401130011,57401130100,57401130101,57401130130,57401130131,57401130133,57401130333,57401132111,57401132112,57401132113,57401132131,57401132133,57401132311,57401132313,57401132331,57401132333,57401301010,57401301012,57401301030,57401301232,57401303010,57401303012,57401303030,57401303032,57401303033,57401303122,57401303210,57401303212,57401303320,57401303322,57401330020,57401330022,57401330200,57401330202,57401330220,57401330222,57401330223,57401330232,57401332010,57401332012,57401332030,57401332032,57401332033,57401332122,57401332123,57401332312,57401332330,57401332332,57402020222,57402020223,57402023230,57402023232,57402110322,57402110323,57402121312,57402121313,57402123221,57402123223,57402130023,57402130031,57402130032,57402130033,57402130201,57402130202,57402130203,57402313020,57402313021,57402330330,57402330332,57402332110,57402332112,57403001122,57403001123,57403001312,57403001330,57403001332,57403001333,57403010111,57403010113,57403010222,57403010223,57403010232,57403010233,57403010302,57403010303,57403011010,57403011012,57403011101,57403011103,57403011130,57403011132,57403011133,57403100022,57403100023,57403100032,57403100033,57403100111,57403100113,57403100122,57403100123,57403313002,57403313003,57403313012,57403313013,57403313102,57403331312,57403331313,57403420202,57403420220,57403420222,57403422100,57403422102,57403422130,57403422132,57403422300,57403422301,57403422302,57403422310,57403422320,57403422322,57404400100,57404400102,57404400120,57404400122,57404400300,57404400302,57404400320,57404400322,57404402110,57404402112,57404403210,57404403212,57404403320,57404403322,57404421100,57404421102,57404421103,57404421112,57404421113,57404430002,57404430020,57404430022,57404430200,57404430202,57404430203,57405023320,57405023321,57405023322,57405033320,57405033321,57405033322,57405033330,57405033331,57405033333,57405410012,57405410013,57405412100,57405412102,57405413030,57405413032,57406001100,57406001110,57406001111,57406002220,57406002221,57406002223,57406003210,57406003211,57406010000,57406010001,57406010003,57406010021,57406010030,57406010031,57406010033,57406011030,57406011031,57406011100,57406011111,57406011113,57406011131,57406020001,57406020010,57406020011,57406020100,57406020101,57406020103,57406021000,57406021001,57406021002,57406100020,57406100021,57406100030,57406100031,57406100033,57406100301,57406100303,57406103021,57406103030,57406103031,57406103033,57406103211,57406103300,57406103301,57406103310,57406103311,57406112200,57406112201,57406112210,57406112211,57406112300,57406112301,57406130110,57406130111,57406130113,57406133100,57406133101,57406133103,57406133121,57406133130,57406133131,57406222231,57406412000,57407200101,57407200103,57407200311,57407200313,57407200331,57407201220,57407201221,57407201223,57407203011,57407203121,57407203301,57407203303,57407203321,57407203323,57407221101,57407221103,57407221121,57407221123,57407221301,57407230220,57407230221,57407230223,57407423102,57407423120,57407423122,57407423300,57407423301,57407423302,57407423320,57407423322,58400210001,58400210003,58400210021,58400210023,58400210210,58400210211,58400210300,58400210301,58400210310,58400210311,58400211320,58400211321,58400300221,58400302010,58400302011,58400302013,58400302121,58400302123,58400302310,58400302311,58400303200,58400303201,58400303210,58400303211,58400303212,58400303301,58400303331,58400313100,58400313101,58400313102,58400313110,58400313111,58400313113,58400313131,58400313200,58400313201,58400330000,58400330001,58400330110,58400330112,58400330120,58400330121,58400330123,58400330130,58400330132,58400401100,58400401102,58400401210,58400401211,58400401212,58400401220,58400401221,58400401222,58400402010,58400402011,58400402012,58400402020,58400402021,58400402030,57407423010,57407423012,57407423013,57407421232,57407403210,57407403212,57407403120,57407403122,57407403100,57407403102,57407401130,57407401131,57407410000,57406430220,57406430222,57406430200,57406430202,57406430020,57406430022,57406421112,57406421113,57406403110,57406403111,57406410220,57406410222,57406410200,57406410202,57406410000,57406410002,57405432220,57405432222,57405432110,57405432111,57405432112,57405433000,57405433001,57405431210,57405413230,57405413232,57405431010,57405431012,57405431030,57405431032,
024,00,,504084375,138590625,506320312,140578125,6,23,47,101,251,479,574071,584001,584011,584012,584013,584022,5740612,5840001,5840003,5840020,5840022,5840023,5840032,5840042,5840101,5840140,5840142,5840210,5840211,5840213,5840230,5840231,5840232,5840311,5840313,5840320,5840321,5840322,5840330,57406013,57406102,57406132,57407031,57407032,57407033,57407202,57407220,57407222,57407223,58400212,58400213,58400331,58400332,58400333,58400403,58400410,58400412,58400430,58400432,58401031,58401410,58401412,58401430,58402120,58402121,58402123,58402330,58402400,58402402,58403100,58403101,58403103,58403121,58403122,58403123,58403230,58403231,58403232,58403320,58403321,58404100,58404101,58404103,58404110,58404111,58404200,574060013,574060102,574060103,574060112,574060113,574060120,574060121,574060123,574060301,574060310,574060311,574060313,574060331,574060333,574061002,574061300,574061302,574061303,574061312,574061330,574061332,574061333,574070111,574070113,574070131,574070132,574070133,574070233,574070303,574072000,574072002,574072032,574072210,574072212,574074321,574074322,574074323,584000011,584000013,584000031,584000033,584000213,584000231,584000233,584003022,584003133,584003302,584003303,584004013,584004022,584004023,584004110,584004112,584004130,584004330,584004332,584010011,584010012,584010013,584010031,584010301,584010303,584014110,584014111,584014112,584014320,584014322,584020111,584020112,584020113,584020130,584020131,584021220,584021221,584021223,584023310,584023311,584023312,584023320,584023321,584023322,584024010,584024012,584024200,584024201,584030331,584031020,584031021,584031023,584032330,584032331,584032332,584033100,584041020,584041021,584041023,584042010,584042011,584042100,584042101,584042110,5740600112,5740600113,5740600310,5740600311,5740600313,5740601112,5740601221,5740601223,5740603031,5740603120,5740603121,5740603123,5740603301,5740610032,5740610320,5740610322,5740610323,5740610332,5740610333,5740611222,5740611223,5740611232,5740613010,5740613012,5740613013,5740613102,5740622220,5740622222,5740702312,5740702313,5740703003,5740703011,5740703012,5740703013,5740703021,5740703022,5740703023,5740720012,5740720030,5740720032,5740720300,5740720302,5740720303,5740722132,5740722133,5740723200,5740723202,5740723220,5740723222,5740742313,5740742331,5740742333,5740743031,5740743032,5740743033,5740743122,5740743201,5740743202,5740743203,5740743300,5740743302,5740743320,5740743322,5840000101,5840000102,5840000103,5840000120,5840000121,5840000303,5840002110,5840002111,5840002113,5840002321,5840002322,5840002323,5840021020,5840021022,5840021023,5840021032,5840021033,5840021122,5840021133,5840030200,5840030202,5840030203,5840030230,5840030232,5840030233,5840030322,5840030323,5840030332,5840031303,5840031312,5840031321,5840031322,5840031323,5840033002,5840033003,5840040111,5840040112,5840040113,5840040123,5840040210,5840040212,5840040213,5840041112,5840041130,5840041132,5840041310,5840041312,5840041320,5840041322,5840043100,5840043102,5840043120,5840043122,5840043123,5840043310,5840043312,5840043330,5840043332,5840043333,5840100031,5840100033,5840100101,5840100103,5840100300,5840100301,5840100330,5840100331,5840100333,5840103001,5840103211,5840103300,5840103301,5840103310,5840103311,5840103313,5840103331,5840103333,5840141130,5840141131,5840141132,5840141300,5840141301,5840141302,5840141320,5840141322,5840143210,5840143211,5840143212,5840143230,5840150002,5840150020,5840201013,5840201031,5840201033,5840201101,5840201102,5840201103,5840201211,5840201321,5840201330,5840201331,5840201333,5840203111,5840203113,5840203131,5840203133,5840212221,5840212222,5840212223,5840233130,5840233131,5840233132,5840233230,5840233232,5840233300,5840233301,5840233302,5840240110,5840240111,5840240112,5840240130,5840240132,5840240300,5840240302,5840240320,5840240322,5840241000,5840242020,5840242021,5840242030,5840242031,5840242100,5840242102,5840242120,5840303330,5840303331,5840303333,5840312010,5840312011,5840312013,5840312022,5840312023,5840312031,5840312032,5840312033,5840323330,5840323331,5840323332,5840331010,5840331012,5840331020,5840331021,5840331022,5840331200,5840331202,5840331220,5840331222,5840332200,5840332201,5840332210,5840332211,5840332300,5840332310,5840333000,5840333002,5840401131,5840401133,5840401311,5840410221,5840410223,5840411200,5840411201,5840411202,5840411210,5840411211,5840411220,5840411222,5840412010,5840412101,5840412110,5840412111,5840413000,5840420120,5840421030,5840421031,5840421032,5840421120,5840421121,57405023323,57405033323,57405033332,57406001101,57406001102,57406001103,57406001112,57406001113,57406003120,57406003121,57406003310,57406003311,57406010002,57406010020,57406010022,57406010023,57406010032,57406011032,57406011033,57406011101,57406011102,57406011103,57406011110,57406011112,57406011130,57406011132,57406011133,57406012200,57406012201,57406012203,57406012221,57406030010,57406030011,57406030013,57406030031,57406030033,57406030301,57406030303,57406031221,57406031223,57406033001,57406033003,57406033021,57406033030,57406033031,57406033033,57406033211,57406100022,57406100023,57406100032,57406100300,57406100302,57406103020,57406103022,57406103023,57406103032,57406103210,57406103212,57406103213,57406103302,57406103303,57406103312,57406103313,57406112202,57406112203,57406112212,57406112213,57406112302,57406112303,57406130112,57406133102,57406133120,57406133122,57406133123,57406133132,57406133133,57406222230,57406222232,57406222233,57407011013,57407011031,57407011033,57407011211,57407011213,57407011231,57407011233,57407012323,57407012332,57407012333,57407013011,57407021313,57407021331,57407021333,57407023031,57407023033,57407023111,57407023113,57407023211,57407023213,57407023223,57407023231,57407023232,57407023233,57407030012,57407030013,57407030023,57407030101,57407030102,57407030103,57407030201,57407030202,57407030203,57407200100,57407200102,57407200310,57407200312,57407200330,57407200332,57407200333,57407201222,57407203010,57407203012,57407203013,57407203120,57407203122,57407203123,57407203300,57407203302,57407203320,57407203322,57407221100,57407221102,57407221120,57407221122,57407221300,57407221302,57407221303,57407230222,57407423103,57407423112,57407423113,57407423121,57407423123,57407423303,57407423321,57407423323,57407430231,57407430232,57407430233,57407432002,57407432003,57407433012,57407433030,57407433032,57407433210,57407433212,57407433230,57407433232,57407433233,58400001001,58400001002,58400001003,58400001231,58400001233,58400003011,58400003013,58400003021,58400003023,58400003201,58400003210,58400003211,58400003213,58400023011,58400023013,58400023023,58400023031,58400023032,58400023033,58400023201,58400023202,58400023203,58400210000,58400210002,58400210020,58400210022,58400210212,58400210213,58400210302,58400210303,58400210312,58400210313,58400211322,58400211323,58400300220,58400300222,58400300223,58400302012,58400302120,58400302122,58400302312,58400302313,58400303202,58400303203,58400303213,58400303300,58400303302,58400303303,58400303330,58400303332,58400303333,58400313103,58400313112,58400313130,58400313132,58400313133,58400313202,58400313203,58400330002,58400330003,58400330111,58400330113,58400330122,58400330131,58400330133,58400401101,58400401103,58400401213,58400401223,58400402013,58400402022,58400402023,58400402031,58400402032,58400402033,58400411330,58400411332,58400413210,58400413212,58400413230,58400413232,58400431010,58400431012,58400431030,58400431032,58400431210,58400431212,58400431213,58400431322,58400431323,58400433310,58400433312,58400522220,58400522222,58401001001,58401001003,58401001021,58401001022,58401001023,58401002110,58401002111,58401003020,58401003021,58401003030,58401003031,58401003033,58401030031,58401030033,58401030211,58401030213,58401030231,58401030233,58401032011,58401032100,58401032101,58401032103,58401033223,58401033232,58401033233,58401033322,58401033323,58401411330,58401411332,58401431000,58401431001,58401432130,58401432131,58401432132,58401432310,58401432312,58401432320,58401432321,58401432322,58401432330,58401500000,58401500002,58401500212,58401500213,58401500231,58401500233,58401500302,58402010112,58402010113,58402011001,58402011002,58402011003,58402013201,58402013203,58402033111,58402033113,58402033333,58402122202,58402122203,58402332310,58402332311,58402332312,58402332330,58402333030,58402333031,58402333032,58402333100,58402333101,58402333102,58402333120,58402333200,58402333201,58402333210,58402410010,58402410011,58402410100,58402420321,58402420330,58402421012,58402421030,58402421032,58402421210,58402421212,58402421221,58403011111,58403011113,58403011131,58403011133,58403011311,58403011313,58403011331,58403011333,58403013111,58403013113,58403031313,58403031322,58403031323,58403031331,58403031332,58403031333,58403033320,58403033321,58403102211,58403102213,58403102231,58403102233,58403120011,58403120013,58403120031,58403120120,58403120121,58403120123,58403120202,58403120203,58403120212,58403120213,58403120301,58403120302,58403120303,58403310230,58403310232,58403312010,58403312012,58403312030,58403312032,58403312210,58403312212,58403312230,58403312232,58403322020,58403322021,58403322030,58403322031,58403322120,58403322121,58403322130,58403322131,58403323010,58403323011,58403323020,58403323021,58403323110,58403323111,58403323120,58403323121,58403330010,58403330012,58403330030,58403330032,58403330200,58403330202,58403330220,58404011110,58404011111,58404011113,58404011131,58404011133,58404013131,58404013133,58404102200,58404102201,58404112030,58404112031,58404112032,58404112120,58404112121,58404112130,58404112131,58404112210,58404112212,58404112230,58404112232,58404113000,58404113001,58404113002,58404113010,58404113011,58404113020,58404113100,58404113101,58404113110,58404113111,58404120010,58404120011,58404120013,58404120031,58404120120,58404120121,58404121130,58404121131,58404130010,58404130012,58404130020,58404130021,58404130030,58404201210,58404201211,58404201220,58404201221,58404201222,58404202000,58404202001,58404202010,58404202011,58404202100,58404202101,58404202110,58404202111,58404203000,58404210210,58404210211,58404210330,58404210331,58404210332,58404211100,58404211102,58404211120,58404211122,58404211220,58404211221,58404211230,58404211231,58404211300,58404212100,58404212101,58404212110,
025,00,Წ,502200000,137915625,504520312,141225000,14,30,71,92,226,354,573956,573966,573975,573976,573977,583906,583907,583917,583927,583937,583947,583926,583916,583905,5739462,5739463,5739643,5739651,5739652,5739653,5739672,5739673,5740700,5840102,5840200,5840202,5840300,5840302,5840400,5840402,5839461,5839463,5839363,5839361,5839360,5839151,5839153,5839041,5739743,5739741,5739642,5739740,5839640,5839641,57394533,57394602,57394603,57394611,57394612,57394613,57394702,57394720,57394722,57395511,57395513,57395531,57395700,57395702,57395720,57395722,57396501,57396502,57396503,57396700,57396702,57396703,57396712,57406022,57406023,57406032,57407010,57407020,57407022,58395701,58395710,58400000,58400002,58400020,58400022,58402030,58402032,58403010,58403012,58403030,58403032,58404010,58404012,58404030,58395611,58395700,58395610,58393621,58393623,58394601,58393620,58392513,58392511,58392531,58391501,58390431,57397423,58390401,58391503,57397421,58394603,58391500,57397420,58395432,58395423,58396421,58396420,58396430,58396431,58395433,58395422,573945133,573945303,573945311,573945312,573945313,573945321,573946012,573946103,573947000,573947002,573955331,573955332,573955333,573957012,573957030,573957032,573957210,573957212,573957230,573957232,573964123,573964131,573964132,573964133,573965003,573967010,573967012,573967013,573967102,573967132,574060202,574060203,574060211,574060212,574060213,574060302,574070120,574070121,574070122,574070210,574070211,574070212,583957110,583957111,584000210,584000212,584010000,584010001,584010002,584010020,584010022,584010023,584010032,584010322,584010323,584020100,584020102,584020120,584020122,584020123,584020310,584020312,584020330,584020332,584030110,584030112,584030130,584030132,584030133,584030310,584030311,584030312,584030330,584030332,584040110,584040112,584040130,584040132,584040133,584040310,584040311,584040312,584040320,584040321,584040330,584050000,584050001,584050003,584050010,584050012,584050021,584050030,5739363313,5739363323,5739363331,5739363332,5739363333,5739372222,5739372223,5739451313,5739451323,5739453012,5739453013,5739453101,5739453102,5739453103,5739453230,5739453231,5739453233,5739460032,5739460033,5739460130,5739460132,5739460133,5739461003,5739461012,5739461013,5739461021,5739461022,5739461023,5739470012,5739470030,5739470032,5739470302,5739470320,5739472120,5739472122,5739472300,5739472302,5739472320,5739472322,5739553013,5739553031,5739553033,5739553231,5739553232,5739553233,5739553300,5739553301,5739553303,5739570100,5739570102,5739570103,5739570130,5739570132,5739570310,5739572310,5739572312,5739572330,5739572332,5739641212,5739641213,5739641221,5739641222,5739641223,5739641301,5739641302,5739641303,5739650011,5739650012,5739650013,5739650023,5739670110,5739670112,5739671032,5739671302,5739671332,5740600323,5740600330,5740600332,5740600333,5740602002,5740602003,5740602012,5740602013,5740602101,5740602102,5740602103,5740603000,5740603002,5740603032,5740603033,5740603320,5740603322,5740603323,5740701100,5740701102,5740701120,5740701122,5740701230,5740701231,5740701300,5740701302,5740701303,5740702130,5740702132,5740702300,5740702301,5740702302,5740702310,5740702320,5740703000,5839570200,5839570201,5839570210,5839570211,5839570300,5839570301,5839570310,5839571120,5839571121,5839571130,5839571131,5840000122,5840000300,5840000322,5840000323,5840002112,5840002300,5840100030,5840100032,5840100210,5840100212,5840100213,5840100332,5840103000,5840103002,5840103020,5840103022,5840103200,5840103202,5840103203,5840103212,5840103213,5840103302,5840103303,5840103312,5840103320,5840103321,5840103330,5840201010,5840201012,5840201030,5840201032,5840201210,5840201212,5840201213,5840201322,5840201323,5840201332,5840203110,5840203112,5840203130,5840203132,5840203310,5840203312,5840203313,5840203330,5840203331,5840203332,5840301110,5840301112,5840301130,5840301132,5840301310,5840301312,5840301313,5840303130,5840310220,5840310222,5840312000,5840312002,5840401110,5840401112,5840401130,5840401132,5840401310,5840401312,5840403130,5840403131,5840403132,5840403220,5840403221,5840403222,5840403230,5840403231,5840403310,5840403312,5840403320,5840410222,5840412000,5840412002,5840500020,5840500021,5840500023,5840500110,5840500111,5840500112,5840500130,5840500131,5840500132,5840500201,5840500231,5840500310,5840500312,5840500320,5840500321,5840500323,5840500330,5840500332,5839561300,5839561301,5839561310,5839561311,5839561211,5839561210,5839561201,5839561200,57393631332,57393633103,57393633110,57393633112,57393633121,57393633123,57393633212,57393633213,57393633222,57393633223,57393633301,57393633302,57393633303,57393722020,57393722022,57393722200,57393722202,57394513033,57394513103,57394513112,57394513113,57394513121,57394513122,57394513123,57394513211,57394513212,57394513213,57394600222,57394600223,57394600232,57394600233,57394601310,57394601312,57394610201,57394610203,57394700100,57394700102,57394700103,57394700112,57394700130,57394700132,57394700310,57394700312,57394700330,57394700332,57394700333,57394721022,57394721023,57394721212,57394721230,57394721232,57394723010,57395510110,57395510111,57395510113,57395510131,57395510133,57395510311,57395510313,57395510331,57395510333,57395512111,57395512113,57395512131,57395512133,57395512311,57395512313,57395512331,57395512333,57395530111,57395530113,57395532111,57395532113,57395532231,57395532233,57395533021,57395533023,57395701012,57395701013,57395701122,57395701123,57395703120,57395703121,57395703322,57395703323,57395721122,57395721123,57395721300,57395721301,57395723130,57395723132,57396411223,57396411232,57396411233,57396411322,57396411323,57396411332,57396411333,57396412112,57396412113,57396413001,57396413002,57396413003,57396500031,57396500033,57396500203,57396500211,57396500212,57396500213,57396500221,57396500222,57396500223,57396701112,57396701130,57396701132,57396701133,57396710022,57396710023,57396710330,57396710332,57396713030,57396713032,57396713033,57396713302,57396713303,57396713332,57396713333,57406002222,57406003122,57406003123,57406003212,57406003213,57406003312,57406003313,57406012202,57406012220,57406012222,57406012223,57406020000,57406020002,57406020003,57406020012,57406020013,57406020102,57406021003,57406030012,57406030030,57406030032,57406030300,57406030302,57406031220,57406031222,57406033000,57406033002,57406033020,57406033022,57406033023,57406033032,57406033210,57406033212,57406033213,57407011010,57407011011,57407011012,57407011030,57407011032,57407011210,57407011212,57407011230,57407011232,57407012320,57407012321,57407012322,57407012330,57407012331,57407013010,57407013012,57407013013,57407021310,57407021311,57407021312,57407021330,57407021332,57407023030,57407023032,57407023110,57407023112,57407023210,57407023212,57407023220,57407023221,57407023222,57407023230,57407030010,57407030011,57407030020,57407030021,57407030022,57407030100,57407030200,58395703110,58395703111,58395703112,58395711220,58395711221,58395711222,58395711230,58395711231,58395711320,58395711321,58395711330,58395711331,58395712000,58395712001,58395712010,58395712011,58395712100,58395712101,58395712110,58395712111,58395713000,58400001000,58400001230,58400001232,58400003010,58400003012,58400003020,58400003022,58400003200,58400003202,58400003203,58400003212,58400023010,58400023012,58400023020,58400023021,58400023022,58400023030,58400023200,58401001000,58401001002,58401001020,58401002112,58401002113,58401003022,58401003023,58401003032,58401030030,58401030032,58401030210,58401030212,58401030230,58401030232,58401032010,58401032012,58401032013,58401032102,58401033220,58401033221,58401033222,58401033230,58401033231,58401033320,58401033321,58402010110,58402010111,58402011000,58402013200,58402013202,58402033110,58402033112,58402033330,58402033331,58402033332,58402122200,58402122201,58403011110,58403011112,58403011130,58403011132,58403011310,58403011312,58403011330,58403011332,58403013110,58403013112,58403031310,58403031311,58403031312,58403031320,58403031321,58403031330,58403033322,58403033323,58403102210,58403102212,58403102230,58403102232,58403120010,58403120012,58403120030,58403120032,58403120033,58403120122,58403120200,58403120201,58403120210,58403120211,58403120300,58404011112,58404011130,58404011132,58404013130,58404013132,58404031330,58404031331,58404033210,58404033212,58404102202,58404102203,58404120012,58404120030,58404120032,58404120033,58404120122,58404120200,58404120201,58404120210,58404120211,58404120300,58405000220,58405000221,58405001130,58405001132,58405001330,58405001331,58405001332,58405002031,58405002033,58405002301,58405002303,58405003110,58405003112,58405003130,58405003132,58405003310,58405003312,58405003330,58405003332,58405010000,58405010002,58405010200,58405010202,58405010220,
026,00,,501707812,130293750,503718750,132168750,6,18,44,85,222,497,543944,543945,543954,543955,543964,543965,5439253,5439333,5439342,5439343,5439351,5439352,5439353,5439360,5439362,5439431,5439433,5439460,5439531,5439533,5439660,5439740,5439741,5439750,54392523,54392622,54392623,54393313,54393412,54393413,54393501,54393502,54393503,54393612,54393630,54393632,54393633,54393722,54394301,54394302,54394303,54394320,54394321,54394323,54394610,54394611,54394620,54394622,54395301,54396310,54396311,54396313,54396331,54396620,54396621,54396622,54397421,54397422,54397423,54397430,54397431,54397510,54397511,54397512,54397521,54397530,55390401,55390403,543925122,543925211,543925213,543925223,543926202,543926203,543926322,543933213,543933231,543934020,543934022,543934023,543934031,543934032,543934033,543934102,543935001,543935003,543936100,543936102,543943003,543943220,543943221,543943223,543946120,543946121,543946122,543946210,543946211,543946212,543946230,543946232,543947000,543947001,543947003,543947021,543953031,543953033,543953233,543956000,543956001,543956002,543956020,543956022,543956200,543956202,543956220,543956222,543956223,543956232,543963121,543963122,543963123,543963331,543963333,543966102,543966120,543966122,543966230,543966232,543966300,543973111,543973113,543973130,543973131,543974201,543974202,543974203,543974320,543974321,543974322,543975130,543975131,543975200,543975201,543975230,543975231,543975320,543976000,543976001,553904001,553904100,553904102,553904120,553904122,5439250323,5439250331,5439250332,5439250333,5439251202,5439251230,5439251232,5439251321,5439251322,5439251323,5439251330,5439251332,5439251333,5439252101,5439252103,5439252121,5439252122,5439252123,5439252210,5439252212,5439252213,5439252223,5439262000,5439262002,5439262003,5439262012,5439262122,5439262123,5439263200,5439263202,5439263203,5439263232,5439331122,5439331123,5439331211,5439331213,5439331223,5439331231,5439331232,5439331233,5439332111,5439332113,5439332123,5439332301,5439332303,5439332331,5439332332,5439332333,5439340133,5439340212,5439340213,5439340301,5439340302,5439340303,5439341030,5439341032,5439341033,5439341122,5439341123,5439341132,5439350001,5439350003,5439350021,5439350022,5439350023,5439361010,5439361012,5439361030,5439361032,5439361033,5439363120,5439363122,5439363123,5439363132,5439372013,5439372023,5439372031,5439372032,5439372033,5439372100,5439372102,5439372120,5439372121,5439372122,5439372300,5439372302,5439372320,5439372322,5439421331,5439421333,5439423111,5439423113,5439423131,5439423133,5439430013,5439432220,5439432221,5439432223,5439461230,5439461231,5439462130,5439462132,5439462310,5439462311,5439462312,5439463200,5439470020,5439470021,5439470100,5439470102,5439470120,5439470122,5439470300,5439530010,5439530011,5439530013,5439530031,5439530300,5439530301,5439530303,5439530321,5439530322,5439530323,5439532131,5439532133,5439532311,5439532312,5439532313,5439560030,5439560031,5439560032,5439560100,5439560210,5439560212,5439562012,5439562030,5439562032,5439562210,5439562212,5439562213,5439562302,5439562303,5439630110,5439630111,5439630113,5439630131,5439631201,5439631202,5439631203,5439633000,5439633001,5439633010,5439633011,5439633013,5439633031,5439633301,5439633303,5439661000,5439661002,5439661003,5439661032,5439661210,5439661212,5439661230,5439662310,5439662311,5439662312,5439662330,5439662332,5439662333,5439663020,5439663021,5439731101,5439731103,5439731121,5439731122,5439731123,5439731331,5439731333,5439742001,5439742003,5439743230,5439743231,5439743232,5439743300,5439743301,5439743302,5439752020,5439752031,5439752033,5439752212,5439752213,5439752231,5439752233,5439752320,5439752321,5439752330,5439753102,5439753120,5439753210,5439753211,5439753212,5439753221,5439753230,5439760020,5439760021,5439760022,5439760031,5439760100,5439760101,5439760102,5439760110,5439760112,5539040001,5539040031,5539040033,5539040211,5539040213,5539040231,5539040233,5539041010,5539042110,54392503123,54392503132,54392503133,54392503212,54392503213,54392503301,54392503302,54392503303,54392512123,54392512310,54392512312,54392512330,54392512332,54392512333,54392513032,54392513033,54392513203,54392513312,54392520333,54392521023,54392521201,54392521203,54392522111,54392522112,54392522113,54392522211,54392522213,54392602220,54392602222,54392602223,54392620010,54392620012,54392620013,54392620132,54392621200,54392621202,54392621203,54392621212,54392621322,54392621323,54392621332,54392621333,54392632012,54392632122,54392632300,54392632302,54392632303,54393303331,54393303332,54393303333,54393310323,54393310331,54393310332,54393310333,54393311320,54393311322,54393311323,54393311332,54393311333,54393312101,54393312103,54393312212,54393312213,54393312220,54393312222,54393312223,54393312302,54393312303,54393321121,54393321123,54393323210,54393323211,54393323223,54393323232,54393323233,54393323300,54393323301,54393323303,54393400222,54393400223,54393401232,54393401233,54393401311,54393401313,54393401322,54393401323,54393402100,54393402102,54393402103,54393402112,54393403002,54393403003,54393410312,54393410313,54393411202,54393411203,54393411212,54393411213,54393411302,54393411303,54393411330,54393411332,54393411333,54393610310,54393610312,54393611222,54393613000,54393613002,54393613020,54393613022,54393613200,54393613222,54393631000,54393631002,54393631020,54393631022,54393631023,54393631212,54393631332,54393631333,54393720103,54393720111,54393720112,54393720113,54393720121,54393720123,54393720203,54393720212,54393720213,54393720221,54393720222,54393720223,54393720301,54393720302,54393720303,54393721012,54393721030,54393721032,54393721230,54393721231,54393721232,54393723010,54393723012,54393723030,54393723032,54393723210,54393723212,54393723230,54393723232,54394213113,54394213131,54394213132,54394213133,54394213323,54394231101,54394231103,54394231121,54394231123,54394231301,54394231303,54394233111,54394300113,54394300123,54394300223,54394300231,54394300232,54394300233,54394322221,54394322223,54394612320,54394612321,54394613000,54394613001,54394613002,54394613010,54394613011,54394613020,54394613022,54394613100,54394613101,54394613110,54394613111,54394613113,54394613200,54394613202,54394621310,54394621312,54394621330,54394621332,54394621333,54394623130,54394623131,54394623300,54394623301,54394623302,54394623320,54394630000,54394630222,54394632020,54394700220,54394700221,54394700222,54394700230,54394700231,54394700233,54394701010,54394701012,54394701030,54394701032,54394701033,54394701210,54394701211,54394701212,54394701230,54394701232,54394702000,54394702002,54394703010,54394703012,54394703020,54395300010,54395300011,54395300013,54395300121,54395300123,54395300301,54395300303,54395300321,54395300330,54395300331,54395300333,54395302111,54395302113,54395303020,54395303021,54395303023,54395303203,54395321010,54395321011,54395321100,54395321110,54395321111,54395321113,54395321131,54395321132,54395321133,54395321323,54395323101,54395323103,54395323211,54395323213,54395323231,54395323233,54395600330,54395600331,54395600332,54395601010,54395601011,54395601020,54395601021,54395601022,54395601200,54395601202,54395602110,54395602300,54395602301,54395602302,54395602320,54395620100,54395620102,54395620310,54395620312,54395620330,54395620332,54395622110,54395622112,54395622113,54395623012,54395623013,54395623120,54395623122,54395623300,54395623302,54395623320,54395623322,54395623323,54395623332,54395623333,54395632222,54396301011,54396301120,54396301121,54396301123,54396301301,54396301331,54396301333,54396303111,54396303131,54396303133,54396303311,54396303313,54396303331,54396303333,54396312000,54396312001,54396312003,54396330020,54396330021,54396330023,54396330030,54396330031,54396330032,54396330120,54396330121,54396330123,54396330331,54396330333,54396332111,54396333001,54396333003,54396333021,54396333023,54396333210,54396333211,54396333213,54396333231,54396333232,54396333233,54396610010,54396610012,54396610302,54396610303,54396612112,54396612130,54396612132,54396612320,54396623312,54396623313,54396630102,54396630120,54396630122,54396630123,54396630220,54396630230,54396630231,54396630300,54396630301,54396630302,54396630320,54396632202,54396632220,54396632222,54397310331,54397310333,54397311001,54397311003,54397311021,54397311023,54397311201,54397311202,54397311203,54397312111,54397312113,54397312131,54397313210,54397313211,54397313300,54397313301,54397313303,54397313321,54397313323,54397331110,54397331111,54397331313,54397331331,54397331333,54397333111,54397333113,54397333131,54397333133,54397333311,54397333313,54397333331,54397420000,54397420001,54397420021,54397420023,54397432330,54397432331,54397432332,54397433030,54397433100,54397433101,54397433110,54397433200,54397433202,54397433220,54397513200,54397513201,54397513202,54397513210,54397513211,54397513220,54397513222,54397513300,54397513301,54397513303,54397513310,54397513311,54397513312,54397520210,54397520211,54397520212,54397520220,54397520222,54397520301,54397522111,54397522113,54397522301,54397522303,54397522321,54397522323,54397523220,54397523221,54397523222,54397523230,54397523231,54397523310,54397523311,54397523312,54397523320,54397523321,54397531000,54397531002,54397531220,54397531222,54397532130,54397532132,54397532200,54397532201,54397532230,54397532231,54397532310,54397532312,54397532320,54397532321,54397600230,54397600231,54397600232,54397600300,54397600301,54397600303,54397601030,54397601031,54397601032,54397601110,54397601111,54397601112,54397601200,54397601202,54397602000,54397602001,54397602002,54397602020,54397610000,55390400031,55390400033,55390400300,55390400301,55390400303,55390402301,55390402303,55390402321,55390410120,55390410122,55390410300,55390410302,55390410320,55390410322,55390412100,55390412120,55390412122,55390412300,55390412302,55390412320,55390420111,55390421000,55390421001,55390421010,55390421011,55390421110,55390421111,55390421113,55390430000,55390430001,55390430002,55390430010,
027,00,Ե,503085937,130790625,504956250,132487500,7,14,34,94,176,422,543957,543967,543977,544050,544060,544061,544070,5439472,5439473,5439561,5439763,5440402,5440510,5440512,5440710,5440712,5539070,5539071,5540000,5540001,5540002,54394631,54394633,54394712,54395603,54395621,54395630,54395631,54395633,54396611,54396613,54396631,54396633,54397603,54397611,54397612,54397613,54404123,54405130,54405132,54407110,54407111,54407112,54407130,54407132,55390610,55390611,55390613,55390731,55390733,55400030,55400100,55400102,55401000,55401001,543946133,543946301,543946303,543946321,543946322,543946323,543947013,543947022,543947023,543947031,543947032,543947033,543947102,543947132,543947133,543956011,543956013,543956320,543956321,543956323,543966101,543966320,543966321,543966323,543976013,543976021,543976022,543976023,543976101,543976102,543976103,543976210,543976211,543976213,543976231,543976233,544040320,544040322,544040323,544040330,544040332,544040333,544041223,544041322,544051100,544051102,544051120,544051122,544051330,544051332,544062002,544071130,544071131,544071132,544071310,544071312,544071330,544071332,553906011,553906013,553906031,553906120,553906121,553906122,553906310,553906311,553906313,553907200,553907201,553907210,553907211,553907300,553907301,553907303,553917111,553917113,553917131,553917133,554000310,554000311,554000312,554000320,554000321,554000322,554001010,554001011,554001012,554001100,554001101,554001200,554001201,554010020,554010100,554010102,5439461233,5439461303,5439461312,5439461313,5439461321,5439461322,5439461323,5439462331,5439462333,5439463001,5439463002,5439463003,5439463020,5439463021,5439463023,5439463201,5439463203,5439470110,5439470112,5439470113,5439470201,5439470202,5439470203,5439470303,5439471030,5439471032,5439471033,5439560103,5439560121,5439560122,5439560123,5439560213,5439560231,5439560233,5439562011,5439562013,5439562300,5439562310,5439562311,5439562313,5439562331,5439563220,5439563221,5439563223,5439661031,5439661033,5439661231,5439661233,5439662313,5439663011,5439663013,5439663031,5439663033,5439663221,5439663223,5439760032,5439760033,5439760113,5439760121,5439760122,5439760123,5439760201,5439760203,5439761001,5439761002,5439761003,5439762011,5439762013,5439762120,5439762121,5439762323,5440400220,5440400222,5440400223,5440400232,5440400233,5440400323,5440400332,5440403000,5440403002,5440403020,5440403022,5440403123,5440403132,5440403211,5440403212,5440403213,5440403310,5440403312,5440412213,5440412222,5440412223,5440413200,5440413202,5440511010,5440511012,5440511030,5440511032,5440511210,5440511212,5440511230,5440511232,5440620200,5440620202,5440622002,5440711330,5440711331,5440711332,5440713110,5440713112,5440713113,5440713130,5440713131,5440713132,5440713310,5440713312,5440713332,5539060101,5539060103,5539060120,5539060121,5539060123,5539060301,5539060303,5539060321,5539060330,5539060331,5539060333,5539061230,5539061231,5539061232,5539063000,5539063121,5539072020,5539072021,5539072030,5539073020,5539073021,5539073022,5539073233,5539171100,5539171101,5539171103,5539171121,5539171301,5539171303,5539171321,5539173110,5539173111,5539173113,5540003130,5540003131,5540003230,5540003232,5540010130,5540010131,5540010300,5540010301,5540010302,5540010320,5540010322,5540011020,5540011021,5540011030,5540011100,5540012030,5540012031,5540012100,5540100210,5540100212,5540100220,5540100221,5540100222,5540101010,5540101012,5540101030,54393723233,54393723322,54394612322,54394612323,54394613003,54394613012,54394613013,54394613021,54394613023,54394613102,54394613103,54394613112,54394613201,54394613203,54394621311,54394621313,54394621331,54394623132,54394623133,54394623303,54394623321,54394623322,54394623323,54394630001,54394630002,54394630003,54394630220,54394630221,54394630223,54394632021,54394632022,54394632023,54394700223,54394700232,54394701011,54394701013,54394701031,54394701112,54394701113,54394701213,54394701231,54394701233,54394702001,54394702003,54394703011,54394703013,54394703021,54394703022,54394703023,54394710020,54394710022,54394710023,54394710032,54394710312,54394710313,54394713020,54394713022,54395600333,54395601012,54395601013,54395601023,54395601201,54395601203,54395602111,54395602112,54395602113,54395602303,54395602321,54395602322,54395602323,54395620101,54395620103,54395620311,54395620313,54395620331,54395620333,54395622111,54395623010,54395623011,54395623121,54395623123,54395623301,54395623303,54395623321,54395623330,54395623331,54395632220,54395632221,54395632223,54396610011,54396610013,54396610300,54396610301,54396612110,54396612111,54396612113,54396612131,54396612133,54396612321,54396612322,54396612323,54396623310,54396623311,54396630100,54396630101,54396630103,54396630121,54396630221,54396630222,54396630223,54396630232,54396630233,54396630303,54396630321,54396630322,54396630323,54396632200,54396632201,54396632203,54396632221,54396632223,54397513313,54397513331,54397600233,54397600302,54397601033,54397601113,54397601201,54397601203,54397602003,54397602021,54397602022,54397602023,54397610001,54397610002,54397610003,54397620001,54397620010,54397620011,54397620100,54397620101,54397620103,54397620121,54397620123,54397620311,54397620313,54397621220,54397621221,54397621230,54397621231,54397621233,54397623011,54397623013,54397623031,54397623033,54397623211,54397623213,54404002212,54404002213,54404002302,54404003220,54404003222,54404003223,54404003332,54404003333,54404012222,54404030012,54404030030,54404030032,54404030210,54404030212,54404030230,54404030232,54404030323,54404030332,54404030333,54404031212,54404031222,54404031223,54404032101,54404032102,54404032103,54404033132,54404120333,54404121222,54404121223,54404121232,54404121233,54404121322,54404121323,54404121332,54404121333,54404122111,54404122112,54404122113,54404122123,54404122200,54404122202,54404122203,54404122211,54404122212,54404122213,54404130222,54404132012,54404132030,54404132032,54404132033,54404132320,54404132322,54404132323,54405112312,54405112330,54405112332,54405131202,54405131220,54405131222,54405131223,54405131232,54405133120,54405133122,54405133300,54405133302,54405133320,54405133322,54405133323,54405133332,54405133333,54406200000,54406200002,54406200020,54406200022,54406202010,54406202012,54406202030,54406202200,54406202202,54406202220,54406202222,54406220000,54406220002,54406220003,54406220200,54406220201,54406220202,54406220220,54406220222,54406222000,54406222002,54406222020,54406222022,54406222200,54406222202,54406222220,54406222222,54407113330,54407113331,54407113332,54407131330,54407131331,54407131332,54407133110,54407133112,54407133130,54407133300,54407133301,54407133302,54407200000,54407200002,54407200020,54407200022,54407200200,54407200202,54407200220,54407200222,54407202000,54407202002,54407202020,54407202022,54407202200,54407202202,55390601003,55390601021,55390601022,55390601023,55390601221,55390601223,55390603001,55390603003,55390603021,55390603023,55390603201,55390603203,55390603230,55390603231,55390603321,55390603323,55390612330,55390612331,55390612333,55390621110,55390621111,55390621113,55390630010,55390630011,55390630012,55390630100,55390630101,55390630103,55390630111,55390630113,55390630131,55390631201,55390631230,55390631231,55390631233,55390720220,55390720310,55390720311,55390721200,55390721201,55390721300,55390721301,55390721310,55390730230,55390730231,55390730233,55390732111,55390732113,55390732131,55390732133,55390732311,55390732312,55390732313,55391710111,55391711020,55391711021,55391711023,55391711201,55391711203,55391711231,55391711233,55391713230,55391713231,55391713233,55391731011,55391731013,55391731120,55391731121,55391731123,55400031320,55400031321,55400031322,55400031330,55400031331,55400032310,55400032311,55400032312,55400032330,55400032332,55400033000,55400033001,55400033002,55400033010,55400033011,55400101320,55400101322,55400103030,55400103032,55400103100,55400103210,55400103212,55400103230,55400103232,55400110310,55400110311,55400110312,55400111010,55400111011,55400111012,55400111020,55400111100,55400120200,55400120202,55400120210,55400120211,55400120213,55400121010,55400121012,55400121020,55400121021,55400121022,55400121200,55401002110,55401002111,55401002112,55401002130,55401002132,55401002230,55401002232,55401002300,55401002301,55401003000,55401003001,55401003010,55401003011,55401003100,55401003101,55401003110,55401003111,55401010130,55401010132,55401010310,55401010312,55401010320,55401010321,55401010322,55401012000,55401012001,55401012010,55401020000,55401020001,55401020002,
028,00,/,501581250,131746875,502860937,132609375,1,5,20,53,118,256,553903,5439732,5539130,5539131,5539140,5539141,54397231,54397233,54397303,54397330,54397332,55390211,55390411,55390413,55390422,55390423,55390431,55390432,55390433,55390502,55390520,55390522,55391321,55391330,55391331,55391421,543972133,543972301,543972321,543973021,543973022,543973023,543973120,543973122,543973123,543973310,543973312,543973330,543973332,543974333,543975220,543975222,553902131,553902133,553904002,553904020,553904022,553904200,553904202,553904203,553904212,553904213,553904301,553904302,553904303,553905000,553905002,553905032,553905210,553905212,553905232,553912111,553912113,553913200,553913201,553913203,553913230,553913231,553913233,553913320,553914200,553914201,553914203,553914300,553914301,553914310,553915000,553915001,553915002,5439721303,5439721312,5439721313,5439721321,5439721322,5439721323,5439723031,5439723032,5439723033,5439723231,5439723233,5439730033,5439730122,5439730123,5439730132,5439730133,5439730202,5439730203,5439731022,5439731032,5439731210,5439731212,5439731320,5439731322,5439731323,5439733110,5439733112,5439733113,5439733130,5439733132,5439733310,5439733312,5439733330,5439733332,5439743312,5439743313,5439743321,5439743323,5439752023,5439752032,5439752210,5539021011,5539021300,5539021301,5539021303,5539021321,5539023110,5539023111,5539023113,5539023131,5539023133,5539023311,5539023313,5539023331,5539023332,5539023333,5539040000,5539040002,5539040032,5539040210,5539040212,5539041011,5539041013,5539041031,5539041033,5539041211,5539041213,5539041231,5539041233,5539042010,5539042012,5539042013,5539042102,5539042103,5539042112,5539042113,5539043002,5539043003,5539050010,5539050012,5539050030,5539050032,5539050033,5539050302,5539052112,5539052130,5539052132,5539052300,5539052302,5539121103,5539121311,5539121313,5539132211,5539132320,5539132321,5539133210,5539133211,5539133212,5539133220,5539133221,5539133230,5539133310,5539142020,5539142021,5539142022,5539142301,5539143020,5539143021,5539143022,5539143030,5539143031,5539143110,5539143112,5539143120,5539143121,5539150030,5539150100,5539150200,54397212323,54397212331,54397212332,54397212333,54397213023,54397213102,54397213103,54397213112,54397213113,54397213201,54397213202,54397213203,54397230300,54397230301,54397230303,54397232300,54397232301,54397232303,54397232321,54397300303,54397300312,54397300313,54397300321,54397300322,54397300323,54397301303,54397301312,54397301313,54397302002,54397302003,54397302011,54397302012,54397302013,54397310202,54397310203,54397310230,54397310232,54397310233,54397310332,54397312110,54397312112,54397312130,54397312132,54397312133,54397313212,54397313213,54397313302,54397313320,54397313322,54397331112,54397331113,54397331310,54397331311,54397331312,54397331330,54397331332,54397333110,54397333112,54397333130,54397333132,54397333310,54397333312,54397333330,54397333332,54397333333,54397420002,54397420003,54397420020,54397420022,54397432333,54397433031,54397433032,54397433033,54397433102,54397433103,54397433111,54397433112,54397433113,54397433201,54397433203,54397433221,54397433222,54397433223,54397520213,54397520221,54397520223,54397520300,54397520302,54397520303,54397522110,54397522112,54397522300,54397522302,54397522320,54397522322,55390210130,55390210131,55390210133,55390210311,55390210313,55390210331,55390210333,55390212111,55390213020,55390213021,55390213023,55390213231,55390213233,55390231121,55390233303,55390400030,55390400032,55390400302,55390402300,55390402302,55390402320,55390402322,55390402323,55390410121,55390410123,55390410301,55390410303,55390410321,55390410323,55390412101,55390412102,55390412103,55390412121,55390412123,55390412301,55390412303,55390412321,55390412322,55390412323,55390420110,55390420112,55390420113,55390421002,55390421003,55390421012,55390421013,55390421112,55390430003,55390430011,55390430012,55390430013,55390500110,55390500111,55390500112,55390500130,55390500132,55390500310,55390500312,55390501222,55390503000,55390503002,55390503003,55390503030,55390503032,55390503033,55390503322,55390521100,55390521102,55390521103,55390521310,55390521312,55390521330,55390523010,55390523011,55390523012,55390523030,55390523032,55391211011,55391211012,55391211013,55391211210,55391211211,55391211213,55391211231,55391211233,55391213011,55391213100,55391213101,55391213103,55391213121,55391213123,55391213310,55391213311,55391320201,55391320210,55391320211,55391322100,55391322101,55391322103,55391322121,55391322130,55391322131,55391322133,55391322311,55391322313,55391323231,55391323233,55391332130,55391332131,55391332132,55391332220,55391332221,55391332222,55391332310,55391333000,55391333001,55391333002,55391333010,55391333011,55391333110,55391333111,55391420230,55391420231,55391420232,55391422000,55391422010,55391423100,55391423101,55391423102,55391423110,55391423111,55391430230,55391430231,55391430320,55391430321,55391430331,55391431110,55391431111,55391431112,55391431220,55391431221,55391431230,55391431300,55391432000,55391500310,55391500311,55391500320,55391500321,55391500322,55391501010,55391501011,55391501012,55391501020,55391501022,55391501200,55391502010,55391502020,55391502022,55391502200,55391502202,55392301101,
029,00,/,501651562,131821875,503465625,133509375,2,11,32,71,171,443,553924,553925,5539051,5539053,5539152,5539231,5539233,5539340,5539341,5539350,5539352,5539353,5539451,54397533,54397622,55390600,55390602,55390620,55390622,55391433,55391503,55391510,55391512,55391530,55391532,55392300,55392302,55392303,55392320,55392321,55392323,55392602,55393310,55393311,55393313,55393430,55393431,55393433,55393510,55393511,55393512,55394501,55394531,55394620,55394621,543975311,543975313,543976202,553905010,553905011,553905013,553905031,553905231,553905233,553906210,553906212,553906213,553906230,553906231,553906302,553906303,553913332,553913333,553914221,553914222,553914223,553914232,553914233,553914321,553914322,553914323,553915011,553915013,553915021,553915023,553915110,553915111,553915112,553915130,553915132,553915310,553915312,553915330,553915332,553916000,553922113,553922131,553922133,553923010,553923012,553923013,553926002,553926200,553926202,553926220,553926222,553933121,553934201,553934210,553934211,553934213,553934320,553934321,553935130,553935131,553935132,553936000,553945000,553945001,553945003,553945031,553945300,553945301,553946022,553946230,553946231,5439751323,5439751332,5439752333,5439753101,5439753103,5439753121,5439753123,5439753222,5439753233,5439762002,5439762003,5439762030,5439762032,5439762033,5439762300,5439762302,5439762320,5439762322,5539050120,5539050121,5539050123,5539050301,5539050330,5539050331,5539050333,5539052111,5539052113,5539060322,5539062110,5539062112,5539062113,5539062320,5539062321,5539062322,5539062330,5539063002,5539063003,5539063012,5539063122,5539063200,5539063201,5539132232,5539132233,5539132322,5539133223,5539133232,5539133233,5539133302,5539133303,5539133312,5539133313,5539142202,5539142203,5539142300,5539142302,5539142303,5539142312,5539142313,5539143113,5539143131,5539143132,5539143133,5539143201,5539143202,5539143203,5539150033,5539150103,5539150121,5539150122,5539150123,5539150203,5539150221,5539150222,5539150223,5539151130,5539151131,5539151132,5539151310,5539151312,5539151330,5539151332,5539153332,5539160010,5539160011,5539160012,5539160020,5539160021,5539221113,5539221121,5539221123,5539230111,5539230112,5539230113,5539232210,5539232211,5539232213,5539232231,5539232233,5539260002,5539260032,5539262010,5539262012,5539262030,5539262032,5539262033,5539262210,5539262211,5539262212,5539262230,5539262232,5539330100,5539330101,5539330110,5539330111,5539330113,5539331200,5539331201,5539331203,5539331230,5539331231,5539331233,5539333100,5539333101,5539342120,5539342121,5539342311,5539343231,5539351330,5539351332,5539351333,5539360010,5539360020,5539362220,5539362222,5539441100,5539441101,5539441110,5539441111,5539450021,5539450023,5539450201,5539450210,5539450211,5539450300,5539450301,5539450303,5539450331,5539450333,5539452111,5539460000,5539460002,5539460020,5539460022,5539460200,5539460202,5539460232,5539460233,5539460322,5539460323,5539462201,5539462210,5539462211,5539462320,5539462321,5539462330,5539462331,5539463022,5539463200,5539463202,5539463220,5539463221,54397513203,54397513212,54397513213,54397513221,54397513223,54397513302,54397513330,54397513332,54397513333,54397523223,54397523232,54397523233,54397523313,54397523322,54397523323,54397531001,54397531003,54397531221,54397531223,54397532131,54397532133,54397532202,54397532203,54397532232,54397532233,54397532311,54397532313,54397532322,54397532323,54397620000,54397620002,54397620003,54397620012,54397620013,54397620102,54397620120,54397620122,54397620310,54397620312,54397621222,54397621223,54397621232,54397623010,54397623012,54397623030,54397623032,54397623210,54397623212,55390500113,55390500131,55390500133,55390500311,55390500313,55390501220,55390501221,55390501223,55390503001,55390503031,55390503320,55390503321,55390503323,55390521101,55390521311,55390521313,55390521331,55390521332,55390521333,55390523013,55390523031,55390523033,55390601000,55390601001,55390601002,55390601020,55390601220,55390601222,55390603000,55390603002,55390603020,55390603022,55390603200,55390603202,55390603232,55390603233,55390603320,55390603322,55390612332,55390621112,55390623230,55390623231,55390623232,55390623310,55390623311,55390623312,55390623320,55390623321,55390630013,55390630102,55390630110,55390630112,55390630130,55390630132,55390630133,55390631200,55390631202,55390631203,55390632020,55390632021,55390632022,55390632100,55390632101,55390632102,55390632110,55390632111,55390633000,55391233333,55391322222,55391322223,55391322231,55391322232,55391322233,55391323230,55391323232,55391332133,55391332223,55391332311,55391332312,55391332313,55391333003,55391333012,55391333013,55391333112,55391333113,55391420233,55391422001,55391422002,55391422003,55391422011,55391422012,55391422013,55391423103,55391423112,55391423113,55391430232,55391430233,55391430322,55391430323,55391430330,55391430332,55391430333,55391431113,55391431222,55391431223,55391431231,55391431232,55391431233,55391431301,55391431302,55391431303,55391432001,55391432002,55391432003,55391500312,55391500313,55391500323,55391501013,55391501021,55391501023,55391501201,55391501202,55391501203,55391502011,55391502012,55391502013,55391502021,55391502023,55391502201,55391502203,55391511330,55391511331,55391531100,55391531101,55391531102,55391531120,55391531122,55391533100,55391533102,55391533120,55391533122,55391533300,55391533332,55391533333,55391600220,55391600221,55391600230,55391600300,55391601000,55391601001,55392211033,55392211103,55392211111,55392211112,55392211113,55392211121,55392211122,55392211123,55392211203,55392211221,55392211223,55392213010,55392213011,55392213013,55392213031,55392213033,55392213211,55392213231,55392213233,55392231011,55392231100,55392231101,55392231110,55392231111,55392231113,55392231131,55392231133,55392231311,55392231313,55392231331,55392301100,55392301102,55392301103,55392322001,55392322010,55392322011,55392322013,55392322121,55392322123,55392322301,55392322303,55392322321,55392322323,55392600002,55392600003,55392600032,55392600033,55392600300,55392600302,55392600303,55392600330,55392600332,55392600333,55392620110,55392620111,55392620112,55392620130,55392620132,55392620310,55392620312,55392621222,55392622130,55392622132,55392622310,55392622312,55392622330,55392622332,55392623000,55392623002,55393300110,55393300111,55393300113,55393300131,55393301020,55393301021,55393301023,55393301030,55393301031,55393301032,55393301120,55393301121,55393301310,55393301311,55393301313,55393301331,55393301333,55393303111,55393312021,55393312211,55393312321,55393312323,55393330101,55393330110,55393330111,55393330113,55393330131,55393331020,55393331021,55393331030,55393331031,55393331100,55393331101,55393331102,55393331110,55393331111,55393331120,55393420000,55393420001,55393420010,55393420011,55393420013,55393420031,55393420300,55393420301,55393420310,55393420311,55393420313,55393421231,55393421233,55393423101,55393423103,55393432211,55393432300,55393432301,55393432303,55393432321,55393432330,55393432331,55393432333,55393513310,55393513312,55393513313,55393600110,55393600112,55393600120,55393600121,55393600122,55393600210,55393600211,55393600212,55393600220,55393600221,55393600222,55393600230,55393602000,55393602002,55393602020,55393602022,55393602222,55393620000,55393620002,55393620020,55393620022,55393620200,55393620202,55393620220,55393620222,55393622000,55393622002,55393622020,55393622022,55393622230,55393622232,55394410111,55394410113,55394410131,55394411020,55394411021,55394411030,55394411031,55394411120,55394411121,55394411130,55394411131,55394500201,55394500203,55394500221,55394500223,55394502131,55394503020,55394503021,55394503210,55394503211,55394503300,55394503301,55394503303,55394503321,55394521130,55394521131,55394521133,55394530311,55394530313,55394600010,55394600012,55394600030,55394600032,55394600210,55394600212,55394600213,55394600230,55394600231,55394600232,55394602010,55394602012,55394602030,55394602032,55394602033,55394602302,55394602303,55394602313,55394603202,55394603203,55394603212,55394603322,55394603323,55394603332,55394622121,55394622130,55394622131,55394622133,55394622311,55394623220,55394623221,55394623223,55394623230,55394623231,55394623232,55394623320,55394623321,55394623330,55394623331,55394630022,55394630200,55394630202,55394630232,55394632010,55394632012,55394632030,55394632032,55394632220,55394632221,55394632230,55394632231,55395601001,55395601010,
030,00,/ĸ,503043750,132018750,505082812,133340625,3,14,33,81,214,380,553927,554011,554021,5539161,5539162,5539163,5539170,5539172,5539261,5539263,5539361,5539370,5540013,5540103,5540200,5540201,5540203,55390722,55390723,55391602,55391603,55391712,55391730,55391732,55391733,55392601,55392603,55393601,55393603,55393621,55393623,55393630,55393631,55393710,55393712,55393720,55393721,55400112,55400122,55400123,55400220,55401011,55401013,55401021,55401022,55401023,55402020,55402021,55402023,55403110,553906322,553906323,553906331,553906332,553906333,553907320,553907322,553915313,553916011,553916012,553916013,553917100,553917102,553917103,553917312,553917313,553926001,553926210,553926211,553926213,553926231,553926232,553926233,553936003,553936021,553936023,553936201,553936203,553936221,553936223,553936320,553936321,553936322,553936330,553936331,553937110,553937300,553946001,553946003,553946010,553946011,553946012,553946021,553946030,554000331,554000332,554000333,554001033,554001130,554001132,554001133,554001211,554001213,554002022,554002220,554002221,554002222,554010032,554010033,554010121,554010122,554010123,554010201,554010202,554010203,554012002,554012022,554012200,554012202,554012220,554012222,554020220,554030011,554031001,554031003,554031010,554031011,554031013,554031110,554031111,554031112,5539062333,5539063203,5539063212,5539063213,5539063301,5539063302,5539063303,5539072023,5539072032,5539072033,5539072121,5539072122,5539072123,5539072132,5539072133,5539073210,5539073212,5539073230,5539073232,5539151311,5539151313,5539151331,5539151333,5539153111,5539153113,5539153311,5539153313,5539153331,5539160013,5539160031,5539160032,5539160033,5539160101,5539160102,5539160103,5539171010,5539171012,5539171013,5539171122,5539171300,5539171302,5539171320,5539171322,5539173100,5539173102,5539173103,5539260001,5539260031,5539262120,5539262121,5539262123,5539262301,5539262302,5539262303,5539360013,5539360201,5539360203,5539360220,5539360221,5539360223,5539362001,5539362003,5539362021,5539362023,5539362201,5539362203,5539362221,5539363230,5539363231,5539363331,5539371110,5539371111,5539371112,5539371120,5539371122,5539371300,5539371302,5539372200,5539372201,5539372202,5539372210,5539372211,5539372212,5539372220,5539372300,5539373010,5539373012,5539373020,5539460130,5539460131,5539460132,5539460310,5539460312,5540003302,5540003303,5540010133,5540010311,5540010312,5540010313,5540011022,5540011023,5540011032,5540011033,5540011120,5540011122,5540011312,5540011313,5540012022,5540012023,5540012032,5540012033,5540012103,5540012121,5540012122,5540012123,5540020230,5540020232,5540020233,5540020322,5540022100,5540022101,5540022102,5540022120,5540022122,5540022230,5540022300,5540100231,5540100232,5540100233,5540100302,5540100303,5540100312,5540100313,5540101011,5540101033,5540101202,5540101203,5540102001,5540102002,5540102003,5540120000,5540120001,5540120002,5540120200,5540120202,5540120230,5540120232,5540122010,5540122012,5540122030,5540122032,5540122210,5540122212,5540122230,5540202210,5540202211,5540202213,5540202220,5540202222,5540220000,5540220002,5540220020,5540220022,5540220200,5540220202,5540220220,5540220222,5540222000,5540222002,5540222020,5540222022,5540222200,5540222202,5540222222,5540300100,5540300101,5540300103,5540300121,5540300130,5540301000,5540301001,5540301002,5540301010,5540301011,5540301020,5540301100,5540301101,5540301103,5540301110,5540301111,5540301112,5540301121,5540301123,5540301130,5540310001,5540310003,5540310021,5540310120,5540310121,5540310123,5540310301,5540310310,5540310311,5540311130,5540311131,5540311132,5540311200,5540311201,5540311210,5540311211,5540311300,5540320000,5540320002,5540320020,55390623233,55390623313,55390623322,55390623323,55390631232,55390632023,55390632103,55390632112,55390632113,55390633001,55390633002,55390633003,55390720221,55390720222,55390720223,55390720312,55390720313,55390721202,55390721203,55390721302,55390721303,55390721311,55390721312,55390721313,55390730232,55390732110,55390732112,55390732130,55390732132,55390732310,55391511332,55391511333,55391531103,55391531121,55391531123,55391533101,55391533103,55391533121,55391533123,55391533301,55391533302,55391533303,55391533330,55391533331,55391600222,55391600223,55391600231,55391600232,55391600233,55391600301,55391600302,55391600303,55391601002,55391601003,55391710110,55391710112,55391710113,55391711022,55391711200,55391711202,55391711230,55391711232,55391713232,55391731010,55391731012,55391731122,55392600000,55392600001,55392600030,55392600031,55392600301,55392600331,55392620113,55392620131,55392620133,55392620311,55392620313,55392621220,55392621221,55392621223,55392622131,55392622133,55392622311,55392622313,55392622331,55392622333,55392623001,55392623003,55393513311,55393600111,55393600113,55393600123,55393600213,55393600223,55393600231,55393600232,55393600233,55393602001,55393602003,55393602021,55393602023,55393602220,55393602221,55393602223,55393620001,55393620003,55393620021,55393620023,55393620201,55393620203,55393620221,55393620223,55393622001,55393622003,55393622021,55393622023,55393622231,55393622233,55393632320,55393632321,55393632322,55393633200,55393633201,55393633210,55393633211,55393633300,55393633301,55393633303,55393711130,55393711131,55393711133,55393711210,55393711211,55393711212,55393711230,55393711232,55393713010,55393713012,55393713030,55393713032,55393713200,55393713201,55393713202,55393713220,55393722030,55393722031,55393722032,55393722130,55393722131,55393722132,55393723010,55393723011,55393723020,55393723100,55393723101,55393730110,55393730210,55393730211,55393730220,55393730300,55394600011,55394600013,55394600031,55394600033,55394600211,55394600233,55394601330,55394601331,55394601332,55394602011,55394602013,55394602031,55394602300,55394602301,55394602310,55394602311,55394602312,55394603200,55394603201,55394603210,55394603211,55394603213,55394603300,55394603302,55394603320,55394610000,55394610002,55394610020,55394610022,55394610200,55400031323,55400031332,55400031333,55400032313,55400032331,55400032333,55400033003,55400033012,55400033013,55400101321,55400101323,55400103031,55400103033,55400103101,55400103102,55400103103,55400103211,55400103213,55400103231,55400103233,55400110313,55400111021,55400111022,55400111023,55400111030,55400111032,55400120201,55400120203,55400120212,55400121011,55400121013,55400121023,55400121201,55400121202,55400121203,55400202020,55400202022,55400202023,55400202032,55400202033,55400202122,55400202310,55400202312,55400203232,55400203233,55400203322,55400221030,55400221031,55400221032,55400221100,55400221210,55400221212,55400221230,55400221232,55400222310,55400222320,55400222321,55400222322,55400223010,55400223020,55400223022,55401002113,55401002131,55401002133,55401002231,55401002233,55401002302,55401002303,55401003002,55401003003,55401003012,55401003013,55401003102,55401003103,55401003112,55401003113,55401010131,55401010133,55401010311,55401010313,55401010323,55401012002,55401012003,55401012011,55401012012,55401012013,55401020003,55401200030,55401200032,55401200100,55401200302,55401200320,55401202010,55401202012,55401202030,55401202032,55401202033,55401222320,55401222321,55401222322,55402022120,55402022121,55402022123,55402022210,55402022211,55402022212,55402022230,55402022232,55402022311,55402200010,55402200011,55402200012,55402200030,55402200032,55402200100,55402200210,55402200212,55402200232,55402202010,55402202012,55402202030,55402202032,55402202210,55402202212,55402202230,55402202232,55402220010,55402220012,55402220030,55402220032,55402220210,55402220212,55402220230,55402220232,55402222200,55402222202,55402222203,55403000000,55403000001,55403000002,55403000010,55403000022,55403001021,55403001311,55403001313,55403010030,55403010032,55403010121,55403010130,55403010131,55403011020,55403011021,55403011130,55403011320,55403011321,55403011322,55403013010,55403013011,55403100000,55403100001,55403100230,55403100231,55403101220,55403101221,55403101223,55403103001,55403103003,55403103030,55403103031,55403103120,55403103121,55403103130,55403103131,55403103133,55403111330,55403111332,55403112020,55403112022,55403112031,55403112120,55403112121,55403112130,55403112131,55403113010,55403113011,55403113020,55403113100,55403200030,55403200032,55403200210,
031,00,,503282812,132853125,504900000,133734375,2,6,23,49,121,227,553947,554040,5539570,5539571,5540302,5540303,5540312,5540410,55393731,55393732,55393733,55394611,55394612,55394613,55394631,55394633,55395611,55395613,55403002,55403003,55403012,55403102,55403130,55403132,55404120,55404121,55405000,55405001,55405002,55405010,55405011,553937113,553937131,553937133,553937223,553937232,553937233,553946101,553946103,553946301,553946303,553946321,553957200,553957201,553957210,553957211,553957300,553957301,553957302,553957310,553957311,554030001,554030002,554030003,554030103,554030131,554030132,554030133,554031032,554031033,554031122,554031123,554031132,554031310,554031312,554031330,554031332,554041100,554041101,554041110,554041220,554041221,554041222,554050030,554050031,554050032,554050120,554050121,554050200,554051000,5539363233,5539363322,5539363323,5539363332,5539363333,5539371321,5539371323,5539372221,5539372222,5539372223,5539372303,5539372311,5539372312,5539372313,5539373013,5539373023,5539373031,5539373032,5539373033,5539460311,5539460313,5539460331,5539461001,5539461003,5539461021,5539461022,5539461023,5539463000,5539463001,5539463003,5539463021,5539463230,5539463231,5539463233,5539561011,5539561012,5539561013,5539561030,5539561031,5539561033,5539561211,5539561212,5539561213,5539561231,5539561233,5539563101,5539563110,5539563111,5539563113,5539572020,5539572021,5539572030,5539572031,5539572033,5539572120,5539572121,5539572130,5539572131,5539572133,5539573030,5539573031,5539573032,5539573120,5539573121,5540202230,5540202232,5540202233,5540300003,5540300120,5540300122,5540300123,5540300132,5540300133,5540301021,5540301022,5540301023,5540301120,5540301122,5540301131,5540301133,5540301300,5540301302,5540301303,5540310002,5540310020,5540310022,5540310302,5540311303,5540311332,5540313110,5540313112,5540313130,5540313132,5540313310,5540411020,5540411021,5540411022,5540411030,5540411110,5540411112,5540411130,5540411200,5540411202,5540411220,5540411222,5540412230,5540412231,5540412232,5540412300,5540412301,5540413000,5540500330,5540500332,5540501300,5540501301,5540502010,5540502011,5540502100,5540502101,5540510010,5540510020,55393632323,55393633202,55393633203,55393633212,55393633213,55393633302,55393711132,55393711213,55393711231,55393711233,55393713011,55393713013,55393713031,55393713033,55393713203,55393713221,55393713222,55393713223,55393722033,55393722133,55393723012,55393723013,55393723021,55393723022,55393723023,55393723102,55393723103,55393730111,55393730112,55393730113,55393730212,55393730213,55393730221,55393730222,55393730223,55393730301,55393730302,55393730303,55394601333,55394603301,55394603303,55394603321,55394603330,55394603331,55394603333,55394610001,55394610003,55394610021,55394610023,55394610201,55394610202,55394610203,55394630020,55394630021,55394630023,55394630201,55394630203,55394630230,55394630231,55394630233,55394632011,55394632013,55394632031,55394632033,55394632320,55394632321,55394632323,55395610031,55395610033,55395610101,55395610103,55395610211,55395610213,55395610321,55395610323,55395612031,55395612033,55395612101,55395612103,55395612211,55395612300,55395612301,55395631001,55395631003,55395631311,55395631313,55395720321,55395720323,55395721321,55395721323,55395730330,55395730332,55395732011,55395732100,55402022122,55402022213,55402022231,55402022233,55402022310,55402022312,55402022313,55403000003,55403000011,55403000012,55403000013,55403000020,55403000021,55403000023,55403001020,55403001022,55403001023,55403001310,55403001312,55403010031,55403010033,55403010120,55403010122,55403010123,55403010132,55403010133,55403011022,55403011023,55403011131,55403011132,55403011133,55403011323,55403013012,55403013013,55403100002,55403100003,55403100232,55403100233,55403101222,55403103000,55403103002,55403103032,55403103033,55403103122,55403103123,55403103132,55403112021,55403112023,55403112030,55403112032,55403112033,55403112122,55403112123,55403112132,55403112133,55403113012,55403113013,55403113021,55403113022,55403113023,55403113102,55403113120,55403113122,55403113300,55403113302,55403113330,55403113332,55403131110,55403131111,55403131112,55403131130,55403131132,55403131310,55403131312,55403131330,55403131332,55403133110,55403133112,55403133113,55403133120,55403133122,55403133300,55403133302,55403133320,55403133322,55404110230,55404110232,55404111110,55404111112,55404111130,55404111132,55404111211,55404111213,55404111310,55404111312,55404112010,55404112012,55404112230,55404112232,55404122330,55404122331,55404123020,55404123021,55404123022,55404123030,55404123200,55404130010,55404130020,55404130021,55405003310,55405003311,55405003312,55405003330,55405012200,55405012201,55405012210,55405012211,55405012300,55405012301,55405012310,55405012311,55405013020,55405013021,55405013022,55405013030,55405013031,55405013100,55405013101,55405013200,55405100120,55405100122,55405100210,55405100212,
032,00,,500906250,132140625,502045312,133884375,0,13,36,69,169,380,5539111,5539113,5539122,5539213,5539220,5539222,5539320,5539321,5539323,5539332,5539421,5539423,5539520,55390132,55391121,55391200,55391202,55391203,55391212,55391230,55391231,55391232,55392111,55392112,55392113,55392210,55392212,55392230,55392232,55392233,55393110,55393111,55393220,55393221,55393223,55393302,55394200,55394201,55394203,55394221,55394222,55394223,55394300,55394302,55394320,55395210,55395211,55395220,55395221,553901232,553901233,553901303,553901332,553901333,553902222,553902223,553911010,553911011,553911013,553911031,553911032,553911033,553911230,553911231,553911233,553912010,553912012,553912013,553912102,553912132,553912330,553912331,553912332,553913220,553921032,553921033,553921101,553921103,553921211,553921213,553921231,553922312,553923222,553931013,553931031,553931033,553931120,553931121,553931122,553931130,553931131,553931132,553932221,553932223,553933000,553933002,553933003,553933012,553933030,553933032,553933033,553942020,553942021,553942023,553942201,553942203,553943010,553943011,553943012,553952120,553952121,553952122,553952220,553952221,553952222,553952300,553952302,553952320,5539012302,5539012311,5539012313,5539013003,5539013010,5539013012,5539013013,5539013021,5539013023,5539013122,5539013300,5539013302,5539013303,5539022322,5539110120,5539110121,5539110123,5539110233,5539110301,5539110302,5539110303,5539112011,5539112012,5539112013,5539112031,5539112321,5539120112,5539120113,5539121032,5539121300,5539121302,5539121303,5539121330,5539121332,5539121333,5539123330,5539123331,5539123332,5539132022,5539132023,5539132220,5539132221,5539132230,5539210302,5539210303,5539210311,5539210312,5539210313,5539211001,5539211003,5539211021,5539211023,5539212101,5539212103,5539212331,5539212333,5539221100,5539221101,5539221102,5539221300,5539221302,5539221320,5539221322,5539223100,5539223102,5539223103,5539223112,5539223130,5539223132,5539232202,5539232203,5539310111,5539310112,5539310113,5539310121,5539310123,5539310301,5539310303,5539310321,5539311230,5539311231,5539311232,5539311330,5539312111,5539322201,5539322203,5539322221,5539322222,5539322223,5539330010,5539330012,5539330130,5539330132,5539330310,5539330312,5539330313,5539331220,5539331222,5539331223,5539333000,5539333001,5539333002,5539333020,5539333220,5539333222,5539411131,5539413333,5539420221,5539420223,5539422001,5539422003,5539422021,5539422023,5539430130,5539430131,5539430132,5539430300,5539430301,5539430302,5539430310,5539430320,5539430322,5539431000,5539431002,5539432100,5539432102,5539432120,5539432122,5539432200,5539432201,5539432202,5539432210,5539432220,5539432222,5539511111,5539511113,5539511131,5539511133,5539511310,5539511311,5539511313,5539511331,5539511333,5539513111,5539521230,5539521232,5539521300,5539522230,5539522300,5539522301,5539522310,5539522311,5539522313,5539523010,5539523012,5539523030,5539523230,5539530000,5539530002,5539530020,5539530022,5539611111,5539611113,5539611131,5539620000,5539620001,5539620002,5539620020,5539620022,55390112322,55390112323,55390112332,55390121333,55390122133,55390122311,55390122313,55390122331,55390122333,55390123030,55390123032,55390123033,55390123121,55390123122,55390123123,55390130012,55390130013,55390130110,55390130112,55390130221,55390130222,55390130223,55390131022,55390131200,55390131202,55390131203,55390131230,55390131232,55390133010,55390133012,55390133013,55390133102,55390133120,55390133122,55390133123,55390133132,55390133133,55390222022,55390222032,55390222122,55390222123,55390222132,55390223200,55390223202,55390223203,55390223230,55390223232,55391100111,55391101220,55391101221,55391101223,55391102131,55391102133,55391102303,55391102311,55391102312,55391102313,55391102321,55391102323,55391103001,55391103002,55391103003,55391120101,55391120102,55391120103,55391120301,55391120303,55391120331,55391120333,55391123201,55391123231,55391201102,55391201103,55391210022,55391210023,55391210302,55391210303,55391210330,55391210332,55391213010,55391213012,55391213013,55391213102,55391213120,55391213122,55391213312,55391213313,55391233330,55391233331,55391233332,55391320200,55391320202,55391320203,55391320212,55391320213,55391322102,55391322120,55391322122,55391322123,55391322132,55391322220,55391322221,55391322230,55391322310,55391322312,55392101101,55392101110,55392101111,55392101333,55392102113,55392102131,55392102133,55392102311,55392102313,55392102331,55392102333,55392103002,55392103003,55392103012,55392103013,55392103101,55392103102,55392103103,55392110000,55392110001,55392110222,55392110223,55392121000,55392121001,55392121003,55392123301,55392123303,55392123321,55392123323,55392211030,55392211031,55392211032,55392211100,55392211101,55392211102,55392211110,55392211120,55392211200,55392211201,55392211202,55392211220,55392211222,55392213012,55392213030,55392213032,55392213210,55392213212,55392213213,55392213230,55392213232,55392231010,55392231012,55392231013,55392231102,55392231103,55392231112,55392231130,55392231132,55392231310,55392231312,55392231330,55392231332,55392231333,55392322000,55392322002,55392322003,55392322012,55392322120,55392322122,55392322300,55392322302,55392322320,55392322322,55393101101,55393101103,55393103231,55393112330,55393112331,55393112333,55393113310,55393113311,55393113313,55393113320,55393113322,55393113331,55393113333,55393121101,55393130000,55393130010,55393130111,55393131000,55393131001,55393131010,55393131011,55393131100,55393131111,55393131113,55393131131,55393131133,55393131311,55393131331,55393131333,55393133111,55393222000,55393222001,55393222003,55393222021,55393222023,55393222201,55393222202,55393222203,55393300112,55393300130,55393300132,55393300133,55393301022,55393301033,55393301122,55393301123,55393301312,55393301330,55393301332,55393303110,55393303112,55393303113,55393312020,55393312022,55393312023,55393312210,55393312212,55393312213,55393312320,55393312322,55393330030,55393330031,55393330032,55393330100,55393330102,55393330120,55393330210,55393332022,55393332023,55394111111,55394111113,55394111131,55394111133,55394111331,55394111333,55394113111,55394113113,55394113131,55394113133,55394131333,55394133111,55394133113,55394133131,55394133133,55394133311,55394133313,55394133323,55394202200,55394202201,55394202203,55394202221,55394202223,55394220201,55394220203,55394220221,55394220222,55394220223,55394301330,55394301332,55394303030,55394303031,55394303032,55394303110,55394303112,55394303210,55394303212,55394303230,55394303232,55394321010,55394321011,55394321012,55394321030,55394321032,55394321210,55394321212,55394321230,55394321232,55394322030,55394322031,55394322032,55394322120,55394322210,55395111101,55395111103,55395111121,55395111123,55395111301,55395111303,55395111321,55395111322,55395111323,55395113120,55395113121,55395113123,55395113301,55395113303,55395113321,55395113323,55395131130,55395131131,55395131133,55395131311,55395131313,55395131331,55395131333,55395133111,55395133331,55395133332,55395133333,55395212310,55395212311,55395213010,55395213011,55395213012,55395213020,55395213021,55395213030,55395213100,55395213101,55395213110,55395213111,55395222310,55395222311,55395222312,55395222320,55395222321,55395222322,55395222330,55395223020,55395223021,55395223030,55395223031,55395223120,55395223121,55395223123,55395223301,55395223310,55395223311,55395230320,55395230322,55395232100,55395232102,55395232120,55395232122,55395232200,55395232201,55395232210,55395232211,55395232213,55395232231,55395232320,55395232321,55395232330,55395232331,55395300232,55395302000,55395302002,55395302020,55396111303,55396111331,55396202000,55396202001,
033,00,/,500400000,130453125,502129687,131868750,4,10,27,77,175,375,543941,543951,543952,543962,5439312,5439313,5439403,5439422,5439501,5439503,5439601,5439610,5439611,5439632,54393033,54393103,54393111,54393112,54393113,54394011,54394012,54394013,54394021,54394023,54394230,54394232,54395023,54395320,54395322,54396001,54396003,54396030,54396031,54396032,54396120,54396130,54396131,54396300,54396302,54397210,54397211,543922222,543930133,543930311,543930312,543930313,543931021,543931022,543931023,543931102,543931103,543940031,543940033,543940101,543940103,543940223,543942132,543942310,543942312,543942330,543942332,543942333,543950010,543950011,543950013,543950031,543950033,543950211,543950212,543950213,543950223,543953002,543953020,543953022,543953023,543953212,543953230,543960210,543960211,543960213,543960330,543960331,543961210,543961211,543961212,543961220,543961221,543961330,543961331,543963012,543963030,543963032,543963302,543963320,543963322,543963323,543972011,543972120,543972121,543973000,543973001,543973002,543973010,543973011,543973100,543973101,543942000,543942002,543932220,543932222,543932202,543932020,543932022,543942020,543942022,543942023,543932000,543932002,5439213331,5439213332,5439213333,5439222230,5439222232,5439222233,5439301313,5439301321,5439301323,5439303033,5439303101,5439303102,5439303103,5439303231,5439303232,5439303233,5439310133,5439310201,5439310203,5439311003,5439311011,5439311012,5439311013,5439400132,5439400133,5439400233,5439400303,5439400321,5439400322,5439400323,5439401021,5439401022,5439401023,5439402031,5439402033,5439402203,5439402212,5439402213,5439402221,5439402223,5439421213,5439421312,5439421330,5439423132,5439423310,5439423312,5439423313,5439500000,5439500001,5439500003,5439500010,5439500011,5439500012,5439500021,5439500121,5439500123,5439500301,5439500303,5439500321,5439500323,5439502033,5439502101,5439502102,5439502103,5439502211,5439502213,5439530000,5439530002,5439530003,5439530210,5439530212,5439530213,5439532100,5439532102,5439532103,5439532112,5439532130,5439532320,5439532322,5439600011,5439600013,5439600031,5439600033,5439600211,5439600213,5439602121,5439602123,5439602301,5439602310,5439602311,5439602313,5439602331,5439602333,5439603320,5439603321,5439603330,5439603331,5439612130,5439612131,5439612132,5439612221,5439612230,5439612231,5439612300,5439612302,5439613201,5439613210,5439613211,5439613213,5439613330,5439613331,5439613333,5439630100,5439630102,5439630103,5439630132,5439630310,5439630312,5439630330,5439630332,5439633030,5439633032,5439633210,5439633212,5439633213,5439633320,5439633322,5439720000,5439720001,5439720010,5439720011,5439720100,5439720101,5439720131,5439720133,5439720311,5439720313,5439721220,5439721221,5439721223,5439721230,5439721231,5439721300,5439721301,5439730120,5439730121,5439731021,5439731030,5439731031,5439420332,5439420333,5439420030,5439420032,5439322210,5439322212,5439322032,5439420322,5439420323,5439420210,5439420212,5439320030,5439320032,5439320010,5439320011,5439320012,5439322000,5439322002,5439320210,5439320212,5439421301,5439421302,5439421303,5439421231,5439421232,5439421233,54392133231,54392133232,54392133233,54392133301,54392133302,54392133303,54392222032,54392222033,54392222122,54392222123,54392222313,54393013032,54393013033,54393013121,54393013122,54393013123,54393013201,54393013202,54393013203,54393013220,54393013221,54393013223,54393030311,54393030313,54393031001,54393031003,54393032111,54393032113,54393032131,54393032133,54393032233,54393032301,54393032302,54393032303,54393101232,54393101233,54393101311,54393101312,54393101313,54393101321,54393101322,54393101323,54393102020,54393102022,54393102023,54393110023,54394001213,54394001231,54394001233,54394001302,54394001303,54394001312,54394001313,54394003011,54394003013,54394003201,54394003203,54394010011,54394010013,54394010031,54394010032,54394010033,54394010202,54394010203,54394020110,54394020111,54394020113,54394020131,54394020133,54394020301,54394020303,54394020321,54394022012,54394022013,54394022102,54394022103,54394022111,54394022113,54394022203,54394022221,54394022222,54394022223,54394212113,54394213112,54394213130,54394213320,54394213321,54394213322,54394231100,54394231102,54394231120,54394231122,54394231300,54394231302,54394233110,54394233112,54394233113,54394322220,54394322222,54395000020,54395000021,54395000023,54395000131,54395000133,54395000201,54395000203,54395000221,54395000230,54395000231,54395000300,54395000301,54395000302,54395000311,54395001200,54395001201,54395001203,54395001221,54395020133,54395020311,54395020313,54395021001,54395021003,54395022101,54395022103,54395022121,54395022122,54395022123,54395300012,54395300120,54395300122,54395300300,54395300302,54395300320,54395300322,54395300323,54395300332,54395302110,54395302112,54395303022,54395303200,54395303201,54395303202,54395321012,54395321013,54395321101,54395321102,54395321103,54395321112,54395321130,54395321320,54395321321,54395321322,54395323100,54395323102,54395323210,54395323212,54395323230,54395323232,54396000101,54396000103,54396000121,54396000123,54396000301,54396000303,54396000321,54396000323,54396002101,54396002103,54396002121,54396002311,54396002313,54396002331,54396002333,54396020111,54396020113,54396021200,54396021201,54396023121,54396023123,54396023301,54396023303,54396023321,54396023323,54396033220,54396033221,54396033230,54396033231,54396033320,54396033321,54396121330,54396121331,54396121332,54396122200,54396122201,54396122203,54396123010,54396123011,54396123012,54396123030,54396123032,54396123100,54396123200,54396123201,54396132000,54396132001,54396132003,54396132030,54396132031,54396132120,54396132121,54396132123,54396132311,54396133200,54396133201,54396133210,54396133211,54396133213,54396133320,54396133321,54396133323,54396301010,54396301012,54396301013,54396301122,54396301300,54396301302,54396301303,54396301330,54396301332,54396303110,54396303112,54396303113,54396303130,54396303132,54396303310,54396303312,54396303330,54396303332,54396312002,54396330022,54396330033,54396330122,54396330330,54396330332,54396332110,54396332112,54396332113,54396333000,54396333002,54396333020,54396333022,54396333212,54396333230,54397001101,54397001110,54397001111,54397010000,54397010001,54397010010,54397010011,54397010100,54397010101,54397111101,54397111110,54397111111,54397111113,54397200030,54397200031,54397200120,54397200121,54397200130,54397200131,54397201020,54397201030,54397201031,54397201033,54397201301,54397201303,54397201321,54397201323,54397203101,54397203103,54397203311,54397212220,54397212221,54397212223,54397212320,54397212321,54397212322,54397212330,54397213020,54397213021,54397213022,54397213100,54397213101,54397213110,54397213111,54397213200,54397230010,54397230011,54397230013,54397300300,54397300301,54397300302,54397300310,54397300311,54397300320,54397301300,54397301301,54397301302,54397301310,54397301311,54397302000,54397302001,54397302010,54397310200,54397310201,54397310231,54397310330,54397311000,54397311002,54397311020,54397311022,54397311200,54394212222,54394212223,54394203302,54394203303,54394203200,54394203202,54394203203,54394203212,54394203213,54394202130,54394202132,54394202112,54394200120,54394200122,54393222320,54393222322,54393222300,54393222302,54394200100,54394200102,54393200330,54393200332,54393200310,54393200312,54393200130,54393200132,54393220010,54393220012,54393202320,54393202300,54393202301,54393202302,54393202130,54393202131,54393202132,54393220300,54393220302,54393220030,54393220032,54393220033,54394213002,54394213003,54394212301,54394212302,54394212303,54394212231,54394212232,54394212233,54393202110,54393202112,54393202113,
034,00,/,501342187,130256250,502790625,130940625,0,5,15,49,86,218,5439233,5439242,5439243,5439323,5439321,54392313,54392323,54392402,54393300,54393301,54393302,54393320,54393322,54394210,54394201,54393223,54393221,54393203,54393201,54394211,543923121,543923122,543923123,543923211,543923212,543923213,543923221,543923222,543923223,543924030,543924032,543924033,543924122,543924133,543925022,543925023,543925200,543925201,543925202,543925220,543933030,543933031,543933032,543933100,543933101,543933102,543933110,543933111,543933120,543933210,543934000,543934001,543934003,543934010,543934011,543934100,543934101,543934110,543934111,543943000,543922322,543922323,543922233,543922232,543922320,543942120,543942031,543942030,543932201,5439223333,5439230333,5439231201,5439231203,5439232031,5439232032,5439232033,5439232103,5439232201,5439232203,5439240312,5439241232,5439241311,5439241312,5439241313,5439241321,5439241322,5439241323,5439250022,5439250200,5439250202,5439250203,5439250212,5439250213,5439252030,5439252031,5439252032,5439252100,5439252220,5439252222,5439330330,5439330331,5439330332,5439331030,5439331031,5439331120,5439331121,5439331130,5439331131,5439331212,5439331220,5439332110,5439332120,5439332121,5439332122,5439332300,5439332302,5439332320,5439340020,5439340021,5439340023,5439340120,5439340121,5439340122,5439340130,5439341131,5439350000,5439350002,5439350020,5439430010,5439430020,5439430021,5439223212,5439223210,5439222311,5439222313,5439223322,5439223023,5439421210,5439421212,5439421221,5439421220,5439420331,5439420033,5439420031,5439420013,5439420011,5439322233,5439322231,5439322213,5439322211,5439322033,5439322031,5439320233,5439320231,5439421310,54392233233,54392233303,54392233311,54392233312,54392233313,54392233321,54392233322,54392233323,54392303233,54392303311,54392303312,54392303313,54392303321,54392303322,54392303323,54392310322,54392310323,54392310332,54392310333,54392311222,54392311223,54392311232,54392311233,54392311322,54392311323,54392311332,54392311333,54392312021,54392312022,54392312023,54392320233,54392320303,54392321011,54392321012,54392321013,54392321022,54392321023,54392322021,54392322022,54392322023,54392400222,54392400233,54392400322,54392400323,54392400332,54392400333,54392401222,54392401223,54392401232,54392403102,54392403103,54392403130,54392403132,54392403133,54392411323,54392411331,54392411332,54392411333,54392412022,54392412023,54392412032,54392412300,54392412302,54392412303,54392412330,54392412332,54392412333,54392413033,54392413101,54392413102,54392413103,54392413203,54392502010,54392502012,54392502013,54392502102,54392502103,54392502112,54392502113,54392503002,54392503020,54392503022,54392503200,54392503221,54392503222,54392503223,54392520330,54392520331,54392520332,54392521020,54392521021,54392521022,54392521200,54392521202,54392522110,54392522210,54392522212,54393303330,54393310320,54393310321,54393310322,54393310330,54393311321,54393311330,54393311331,54393312100,54393312102,54393312210,54393312211,54393312221,54393312300,54393312301,54393321120,54393321122,54393323212,54393323213,54393323220,54393323221,54393323222,54393323230,54393323231,54393323302,54393400220,54393400221,54393401230,54393401231,54393401310,54393401312,54393401320,54393401321,54393402101,54393402110,54393402111,54393402113,54393403000,54393403001,54393410310,54393410311,54393411200,54393411201,54393411210,54393411211,54393411300,54393411301,54393411331,54394212110,54394212112,54394213111,54394300110,54394300111,54394300112,54394300120,54394300121,54394300122,54394300220,54394300221,54394300222,54394300230,54392233232,54392233230,54392233203,54392233202,54392233200,54392233022,54392232133,54392232132,54392230323,54392223033,54392223122,54392223123,54392221333,54392230222,54392230223,54392230322,54392230320,54394212221,54394212220,54394203301,54394203201,54394203210,54394203211,54394203300,54394202133,54394202113,54394202131,54394202111,54394200123,54394200121,54393222323,54393222321,54393222303,54393222301,54394200101,54394200103,54393200333,54393200331,54393200313,54393200311,54393200133,54393220013,54393220011,54393202323,54393202322,54393202321,54393202303,54393202133,54393200131,54393220301,54393220303,54393220031,54394213110,54394212111,54394213000,54394213001,54394212300,54394212230,54394202110,54393202111,
035,00,,498881250,129525000,500878125,131100000,5,18,37,84,180,374,543816,543826,543827,543836,543837,5438053,5438062,5438151,5438152,5438153,5438172,5438173,5438251,5438252,5438253,5438351,5438353,5438451,5438460,5439200,5439202,5439300,5439302,54380503,54380510,54380512,54380513,54380521,54380523,54380632,54381501,54381503,54381700,54381702,54381703,54382501,54382503,54383500,54383501,54383503,54383521,54383523,54384501,54384503,54384521,54384530,54384531,54384610,54384611,54384620,54384700,54384710,54384711,54391020,54391022,54391023,54392032,54393010,54393012,54394000,533875322,533875323,533875332,543805012,543805013,543805021,543805023,543805110,543805112,543805113,543805221,543805223,543806022,543806023,543806032,543806033,543806122,543806300,543806302,543806303,543806330,543806332,543806333,543814312,543814313,543814330,543814331,543814333,543815001,543815023,543817011,543817012,543817013,543817102,543817120,543817122,543824333,543825001,543825003,543825020,543825021,543825023,543834111,543834113,543834131,543835020,543835021,543835023,543845230,543845231,543845320,543845321,543845330,543845331,543846120,543846121,543846122,543846130,543846131,543846210,543847010,543847011,543847013,543847020,543847130,543847131,543847132,543910210,543910212,543920122,543920300,543920302,543920303,543920332,543930110,543930112,543930300,543930301,543930302,543930320,543940010,543940011,543940020,543940021,5338753202,5338753203,5338753211,5338753212,5338753213,5338753332,5438050033,5438050103,5438050111,5438050112,5438050113,5438050201,5438050203,5438050221,5438051110,5438051112,5438051113,5438052011,5438052013,5438052031,5438052033,5438052221,5438052223,5438060200,5438060202,5438060303,5438060312,5438060313,5438061230,5438061232,5438063010,5438063012,5438063013,5438063120,5438063122,5438063310,5438063312,5438072222,5438072223,5438143103,5438143112,5438143113,5438143231,5438143232,5438143233,5438143320,5438143321,5438143322,5438150001,5438150003,5438150031,5438150033,5438150211,5438150212,5438150213,5438170100,5438170102,5438170103,5438171002,5438171032,5438171210,5438171212,5438171230,5438171232,5438171233,5438171303,5438171312,5438171321,5438171322,5438171323,5438171330,5438171332,5438171333,5438241011,5438241013,5438243113,5438243131,5438243133,5438243311,5438243313,5438243323,5438250001,5438250003,5438250021,5438250023,5438250221,5438250223,5438341101,5438341103,5438341121,5438341123,5438341301,5438341331,5438350220,5438350221,5438350223,5438352011,5438352033,5438352211,5438450011,5438450013,5438450031,5438452011,5438452211,5438452213,5438452321,5438452330,5438452331,5438452333,5438453220,5438453221,5438453231,5438453320,5438453321,5438453330,5438461230,5438461231,5438461232,5438461320,5438461321,5438461323,5438461330,5438461331,5438461332,5438462110,5438462111,5438462112,5438462120,5438462200,5438462201,5438462202,5438470120,5438470121,5438470122,5438470210,5438470220,5438471210,5438471211,5438471213,5438471231,5438471330,5438471332,5439100222,5439103202,5439103220,5439201022,5439201200,5439201202,5439201232,5439203010,5439203012,5439203300,5439203302,5439301110,5439301112,5439301130,5439301132,5439301133,5439301300,5439301301,5439301302,5439301310,5439301311,5439303030,5439303032,5439303210,5439303212,5439303220,5439303221,5439303222,5439310200,5439400120,5439400122,5439400221,5439400230,5439400231,5439400300,5439400302,5439401000,5439401002,53387523311,53387523313,53387523331,53387523332,53387523333,53387532013,53387532101,53387532102,53387532103,53387533000,53387533020,53387533022,53387533023,53387533032,53387533302,54380500312,54380500313,54380500321,54380500322,54380500323,54380501023,54380502231,54380502233,54380511110,54380511112,54380511113,54380520011,54380520100,54380520101,54380520103,54380520121,54380520123,54380520301,54380520303,54380520321,54380520323,54380522033,54380522223,54380600020,54380600022,54380600200,54380600202,54380600220,54380600222,54380600223,54380600232,54380602010,54380602012,54380602030,54380602032,54380602033,54380603012,54380603013,54380603021,54380603022,54380603023,54380603102,54380603103,54380612020,54380612022,54380612023,54380612032,54380612332,54380630110,54380630112,54380630113,54380631002,54380631020,54380631022,54380631232,54380633130,54380633132,54380722200,54380722202,54380722203,54380722322,54380722323,54380722332,54380723323,54380723332,54380723333,54380732222,54381430333,54381431023,54381431102,54381431103,54381431111,54381431112,54381431113,54381432111,54381432113,54381432123,54381432131,54381432132,54381432133,54381432301,54381432303,54381433230,54381433231,54381433232,54381500001,54381500211,54381500300,54381500301,54381500303,54381500321,54381500323,54381502101,54381502103,54381502231,54381502233,54381701010,54381701012,54381701013,54381710000,54381710002,54381710003,54381710012,54381710030,54381710032,54381710033,54381710300,54381710302,54381710332,54381712110,54381712112,54381712132,54381712310,54381712312,54381713132,54381713201,54381713202,54381713203,54381713310,54381713312,54381713313,54382410100,54382410101,54382410103,54382410121,54382410123,54382411000,54382411022,54382411101,54382411110,54382411111,54382413111,54382413113,54382413131,54382413133,54382431111,54382431113,54382431123,54382431301,54382431303,54382431321,54382431323,54382433101,54382433103,54382433121,54382433122,54382433123,54382433211,54382433212,54382433213,54382500000,54382500001,54382500003,54382500201,54382500203,54382500221,54382500222,54382500223,54382502200,54382502201,54382502203,54383413030,54383413031,54383413301,54383413303,54383413331,54383502220,54383502221,54383520011,54383520101,54383520103,54383520130,54383520131,54383520133,54383520311,54383520313,54383522131,54383522133,54383522311,54383522313,54383522331,54383522332,54383522333,54384500330,54384500331,54384500333,54384502111,54384502113,54384502131,54384502133,54384502311,54384502313,54384502331,54384502332,54384502333,54384520131,54384520133,54384520311,54384520313,54384520331,54384520332,54384520333,54384522311,54384523200,54384523201,54384523321,54384532220,54384532222,54384532300,54384532301,54384532331,54384532333,54384533220,54384533221,54384533222,54384533230,54384533310,54384533311,54384612330,54384612331,54384612332,54384613220,54384613221,54384613330,54384613331,54384621130,54384621210,54384621211,54384621220,54384622030,54384622100,54384622101,54384622102,54384630000,54384630001,54384630002,54384630010,54384630011,54384701230,54384701231,54384701232,54384702110,54384702111,54384702112,54384702120,54384702121,54384702122,54384702210,54384702211,54384703000,54384703001,54384703111,54384712000,54384712001,54384712010,54384712121,54384712123,54384712301,54384712303,54384712330,54384712331,54384712333,54384713310,54384730111,54384731000,54384731001,54384731010,54384731011,54384731100,54391002232,54391002333,54391003222,54391003223,54391003232,54391003233,54391003322,54391021100,54391021102,54391021320,54391021322,54391021323,54391032000,54391032002,54391032220,54391032222,54392010000,54392010002,54392010020,54392010022,54392010200,54392010202,54392010203,54392012030,54392012032,54392012302,54392030110,54392030112,54392030130,54392030132,54392030133,54392031202,54392031220,54392031222,54392031223,54392033012,54392033030,54392033032,54392033320,54392033322,54392033323,54393011310,54393011312,54393011313,54393013030,54393013031,54393013120,54393013200,54393013222,54393030310,54393030312,54393031000,54393031002,54393032110,54393032112,54393032130,54393032132,54393032230,54393032231,54393032232,54393032300,54393100220,54393100222,54393100223,54393102021,54394001210,54394001211,54394001212,54394001230,54394001232,54394001300,54394001301,54394001310,54394001311,54394002201,54394002230,54394002231,54394002320,54394002321,54394002323,54394003010,54394003012,54394003200,54394003202,54394010010,54394010012,54394010030,54394010200,54394010201,54394020101,
036,00,˹/̾/,498220312,130865625,500582812,132346875,9,15,34,73,183,456,543854,543855,543856,543857,543864,543865,543866,543867,543875,5438472,5438531,5438533,5438631,5438633,5438740,5438741,5438743,5438760,5438761,5438762,5438770,5538050,5538051,5538060,54384623,54384631,54384632,54384633,54384732,54384733,54385303,54385321,54385323,54386301,54387310,54387311,54387313,54387420,54387421,54387423,54387630,54387631,54387710,54387712,54387720,54387721,54387730,54395002,54396022,55380401,55380410,55380411,55380413,55380521,55380530,55380531,55380533,55380620,543843332,543843333,543844223,543844230,543844232,543846213,543846222,543846223,543846301,543846302,543846303,543847023,543847032,543847033,543847122,543847300,543847302,543847303,543847312,543847313,543853012,543853013,543863031,543863033,543873310,543873311,543876320,543876321,543876322,543876330,543876331,543877110,543877111,543877112,543877130,543877132,543877220,543877221,543877230,543877231,543877310,543877311,543877312,543877320,543940200,543940202,543950200,543950202,543950220,543950222,543960000,543960002,543960020,543960022,543960200,543960202,543960203,543960232,553804031,553804120,553804121,553805200,553805201,553806100,553806102,553806120,553806122,553806210,553806212,553806220,553806221,553806222,553806230,5438433213,5438433231,5438433233,5438433302,5438433303,5438433310,5438433312,5438442212,5438442213,5438442221,5438442222,5438442223,5438442312,5438442330,5438442332,5438442333,5438452222,5438452223,5438452232,5438452233,5438452322,5438452323,5438453223,5438453232,5438453332,5438453333,5438462123,5438462211,5438462212,5438462213,5438463002,5438463003,5438470213,5438470222,5438470223,5438470301,5438470302,5438470303,5438470310,5438470312,5438470313,5438471202,5438471203,5438471232,5438471333,5438473010,5438473012,5438473013,5438473102,5438473103,5438473111,5438473112,5438473113,5438530112,5438530113,5438530231,5438530233,5438532031,5438532033,5438532211,5438532213,5438532231,5438630301,5438630303,5438630321,5438630323,5438632110,5438632111,5438632113,5438632131,5438632133,5438632311,5438632312,5438632313,5438632330,5438632331,5438632333,5438730111,5438730113,5438730131,5438731201,5438731210,5438731211,5438731213,5438731231,5438731233,5438733011,5438733013,5438733120,5438733121,5438733123,5438733130,5438733131,5438733132,5438742211,5438763230,5438763231,5438763320,5438763321,5438763323,5438763330,5438763331,5438763333,5438771130,5438771132,5438771310,5438771312,5438771330,5438771332,5438772220,5438772221,5438772331,5438773130,5438773132,5438773210,5438773211,5438773300,5439400222,5439402012,5439402200,5439402202,5439500032,5439500033,5439500300,5439500302,5439500320,5439500322,5439502010,5439502011,5439502012,5439502030,5439502032,5439600230,5439600232,5439602010,5439602012,5439602013,5439602122,5439602300,5439602302,5439602303,5538040011,5538040013,5538040031,5538040033,5538040211,5538040300,5538040301,5538040303,5538040321,5538040330,5538040331,5538041220,5538041221,5538041230,5538041231,5538043100,5538043111,5538052030,5538052031,5538053200,5538053201,5538053210,5538053211,5538062110,5538062111,5538062112,5538062130,5538062132,5538062230,5538062231,5538062232,5538062310,5538062320,5538062321,5538063000,5538151100,5538151101,5538151103,5538151110,5538151111,5538151112,5538160000,54384331323,54384331332,54384332103,54384332112,54384332113,54384332121,54384332123,54384332223,54384332232,54384332233,54384332301,54384332303,54384332321,54384332322,54384332323,54384333002,54384333003,54384333011,54384333012,54384333013,54384333110,54384333112,54384333130,54384333132,54384422033,54384422111,54384422112,54384422113,54384422202,54384422203,54384423102,54384423312,54384432222,54384432223,54384432232,54384432233,54384432322,54384432323,54384432332,54384432333,54384433222,54384433232,54384433233,54384433323,54384433331,54384433332,54384433333,54384522123,54384522301,54384522302,54384522303,54384522310,54384522312,54384522313,54384523202,54384523203,54384523320,54384523322,54384523323,54384532221,54384532223,54384532302,54384532303,54384532330,54384532332,54384533223,54384533231,54384533232,54384533233,54384533312,54384533313,54384612333,54384613222,54384613223,54384613332,54384613333,54384621131,54384621132,54384621133,54384621212,54384621213,54384621221,54384621222,54384621223,54384622031,54384622032,54384622033,54384622103,54384630003,54384630012,54384630013,54384701233,54384702113,54384702123,54384702212,54384702213,54384703002,54384703003,54384703110,54384703112,54384703113,54384712002,54384712003,54384712011,54384712012,54384712013,54384712120,54384712122,54384712300,54384712302,54384712332,54384713311,54384713312,54384713313,54384730110,54384730112,54384730113,54384731002,54384731003,54384731012,54384731013,54384731101,54384731102,54384731103,54385300311,54385300313,54385300331,54385300333,54385301031,54385301032,54385301033,54385301103,54385301111,54385301112,54385301113,54385302111,54385302113,54385302131,54385302133,54385320110,54385320111,54385320113,54385320131,54385320132,54385320133,54385320323,54385322101,54385322103,54385322121,54385322123,54385322330,54385322331,54385322333,54386300111,54386300113,54386300131,54386300133,54386300311,54386300313,54386300331,54386300333,54386302111,54386303000,54386303001,54386303003,54386303203,54386303221,54386321010,54386321011,54386321121,54386321123,54386321301,54386321303,54386321321,54386321323,54386323101,54386323103,54386323320,54386323321,54386323323,54387301101,54387301103,54387301121,54387301123,54387301301,54387312000,54387312001,54387312003,54387312120,54387312121,54387312123,54387312301,54387312303,54387312321,54387312323,54387330101,54387330103,54387330121,54387330311,54387331221,54387331330,54387331331,54387422001,54387422010,54387422011,54387422100,54387422101,54387422131,54387422133,54387422311,54387422332,54387422333,54387632320,54387632321,54387632330,54387632331,54387633220,54387633221,54387633223,54387633320,54387633321,54387633323,54387711310,54387711312,54387711330,54387711332,54387713110,54387713112,54387713130,54387713132,54387713310,54387713312,54387713330,54387713332,54387722220,54387722221,54387722222,54387722300,54387722301,54387722311,54387723200,54387723201,54387723210,54387723211,54387723300,54387723301,54387723303,54387732120,54387732121,54387732122,54387732130,54387732131,54387732200,54387732201,54387732202,54387732210,54387733020,54387733021,54394002200,54394002202,54394002203,54394002232,54394002233,54394002322,54394020100,54394020102,54394020103,54394020112,54394020130,54394020132,54394020300,54394020302,54394020320,54394020322,54394020323,54394022010,54394022011,54394022100,54394022101,54394022110,54394022112,54394022200,54394022201,54394022202,54394022220,54395000022,54395000130,54395000132,54395000200,54395000202,54395000220,54395000222,54395000223,54395000232,54395000233,54395000303,54395000310,54395000312,54395000313,54395001202,54395001220,54395001222,54395001223,54395020130,54395020131,54395020132,54395020310,54395020312,54395021000,54395021002,54395022100,54395022102,54395022120,54396000100,54396000102,54396000120,54396000122,54396000300,54396000302,54396000320,54396000322,54396002100,54396002102,54396002120,54396002122,54396002123,54396002310,54396002312,54396002330,54396002332,54396020110,54396020112,54396021202,54396021203,54396023120,54396023122,54396023300,54396023302,54396023320,54396023322,54397000000,54397000001,54397000002,54397000010,54397000020,54397000100,54397000101,54397000110,54397000111,54397001000,54397001001,54397001003,54397001010,54397001011,54397001012,54397001100,55380400101,55380400103,55380400121,55380400123,55380400301,55380400303,55380400321,55380400322,55380400323,55380402100,55380402101,55380402103,55380402130,55380402131,55380403020,55380403021,55380403321,55380403330,55380403331,55380403333,55380412220,55380412221,55380412222,55380412230,55380412231,55380412233,55380412320,55380412321,55380412322,55380412330,55380412331,55380412333,55380430111,55380431010,55380431011,55380431012,55380431101,55380431130,55380431131,55380431133,55380520200,55380520201,55380520210,55380520211,55380520321,55380520330,55380520331,55380520333,55380523010,55380523011,55380523100,55380523101,55380523110,55380523111,55380523113,55380532020,55380532021,55380532030,55380532031,55380532120,55380532121,55380532130,55380532131,55380532133,55380532311,55380532313,55380611111,55380612100,55380612102,55380612120,55380612122,55380612300,55380612302,55380612320,55380621130,55380621131,55380621132,55380621310,55380621312,55380622330,55380622331,55380623120,55380623121,55380623122,55380623220,55380623221,55380630010,55380630020,55380700000,55381511021,55381511023,55381511130,55381511131,55381511132,55381511210,55381511211,55381511300,55381511301,55381600010,55381600020,
037,00,/,499640625,131615625,501721875,133406250,3,18,43,105,209,464,553900,553910,553920,5439702,5439703,5439710,5439712,5439713,5439722,5538071,5538072,5538073,5538170,5538171,5538173,5538271,5539010,5539020,5539300,5539301,5539303,54397002,54397003,54397011,54397012,54397013,54397110,54397112,54397113,54397202,55380613,55380631,55380632,55380633,55380701,55380702,55380703,55381611,55381613,55381631,55381720,55381721,55383713,55383731,55390110,55390111,55390113,55390120,55390220,55390221,55390230,55390232,55391122,55392100,55392120,55392122,55393020,55393021,55393100,55393102,55393120,55393122,55394011,55394013,543877323,543877331,543877332,543877333,543961233,543961322,543970002,543970003,543970012,543970013,543970102,543970103,543971110,543971112,543971113,543972002,543972003,543972012,543972030,543972032,543972302,543972320,543972322,553806101,553806103,553806110,553806112,553806113,553806233,553806301,553806302,553806303,553807001,553807002,553807003,553816100,553816101,553816103,553816121,553816123,553816301,553816303,553817221,553817230,553817231,553827013,553827031,553827033,553827300,553827301,553827302,553827310,553827311,553827313,553827331,553827333,553837111,553837112,553837113,553901120,553901121,553901122,553901210,553901211,553901212,553901220,553901222,553901311,553901313,553902100,553902102,553902120,553902122,553902123,553902230,553902231,553902233,553902310,553902312,553902330,553902332,553911000,553911002,553911003,553911020,553911022,553911200,553911202,553912101,553921010,553921012,553921020,553921022,553921212,553921230,553921232,553931010,553931210,553931212,553931230,553931232,553940310,553941000,553941001,553941002,5438772223,5438772232,5438772233,5438772322,5438772323,5438772332,5438772333,5438773131,5438773133,5438773222,5438773223,5438773301,5438773303,5439603333,5439612222,5439612223,5439612232,5439612233,5439612311,5439612312,5439612313,5439612321,5439612322,5439612323,5439613202,5439613230,5439613232,5439613233,5439613322,5439613323,5439700003,5439700012,5439700013,5439700102,5439700103,5439700112,5439700113,5439701002,5439701003,5439701011,5439701012,5439701013,5439711112,5439711113,5439720002,5439720312,5439720330,5439720332,5439720333,5439723000,5439723002,5439723003,5538061110,5538061112,5538061113,5538061211,5538061213,5538061231,5538061233,5538062133,5538062311,5538062313,5538063003,5538070001,5538070002,5538070003,5538160110,5538160111,5538160113,5538161021,5538163021,5538163023,5538172200,5538172201,5538172203,5538172320,5538172321,5538172330,5538172331,5538172333,5538270111,5538270113,5538270121,5538270123,5538270321,5538272110,5538272111,5538272113,5538272131,5538273030,5538273031,5538273032,5538273121,5538273123,5538273301,5538273303,5538273321,5538273323,5538371101,5538371102,5538371103,5539011230,5539011231,5539012130,5539012131,5539012132,5539012210,5539012211,5539012212,5539012230,5539012232,5539012300,5539012301,5539012310,5539013000,5539013002,5539013020,5539013100,5539013101,5539013103,5539013121,5539013311,5539021010,5539021012,5539021030,5539021032,5539021210,5539021212,5539021213,5539021320,5539021322,5539022200,5539022201,5539022210,5539022211,5539022321,5539023130,5539023132,5539023310,5539023312,5539110010,5539110012,5539110013,5539110210,5539110211,5539110212,5539112032,5539112322,5539120111,5539121000,5539121001,5539121003,5539121031,5539121100,5539121102,5539121120,5539121122,5539210112,5539210113,5539210130,5539210131,5539210132,5539210210,5539210212,5539210230,5539210232,5539211002,5539211020,5539212102,5539302210,5539302211,5539302300,5539302301,5539302310,5539302311,5539302313,5539302331,5539302333,5539310120,5539310122,5539310300,5539310302,5539310320,5539310322,5539312112,5539312130,5539312132,5539312310,5539312312,5539312313,5539312330,5539312332,5539401001,5539401010,5539401011,5539401013,5539401031,5539403110,5539403111,5539403112,5539403120,5539403121,5539410030,5539410032,5539410100,5539410200,5539410202,5539410220,5539410222,54387632322,54387632323,54387632332,54387632333,54387633222,54387633322,54387711311,54387711313,54387711331,54387711333,54387713111,54387713113,54387713131,54387713133,54387713311,54387713313,54387713331,54387713333,54387722223,54387722302,54387722303,54387722310,54387722312,54387722313,54387723202,54387723203,54387723212,54387723213,54387723302,54387732123,54387732132,54387732133,54387732203,54387732211,54387732212,54387732213,54387733022,54387733023,54396033222,54396033223,54396033232,54396033233,54396033322,54396033323,54396121333,54396122202,54396123013,54396123031,54396123033,54396123101,54396123102,54396123103,54396123202,54396123203,54396132002,54396132032,54396132033,54396132122,54396132310,54396132312,54396132313,54396133202,54396133203,54396133212,54396133322,54397000003,54397000011,54397000012,54397000013,54397000021,54397000022,54397000023,54397000102,54397000103,54397000112,54397000113,54397001002,54397001013,54397001102,54397001103,54397001112,54397001113,54397010002,54397010003,54397010012,54397010013,54397010102,54397010103,54397111100,54397111102,54397111103,54397111112,54397200032,54397200033,54397200122,54397200123,54397200132,54397200133,54397201021,54397201022,54397201023,54397201032,54397201300,54397201302,54397201320,54397201322,54397203100,54397203102,54397203310,54397203312,54397203313,54397212222,54397230012,54397230302,54397232302,54397232320,54397232322,54397232323,55380611110,55380611112,55380611113,55380612101,55380612103,55380612121,55380612123,55380612301,55380612303,55380612321,55380612322,55380612323,55380621133,55380621311,55380621313,55380623123,55380623230,55380623231,55380623233,55380630011,55380630012,55380630013,55380630021,55380630022,55380630023,55380700001,55380700002,55380700003,55381601011,55381601013,55381601031,55381601120,55381601121,55381601123,55381601310,55381601311,55381601313,55381610200,55381610201,55381610202,55381610230,55381610231,55381610233,55381612011,55381612013,55381630033,55381632010,55381632011,55381632100,55381632101,55381632110,55381632111,55381633000,55381633001,55381633010,55381633100,55381633101,55381633110,55381633111,55381633113,55381722020,55381722021,55381722023,55381722201,55381722210,55381722211,55381722300,55381722301,55381722310,55381722311,55381722313,55381723230,55381723231,55381723320,55381723321,55381723323,55382701101,55382701103,55382701121,55382701122,55382701123,55382703010,55382703011,55382703033,55382703230,55382703231,55382703233,55382721011,55382721120,55382721121,55382721123,55382721331,55382730330,55382730331,55382730332,55382731200,55382731201,55382731202,55383710133,55383710311,55383710313,55383710331,55383710333,55383711001,55383711003,55383712111,55383712113,55383712131,55383712133,55383712311,55383712313,55383712331,55383712333,55383730111,55383730113,55383730131,55383730133,55383730311,55383730313,55383730331,55383730333,55383732111,55383733000,55383733001,55383733100,55383733101,55383733110,55390112320,55390112321,55390112330,55390112331,55390112333,55390121330,55390121331,55390121332,55390122130,55390122131,55390122132,55390122310,55390122312,55390122330,55390122332,55390123031,55390123120,55390130010,55390130011,55390130111,55390130113,55390130220,55390131020,55390131021,55390131023,55390131201,55390131231,55390131233,55390133011,55390133100,55390133101,55390133103,55390133121,55390133130,55390133131,55390210132,55390210310,55390210312,55390210330,55390210332,55390212110,55390212112,55390212113,55390213022,55390213230,55390213232,55390222020,55390222021,55390222023,55390222030,55390222031,55390222033,55390222120,55390222121,55390222130,55390222131,55390222133,55390223201,55390223231,55390223233,55390231120,55390231122,55390231123,55390233300,55390233301,55390233302,55391100110,55391100112,55391100113,55391101222,55391102130,55391102132,55391102300,55391102301,55391102302,55391102310,55391102320,55391102322,55391103000,55391120100,55391120300,55391120302,55391120330,55391120332,55391123200,55391123202,55391123203,55391123230,55391123232,55391123233,55391201100,55391201101,55391210020,55391210021,55391210300,55391210301,55391210331,55391210333,55391211010,55391211212,55391211230,55391211232,55392101100,55392101102,55392101103,55392101112,55392101113,55392101330,55392101331,55392101332,55392102110,55392102111,55392102112,55392102130,55392102132,55392102310,55392102312,55392102330,55392102332,55392103000,55392103001,55392103010,55392103011,55392103100,55392110002,55392110003,55392110220,55392110221,55392121002,55392123300,55392123302,55392123320,55392123322,55393022000,55393022001,55393022010,55393022011,55393022013,55393022031,55393022120,55393022121,55393022130,55393023031,55393023120,55393023121,55393023123,55393023301,55393023303,55393023321,55393101100,55393101102,55393103230,55393103232,55393103233,55393121100,55393121102,55393121103,55393121130,55393121131,55393121132,55393121310,55393121312,55393121330,55393121332,55393123110,55393123112,55393123113,55393123310,55393123311,55393123312,55394001111,55394010000,55394010001,55394010030,55394010031,55394010120,55394010121,55394010123,55394010301,55394010331,55394010333,55394012111,55394012113,55394012131,55394012133,55394012311,55394012313,55394012331,55394012333,55394030111,55394030113,55394030131,55394031130,55394031300,55394031301,55394100310,55394100311,55394100312,55394100330,55394100332,55394101010,55394101011,55394101012,55394101020,55394101100,55394101101,55394102010,55394102011,55394102012,55394102030,55394102032,55394102100,55394102101,55394102210,55394102212,55394102230,55394120000,55394120001,55394120002,
038,00,/,498684375,132253125,501328125,134690625,14,22,66,132,349,685,553826,553835,553836,553845,553846,553847,553855,553856,553857,553866,553867,553950,553960,553970,5538162,5538252,5538253,5538370,5538372,5538443,5538541,5538543,5538651,5538760,5538761,5538763,5539402,5539510,5539512,5539712,5639000,5639001,5639010,5538770,5538771,5538773,55381512,55381513,55381531,55381532,55381533,55381602,55381603,55382511,55382512,55382513,55382700,55382702,55382720,55382722,55382723,55382732,55383411,55383413,55383431,55383433,55384403,55384411,55384412,55384413,55385403,55386501,55386530,55386531,55387621,55387623,55393132,55394000,55394002,55394003,55394032,55394033,55394103,55394110,55394112,55394121,55394122,55394123,55394130,55394132,55395110,55395112,55395130,55395132,55396100,55396101,55396102,55396120,55396122,55397100,55397102,55397103,55397132,56380601,56380711,56390021,56390030,56390031,56390110,56390112,56390120,56390121,553815031,553815101,553815102,553815103,553815301,553815303,553816001,553816002,553816003,553816012,553816122,553816322,553816323,553816332,553816333,553824332,553824333,553825032,553825033,553825101,553825103,553827010,553827212,553834323,553837100,553837102,553837120,553837122,553837300,553837302,553837320,553837322,553837323,553837332,553837333,553844101,553844103,553844211,553844213,553844231,553844233,553854011,553854012,553854013,553854210,553854211,553865031,553865033,553865331,553865333,553876200,553876201,553876203,553876220,553876221,553876223,553930222,553930223,553930232,553931302,553931303,553931312,553931330,553931332,553931333,553940010,553940012,553940013,553940102,553940120,553940122,553940300,553940302,553940303,553941012,553941013,553941023,553941110,553941112,553941130,553941132,553941133,553941201,553941202,553941203,553941310,553941311,553941312,553941330,553941332,553951110,553951112,553951130,553951132,553951310,553951312,553951330,553951332,553961030,553961031,553961032,553961100,553961101,553961110,553961210,553971012,553971122,553971300,553971302,563806001,563806003,563806021,563806023,563806030,563806031,563806032,563806100,563806102,563806111,563807130,563807131,563807132,563900330,563900331,563901132,563901230,563901231,563901300,563901302,563807101,553877200,553877201,5538053221,5538053223,5538053230,5538053232,5538053233,5538150131,5538150132,5538150133,5538150331,5538151001,5538151002,5538151003,5538151120,5538151122,5538151123,5538151131,5538151132,5538151133,5538152311,5538152313,5538153000,5538153001,5538153003,5538153021,5538153022,5538153023,5538160003,5538160100,5538160102,5538160130,5538160132,5538160133,5538161022,5538161200,5538161202,5538161203,5538163000,5538163001,5538163002,5538163020,5538163022,5538163200,5538163202,5538163203,5538163212,5538163213,5538163302,5538163303,5538163312,5538163313,5538172222,5538172223,5538172232,5538172233,5538172322,5538243131,5538243133,5538243302,5538243303,5538243311,5538243312,5538243313,5538250233,5538250312,5538250313,5538251001,5538251003,5538251021,5538251023,5538270120,5538270122,5538270300,5538270302,5538270320,5538270322,5538272100,5538272102,5538272103,5538272130,5538272132,5538273122,5538273300,5538273302,5538273320,5538273322,5538341013,5538341031,5538341033,5538341211,5538341213,5538341231,5538341233,5538343011,5538343013,5538343031,5538343033,5538343211,5538343213,5538371010,5538371011,5538371012,5538371030,5538371032,5538371210,5538371212,5538371230,5538371232,5538373010,5538373012,5538373030,5538373032,5538373210,5538373212,5538373213,5538373301,5538373302,5538373303,5538373312,5538373313,5538440123,5538440132,5538440213,5538441001,5538441003,5538441021,5538441022,5538441023,5538442101,5538442103,5538442121,5538442123,5538442301,5538442303,5538442321,5538442323,5538540101,5538540102,5538540103,5538540211,5538542130,5538542131,5538542133,5538542311,5538641111,5538641113,5538650000,5538650001,5538650002,5538650010,5538650011,5538650013,5538650031,5538650300,5538650301,5538650303,5538650321,5538652110,5538652111,5538652113,5538652131,5538652132,5538652133,5538652311,5538653200,5538653201,5538653210,5538653211,5538653300,5538653303,5538751111,5538751113,5538751311,5538762021,5538762022,5538762023,5538762220,5538762221,5538762223,5539302202,5539302302,5539312333,5539313002,5539313003,5539313010,5539313012,5539313013,5539313102,5539313103,5539313112,5539313130,5539313132,5539313310,5539313312,5539313313,5539400110,5539400112,5539400113,5539401002,5539401032,5539401210,5539401212,5539401230,5539401232,5539403010,5539403012,5539403122,5539403123,5539403131,5539403132,5539403133,5539410103,5539410111,5539410112,5539410113,5539410211,5539410212,5539410213,5539411110,5539411112,5539411130,5539411132,5539411310,5539411312,5539412001,5539412002,5539412003,5539413130,5539413131,5539413132,5539413310,5539413312,5539413330,5539422000,5539422002,5539513110,5539513112,5539513130,5539513132,5539513310,5539513312,5539513313,5539513330,5539513331,5539513332,5539610330,5539610331,5539610332,5539611020,5539611021,5539611022,5539611030,5539611031,5539611033,5539611110,5539611112,5539611120,5539611121,5539611122,5539611200,5539612110,5539612120,5539612122,5539612300,5539612302,5539612320,5539612322,5539710100,5539710102,5539710103,5539710130,5539710132,5539710133,5539711202,5539711232,5539713010,5539713012,5539713030,5539713032,5638060001,5638060003,5638060021,5638060023,5638060201,5638060203,5638060330,5638061011,5638061100,5638061101,5638061103,5638061130,5638061131,5638061200,5638061202,5638062011,5638062100,5638062101,5638071231,5638071233,5638071330,5638071331,5638071332,5638073100,5639002010,5639002011,5639002013,5639002031,5639002311,5639002312,5639002313,5639002331,5639003200,5639003201,5639003202,5639003210,5639003211,5639011120,5639011122,5639011300,5639011302,5639011303,5639012200,5639012202,5639012211,5639012320,5639012321,5639012330,5639012331,5639013010,5639013011,5639013100,5639013200,5639013201,5639013202,5639013220,5638070000,5538772111,5638071000,5638071001,5638071211,5638071213,5638071030,5638071031,5638071033,5538772030,5538772100,5538772102,5538772020,5538772021,5538772022,55380532032,55380532033,55380532122,55380532123,55380532132,55380532201,55380532203,55380532221,55380532223,55380532310,55380532312,55380622332,55380622333,55380623222,55380623223,55380623232,55381501233,55381501303,55381503011,55381503013,55381503031,55381503300,55381503301,55381503303,55381503331,55381503333,55381510001,55381510003,55381511020,55381511022,55381511133,55381511212,55381511213,55381511302,55381511303,55381521333,55381523310,55381523311,55381523313,55381523331,55381530021,55381530023,55381600011,55381600012,55381600013,55381600021,55381600022,55381600023,55381601010,55381601012,55381601030,55381601032,55381601033,55381601122,55381601312,55381610203,55381610232,55381612010,55381612012,55381630030,55381630031,55381630032,55381632012,55381632013,55381632102,55381632103,55381632112,55381632113,55381633002,55381633003,55381633011,55381633012,55381633013,55381633102,55381633103,55381633112,55381722022,55381722200,55381722202,55381722203,55381722212,55381722213,55381722302,55381722303,55381722312,55381723232,55381723233,55381723322,55382431113,55382431131,55382431133,55382432311,55382432313,55382432331,55382432333,55382502232,55382502233,55382502311,55382502313,55382502321,55382502322,55382502323,55382503022,55382503023,55382503032,55382503033,55382503111,55382503113,55382510001,55382510003,55382510021,55382510023,55382510201,55382510203,55382510221,55382510222,55382510223,55382701100,55382701102,55382701120,55382703012,55382703013,55382703030,55382703031,55382703032,55382703232,55382721010,55382721012,55382721013,55382721122,55382721330,55382721332,55382721333,55382730333,55382731203,55383410111,55383410112,55383410113,55383410121,55383410123,55383410301,55383410303,55383410321,55383410323,55383412101,55383432121,55383432123,55383432211,55383432213,55383432231,55383432232,55383432233,55383710130,55383710131,55383710132,55383710310,55383710312,55383710330,55383710332,55383711000,55383711002,55383712110,55383712112,55383712130,55383712132,55383712310,55383712312,55383712330,55383712332,55383730110,55383730112,55383730130,55383730132,55383730310,55383730312,55383730330,55383730332,55383732110,55383732112,55383732113,55383733002,55383733003,55383733102,55383733103,55383733111,55383733112,55383733113,55384400333,55384401221,55384401222,55384401223,55384401332,55384401333,55384402111,55384402112,55384402113,55384402311,55384402313,55384402331,55384410203,55384421203,55384421221,55384423003,55384423021,55385400331,55385400332,55385400333,55385401003,55385402130,55385402131,55385402133,55385402311,55385402313,55385402331,55385402333,55385420111,55385420113,55385420131,55385420133,55385420311,55385421200,55385421201,55385421210,55385421211,55385421213,55385421320,55385421321,55385421323,55385423101,55385423131,55386410000,55386410001,55386410010,55386410100,55386410110,55386410111,55386411000,55386411001,55386411010,55386411011,55386411100,55386411101,55386411311,55386500030,55386500031,55386500032,55386500120,55386500121,55386500200,55386500331,55386500333,55386502111,55386502113,55386503020,55386503021,55386503231,55386521120,55386521121,55386521123,55386521301,55386521302,55386521303,55386523101,55386523103,55386523121,55386523130,55386532121,55386533010,55386533011,55386533013,55386533211,55386533213,55386533231,55387511101,55387511103,55387511121,55387511311,55387511313,55387511331,55387511332,55387511333,55387513131,55387513311,55387513313,55387513331,55387513333,55387531111,55387620201,55387620202,55387620203,55387622221,55387622223,55393022002,55393022003,55393022012,55393022030,55393022032,55393022033,55393022122,55393022123,55393022131,55393022132,55393022133,55393023030,55393023032,55393023033,55393023122,55393023300,55393023302,55393023320,55393023322,55393023323,55393112332,55393113312,55393113321,55393113323,55393113330,55393113332,55393121133,55393121311,55393121313,55393121331,55393121333,55393123111,55393123313,55393130001,55393130002,55393130003,55393130011,55393130012,55393130013,55393130110,55393130112,55393130113,55393131002,55393131003,55393131012,55393131013,55393131101,55393131102,55393131103,55393131110,55393131112,55393131130,55393131132,55393131310,55393131312,55393131313,55393131330,55393131332,55393133110,55393133112,55393133113,55393222002,55393222020,55393222022,55393222200,55394001110,55394001112,55394001113,55394010002,55394010003,55394010032,55394010033,55394010122,55394010300,55394010302,55394010303,55394010330,55394010332,55394012110,55394012112,55394012130,55394012132,55394012310,55394012312,55394012330,55394012332,55394030110,55394030112,55394030130,55394030132,55394030133,55394031131,55394031132,55394031133,55394031302,55394031303,55394100313,55394100331,55394100333,55394101013,55394101021,55394101022,55394101023,55394101102,55394101103,55394102013,55394102031,55394102033,55394102102,55394102103,55394102211,55394102213,55394102231,55394102232,55394102233,55394111110,55394111112,55394111130,55394111132,55394111330,55394111332,55394113110,55394113112,55394113130,55394113132,55394120003,55394131330,55394131331,55394131332,55394133110,55394133112,55394133130,55394133132,55394133310,55394133312,55394133320,55394133321,55394133322,55394202202,55394202220,55394202222,55394220200,55394220202,55394220220,55395111100,55395111102,55395111120,55395111122,55395111300,55395111302,55395111320,55395113122,55395113300,55395113302,55395113320,55395113322,55395131132,55395131310,55395131312,55395131330,55395131332,55395133110,55395133112,55395133113,55395133330,55396103330,55396103332,55396110230,55396110231,55396110320,55396110321,55396111230,55396111232,55396111300,55396111301,55396111302,55396112020,55396112021,55396112022,55396112110,55396112111,55396112200,55396112202,55396113000,55396113001,55396113003,55396113010,55396113021,55396113023,55396113201,55396121120,55396121122,55396121210,55396121212,55396121230,55396123230,55396123232,55397101010,55397101012,55397101013,55397101102,55397101120,55397101122,55397101123,55397101312,55397110220,55397110222,55397112000,55397112002,55397112302,55397112303,55397112312,55397112330,55397112332,55397130110,55397130112,55397130130,55397130132,55397130310,55397130312,55397130330,55397130332,56380602210,56380602211,56380602213,56380602231,56380602233,56380603310,56380603311,56380603320,56380603322,56380603323,56380610100,56380610101,56380610102,56380611020,56380611021,56380612010,56380612011,56380612012,56380612030,56380612200,56380620100,56380620101,56380620103,56380620121,56380620130,56380620131,56380621020,56380621021,56380621030,56380621031,56380621100,56380621101,56380621102,56380621120,56380712301,56380712303,56380712321,56380712323,56380713330,56380713331,56380713333,56380730111,56380730113,56380730131,56380731010,56380731011,56380731012,56380731020,56380731021,56380731100,56380731101,56390020010,56390020011,56390020120,56390020121,56390020123,56390020301,56390020303,56390020321,56390020330,56390020331,56390020333,56390022111,56390023000,56390023001,56390023010,56390023011,56390023100,56390023101,56390023103,56390023300,56390023301,56390023303,56390023321,56390023330,56390023331,56390032030,56390032031,56390032032,56390032120,56390032121,56390032130,56390032131,56390032133,56390032200,56390032202,56390032220,56390032311,56390033200,56390033201,56390033210,56390033211,56390033300,56390033301,56390033310,56390033311,56390111022,56390111023,56390111210,56390111212,56390111230,56390111232,56390113010,56390113012,56390122010,56390122012,56390122101,56390122103,56390122130,56390122131,56390122133,56390122200,56390122311,56390123221,56390123230,56390123231,56390130120,56390130121,56390130122,56390130130,56390130131,56390130300,56390130302,56390130320,56390130322,56390131010,56390131012,56390131020,56390131021,56390131030,56390132100,56380712121,56380712123,56380712101,56380712103,56380710321,55387721100,55387721101,55387720320,55387720321,55387720310,55387720312,55387721030,55387723333,56380701111,56380710030,56380710031,56380710033,55387723111,55387721331,55387721333,55387721311,55387721313,55387721130,55387721131,55387721133,55387721200,55387720330,55387722000,55387722002,55387722222,56380700200,56380700202,55387720230,55387720231,56380700020,56380700021,56380700022,55387721010,55387721011,55387721012,
039,00,/ľ,495450000,132337500,498867187,134400000,10,22,59,75,159,431,553736,553737,553840,553852,553853,553863,553747,553850,553851,553862,5537162,5537260,5537262,5538300,5538302,5538430,5538432,5538433,5538421,5538423,5537353,5537451,5537460,5537461,5537463,5537570,5537571,5538610,5538601,5538611,5538730,5538721,55371602,55372531,55372533,55372610,55372612,55372613,55372630,55372632,55373511,55373512,55373513,55373521,55383030,55383032,55383033,55384312,55384313,55384420,55384422,55385422,55386400,55386401,55386402,55387310,55387311,55387312,55387400,55383233,55384221,55384222,55384223,55384133,55384120,55384122,55384123,55373523,55374621,55374620,55374500,55374501,55374503,55374531,55374623,55375611,55375731,55375730,55386001,55375733,55386131,55386130,55386133,55387201,55387320,55387231,55387230,55387203,55387200,55387233,55387322,553715333,553716030,553716032,553716302,553716320,553716322,553716323,553725111,553725113,553725131,553725133,553726110,553726112,553726310,553726311,553726312,553726330,553726332,553727223,553727323,553727332,553727333,553735033,553735203,553820222,553830102,553830132,553833220,553833222,553843102,553844020,553844022,553854000,553854001,553854002,553854020,553854022,553854200,553854202,553854230,553854232,553854233,553864030,553864031,553864200,553864201,553864220,553864222,553873130,553873131,553873211,553831222,553841000,553841002,553841020,553841022,553841023,553832323,553842011,553842013,553841210,553841212,553841320,553841322,553841323,553842031,553842032,553842033,553830120,553830122,553830123,553873210,553873212,553735223,553735221,5537153311,5537153312,5537153313,5537160023,5537160032,5537160330,5537160332,5537160333,5537163000,5537163002,5537163003,5537163030,5537163032,5537163210,5537163212,5537163213,5537163322,5537251323,5537253211,5537261132,5537263130,5537263132,5537263310,5537263311,5537263312,5537263330,5537263332,5537263333,5537270202,5537270220,5537270222,5537272221,5537272222,5537272223,5537272322,5537272333,5537273211,5537273212,5537273213,5537273222,5537273223,5537350313,5537350321,5537350323,5537352013,5537352023,5538202202,5538202203,5538301000,5538301002,5538301302,5538301303,5538332210,5538332212,5538332230,5538332232,5538332233,5538332322,5538431002,5538431030,5538431032,5538431033,5538431122,5538431123,5538431132,5538431133,5538440210,5538440212,5538440230,5538440232,5538442100,5538442102,5538442320,5538442322,5538540030,5538540031,5538540032,5538540210,5538540212,5538540230,5538540232,5538542010,5538542012,5538542030,5538542032,5538542033,5538542122,5538542123,5538542312,5538640320,5538641002,5538641020,5538642020,5538642021,5538642022,5538642030,5538642210,5538642212,5538642230,5538642232,5538731320,5538731321,5538731322,5538731330,5538731331,5538740102,5538740103,5538740120,5538740121,5538740122,5538740200,5538410212,5538323213,5538420101,5538420103,5538420121,5538420123,5538410320,5538410322,5538413022,5538323132,5538323133,5538323123,5538312202,5538412130,5538412132,5538412133,5538412110,5538412111,5538412112,5538413210,5538413212,5538413213,5538420301,5538420303,5538322332,5538322333,5538422011,5538422013,5538422032,5538422023,5538323221,5538323222,5538323223,5538303100,5538303102,5538303120,5538303122,5538303123,5538301210,5538301212,5538301213,5538202230,5538202232,5538202233,5537352221,5537352223,5537352203,5537352201,55371513113,55371513131,55371513133,55371531133,55371531311,55371531313,55371531331,55371531332,55371531333,55371533031,55371533033,55371533101,55371533102,55371533103,55371533211,55371533213,55371533233,55371600211,55371600213,55371600223,55371600300,55371600302,55371600303,55371600330,55371600332,55371600333,55371601222,55371601223,55371601232,55371603120,55371603122,55371603312,55371612220,55371612222,55371612223,55371612232,55371630010,55371630012,55371630013,55371630312,55371630330,55371630332,55371632110,55371632112,55371632113,55371633022,55371633200,55371633202,55371633203,55371633232,55372511011,55372511233,55372513011,55372513211,55372513213,55372513223,55372530131,55372530133,55372530311,55372530313,55372530331,55372530333,55372532130,55372532131,55372532133,55372532311,55372532313,55372532331,55372532333,55372611102,55372611120,55372611122,55372611300,55372611302,55372611303,55372611332,55372631310,55372631312,55372631330,55372631332,55372631333,55372633130,55372633131,55372633132,55372633310,55372633312,55372702002,55372702212,55372702230,55372720000,55372720222,55372722000,55372722002,55372722122,55372722123,55372722132,55372722201,55372722202,55372722203,55372723200,55372723202,55372723230,55372723232,55372723233,55372723312,55372723313,55372723321,55372723322,55372723323,55372732033,55372732101,55372732102,55372732103,55372732202,55372732203,55372732211,55372732212,55372732213,55372733000,55372733002,55372733020,55372733022,55372733023,55372733032,55372733033,55372733122,55372733123,55372733131,55372733132,55372733133,55373502333,55373503032,55373503033,55373503111,55373503112,55373503113,55373503121,55373503122,55373503123,55373503221,55373503222,55373503223,55373510111,55373510113,55373510131,55373510133,55373510232,55373510233,55373510311,55373510313,55373510322,55373510331,55373510332,55373510333,55373520111,55373520113,55373520123,55373520213,55382022002,55382022003,55382022012,55382022013,55382023222,55382023223,55382023232,55382023233,55382023322,55383010012,55383010302,55383013002,55383320230,55383320232,55383320233,55383322312,55383322313,55383323202,55383323203,55383323230,55383323232,55383323233,55383323322,55383323323,55384310000,55384310002,55384310003,55384310030,55384310032,55384310033,55384310122,55384310312,55384310313,55384311202,55384311203,55384311212,55384400222,55384400223,55384400232,55384402110,55384402310,55384402312,55384402330,55384402332,55384402333,55384421200,55384421201,55384421202,55384421220,55384421222,55384421223,55384423000,55384423001,55384423002,55384423020,55384423022,55384423023,55385400330,55385401000,55385401001,55385401002,55385402132,55385402310,55385402312,55385402330,55385402332,55385420110,55385420112,55385420130,55385420132,55385420310,55385420312,55385420313,55385421202,55385421203,55385421212,55385421322,55385423100,55385423102,55385423103,55385423130,55385423132,55385423133,55386403210,55386403211,55386403220,55386403221,55386403222,55386403300,55386403301,55386403303,55386403310,55386403311,55386403312,55386410002,55386410003,55386410012,55386410030,55386410032,55386410210,55386410212,55386410220,55386410221,55386410222,55386412002,55386412020,55386420230,55386420232,55386420233,55386420310,55386421000,55386421002,55386421020,55386422332,55386422333,55387313230,55387313231,55387313232,55387313320,55387313321,55387313330,55387321300,55387321301,55387321302,55387330000,55387330001,55387330002,55387330010,55387330011,55387330020,55387330022,55387330100,55387330101,55387330110,55387330111,55387401000,55387401002,55387401003,55387401230,55387402010,55387402011,55387402012,55387402020,55387402021,55387402022,55387402100,55387402101,55387402110,55387402111,55387402200,55387403000,55387403001,55383320220,55383320222,55383320223,55383231312,55383231313,55383231302,55383231303,55383231212,55383231213,55383231203,55383231221,55383231222,55383231223,55383232112,55383232113,55383122300,55383122302,55384100300,55384100302,55384100120,55384100122,55384100100,55384100102,55383122320,55383122322,55384102130,55384102132,55384102133,55384103022,55384103232,55384103233,55384103322,55384103323,55384121310,55384121312,55384121130,55384121131,55384121132,55384103332,55384103333,55384130232,55384130233,55384130333,55384132111,55384132112,55384132113,55384131222,55384131223,55384131232,55384131332,55384131333,55384201223,55384203001,55384203003,55383223231,55383223233,55383223302,55383223303,55383223312,55383223313,55384203021,55384203022,55384203023,55384202332,55384202333,55384202323,55384220101,55384220103,55384220121,55384220302,55384220221,55384220222,55384220223,55384220331,55384220332,55384220333,55384220310,55384220311,55384220313,55383232121,55383232122,55383232123,55383232033,55383232201,55383232202,55383232203,55383031030,55383031032,55383031010,55383031011,55383031012,55383013320,55383013322,55383013300,55383013302,55383013122,55383122000,55383122002,55383122003,55383031332,55383031333,55383031320,55383031322,55383031323,55383031210,55383031212,55383031213,55384220212,55384220213,55383012112,55383012113,55383010320,55383010322,55383010030,55383010032,55383010033,55382022120,55382022122,55382022310,55382022312,55382022313,
040,00,Ĺ,498150000,133800000,500864062,135750000,7,17,53,91,186,416,563805,563816,563817,563826,563815,563825,563804,5538643,5538741,5538742,5538743,5538750,5538752,5638063,5638270,5639100,5639102,5638072,5638141,5638360,5638143,5638031,5638353,5638351,55386413,55386423,55386520,55386522,55387331,55387333,55387510,55387512,55387530,55387532,55387533,56380613,56380622,56380623,56380702,56380732,56380733,56383611,56392010,56392000,56392001,56391010,56391012,56391030,56391032,56382720,56382721,56382710,56382711,56382712,56380703,55387332,55387323,56380301,56381401,56383620,56383622,56383501,56382411,56382413,56382410,56381403,56381421,56381400,56380331,56380303,56380300,56380330,56380333,56384600,56384511,56384602,56384513,553864103,553864112,553864121,553864122,553864123,553864211,553864212,553864213,553865020,553865022,553865023,553865210,553865212,553865230,553865232,553865233,553865322,553865323,553873302,553873303,553874011,553874013,553874023,553874031,553874032,553874033,553875110,553875112,553875130,553875132,553875310,553875312,553875313,563806103,563806112,563806121,563806123,563806200,563806202,563806203,563806212,563806213,563807300,563807302,563807303,563807312,563807313,563836100,563836101,563836102,563836120,563836122,563836210,563836211,563836212,563836300,563846012,563846013,563846031,563846033,563900202,563900220,563900222,563900223,563900232,563910330,563910332,563910110,563910111,563910112,563920110,563827310,563827130,563827131,563827132,563827220,563827221,563827222,563807122,563807120,563807102,563807013,563807010,553877232,553877230,553877221,553877223,563807001,563807003,563807012,563846030,5538640323,5538640332,5538640333,5538641012,5538641013,5538641023,5538641102,5538641103,5538641112,5538641130,5538641132,5538641133,5538641201,5538641203,5538642032,5538642033,5538642101,5538642103,5538642211,5538642213,5538642231,5538650021,5538650022,5538650023,5538650030,5538650032,5538650210,5538650212,5538650213,5538650320,5538650322,5538653202,5538653203,5538653213,5538653302,5538653320,5538653322,5538732131,5538732133,5538733003,5538733012,5538733013,5538740101,5538740203,5538740212,5538740213,5538740221,5538740222,5538740223,5538740301,5538740302,5538740303,5538751130,5538751132,5538751310,5538751312,5538751330,5538751332,5538753110,5538753112,5538753113,5638060000,5638060002,5638060020,5638060022,5638060200,5638060202,5638060220,5638060222,5638060333,5638061012,5638061013,5638061221,5638061222,5638061223,5638062111,5638062113,5638073010,5638073012,5638073103,5638073111,5638073112,5638073113,5638361030,5638361031,5638361032,5638361210,5638361212,5638361230,5638361231,5638361232,5638361301,5638361310,5638361311,5638361313,5638362130,5638362132,5638362300,5638362301,5638362302,5638362320,5638362322,5638363010,5638363021,5638460321,5639002000,5639002002,5639002003,5639002210,5639002212,5639002213,5639002302,5639002303,5639003221,5639003223,5639003230,5639003232,5639003233,5639003322,5639003323,5639003332,5639003333,5639101130,5639201110,5639201112,5638370020,5638370022,5638272300,5638271330,5638271331,5638273112,5639200300,5639200200,5639200201,5638272230,5638272232,5639101300,5639101301,5639101302,5639103122,5639103123,5639201120,5639201121,5639200210,5639200211,5638273121,5638273000,5638273001,5638273002,5638370000,5638370200,5638370202,5638070023,5638070021,5638070003,5638070001,5538772223,5538772220,5538772202,5538772201,5538772203,5538772221,5538772122,5538772121,5538772112,5538772130,5538772132,5538772310,5538772313,5538772331,5538772330,5538772312,5538772332,5638070110,5638070113,5638071002,5638070112,5538772123,5638460100,5638460102,5638460103,5638070022,5638061133,5638061132,5638460320,5538732132,55386403212,55386403213,55386403223,55386403302,55386403313,55386410011,55386410013,55386410031,55386410033,55386410101,55386410102,55386410103,55386410112,55386410113,55386410211,55386410213,55386410223,55386411002,55386411003,55386411012,55386411013,55386411102,55386411103,55386411310,55386411312,55386411313,55386412000,55386412001,55386412003,55386412021,55386412022,55386412023,55386420231,55386420311,55386420312,55386420313,55386421001,55386421003,55386421021,55386421022,55386421023,55386422330,55386422331,55386500033,55386500122,55386500123,55386500201,55386500202,55386500203,55386500330,55386500332,55386502110,55386502112,55386503022,55386503023,55386503230,55386503232,55386503233,55386521122,55386521300,55386523100,55386523102,55386523120,55386523122,55386523123,55386523131,55386523132,55386523133,55386532120,55386532122,55386532123,55386533012,55386533210,55386533212,55386533230,55386533232,55386533233,55387313233,55387313322,55387313323,55387313331,55387313332,55387313333,55387321303,55387330003,55387330012,55387330013,55387330021,55387330023,55387330102,55387330103,55387330112,55387330113,55387401001,55387401231,55387401232,55387401233,55387402013,55387402023,55387402102,55387402103,55387402112,55387402113,55387402201,55387402202,55387402203,55387403002,55387403003,55387511100,55387511102,55387511120,55387511122,55387511123,55387511310,55387511312,55387511330,55387513130,55387513132,55387513133,55387513310,55387513312,55387513330,55387513332,55387531110,55387531112,55387531113,55387620200,55387622220,55387622222,56380602212,56380602230,56380602232,56380603312,56380603313,56380603321,56380610103,56380611022,56380611023,56380612013,56380612031,56380612032,56380612033,56380612201,56380612202,56380612203,56380620102,56380620120,56380620122,56380620123,56380620132,56380620133,56380621022,56380621023,56380621032,56380621033,56380621103,56380621121,56380621122,56380621123,56380712302,56380712320,56380712322,56380713332,56380730110,56380730112,56380730130,56380730132,56380730133,56380731013,56380731022,56380731023,56380731102,56380731103,56383610330,56383610331,56383610333,56383612111,56383612132,56383612133,56383612330,56383612331,56383612332,56383613000,56383613001,56383613031,56383613120,56383613121,56383621330,56383623030,56383623031,56383623032,56383623120,56383623210,56383623212,56383630120,56383630122,56383630221,56383630300,56383630302,56383630320,56384603221,56384612002,56384612020,56384612022,56384612200,56384612202,56384612220,56384612222,56390020012,56390020013,56390020122,56390020300,56390020302,56390020320,56390020322,56390020323,56390020332,56390022110,56390022112,56390022113,56390023002,56390023003,56390023012,56390023013,56390023102,56390023302,56390023320,56390023322,56390023323,56390023332,56390023333,56390032033,56390032122,56390032123,56390032132,56390032201,56390032203,56390032221,56390032222,56390032223,56390032310,56390032312,56390032313,56390033202,56390033203,56390033212,56390033213,56390033302,56390033303,56390033312,56390033313,56390122202,56390122220,56390122222,56391100000,56391100002,56391100020,56391100022,56391011310,56391011311,56391011312,56391011320,56391011321,56391011322,56391013030,56391031000,56391013220,56391013222,56391013200,56391013201,56391013202,56391031202,56391031203,56391031212,56391033322,56392011300,56392011301,56392011302,56392011230,56392011220,56392011221,56392011222,56392012100,56392012101,56392012102,56392012010,56392012011,56392012013,56392012000,56392012001,56392003010,56392003020,56392002130,56392002131,56392002121,56392002020,56392002022,56392002023,56392002200,56392002201,56382713320,56382713322,56382731100,56382731102,56382731103,56382731300,56382731302,56382731230,56382731231,56382731200,56382731201,56382731203,56382730131,56382730111,56382730113,56382730100,56382730101,56382730102,56382730030,56382730031,56382730032,56382730210,56382730200,56382730201,56382723010,56382723020,56382722310,56382722312,56383700010,56383700011,56383700012,56383700030,56383700020,56383700021,56383700022,56383700230,56383700232,56383702010,56383702012,56383702030,56383702032,56383702210,56380712300,56380712122,56380712120,56380712102,56380712100,56380710323,56380710322,56380710320,55387721102,55387720323,55387720313,55387721032,55387723331,55387723332,56380701110,56380701113,56380710032,55387723113,55387723110,55387721332,55387721330,55387721312,55387721310,55387721132,55387721031,55387721201,55387721202,55387720311,55387720331,55387720332,55387720322,55387722003,55387722221,56380700201,56380700203,56380701112,55387723330,55387723112,55387721033,55387721203,55387720333,55387720232,55387720233,56383702200,56383702201,56384601132,56384601133,56384601122,56384601123,56383623230,56383623232,56384601010,56384601012,56384601013,56383621310,56383621311,56383621312,56383630200,56383630201,56383630203,56383630230,56383630231,56383623100,56383623102,56384603230,56384603231,55387721103,56380700023,55387722223,55387722220,55387722001,55387721013,56384603222,56384603220,
041,00,/,499387500,134625000,503057812,137025000,14,36,74,100,223,525,563847,563857,563931,563932,563933,563940,563943,563950,563930,563921,563922,563856,563867,563960,5638463,5639232,5639233,5639242,5639410,5639411,5639412,5639420,5639421,5639423,5639440,5639442,5639443,5639530,5639531,5639540,5639541,5638371,5639203,5639202,5639122,5639113,5639112,5638373,5638372,5639710,5639612,5639613,5639701,5639712,5639703,5638771,5638661,5639700,5638462,5739010,56383631,56383632,56383633,56384611,56384613,56391232,56391233,56391322,56392300,56392302,56392303,56392312,56392313,56392402,56392403,56393400,56393402,56393420,56393422,56394130,56394131,56394132,56394220,56394221,56394410,56394412,56395100,56395101,56395102,56395120,56395122,56395211,56395213,56395320,56395321,56395431,56395500,56395502,56395520,56395521,56395523,56395532,56396100,56396102,56397130,56391103,56391102,56391101,56392013,56382733,56382732,56383701,56383703,56397112,56397110,56397111,56384610,56397021,56397132,57390110,56397020,56397023,56386631,56384533,56384531,56386601,56387701,56385511,57390112,57390130,57390011,57390010,56387731,56385513,563836132,563836233,563846121,563846123,563912302,563912303,563912312,563912313,563913202,563913203,563923012,563924013,563924102,563934010,563934011,563934012,563934030,563934032,563934210,563934212,563934230,563934232,563934233,563941330,563941331,563942220,563942231,563942233,563944130,563944132,563945220,563945222,563945223,563951030,563951032,563951100,563951101,563951102,563951210,563951232,563952011,563952100,563952101,563952103,563952311,563952313,563953220,563953221,563953300,563954211,563954300,563954301,563954303,563954331,563955030,563955032,563955033,563955220,563955221,563955300,563955302,563961030,563961032,563920031,563911122,563911123,563911120,563911102,563911100,563911001,563911003,563911002,563910131,563910133,563910311,563910313,563910331,563920123,563920122,563920033,563920032,563920023,563827303,563827231,563827233,563827232,563837001,563837003,563837021,563837023,563962220,563962202,563971310,563971130,563971132,563961132,563961123,563961122,563961033,563836133,5638361302,5638362311,5638362313,5638363011,5638363013,5638363031,5638363033,5638370222,5638460110,5638460111,5638461201,5638461203,5638461221,5638461223,5639120232,5639123000,5639123002,5639123003,5639123011,5639123012,5639123013,5639132002,5639132003,5639132012,5639132013,5639230132,5639230133,5639231022,5639231103,5639231121,5639231122,5639231123,5639231130,5639231132,5639231133,5639240022,5639240023,5639240032,5639240033,5639240122,5639240123,5639241002,5639241032,5639241200,5639241201,5639241202,5639241220,5639243002,5639243020,5639243022,5639243200,5639243202,5639343220,5639343222,5639343223,5639343232,5639413320,5639413322,5639413331,5639422210,5639422211,5639422212,5639422220,5639422221,5639422300,5639422301,5639422303,5639422321,5639422323,5639441102,5639441120,5639441122,5639441123,5639441312,5639441330,5639441332,5639441333,5639452022,5639452212,5639510310,5639510311,5639510312,5639510330,5639510332,5639511030,5639511031,5639511032,5639511100,5639511200,5639512302,5639512303,5639512312,5639512330,5639520101,5639521020,5639521021,5639521023,5639521210,5639521211,5639521213,5639521231,5639521233,5639523100,5639523101,5639523103,5639523121,5639523311,5639523313,5639533010,5639533020,5639542000,5639542100,5639542101,5639542103,5639543020,5639543021,5639543023,5639543301,5639543331,5639550120,5639550122,5639550123,5639550310,5639550312,5639551222,5639552220,5639552221,5639552223,5639552230,5639552231,5639552232,5639553030,5639553032,5639553033,5639553300,5639553302,5639553320,5639610120,5639610122,5639610312,5639610313,5639611202,5639650111,5639651000,5639651001,5639651003,5639651010,5639651012,5639713300,5639713302,5639713322,5639111330,5639012212,5639012203,5639012332,5639012230,5639012221,5639012223,5639012232,5639012233,5639012333,5639013222,5639111212,5639111210,5639111332,5639111323,5639111322,5639103102,5639101323,5639101321,5639101133,5639110003,5639110001,5639103101,5639103103,5639103330,5639103333,5639201131,5639201113,5639201111,5639103331,5639201132,5639201133,5638273012,5638370021,5638272303,5638273022,5638273023,5638273132,5638273131,5638271333,5638273111,5638273113,5638273133,5639200222,5639200221,5639200303,5639201202,5639201211,5639201212,5639201203,5639201213,5639200203,5638272233,5639200223,5639611203,5639622222,5639720022,5639622003,5639611302,5639611303,5639611332,5639622220,5639711311,5639711310,5639512110,5639512112,5638370223,5638273122,5639713320,5639713120,5639713121,5639713122,56383610332,56383612110,56383612112,56383612113,56383612130,56383612131,56383612333,56383613002,56383613003,56383613032,56383613033,56383613122,56383621331,56383621333,56383623033,56383623122,56383623123,56383623211,56383623213,56383630121,56383630123,56383630222,56383630301,56383630303,56383630321,56383630322,56383630323,56384612001,56384612003,56384612021,56384612023,56384612201,56384612203,56384612221,56384612223,56391202213,56391202231,56391202233,56391202302,56391202303,56391202312,56391202330,56391202332,56391202333,56391203222,56391203223,56391203232,56391203233,56391231020,56391231022,56391323222,56392301000,56392301002,56392301020,56392301022,56392301300,56392301302,56392310230,56392310232,56392310233,56392310322,56392310323,56392310331,56392310332,56392310333,56392311201,56392311203,56392311310,56392311312,56392400211,56392400213,56392400300,56392400302,56392401211,56392401213,56392410030,56392410032,56392412030,56392412032,56392412220,56392412221,56392432200,56392432201,56393401300,56393401302,56393421122,56393421300,56393421302,56393423102,56393423120,56393423122,56393423123,56393423132,56393423133,56393432022,56393432023,56393432210,56393432212,56394133210,56394133211,56394133212,56394133230,56394133232,56394133300,56394133301,56394133303,56394222130,56394222131,56394222132,56394222300,56394222301,56394223020,56394223021,56394411000,56394411002,56394411212,56394411213,56394411322,56394413100,56394413102,56394413103,56394413112,56394413130,56394413132,56394413310,56394413312,56394520002,56394520020,56394520022,56394520200,56394520202,56394520203,56394520212,56394520230,56394520232,56394520233,56394522102,56394522103,56394522130,56394522132,56394523200,56394523202,56394523220,56394523222,56395103130,56395103131,56395110330,56395110331,56395111010,56395111012,56395111020,56395111021,56395111022,56395111200,56395111202,56395112010,56395112011,56395112012,56395112020,56395112021,56395123132,56395123310,56395123312,56395201030,56395201031,56395201033,56395201301,56395201310,56395201311,56395201313,56395212011,56395212120,56395212121,56395212123,56395212301,56395212303,56395212321,56395230111,56395230113,56395231020,56395231021,56395231023,56395231231,56395233101,56395233103,56395233121,56395233123,56395233311,56395322200,56395322210,56395322211,56395322213,56395322300,56395322301,56395322302,56395323000,56395323001,56395323002,56395323010,56395323011,56395323020,56395323022,56395323100,56395323101,56395323110,56395323111,56395330110,56395330111,56395330120,56395330121,56395330210,56395330212,56395330220,56395330221,56395330222,56395331000,56395331001,56395331010,56395331011,56395331100,56395331101,56395331110,56395331111,56395420010,56395420011,56395420012,56395420100,56395420101,56395420110,56395420111,56395421020,56395421021,56395421023,56395421201,56395421210,56395421211,56395421300,56395421301,56395421303,56395421310,56395421311,56395421312,56395430221,56395432111,56395433000,56395433001,56395433301,56395433331,56395501000,56395501002,56395501020,56395501022,56395501023,56395501212,56395501213,56395501322,56395512200,56395512202,56395512230,56395512232,56395512233,56395522220,56395522221,56395522330,56395522331,56395522333,56395530122,56395530123,56395530132,56395530310,56395530312,56395530313,56395531202,56395531220,56395531222,56395533010,56395533012,56395533030,56395533031,56395533032,56395533120,56395533210,56395533220,56395533222,56396112003,56396112012,56396501010,56396501011,56396501100,56396501101,56396501103,56396501121,56396501123,56396510110,56396510112,56396510130,56396510132,56397133010,56397133012,56391202232,56391202223,56391202222,56391113333,56391113332,56391113330,56391113312,56391113122,56391113123,56391113213,56391113212,56391113203,56391113202,56391112133,56391112132,56391112130,56391112112,56391112110,56391110322,56391110320,56391110302,56391110122,56391110300,56391110120,56391110102,56390132233,56390132232,56390122201,56390122221,56390122203,56390122223,56390122013,56390122011,56390122100,56390122102,56390122132,56390122310,56390122313,56390122312,56390123220,56390123222,56390123223,56390123232,56390123233,56391100001,56391100003,56391100021,56391100023,56391011313,56391011323,56391013031,56391013032,56391031002,56391031001,56391013223,56391013221,56391013203,56391013033,56391031200,56391031201,56391031210,56391031213,56391033320,56391033323,56392011303,56392011231,56392011232,56392011223,56392011233,56391033321,56391031211,56391031003,56392012103,56392012012,56392012003,56392012002,56392003011,56392003012,56392003021,56392003022,56392002133,56392002132,56392002123,56392002120,56392002021,56392002203,56392002202,56382713321,56382713323,56382731101,56382731301,56382731303,56382731233,56382731232,56382731202,56382730133,56382730130,56382730112,56382730110,56382730103,56382730033,56382730211,56382730212,56382730132,56382730203,56382730202,56382723011,56382723012,56382723021,56382723022,56382722311,56382722313,56383700013,56383700031,56383700032,56383700023,56383700231,56383700233,56383702011,56383702013,56383702031,56383702033,56383702211,56383702213,56392003013,56392003023,56392002122,56382730213,56382723013,56382723023,56383700033,56396112122,56396112123,56396112132,56396112131,56396113122,56396113300,56396113303,56396113333,56396220022,56396220023,56396222102,56396222100,56396220322,56396222210,56396222212,56397200000,56397200002,56397200020,56397200022,56397200200,56397200203,56397200230,56397200232,56397202001,56397202002,56397113121,56397113130,56397113120,56397113300,56397113302,56397113320,56397113322,56397131100,56397113321,56397131120,56397131102,56397131122,56397113122,56397200202,56397202000,56396113302,56396112133,56396101020,56396101022,56395123320,56396101000,56396101001,56396101002,56396103100,56396103102,56396103103,56396101230,56396101232,56396101233,56395123002,56395121210,56395121211,56395121300,56395121301,56395121200,56395121201,56395121202,56395121130,56395121132,56395121110,56395121112,56383702202,56383702203,56383702212,56383613123,56383613030,56384601131,56384601130,56384601121,56384601120,56383623231,56383623233,56384601011,56384612000,56383621332,56383621313,56383630220,56383630202,56383630223,56383630232,56383630233,56383623121,56383623103,56383623101,56384603223,56384603232,56384603233,56397131230,56397131231,56397131232,
042,00,ȯ/¼,500962500,135853125,503620312,138825000,17,31,56,87,215,401,563963,563964,563973,563974,573903,573904,573914,573924,573934,573935,573944,573923,573913,573954,573902,573933,573943,5639513,5639522,5739252,5739253,5739262,5739360,5739362,5739450,5739452,5739550,5739552,5639620,5639621,5639623,5639721,5639722,5639723,5739121,5739640,5739522,5739513,5739511,5739520,5739521,5739422,5739423,5739631,5739123,5739530,5739531,5739533,56395113,56395200,56395202,56395203,56395232,56395332,56395333,56395422,56395423,56396110,56396111,56396500,57390520,57390522,57391500,57391502,57391520,57391521,57391522,57392500,57392502,57392503,57392632,57393610,57393612,57393613,57393630,57393632,57394510,57394511,57394512,57396410,56396221,56396223,56397201,56397203,57391201,57390111,57390113,57390131,57396200,57396111,57394133,57394132,57396201,57396331,57392211,57392213,57391203,57391200,57390133,57395321,57392231,57392233,57392210,57391221,563951111,563951113,563951121,563951122,563951123,563952012,563952122,563952300,563952302,563952303,563952330,563952332,563953232,563953233,563953303,563953312,563953313,563954202,563954203,563954320,563954322,563954323,563954332,563965020,563965022,563971313,563971331,563971333,563975222,573905000,573905002,573905020,573905022,573905210,573905212,573905213,573905230,573905232,573915010,573915012,573915030,573915032,573915033,573915230,573915232,573925010,573925012,573925013,573926022,573926023,573926302,573926332,573936110,573936112,573936310,573936311,573936312,573936330,573937020,573937022,573945300,573945302,573945320,573945322,573946000,573946001,573946010,573946011,573955100,573955102,573955120,573955122,573955300,573955302,573955320,573964110,573964111,573964120,563962223,563962201,563972001,563972003,563972021,563972022,563972023,563961011,563961013,5639413332,5639413333,5639422222,5639422223,5639422231,5639422232,5639422233,5639422320,5639422322,5639510331,5639511103,5639511121,5639511122,5639511123,5639511203,5639512123,5639512132,5639512133,5639512311,5639520100,5639520102,5639520132,5639520133,5639521022,5639521200,5639521202,5639521203,5639523010,5639523012,5639523013,5639523120,5639523122,5639523330,5639523332,5639523333,5639532222,5639532223,5639532231,5639532232,5639532233,5639532303,5639532312,5639532313,5639533013,5639533023,5639533102,5639533103,5639533112,5639533113,5639542002,5639542003,5639542012,5639542013,5639542122,5639542123,5639542132,5639542133,5639543210,5639543212,5639543213,5639543302,5639543303,5639543332,5639650100,5639650102,5639650103,5639650120,5639650121,5639650210,5639650212,5639650230,5639652000,5639713321,5639750022,5639750200,5639750202,5639750220,5639750222,5639752000,5639752002,5639752020,5639752022,5639752200,5639752202,5739050010,5739050012,5739050030,5739050032,5739050210,5739050212,5739050230,5739050232,5739052110,5739052112,5739052310,5739052311,5739150312,5739152310,5739152311,5739152312,5739152330,5739152332,5739250110,5739250112,5739251202,5739251220,5739251222,5739251223,5739251232,5739251332,5739251333,5739260320,5739260322,5739260323,5739263032,5739263300,5739263302,5739263303,5739263332,5739361110,5739361112,5739361130,5739361132,5739361133,5739363130,5739363132,5739363320,5739370022,5739372000,5739451300,5739451301,5739451302,5739451320,5739451322,5739453010,5739453011,5739453100,5739453232,5739460020,5739460021,5739460030,5739460031,5739461000,5739461001,5739461002,5739461010,5739461011,5739551010,5739551012,5739551030,5739551032,5739551210,5739551212,5739551230,5739551232,5739553010,5739553012,5739553030,5739553032,5739553210,5739553212,5739553213,5739553220,5739553221,5739553222,5739553230,5739641120,5739641121,5739641130,5739641131,5739641210,5739641220,5739650000,5739650001,5739650002,5739650010,5639622223,5639720021,5639622000,5639622001,5639611300,5639611301,5639611331,5639611210,5639611211,5639611310,5639611311,5639611313,5639622211,5639622212,5639622213,5639622030,5639622031,5639622033,5639720001,5639720003,5639720201,5639720202,5639720203,5639711331,5639711333,5639713111,5639713113,5639610103,5639512333,5639610101,5639610121,5639610311,5639512301,5639512310,5639512122,5639510333,5639512131,5639713323,5639713303,56394133213,56394133231,56394133233,56394133302,56394222133,56394222302,56394222303,56394223022,56394223023,56395103132,56395103133,56395110332,56395110333,56395111011,56395111013,56395111023,56395111201,56395111203,56395112013,56395112022,56395112023,56395123131,56395123133,56395123311,56395123313,56395201032,56395201300,56395201302,56395201303,56395201312,56395212010,56395212012,56395212013,56395212122,56395212300,56395212302,56395212320,56395212322,56395212323,56395230110,56395230112,56395231022,56395231230,56395231232,56395231233,56395233100,56395233102,56395233120,56395233122,56395233310,56395233312,56395233313,56395322201,56395322202,56395322203,56395322212,56395322303,56395323003,56395323012,56395323013,56395323021,56395323023,56395323102,56395323103,56395323112,56395323113,56395330112,56395330113,56395330122,56395330123,56395330211,56395330213,56395330223,56395331002,56395331003,56395331012,56395331013,56395331102,56395331103,56395331112,56395331113,56395420013,56395420102,56395420103,56395420112,56395420113,56395421022,56395421200,56395421202,56395421203,56395421212,56395421213,56395421302,56395421313,56395430220,56395430222,56395430223,56395432110,56395432112,56395432113,56395433002,56395433003,56395433300,56395433302,56395433303,56395433330,56395433332,56395433333,56395522222,56395522223,56395522332,56396112000,56396112001,56396112010,56396112011,56396112013,56396501012,56396501013,56396501102,56396501120,56396501122,56396501220,56396501221,56396501222,56396501230,56396501231,56396501300,56396502110,56396502111,56396502112,56396502130,56396502132,56396503000,56396520010,56396520012,56396520020,56396520022,56396520200,56396522000,56397133011,56397133013,56397500022,56397500200,56397500202,56397500230,56397500232,56397502010,56397502012,56397502030,56397502032,56397502210,56397502212,56397502230,56397502232,56397502233,56397520010,56397520011,56397520012,56397520030,56397520032,56397520210,56397520212,56397520230,56397520231,56397520232,56397522010,56397522012,56397522030,56397522032,56397522033,56397522322,56397522323,56397522332,57390500110,57390500112,57390500130,57390500132,57390500310,57390500312,57390500330,57390500332,57390502110,57390502112,57390502130,57390502132,57390502310,57390502312,57390502330,57390502332,57390502333,57390503222,57390503223,57390523120,57390523122,57391501300,57391501302,57391501320,57391501322,57391503100,57391503102,57391503103,57391503132,57391503133,57391512022,57392510202,57392510220,57392510222,57392512000,57392512002,57392512003,57392512012,57392512030,57392512032,57392512210,57392512212,57392513231,57392513233,57392513311,57392513313,57392602023,57392602032,57392603023,57392603210,57392603212,57392603320,57392603322,57392630020,57392630022,57392630023,57392630032,57392630033,57392630302,57392630303,57392630312,57392630330,57392630332,57392630333,57392631222,57392631223,57392631232,57392633010,57392633012,57392633013,57392633102,57392633120,57392633122,57392633300,57392633302,57393611110,57393611112,57393611130,57393611132,57393611310,57393611312,57393611313,57393631310,57393631312,57393631330,57393633100,57393633101,57393633102,57393633120,57393633122,57393633210,57393633211,57393633220,57393633221,57393633300,57393700202,57393700203,57393700232,57393700233,57393702102,57393702120,57393702122,57393702300,57393702302,57393702320,57393720020,57393720022,57394513030,57394513031,57394513032,57394513100,57394513101,57394513102,57394513110,57394513111,57394513120,57394513210,57394600220,57394600221,57394600230,57394600231,57394601311,57394601313,57394610200,57394610202,57395510112,57395510130,57395510132,57395510310,57395510312,57395510330,57395510332,57395512110,57395512112,57395512130,57395512132,57395512310,57395512312,57395512330,57395512332,57395530110,57395530112,57395532110,57395532112,57395532230,57395532232,57395533020,57395533022,57396411220,57396411221,57396411222,57396411230,57396411231,57396411320,57396411321,57396411330,57396411331,57396412110,57396412111,57396413000,57396500030,57396500032,57396500200,57396500201,57396500202,57396500210,57396500220,56396112120,56396112121,56396112130,56396113120,56396113121,56396113123,56396113301,56396113330,56396113331,56396113332,56396220020,56396220021,56396222101,56396222103,56396220320,56396220321,56396220323,56396222211,56396222213,56397200001,56397200003,56397200021,56397200023,56397200201,56397200231,56397200233,56397202003,56397113123,56397113131,56397113132,56397113133,56397113301,56397113303,56397113323,56397131101,56397131103,56397131121,56397131123,56396101021,56396101023,56395123322,56395123323,56395123321,56396101003,56396112002,56396103101,56396101231,56395123001,56395123130,56395123003,56395123000,56395121212,56395121213,56395121302,56395121303,56395121203,56395121133,56395121131,56395121113,56395121111,56397131233,
043,00,,497362500,135975000,499050000,138150000,10,24,38,0,0,0,563873,573802,573812,563872,573803,573823,573813,573804,563862,563863,5738221,5738331,5738333,5738330,5738223,5738013,5738111,5738011,5638713,5638611,5638513,5638522,5638523,5638742,5738342,5738340,5738242,5738141,5638740,5738140,5738220,5638532,5638642,5738240,57383211,57383321,57383323,57382221,57381131,56387112,56387113,56385123,56385121,56386101,56385113,56385112,56385202,56385203,56385212,56385213,57384400,57384311,57384310,57384401,57384402,57384313,56387432,56387430,56387412,56387433,56386131,56387111,56386133,57381133,57380103,56387123,57380101,56385332,56386402,56387410,56385103,57381422,
044,00,,503943750,127753125,505110937,128559375,0,8,15,32,72,156,5340212,5340213,5340303,5340310,5340311,5340312,5340301,5340300,53402200,53402202,53402220,53402222,53403130,53403132,53404011,53404100,53404101,53402032,53402033,53402023,53403021,53403020,53402022,534012223,534020313,534021032,534021033,534021111,534021113,534021131,534021133,534022012,534022030,534022210,534022212,534030230,534030231,534030233,534031310,534032000,534032002,534032020,534032022,534040011,534040100,534040101,534040131,534040133,534041020,534041021,534041100,534041102,534041120,533927333,533927331,5340122221,5340122223,5340203113,5340203121,5340203122,5340203123,5340210223,5340210233,5340210313,5340211101,5340211103,5340211121,5340211122,5340211123,5340211220,5340211222,5340211223,5340211232,5340211233,5340211301,5340211323,5340220102,5340220130,5340220132,5340220320,5340220322,5340222300,5340222301,5340222302,5340222320,5340302211,5340302213,5340302320,5340302321,5340302323,5340313110,5340313111,5340313120,5340313122,5340313300,5340320010,5340320011,5340320012,5340320210,5340320212,5340320230,5340320232,5340400101,5340401030,5340401031,5340401033,5340401211,5340401300,5340401301,5340401303,5340410230,5340410300,5340410301,5340410303,5340410310,5340410311,5340410313,5340411010,5340411011,5340411012,5340411030,5340411032,5340411210,5340411212,5340411220,5340411221,5340411230,53401133233,53401133322,53401133323,53401133332,53401133333,53401222032,53401222033,53401222123,53401222132,53401222133,53401222201,53401222203,53401222221,53401222222,53401222223,53402031033,53402031103,53402031111,53402031112,53402031113,53402031121,53402031122,53402031123,53402031201,53402031202,53402031203,53402102223,53402102311,53402102313,53402102322,53402102323,53402103032,53402103033,53402103121,53402103122,53402103123,53402111201,53402111203,53402112020,53402112022,53402112023,53402112210,53402112212,53402112213,53402112302,53402112303,53402112313,53402113000,53402113001,53402113030,53402113031,53402113033,53402113202,53402113211,53402113212,53402113213,53402113220,53402113222,53402113223,53402201002,53402201330,53402201332,53402203210,53402203212,53402203230,53402221300,53402221302,53402221320,53402221322,53402223030,53402223032,53402223100,53402223220,53402223221,53402223222,53403022101,53403022311,53403023220,53403023221,53403023223,53403131120,53403131210,53403131212,53403131230,53403131232,53403133010,53403133020,53403133022,53403133200,53403133202,53403133220,53403133222,53403200130,53403200300,53403200301,53403200302,53403200320,53403200322,53403200323,53403201000,53403220000,53403220001,53403220002,53403220010,53403220011,53403220100,53403220101,53404001001,53404001031,53404001033,53404010210,53404010211,53404010213,53404010231,53404010320,53404010321,53404010323,53404012101,53404012103,53404013021,53404013023,53404013210,53404013211,53404013213,53404013231,53404013233,53404031011,53404031100,53404031101,53404031110,53404031111,53404102310,53404102311,53404102320,53404103020,53404103021,53404103022,53404103120,53404103121,53404103123,53404103200,53404103311,53404110130,53404110131,53404110132,53404112110,53404112112,53404112130,53404112132,53404112230,53404112231,53404112310,53404112312,53404112320,53404112321,53404112323,
044,01,/,503521875,127912500,504576562,128868750,0,5,19,46,77,137,5339471,5339373,5339370,5339371,5339272,53393721,53393723,53394723,53394730,53394731,53394732,53404000,53404002,53404003,53404020,53404021,53404023,53404030,53404032,53404033,53405010,53405011,53392732,53392730,533937200,533937201,533937203,533937221,533937223,533947001,533947010,533947011,533947013,533947031,533947033,533947211,533947212,533947213,533947330,533947331,534030222,534040012,534040013,534040120,534040122,534040123,534040220,534040221,534040223,534040312,534040313,534041022,534041200,534041202,534041220,534041222,534050001,534050010,534050011,534050013,534050121,534051000,534051001,534051002,534030220,533927023,533927032,533927033,533927330,533927332,5339372021,5339470121,5339472101,5339472103,5339472233,5339473320,5339473321,5339570100,5339570101,5339570102,5339570110,5339570111,5339571000,5339571001,5339571010,5339571011,5339571013,5339571031,5339571102,5339571120,5340302212,5340302230,5340302232,5340302233,5340400102,5340401020,5340401022,5340401212,5340401213,5340401320,5340401322,5340402221,5340402223,5340403100,5340403102,5340403103,5340403112,5340403113,5340412030,5340412032,5340412210,5340412212,5340412230,5340412232,5340412233,5340500031,5340500120,5340500121,5340500122,5340501200,5340501201,5340501203,5340501221,5340501223,5340501230,5340501231,5340501232,5340501300,5340501301,5340501302,5340501310,5340501311,5340503001,5340510030,5339361133,5339361111,5339361131,5339361113,5339263333,5339263313,5339263331,5339263311,5339263133,5339263131,5339270221,5339270222,5339270223,53393613331,53393613333,53393631111,53393720201,53393720231,53393720233,53394700310,53394700311,53394701200,53394701201,53394701203,53394701230,53394701231,53394701233,53394703233,53394720313,53394720331,53394720333,53394721003,53394721021,53394721022,53394721023,53394722313,53394733220,53394733222,53394733300,53394733302,53395701030,53395701031,53395701032,53395701120,53395701200,53395701201,53395710031,53395710120,53395710121,53395710123,53395710301,53395710330,53395710331,53395711000,53395711002,53395711220,53395711221,53395711223,53403022103,53403022310,53403022312,53403022313,53403023222,53404001000,53404001002,53404001003,53404001030,53404001032,53404010212,53404010230,53404010232,53404010233,53404010322,53404012100,53404012102,53404013020,53404013022,53404013212,53404013230,53404013232,53404022201,53404031010,53404031012,53404031013,53404031102,53404031103,53404031112,53404031113,53404120120,53404120122,53404120123,53404122312,53405000011,53405000013,53405000031,53405000301,53405000303,53405000330,53405000331,53405000333,53405001230,53405001231,53405001233,53405003101,53405003110,53405003111,53405003113,53405012020,53405012021,53405012023,53405012201,53405012203,53405012221,53405012223,53405012330,53405012332,53405013030,53405013031,53405013032,53405013120,53405013121,53405013130,53405013131,53405013200,53405013201,53405030001,53405030100,53405030101,53405030102,53405100310,53405100311,53405100312,53405100320,53405100322,53405101002,53405101020,53405101022,53405102000,53405102001,53405102002,53405102010,53405102011,53403022102,53403022100,53393613313,53393613311,53393613133,53393613113,53393613131,53393613111,
045,00,ڹ,503100000,126534375,504942187,128025000,5,12,32,58,122,280,524070,534000,533907,534010,533917,5239773,5240600,5240602,5240603,5240712,5340010,5340012,5340201,5340200,5339063,5339271,5339062,52397711,52397712,52397713,52397721,52397723,52406010,52406012,52406013,52406102,52407100,52407102,52407103,52407132,53401100,53401102,53401120,53401122,53401123,53401132,53402100,53402101,53402110,53390613,53402021,53402020,53402030,53392731,53392701,53391613,53391611,53391610,53392700,523967311,523967313,523967323,523967331,523967332,523967333,523977031,523977033,523977101,523977102,523977103,523977203,523977221,523977222,523977223,524050222,524050223,524050232,524050233,524060112,524060113,524061200,524061202,524061220,524061222,524061223,524071010,524071012,524071122,524071300,524071302,524071303,524071312,533906113,534001100,534001101,534001102,534001120,534001122,534001300,534011010,534011012,534011030,534011031,534011032,534011210,534011212,534011213,534011302,534011330,534011331,534021020,534021021,534021121,533906123,533927031,533927030,533927021,5239573313,5239671313,5239671331,5239671332,5239671333,5239673103,5239673121,5239673123,5239673212,5239673301,5239673302,5239673303,5239763331,5239763333,5239770131,5239770132,5239770133,5239770301,5239770303,5239770321,5239770322,5239770323,5239771002,5239771003,5239772011,5239772012,5239772013,5239772201,5239772202,5239772203,5240502202,5240502203,5240502212,5240503222,5240601100,5240601102,5240610022,5240610033,5240610120,5240610122,5240610300,5240610302,5240612010,5240612012,5240612030,5240612032,5240612210,5240612212,5240612213,5240612322,5240710110,5240710112,5240710130,5240710132,5240711200,5240711202,5240711203,5240711230,5240711232,5240713012,5240713013,5240713102,5240713103,5240713300,5240713302,5240713320,5339061111,5339061112,5339061113,5339061121,5339061123,5340011030,5340011032,5340011210,5340011212,5340013010,5340013012,5340013020,5340013021,5340013022,5340013200,5340013202,5340110110,5340110111,5340110112,5340110130,5340110132,5340110133,5340110330,5340110332,5340112110,5340112112,5340112113,5340113002,5340113003,5340113030,5340113032,5340113320,5340113321,5340113322,5340113330,5340113331,5340122200,5340122202,5340203100,5340203101,5340203102,5340210220,5340210221,5340210230,5340210300,5340210301,5340210302,5340210310,5340210311,5340211100,5340211102,5340211200,5340211201,5340211203,5340211302,5339061213,52395733112,52395733113,52395733310,52395733311,52395733313,52395733331,52395733333,52396711111,52396711113,52396711131,52396711133,52396711311,52396711313,52396711331,52396711333,52396713111,52396713112,52396713113,52396713123,52396713301,52396713303,52396731011,52396731012,52396731013,52396732131,52396732132,52396732133,52396732211,52396732213,52396732231,52396732233,52396733002,52396733003,52397633133,52397633303,52397633321,52397633323,52397701131,52397701133,52397701231,52397701232,52397701233,52397701303,52397702313,52397702331,52397702333,52397703021,52397703023,52397703201,52397703202,52397703203,52397710011,52397710012,52397710013,52397720031,52397720033,52397720102,52397720103,52397720211,52397720213,52397720231,52397720232,52397720233,52397722003,52405022002,52405022003,52405022012,52405022013,52405022102,52405022103,52405022130,52405022132,52405022133,52405023022,52405023023,52405023032,52405023033,52405023122,52405023123,52405032232,52405032323,52405032332,52405032333,52405033222,52405033223,52406011010,52406011012,52406011030,52406011032,52406011033,52406011122,52406011123,52406011132,52406100133,52406100230,52406100232,52406100233,52406100303,52406100311,52406100312,52406100313,52406100321,52406100322,52406100323,52406101022,52406101023,52406101032,52406101210,52406101212,52406101230,52406101232,52406103010,52406103200,52406103202,52406103220,52406120110,52406120111,52406120112,52406120130,52406120332,52406122110,52406122112,52406122113,52406123022,52406123200,52406123202,52406123203,52406123230,52406123232,52406123233,52406123322,52406123323,52407101112,52407101130,52407101132,52407101310,52407101312,52407101330,52407101332,52407101333,52407110222,52407112010,52407112012,52407112122,52407130100,52407130101,52407130102,52407130112,52407130113,52407131002,52407131003,52407131120,52407131122,52407131300,52407131302,52407133010,52407133011,52407133012,52407133030,52407133032,52407133220,52407133222,53390611013,53390611031,53390611032,53390611033,53390611101,53390611102,53390611103,53390612113,53400110310,53400110312,53400110330,53400110332,53400111000,53400111002,53400112110,53400112112,53400112130,53400112132,53400112300,53400112301,53400112302,53400112310,53400112320,53400112322,53400112323,53400130230,53400130232,53400130300,53400130301,53400130302,53400132010,53400132030,53400132032,53400132200,53400132201,53400132202,53400132220,53400132222,53401101130,53401101132,53401101310,53401101312,53401101313,53401103310,53401103311,53401103312,53401103330,53401110000,53401110202,53401110220,53401110222,53401112000,53401112002,53401112020,53401112022,53401112200,53401121112,53401121113,53401130002,53401130330,53401130332,53401131223,53401131232,53401131233,53401131322,53401131323,53401131332,53401131333,53401133230,53401133231,53401133232,53401133320,53401133321,53401133330,53401133331,53401220222,53401222030,53401222200,53401222202,53401222220,53402031030,53402031031,53402031032,53402031100,53402031101,53402031102,53402031110,53402031120,53402031200,53402102220,53402102221,53402102222,53402102310,53402102312,53402102320,53402102321,53402103030,53402103031,53402103120,53402111200,53402111202,53402112021,53402112211,53402112300,53402112301,53402112310,53402112311,53402112312,53402113002,53402113003,53402113032,53402113200,53402113201,53402113203,53402113210,53402113221,53390612112,53390611223,
046,00,˼,502987500,125475000,503985937,127350000,2,16,37,27,77,152,523936,523946,5239470,5239472,5239570,5239572,5239670,5239672,5239263,5239561,5239563,5239661,5239663,5239761,5239762,5239272,5239660,5339060,52393700,52393702,52393720,52393722,52393723,52395732,52396710,52396712,52396730,52397631,52397700,52392613,52392621,52392623,52392702,52392703,52392612,52393513,52393531,52393533,52393511,52392622,52395601,52395603,52395621,52395623,52395622,52396621,52397603,52397601,52397630,52397632,53390610,52396623,52392712,52397602,52397531,523937010,523937012,523957100,523957102,523957103,523957120,523957330,523957332,523967110,523967112,523967130,523967132,523967320,523976330,523976332,523977010,523977020,523977021,523977022,523927300,533906120,533906122,523975331,523926033,523926203,523926032,523926202,5239370110,5239370112,5239370130,5239370132,5239370300,5239370301,5239370302,5239370310,5239370320,5239372102,5239372120,5239372122,5239373222,5239471000,5239471002,5239471220,5239471222,5239473000,5239473001,5239473002,5239473022,5239473200,5239473202,5239473220,5239473222,5239571012,5239571013,5239571210,5239571211,5239571212,5239571220,5239571221,5239571223,5239571230,5239571300,5239573022,5239573310,5239573312,5239573330,5239573332,5239671110,5239671112,5239671130,5239671132,5239671310,5239673100,5239673102,5239673120,5239673122,5239673210,5239673211,5239673220,5239673222,5239763310,5239763311,5239763312,5239770110,5239770111,5239770112,5239770120,5239770121,5239770122,5239770230,5239770232,5239770300,5239771000,5239772000,5239772001,5239772002,5239772020,5239772022,5339061100,5339061102,5339061120,5239273020,5339061212,5339061210,52393701110,52393701332,52393703030,52393703110,52393703220,52393703221,52393703222,52393721000,52393721002,52393721003,52393721210,52393721212,52393721230,52393721232,52393721233,52393721322,52393721323,52393721332,52393721333,52393732022,52393732200,52393732202,52393732203,52393732230,52393732232,52394710010,52394710200,52394710202,52394710220,52394710222,52394712000,52394712002,52394712020,52394712022,52394712212,52394712230,52394712232,52394712233,52394730030,52394730032,52394730200,52394730201,52394730202,52394730232,52394732010,52394732012,52394732030,52394732032,52394732210,52394732212,52394732230,52394732232,52394732233,52395710102,52395710103,52395710112,52395711220,52395711222,52395712130,52395712131,52395712132,52395712220,52395712221,52395712222,52395712310,52395712320,52395712322,52395713020,52395730000,52395730020,52395730022,52395730200,52395730202,52395730232,52395733312,52395733330,52395733332,52396711110,52396711112,52396711130,52396711132,52396711310,52396711312,52396711330,52396711332,52396713110,52396713120,52396713121,52396713122,52396713300,52396713302,52396731010,52396732130,52396732210,52396732212,52396732230,52396732232,52396733000,52396733001,52397633130,52397633131,52397633132,52397633300,52397633301,52397633302,52397633320,52397633322,52397701130,52397701132,52397701230,52397701300,52397701301,52397701302,52397702310,52397702311,52397702312,52397702330,52397702332,52397703020,52397703022,52397703200,52397710010,52397720030,52397720032,52397720100,52397720101,52397720210,52397720212,52397720230,52397722000,52397722001,52397722002,53390611010,53390611011,53390611012,53390611030,53390611100,53390611220,53390611221,53390611222,53390612111,53390612110,52392730222,52392730221,52392730212,52392730211,52392730122,52392730210,52392730220,52392730120,52392730100,52392730102,
047,00,˼,503676562,125550000,505687500,127237500,2,17,48,46,102,228,524062,524051,5240500,5240611,5240613,5240720,5240721,5240723,5240730,5240632,5240630,5240523,5240520,5240522,5240501,5240403,5240402,5240400,5239371,52393730,52394713,52394731,52394733,52395731,52405020,52405021,52405030,52405031,52406121,52407111,52407113,52407220,52407221,52407320,52407321,52406332,52407310,52407312,52407330,52405322,52405323,52406312,52406330,52406310,52405320,52405212,52405213,52404133,52404132,52404122,52404123,52404120,52404013,52404012,52394711,52393733,52403022,52403020,52393731,52392732,52392733,52403000,52403002,52403023,52404010,52407332,52392731,523937033,523937211,523937321,523937323,523947101,523947103,523947121,523947123,523947301,523947303,523947321,523947323,523957110,523957111,523957113,523957131,523957132,523957133,523957301,523957303,524050320,524050321,524050330,524050331,524050333,524061000,524061011,524061013,524061031,524061033,524061231,524071100,524071101,524071103,524071331,524072231,524072233,524073220,524073221,534002101,534002110,524073230,524073231,523927303,524020220,524020222,5239370113,5239370131,5239370312,5239370313,5239370321,5239370323,5239372101,5239372103,5239372130,5239372131,5239373200,5239373201,5239373203,5239373221,5239471003,5239471021,5239471023,5239471201,5239471203,5239473021,5239571120,5239571121,5239571123,5239571233,5239571301,5239571303,5239573001,5239573003,5239573021,5240502211,5240502300,5240502301,5240502310,5240502311,5240502313,5240503220,5240503221,5240503230,5240503231,5240503320,5240503321,5240503323,5240601110,5240601111,5240610010,5240610011,5240610012,5240610020,5240610021,5240610100,5240610101,5240610303,5240610321,5240610323,5240612031,5240612300,5240612301,5240612303,5240612321,5240612330,5240612331,5240612333,5240711020,5240711021,5240711023,5240711210,5240711211,5240711213,5240711231,5240711233,5240713101,5240713110,5240713111,5240713113,5240713131,5240713132,5240713133,5240722200,5240722201,5240722202,5240722300,5240722301,5240722303,5240722321,5240732220,5240732221,5240732230,5240732231,5240732232,5340021000,5340021001,5340021003,5340021110,5340021111,5340021112,5240732320,5240732321,5240732330,5240732331,5239273013,5239273023,5239273011,52393701111,52393701112,52393701113,52393701330,52393701331,52393701333,52393703031,52393703032,52393703033,52393703111,52393703112,52393703113,52393703223,52393721001,52393721211,52393721213,52393721231,52393721320,52393721321,52393721330,52393721331,52393732020,52393732021,52393732023,52393732201,52393732231,52393732233,52394710011,52394710012,52394710013,52394710201,52394710203,52394710221,52394710223,52394712001,52394712003,52394712021,52394712023,52394712210,52394712211,52394712213,52394712231,52394730031,52394730033,52394730203,52394730230,52394730231,52394730233,52394732011,52394732013,52394732031,52394732033,52394732211,52394732213,52394732231,52395710100,52395710101,52395710110,52395710111,52395710113,52395711221,52395711223,52395712133,52395712223,52395712311,52395712312,52395712313,52395712321,52395712323,52395713021,52395713022,52395713023,52395730001,52395730002,52395730003,52395730021,52395730023,52395730201,52395730203,52395730230,52395730231,52395730233,52395733110,52395733111,52405022000,52405022001,52405022010,52405022011,52405022100,52405022101,52405022131,52405023020,52405023021,52405023030,52405023031,52405023120,52405023121,52405032230,52405032231,52405032233,52405032320,52405032321,52405032322,52405032330,52405032331,52405033220,52405033221,52406011011,52406011013,52406011031,52406011120,52406011121,52406011130,52406011131,52406011133,52406100130,52406100131,52406100132,52406100231,52406100300,52406100301,52406100302,52406100310,52406100320,52406101020,52406101021,52406101030,52406101031,52406101033,52406101211,52406101213,52406101231,52406101233,52406103011,52406103012,52406103013,52406103201,52406103203,52406103221,52406103222,52406103223,52406120113,52406120131,52406120132,52406120133,52406120330,52406120331,52406120333,52406122111,52406123020,52406123021,52406123023,52406123201,52406123231,52406123320,52406123321,52407101110,52407101111,52407101113,52407101131,52407101133,52407101311,52407101313,52407101331,52407110220,52407110221,52407110223,52407112011,52407112013,52407112120,52407112121,52407112123,52407130103,52407130110,52407130111,52407131000,52407131001,52407131121,52407131123,52407131301,52407131303,52407133013,52407133031,52407133310,52407133311,52407133313,52407222100,52407222101,52407222110,52407222111,52407222113,52407222200,52407222201,52407222202,52407223021,52407223231,52407223233,52407322220,52407322221,52407322222,52407322230,52407322231,52407322233,52407322330,52407322331,53400201100,53400201101,53400201110,53400201111,53400201113,53400210020,53400210021,53400210023,53400211130,53400211131,53400211132,53400300000,53400300002,53400300011,53400300020,53400300100,52407323220,52392730223,52392730213,52392730123,52392730121,52392730101,52392730103,
048,00,и/彽Τ,504646875,127134375,505912500,128268750,1,10,32,42,89,220,534023,5340022,5340023,5340120,5340121,5340123,5340221,5340132,5340133,5340130,5340032,53400113,53400131,53400133,53400200,53400202,53400203,53400212,53400213,53401111,53401113,53401221,53401223,53402230,53402231,53402233,53403211,53403300,53403301,53403310,53402420,53402402,53402400,53401312,53400330,53400332,53401310,53400303,53400302,53400301,53400312,53401313,53400310,524072223,534001111,534001112,534001113,534001321,534001323,534002010,534002012,534002013,534002102,534002103,534002112,534002113,534003002,534011101,534011103,534011121,534011123,534011301,534011310,534011311,534012200,534012201,534012203,534022011,534022031,534022033,534022211,534022320,534022321,534022323,534032101,534032103,534032122,534032123,534033021,534033023,534033030,534033031,534033120,534024220,534003003,5240713321,5240713323,5240713330,5240713332,5240713333,5240722203,5240722212,5240722213,5240722221,5240722222,5240722223,5240722320,5240722322,5340011101,5340011102,5340011103,5340011233,5340013011,5340013013,5340013031,5340013032,5340013033,5340013221,5340013223,5340020112,5340020113,5340030003,5340030012,5340111001,5340111002,5340111003,5340111021,5340111023,5340111201,5340111203,5340111221,5340111222,5340111223,5340113001,5340113031,5340113120,5340113121,5340113130,5340113131,5340122020,5340122021,5340122023,5340122201,5340122210,5340122211,5340220101,5340220103,5340220131,5340222131,5340222133,5340222311,5340222312,5340222313,5340223220,5340223221,5340223223,5340321023,5340321201,5340321202,5340321203,5340321210,5340321212,5340330200,5340330201,5340330320,5340330321,5340330322,5340330330,5340330331,5340331100,5340331101,5340331102,5340331210,5340331211,5340331212,5340331220,5340331221,5340242210,5340242220,5340030011,5340030013,5240732333,5240732332,5240732323,52407133033,52407133221,52407133223,52407133312,52407222102,52407222103,52407222112,52407222203,52407223020,52407223022,52407223023,52407223230,52407223232,52407322223,52407322232,52407322332,53400110311,53400110313,53400110331,53400110333,53400111001,53400111003,53400112111,53400112113,53400112131,53400112133,53400112303,53400112311,53400112312,53400112313,53400112321,53400130231,53400130233,53400130303,53400132011,53400132012,53400132013,53400132031,53400132033,53400132203,53400132221,53400132223,53400201102,53400201103,53400201112,53400210022,53400211133,53400300001,53400300003,53400300010,53400300012,53400300013,53400300021,53400300022,53400300023,53400300101,53400300102,53400300103,53401101131,53401101133,53401101311,53401103313,53401103331,53401103332,53401103333,53401110001,53401110002,53401110003,53401110200,53401110201,53401110203,53401110221,53401110223,53401112001,53401112003,53401112021,53401112023,53401112201,53401112202,53401112203,53401121110,53401121111,53401130000,53401130001,53401130003,53401130331,53401130333,53401131220,53401131221,53401131222,53401131230,53401131231,53401131320,53401131321,53401131330,53401131331,53401220220,53401220221,53401220223,53401222031,53401222120,53401222121,53401222122,53401222130,53401222131,53402201000,53402201001,53402201003,53402201331,53402201333,53402203211,53402203213,53402203231,53402203232,53402203233,53402221301,53402221303,53402221321,53402221323,53402223031,53402223033,53402223101,53402223102,53402223103,53402223311,53402223313,53402223331,53402232220,53402232221,53403203113,53403203131,53403203133,53403203311,53403203313,53403203331,53403210011,53403210013,53403210031,53403210033,53403210203,53403210211,53403210212,53403210213,53403210221,53403210223,53403212001,53403212002,53403212003,53403212112,53403212130,53403212132,53403212133,53403213001,53403213010,53403213011,53403213100,53403213101,53403213110,53403213111,53403230001,53403230010,53403230011,53403230100,53403230101,53403230110,53403230111,53403302031,53403302033,53403302211,53403302213,53403302231,53403302233,53403303230,53403303231,53403303232,53403303320,53403303321,53403303330,53403303331,53403311030,53403311031,53403311100,53403311101,53403311102,53403311110,53403311120,53403311200,53403311202,53403312130,53403312131,53403312132,53403312220,53403312221,53403312230,53403312300,53403312301,53403312302,53403320011,53403320100,53403320101,53403320110,53403320111,53403321000,53403321001,53403321003,53403321010,53403321012,53402422212,53402422211,53402422122,53402422121,53402422112,53402422111,53402422110,53402422120,53402422210,52407322333,52407323222,52407323221,52407323223,
048,01,ȬԾ,505504687,128025000,506812500,128859375,1,8,16,31,68,166,534034,5340333,5340440,5340441,5340443,5340452,5340451,5340450,5340352,53403313,53404311,53404420,53404421,53404423,53404530,53404532,53405411,53405500,53405501,53403533,53403532,53403622,53403502,53402432,53402423,534033113,534033211,534033213,534033231,534033233,534043100,534043101,534043103,534043130,534043131,534043133,534043311,534044220,534044221,534044223,534045310,534045312,534045313,534054101,534054131,534055020,534055021,534055022,534055100,534055101,534055102,534046020,534046002,534046001,534046000,534024223,5340242222,5340331113,5340331121,5340331122,5340331123,5340331231,5340331232,5340331233,5340430110,5340430111,5340430113,5340430131,5340431020,5340431021,5340431023,5340431210,5340431211,5340431320,5340431321,5340431323,5340433101,5340433103,5340433131,5340433133,5340442221,5340442223,5340453110,5340453112,5340453113,5340453300,5340453302,5340453311,5340453313,5340453320,5340453322,5340460220,5340540001,5340540003,5340540010,5340540012,5340540100,5340540101,5340540102,5340540110,5340540111,5340541001,5340541003,5340541030,5340541031,5340541033,5340541300,5340541301,5340541302,5340550230,5340550231,5340550300,5340550302,5340550311,5340550320,5340551030,5340551032,5340551100,5340551101,5340551200,5340551201,5340551202,5340242223,5340242213,53403303233,53403303322,53403303323,53403303332,53403303333,53403311032,53403311033,53403311103,53403311111,53403311112,53403311113,53403311121,53403311122,53403311123,53403311201,53403311203,53403312133,53403312222,53403312223,53403312231,53403312232,53403312233,53403312303,53403321011,53403321013,53403321031,53403321033,53403321211,53403321213,53403321231,53403321233,53403323011,53403323013,53403323031,53403323033,53403323211,53403323213,53403323231,53403323233,53404301011,53404301013,53404301031,53404301120,53404301121,53404310221,53404310223,53404312001,53404312010,53404312011,53404312013,53404312130,53404312131,53404312133,53404313221,53404313223,53404331211,53404331300,53404331301,53404331303,53404331321,53404333110,53404333111,53404422201,53404422203,53404422221,53404531110,53404531112,53404533010,53404533011,53404533012,53404533030,53404533032,53404533100,53404533101,53404533103,53404533210,53404533212,53404533230,53404533232,53404533233,53404533310,53404533311,53404533313,53404602102,53404602120,53404602122,53404602210,53404602211,53404602212,53404620020,53404620022,53404620200,53404620202,53404620220,53404620222,53404622000,53404622002,53404622020,53404622022,53404622200,53404622202,53405400003,53405400021,53405400110,53405400111,53405400113,53405400131,53405400133,53405401030,53405401120,53405401121,53405401123,53405401130,53405410000,53405410001,53405410003,53405410021,53405410211,53405410213,53405410231,53405410320,53405410321,53405410323,53405412110,53405412111,53405412113,53405413030,53405413032,53405413311,53405413313,53405502320,53405502331,53405502333,53405503010,53405503011,53405503012,53405503030,53405503032,53405503101,53405503130,53405503131,53405503133,53405503220,53405503222,53405510310,53405510312,53405510330,53405510332,53405511020,53405511021,53405511022,53405511030,53405512030,53405512100,53405512101,53405520000,53405520001,53405520010,53404602100,53404600322,53404600320,53404600302,53404600300,53402422213,53402422123,53402422113,
049,00,/,504506250,128062500,505659375,129140625,2,3,21,43,135,285,534042,534052,5340413,5340432,5340511,53403221,53403222,53403223,53403231,53403232,53403233,53403322,53404111,53404113,53404121,53404123,53404300,53404302,53404303,53405130,53405131,53405133,53405300,53405302,53406200,53406201,534031313,534031331,534031333,534032011,534032012,534032013,534032030,534032032,534032132,534032133,534032202,534032203,534032302,534032303,534033202,534033203,534043012,534043122,534051011,534051012,534051013,534051030,534051031,534051033,534051213,534051321,534051323,534053010,534053012,534053200,534053202,534053220,534053222,534062021,534062030,534062100,534062101,534061100,534061101,534061103,534061110,534061111,534061112,5340222321,5340222323,5340222330,5340222332,5340313113,5340313303,5340313321,5340313323,5340320031,5340320033,5340320101,5340320102,5340320103,5340320211,5340320213,5340320231,5340320233,5340320310,5340320312,5340320330,5340320332,5340321000,5340321002,5340321302,5340321303,5340321312,5340321313,5340322002,5340322003,5340322011,5340322012,5340322013,5340323002,5340323003,5340323012,5340323013,5340330202,5340330220,5340330222,5340332000,5340332002,5340332003,5340332012,5340332013,5340332102,5340332120,5340332122,5340332300,5340332302,5340332320,5340332322,5340410233,5340410321,5340410322,5340410323,5340410330,5340410332,5340410333,5340411031,5340411033,5340411222,5340411233,5340412010,5340412011,5340412013,5340412031,5340412033,5340412211,5340412213,5340430100,5340430102,5340430130,5340430132,5340430133,5340431202,5340431203,5340431212,5340431230,5340433000,5340510033,5340510101,5340510103,5340510211,5340512111,5340512113,5340512301,5340512310,5340512311,5340512313,5340513200,5340513201,5340513223,5340530110,5340530112,5340530130,5340530132,5340532010,5340532012,5340532030,5340532210,5340532212,5340532230,5340532232,5340532233,5340610112,5340610113,5340610131,5340611210,5340611211,5340620201,5340620231,5340620320,5340620321,5340621020,5340621021,5340621022,5340621030,5340621100,5340621101,5340621102,5340621110,5340621111,5340621200,5340630000,5340630001,5340630010,5340630011,5340611020,5340611021,5340611023,5340611130,5340611131,5340620310,5340620311,5340620312,53402223223,53402223310,53402223312,53402223330,53402223332,53402223333,53402232222,53402232223,53403131121,53403131122,53403131123,53403131211,53403131213,53403131231,53403131233,53403133011,53403133012,53403133013,53403133021,53403133023,53403133201,53403133203,53403133221,53403133223,53403200131,53403200132,53403200133,53403200303,53403200321,53403201001,53403201002,53403201003,53403203110,53403203111,53403203112,53403203130,53403203132,53403203310,53403203312,53403203330,53403203332,53403203333,53403210010,53403210012,53403210030,53403210032,53403210200,53403210201,53403210202,53403210210,53403210220,53403210222,53403212000,53403212110,53403212111,53403212113,53403212131,53403213000,53403213002,53403213003,53403213012,53403213013,53403213102,53403213103,53403213112,53403213113,53403220003,53403220012,53403220013,53403220102,53403220103,53403230000,53403230002,53403230003,53403230012,53403230013,53403230102,53403230103,53403230112,53403230113,53403302030,53403302032,53403302210,53403302212,53403302230,53403302232,53403320010,53403320012,53403320013,53403320102,53403320103,53403320112,53403320113,53403321002,53403321030,53403321032,53403321210,53403321212,53403321230,53403321232,53403323010,53403323012,53403323030,53403323032,53403323210,53403323212,53403323230,53403323232,53404102312,53404102313,53404102321,53404102322,53404102323,53404103023,53404103122,53404103201,53404103202,53404103203,53404103310,53404103312,53404103313,53404110133,53404112111,53404112113,53404112131,53404112133,53404112232,53404112233,53404112311,53404112313,53404112322,53404120121,53404122310,53404122311,53404122313,53404301010,53404301012,53404301030,53404301032,53404301033,53404301122,53404301123,53404310220,53404310222,53404312000,53404312002,53404312003,53404312012,53404312320,53404312321,53404312322,53404330010,53404330011,53404330012,53404330020,53404330021,53404330200,53404330202,53404330220,53404330222,53404332000,53404332002,53404332020,53404332202,53405100313,53405100321,53405100323,53405101000,53405101001,53405101003,53405101021,53405101023,53405102101,53405102130,53405102131,53405103231,53405103233,53405121100,53405121101,53405121103,53405121121,53405121123,53405121232,53405121233,53405123031,53405123120,53405123121,53405123123,53405123301,53405123310,53405123311,53405132020,53405132021,53405132030,53405132031,53405132033,53405132211,53405132213,53405132222,53405132223,53405301110,53405303000,53405303001,53405303002,53405303010,53405303011,53405303020,53405303022,53405303100,53405303101,53405303200,53405303202,53405303220,53405320320,53405320321,53405320322,53405322110,53405322112,53405322130,53405322132,53405322310,53405322312,53405322313,53405323222,53406101031,53406101033,53406101103,53406101111,53406101112,53406101113,53406101301,53406112010,53406112011,53406113010,53406202330,53406202331,53406203300,53406210230,53406210231,53406210232,53406210310,53406210311,53406210312,53406210320,53406210321,53406211030,53406211031,53406211032,53406211130,53406211131,53406211200,53406212010,53406212012,53406212020,53406212021,53406212030,53406300020,53406300021,53406301000,53406301002,53406110220,53406110221,53406110223,53406113000,53406113001,53406113002,53406111320,53406111321,53406111330,53406111331,53406111333,53406202000,53406202001,53406202003,53406202030,53406202031,53406202033,53406202300,53406202301,53406202303,53406203220,53406203221,53406203130,53406203131,53406203132,
050,00,ĸҼ,505167187,128400000,507262500,129440625,0,9,26,72,149,308,5340531,5340533,5340542,5340543,5340631,5340640,5340641,5340642,5340461,53404621,53404630,53404631,53405321,53405402,53405403,53405521,53405522,53405523,53405530,53406213,53406302,53406303,53406320,53406321,53406330,53406331,53406430,53406500,53407400,53404720,53404722,53404702,53404603,53404601,53404700,534043301,534043303,534043321,534043323,534043330,534043332,534043333,534046023,534046201,534046203,534046221,534046223,534046230,534046231,534046232,534046331,534053033,534053230,534053231,534053233,534054002,534054003,534054012,534054013,534054120,534054122,534054123,534054132,534055033,534055111,534055112,534055113,534055122,534055123,534055130,534055131,534055132,534055201,534055202,534055203,534056000,534056001,534056002,534062113,534062121,534062311,534062313,534063002,534063003,534063011,534063012,534063013,534063221,534063320,534063321,534063323,534063330,534063331,534064310,534064312,534064320,534064321,534064322,534065010,534065011,534074010,534074011,534074021,534055320,534055321,534055322,534046333,5340431231,5340431233,5340433003,5340433021,5340433023,5340433100,5340433102,5340433120,5340433122,5340433123,5340433201,5340433203,5340433221,5340433222,5340433223,5340433310,5340433312,5340433313,5340453312,5340453330,5340453332,5340453333,5340460222,5340460223,5340462000,5340462001,5340462003,5340462021,5340462023,5340462201,5340462203,5340462221,5340462222,5340462223,5340462330,5340462331,5340462332,5340463210,5340463211,5340530113,5340530131,5340530133,5340530303,5340530311,5340530312,5340530313,5340530321,5340530323,5340532011,5340532013,5340532031,5340532033,5340532320,5340532321,5340532323,5340541020,5340541022,5340541210,5340541212,5340541213,5340541330,5340541332,5340541333,5340550312,5340550321,5340550323,5340551211,5340551212,5340551213,5340551330,5340552002,5340552003,5340553100,5340553101,5340553102,5340553120,5340553122,5340560030,5340560100,5340560101,5340560102,5340560200,5340621033,5340621112,5340621121,5340621122,5340621123,5340621231,5340623101,5340623103,5340630003,5340630012,5340630013,5340630101,5340630102,5340630103,5340632200,5340632201,5340633221,5340633320,5340633321,5340633322,5340633333,5340643110,5340643112,5340643130,5340643230,5340643232,5340643300,5340650130,5340650200,5340650202,5340651000,5340651001,5340651002,5340651010,5340731011,5340731111,5340731113,5340740221,5340740230,5340741000,5340741001,5340632300,5340632301,5340632302,5340632310,5340632311,5340632313,5340740200,5340740201,5340740203,5340463300,5340463301,5340740120,5340740121,5340740122,5340650120,5340650121,5340553230,5340553231,5340553232,5340463200,5340463201,5340463202,5340460213,5340460211,5340460033,5340460031,53404312132,53404312323,53404313220,53404313222,53404330013,53404330022,53404330023,53404330201,53404330203,53404330221,53404330223,53404331210,53404331212,53404331213,53404331302,53404331320,53404331322,53404331323,53404332001,53404332003,53404332021,53404332022,53404332023,53404332200,53404332201,53404332203,53404333112,53404333113,53404422200,53404422202,53404422220,53404422222,53404422223,53404531111,53404531113,53404533013,53404533031,53404533033,53404533102,53404533211,53404533213,53404533231,53404533312,53404602121,53404602123,53404602213,53404620021,53404620023,53404620201,53404620203,53404620221,53404620223,53404622001,53404622003,53404622021,53404622023,53404622201,53404622203,53404623330,53404632200,53405301111,53405301112,53405301113,53405303003,53405303012,53405303013,53405303021,53405303023,53405303102,53405303103,53405303201,53405303203,53405303221,53405303222,53405303223,53405320323,53405322111,53405322113,53405322131,53405322133,53405322311,53405323220,53405323221,53405323223,53405400000,53405400001,53405400002,53405400020,53405400022,53405400023,53405400112,53405400130,53405400132,53405401031,53405401032,53405401033,53405401122,53405401131,53405401132,53405401133,53405410002,53405410020,53405410022,53405410023,53405410210,53405410212,53405410230,53405410232,53405410233,53405410322,53405412112,53405413031,53405413033,53405413310,53405413312,53405502321,53405502322,53405502323,53405502330,53405502332,53405503013,53405503031,53405503033,53405503100,53405503102,53405503103,53405503132,53405503221,53405503223,53405510311,53405510313,53405510331,53405510333,53405511023,53405511031,53405511032,53405511033,53405512031,53405512032,53405512033,53405512102,53405512103,53405520002,53405520003,53405520011,53405520012,53405520013,53405531030,53405531032,53405533020,53405533022,53405601030,53405601100,53405601200,53405602010,53405602011,53405602012,53405602020,53406210233,53406210313,53406210322,53406210323,53406211033,53406211132,53406211133,53406211201,53406211202,53406211203,53406212011,53406212013,53406212031,53406212033,53406212300,53406212301,53406212303,53406231231,53406233110,53406233111,53406300022,53406300023,53406301001,53406301003,53406322031,53406323311,53406333230,53406333231,53406333232,53406431130,53406431132,53406432310,53406432311,53406432312,53406433010,53406433011,53406433012,53406433020,53406433021,53406433022,53406501320,53406501321,53406502010,53406502011,53406502012,53406502030,53406502220,53406510030,53406510031,53406510032,53406510200,53407310101,53407310103,53407310130,53407310131,53407311000,53407311001,53407311002,53407311101,53407311103,53407311121,53407311123,53407311301,53407402201,53407402310,53407402320,53407403000,53407403001,53407403002,53407410100,53407410101,53406212330,53406212331,53406212333,53406231000,53406231001,53406231003,53406231211,53406231213,53406323030,53406323031,53406323032,53406323120,53406323121,53406332200,53406332201,53406332203,53406333300,53406333311,53406333312,53406333313,53407311310,53407311311,53407402231,53407402021,53407402023,53407401230,53407401232,53407401300,53407401301,53407401302,53407401310,53407401311,53407410020,53407410021,53407410022,53406431320,53406431321,53406431322,53406431110,53406431111,53406431112,53406502200,53406502201,53406502202,53406501230,53406501231,53406501220,53406501221,53406501310,53406501311,53406501312,53405532330,53405532332,53405533000,53405533002,53405513320,53405513322,53405513310,53405600320,53405600321,53405600322,53405600310,53405600311,53405600312,53404633211,53404633213,53404633030,53404633031,53404633033,53404632030,53404632031,53404633231,53404633233,53404602103,53404602101,53404600323,53404600321,53404600303,53404600301,
051,00,//,503198437,128662500,504717187,129965625,0,5,25,57,143,288,5339573,5339671,5339770,5340502,5340600,53395703,53395712,53395713,53395721,53395723,53396701,53396703,53396721,53396723,53396730,53396731,53396732,53397613,53397631,53397633,53405002,53405031,53405032,53405033,53405120,53405122,53406020,53406010,53406011,53406012,533957001,533957003,533957013,533957102,533957111,533957113,533957223,533967203,533967221,533967222,533967223,533967330,533967331,533967332,533976113,533976303,533976321,533976323,533977100,533977101,533977102,533977210,534050002,534050030,534050032,534050033,534050133,534050302,534050303,534051022,534051023,534051210,534051232,534060210,534060211,534060220,534061000,534061002,543906101,543906103,543906121,543906122,543906213,543906300,543916010,534060130,534060131,534060132,533977200,533977201,533977202,543906110,543906111,543906112,543906230,543906231,543906232,5339473323,5339473331,5339473332,5339473333,5339570021,5339570023,5339570113,5339570121,5339570122,5339570123,5339570210,5339570211,5339570213,5339570231,5339570233,5339571002,5339571032,5339571101,5339571103,5339571121,5339571123,5339572011,5339572013,5339572031,5339572033,5339572211,5339572212,5339572213,5339670011,5339670013,5339670031,5339670033,5339670231,5339670233,5339672011,5339672013,5339672201,5339672203,5339673330,5339761111,5339761113,5339761123,5339761231,5339761233,5339763011,5339763012,5339763013,5339763201,5339763203,5339763220,5339763221,5339763223,5339771030,5339771100,5339772220,5339772222,5340402222,5340500000,5340500002,5340500032,5340500312,5340500313,5340501321,5340501322,5340501323,5340503002,5340503003,5340503011,5340503012,5340503013,5340510202,5340510203,5340510212,5340510320,5340510321,5340510322,5340512120,5340512121,5340512122,5340512300,5340512302,5340512332,5340512333,5340513220,5340602130,5340603000,5340603011,5340603100,5340610030,5340610100,5340610101,5340610200,5340610202,5340610220,5439061001,5439061003,5439061021,5439061023,5439061201,5439061203,5439062111,5439062112,5439062113,5439062123,5439063010,5439063020,5439070000,5439160110,5439160112,5439160120,5439160121,5340602210,5340602211,5340602212,5340602120,5340602121,5340602122,5340601330,5340601331,5340601332,5340610010,5340610011,5340610012,5339772110,5339772111,5339772112,5339772030,5339772031,5339772032,5339772200,5339772201,5339772202,5439061130,5439061131,5439061132,5439061300,5439061301,5439061302,5439061230,5439061231,5439061232,5439062330,5439062332,53394722323,53394733221,53394733223,53394733301,53394733303,53395700031,53395700033,53395701033,53395701121,53395701122,53395701123,53395701202,53395701203,53395702011,53395702121,53395702123,53395702301,53395702303,53395702321,53395702323,53395710030,53395710032,53395710033,53395710122,53395710300,53395710302,53395710303,53395710332,53395710333,53395711001,53395711003,53395711222,53395720101,53395720103,53395720121,53395720123,53395720301,53395720303,53395720321,53395720323,53395722101,53395722103,53396633313,53396633331,53396633333,53396700101,53396700103,53396700121,53396700123,53396700301,53396702110,53396702111,53396702113,53396702131,53396702133,53396702303,53396702321,53396702323,53396720101,53396720103,53396720121,53396720122,53396720123,53396720231,53396720232,53396720233,53396722003,53396722021,53396722022,53396722023,53397611121,53397611123,53397611212,53397611213,53397611222,53397611223,53397612113,53397612131,53397612133,53397630103,53397630233,53397632023,53397632220,53397632221,53397632223,53397710310,53397710320,53397711020,53397712000,53397712001,53397712002,53397712220,53397712222,53397721210,53397722210,53397722212,53397722230,53404022200,53404022202,53404022203,53405000010,53405000012,53405000030,53405000032,53405000033,53405000300,53405000302,53405000332,53405001232,53405003100,53405003102,53405003103,53405003112,53405012022,53405012200,53405012202,53405012220,53405012222,53405012331,53405012333,53405013033,53405013122,53405013123,53405013132,53405013133,53405013202,53405013203,53405030000,53405030002,53405030003,53405030103,53405102003,53405102012,53405102013,53405102100,53405102102,53405102103,53405102132,53405102133,53405103230,53405103232,53405121102,53405121120,53405121122,53405121230,53405121231,53405123030,53405123032,53405123033,53405123122,53405123300,53405123302,53405123303,53405123312,53405123313,53405132022,53405132023,53405132032,53405132210,53405132212,53405132220,53405132221,53406023000,53406023001,53406023002,53406030010,53406030101,53406030103,53406030131,53406031020,53406101020,53406101021,53406101030,53406101032,53406101100,53406101101,53406101102,53406101110,53406102030,53406102032,53406102220,54390603313,54390603331,54390603332,54390603333,54390610001,54390610003,54390610021,54390610023,54390610201,54390610203,54390610221,54390610223,54390612001,54390612003,54390612021,54390612023,54390621033,54390621103,54390621211,54390621213,54390621223,54390630120,54390630210,54391600111,54391600113,54391600131,54391600133,54391600311,54391601110,54391601112,54391601221,54391601230,54391601300,53397730000,53397730002,53397711010,53397711011,53397711012,53396733320,53396733321,53396733322,53396733310,53396733311,53396733312,53406022210,53406022211,53406022300,53406022301,53406022130,53406022131,53406022132,53406021230,53406021231,53406021232,53406021310,53406021311,53406030020,53406030021,53406030022,53406031010,53406031011,53406031012,53406013330,53406013331,53406013332,53406100130,53406100131,53406100132,53406100320,53406100322,53406102010,53406102011,53406102012,53397721130,53397721131,53397721132,53397721200,53397721201,53397721202,53397720330,53397722100,53397722030,53397722032,54390700020,54390700021,54390700022,54390611330,54390613100,54390613101,54390613102,54390613030,54390613031,54390613032,54390613200,54390613201,54390613202,54390612330,54390612331,54390612332,54390630220,54390630221,54390630222,54390623330,54390623332,54390623310,54390623311,54390623312,
052,00,/Ĥ,503760937,129028125,505378125,130753125,1,9,36,95,218,409,534070,5340612,5340613,5340710,5340711,5440001,5440003,5440101,5440103,5440201,53397713,53406032,53406033,53406103,53407120,53407121,53407122,54400001,54400003,54400021,54400023,54400100,54400122,54401001,54401002,54401003,54401021,54401023,54401100,54401102,54401120,54401122,54402001,54402120,54402121,54402123,54403101,54403103,54403110,54403112,54403121,54403130,54402100,54402102,54402103,54402132,533977112,533977113,533977121,533977123,533977301,533977302,533977310,533977311,533977313,533977331,534060231,534060232,534060233,534060303,534060312,534060313,534061023,534061122,534061123,534061132,534061133,534062300,534062303,534071230,534071232,534071300,534071301,534072020,534072022,534072200,544000000,544000001,544000003,544000203,544000221,544000223,544001010,544001020,544001022,544001200,544001202,544001203,544010001,544010003,544010200,544010201,544010203,544010221,544010223,544011012,544011030,544011032,544011210,544011212,544020030,544020031,544020033,544020300,544020301,544020310,544020311,544020313,544021220,544021221,544021223,544031001,544031132,544011230,544011231,544011232,544021010,544021012,544021013,544021120,544021121,544021122,534062210,534062200,534062201,534062202,534071310,534071311,534071313,533977111,534060302,534061021,534061012,534062022,534062122,534062301,534061131,534060311,544021300,544021302,544021303,5339771033,5339771203,5339771221,5339771223,5339773001,5339773003,5339773030,5339773031,5339773032,5339773120,5339773121,5339773123,5339773301,5339773303,5339773321,5339773323,5340602133,5340602222,5340602223,5340602232,5340602233,5340602303,5340603003,5340603012,5340610033,5340610132,5340610223,5340611202,5340611203,5340611212,5340611213,5340611302,5340611303,5340620331,5340620332,5340620333,5340623120,5340623122,5340623300,5340623301,5340623303,5340623312,5340623313,5340623331,5340712330,5340712332,5340713020,5340713021,5340720020,5340720021,5340720022,5340720210,5340720212,5340720230,5340720232,5340722010,5340722200,5439071101,5440000020,5440000021,5440000023,5440000210,5440000211,5440002013,5440002023,5440002201,5440002202,5440002203,5440002221,5440002222,5440002223,5440010110,5440010210,5440010212,5440010230,5440010232,5440012010,5440012012,5440012013,5440012120,5440012122,5440012123,5440012300,5440012301,5440012302,5440012322,5440100000,5440100001,5440100003,5440100021,5440100022,5440100023,5440102021,5440102023,5440102201,5440102202,5440102203,5440102221,5440102223,5440110132,5440110310,5440110312,5440110330,5440110332,5440112110,5440112112,5440112130,5440112132,5440112133,5440113200,5440113202,5440113203,5440200001,5440200010,5440200011,5440200013,5440200031,5440200033,5440200211,5440202113,5440202131,5440202133,5440202311,5440203020,5440203021,5440203030,5440203031,5440203120,5440203121,5440203123,5440203311,5440212221,5440212223,5440310211,5440310213,5440312011,5440312013,5440312031,5440312301,5440312310,5440312311,5440313100,5440313102,5440313200,5440313201,5440313210,5440211300,5440113220,5440211032,5440112330,5440112331,5440112332,5440210110,5440210112,5440210113,5440211230,5440211232,5340622200,5340623210,5340622120,5340622121,5340622122,5340720002,5340622030,5340622031,5340622032,5340622110,5340622111,5340712310,5340712312,5340713120,5340713121,5340713122,5440310030,5440310031,5440310033,5339771202,5339771201,5339771103,5339673333,5340602231,5340602302,5340602301,5340602132,5340603103,5340610031,5340610133,5340611200,5340620202,5340620232,5340620323,5340621232,5340623102,5340623310,5340610221,5340602220,5339773002,5339771220,5340722020,5340722021,5340722022,5339773330,5339773331,5339773333,5440211020,5440211022,5440211023,5440213320,5440213322,5440311100,5440311102,5440311120,5440311122,5440213010,5440213012,5440311300,5440311302,5440311303,53397710323,53397711023,53397712003,53397712221,53397721311,53397721313,53397721331,53397730330,53397730331,53397731220,53397731221,53397731223,53397733001,53397733003,53397733021,53397733023,53397733201,53397733203,53397733221,53397733223,53406023003,53406030013,53406030102,53406030132,53406030133,53406031022,53406031023,53406101022,53406101302,53406102031,53406102033,53406102223,53406112012,53406112013,53406113012,53406113013,53406202332,53406203303,53406212023,53406212302,53406231232,53406233021,53406233112,53406233301,53406233331,53406322220,53407123330,53407123332,53407130331,53407132000,53407133000,53407133001,53407133110,53407133111,53407200230,53407200232,53407200233,53407200322,53407202130,53407202132,53407202310,53407202312,53407220300,53407220302,54390711001,54390711100,54390711102,54390733333,54391711111,54391711113,54391711333,54391713111,54391713331,54391713333,54391731111,54391731113,54391731131,54391731133,54400000220,54400000221,54400000223,54400002010,54400002011,54400002013,54400002121,54400002130,54400002131,54400002133,54400002311,54400002313,54400002331,54400002333,54400020111,54400020112,54400020113,54400020121,54400020123,54400020212,54400020213,54400022200,54400022201,54400022203,54400101110,54400101120,54400101210,54400120110,54400120112,54400120113,54400121020,54400121022,54400121023,54400121212,54400123030,54400123031,54400123032,54400123200,54400123202,54401000020,54401000021,54401000023,54401000202,54401000203,54401020200,54401020201,54401020203,54401020221,54401020223,54401022001,54401022002,54401022003,54401022201,54401101000,54401101001,54401101002,54401101022,54401101023,54401103110,54401103112,54401103330,54401103332,54401121110,54401121112,54401121130,54401121132,54401121310,54401121312,54401130222,54401130223,54402000120,54402000121,54402000123,54402000301,54402000303,54402000321,54402000323,54402002101,54402002103,54402002131,54402003210,54402003211,54402021110,54402021111,54402021113,54402021303,54402021321,54402021323,54402023101,54402030220,54402030222,54402031221,54402032000,54402033101,54402033131,54402122201,54402122221,54403102311,54403102313,54403102331,54403102332,54403102333,54403120101,54403120103,54403120121,54403120123,54403120301,54403120331,54403120333,54403123000,54403123001,54403123130,54403123131,54403131010,54403132110,54403132111,54403132112,54403132120,54403132121,54401132210,54401132211,54401132212,54401123330,54402101110,54402101112,54402101113,54402110020,54402110022,54402110023,54402110302,54402110303,54402112310,54402112311,54402112312,54402113020,54402113021,54402113022,54402110330,54402110332,53406222200,53406222202,53407200032,53407200033,53407200000,53407200002,53407200003,53406222220,53406222222,53406222020,53406222021,53406222022,53406222010,53406222011,53406222012,53406222100,53406222101,53406220330,53406220331,53406232110,53406232111,53406232120,53406232121,53406230231,53406230233,53406230211,53406230213,53406221300,53406221302,53406221120,53406221121,53406221122,53406221130,53406221131,53406221133,54401103130,54401103132,54401101300,54401101302,54401101303,54400102110,54400102112,54400101200,54400101201,54400101202,54401103310,54401103312,54400121320,54400121322,53407123310,53407123312,53407123130,53407123132,53407123110,53407123111,53407123112,53407130220,53407130221,53407130222,53407130300,53407130310,53407130311,53407130313,53407131230,53407131231,53407131232,53407220120,53407220122,54403113300,54403113301,54403113302,54403131200,54403131201,54403131202,54403100320,54403100321,54403100323,54403100211,54403100213,54403100031,54403100033,54403100010,54403100011,54403100013,53397730003,53397712223,53397730001,53397710322,53397710321,53397711022,53397710311,53397710312,53397710313,53397711021,53397711013,53396733323,53396733313,53406022212,53406022302,53406022213,53406022303,53406022133,53406021233,53406021312,53406021313,53406030023,53406030012,53406031013,53406102222,53406013333,53406102221,53406101023,53406100133,53406100323,53406100321,53406101300,53406101303,53406110222,53406113003,53406113011,53406111322,53406111332,53406202002,53406202032,53406202302,53406202333,53406203222,53406203223,53406203302,53406203301,53406203133,53406212022,53406212032,53406212332,53406231002,53406231210,53406231212,53406231230,53406231233,53406233113,53406111323,53406102013,53406030011,53406030100,53406030130,53406031021,53397721133,53406322200,53406322202,53406322020,53406322021,53406322022,53407202110,53407202112,53407220230,53407220231,53407220232,54400123100,54400123102,54390711311,54390711313,54390711131,54390711133,54390711111,54390711113,53397733320,53397733322,54402110210,54402110212,54402110213,54402021100,54402021101,54403113120,54403113122,54403113123,54402131220,54402131222,54402112330,54402112332,54402130110,54402130112,54402130130,54402130132,54402133000,54402133002,54402133020,54402133022,54402133023,54403111232,54403113010,54403113012,54403113013,
053,00,Ų,502875000,129487500,504239062,130940625,1,10,39,65,145,327,543927,5439072,5439161,5439162,5439163,5439170,5439172,5439261,5439370,5439371,5439373,53397723,53397732,54390631,54390633,54390701,54390702,54390703,54390710,54390712,54390713,54390730,54390731,54390732,54391531,54391533,54391602,54391603,54391710,54391712,54391730,54391732,54391733,54392511,54392600,54392601,54392603,54392630,54392631,54392633,54404000,54403022,54403020,54403002,54403000,54402022,54402020,54390632,54394711,54403001,533977223,543906133,543906303,543907001,543907003,543907112,543907330,543907331,543907332,543915111,543915113,543915131,543915132,543915133,543915321,543915323,543916000,543916002,543917110,543917112,543917130,543917132,543917310,543917312,543917313,543925101,543925103,543925131,543926020,543926021,543926023,543926210,543926211,543936110,543936111,543936113,543936131,543936133,543936311,543937200,543937211,543937213,543937231,543947101,544000022,544000200,544020002,544020020,544020212,544020022,544020023,544020230,544020232,544020233,544030030,544030032,544030210,544030212,544030230,544030232,544040021,543907002,544020210,543947131,544040020,5339772123,5339772130,5339772132,5339772213,5439061313,5439061323,5439062223,5439062232,5439063013,5439071102,5439071103,5439071112,5439071130,5439071132,5439073330,5439073331,5439073332,5439151101,5439151103,5439151121,5439151123,5439151301,5439151303,5439153011,5439153013,5439153031,5439153032,5439153033,5439153201,5439153203,5439153221,5439153223,5439160010,5439160012,5439160030,5439160032,5439160033,5439160131,5439160132,5439160133,5439171110,5439171112,5439171113,5439171130,5439171131,5439171132,5439171310,5439171312,5439171313,5439171330,5439171331,5439171332,5439173110,5439173112,5439251001,5439251003,5439251021,5439251023,5439251200,5439251201,5439251203,5439251210,5439251211,5439251213,5439251300,5439251301,5439251302,5439260220,5439260221,5439260223,5439262010,5439262011,5439262130,5439262131,5439263210,5439263211,5439263213,5439263231,5439263233,5439361011,5439361013,5439361120,5439361121,5439361123,5439361301,5439361303,5439361321,5439361323,5439363101,5439363103,5439363131,5439372330,5439372331,5439372333,5439471000,5439471001,5439471301,5439471303,5440000200,5440000202,5440000203,5440000230,5440000232,5440002010,5440002020,5440002022,5440002200,5440102222,5440200000,5440200002,5440200003,5440200212,5440400320,5440400231,5440302310,5440202112,5440200320,5440200322,5440202312,5440202313,5440400101,5440400100,5440400102,5440400120,5440400122,5440400300,5440400302,5339772122,5339772211,5339772212,5439070001,5439070003,5439061311,5439061312,5439061321,5439061322,5439063011,5439063023,5439160113,5439471300,5439363130,5439071133,5440302132,5440302130,5440200323,53397721213,53397721310,53397721312,53397721330,53397721332,53397721333,53397722211,53397722213,53397722231,53397722233,53397730332,53397730333,53397731222,53397733000,53397733002,53397733020,53397733022,53397733200,53397733202,53397733220,53397733222,54390533232,54390533233,54390533322,54390533323,54390533332,54390533333,54390622212,54390622213,54390622221,54390622222,54390622223,54390622302,54390622303,54390622312,54390622330,54390622332,54390630123,54390630213,54390711000,54390711002,54390711003,54390711103,54390733330,54390733331,54390733332,54391512332,54391512333,54391513023,54391530121,54391530123,54391530301,54391530302,54391530303,54391532223,54391600110,54391600112,54391600130,54391600132,54391600310,54391600312,54391601113,54391601222,54391601233,54391601303,54391711110,54391711112,54391711330,54391711331,54391711332,54391713110,54391713112,54391713113,54391713330,54391713332,54391731110,54391731112,54391731130,54391731132,54392510001,54392510003,54392510021,54392510023,54392510201,54392510203,54392510221,54392510223,54392512120,54392512121,54392512122,54392512311,54392512313,54392512331,54392513030,54392513031,54392513200,54392513201,54392513202,54392513310,54392513311,54392513313,54392602221,54392620011,54392620130,54392620131,54392620133,54392621201,54392621210,54392621211,54392621213,54392621320,54392621321,54392621330,54392621331,54392632010,54392632011,54392632013,54392632120,54392632121,54392632123,54392632301,54393610311,54393610313,54393611220,54393611221,54393611223,54393613001,54393613003,54393613021,54393613023,54393613201,54393613202,54393613203,54393613220,54393613221,54393613223,54393631001,54393631003,54393631021,54393631330,54393631331,54393720100,54393720101,54393720102,54393720110,54393720120,54393720122,54393720200,54393720201,54393720202,54393720210,54393720211,54393720220,54393720300,54393721010,54393721011,54393721013,54393721031,54393721033,54393721233,54393723011,54393723013,54393723031,54393723033,54393723211,54393723213,54393723231,54393723320,54393723321,54393723323,54394701110,54394701111,54394710021,54394710030,54394710031,54394710033,54394710311,54394713021,54394713023,54400000222,54400002012,54400002120,54400002122,54400002123,54400002132,54400002310,54400002312,54400002330,54400002332,54400020110,54400020120,54400020122,54400020210,54400020211,54400022202,54401000022,54401000200,54401000201,54401020202,54401020220,54401020222,54401022000,54401022200,54401022202,54401022203,54402000122,54402000300,54402000302,54402000320,54402000322,54402002100,54402002102,54402002130,54402002132,54402002133,54404002211,54404002300,54404002303,54404003221,54404003212,54404003210,54404002301,54404003032,54404003030,54404003012,54404003011,54404003100,54404001210,54404001032,54404001030,54404001031,54404001100,54403023322,54403023320,54403023302,54403023300,54403023122,54403023120,54403023121,54403021122,54403021120,54403021102,54403021100,54403003322,54403003320,54403003300,54403003302,54403003122,54403003120,54403003102,54403003100,54403010200,54403010022,54403010002,54402023103,54402021112,54402021301,54402021300,54402003213,54402003212,54402021302,54402021320,54402021322,54402023100,54402023102,53397721211,53397721212,53397721203,53397720331,53397720333,53397720332,53397722101,53397722103,53397722102,53397722031,53397722033,53397722232,54390700023,54390611331,54390611333,54390611332,54390613103,54390613033,54390613203,54390612333,54390630121,54390630122,54390630211,54390630212,54390630223,54391601111,54390623331,54390623333,54390623313,54391601301,54391601302,54391601223,54391601220,54391600313,54391601232,54391601231,54394710310,54393631211,54393631213,54393631210,54390711312,54390711310,54390711132,54390711130,54390711101,54390711112,54390711110,53397733323,53397733321,54403012000,54403010222,54403010220,54403010202,54403010020,54403010000,54403021123,54402021102,54402021103,54403023321,54403023303,54404002210,54404001212,
054,00,ڱ,504534375,128643750,507150000,130612500,8,21,35,82,178,367,544002,544003,544013,544014,544004,534075,544012,544022,5340723,5340730,5340732,5340733,5340742,5340743,5440011,5440013,5440230,5440231,5340721,5440111,5340652,5440050,5440052,5440150,5340653,5340660,5340662,5340562,5340561,53406503,53406511,53406512,53406513,53407203,53407221,53407223,53407312,53407411,53407412,53407413,54402330,54402400,54402402,54401133,53406223,53407201,54400103,53407313,54402411,54401520,54401522,54400510,54400512,53407600,53407602,53405630,53405603,53405631,53405632,53406610,54400530,54402111,54401131,54402320,534046323,534055313,534055331,534055333,534056013,534056023,534064333,534065023,534065103,534071322,534071323,534071332,534071333,534072221,534072222,534072223,534073102,534073103,534073112,534074031,534074032,534074033,534074103,544001013,544001211,544001233,544011300,544023210,544023211,544023213,544023310,544024010,544024011,544024200,544021101,544011323,544011321,544011303,544011301,534062332,534072001,534062223,534062320,534062323,534062322,544011011,534063223,534063232,534073100,534074102,534064332,534064331,534065021,534055332,534055311,534056022,534056021,534071321,544024101,544024100,544021131,544021133,544021311,544021313,544021331,544021333,544023220,544023222,544032111,544032110,544032101,544032100,544032011,544032010,544032001,544032000,544031111,544032102,544021132,544021310,544032002,544031113,5340463222,5340463223,5340463320,5340553301,5340553303,5340560111,5340560112,5340560113,5340560121,5340560122,5340560123,5340560203,5340623332,5340632221,5340632223,5340632332,5340632333,5340643133,5340650221,5340650223,5340651013,5340651022,5340651023,5340713032,5340713201,5340713202,5340713203,5340713302,5340713303,5340713312,5340713313,5340720031,5340720233,5340722011,5340722013,5340722031,5340722033,5340722202,5340722203,5340731102,5340731103,5340731132,5340740133,5340740222,5340740233,5340740303,5340741011,5340741012,5340741013,5440010113,5440010123,5440010213,5440010231,5440010233,5440012100,5440012101,5440012103,5440012131,5440012133,5440012311,5440012312,5440012313,5440012321,5440012323,5440110101,5440110103,5440110131,5440113020,5440113021,5440113023,5440113201,5440232120,5440233110,5440233111,5440233120,5440233122,5440233200,5440233210,5440233211,5440233300,5440240130,5440240300,5440240302,5440240320,5440242010,5440211303,5440211301,5440211000,5440113222,5440113223,5440211001,5440211003,5440211031,5340720030,5340622203,5340622211,5340623213,5340623020,5340622131,5340622123,5340622132,5340622133,5340623022,5340622212,5340622221,5340622223,5340720001,5340622213,5440110133,5440010122,5340632330,5340633222,5340633223,5340731012,5340731101,5340633332,5340731133,5340740302,5340740301,5340740132,5340741003,5340643303,5340643233,5340643131,5340650133,5340651021,5340651012,5340651011,5340553123,5340553121,5340551333,5340560033,5340463322,5340463302,5340463213,5340463212,5340463221,5340720033,5340722032,5340722201,5340713310,5340713301,5340713023,5440012130,5440241033,5440241031,5440241030,5440241021,5440330000,5440321121,5440321120,5440321031,5440321030,5440320133,5440320131,5440320130,5440320121,5440320120,5440320031,5440320030,5440213121,5440213123,5440213301,5440213303,5440213321,5440213323,5440311101,5440311103,5440213120,5440232210,5440330001,5440321201,5440321200,5440320200,5440311313,5440311311,5440311310,5440311121,53404623333,53404632203,53405531031,53405531033,53405533021,53405533023,53405601031,53405601033,53405601102,53405601103,53405601201,53405601203,53405602013,53405602023,53406233023,53406233300,53406233302,53406233332,53406322032,53406322221,53406322223,53406323312,53406333233,53406431131,53406431133,53406432313,53406433013,53406433023,53406501322,53406501323,53406502013,53406502031,53406502033,53406502221,53406502223,53406510033,53406510203,53407123333,53407130330,53407130332,53407132003,53407133002,53407133003,53407133112,53407200231,53407200320,53407200321,53407202133,53407202311,53407202313,53407220303,53407310102,53407310132,53407310133,53407311003,53407311100,53407311102,53407311120,53407311122,53407311300,53407311302,53407402200,53407402202,53407402313,53407402323,53407403003,53407410102,53407410103,54400101111,54400101112,54400101113,54400101121,54400101122,54400101123,54400101211,54400101212,54400101213,54400120111,54400121021,54400121210,54400121211,54400123033,54400123201,54400123203,54401101003,54401101020,54401101021,54401103111,54401103331,54401103333,54401121111,54401121113,54401121131,54401121133,54401121311,54401121313,54401130220,54401130221,54402321220,54402323100,54402323101,54402323111,54402331120,54402331131,54402331133,54402331210,54402331212,54402331230,54402331232,54402331311,54402332010,54402332011,54402332012,54402332020,54402332021,54402332030,54402332120,54402332121,54402332131,54402333010,54402333012,54402333020,54402333021,54402333030,54402401200,54402401201,54402401202,54402401210,54402401211,54402401220,54402401222,54402403210,54402403212,54402403220,54402403221,54402403222,54402420120,54402420121,54402420200,54402420201,54402420210,54401132213,54401123331,54401123332,54402101111,54401123333,54402110021,54402110300,54402110301,54402112313,54402113023,54402110333,54402110331,53406222203,53407200031,53407200030,53407200001,53406222223,53406222221,53406222201,53406222023,53406222013,53406222102,53406222103,53406220332,53406220333,53406233022,53406233020,53406232113,53406232112,53406232123,53406232122,53406230232,53406230230,53406230212,53406230210,53406221301,53406221303,53406221123,53406221132,54401103131,54401103113,54401101301,54400102113,54400102111,54400101203,54402322110,54402322111,54402322112,54402321210,54402321211,54402321213,54402401310,54402401311,54402403030,54402403032,53406322033,53406323033,53406323122,53406323310,53406323123,53406323313,53406332202,53407310100,53406333302,53406333303,53406333301,53406333310,53407311313,53407311312,53407311303,53407402321,53407402322,53407402233,53407402232,53407402203,53407402230,53407402022,53407402020,53407402312,53407402311,53407401233,53407401231,53407401303,53407401312,53407401313,53407410023,53406431323,53406431113,53406502222,53406502203,53406502032,53406501233,53406501232,53406501223,53406501222,53406510202,53406501313,53406510201,53405532333,53405532331,53405533003,53405533001,53405513323,53405513313,53405600323,53405602021,53405602022,53405513311,53405513312,53405513321,53405601202,53405600313,53405601032,53404633232,53404633230,53404633212,53404633210,53404633032,53404632033,53404632201,53404632202,53404623331,53404623332,53405601101,53404632032,53406322222,53406233333,53406233330,53406233303,53406322203,53406322023,53406322201,53406322030,53407202111,53407202131,53407202113,53407200323,53407220301,53407220123,53407220121,53407220233,53407133113,53407131233,53407130333,53407130312,53407130301,53407130303,53407130302,53407130223,53407132001,53407132002,53407123113,53407123131,53407123133,53407123311,53407123313,53407123331,54400121213,54400121321,54400121323,54400123103,54400123101,54401103133,54401103311,54401103313,54402110211,54402410200,54402410201,54402410231,54402410320,54402410321,54402410323,54402322120,54402322320,54402322322,54403300030,54403300020,54403300022,54403300021,54403211310,54403211300,54403211302,54403211320,54403211231,54403211230,54403211301,54403211220,54403210331,54403210330,54403210320,54403210322,54403210321,54403212021,54403212020,54403203111,54403203110,54403201323,54403201321,54403201320,54403201231,54403201230,54403200330,54403200331,54403201221,54403201220,54403200320,54403202010,54403202021,54403202022,54403202020,54403113121,54402131221,54402112331,54402112333,54402130111,54402130113,54402130131,54402130133,54402131223,54402133003,54402133001,54402133021,54403111231,54403111233,54403113011,54403111230,
055,00,,504140625,130246875,506362500,131268750,2,12,25,91,166,353,544042,544034,5440303,5440322,5440323,5440331,5440332,5440333,5440410,5440411,5440430,5440431,5440432,5440243,54402421,54402422,54402423,54403213,54403301,54403302,54403303,54404010,54404011,54404013,54404131,54404133,54404330,54404400,54404401,54405301,54403011,54403013,54403133,54403122,54402412,54402413,54403520,54403522,54403502,544020321,544020322,544020323,544020332,544020333,544023232,544023233,544023322,544023323,544023331,544023332,544023333,544024031,544024033,544024203,544031020,544031022,544031200,544031202,544031232,544031233,544031311,544031313,544031322,544031323,544032021,544032023,544032030,544032032,544032033,544032122,544032123,544033003,544040120,544040121,544040123,544040301,544040310,544040311,544041200,544041201,544041202,544041210,544041211,544041220,544041300,544041301,544041303,544041321,544043310,544043312,544043320,544043321,544043322,544044020,544044021,544044022,544044100,544052100,544052101,544052102,544052110,544052111,544053000,544053001,544053003,544053023,544053030,544053031,544053100,544053102,544053120,544052000,544052001,544051110,544051111,544052010,544052011,544052013,544040013,544030101,544030103,544023230,544033001,544033002,544032121,544032022,544020330,544030121,544030122,544030123,5440203201,5440203202,5440203203,5440203312,5440232213,5440232231,5440232233,5440232312,5440232313,5440233130,5440233132,5440233133,5440240123,5440240133,5440240323,5440241022,5440242011,5440242013,5440242022,5440242023,5440310002,5440310020,5440310022,5440310230,5440311333,5440312032,5440312302,5440313123,5440313213,5440320312,5440321133,5440321203,5440400330,5440400331,5440401220,5440401221,5440401223,5440403030,5440403031,5440403120,5440403130,5440403131,5440403133,5440403311,5440412030,5440412031,5440412032,5440412120,5440412121,5440412130,5440412131,5440412210,5440413020,5440413021,5440413023,5440413230,5440413231,5440413233,5440433110,5440433111,5440433112,5440433130,5440433132,5440433230,5440433231,5440433232,5440433300,5440433301,5440433310,5440440230,5440440300,5440440301,5440440302,5440440310,5440441010,5440441012,5440441020,5440442000,5440511011,5440511013,5440511031,5440520310,5440520311,5440520312,5440521030,5440521032,5440521120,5440521121,5440521130,5440521131,5440530020,5440530021,5440530023,5440530211,5440530212,5440530213,5440530223,5440530320,5440530321,5440530323,5440530330,5440531010,5440531012,5440531013,5440531030,5440531032,5440531210,5440531212,5440532001,5440532010,5440520030,5440520031,5440511130,5440520021,5440520120,5440520121,5440302311,5440302313,5440400123,5440400311,5440400312,5440400313,5440400111,5440400112,5440400113,5440302331,5440302333,5440302131,5440302133,5440302111,5440302113,5440300331,5440300333,5440300311,5440300313,5440301021,5440301023,5440301001,5440301003,5440232230,5440232123,5440320313,5440320310,5440320203,5440311331,5440313121,5440313103,5440313202,5440313203,5440312303,5440312312,5440310232,5440310212,5440310210,5440310023,5440310000,5440203033,5440203023,5440203032,5440240132,5440240301,5440311332,5440313122,5440301201,5440301202,5440301203,54402030223,54402031222,54402032001,54402032003,54402033102,54402033103,54402033132,54402122202,54402122203,54402122220,54402122222,54402321223,54402322123,54402323102,54402323103,54402323110,54402323112,54402323113,54402331121,54402331122,54402331123,54402331130,54402331132,54402331211,54402331213,54402331231,54402331233,54402331310,54402331312,54402331313,54402332013,54402332022,54402332023,54402332031,54402332032,54402332033,54402332122,54402332123,54402332130,54402332132,54402332133,54402333011,54402333013,54402333022,54402333023,54402333031,54402333032,54402333033,54402401203,54402401212,54402401221,54402403213,54402403223,54402410232,54402410233,54402420122,54402420123,54402420202,54402420203,54402420211,54402420212,54402420213,54403102312,54403102330,54403120100,54403120102,54403120120,54403120122,54403120300,54403120302,54403120332,54403123002,54403123003,54403123132,54403123133,54403131013,54403132113,54403132122,54403132123,54403201233,54403202013,54403203112,54403211222,54403211313,54403211321,54403211323,54403212022,54403212023,54403300031,54403300032,54403300033,54404003330,54404003331,54404012220,54404012221,54404012223,54404030010,54404030011,54404030013,54404030031,54404030033,54404030211,54404030213,54404030231,54404030233,54404030320,54404030321,54404030322,54404030330,54404030331,54404031210,54404031211,54404031213,54404031220,54404031221,54404032100,54404033130,54404033131,54404033133,54404120330,54404120331,54404120332,54404121220,54404121221,54404121230,54404121231,54404121320,54404121321,54404121330,54404121331,54404122110,54404122120,54404122121,54404122122,54404122201,54404122210,54404130220,54404130221,54404130223,54404132010,54404132011,54404132013,54404132031,54404132321,54404331332,54404332330,54404332331,54404332332,54404333020,54404333021,54404333022,54404333031,54404333110,54404333120,54404333200,54404333202,54404402310,54404402311,54404402312,54404402320,54404402321,54404402322,54404403030,54404403031,54404403032,54404403110,54404403111,54404403112,54404403120,54404403121,54404410110,54404410111,54404410112,54404410210,54404410211,54404410212,54404410220,54404410221,54404410222,54404411000,54404411001,54404411010,54404412000,54404420010,54404420011,54404420012,54405210310,54405210311,54405210312,54405211330,54405211331,54405212000,54405212001,54405212002,54405212010,54405212011,54405212100,54405300220,54405302031,54405302033,54405302101,54405302103,54405302211,54405302212,54405302213,54405303220,54405303221,54405303223,54405303311,54405303320,54405303322,54405310112,54405310113,54405310310,54405310312,54405310330,54405312200,54405312201,54405312210,54405312211,54405312300,54405320110,54405321001,54405321010,54405321011,54405203031,54405203011,54405203013,54405111200,54405111201,54405111202,54405111210,54405111211,54405111213,54405111231,54405111320,54405111310,54405111311,54405200200,54405200201,54405200331,54405201220,54405201221,54405201230,54405201231,54405201233,54404003211,54404003213,54404003031,54404003033,54404003010,54404003013,54404003101,54404003102,54404003103,54404001211,54404001213,54404001033,54404001101,54404001102,54404001103,54403023323,54403023301,54403023123,54403021121,54403021101,54403021103,54403003321,54403003323,54403003301,54403003303,54403003121,54403003123,54403003101,54403003103,54403010201,54403010203,54403010021,54403010023,54403010001,54403010003,54402322323,54402322321,54402322122,54402322121,54402322113,54402321222,54402321212,54402321221,54403300023,54403211311,54403211312,54403211303,54403210323,54403210332,54403210333,54403211221,54403211223,54403211232,54403211233,54403211322,54403203113,54403201232,54403201223,54403201222,54403200333,54403200332,54403200321,54403200323,54403200322,54403202011,54403202012,54403113303,54403131011,54403131012,54403131203,54403120303,54403120330,54403102310,54403100322,54403100212,54403100210,54403100032,54403100030,54403100012,54402122223,54402122200,54402033133,54402033130,54402033100,54402031223,54402031220,54402030221,54402032002,54402410230,54402410203,54402410202,54402401313,54402401312,54402401213,54402401223,54402403031,54402403211,54402403033,54402410322,54403202023,54403201322,54403012001,54403012002,54403012003,54403010221,54403010223,54405300222,
056,00,Ω,504759375,130800000,507037500,132975000,10,26,55,85,196,403,544063,544064,544073,544074,554003,554004,554015,554005,544075,544054,5440523,5440533,5440621,5440623,5440721,5440722,5440723,5540021,5540023,5540121,5540123,5540130,5540140,5540141,5540143,5540250,5440522,5540162,5540160,5440652,5440650,5440552,5440550,5440443,5440450,5440452,54404413,54404421,54404422,54404423,54405213,54405311,54405313,54405322,54405323,54406221,54406223,54407201,54407203,55400200,55400201,55401201,55401203,55401221,55401223,55401310,55401311,55401320,55401421,55401423,55402201,55402203,55402210,55402212,55402221,55402410,55402411,55402510,55402511,54406201,54405202,54405113,54406203,55401420,55401321,55402600,55402610,55401632,55401630,55402601,55400622,54407622,55400600,55400602,55400620,55400623,54406532,54406512,54406530,54406533,54406510,544043333,544044032,544044033,544044103,544044112,544044121,544044122,544044123,544044201,544044202,544044203,544052122,544052123,544053202,544053203,544053211,544053212,544053213,544062023,544062201,544062203,544062221,544062223,544072001,544072003,544072021,544072023,554001113,554002030,554002031,554002213,554002231,554002232,554002233,554012021,554013120,554013121,554013122,554013130,554013131,554013133,554013220,554013221,554022003,554022021,554022023,554022110,554022111,554022112,554022130,554022132,554022201,554022203,554022221,554022223,554022230,554022231,554022232,554024011,554024130,554024131,554024133,554024311,554024312,554024313,554024330,554025120,554025121,554025122,554025130,554025131,554025200,554025201,554025210,544062001,544062003,544062021,544052033,544052032,544051313,544051311,554013300,544051310,544044111,544044113,5440433113,5440433131,5440433313,5440433321,5440433322,5440433323,5440440233,5440440313,5440441013,5440441023,5440441102,5440441103,5440441201,5440441202,5440441203,5440442002,5440442003,5440520313,5440521033,5440521122,5440521123,5440521132,5440521202,5440521203,5440521211,5440521212,5440521213,5440530200,5440530201,5440530202,5440530220,5440530222,5440530333,5440531211,5440531213,5440531222,5440531223,5440531231,5440531232,5440531233,5440532000,5440532002,5440532003,5440532012,5440532013,5440532102,5440532103,5440620221,5440620223,5440622001,5440622003,5440622021,5440622023,5440622201,5440622203,5440622221,5440622223,5440713111,5440713331,5440713333,5440720001,5440720003,5440720021,5440720023,5440720201,5440720203,5440720221,5440720222,5440720223,5540011111,5540011112,5540011113,5540011310,5540011311,5540020200,5540020201,5540020210,5540020211,5540020213,5540020320,5540020321,5540020330,5540020331,5540020333,5540022111,5540022112,5540022113,5540022233,5540022303,5540120011,5540120012,5540120013,5540120031,5540120033,5540120231,5540120233,5540122011,5540122013,5540122031,5540122033,5540122211,5540122213,5540122231,5540122233,5540131230,5540131231,5540131232,5540131320,5540131321,5540132220,5540132221,5540132230,5540132300,5540132302,5540133110,5540133111,5540142211,5540142213,5540142231,5540220011,5540220012,5540220013,5540221130,5540221132,5540221310,5540221312,5540221330,5540222201,5540222203,5540222221,5540222223,5540222330,5540222331,5540223000,5540223001,5540223002,5540223010,5540223020,5540223022,5540240101,5540240130,5540240131,5540241211,5540241321,5540243103,5540243211,5540243213,5540243231,5540243233,5540243320,5540243322,5540251230,5540252020,5540252021,5540252030,5540252031,5540252110,5540252111,5540252112,5540253000,5540260200,5540320001,5540320010,5540320011,5540320100,5540320101,5540341010,5440620003,5440620001,5440513331,5440513313,5440513311,5440513310,5440513121,5440511211,5440511213,5440520032,5440511122,5440511133,5440520022,5440520023,5440520300,5440520302,5440511033,5540131323,5540133113,5540142210,5540142201,5540133131,5540133133,5540132301,5540133022,5540133020,5540132222,5540011123,5540011121,54404331330,54404331331,54404331333,54404332333,54404333023,54404333030,54404333032,54404333033,54404333111,54404333112,54404333113,54404333121,54404333122,54404333123,54404333201,54404333203,54404402313,54404402323,54404403033,54404403113,54404403122,54404403123,54404410113,54404410213,54404410223,54404411002,54404411003,54404411011,54404411012,54404411013,54404412001,54404412002,54404412003,54404420013,54405211332,54405211333,54405212003,54405212012,54405212013,54405212101,54405212102,54405212103,54405300221,54405300223,54405302030,54405302032,54405302100,54405302102,54405302210,54405303222,54405303310,54405303312,54405303313,54405303321,54405303323,54405310110,54405310111,54405310311,54405310313,54405310331,54405310332,54405310333,54405312202,54405312203,54405312212,54405312213,54405312301,54405312302,54405312303,54405320111,54405320112,54405320113,54405321000,54405321002,54405321003,54405321012,54405321013,54406202013,54406202031,54406202032,54406202033,54406202201,54406202203,54406202221,54406202223,54406220001,54406220203,54406220221,54406220223,54406222001,54406222003,54406222021,54406222023,54406222201,54406222203,54406222221,54406222223,54407113333,54407131333,54407133111,54407133113,54407133131,54407133132,54407133133,54407133303,54407200001,54407200003,54407200021,54407200023,54407200201,54407200203,54407200221,54407200223,54407202001,54407202003,54407202021,54407202023,54407202201,54407202203,55400111013,55400111031,55400111033,55400111101,55400111102,55400111103,55400202021,55400202030,55400202031,55400202120,55400202121,55400202123,55400202311,55400202313,55400203230,55400203231,55400203320,55400203321,55400203323,55400221033,55400221101,55400221102,55400221103,55400221211,55400221213,55400221231,55400221233,55400222311,55400222312,55400222313,55400222323,55400223011,55400223012,55400223013,55400223021,55400223023,55401200031,55401200033,55401200101,55401200102,55401200103,55401200300,55401200301,55401200303,55401200321,55401200322,55401200323,55401202011,55401202013,55401202031,55401222323,55401322310,55401322312,55401323100,55401323101,55401330210,55401333111,55402200013,55402200031,55402200033,55402200101,55402200102,55402200103,55402200211,55402200213,55402200230,55402200231,55402200233,55402202011,55402202013,55402202031,55402202033,55402202211,55402202213,55402202231,55402202233,55402211310,55402211311,55402213320,55402213321,55402213322,55402220011,55402220013,55402220031,55402220033,55402220211,55402220213,55402220231,55402220233,55402222201,55402223320,55402223321,55402223322,55402223330,55402230030,55402230031,55402230032,55402230110,55402230111,55402230120,55402230121,55402230210,55402230212,55402230230,55402230232,55402231000,55402231001,55402231010,55402231011,55402231100,55402232000,55402232002,55402232020,55402232022,55402401001,55402401003,55402401021,55402401030,55402401031,55402401033,55402401211,55402401320,55402401321,55402401330,55402401331,55402401333,55402412101,55402412103,55402413201,55402413203,55402413231,55402413233,55402431011,55402431013,55402431021,55402431023,55402432233,55402432303,55402432321,55402432322,55402432323,55402433210,55402433212,55402512320,55402520220,55402520221,55402520222,55402520230,55402520231,55402520320,55402520321,55402520330,55402520331,55402521130,55402521131,55402521200,55402521201,55402521202,55402521210,55402521211,55402521220,55402521300,55402521301,55402530010,55402530011,55402530020,55402530021,55402602010,55402602012,55402602020,55402602022,55402602111,55402602113,55402603101,55403200031,55403200120,55403200121,55403200130,55403200131,55403201020,55403201021,55403201030,55403201031,55403201100,55403410011,55403410013,55403410031,55403410110,55403410111,55403410112,55403410120,55403410121,55403410123,55403410130,55403410132,55403410301,55403410303,55403410310,55403410311,55403410312,55403410330,55403410332,55403411000,55403411001,54406202011,54406200023,54406200021,54406200003,54406200001,54405133331,54405133330,54405133321,54405133303,54405133301,54405133123,54405133121,54405131233,54405131231,54405131230,54405131221,54405131203,54405131201,54405112333,54405112331,54405112313,54405112311,54405112310,54405203012,54405203010,54405111203,54405111212,54405111230,54405111233,54405111323,54405111321,54405111312,54405111313,54405200202,54405200203,54405200330,54405200333,54405200332,54405201222,54405201223,54405201232,54405111322,54405111232,55401330100,55401330101,55401330102,55401312330,55401313221,55401331123,55401331121,55401422001,55401422000,55401333110,55401331301,55401323210,55401323032,55401323031,55401323030,55401323102,55401332000,55401323111,55401323110,55401330212,55401330211,55401330120,55401322311,55401323200,55401323201,55401322230,55401322231,55402300000,55402300002,55402300020,55402300022,55402300200,54405131200,54405203030,54405203032,54405203033,54405210313,
057,00,ؼ,503142187,128418750,503198437,128475000,0,0,0,0,2,11,5339460030,5339460032,53394600120,53394600122,53394600123,53394600130,53394600132,53394600213,53394600231,53394600233,53394600310,53394600312,53394600330,
057,01,ͭĮ/ë,503085937,128400000,503156250,128484375,0,0,0,1,1,10,533946000,5339460020,53394511111,53394600210,53394600211,53394600212,53394600220,53394600221,53394600223,53394600230,53394600232,53394602001,
057,02,ո,503170312,128484375,503254687,128531250,0,0,0,0,2,11,5339460213,5339460302,53394602303,53394602310,53394602311,53394602312,53394603003,53394603012,53394603030,53394603032,53394603200,53394603201,53394603210,
057,03,,503128125,128475000,503226562,128493750,0,0,0,0,2,4,5339460210,5339460211,53394602010,53394602011,53394603000,53394603002,
057,04,ο/Į,503114062,128484375,503184375,128521875,0,0,0,0,2,9,5339460203,5339460212,53394602003,53394602012,53394602013,53394602021,53394602023,53394602210,53394602211,53394602300,53394602301,
057,05,Į/ԥë,503029687,128428125,503114062,128521875,0,0,0,0,5,19,5339451131,5339451133,5339451310,5339451311,5339451312,53394511132,53394511133,53394511301,53394511303,53394511321,53394511322,53394511323,53394513011,53394513013,53394513031,53394513033,53394513130,53394513131,53394513211,53394513300,53394600222,53394602000,53394602002,53394602020,
058,00,,503142187,128371875,503198437,128428125,0,0,0,0,2,6,5339362232,5339460010,53393622233,53393622302,53393622332,53394600110,53394600112,53394600121,
058,02,ܶ,503184375,128400000,503240625,128475000,0,0,0,0,1,17,5339460102,53394600111,53394600113,53394600131,53394600133,53394600311,53394600313,53394600331,53394600332,53394600333,53394601000,53394601002,53394601003,53394601200,53394601201,53394601202,53394601220,53394601222,
058,04,ͷĮ/Į,503226562,128428125,503268750,128484375,0,0,0,0,0,12,53394601032,53394601203,53394601210,53394601212,53394601213,53394601221,53394601223,53394601230,53394601231,53394601232,53394603001,53394603010,
058,05,,503170312,128362500,503226562,128400000,0,0,0,0,0,10,53393622301,53393622303,53393622310,53393622312,53393622313,53393622330,53393622331,53393622333,53393623220,53393623222,
058,06,//˭,503156250,128287500,503296875,128409375,0,0,0,1,9,19,533936230,5339362033,5339362120,5339362122,5339362123,5339362211,5339362213,5339362320,5339362312,5339362310,53393620311,53393620312,53393620313,53393620323,53393621212,53393622101,53393622103,53393622120,53393622121,53393622123,53393622311,53393623210,53393623211,53393623212,53393623221,53393623223,53393623230,53393623232,53394601001,
058,07,,503071875,128353125,503170312,128400000,0,0,0,0,3,12,5339362220,5339362221,5339362222,53393533310,53393533311,53393533313,53393533331,53393533333,53393622032,53393622033,53393622122,53393622230,53393622231,53393622232,53393622300,
058,08,;Į/Ǳ,503071875,128268750,503170312,128362500,0,0,0,1,6,17,533936202,5339353131,5339362002,5339362003,5339362200,5339362201,5339362202,53393531132,53393531133,53393531331,53393533111,53393533113,53393533131,53393533133,53393620120,53393620122,53393620300,53393620302,53393620320,53393620322,53393622030,53393622031,53393622100,53393622102,
058,09,Į/,503057812,128287500,503100000,128343750,0,0,0,0,0,11,53393531301,53393531303,53393531321,53393531323,53393531330,53393531332,53393531333,53393533101,53393533103,53393533110,53393533112,
058,10,,503029687,128240625,503170312,128287500,0,0,0,0,5,17,5339353110,5339353111,5339353112,5339362000,5339362001,53393513233,53393513322,53393513323,53393513332,53393513333,53393531011,53393531013,53393531031,53393531130,53393531131,53393602222,53393602223,53393602232,53393602233,53393602322,53393620100,53393620102,
059,00,ֺ,503015625,128390625,503100000,128446875,0,0,0,0,4,11,5339451101,5339451103,5339451110,5339451112,53393533233,53393533322,53393533323,53393533332,53394511110,53394511112,53394511113,53394511130,53394511131,53394511211,53394511300,
059,01,Ļ/ǻĮ,502973437,128371875,503029687,128437500,0,0,0,0,3,10,5339353322,5339451100,5339451102,53393532333,53393533202,53393533203,53393533212,53393533230,53393533232,53394510111,53394510113,53394510131,53394510133,
059,02,ϻ,503029687,128353125,503085937,128390625,0,0,0,0,1,9,5339353330,53393533033,53393533122,53393533211,53393533213,53393533231,53393533312,53393533320,53393533321,53393533330,
059,03,,502973437,128343750,503029687,128381250,0,0,0,0,0,9,53393532311,53393532313,53393533022,53393533023,53393533030,53393533032,53393533200,53393533201,53393533210,
059,04,۽,503029687,128343750,503085937,128362500,0,0,0,0,0,6,53393533031,53393533120,53393533121,53393533123,53393533130,53393533132,
059,05,/,502973437,128259375,503057812,128362500,0,0,0,0,4,24,5339353121,5339353123,5339353300,5339353301,53393531012,53393531021,53393531022,53393531023,53393531030,53393531032,53393531033,53393531200,53393531201,53393531203,53393531221,53393531223,53393531300,53393531302,53393531320,53393531322,53393532111,53393532113,53393532131,53393532133,53393533020,53393533021,53393533100,53393533102,
059,06,/ͭ,503170312,128006250,503521875,128325000,0,0,2,9,25,45,53393610,53392632,533936030,533936032,533936210,533936013,533936031,533936011,533936110,533926332,533926330,5339360122,5339360123,5339360213,5339360231,5339360233,5339360330,5339360332,5339362011,5339362013,5339362110,5339362112,5339362130,5339361200,5339360331,5339360211,5339360121,5339360103,5339262333,5339361112,5339361110,5339263332,5339263330,5339263312,5339263310,5339263132,53393601203,53393602301,53393602303,53393602321,53393602323,53393603330,53393603332,53393620101,53393620103,53393620121,53393620123,53393621110,53393621112,53393621130,53393621210,53393621211,53393621213,53393621320,53393621321,53393621322,53393612020,53393612010,53393603331,53393612021,53393612012,53393612011,53393600332,53393620310,53393620301,53393620303,53393620321,53393600333,53393601201,53393601023,53393601013,53393601011,53392623322,53392623323,53392623321,53392623312,53392623313,53393611200,53393611201,53393611210,53393611211,
060,00,/ȿ,502903125,128146875,503085937,128268750,0,0,0,2,13,26,533935121,533935130,5339351032,5339351033,5339351122,5339351201,5339351203,5339351230,5339351231,5339351312,5339351320,5339351321,5339351322,5339351330,5339353100,53393510213,53393510231,53393510232,53393510233,53393510302,53393510303,53393510312,53393510313,53393511232,53393512210,53393512211,53393512330,53393512331,53393512333,53393513102,53393513103,53393513132,53393513230,53393513231,53393513232,53393513310,53393513312,53393513320,53393513321,53393513330,53393531010,
060,01,ܹ,502889062,128221875,503001562,128296875,0,0,0,0,6,12,5339351223,5339351232,5339353001,5339353010,5339353011,5339353013,53393512203,53393512212,53393512213,53393512221,53393512223,53393512332,53393530031,53393530120,53393530121,53393530123,53393530311,53393531020,
060,02,ŷ,503071875,128090625,503226562,128240625,0,0,0,2,12,27,533936002,533936020,5339351311,5339360001,5339360002,5339360003,5339360012,5339360030,5339360032,5339360210,5339360212,5339360220,5339360221,5339360031,53392622232,53392622233,53392622322,53393511333,53393513130,53393513131,53393513133,53393513311,53393513313,53393513331,53393600002,53393600003,53393600100,53393600102,53393600130,53393600132,53393600330,53393602220,53393602221,53393602230,53393602231,53393602300,53393602302,53393602320,53393600331,53393601202,53393601200,
060,03,Į,502973437,128109375,503100000,128184375,0,0,0,0,9,13,5339351102,5339351103,5339351112,5339351113,5339351120,5339351121,5339351130,5339351131,5339351132,53393510133,53393510311,53393511103,53393511112,53393511113,53393511230,53393511231,53393511233,53393511330,53393511331,53393511332,53393513100,53393513101,
060,04,翹,502903125,128006250,503325000,128146875,0,0,0,5,30,50,533925331,533925332,533925333,533926220,533926232,5339253132,5339253133,5339253231,5339253232,5339253233,5339253301,5339253302,5339253303,5339262022,5339262210,5339262212,5339262213,5339262220,5339262221,5339262222,5339262230,5339262231,5339262233,5339262302,5339351010,5339351011,5339351012,5339351100,5339351101,5339360011,5339360100,5339262303,5339262312,5339262330,5339262313,53392531231,53392531233,53392532131,53392532132,53392532133,53392532233,53392532302,53392532303,53392533001,53392533002,53392533003,53392620232,53392620233,53392620320,53392620322,53392620323,53392622112,53392622230,53392622231,53392622320,53392622321,53392622323,53393510010,53393510011,53393510013,53393510130,53393510131,53393510132,53393510300,53393510301,53393510310,53393511100,53393511101,53393511102,53393511110,53393511111,53393600000,53393600001,53393600101,53393600103,53393600131,53393600133,53393601020,53393601022,53393601021,53393601010,53393601012,53392623320,53392623310,53392623311,
061,00,/,502832812,127875000,503606250,128100000,0,0,4,12,35,49,53392621,53392630,53392612,53392613,533925303,533925310,533925311,533925320,533926032,533926033,533926200,533926201,533926310,533926311,533926312,533927020,5339251232,5339251233,5339252311,5339252313,5339253011,5339253013,5339253021,5339253022,5339253023,5339253120,5339253121,5339253122,5339253130,5339253131,5339253210,5339253211,5339253212,5339253220,5339253221,5339253222,5339260233,5339260303,5339262020,5339262021,5339262030,5339262031,5339262033,5339262300,5339260313,5339260312,5339262301,5339262310,5339262311,5339263130,5339270220,53392512302,53392512303,53392512312,53392512313,53392513202,53392513220,53392513222,53392513223,53392521331,53392521332,53392521333,53392523121,53392523123,53392523311,53392523313,53392530100,53392530101,53392530103,53392530121,53392530122,53392530123,53392530202,53392530203,53392531230,53392531232,53392532130,53392532230,53392532231,53392532232,53392532300,53392532301,53392533000,53392602311,53392602312,53392602313,53392602321,53392602322,53392602323,53392603023,53392620230,53392620231,53392620321,53392622110,53392622111,53392622113,53392603102,53392603103,53392603112,53392603113,
061,01,ıĴ,502720312,128062500,502931250,128165625,0,0,0,1,9,32,533935011,5339252332,5339252333,5339350102,5339350103,5339350120,5339351000,5339351002,5339351003,5339351020,53392523301,53392523302,53392523303,53392523310,53392523312,53393500131,53393500132,53393500133,53393500301,53393500310,53393500311,53393501002,53393501003,53393501011,53393501012,53393501013,53393501210,53393501211,53393501212,53393501300,53393501301,53393501310,53393501311,53393501313,53393501331,53393510012,53393510210,53393510211,53393510212,53393510220,53393510221,53393510230,
062,00,ëؼ,502875000,128325000,502945312,128400000,0,0,0,0,6,6,5339353201,5339353202,5339353203,5339353220,5339353221,5339353223,53393532102,53393532120,53393532122,53393532221,53393532223,53393532320,
062,01,ë̤/ܱ׺,502931250,128334375,502973437,128381250,0,0,0,0,0,9,53393532103,53393532112,53393532121,53393532123,53393532130,53393532132,53393532300,53393532301,53393532302,
062,03,ɽƻ/,502931250,128362500,502987500,128437500,0,0,0,0,2,13,5339451010,5339451012,53393532303,53393532310,53393532312,53393532321,53393532322,53393532323,53393532330,53393532332,53394510110,53394510112,53394510130,53394510132,53393532331,
062,04,/塹ھ帶,502818750,128381250,502903125,128475000,0,0,0,0,7,15,5339352333,5339450111,5339450112,5339450113,5339450130,5339450131,5339451020,53393523323,53393532220,53393532222,53394501101,53394501102,53394501103,53394501330,53394501331,53394501333,53394510000,53394510002,53394510020,53394510022,53394510023,53394510220,
062,05,/崱,502917187,128287500,503001562,128334375,0,0,0,0,2,12,5339353032,5339353033,53393530233,53393530301,53393530303,53393530310,53393530312,53393530313,53393531202,53393531220,53393531222,53393532100,53393532101,53393532110,
062,06,ܹ,502846875,128231250,502945312,128343750,0,0,0,0,6,18,5339353000,5339353002,5339353020,5339353021,5339353022,5339353200,53393503332,53393503333,53393512220,53393512222,53393521111,53393521331,53393521333,53393523111,53393523113,53393530030,53393530032,53393530033,53393530122,53393530230,53393530231,53393530232,53393530300,53393530302,
062,07,ͳ,502790625,128146875,502903125,128250000,0,0,0,1,10,17,533935031,5339350123,5339350132,5339350301,5339350303,5339350321,5339350330,5339350331,5339350332,5339351200,5339351202,53393501213,53393501302,53393501303,53393501312,53393501330,53393501332,53393501333,53393503230,53393503231,53393503233,53393503330,53393503331,53393510222,53393510223,53393512200,53393512201,53393512202,
062,08,㲰/,502790625,128250000,502875000,128343750,0,0,0,0,7,16,5339352113,5339352121,5339352123,5339352130,5339352131,5339352132,5339352310,53393521032,53393521033,53393521101,53393521103,53393521110,53393521112,53393521113,53393521121,53393521122,53393521123,53393521330,53393521332,53393523010,53393523011,53393523110,53393523112,
062,09,Ҷ,502565625,128165625,502692187,128250000,0,0,0,1,4,19,533934133,5339341313,5339341321,5339350200,5339350202,53393413033,53393413113,53393413121,53393413122,53393413123,53393413230,53393413231,53393413233,53393500232,53393502010,53393502012,53393502030,53393502032,53393502200,53393502201,53393502202,53393502210,53393502220,53393502222,
062,10,,502692187,128146875,502790625,128231250,0,0,0,1,6,14,533935021,5339350032,5339350033,5339350122,5339350231,5339350300,5339350302,53393500231,53393500233,53393500302,53393500303,53393500312,53393500313,53393502011,53393502013,53393502031,53393502033,53393502300,53393502301,53393503200,53393503201,
062,11,,502734375,128334375,502875000,128409375,0,0,0,0,10,15,5339352213,5339352302,5339352303,5339352312,5339352313,5339352320,5339352321,5339352323,5339352330,5339352331,53393522112,53393522113,53393523002,53393523003,53393523012,53393523013,53393523221,53393523223,53393523320,53393523321,53393523322,53394501001,53394501010,53394501011,53394501100,
062,12,,502425000,128212500,502706250,128446875,0,0,1,4,19,53,53393431,533934301,533934330,533934332,533944110,5339341232,5339341233,5339341320,5339341322,5339343001,5339343003,5339343021,5339343023,5339343030,5339343031,5339343032,5339343310,5339343312,5339343330,5339343332,5339352002,5339352020,5339352022,5339352023,53393412231,53393412232,53393412233,53393412312,53393412313,53393413232,53393430003,53393430020,53393430021,53393430023,53393430201,53393430203,53393430221,53393430330,53393430331,53393430332,53393432011,53393432100,53393432131,53393432133,53393432311,53393432312,53393432313,53393432331,53393432333,53393433110,53393433112,53393433130,53393433132,53393433310,53393433312,53393433330,53393520000,53393520002,53393520003,53393520030,53393520032,53393520210,53393520212,53393520213,53394410110,53394410111,53394410113,53394410131,53394411100,53394411101,53394411102,53394411120,53394411122,53394411200,53394411201,53394411210,53394411211,
062,13,,502720312,128362500,502818750,128465625,0,0,0,0,9,18,5339352231,5339352233,5339450011,5339450013,5339450031,5339450102,5339450103,5339450120,5339450121,53393522321,53393522323,53393523220,53393523222,53394500101,53394500103,53394500121,53394500123,53394500301,53394501000,53394501002,53394501003,53394501012,53394501013,53394501220,53394501221,53394501230,53394501231,
062,14,,502537500,128362500,502734375,128493750,0,0,0,3,8,25,533935222,533944113,533945000,5339352230,5339441111,5339441113,5339441122,5339441123,5339450020,5339450021,5339450022,53393433311,53393433313,53393433331,53393433332,53393433333,53393522320,53393522322,53394411103,53394411121,53394411123,53394411202,53394411203,53394411212,53394411213,53394413100,53394413101,53394413102,53394413110,53394413111,53394500100,53394500102,53394500120,53394500122,53394500230,53394500300,
062,15,Ѳ/,502664062,128212500,502832812,128296875,0,0,0,1,8,26,533935201,5339350223,5339350232,5339350233,5339350322,5339352001,5339352100,5339352101,5339352102,53393502203,53393502211,53393502212,53393502213,53393502221,53393502223,53393502302,53393502303,53393503202,53393503203,53393503232,53393520001,53393520031,53393520033,53393520211,53393520300,53393520301,53393520310,53393520311,53393521030,53393521031,53393521100,53393521102,53393521120,53393521200,53393521201,
062,16,ë/Ʋ,502635937,128296875,502790625,128362500,0,0,0,1,5,14,533935220,5339352032,5339352033,5339352122,5339352210,5339352212,53393433111,53393433113,53393433131,53393433133,53393520302,53393520303,53393520312,53393520313,53393521202,53393521203,53393522110,53393522111,53393523000,53393523001,
063,00,,502931250,128465625,502959375,128484375,0,0,0,0,0,3,53394510322,53394512100,53394512101,
063,01,,502875000,128456250,502931250,128503125,0,0,0,0,3,7,5339451023,5339451200,5339451201,53394510221,53394510222,53394510223,53394512020,53394512021,53394512030,53394512031,
063,02,/塹,502889062,128400000,502973437,128465625,0,0,0,0,4,7,5339451001,5339451003,5339451021,5339451030,53394510001,53394510003,53394510021,53394510310,53394510312,53394510320,53394510321,
063,03,ɲĮ,502931250,128484375,502973437,128503125,0,0,0,0,0,6,53394512102,53394512103,53394512112,53394512120,53394512121,53394512130,
063,04,ɣ,502945312,128456250,502987500,128484375,0,0,0,0,0,5,53394510323,53394510330,53394510332,53394510333,53394512110,
063,05,̥ë/ǻĮ,502973437,128437500,503029687,128465625,0,0,0,0,1,6,5339451120,53394510311,53394510313,53394510331,53394511210,53394511212,53394511220,
063,06,ë,502987500,128446875,503057812,128484375,0,0,0,0,1,9,5339451123,53394511213,53394511221,53394511222,53394511223,53394511302,53394511320,53394513000,53394513001,53394513010,
063,07,Ķ/ں,503043750,128503125,503114062,128550000,0,0,0,0,2,9,5339451331,5339451332,53394513132,53394513133,53394513301,53394513302,53394513303,53394513330,53394513331,53394513332,53394602022,
063,08,Ͼ/,502903125,128475000,503043750,128568750,0,0,0,1,6,26,533945123,5339451221,5339451302,5339451320,5339451322,5339453010,5339453011,53394512032,53394512033,53394512111,53394512113,53394512122,53394512123,53394512131,53394512132,53394512133,53394512230,53394512231,53394512233,53394513002,53394513003,53394513012,53394513030,53394513032,53394513210,53394513212,53394513213,53394513230,53394513231,53394530011,53394530013,53394531000,53394531002,
063,09,,502720312,128456250,502917187,128606250,0,0,0,2,11,25,533945031,533945033,5339450132,5339450303,5339450321,5339450323,5339451220,5339451222,5339452031,5339452101,5339452103,5339452110,5339452112,53394501233,53394501332,53394503011,53394503013,53394503223,53394512022,53394512023,53394512232,53394520123,53394520132,53394520133,53394520301,53394520303,53394521001,53394521003,53394521021,53394521022,53394521023,53394521200,53394521201,53394521202,53394521210,53394521211,53394521300,53394521301,
063,10,߻/ë,502664062,128446875,502804687,128578125,0,0,0,2,12,32,533945021,533945023,5339450032,5339450033,5339450201,5339450203,5339450221,5339450223,5339450300,5339450302,5339450320,5339452001,5339452010,5339452011,53394500231,53394500232,53394500233,53394500302,53394500303,53394501222,53394501223,53394501232,53394502003,53394502021,53394502023,53394502201,53394502203,53394502221,53394502223,53394503010,53394503012,53394503220,53394503221,53394503222,53394520001,53394520003,53394520021,53394520030,53394520031,53394520120,53394520121,53394520130,53394520131,53394521000,53394521002,53394521020,
063,12,/,502509375,128475000,502678125,128587500,0,0,0,1,14,26,533944133,5339441300,5339441301,5339441303,5339441312,5339441313,5339441321,5339441323,5339443011,5339443013,5339443100,5339443101,5339443110,5339443111,5339443113,53394413020,53394413021,53394413023,53394413103,53394413112,53394413113,53394413201,53394413203,53394413221,53394413222,53394413223,53394431020,53394431021,53394431022,53394502000,53394502001,53394502002,53394502020,53394502022,53394502200,53394502202,53394502220,53394502222,53394520000,53394520002,53394520020,
063,14,/,502270312,128550000,502720312,128793750,0,0,2,13,24,59,53394432,53394433,533944212,533944213,533944230,533944231,533944233,533944302,533944303,533944312,533944313,533945202,533954101,533954110,533954111,5339442033,5339442100,5339442102,5339442103,5339442112,5339442211,5339442321,5339443012,5339443103,5339443112,5339452200,5339452201,5339452202,5339452220,5339541000,5339541001,5339541003,5339541030,5339541031,5339541033,5339541120,5339541121,5339541122,5339541130,53394420111,53394420113,53394420131,53394420133,53394420303,53394420311,53394420312,53394420313,53394420321,53394420323,53394421010,53394421012,53394421013,53394421102,53394421132,53394422130,53394422131,53394422133,53394423200,53394423201,53394423203,53394423230,53394423231,53394423233,53394430033,53394430103,53394431023,53394520022,53394520023,53394520032,53394520033,53394520122,53394520300,53394520302,53394520320,53394520322,53394522220,53394522221,53394522222,53395401111,53395410021,53395410023,53395410211,53395410321,53395411231,53395411310,53395411311,53395411320,53395411321,53395412111,53395413000,53395413001,53395413003,53395413010,53395500000,53395500002,53395500020,53395500022,53395500200,
064,00,ܶ,503128125,128521875,503198437,128596875,0,0,0,0,5,8,5339460223,5339460232,5339462001,5339462003,5339462010,53394602212,53394602213,53394602302,53394602330,53394602332,53394620120,53394620121,53394620210,
064,01,/,503128125,128578125,503184375,128625000,0,0,0,0,2,8,5339462023,5339462030,53394620122,53394620123,53394620211,53394620212,53394620213,53394620320,53394620321,53394620322,
064,02,/,503071875,128540625,503128125,128596875,0,0,0,0,4,5,5339453111,5339453113,5339462000,5339462002,53394513333,53394602222,53394602223,53394620200,53394620201,
064,03,/,502987500,128540625,503071875,128615625,0,0,0,0,7,8,5339453101,5339453102,5339453103,5339453110,5339453112,5339453121,5339453130,53394513232,53394513233,53394531001,53394531003,53394531201,53394531203,53394531230,53394531231,
064,04,ڱ/ƻ,503100000,128512500,503128125,128540625,0,0,0,0,1,2,5339460220,53394602220,53394602221,
065,00,,502846875,128578125,503043750,128690625,0,0,0,2,11,22,533945320,533945321,5339453023,5339453031,5339453032,5339453033,5339453122,5339453231,5339453300,5339453301,5339453302,5339453320,5339453321,53394523111,53394523113,53394523130,53394523131,53394530133,53394530212,53394530213,53394530222,53394530223,53394530302,53394530303,53394531200,53394531202,53394531232,53394531233,53394532201,53394532210,53394533030,53394533032,53394533033,53394533221,53394533230,
065,01,,502832812,128550000,502987500,128643750,0,0,0,0,9,16,5339452111,5339452113,5339452131,5339452133,5339453000,5339453002,5339453003,5339453012,5339453020,53394521303,53394521321,53394521323,53394523110,53394523112,53394530010,53394530012,53394530130,53394530131,53394530132,53394530210,53394530211,53394530220,53394530221,53394530300,53394530301,
065,02,,502734375,128596875,502959375,128765625,0,0,0,3,16,33,533945233,533955010,533955011,5339452123,5339452301,5339452310,5339452312,5339452322,5339452323,5339453222,5339453223,5339453230,5339550013,5339550031,5339550120,5339550121,5339550130,5339551000,5339551001,53394521203,53394521212,53394521213,53394521221,53394521223,53394521302,53394521320,53394521322,53394523031,53394523033,53394523132,53394523133,53394523211,53394532200,53394532202,53394532203,53394532211,53394532212,53394532213,53394532320,53394532321,53394532322,53395500112,53395500113,53395500330,53395500331,53395501220,53395501221,53395501230,53395501310,53395510020,53395510021,53395510100,
065,03,˭/˭,502664062,128606250,502818750,128728125,0,0,0,2,8,17,533945221,533945223,5339452033,5339452203,5339452221,5339452223,5339452300,5339452302,5339452320,5339550010,53394520321,53394520323,53394521220,53394521222,53394522223,53394523030,53394523032,53394523210,53394523212,53394523213,53395500001,53395500010,53395500011,53395500013,53395500110,53395500111,53395500121,
065,04,,502664062,128709375,502917187,128868750,0,0,1,1,19,33,53395503,533955021,5339550003,5339550021,5339550023,5339550030,5339550032,5339550132,5339550201,5339550203,5339550230,5339550231,5339550233,5339551202,5339551220,5339551222,5339552100,5339552101,5339552110,5339552111,5339553000,53395500003,53395500012,53395500021,53395500023,53395500120,53395500122,53395500123,53395500201,53395500203,53395500221,53395500223,53395500332,53395500333,53395501222,53395501223,53395501231,53395501232,53395501233,53395501332,53395502001,53395502003,53395502021,53395502211,53395502321,53395502323,53395512002,53395512003,53395512230,53395512232,53395520101,53395520111,53395530010,53395530012,
065,05,,503001562,128671875,503142187,128765625,0,0,0,0,7,36,5339453332,5339551101,5339551110,5339551111,5339551113,5339551131,5339560020,53394533223,53394533231,53394533232,53394533233,53394533302,53394533303,53394533330,53394533332,53394533333,53394622222,53394622223,53394622232,53395511001,53395511003,53395511021,53395511030,53395511031,53395511120,53395511121,53395511123,53395511301,53395511303,53395511321,53395511330,53395511331,53395600000,53395600001,53395600002,53395600010,53395600020,53395600022,53395600023,53395600210,53395600212,53395600220,53395600221,
065,06,Τ,503043750,128643750,503142187,128690625,0,0,0,0,3,15,5339453331,5339462202,5339462220,53394533122,53394533123,53394533131,53394533132,53394533133,53394533300,53394533301,53394533331,53394622030,53394622032,53394622210,53394622212,53394622220,53394622221,53394622230,
065,07,콽,502903125,128681250,503057812,128775000,0,0,0,0,9,24,5339453233,5339551003,5339551011,5339551012,5339551013,5339551030,5339551031,5339551120,5339551121,53394532323,53394533220,53394533222,53395510101,53395510102,53395510103,53395510211,53395511000,53395511002,53395511020,53395511022,53395511023,53395511032,53395511033,53395511122,53395511220,53395511221,53395511223,53395511230,53395511231,53395511232,53395511300,53395511302,53395511320,
065,08,ֱ,502846875,128728125,503057812,128859375,0,0,0,2,12,32,533955121,533955130,5339551020,5339551022,5339551023,5339551032,5339551033,5339551201,5339551203,5339551221,5339551230,5339551231,5339551320,5339551321,53395501311,53395501312,53395501313,53395501330,53395501331,53395501333,53395510022,53395510023,53395510210,53395510212,53395510213,53395511222,53395511233,53395511322,53395512000,53395512001,53395512231,53395512233,53395512320,53395512321,53395512322,53395512330,53395512331,53395513100,53395513102,53395513120,53395513122,53395513220,53395513221,53395513300,53395513302,53395530011,
065,09,ü//,503029687,128587500,503254687,128700000,0,0,0,1,10,22,533946223,5339453131,5339453132,5339453133,5339453310,5339453311,5339462022,5339462200,5339462201,5339462320,5339462322,53394533031,53394533120,53394533121,53394533130,53394620202,53394620203,53394622031,53394622033,53394622100,53394622102,53394622120,53394622122,53394622123,53394622132,53394622211,53394622213,53394622231,53394622233,53394623210,53394623212,53394623230,53394623232,
066,00,/Į,503184375,128521875,503282812,128615625,0,0,0,0,7,12,5339460322,5339462011,5339462013,5339462100,5339462102,5339462103,5339462121,53394602313,53394602331,53394602333,53394603202,53394603203,53394621012,53394621201,53394621203,53394621230,53394621231,53394621302,53394621320,
066,01,,503240625,128521875,503325000,128615625,0,0,0,0,5,17,5339460323,5339462110,5339462112,5339462113,5339462131,53394603212,53394603213,53394603302,53394603320,53394603322,53394603323,53394621010,53394621011,53394621013,53394621110,53394621112,53394621300,53394621301,53394621303,53394621321,53394621330,53394621331,
066,02,Τ,503170312,128587500,503268750,128662500,0,0,0,0,7,12,5339462031,5339462033,5339462122,5339462211,5339462300,5339462302,5339462303,53394620323,53394621200,53394621202,53394621232,53394622101,53394622103,53394622121,53394622130,53394622131,53394622133,53394623010,53394623012,
066,03,齻,503057812,128615625,503493750,128934375,0,0,3,10,23,87,53395601,53395603,53395612,533946231,533946233,533956001,533956003,533956020,533956021,533956023,533956201,533956210,533956211,5339463200,5339463202,5339463220,5339551311,5339560003,5339560023,5339560221,5339561022,5339561023,5339561032,5339561033,5339561122,5339561123,5339561300,5339562003,5339562021,5339562030,5339562031,5339562032,5339563000,5339563002,5339563011,5339563100,53394621233,53394621322,53394621323,53394621332,53394621333,53394623011,53394623013,53394623211,53394623213,53394623231,53394623233,53394630222,53394630223,53394632012,53394632030,53394632032,53394632210,53394632220,53394632222,53395511323,53395511332,53395511333,53395513101,53395513103,53395513131,53395513133,53395600003,53395600011,53395600012,53395600013,53395600021,53395600211,53395600213,53395600222,53395600223,53395602200,53395602201,53395602203,53395602230,53395602231,53395602233,53395610000,53395610002,53395610020,53395610022,53395610200,53395610202,53395610203,53395610212,53395610213,53395610302,53395610303,53395610312,53395610313,53395611202,53395611203,53395611212,53395611213,53395613010,53395613020,53395613021,53395613022,53395613200,53395613202,53395613220,53395613222,53395620013,53395620023,53395620201,53395620203,53395620230,53395620231,53395620330,53395620331,53395620332,53395621200,53395621310,53395621311,53395622101,53395630010,53395630012,53395630030,53395630032,53395630200,53395630201,53395630210,53395630212,
066,04,,503339062,128428125,503592187,128746875,0,0,0,8,28,69,533946311,533946312,533946313,533946321,533946323,533946330,533946332,533956101,5339461131,5339461132,5339461133,5339461311,5339461313,5339461331,5339461332,5339461333,5339463033,5339463101,5339463103,5339463223,5339463310,5339463312,5339463330,5339470020,5339470022,5339470200,5339470202,5339470220,5339470222,5339472000,5339472002,5339561001,5339561003,5339561100,5339561101,5339561102,53394611132,53394611133,53394611301,53394611302,53394611303,53394613101,53394613103,53394613121,53394613123,53394613233,53394613301,53394613302,53394613303,53394630311,53394630313,53394630322,53394630323,53394631021,53394631022,53394631023,53394632013,53394632031,53394632033,53394632211,53394632212,53394632213,53394632221,53394632223,53394633110,53394633111,53394633112,53394633130,53394633320,53394633322,53394700022,53394700023,53394700032,53394700210,53394700212,53394700230,53394700232,53394702010,53394702012,53394702030,53394702032,53394702210,53394702212,53394702230,53394702232,53394720200,53394720202,53394720220,53395610001,53395610003,53395610021,53395610023,53395610201,53395610210,53395610211,53395610300,53395610301,53395610310,53395610311,53395611030,53395611032,53395611200,53395611201,53395611210,53395611211,
066,05,,503451562,128428125,503718750,128850000,0,0,0,10,29,71,533947021,533947023,533947030,533947201,533947220,533947221,533947222,533956111,533956113,533956131,5339463331,5339463333,5339470030,5339470032,5339470033,5339470122,5339470320,5339470321,5339470322,5339472001,5339472003,5339472021,5339472023,5339472030,5339472032,5339472230,5339561303,5339561321,5339561330,5339561331,5339561333,5339570000,5339570001,5339570002,5339570020,5339570022,5339570200,5339570203,5339570222,53394633113,53394633131,53394633132,53394633133,53394633321,53394633323,53394700033,53394700211,53394700213,53394700231,53394700233,53394700312,53394700313,53394701202,53394701232,53394702011,53394702013,53394702031,53394702033,53394702211,53394702213,53394702231,53394702233,53394703230,53394703231,53394703232,53394720201,53394720203,53394720221,53394720222,53394720223,53394720310,53394720311,53394720312,53394720330,53394720332,53394721000,53394721001,53394721002,53394721020,53394722310,53394722311,53394722312,53394722320,53394722321,53394722322,53395611031,53395611033,53395613011,53395613012,53395613013,53395613023,53395613201,53395613203,53395613221,53395613223,53395613230,53395613231,53395613320,53395613321,53395613323,53395700030,53395700032,53395702010,53395702012,53395702013,53395702020,53395702021,53395702120,53395702122,53395702202,
067,00,ξ,503254687,128475000,503325000,128540625,0,0,0,1,1,11,533946031,5339460331,53394603011,53394603013,53394603031,53394603033,53394603211,53394603300,53394603301,53394603303,53394603321,53394603330,53394603331,
067,01,ӻĮ/Ƚ,503296875,128437500,503395312,128634375,0,0,0,0,12,24,5339461020,5339461022,5339461200,5339461202,5339461220,5339461222,5339463000,5339463001,5339463002,5339463020,5339463021,5339463023,53394603332,53394603333,53394610210,53394610212,53394610230,53394610232,53394612010,53394612012,53394612030,53394612032,53394612210,53394612212,53394612230,53394612232,53394612233,53394621111,53394621113,53394630030,53394630032,53394630100,53394630220,53394630221,53394632010,53394632011,
067,02,,503367187,128428125,503507812,128615625,0,0,0,1,14,41,533946123,5339461123,5339461212,5339461213,5339461301,5339461302,5339461303,5339461320,5339461321,5339461322,5339463011,5339463012,5339463013,5339463030,5339463100,53394611023,53394611201,53394611203,53394611210,53394611212,53394611213,53394611221,53394611223,53394612011,53394612013,53394612031,53394612033,53394612100,53394612102,53394612103,53394612112,53394612113,53394612211,53394612213,53394612231,53394613001,53394613002,53394613003,53394613100,53394613102,53394613120,53394613122,53394613230,53394613231,53394613232,53394613300,53394630031,53394630033,53394630101,53394630102,53394630103,53394630310,53394630312,53394630320,53394630321,53394631020,
067,03,,503254687,128428125,503325000,128475000,0,0,0,1,0,7,533946013,53394601033,53394601122,53394601123,53394601132,53394601133,53394601211,53394601233,
067,04,,503240625,128362500,503310937,128428125,0,0,0,0,4,13,5339362330,5339362332,5339460101,5339460110,53393623213,53393623231,53393623233,53393623312,53393623330,53393623332,53394601030,53394601031,53394601110,53394601112,53394601120,53394601121,53394601130,
067,05,ھ,503310937,128381250,503367187,128437500,0,0,0,0,3,11,5339363222,5339461000,5339461002,53393623331,53393623333,53393632230,53393632232,53394601111,53394601113,53394601131,53394610010,53394610012,53394610030,53394610032,
067,06,ä̦/ھ,503282812,128137500,503521875,128400000,0,0,1,7,20,21,53393630,533936122,533936123,533936320,533936321,533936323,533936121,533936130,5339361203,5339361320,5339361322,5339362131,5339362133,5339363100,5339363102,5339363120,5339363122,5339363220,5339363221,5339363300,5339363302,5339363320,5339361321,5339361123,5339361122,5339361130,5339362311,5339362313,53393603333,53393612013,53393612022,53393612023,53393621111,53393621113,53393621131,53393621132,53393621133,53393621323,53393623310,53393623311,53393623313,53393632231,53393632233,53393633220,53393633221,53393611202,53393611212,53393611203,53393611213,
067,07,Į,503367187,128390625,503465625,128484375,0,0,0,2,1,21,533946101,533946103,5339461100,53393633222,53393633223,53394610011,53394610013,53394610031,53394610033,53394610211,53394610213,53394610231,53394610233,53394611020,53394611021,53394611022,53394611200,53394611202,53394611220,53394611222,53394612101,53394612110,53394612111,53394613000,
067,08,׳,503465625,128156250,503606250,128446875,0,0,0,5,25,24,533936313,533936331,533936333,533937220,533937222,5339363103,5339363121,5339363123,5339363301,5339363303,5339363321,5339363323,5339372022,5339461101,5339461103,5339461110,5339461111,5339461112,5339470000,5339470001,5339363101,5339361323,5339361132,5339363110,5339363112,5339363113,5339361330,5339361332,5339361310,5339361312,53393720200,53393720202,53393720203,53393720230,53393720232,53394611130,53394611131,53394611211,53394611300,53394700020,53394700021,53394700030,53394700031,53393631110,53393631112,53393631113,53393613330,53393613332,53393613310,53393613312,53393613130,53393613132,53393613110,53393613112,
068,00,Ⱦͻ/,502298437,128362500,502551562,128587500,0,0,1,6,19,50,53394412,533944012,533944013,533944031,533944033,533944102,533944103,5339342323,5339343223,5339343230,5339343232,5339440101,5339440102,5339440103,5339440301,5339440303,5339440321,5339440323,5339441001,5339441003,5339441010,5339441012,5339442111,5339443000,5339443001,5339443002,53393423223,53393432212,53393432213,53393432221,53393432223,53393432330,53393432332,53394400131,53394400133,53394400311,53394400313,53394400331,53394400333,53394401001,53394401002,53394401003,53394403000,53394403001,53394403003,53394403023,53394403201,53394403203,53394403221,53394403222,53394403223,53394410001,53394410003,53394410021,53394410023,53394410112,53394410130,53394410132,53394410133,53394413022,53394413200,53394413202,53394413220,53394421011,53394421100,53394421101,53394421103,53394421130,53394421131,53394421133,53394430030,53394430031,53394430032,53394430100,53394430101,53394430102,
068,01,ʬ/Ω,501918750,128400000,502340625,128681250,0,0,2,12,29,97,53394331,53394402,533943102,533943120,533943122,533943123,533943131,533943132,533943133,533943301,533943303,533944200,533944202,533944220,5339430113,5339430131,5339430133,5339430331,5339431002,5339431003,5339431210,5339431212,5339431301,5339431302,5339431303,5339432133,5339433000,5339433021,5339433022,5339433023,5339433201,5339433210,5339433211,5339433213,5339433300,5339433302,5339433311,5339433313,5339440022,5339440023,5339442010,5339442012,5339442210,53394301113,53394301301,53394301302,53394301303,53394301320,53394301321,53394303111,53394303113,53394303131,53394303132,53394303133,53394303331,53394303333,53394310001,53394310002,53394310003,53394310012,53394310013,53394310100,53394310102,53394310120,53394310122,53394310300,53394310302,53394310320,53394310322,53394311222,53394311223,53394311232,53394311333,53394312132,53394313000,53394313001,53394313003,53394321111,53394321112,53394321113,53394321131,53394321322,53394321323,53394330010,53394330011,53394330013,53394330031,53394330033,53394330202,53394330203,53394332000,53394332001,53394332003,53394332120,53394332121,53394332311,53394333010,53394333011,53394333012,53394333030,53394333032,53394333100,53394333101,53394333103,53394333121,53394333123,53394333200,53394333201,53394333301,53394333310,53394333311,53394400203,53394400312,53394400320,53394400322,53394400330,53394400332,53394403002,53394403020,53394403021,53394403022,53394403200,53394403202,53394403220,53394420110,53394420112,53394420130,53394420132,53394420300,53394420301,53394420302,53394420310,53394420320,53394420322,53394422120,53394422121,53394422122,53394422200,53394422201,53394422202,
068,02,,501539062,128634375,502368750,129234375,0,1,14,29,68,171,5339532,53395231,53395303,53395311,53395312,53395313,53395330,53395331,53395332,53395402,53396300,53396301,53396303,53396310,53396312,533944223,533952301,533952303,533952321,533952330,533952331,533952333,533953021,533953022,533953023,533953101,533953103,533953330,533954000,533954001,533954002,533954010,533954200,533954201,533954203,533962111,533962113,533963020,533963021,533963023,533963201,533963210,533963211,533963212,5339433230,5339433232,5339433233,5339433321,5339433322,5339433323,5339433332,5339433333,5339442221,5339442222,5339442223,5339442322,5339523021,5339523023,5339523201,5339523321,5339523323,5339530021,5339530023,5339530032,5339530033,5339530122,5339530123,5339530132,5339530133,5339530203,5339531003,5339531021,5339531022,5339531023,5339533310,5339533311,5339533312,5339533320,5339533321,5339533322,5339533330,5339540121,5339540302,5339540320,5339540322,5339542020,5339542021,5339542100,5339542102,5339542103,5339542120,5339542122,5339542211,5339621101,5339621103,5339621121,5339621123,5339621301,5339621310,5339621311,5339630220,5339630221,5339630223,5339631100,5339631102,5339632031,5339632130,5339633000,5339633001,5339633010,5339633011,5339633013,53394332122,53394332123,53394332213,53394332231,53394332233,53394332310,53394332312,53394332313,53394333013,53394333031,53394333033,53394333102,53394333120,53394333122,53394333202,53394333203,53394333300,53394333302,53394333303,53394333312,53394333313,53394422123,53394422132,53394422203,53394423202,53394423232,53395212323,53395212332,53395213233,53395213322,53395213323,53395213332,53395213333,53395230013,53395230031,53395230032,53395230033,53395230221,53395230223,53395232001,53395232003,53395232030,53395232031,53395232033,53395232300,53395232301,53395232311,53395233200,53395233201,53395233203,53395233221,53395233223,53395300301,53395300302,53395300303,53395300310,53395300312,53395300313,53395301202,53395301203,53395301212,53395301213,53395301302,53395301303,53395301312,53395301313,53395302011,53395302013,53395302022,53395302023,53395310011,53395310012,53395310013,53395310021,53395310023,53395310201,53395310202,53395310203,53395333130,53395333132,53395333230,53395333231,53395333232,53395333320,53395400302,53395400310,53395400311,53395400320,53395400322,53395400323,53395401200,53395401201,53395401203,53395403000,53395403002,53395403003,53395403030,53395403032,53395403033,53395403210,53395403211,53395403212,53395420220,53395420221,53395420222,53395420230,53395420231,53395421010,53395421012,53395421013,53395421210,53395421212,53395421230,53395421231,53395422101,53395423000,53395423002,53395423020,53396211001,53396211003,53396211021,53396211023,53396211201,53396211203,53396213131,53396213133,53396213311,53396311010,53396311012,53396311030,53396311032,53396311200,53396311201,53396311202,53396311220,53396311222,53396313000,53396313020,53396313022,53396313200,53396313202,53396313220,53396320011,53396320013,53396320031,53396320301,53396320303,53396320330,53396320331,53396320333,53396321310,53396321311,53396321312,53396321320,53396321321,53396321322,53396321330,53396322111,53396323000,53396323001,53396323010,53396323011,53396330020,53396330021,53396330030,53396330120,53396330121,53396330123,53396330200,53396330310,53396330311,
069,00,ǽ/,500765625,128934375,501848437,129571875,0,7,12,19,85,148,5339612,5339613,5339620,5339622,5339623,5339711,5339720,53396103,53396111,53396112,53396113,53396210,53396212,53397100,53397101,53397210,53397212,53397220,53397221,533952322,533960133,533961013,533961022,533961023,533961102,533961103,533962132,533963202,533963220,533963222,533970111,533971031,533971033,533971311,533972110,533972130,533972132,533972230,5339522313,5339522331,5339522332,5339522333,5339523202,5339523232,5339523233,5339601303,5339601312,5339601313,5339601321,5339603111,5339603113,5339603131,5339603133,5339603311,5339603313,5339603331,5339603333,5339610113,5339610121,5339610123,5339610202,5339610203,5339610211,5339610212,5339610213,5339611001,5339611002,5339611003,5339611012,5339621122,5339621300,5339621302,5339621303,5339621312,5339621330,5339621332,5339621333,5339630222,5339632000,5339632002,5339632032,5339632210,5339632212,5339701101,5339701103,5339701131,5339710211,5339710300,5339710301,5339710303,5339712111,5339712113,5339713000,5339713001,5339713010,5339713100,5339713101,5339713103,5339713121,5339713130,5339713131,5339713133,5339721110,5339721111,5339721113,5339721120,5339721122,5339721123,5339721312,5339721330,5339721332,5339722200,5339722201,5339722210,5339722211,5339722310,5339723000,5339723001,5339723002,5339723020,5339723100,5339723101,5339730000,53395133232,53395133233,53395133322,53395133323,53395133332,53395133333,53395222222,53395222223,53395222232,53395222233,53395222322,53395222323,53395223112,53395223113,53395223121,53395223123,53395223222,53395223223,53395223231,53395223232,53395223233,53395223301,53395223303,53395232032,53395232302,53395232303,53395232310,53395232312,53395232313,53395233202,53395233220,53395233222,53396013231,53396031100,53396031101,53396031103,53396031121,53396031123,53396033103,53396033121,53396033123,53396033301,53396033303,53396033321,53396033322,53396033323,53396100333,53396101113,53396101123,53396101221,53396101222,53396101223,53396102013,53396102102,53396102103,53396110001,53396110002,53396110003,53396110102,53396110103,53396110113,53396110131,53396110132,53396110133,53396211000,53396211002,53396211020,53396211022,53396211200,53396211202,53396213130,53396213132,53396213310,53396213312,53396213313,53396320010,53396320012,53396320030,53396320032,53396320033,53396320300,53396320302,53396320332,53396322110,53396322112,53397011300,53397011301,53397011331,53397102100,53397102101,53397102103,53397103020,53397103021,53397103211,53397103213,53397103231,53397121100,53397121101,53397121103,53397121121,53397121123,53397130020,53397130021,53397130030,53397130031,53397130110,53397130120,53397131021,53397131023,53397131321,53397133111,53397211121,53397211123,53397211210,53397211212,53397213102,53397213103,53397222130,53397222131,53397222133,53397222311,53397223110,53397223111,53397223112,53397223120,53397223121,53397223200,53397223201,53397223210,53397230030,53397230032,53397230100,53397230101,53397230102,53397230110,53397230111,53397230113,53397230131,53397230210,53397230220,53397230222,53397231020,53397231021,53397231023,53397231030,53397231032,53397300010,53397300020,
070,00,/쾾,500948437,129018750,502453125,129993750,1,5,26,60,140,320,543902,5339731,5339732,5339733,5439011,5439030,53396331,53396332,53396333,53396402,53396420,53396422,53397132,53397232,53397233,53397301,53397302,53397303,53397400,53397402,54390103,54390130,54390131,54390133,54390310,54390311,54390312,54390320,54390321,54390322,54390330,54390403,533963131,533963133,533963223,533963231,533963232,533963233,533964003,533964212,533964230,533971302,533971303,533971330,533971332,533971333,533972113,533972222,533972233,533972303,533972311,533972312,533972313,533973001,533973002,533973003,533974200,533974202,533974220,543901011,543901013,543901210,543901211,543901213,543901230,543901231,543901232,543901321,543903130,543903131,543903132,543903230,543903231,543903310,543903320,543903321,543904000,543904002,543904003,543904012,543904020,543904021,543912001,543912010,543912011,543912013,543912100,543912110,543912111,543912112,543913000,543913001,5339631112,5339631121,5339631123,5339631130,5339631132,5339631133,5339631301,5339631303,5339631321,5339631323,5339632213,5339632302,5339632303,5339633021,5339633022,5339633023,5339633030,5339633032,5339633033,5339640021,5339640022,5339640023,5339640300,5339640322,5339640323,5339642100,5339642102,5339642130,5339642320,5339642322,5339712131,5339712132,5339712133,5339712310,5339712311,5339712313,5339712331,5339712333,5339713013,5339713120,5339713122,5339713123,5339713310,5339713312,5339713313,5339721311,5339721313,5339721331,5339721333,5339722202,5339722203,5339722212,5339722230,5339722232,5339722233,5339722313,5339722322,5339722323,5339723012,5339723023,5339730003,5339740100,5339740102,5339740120,5339740122,5339740300,5339740302,5339740320,5339742010,5339742012,5339742030,5339742220,5339742222,5439010101,5439010103,5439010121,5439010122,5439010123,5439012120,5439012121,5439012123,5439012330,5439012331,5439012332,5439013200,5439013201,5439013231,5439013233,5439031330,5439031331,5439031332,5439032320,5439032322,5439033110,5439033112,5439033120,5439033121,5439033122,5439033130,5439033220,5439033221,5439033223,5439033230,5439033232,5439040010,5439040012,5439040130,5439040132,5439040133,5439040231,5439040233,5439042011,5439042013,5439042031,5439042100,5439042101,5439042102,5439110100,5439110101,5439110110,5439111011,5439111100,5439120001,5439120121,5439120123,5439121010,5439121011,5439121012,5439121020,5439121022,5439121030,5439121130,5439121131,5439130020,5439130021,5439130030,5439130031,5439130032,5439130100,5439130102,53396311031,53396311033,53396311203,53396311221,53396311223,53396311310,53396311312,53396311313,53396313001,53396313002,53396313003,53396313021,53396313023,53396313201,53396313203,53396313221,53396313222,53396313223,53396321313,53396321323,53396321331,53396321332,53396321333,53396322113,53396323002,53396323003,53396323012,53396323013,53396330022,53396330023,53396330031,53396330032,53396330033,53396330122,53396330201,53396330202,53396330203,53396330312,53396330313,53396400033,53396400121,53396400122,53396400123,53396400130,53396400132,53396400201,53396400202,53396400203,53396401222,53396403020,53396403021,53396403200,53396403202,53396403203,53396403212,53396403213,53396403302,53396403320,53396403322,53396421010,53396421011,53396421012,53396421030,53396421032,53396421033,53396421100,53396421320,53396421322,53396423100,53396423102,53396423120,53396423122,53396423210,53396423212,53396423230,53396423232,53397121301,53397121302,53397121303,53397123011,53397123013,53397123120,53397123121,53397123123,53397123233,53397123301,53397123303,53397123321,53397123322,53397123323,53397130022,53397130023,53397130032,53397130033,53397130111,53397130112,53397130113,53397130121,53397130122,53397130123,53397131020,53397131022,53397131320,53397131322,53397131323,53397133110,53397133112,53397133113,53397211120,53397211122,53397211211,53397211213,53397213100,53397213101,53397222132,53397222310,53397222312,53397222313,53397223113,53397223122,53397223123,53397223202,53397223203,53397223211,53397223212,53397223213,53397230031,53397230033,53397230103,53397230112,53397230130,53397230132,53397230133,53397230211,53397230212,53397230213,53397230221,53397230223,53397231022,53397231031,53397231033,53397300011,53397300012,53397300013,53397300021,53397300022,53397300023,53397401010,53397401012,53397401030,53397401032,53397401210,53397401212,53397401230,53397401232,53397403010,53397403220,53397403221,53397420110,53397420320,53397422210,53397422212,53397422232,53397422233,54390100331,54390100333,54390101023,54390101201,54390101202,54390101203,54390102111,54390102113,54390102131,54390102331,54390102333,54390120111,54390121221,54390121222,54390121223,54390122311,54390122313,54390122331,54390122333,54390123330,54390123331,54390123332,54390132020,54390132021,54390132022,54390132031,54390132033,54390132200,54390132300,54390132301,54390132303,54390132321,54390132323,54390313330,54390313331,54390313332,54390323210,54390323230,54390323232,54390323311,54390331110,54390331112,54390331130,54390331230,54390331231,54390331232,54390331320,54390331321,54390332310,54390332312,54390333000,54390333001,54390333002,54390333020,54390333022,54390400130,54390400132,54390400133,54390401022,54390401023,54390401032,54390401033,54390401101,54390401103,54390401112,54390401121,54390401122,54390401123,54390401130,54390401132,54390401310,54390401312,54390401313,54390402200,54390402201,54390402210,54390402211,54390402300,54390402301,54390402303,54390402323,54390412020,54390412022,54390412200,54390412201,54390412202,54390412220,54390412222,54390420101,54390420103,54390420123,54390420301,54390421030,54390421032,54390421100,54390421101,54390421102,54390421110,54390421111,54390421200,54390421202,54390430000,54391100111,54391100113,54391101020,54391101021,54391101030,54391110101,54391110103,54391111010,54391111011,54391111012,54391111100,54391111101,54391111110,54391111111,54391200001,54391200030,54391200031,54391200033,54391200301,54391200303,54391200310,54391200311,54391200312,54391201200,54391203010,54391203011,54391203100,54391203101,54391203103,54391203110,54391203111,54391203112,54391210130,54391210131,54391210133,54391210210,54391210211,54391210213,54391210311,54391210313,54391211320,54391211321,54391212000,54391300220,54391300221,54391300230,54391300231,54391300233,54391300330,54391301010,54391301012,54391301030,54391301032,54391301200,
070,01,¸/ī/ٻθ,502129687,128700000,502762500,129187500,0,0,4,27,50,140,53395430,53395431,53395432,53396410,533954013,533954031,533954033,533954120,533954122,533954123,533954131,533954132,533954133,533954211,533954213,533954220,533954222,533954223,533954231,533954232,533954233,533954330,533954331,533954332,533955200,533964010,533964011,533964013,533964031,533964110,533964120,5339533331,5339533333,5339540033,5339540110,5339540112,5339540113,5339540122,5339540123,5339540301,5339540323,5339541020,5339541022,5339541023,5339541133,5339541210,5339541212,5339541213,5339541302,5339541303,5339542212,5339542213,5339542301,5339542303,5339543330,5339543331,5339543332,5339550220,5339550222,5339550223,5339552020,5339631110,5339631111,5339631113,5339640000,5339640001,5339640002,5339640010,5339640011,5339640120,5339640121,5339640123,5339640301,5339640303,5339640331,5339640333,5339641120,5339641210,5339641220,5339641221,5339642112,53395333131,53395333133,53395333233,53395333321,53395333322,53395333323,53395400300,53395400301,53395400303,53395400312,53395400313,53395400321,53395401110,53395401112,53395401113,53395401202,53395403001,53395403031,53395403213,53395410020,53395410022,53395410210,53395410212,53395410213,53395410320,53395410322,53395410323,53395411230,53395411232,53395411233,53395411312,53395411313,53395411322,53395411323,53395412110,53395412112,53395412113,53395413002,53395413011,53395413012,53395413013,53395420223,53395420232,53395420233,53395421011,53395421211,53395421213,53395421232,53395421233,53395422100,53395422102,53395422103,53395423001,53395423003,53395423021,53395423022,53395423023,53395433330,53395433332,53395500202,53395500220,53395500222,53395502000,53395502002,53395502020,53395502022,53395502023,53395502210,53395502212,53395502213,53395502320,53395502322,53395520100,53395520102,53395520103,53395520110,53395520112,53395520113,53395520120,53395520121,53395520122,53395520130,53395520210,53395520211,53395520213,53395520220,53395520221,53395520222,53395520231,53395520233,53395520300,53395520302,53395520320,53395522000,53395522002,53395522020,53395522022,53396311011,53396311013,53396311311,53396400030,53396400031,53396400032,53396400120,53396400131,53396400133,53396400200,53396401220,53396401221,53396401223,53396403022,53396403023,53396403201,53396403210,53396403211,53396403300,53396403301,53396403303,53396403321,53396403323,53396411100,53396411120,53396411210,53396411220,53396412110,53396412111,53396412112,53396412120,53396412121,53396412122,53396412300,53396412302,53396421013,53396421031,53396421101,53396421102,53396421103,53396421110,53396421111,53396421112,
071,00,,502228125,129131250,503001562,129740625,0,2,15,17,66,170,5339741,5339743,53396430,53396432,53396433,53396522,53396523,53397421,53397423,53397500,53397501,53397502,53397520,53397522,53397523,54390410,54390411,533964233,533965320,533965321,533965322,533974011,533974013,533974031,533974033,533974221,533974223,533975030,533975031,533975032,533975212,533975213,543905000,543905002,5339641222,5339641223,5339641232,5339641233,5339642113,5339642131,5339642133,5339642311,5339642313,5339652023,5339652032,5339652033,5339652122,5339652123,5339652132,5339652133,5339653022,5339653023,5339653032,5339653033,5339653230,5339653231,5339653232,5339740303,5339740321,5339740323,5339742013,5339742031,5339742033,5339750330,5339750332,5339751000,5339751001,5339751002,5339751020,5339752100,5339752101,5339752102,5339753020,5339753022,5339753200,5339753202,5339753220,5339753222,5439040011,5439040100,5439040101,5439041200,5439041201,5439041210,5439041211,5439041300,5439041301,5439041303,5439041310,5439041311,5439050010,5439050011,5439050012,5439050030,5439050032,5439050100,5439050101,5439050200,5439050201,5439050210,53396413220,53396413222,53396421113,53396421321,53396421323,53396423101,53396423103,53396423121,53396423123,53396423211,53396423213,53396423231,53396423233,53396431000,53396431002,53396431020,53396431022,53396431200,53396431202,53396431220,53396431222,53396431223,53396431232,53396431233,53396431322,53396431323,53396431332,53396431333,53396520212,53396520213,53396520221,53396520222,53396520223,53396520302,53396520303,53396520312,53396520313,53396521202,53396521203,53396521212,53396521213,53396521302,53396521303,53396521312,53396521313,53396530202,53396530203,53396530212,53396530213,53396530302,53396530303,53396530312,53396530313,53396531202,53396531220,53396531222,53396533000,53396533002,53396533020,53396533022,53396533200,53397401011,53397401013,53397401031,53397401033,53397401211,53397401213,53397401231,53397401233,53397403011,53397403012,53397403013,53397403222,53397403223,53397420111,53397420112,53397420113,53397420321,53397420322,53397420323,53397422211,53397422213,53397422230,53397422231,53397503310,53397503311,53397503312,53397503330,53397503332,53397510030,53397510032,53397510210,53397510220,53397510222,53397512000,53397512002,53397512020,53397512022,53397512200,53397521030,53397521032,53397521033,53397521100,53397521101,53397521102,53397530210,53397530212,53397530230,53397530232,53397532010,53397532012,53397532030,53397532032,53397532210,53397532212,53397532230,53397532232,54390400131,54390401020,54390401021,54390401030,54390401031,54390401100,54390401102,54390401110,54390401111,54390401113,54390401120,54390401131,54390401133,54390401311,54390412021,54390412023,54390412030,54390412031,54390412032,54390412120,54390412203,54390412210,54390412212,54390412221,54390412230,54390413021,54390413023,54390413120,54390413122,54390500130,54390500131,54390500132,54390500310,54390500312,54390500330,54390500332,54390501020,54390501021,54390501030,54390501031,54390501100,54390501101,54390501110,54390501111,54390502030,54390502031,54390502110,54390502112,54390502120,54390502121,54390502130,54390510000,54390510001,
071,01,,502495312,128868750,503071875,129253125,0,0,3,22,42,109,53396500,53396502,53396503,533955212,533955213,533955221,533955222,533955223,533964113,533964130,533964131,533964133,533964311,533965010,533965012,533965013,533965122,533965123,533965200,533965201,533965210,533965211,533965300,533965301,533965310,5339552031,5339552033,5339552102,5339552103,5339552112,5339552113,5339552201,5339552203,5339552300,5339552301,5339552302,5339552310,5339552320,5339552322,5339553002,5339553020,5339641111,5339641113,5339641123,5339641213,5339641231,5339641320,5339641321,5339641323,5339643101,5339643103,5339643121,5339643130,5339643131,5339650112,5339651022,5339651200,5339651202,5339651203,5339651212,5339651213,5339651322,5339652020,5339653112,5339653121,5339653123,5339653130,53395433331,53395433333,53395520123,53395520131,53395520132,53395520133,53395520212,53395520223,53395520230,53395520232,53395520301,53395520303,53395520321,53395520322,53395520323,53395522001,53395522003,53395522021,53395522023,53395523030,53395523032,53395523110,53395523111,53395523230,53395523232,53395530210,53395530212,53395530220,53395530221,53395530230,53396411101,53396411102,53396411103,53396411121,53396411122,53396411123,53396411211,53396411212,53396411213,53396411221,53396411222,53396411223,53396412113,53396412123,53396412301,53396412303,53396413221,53396413223,53396431001,53396431003,53396431021,53396431023,53396431201,53396431203,53396431221,53396431230,53396431231,53396431320,53396431321,53396431330,53396431331,53396501100,53396501102,53396501103,53396510202,53396510203,53396512010,53396512012,53396512013,53396513202,53396513232,53396513233,53396520210,53396520211,53396520220,53396520300,53396520301,53396520310,53396520311,53396521200,53396521201,53396521210,53396521211,53396521300,53396521301,53396521310,53396521311,53396530200,53396530201,53396530210,53396530211,53396530300,53396530301,53396530310,53396530311,53396531100,53396531102,53396531200,53396531201,53396531203,53396531221,53396531223,53396531320,53396531322,53396533001,53396533003,53396533010,53396533012,53396533021,
071,02,,502790625,128793750,503240625,129187500,0,0,4,15,28,79,53395531,53395532,53395533,53396511,533955233,533955301,533955303,533956220,533956222,533956223,533965100,533965101,533965103,533965130,533965131,533965133,533966000,533966002,533966020,5339551323,5339551331,5339551332,5339551333,5339552312,5339552313,5339552321,5339553003,5339560222,5339562000,5339562022,5339562212,5339650111,5339650113,5339651021,5339651023,5339651210,5339651211,5339651321,5339653111,5339653113,5339660010,5339660011,5339660012,5339660030,5339660220,5339660221,5339660222,53395512323,53395512332,53395512333,53395513121,53395513123,53395513130,53395513132,53395513222,53395513223,53395513301,53395513303,53395523031,53395523033,53395523112,53395523113,53395523231,53395523233,53395530013,53395530211,53395530213,53395530222,53395530223,53395530231,53395530232,53395530233,53395602202,53395602232,53395620010,53395620011,53395620012,53395620020,53395620021,53395620022,53395620200,53395620202,53395620232,53395620233,53395622100,53395622102,53395622103,53395622130,53395622132,53395622133,53395623022,53395623200,53395623201,53395623202,53396501101,53396510200,53396510201,53396512011,53396513200,53396513201,53396513203,53396513230,53396513231,53396531101,53396531103,53396600130,53396600131,53396600132,53396600310,53396600312,53396600320,53396600321,53396600322,53396602100,53396602102,53396602120,53396602122,53396602230,53396602231,53396602232,53396602300,53396602301,53396620000,53396620001,53396620002,53396620020,
072,00,/,503170312,128803125,503648437,129121875,0,0,5,14,37,81,53395632,53395633,53396601,53396610,53396611,533956231,533956233,533956303,533956311,533956312,533956313,533957200,533957202,533957220,533957222,533966121,533967000,533967002,533967020,5339562121,5339562122,5339562123,5339562130,5339562132,5339562133,5339562211,5339562300,5339562301,5339562303,5339562321,5339562322,5339562323,5339563010,5339563012,5339563013,5339563022,5339563023,5339563101,5339563102,5339563103,5339570221,5339570223,5339660033,5339660211,5339660301,5339661200,5339661201,5339661203,5339661300,5339661301,5339661310,5339661311,5339661313,5339670032,5339670210,5339670212,53395613232,53395613233,53395613322,53395620333,53395621201,53395621202,53395621203,53395621312,53395621313,53395622131,53395623020,53395623021,53395623023,53395623203,53395630011,53395630013,53395630031,53395630033,53395630202,53395630203,53395630211,53395630213,53395702022,53395702023,53395702200,53395702201,53395702203,53395702300,53395702302,53395702320,53395702322,53395720100,53395720102,53395720120,53395720122,53395720300,53395720302,53395720320,53395720322,53395722100,53395722102,53396600133,53396600311,53396600313,53396600323,53396602101,53396602103,53396602121,53396602123,53396602130,53396603000,53396603001,53396603003,53396603100,53396603101,53396603111,53396603113,53396612210,53396612211,53396612300,53396612301,53396612310,53396612311,53396613020,53396613021,53396613030,53396613031,53396613120,53396613121,53396613123,53396700100,53396700102,53396700120,53396700122,53396700300,53396700302,53396700303,53396702112,53396702130,53396702132,53396702200,
072,01,״/,502157812,129571875,503339062,130340625,0,5,19,39,83,221,5439052,5439141,5439143,5439150,5439152,54390431,54390432,54390433,54390503,54390511,54390512,54390513,54390530,54390531,54390532,54390600,54390602,54390620,54391403,54391421,54391423,54391510,54392410,54392501,543904123,543904132,543904133,543904301,543904302,543904303,543905012,543905013,543905022,543905023,543905101,543905102,543905103,543905330,543905331,543906032,543906220,543906221,543914203,543914221,543914222,543914223,543915120,543915121,543915122,543915300,543915302,543924000,543924001,543924010,543924011,543924013,543924110,543924111,543924112,543924121,543925000,543925001,543925003,5339753232,5339753233,5339753322,5339753323,5339753332,5339753333,5339762222,5439041213,5439041313,5439042323,5439042331,5439042332,5439042333,5439043001,5439043002,5439043003,5439050112,5439050113,5439050202,5439051001,5439051002,5439051003,5439053320,5439053321,5439053322,5439053330,5439053331,5439060302,5439060330,5439060332,5439062100,5439062101,5439062102,5439062120,5439062220,5439133333,5439140110,5439140111,5439140113,5439140121,5439140123,5439140131,5439140132,5439140133,5439142011,5439142013,5439142202,5439142203,5439151100,5439151102,5439151120,5439151122,5439151230,5439151231,5439151232,5439151300,5439153010,5439153200,5439153202,5439153220,5439231111,5439240020,5439240021,5439240030,5439240031,5439240120,5439240121,5439240311,5439241130,5439241131,5439241200,5439241201,5439241231,5439241300,5439241301,5439241302,5439250020,5439250021,5439250023,5439250301,5439250303,5439250310,5439250311,53397532231,53397532233,53397532302,53397532303,53397622230,53397622232,54390412033,54390412121,54390412122,54390412123,54390412211,54390412213,54390412223,54390412231,54390412232,54390412233,54390413020,54390413022,54390413121,54390413123,54390421113,54390421131,54390421133,54390421311,54390421313,54390421333,54390423111,54390423113,54390423131,54390423132,54390423133,54390423212,54390423213,54390423301,54390423302,54390423303,54390430001,54390430002,54390430003,54390500133,54390500311,54390500313,54390500331,54390500333,54390501022,54390501023,54390501032,54390501033,54390501102,54390501103,54390501112,54390501113,54390502032,54390502033,54390502111,54390502113,54390502122,54390502123,54390502131,54390502132,54390502133,54390510002,54390510003,54390533230,54390533231,54390533320,54390533321,54390533330,54390533331,54390601000,54390601002,54390601020,54390601022,54390601200,54390601202,54390603002,54390603032,54390603033,54390603122,54390603123,54390603132,54390603133,54390603310,54390603311,54390603312,54390603330,54390612022,54390621030,54390621031,54390621032,54390621100,54390621101,54390621102,54390621210,54390621212,54390621220,54390621221,54390621222,54390622210,54390622211,54390622220,54390622300,54390622301,54390622310,54390622311,54390622313,54390622331,54390622333,54391333113,54391333131,54391333133,54391333311,54391333313,54391333323,54391401010,54391401011,54391401013,54391401120,54391401121,54391401123,54391401222,54391401223,54391401301,54391401302,54391401303,54391402111,54391402113,54391402131,54391420122,54391420123,54391422002,54391422003,54391422011,54391422012,54391422013,54391512330,54391512331,54391513020,54391513021,54391513022,54391530120,54391530122,54391530300,54391532220,54391532221,54391532222,54392311101,54392311103,54392311121,54392311130,54392311131,54392311133,54392311311,54392311313,54392311331,54392400220,54392400221,54392400223,54392400230,54392400231,54392400232,54392400320,54392400321,54392400330,54392400331,54392401220,54392401221,54392401230,54392401231,54392401233,54392403100,54392403101,54392403131,54392411320,54392411321,54392411322,54392411330,54392412020,54392412021,54392412030,54392412031,54392412033,54392412301,54392412331,54392413030,54392413031,54392413032,54392413100,54392413200,54392413201,54392413202,54392502011,54392502100,54392502101,54392502110,54392502111,54392503000,54392503001,54392503003,54392503021,54392503023,54392503120,54392503121,54392503122,54392503130,54392503131,54392503201,54392503202,54392503203,54392503210,54392503211,54392503220,54392503300,54392510000,54392510002,54392510020,54392510022,54392510200,54392510202,54392510220,54392510222,
072,02,/ë,502804687,129075000,503634375,129703125,0,1,13,32,64,135,5339760,53396621,53396622,53396623,53396630,53396631,53396632,53397511,53397513,53397531,53397610,53397620,53397621,53397623,533965331,533965333,533966032,533966033,533966132,533966133,533966201,533966202,533966203,533966330,533966331,533966332,533967200,533975101,533975103,533975121,533975123,533975300,533975301,533975303,533975321,533975330,533975331,533976110,533976120,533976122,533976220,533976221,533976223,533976300,543906011,543906013,5339653131,5339653133,5339653233,5339653303,5339653321,5339653322,5339653323,5339660231,5339660232,5339660233,5339660302,5339660303,5339660312,5339660313,5339661202,5339661220,5339661222,5339661223,5339661232,5339661233,5339662001,5339662003,5339663330,5339663332,5339670221,5339670222,5339670223,5339672020,5339672021,5339672022,5339751023,5339751201,5339751203,5339751221,5339751222,5339751223,5339752111,5339752112,5339752113,5339753231,5339753320,5339753321,5339753330,5339753331,5339761110,5339761120,5339761210,5339761212,5339761230,5339761232,5339762220,5339762221,5339763020,5339763021,5339763022,5339763200,5439060101,5439060103,5439060121,5439060122,5439060123,5439060301,5439060310,5439060311,53396531321,53396531323,53396533011,53396533013,53396533023,53396533201,53396533202,53396533203,53396602131,53396602132,53396602133,53396602233,53396602302,53396602303,53396603002,53396603102,53396603103,53396603110,53396603112,53396612212,53396612213,53396612302,53396612303,53396612312,53396612313,53396613022,53396613023,53396613032,53396613033,53396613122,53396620003,53396620021,53396620022,53396620023,53396633310,53396633311,53396633312,53396633330,53396633332,53396702201,53396702202,53396702203,53396702300,53396702301,53396702302,53396702320,53396702322,53396720100,53396720102,53396720120,53396720230,53396722000,53396722001,53396722002,53396722020,53397503313,53397503331,53397503333,53397510031,53397510033,53397510211,53397510212,53397510213,53397510221,53397510223,53397512001,53397512003,53397512021,53397512023,53397512201,53397512202,53397512203,53397521031,53397521103,53397530211,53397530213,53397530231,53397530233,53397532011,53397532013,53397532031,53397532033,53397532211,53397532213,53397532300,53397532301,53397611120,53397611122,53397611210,53397611211,53397611220,53397611221,53397612110,53397612111,53397612112,53397612130,53397612132,53397622231,53397622233,53397630100,53397630101,53397630102,53397630230,53397630231,53397630232,53397632020,53397632021,53397632022,53397632222,54390601001,54390601003,54390601021,54390601023,54390601201,54390601203,54390603000,54390603001,54390603003,54390603030,54390603031,54390603120,54390603121,54390603130,54390603131,54390610000,54390610002,54390610020,54390610022,54390610200,54390610202,54390610220,54390610222,54390612000,54390612002,54390612020,
073,00,ë/ë,500315625,129721875,502425000,130575000,0,9,25,64,168,310,5439122,5439123,5439131,5439132,5439210,5439211,5439212,5439220,5439221,54390422,54391030,54391033,54391122,54391123,54391131,54391132,54391133,54391213,54391302,54391303,54391330,54391331,54391332,54391400,54392011,54392013,54392130,54392131,54392132,54392220,54392231,54392300,54392301,54392302,543903331,543903332,543903333,543904200,543904202,543904230,543910002,543910003,543910020,543910021,543910030,543910312,543910321,543910323,543911132,543911133,543911212,543911213,543911302,543911303,543912022,543912023,543912032,543912033,543912121,543912122,543912123,543913011,543913013,543913330,543913332,543914020,543914022,543914023,543914200,543914202,543920101,543920103,543920121,543920310,543920311,543920313,543920331,543921330,543921331,543922210,543922211,543922212,543922300,543922301,543922331,543923030,543923031,543923100,543923101,543923102,543923110,543923200,543923201,543931000,543931001,543931003,543931010,543931011,5438171131,5438171133,5438171310,5438171311,5439032330,5439032332,5439032333,5439033131,5439033133,5439033222,5439033233,5439033301,5439033303,5439040222,5439040223,5439042032,5439042033,5439042112,5439042121,5439042122,5439042123,5439042130,5439042132,5439042310,5439042312,5439042320,5439042322,5439100120,5439100122,5439100123,5439100220,5439100221,5439100230,5439100231,5439100232,5439100312,5439100320,5439100321,5439100330,5439100333,5439101221,5439101222,5439101223,5439101230,5439101232,5439101233,5439102111,5439102112,5439102113,5439102130,5439102131,5439102133,5439103102,5439103132,5439103133,5439103201,5439103203,5439103221,5439103223,5439112022,5439112023,5439112031,5439112032,5439112033,5439112101,5439112102,5439112103,5439112110,5439112112,5439112113,5439113002,5439113003,5439113011,5439113012,5439113013,5439120203,5439120211,5439120213,5439120300,5439120302,5439120303,5439120312,5439120313,5439121023,5439121032,5439121033,5439121133,5439121201,5439121202,5439121203,5439130121,5439130122,5439130123,5439133310,5439133312,5439133330,5439140100,5439140102,5439140103,5439140120,5439140210,5439140212,5439142010,5439201001,5439201003,5439201021,5439201023,5439201201,5439201231,5439201233,5439203121,5439203123,5439203330,5439203331,5439203333,5439213320,5439213321,5439213322,5439222130,5439222131,5439222132,5439222200,5439222201,5439222202,5439222210,5439222211,5439222213,5439222300,5439222301,5439222302,5439222310,5439223020,5439223021,5439223030,5439223031,5439223033,5439223211,5439223300,5439223301,5439223303,5439223321,5439230320,5439230321,5439230322,5439230330,5439231030,5439231031,5439231120,5439231121,5439231130,5439231200,5439232020,5439232021,5439232022,5439232100,5439232200,5439301111,5439301113,5439310020,5439310021,5439310023,5439310120,5439310121,5439310122,5439310130,5439311000,5439311001,5439311010,54381711132,54381711133,54381711233,54381711303,54381711321,54381711322,54381711323,54381713011,54381713012,54381713013,54381713130,54381713131,54381713133,54381713311,54390313333,54390323211,54390323212,54390323213,54390323231,54390323233,54390323310,54390323312,54390323313,54390331111,54390331113,54390331131,54390331132,54390331133,54390331233,54390331322,54390331323,54390332311,54390332313,54390333003,54390333021,54390333023,54390402202,54390402203,54390402212,54390402213,54390402302,54390402320,54390402321,54390402322,54390420100,54390420102,54390420120,54390420121,54390420122,54390420300,54390420302,54390420303,54390421031,54390421033,54390421103,54390421112,54390421130,54390421132,54390421201,54390421203,54390421310,54390421312,54390421330,54390421331,54390421332,54390423110,54390423112,54390423130,54390423210,54390423211,54390423300,54391000022,54391000023,54391000032,54391000033,54391001212,54391001322,54391002230,54391002231,54391002233,54391002330,54391002331,54391002332,54391003100,54391003102,54391003220,54391003221,54391003230,54391003231,54391003312,54391003313,54391003320,54391003321,54391003323,54391012032,54391012033,54391012201,54391012202,54391012203,54391012312,54391012313,54391013220,54391013222,54391021101,54391021103,54391021321,54391031000,54391031002,54391031030,54391031032,54391031033,54391031300,54391031302,54391031303,54391031312,54391031313,54391032001,54391032003,54391032221,54391032223,54391112133,54391112311,54391112313,54391112331,54391112333,54391113022,54391113023,54391113032,54391113033,54391113122,54391113123,54391113132,54391113133,54391120213,54391120301,54391120302,54391120303,54391121003,54391121112,54391121113,54391130002,54391130003,54391130012,54391130103,54391200233,54391200322,54391200323,54391200332,54391200333,54391201222,54391201223,54391202011,54391202021,54391202022,54391202023,54391202100,54391202101,54391202103,54391202122,54391202123,54391203012,54391203013,54391203102,54391203113,54391210132,54391210212,54391210310,54391210312,54391211322,54391211323,54391212001,54391212002,54391212003,54391300222,54391300223,54391300232,54391300331,54391300332,54391300333,54391301011,54391301013,54391301031,54391301033,54391301201,54391301202,54391301203,54391333110,54391333111,54391333112,54391333130,54391333132,54391333310,54391333312,54391333320,54391333321,54391333322,54391401012,54391401122,54391401220,54391401221,54391401300,54391402110,54391402112,54391402130,54391402132,54391402133,54391420120,54391420121,54391422000,54391422001,54391422010,54392010001,54392010003,54392010021,54392010023,54392010201,54392012031,54392012033,54392012300,54392012301,54392012303,54392030111,54392030113,54392030131,54392031200,54392031201,54392031203,54392031221,54392033010,54392033011,54392033013,54392033031,54392033033,54392033321,54392133230,54392133300,54392221330,54392221331,54392221332,54392222030,54392222031,54392222120,54392222121,54392222310,54392222311,54392222312,54392223030,54392223031,54392223032,54392223120,54392223121,54392230220,54392230221,54392230321,54392232130,54392232131,54392233020,54392233021,54392233023,54392233201,54392233231,54392233300,54392233301,54392233302,54392233310,54392233320,54392303230,54392303231,54392303232,54392303310,54392303320,54392310320,54392310321,54392310330,54392310331,54392311100,54392311102,54392311120,54392311122,54392311123,54392311132,54392311220,54392311221,54392311230,54392311231,54392311310,54392311312,54392311320,54392311321,54392311330,54392312020,54392320230,54392320231,54392320232,54392320300,54392320301,54392320302,54392321010,54392321020,54392321021,54392322020,54393011311,54393100221,54393101230,54393101231,54393101310,54393101320,54393110020,54393110021,54393110022,
074,00,/Ĺ,499359375,129018750,501440625,130106250,3,7,30,72,156,366,533876,533877,543900,5338663,5338672,5339700,5339702,5339703,5438070,5438071,53386622,53386623,53386702,53386703,53386730,53386732,53386733,53387531,53396022,53396023,53396030,53396032,53397010,53397012,53397013,53397120,53397122,54380601,54380610,54380611,54380613,54380720,54380721,54380730,54380731,54380733,54391010,54391011,54391102,54391103,533865333,533866122,533866123,533866132,533866133,533866211,533866213,533867312,533867313,533875131,533875133,533875331,533960213,533960310,533960312,533960330,533960332,533970112,533971020,533971022,533971023,533971210,533971212,543806001,543806003,543806021,543806121,543806311,543806313,543807220,543807221,543807230,543807231,543807232,543807320,543807321,543807323,543817101,543817110,543901000,543901001,543901002,543901020,543901022,543901200,543901202,543901203,543901220,543901221,543901222,543910001,543910010,543910011,543910121,543910130,543910131,543910133,543910311,543911000,543911002,543911003,543911012,543911013,543911100,543911102,543911103,543911112,543911113,543911120,543911122,543911200,543911201,5338653303,5338653312,5338653313,5338653321,5338653323,5338660323,5338660331,5338660332,5338660333,5338661202,5338661203,5338661212,5338661213,5338661302,5338661303,5338661312,5338661313,5338662101,5338662103,5338662121,5338662122,5338662123,5338670023,5338670030,5338670032,5338670033,5338670132,5338670133,5338671200,5338671202,5338671220,5338671222,5338671223,5338673102,5338751110,5338751111,5338751113,5338751131,5338751133,5338751321,5338751323,5338753013,5338753031,5338753033,5338753301,5338753331,5338753333,5339601322,5339602020,5339602022,5339602113,5339602122,5339602123,5339603130,5339603132,5339701100,5339701102,5339701132,5339710212,5339710213,5339710320,5339710322,5339712300,5339712302,5339712303,5339712320,5339712321,5339712322,5438060000,5438060001,5438060003,5438060021,5438060300,5438060311,5438061200,5438061201,5438061231,5438063101,5438063103,5438063121,5438063311,5438072221,5438072230,5438072231,5438072330,5438072331,5438073220,5438073221,5438073223,5438171031,5438171110,5438171111,5438171112,5438171120,5438171121,5438171122,5438171300,5438171302,5439010030,5439010031,5439010032,5439010100,5439010210,5439010212,5439010230,5439010231,5439010232,5439012010,5439012012,5439012013,5439012230,5439012232,5439013221,5439013222,5439013223,5439100000,5439100001,5439100130,5439100131,5439100133,5439100311,5439100313,5439101200,5439101201,5439101202,5439101320,5439101321,5439101323,5439103101,5439110010,5439110012,5439110013,5439110111,5439110112,5439110113,5439111012,5439111013,5439111102,5439111103,5439111112,5439111113,5439111210,5439111211,5439111212,5439111230,5439111232,5439111300,5439111301,5439111310,5439111311,5439112020,5439120002,5439120020,5439120021,5439120022,5439120200,53386533013,53386533102,53386533103,53386533111,53386533112,53386533113,53386603113,53386603131,53386603133,53386603213,53386603301,53386603302,53386603303,53386611233,53386611322,53386612002,53386612003,53386612012,53386612103,53386612112,53386612113,53386613011,53386613013,53386613100,53386613102,53386613103,53386613111,53386613112,53386613113,53386620232,53386620233,53386620322,53386620323,53386620332,53386620333,53386700121,53386700123,53386700212,53386700213,53386700221,53386700222,53386700223,53386700310,53386700312,53386700313,53386701220,53386701222,53386701223,53386701232,53386701233,53386701312,53386710222,53386710223,53386712212,53386712213,53386712322,53386731032,53386731033,53386731121,53386731122,53386731123,53386731130,53386731132,53386731133,53387511010,53387511011,53387511121,53387511123,53387511301,53387511303,53387511321,53387511322,53387511323,53387512333,53387513011,53387513013,53387513031,53387513032,53387513033,53387513221,53387513222,53387513223,53387530111,53387530112,53387530113,53387533001,53387533002,53387533003,53387533021,53387533030,53387533031,53387533033,53387533300,53387533301,53387533303,53396012222,53396012223,53396012230,53396012232,53396012233,53396012322,53396012323,53396012331,53396012332,53396012333,53396013202,53396013203,53396013230,53396013232,53396013233,53396020022,53396020232,53396021111,53396021112,53396021113,53396021121,53396021122,53396021123,53396021211,53396021212,53396021213,53396031102,53396031120,53396031122,53396033100,53396033101,53396033102,53396033120,53396033122,53396033300,53396033302,53396033320,53397011302,53397011303,53397011330,53397011332,53397011333,53397102102,53397103022,53397103023,53397103210,53397103212,53397103230,53397103232,53397103233,53397121102,53397121120,53397121122,53397121300,53397123010,53397123012,53397123122,53397123230,53397123231,53397123232,53397123300,53397123302,53397123320,54380511111,54380600021,54380600023,54380600201,54380600203,54380600221,54380600230,54380600231,54380600233,54380602011,54380602013,54380602031,54380603010,54380603011,54380603020,54380603100,54380603101,54380612021,54380612030,54380612031,54380612033,54380612330,54380612331,54380612333,54380630111,54380631000,54380631001,54380631003,54380631021,54380631023,54380631230,54380631231,54380631233,54380633131,54380633133,54380722201,54380722320,54380722321,54380722330,54380722331,54380722333,54380723320,54380723321,54380723322,54380723330,54380723331,54380732220,54380732221,54380732223,54381701011,54381710001,54381710010,54381710011,54381710013,54381710031,54381710301,54381710303,54381710330,54381710331,54381710333,54381711130,54381711131,54381711230,54381711231,54381711232,54381711300,54381711301,54381711302,54381711320,54381712111,54381712113,54381712130,54381712131,54381712133,54381712311,54381712313,54381713010,54381713200,54390100330,54390100332,54390101020,54390101021,54390101022,54390101200,54390102110,54390102112,54390102130,54390102132,54390102133,54390102330,54390102332,54390120110,54390120112,54390120113,54390121220,54390122310,54390122312,54390122330,54390122332,54390123333,54390132023,54390132030,54390132032,54390132201,54390132202,54390132203,54390132302,54390132320,54390132322,54391000020,54391000021,54391000030,54391000031,54391001210,54391001211,54391001213,54391001320,54391001321,54391001323,54391003101,54391003103,54391003310,54391003311,54391012030,54391012031,54391012200,54391012310,54391012311,54391013221,54391013223,54391031001,54391031003,54391031031,54391031301,54391031310,54391031311,54391100110,54391100112,54391101022,54391101023,54391101031,54391101032,54391101033,54391110100,54391110102,54391111013,54391111102,54391111103,54391111112,54391111113,54391112130,54391112131,54391112132,54391112310,54391112312,54391112330,54391112332,54391113020,54391113021,54391113030,54391113031,54391113120,54391113121,54391113130,54391113131,54391120210,54391120211,54391120212,54391120300,54391121000,54391121001,54391121002,54391121110,54391121111,54391130000,54391130001,54391130010,54391130011,54391130013,54391130100,54391130101,54391130102,54391200000,54391200002,54391200003,54391200032,54391200230,54391200231,54391200232,54391200300,54391200302,54391200313,54391200320,54391200321,54391200330,54391200331,54391201201,54391201202,54391201203,54391201220,54391201221,54391202010,54391202012,54391202013,54391202020,54391202102,54391202120,54391202121,
075,00,/Ĵ,501960937,128268750,502537500,128512500,0,0,0,13,41,92,533933323,533933332,533933333,533934213,533934222,533934223,533934230,533934231,533934233,533943110,533943111,533944000,533944011,5339333212,5339333213,5339333221,5339333222,5339333223,5339333302,5339333303,5339333312,5339333313,5339342113,5339342121,5339342122,5339342123,5339342202,5339342203,5339342211,5339342212,5339342213,5339342320,5339342321,5339343200,5339343202,5339343203,5339343211,5339343212,5339343220,5339431011,5339431013,5339431031,5339431033,5339431120,5339431121,5339431130,5339431131,5339431132,5339431211,5339440010,5339440011,5339440012,5339440021,5339440030,53393323333,53393332031,53393332032,53393332033,53393332103,53393332112,53393332113,53393332201,53393332203,53393333002,53393333003,53393333012,53393333013,53393333102,53393333103,53393333112,53393333113,53393420331,53393420332,53393420333,53393421121,53393421122,53393421123,53393421202,53393421203,53393422002,53393422003,53393422012,53393422013,53393422101,53393422102,53393422103,53393423220,53393423221,53393423222,53393430022,53393430200,53393430202,53393430220,53393430222,53393430223,53393430333,53393432010,53393432012,53393432013,53393432101,53393432102,53393432103,53393432130,53393432132,53393432210,53393432211,53393432220,53393432222,53393432310,53394301111,53394310000,53394310010,53394310011,53394310101,53394310103,53394310121,53394310123,53394310301,53394310303,53394310321,53394310323,53394311220,53394311221,53394311230,53394311231,53394311233,53394311330,53394311331,53394311332,53394312130,53394312131,53394312133,53394313002,53394400130,53394400132,53394400200,53394400201,53394400202,53394400310,53394400321,53394400323,53394401000,53394410000,53394410002,53394410020,53394410022,
075,01,¿,501707812,128165625,502312500,128484375,0,0,3,9,48,105,53393322,53393330,53393331,533933122,533933133,533933230,533933231,533933232,533934200,533934202,533943001,533943010,5339323311,5339323313,5339330302,5339330303,5339330312,5339330313,5339330321,5339330330,5339330331,5339330333,5339331202,5339331203,5339331232,5339331311,5339331312,5339331313,5339331322,5339331323,5339332023,5339332032,5339332033,5339332131,5339332132,5339332133,5339332330,5339332331,5339332332,5339333200,5339333201,5339333202,5339340222,5339340223,5339342012,5339342030,5339342032,5339430000,5339430001,5339430003,5339430020,5339430021,5339430023,5339430030,5339430031,5339430032,5339430110,5339430112,5339430120,5339430121,53393231333,53393233121,53393233123,53393233311,53393302113,53393302131,53393303102,53393303103,53393303112,53393303113,53393303201,53393303231,53393303320,53393303321,53393303323,53393311332,53393311333,53393312002,53393312003,53393312012,53393312013,53393312300,53393312302,53393312303,53393312330,53393312332,53393312333,53393313033,53393313101,53393313102,53393313103,53393313203,53393313211,53393313212,53393313213,53393320212,53393320213,53393320222,53393320223,53393320302,53393320303,53393320312,53393321111,53393321113,53393321131,53393321133,53393321222,53393321223,53393321233,53393321303,53393323330,53393323331,53393323332,53393332030,53393332100,53393332101,53393332102,53393332110,53393332111,53393332200,53393332202,53393333000,53393333001,53393333010,53393333011,53393333100,53393333101,53393333110,53393333111,53393400222,53393402000,53393402200,53393402202,53393402203,53393402320,53393402322,53393420100,53393420102,53393420103,53393420112,53393420310,53393420312,53393420313,53393420330,53393422000,53393422001,53393422010,53393422011,53393422100,53394211111,53394300021,53394300023,53394300220,53394300221,53394300223,53394300330,53394300331,53394300332,53394301110,53394301112,53394301220,53394301300,53394302001,53394302010,53394302011,
076,00,Ȭ,500273437,127931250,501960937,128634375,0,4,25,66,143,267,5339303,5339310,5339313,5339322,53392021,53392032,53392033,53392122,53392123,53393011,53393012,53393013,53393021,53393023,53393110,53393112,53393113,53393120,53393121,53393230,53393232,53394000,53394001,53394002,53394010,53394111,53394200,53394201,53394210,533847131,533847132,533847133,533920221,533920230,533920231,533920233,533920300,533920302,533920303,533920310,533920312,533920313,533921202,533921203,533921212,533921320,533921322,533921323,533930032,533930033,533930101,533930103,533931112,533931220,533931221,533931222,533931230,533931231,533931233,533932020,533932022,533932122,533932123,533932131,533932132,533932133,533932310,533932311,533932312,533932330,533932332,533933020,533933022,533933023,533933200,533933201,533933210,533940030,533940031,533940110,533940200,533941100,533941101,533941130,533941131,533941132,533942020,533942021,533942030,533942031,533942110,533942112,533942113,533942120,533942122,5338471111,5338471113,5338471131,5338471132,5338471133,5338471303,5339202013,5339202031,5339202032,5339202033,5339202201,5339202203,5339202221,5339202230,5339202231,5339202320,5339202321,5339202323,5339203011,5339203012,5339203013,5339203111,5339203112,5339203113,5339212002,5339212003,5339212012,5339212013,5339212132,5339213210,5339213212,5339213213,5339213320,5339213322,5339300213,5339300231,5339300233,5339300302,5339300303,5339300312,5339300313,5339301001,5339301002,5339301003,5339301020,5339301021,5339301023,5339302011,5339302012,5339302013,5339302030,5339302031,5339302033,5339302211,5339302213,5339302223,5339302231,5339302232,5339302233,5339311100,5339311102,5339312230,5339312231,5339312320,5339312321,5339320022,5339320023,5339320230,5339320232,5339320233,5339320322,5339320323,5339320331,5339320332,5339320333,5339321301,5339321303,5339323130,5339323131,5339323132,5339323310,5339323330,5339323332,5339323333,5339330022,5339330023,5339330210,5339330212,5339330322,5339332020,5339332110,5339332112,5339332120,5339332121,5339400320,5339400321,5339400322,5339401110,5339401111,5339401112,5339401120,5339401121,5339401122,5339401200,5339402010,5339402011,5339402012,5339402021,5339402030,5339410110,5339410111,5339410113,5339410131,5339411020,5339411021,5339411030,5339411031,5339411033,5339411211,5339411213,5339411231,5339411233,5339411330,5339411331,5339411332,5339420220,5339420221,5339420230,5339420231,5339420320,5339420321,5339420322,5339420330,5339420331,5339421110,5339421112,5339421113,5339421210,5339421211,5339421212,5339421230,5339421301,5339421310,53383733333,53384711233,53384711303,53384712313,53384712331,53384712333,53384713011,53384713013,53384713023,53384731111,53384731113,53392002333,53392003222,53392003223,53392003232,53392003322,53392012333,53392013222,53392013223,53392013321,53392013323,53392013330,53392013332,53392013333,53392020111,53392020113,53392020123,53392020233,53392020301,53392020303,53392022320,53392022321,53392022330,53392022331,53392023220,53392023221,53392023223,53392030102,53392030103,53392031101,53392031102,53392031103,53392102222,53392120000,53392120002,53392120003,53392120012,53392120013,53392120102,53392121022,53392121302,53392121303,53392121332,53392121333,53392130222,53392132110,53392132112,53392132113,53392133002,53392133020,53392133022,53392133230,53392133232,53393002303,53393002321,53393002323,53393003003,53393003011,53393003012,53393003013,53393003100,53393003102,53393003103,53393003112,53393010001,53393010003,53393010221,53393010222,53393010223,53393020101,53393020102,53393020103,53393020321,53393020323,53393022101,53393022222,53393022223,53393022301,53393022303,53393111010,53393111012,53393111030,53393111032,53393111033,53393111322,53393111332,53393111333,53393122320,53393122321,53393122322,53393123230,53393123231,53393123233,53393200203,53393202102,53393202120,53393202122,53393202123,53393202132,53393202310,53393202312,53393202313,53393203202,53393203203,53393203212,53393203213,53393203301,53393203302,53393203303,53393213001,53393213003,53393213021,53393213023,53393231330,53393231331,53393231332,53393233120,53393233122,53393233310,53393233312,53393233313,53393300203,53393300211,53393300212,53393300213,53393300300,53393300302,53393300320,53393300322,53393300323,53393302112,53393302130,53393302132,53393302133,53393303200,53393303202,53393303203,53393303230,53393303232,53393303233,53393303322,53393320210,53393320211,53393320220,53393320221,53393320300,53393320301,53393320310,53393320311,53393320313,53393321110,53393321112,53393321130,53393321132,53393321220,53393321221,53393321230,53393321231,53393321232,53393321300,53393321301,53393321302,53394003230,53394003231,53394003300,53394003301,53394003302,53394011130,53394011131,53394011132,53394011230,53394011231,53394011232,53394011300,53394011301,53394011302,53394012010,53394012011,53394012012,53394012020,53394012100,53394012101,53394020130,53394020201,53394020203,53394020230,53394020231,53394020233,53394020320,53394020322,53394021000,53394022011,53394100000,53394100001,53394100002,53394101120,53394101121,53394101123,53394101301,53394101303,53394101321,53394101330,53394110230,53394110320,53394110321,53394110323,53394112101,53394112103,53394112121,53394113330,53394113331,53394113332,53394130111,53394131000,53394131001,53394131010,53394131011,53394131100,53394202220,53394202221,53394202223,53394202230,53394202231,53394202232,53394202320,53394202321,53394202330,53394202331,53394202333,53394203230,53394203231,53394203232,53394203320,53394203321,53394203330,53394203331,53394203333,53394211110,53394211112,53394211113,53394212130,53394212131,53394212132,53394212310,53394212312,53394212320,53394212321,53394213000,53394213001,53394213002,53394213110,53394213111,53394213112,53394230010,53394300020,53394300022,53394300222,
077,00,Ω,501609375,128456250,502031250,128756250,0,0,3,15,29,78,53394320,53394322,53394323,533942132,533942133,533942311,533942313,533943021,533943022,533943023,533943030,533943032,533943210,533943212,533953000,533953001,533953010,533953011,5339421233,5339421302,5339421303,5339421312,5339421313,5339423100,5339423101,5339423311,5339423313,5339423331,5339423333,5339430123,5339430202,5339430203,5339430310,5339430312,5339430330,5339430332,5339432110,5339432112,5339432130,5339432131,5339433002,5339433202,5339433203,5339433220,5339433222,5339521111,5339531000,53394212133,53394212311,53394212313,53394213003,53394213113,53394230111,53394231020,53394231021,53394231030,53394231031,53394231033,53394233100,53394233101,53394233103,53394233121,53394233123,53394233300,53394233301,53394233303,53394233321,53394233323,53394300333,53394301221,53394301222,53394301223,53394301322,53394301323,53394302000,53394302002,53394302003,53394302012,53394302013,53394303110,53394303112,53394303130,53394303330,53394303332,53394321110,53394321130,53394321132,53394321133,53394321320,53394321321,53394330012,53394330030,53394330032,53394330200,53394330201,53394332002,53394332210,53394332211,53394332212,53394332230,53394332232,53395211101,53395211103,53395211130,53395211131,53395211133,53395211311,53395211313,53395300200,53395300201,53395300203,53395300300,53395300311,53395301200,53395301201,53395301210,53395301211,53395301300,53395301301,53395301310,53395301311,53395310010,53395310020,53395310022,53395310200,
077,01,/ʡ/¿,499739062,128381250,501792187,129225000,2,8,20,69,146,262,533857,533950,5339403,5339412,5339422,5339510,5339511,5339512,5339520,5339600,53384732,53384733,53385611,53386711,53386713,53394013,53394023,53394102,53394103,53394132,53394133,53394232,53395130,53395131,53395132,53395210,53395220,53395221,53396010,53396011,533846331,533846332,533846333,533847222,533847223,533847232,533847233,533847303,533847310,533847312,533847313,533856101,533856103,533856313,533856331,533856333,533867000,533867010,533867011,533867100,533867101,533867103,533867121,533940122,533940123,533940211,533940212,533940213,533940221,533940222,533940223,533941001,533941002,533941003,533941010,533941012,533941120,533941122,533941300,533941302,533941303,533941312,533941313,533942302,533942303,533942312,533942330,533942332,533951330,533951331,533952110,533952112,533952120,533952121,533952122,533952130,533952131,533952220,533952221,533952230,533960120,533960121,533960201,533960203,533960210,533961000,533961001,533961002,533961010,5338463301,5338463303,5338472200,5338472202,5338472203,5338472212,5338472213,5338472302,5338472303,5338472312,5338472313,5338473023,5338473110,5338473112,5338473113,5338561003,5338561021,5338561023,5338561201,5338561210,5338561211,5338561300,5338561301,5338561310,5338561311,5338561313,5338561331,5338561333,5338563111,5338563113,5338563303,5338563321,5338661111,5338661113,5338661131,5338661133,5338670010,5338670011,5338670013,5338670020,5338670120,5338670121,5338670130,5338671020,5338671021,5338671023,5338671201,5338671203,5338671230,5338671231,5338671233,5338673100,5338673101,5338673110,5338673111,5339312233,5339312322,5339400331,5339400332,5339400333,5339401131,5339401132,5339401133,5339401203,5339401211,5339401212,5339401213,5339402022,5339402031,5339402033,5339402101,5339402102,5339402103,5339402200,5339402202,5339402203,5339410001,5339410002,5339410003,5339411022,5339411230,5339411232,5339413010,5339413012,5339413013,5339413102,5339413103,5339413111,5339413112,5339413113,5339423000,5339423002,5339423003,5339423010,5339423012,5339423013,5339513320,5339513321,5339513322,5339513330,5339513331,5339521112,5339521130,5339521132,5339521133,5339521230,5339521231,5339521320,5339521321,5339521322,5339521330,5339521331,5339522220,5339522221,5339522230,5339522231,5339522233,5339522310,5339522320,5339522321,5339523000,5339523002,5339523020,5339530022,5339530200,5339601220,5339601221,5339601230,5339601231,5339601300,5339601301,5339601302,5339601310,5339601311,5339602000,5339602001,5339602003,5339602021,5339602110,5339602120,5339610030,5339610031,5339610032,5339610110,5339610120,5339610200,53384631232,53384631233,53384631322,53384631323,53384631332,53384631333,53384632322,53384632323,53384632331,53384632332,53384632333,53384633023,53384720222,53384720223,53384722010,53384722012,53384722013,53384722102,53384723103,53384723111,53384723112,53384723113,53384730113,53384730123,53384730131,53384730132,53384730133,53384730213,53384730222,53384730223,53384731110,53384731112,53385610013,53385610223,53385612001,53385612003,53385613031,53385613120,53385613121,53385613123,53385613323,53385631101,53385631103,53385631121,53385631122,53385631123,53385631211,53385631213,53385631231,53385633011,53385633012,53385633013,53385633231,53386611100,53386611101,53386611103,53386611121,53386611123,53386611301,53386611303,53386611321,53386611323,53386613101,53386613110,53386700120,53386700122,53386700210,53386700211,53386700220,53386700311,53386701221,53386701230,53386701231,53386701310,53386701311,53386701313,53386710220,53386710221,53386712210,53386712211,53386712320,53386712321,53386712323,53386731030,53386731031,53386731120,53386731131,53393122323,53393123232,53394003232,53394003233,53394003303,53394011133,53394011233,53394011303,53394012013,53394012021,53394012022,53394012023,53394012102,53394012103,53394020131,53394020132,53394020133,53394020200,53394020202,53394020232,53394020321,53394020323,53394021001,53394021002,53394021003,53394022010,53394022012,53394022013,53394100003,53394101122,53394101300,53394101302,53394101320,53394101322,53394101323,53394101331,53394101332,53394101333,53394110231,53394110232,53394110233,53394110322,53394112100,53394112102,53394112120,53394112122,53394112123,53394113333,53394130110,53394130112,53394130113,53394131002,53394131003,53394131012,53394131013,53394131101,53394131102,53394131103,53394202222,53394202233,53394202322,53394202323,53394202332,53394203233,53394203322,53394203323,53394203332,53394212322,53394212323,53394230011,53394230012,53394230013,53394230110,53394230112,53394230113,53394231022,53394231023,53394231032,53394233102,53394233120,53394233122,53394233302,53394233320,53394233322,53395133230,53395133231,53395133320,53395133321,53395133330,53395133331,53395211100,53395211102,53395211132,53395211310,53395211312,53395212320,53395212321,53395212322,53395212330,53395212331,53395212333,53395213230,53395213231,53395213232,53395213320,53395213321,53395213330,53395213331,53395222220,53395222221,53395222230,53395222231,53395222320,53395222321,53395223110,53395223111,53395223120,53395223122,53395223220,53395223221,53395223230,53395223300,53395223302,53395230010,53395230011,53395230012,53395230030,53395230220,53395230222,53395232000,53395232002,53395300202,53395302010,53395302012,53395302020,53395302021,53396012220,53396012221,53396012231,53396012320,53396012321,53396012330,53396013200,53396013201,53396020020,53396020021,53396020023,53396020230,53396020231,53396020233,53396021110,53396021120,53396021210,53396100330,53396100331,53396100332,53396101110,53396101111,53396101112,53396101120,53396101121,53396101122,53396101220,53396102010,53396102011,53396102012,53396102100,53396102101,53396110000,53396110100,53396110101,53396110110,53396110111,53396110112,53396110130,
078,00,¤θ/ޥץ顼/,502087500,127893750,502720312,128203125,0,0,3,13,43,102,53392420,53392423,53393411,533923311,533924023,533924210,533924212,533924213,533924322,533924323,533924332,533924333,533934010,533934011,533934100,533934101,5339231330,5339231332,5339231333,5339233122,5339233123,5339233130,5339233131,5339233132,5339233301,5339233303,5339233321,5339240212,5339240221,5339240222,5339240223,5339240322,5339240323,5339240332,5339242110,5339242112,5339242211,5339243133,5339243202,5339243212,5339243213,5339243302,5339243303,5339243311,5339243312,5339243313,5339252200,5339252202,5339252220,5339252222,5339340131,5339341020,5339341021,5339341030,5339341031,5339341310,5339350020,5339350021,5339350022,53392313312,53392313313,53392331203,53392331211,53392331212,53392331213,53392331330,53392331331,53392333000,53392333001,53392333003,53392333021,53392333100,53392333102,53392333120,53392333122,53392333230,53392333231,53392333300,53392333302,53392333303,53392333320,53392333321,53392402033,53392402130,53392402132,53392402133,53392402201,53392402202,53392402203,53392403200,53392403202,53392403203,53392403212,53392403213,53392421112,53392421130,53392421132,53392421133,53392422000,53392422001,53392422003,53392422010,53392422011,53392422012,53392422101,53392422131,53392422133,53392430022,53392430200,53392430202,53392430220,53392430222,53392432000,53392432002,53392432030,53392432032,53392432033,53392433002,53392433003,53392433012,53392433013,53392433102,53392433103,53392520222,53392520223,53392520232,53392522010,53392522012,53392522030,53392522032,53393401300,53393401301,53393401303,53393401330,53393410231,53393410320,53393410321,53393410330,53393410331,53393410333,53393413000,53393413001,53393413010,53393413011,53393413013,53393413031,53393413110,53393413111,53393413112,53393413120,53393500000,53393500002,53393500020,53393500022,53393500023,53393500031,53393500033,53393500120,53393500122,53393500230,53393500300,
078,01,̥˥塼,502368750,127809375,502621875,128053125,0,0,1,7,22,46,53392412,533924031,533924102,533924103,533924301,533924303,533924310,533924312,5339240131,5339240133,5339240330,5339240331,5339240333,5339241122,5339241123,5339241300,5339241301,5339241302,5339241320,5339241322,5339243000,5339243001,5339243003,5339243021,5339243023,5339243130,5339243132,5339243201,5339243210,5339243211,53392401131,53392401132,53392401133,53392401301,53392401303,53392401321,53392401322,53392401323,53392410020,53392410022,53392410023,53392410113,53392410131,53392410132,53392410133,53392411022,53392411200,53392411202,53392411203,53392411212,53392411213,53392413230,53392413232,53392421110,53392421111,53392421113,53392421131,53392430020,53392430021,53392430023,53392430201,53392430203,53392430221,53392430223,53392431121,53392431122,53392431123,53392432001,53392432003,53392432031,53392433000,53392433001,53392433010,53392433011,53392433100,53392433101,
078,02,ߤʤȤߤ餤,502579687,127575000,502762500,127678125,0,0,0,3,4,22,533914131,533915022,533915023,5339150202,5339150212,5339152000,5339152001,53391413011,53391413013,53391413031,53391413033,53391413211,53391413300,53391413301,53391413310,53391413311,53391413313,53391413331,53391413333,53391502002,53391502003,53391502012,53391502030,53391502032,53391502033,53391502130,53391502132,53391520030,53391520100,
078,03,Į/ڳ,502720312,127528125,502818750,127640625,0,0,0,1,6,14,533915012,5339150211,5339150300,5339150302,5339150303,5339150321,5339150320,53391500332,53391500333,53391501032,53391501033,53391502101,53391502103,53391502131,53391502133,53391503010,53391503011,53391503012,53391503230,53391503220,53391503221,
078,04,/Į,502635937,127556250,502720312,127603125,0,0,0,0,2,10,5339150022,5339150023,53391411331,53391411333,53391502000,53391502001,53391502010,53391502011,53391502013,53391502031,53391502100,53391502102,
078,05,Į,502692187,127509375,502762500,127575000,0,0,0,0,5,8,5339150012,5339150013,5339150030,5339150031,5339150032,53391500031,53391500033,53391500102,53391500103,53391500211,53391500213,53391500330,53391500331,
078,06,/̱,502664062,127350000,503100000,127631250,0,1,1,6,15,31,5339053,53391510,533905232,533905233,533915011,533915013,533905231,533905213,5339052231,5339052233,5339150011,5339150100,5339150101,5339150102,5339150310,5339150312,5339150311,5339151200,5339052303,5339052301,5339052302,5339052123,5339052113,53390522301,53390522303,53390522321,53390522323,53391500011,53391500012,53391500013,53391500023,53391500030,53391500032,53391500100,53391500101,53391501030,53391501031,53391503013,53391503300,53391503301,53391503132,53391503130,53391503131,53391512020,53391503302,53391512010,53390523003,53390522133,53390522132,53390522131,53390523002,53390523001,53390521213,53390521123,
078,07,/ڥë,502467187,127462500,502692187,127584375,0,0,0,3,13,24,533914101,533914110,533914112,5339043233,5339043321,5339043322,5339043323,5339141030,5339141031,5339141033,5339141112,5339141113,5339141130,5339141131,5339141132,5339150020,53390432311,53390432312,53390432313,53390432321,53390432323,53390433202,53391410013,53391410031,53391410213,53391410321,53391410323,53391411100,53391411102,53391411103,53391411330,53391411332,53391412110,53391412111,53391413000,53391413001,53391413010,53391500022,53391500210,53391500212,
078,08,ڥë,502382812,127556250,502621875,127809375,0,0,0,7,26,70,533914120,533914123,533914301,533914303,533914310,533914321,533914323,5339140311,5339140313,5339141022,5339141023,5339141210,5339141212,5339141213,5339141221,5339141302,5339141320,5339141322,5339141323,5339143003,5339143021,5339143023,5339143120,5339143122,5339143201,5339143202,5339143203,5339143300,5339143302,5339143320,5339143321,5339143322,5339143330,53391401333,53391403103,53391403121,53391403123,53391403310,53391403311,53391410320,53391410322,53391412112,53391412113,53391412200,53391412201,53391412230,53391412231,53391412233,53391413002,53391413003,53391413012,53391413030,53391413032,53391413210,53391413212,53391413213,53391413302,53391413320,53391413322,53391423113,53391423131,53391423132,53391423133,53391423310,53391423311,53391423313,53391430011,53391430012,53391430013,53391430021,53391430022,53391430023,53391430201,53391430221,53391431100,53391431102,53391431120,53391431210,53391431212,53391431213,53391431230,53391431231,53391431232,53391432002,53391432003,53391432201,53391432210,53391432211,53391432213,53391432231,53391432233,53391433010,53391433012,53391433030,53391433032,53391433033,53391433230,53391433231,53391433320,53391433321,53392410110,53392410111,53392411000,
078,09,,502537500,127256250,502776562,127528125,0,0,0,8,18,45,533904133,533904311,533904313,533904331,533904333,533905202,533905220,533905222,5339041301,5339041303,5339041310,5339041312,5339041313,5339041321,5339041322,5339041323,5339043100,5339043101,5339052000,5339052002,5339052210,5339052212,5339141111,5339150000,5339052211,5339052032,53390411220,53390411222,53390411223,53390411232,53390411233,53390411322,53390413001,53390413003,53390413021,53390413023,53390413201,53390413203,53390431020,53390431021,53390431030,53390431031,53390431213,53390431231,53390431232,53390431233,53390433010,53390433011,53390433013,53390502202,53390502220,53390502222,53390520010,53390520012,53390520030,53390520032,53390520033,53390520300,53390520302,53390522130,53390522300,53390522302,53390522320,53390522322,53391411101,53391500010,53391500020,53391500021,53390520332,53390520330,53390523000,
078,10,Ȭ/ʸ,502523437,127106250,503100000,127425000,0,1,4,8,23,45,5339051,52397433,53390500,53390501,53390503,523975222,533904110,533904111,533905020,533905021,533905023,533905201,533905210,5239743132,5239752200,5239752202,5239752203,5239752233,5339041120,5339041121,5339041130,5339041131,5339041133,5339041311,5339050221,5339050223,5339052031,5239752232,5239752322,5239752323,5239752332,5339052120,5339052122,5339052110,5339052111,5239752333,52397431222,52397431223,52397431231,52397431232,52397431233,52397431332,52397431333,52397432111,52397520222,52397522012,52397522013,52397522120,52397522122,52397522300,52397522302,53390410111,53390410113,53390410131,53390410133,53390410311,53390410313,53390411221,53390411230,53390411231,53390411320,53390411321,53390411323,53390502200,53390502201,53390502203,53390502221,53390502223,53390520011,53390520013,53390520031,53390520301,53390520303,53390520333,53390520331,53390521210,53390521211,53390521212,53390521120,53390521121,53390521122,
078,11,,502579687,127621875,502692187,127781250,0,0,0,2,7,29,533914313,533914331,5339143111,5339143113,5339152002,5339152020,5339152022,5339152200,5339152202,53391413303,53391413312,53391413321,53391413323,53391413330,53391413332,53391431101,53391431103,53391431121,53391431122,53391431123,53391431211,53391431233,53391433011,53391433013,53391433031,53391433310,53391433311,53391433313,53391520032,53391520210,53391520212,53391520230,53391520232,53391522010,53391522012,53391522030,53391522032,53391522210,
078,12,粬/,502410937,127293750,502593750,127500000,0,0,0,4,18,42,533904301,533904303,533904320,533904321,5339041223,5339041231,5339041232,5339041233,5339043001,5339043002,5339043003,5339043020,5339043021,5339043023,5339043120,5339043122,5339043220,5339043221,5339043230,5339043300,5339043302,5339043303,53390412132,53390412133,53390412221,53390412223,53390412301,53390412302,53390412303,53390413020,53390413022,53390413200,53390413202,53390421131,53390421133,53390423311,53390423313,53390430001,53390430002,53390430003,53390430220,53390430221,53390430223,53390431022,53390431023,53390431032,53390431033,53390431210,53390431211,53390431212,53390431230,53390432220,53390432221,53390432222,53390432230,53390432231,53390432233,53390432310,53390432320,53390432322,53390433012,53390433200,53390433201,53390433203,
078,13,/ܶ,502270312,127200000,502551562,127378125,0,0,0,4,21,40,533904032,533904033,533904102,533904120,5339040133,5339040213,5339040231,5339040233,5339040300,5339040302,5339040303,5339040311,5339040312,5339040313,5339041010,5339041012,5339041030,5339041032,5339041033,5339041210,5339041211,5339041212,5339041220,5339041221,5339042111,53390401313,53390401323,53390402111,53390402113,53390402121,53390402123,53390402301,53390402303,53390402321,53390402323,53390403010,53390403012,53390403101,53390403103,53390410033,53390410110,53390410112,53390410130,53390410132,53390410310,53390410312,53390412130,53390412131,53390412220,53390412222,53390412300,53390413000,53390413002,53390420110,53390420111,53390421001,53390421003,53390421010,53390421011,53390421012,53390421100,53390421101,53390421103,53390421130,53390430000,
078,14,,502143750,127265625,502481250,127603125,0,0,0,11,28,61,533904022,533904200,533904203,533904212,533904213,533904230,533904231,533904232,533914010,533914011,533914012,5339031311,5339031313,5339031331,5339031333,5339033111,5339033112,5339033113,5339042010,5339042012,5339042013,5339042021,5339042102,5339042103,5339042112,5339042210,5339042211,5339042213,5339042231,5339042330,5339042332,5339042333,5339140130,5339140131,5339140132,5339140300,5339141000,5339141002,5339141020,53390311323,53390311332,53390311333,53390313101,53390313103,53390313121,53390313123,53390313301,53390313303,53390313321,53390313323,53390331101,53390331102,53390331103,53390331311,53390402020,53390402022,53390402032,53390402033,53390402120,53390402122,53390402300,53390402302,53390402320,53390402322,53390420112,53390420113,53390420200,53390420201,53390420231,53390420233,53390421000,53390421002,53390421013,53390421102,53390421132,53390422011,53390422331,53390422333,53390423310,53390423312,53390430222,53390432223,53390432232,53391401330,53391401331,53391401332,53391403010,53391403011,53391403020,53391403100,53391403101,53391410010,53391410011,53391410012,53391410030,53391410032,53391410033,53391410210,53391410211,53391410212,
078,15,/бԻ,502101562,127378125,502312500,127603125,0,0,0,8,24,26,533903331,533903333,533904222,533913111,533913113,533914000,533914001,533914003,5339033121,5339033123,5339033130,5339033132,5339033133,5339033301,5339033303,5339033321,5339033323,5339042022,5339042200,5339042202,5339042203,5339042212,5339042230,5339042232,5339131101,5339131103,5339131121,5339131123,5339140020,5339140021,5339140210,5339140211,53390331033,53390331310,53390331312,53390331313,53390420202,53390420203,53390420230,53390420232,53390422010,53390422012,53390422013,53390422330,53390422332,53391311001,53391313011,53391313013,53391313031,53391313100,53391313101,53391313102,53391313110,53391313111,53391313120,53391402121,53391402130,53391402131,
078,16,/ë/Ķ,501862500,127453125,502256250,127856250,0,0,2,17,40,85,53391312,53391331,533913011,533913013,533913031,533913033,533913100,533913102,533913103,533913132,533913133,533913301,533913303,533913321,533913322,533913323,533913330,533913332,533923101,5339033221,5339033223,5339130101,5339130103,5339130121,5339130123,5339130301,5339130303,5339130321,5339131012,5339131013,5339131102,5339131120,5339131122,5339131300,5339131302,5339131313,5339132110,5339132111,5339133000,5339133001,5339133003,5339133021,5339133023,5339133201,5339133203,5339133310,5339133312,5339133330,5339133332,5339140022,5339140023,5339140200,5339140201,5339140202,5339140220,5339140222,5339142000,5339231000,5339231001,53390323232,53390323233,53390323322,53390323323,53390332032,53390332033,53390332221,53390332222,53390332223,53390332300,53390332302,53390332303,53390332320,53390332321,53390332322,53391301221,53391301223,53391303001,53391303003,53391303020,53391303021,53391303023,53391303201,53391303203,53391303231,53391303233,53391310112,53391310113,53391311002,53391311003,53391313010,53391313012,53391313030,53391313032,53391313033,53391313103,53391313112,53391313113,53391313121,53391313122,53391313123,53391321011,53391330021,53391330023,53391330201,53391330203,53391330221,53391330223,53391332001,53391332003,53391332021,53391332022,53391332023,53391333110,53391333111,53391333112,53391402030,53391402032,53391402210,53391402212,53391402230,53391420020,53391420021,53391420022,53391420200,53391420202,53391420220,53392301113,53392310021,53392310030,53392310031,53392310033,53392310211,53392310300,53392310301,53392310303,53392310310,53392310311,53392310312,53392311000,53392311001,53392311010,53392311011,53392311100,53392311101,
078,17,滳/Ĺ,502115625,127762500,502523437,127921875,0,0,0,6,25,43,533924001,533924002,533924003,533924010,533924012,533924030,5339142333,5339143222,5339231103,5339231112,5339231113,5339231130,5339231131,5339231133,5339231311,5339231313,5339240002,5339240003,5339240110,5339240111,5339240112,5339240200,5339240201,5339240202,5339240210,5339240211,5339241000,5339241001,5339241003,5339241010,5339241012,53391422322,53391423223,53391423232,53391423233,53391423322,53391423323,53391432200,53391432202,53391432203,53391432212,53391432230,53391432232,53392311012,53392311013,53392311102,53392311103,53392311211,53392311320,53392311321,53392311323,53392313101,53392313103,53392313121,53392313123,53392313310,53392313311,53392400011,53392400013,53392401130,53392401300,53392401302,53392401320,53392402030,53392402031,53392402032,53392402131,53392402200,53392403201,53392403210,53392403211,53392410021,53392410112,53392410130,
078,18,˾/,502171875,127584375,502467187,127818750,0,0,1,8,23,59,53391421,533914023,533914032,533914201,533914203,533914220,533914221,533914222,533914230,5339133313,5339133331,5339133333,5339140303,5339140330,5339140332,5339140333,5339141222,5339142001,5339142003,5339142021,5339142023,5339142230,5339142231,5339142233,5339142310,5339142312,5339142320,5339142321,5339142330,5339143000,5339231111,5339240000,53391333113,53391402031,53391402033,53391402120,53391402122,53391402123,53391402132,53391402133,53391402211,53391402213,53391402231,53391402232,53391402233,53391403012,53391403013,53391403021,53391403022,53391403023,53391403102,53391403120,53391403122,53391403312,53391403313,53391412202,53391412203,53391412232,53391420023,53391420201,53391420203,53391420221,53391420222,53391420223,53391422320,53391422321,53391422323,53391423110,53391423111,53391423112,53391423130,53391423220,53391423221,53391423222,53391423230,53391423231,53391423312,53391423320,53391423321,53391430010,53391430020,53391430200,53391430202,53391430203,53391430220,53391430222,53391430223,53391432000,53391432001,53392400010,53392400012,
078,19,,502537500,127762500,502762500,127978125,0,0,0,5,22,30,533924111,533924113,533924131,533924133,533925020,5339143333,5339152220,5339152222,5339152223,5339241101,5339241103,5339241303,5339241321,5339243110,5339243111,5339250000,5339250001,5339250002,5339250020,5339250022,5339250023,5339250210,5339250212,5339250220,5339250221,5339250222,5339250230,53391433232,53391433233,53391433312,53391433322,53391433323,53391522211,53391522212,53391522213,53392411001,53392411002,53392411003,53392411020,53392411021,53392411023,53392411201,53392411210,53392411211,53392413231,53392413233,53392431120,53392500030,53392500032,53392500210,53392500212,53392500213,53392500322,53392502310,53392502312,53392502313,53392520000,
078,20,/ḫ,502692187,127500000,503550000,128015625,0,4,13,18,20,65,5339153,5339163,5339162,5339160,53391523,53392501,53392503,53392510,53392511,53392600,53392601,53391513,53391521,53391511,53391612,53392610,53392611,533915122,533915203,533915221,533915223,533925001,533925120,533925121,533925122,533925130,533925131,533925133,533925211,533925300,533926020,533926021,533926022,533915123,533915121,5339150333,5339151203,5339152012,5339152013,5339250030,5339250031,5339250033,5339250211,5339250213,5339251321,5339251323,5339252101,5339252130,5339252131,5339260230,5339260300,5339260301,5339150331,5339152011,5339150332,53391520031,53391520033,53391520102,53391520103,53391520211,53391520213,53391520231,53391520233,53391522011,53391522013,53391522031,53391522033,53392500031,53392500033,53392500211,53392500320,53392500321,53392500323,53392502311,53392512300,53392512301,53392512310,53392512311,53392513200,53392513201,53392513203,53392513221,53392521000,53392521001,53392521003,53392521021,53392521023,53392521030,53392521031,53392521032,53392521201,53392521210,53392521330,53392530102,53392530120,53392530200,53392530201,53392602310,53392602320,53392603020,53392603021,53392603022,53392603100,53391503303,53392603101,53392603110,53392603111,53391503133,53391512012,53391512013,53391512011,53391520101,53391503222,53391503223,53391503232,53391503233,53391512021,53391512022,53391512023,53391503231,
078,21,¢/,502621875,127931250,502846875,128137500,0,0,0,6,19,36,533925201,533925203,533925221,533925223,533925230,533925232,5339243113,5339243131,5339250223,5339250232,5339250233,5339252001,5339252002,5339252003,5339252020,5339252021,5339252122,5339252123,5339252132,5339252221,5339252223,5339252310,5339350001,5339350010,5339350011,53392520001,53392520002,53392520003,53392520220,53392520221,53392520230,53392520231,53392520233,53392521002,53392521020,53392521022,53392521033,53392521200,53392521202,53392521203,53392521211,53392521212,53392521213,53392522011,53392522013,53392522031,53392522033,53392523120,53392523122,53392523300,53393500001,53393500003,53393500021,53393500030,53393500032,53393500121,53393500123,53393500130,53393501000,53393501001,53393501010,
079,00,ɴ/и,502031250,128015625,502579687,128296875,0,0,1,11,42,73,53393403,533924222,533924223,533933121,533934000,533934001,533934003,533934012,533934021,533934120,533934121,533934210,5339233311,5339233313,5339233331,5339233333,5339242202,5339242203,5339242212,5339331032,5339331103,5339331111,5339331112,5339331113,5339331121,5339331122,5339331123,5339331130,5339331131,5339331132,5339331231,5339331300,5339331301,5339331302,5339340020,5339340021,5339340023,5339340132,5339340201,5339340202,5339340203,5339340221,5339340230,5339340231,5339340233,5339341022,5339341220,5339341221,5339341222,5339341230,5339341302,5339342013,5339342110,5339342111,53392331332,53392331333,53392333101,53392333103,53392333121,53392333123,53392333301,53392422002,53392422013,53392422100,53392422102,53392422103,53392422130,53392422132,53393310331,53393310332,53393310333,53393311101,53393311102,53393311103,53393311201,53393311202,53393311203,53393311330,53393311331,53393312301,53393312331,53393313030,53393313031,53393313032,53393313100,53393313200,53393313201,53393313202,53393313210,53393400220,53393400221,53393400223,53393401302,53393401331,53393401332,53393401333,53393402001,53393402002,53393402003,53393402201,53393402321,53393402323,53393410230,53393410232,53393410233,53393410322,53393410323,53393410332,53393412230,53393412310,53393412311,53393413002,53393413003,53393413012,53393413030,53393413032,53393420101,53393420110,53393420111,53393420113,53393420311,53393421120,53393421200,53393421201,53393430000,53393430001,53393430002,
080,00,/ͳ/,502157812,126975000,502537500,127312500,0,0,3,14,24,51,52397423,52397420,52397402,523974212,523974213,523974220,523974221,523974223,523974320,523974322,523974323,533904001,533904003,533904010,533904011,533904012,523974210,5239733131,5239733133,5239742113,5239742220,5239742221,5239743020,5239743022,5239743023,5239743210,5239743212,5239743213,5339040021,5339040023,5339040130,5339040200,5339040201,5339040210,5339041000,5339041001,5339041002,5239742112,5239740323,5239740322,5239740320,52397331132,52397331133,52397331301,52397331303,52397331321,52397333111,52397333113,52397333131,52397333133,52397421103,52397421112,52397422221,52397422230,52397422231,52397422233,52397430022,52397430212,52397430320,52397430322,52397430323,52397432110,52397432112,52397432113,53390400011,53390400031,53390400033,53390400203,53390400221,53390400222,53390400223,53390401310,53390401311,53390401312,53390401320,53390401321,53390401322,53390402021,53390402023,53390402030,53390402031,53390402110,53390402112,53390403011,53390403013,53390403100,53390403102,53390410030,53390410031,53390410032,52397421102,52397421100,
081,00,ܲ/,502312500,126375000,503212500,127200000,1,6,17,18,22,25,523965,5239750,5239751,5239552,5239641,5239643,5239741,52396622,52396620,52397600,52397521,52395532,52395530,52395413,52395502,52395431,52395433,52395503,52397401,52396423,52397530,52397532,52395512,52395533,523974301,523974310,523974311,523975200,523975201,523975203,523975230,523975231,523974031,523974033,523974030,523975330,523975332,523975333,523955312,523955310,523955132,523955130,5239743000,5239743001,5239743003,5239743030,5239743031,5239743033,5239743120,5239743121,5239743130,5239743131,5239752020,5239752021,5239752023,5239752210,5239752211,5239752213,5239752231,5239752320,5239752321,5239752330,5239752331,5239740321,52397421101,52397421110,52397421111,52397421113,52397430020,52397430021,52397430023,52397430210,52397430211,52397430213,52397430321,52397431220,52397431221,52397431230,52397431330,52397431331,52397520220,52397520221,52397520223,52397522010,52397522011,52397522121,52397522123,52397522301,52397522303,
082,00,ʿ/,501243750,126900000,501764062,127425000,0,2,10,12,31,80,5239722,5239720,52397232,53390201,53390210,53390211,53390213,52397231,52397230,52397212,52397213,52397210,523972330,523972332,533902000,533902001,533902003,533902030,533902031,533902033,533902120,533902121,533902123,533902311,5239711330,5239711333,5239713110,5239713111,5239713113,5239713131,5239713133,5239713310,5239713311,5239713313,5239723310,5239723311,5239723312,5239723330,5239723332,5239723333,5339011111,5339011113,5339020020,5339020021,5339020023,5339020211,5339020320,5339020321,5339022110,5339022111,5339023011,5339023130,5339023131,5239711331,5239711313,52397113320,52397113321,52397113323,52397131121,52397131123,52397131301,52397131303,52397131321,52397131323,52397133121,52397133311,52397133332,52397133333,52397233130,52397233131,52397233132,52397233310,52397233312,52397233313,52397320222,52397322000,52397322002,53390111310,53390111311,53390111313,53390200220,53390200221,53390202101,53390202130,53390202131,53390202133,53390202311,53390202313,53390203233,53390212200,53390212201,53390212202,53390212210,53390212211,53390212213,53390212220,53390212222,53390212231,53390212233,53390221011,53390221013,53390221130,53390221132,53390230000,53390230011,53390230100,53390230101,53390231000,53390231001,53390231003,53390231010,53390231011,53390231021,53390231023,53390231213,53390231231,53390231233,53390231320,53390231321,53390231322,53390231330,53390231331,53390300000,53390320002,53390320020,53390320022,53390320200,53390320202,53390320220,53390320222,52397113123,52397113113,52397113111,52397113112,52397113121,
082,01,ƣ//,501735937,126975000,502256250,127518750,0,0,15,23,43,78,52397323,52397332,53390301,53390302,53390303,53390310,53390312,53390321,53390330,52397330,52397312,52397313,52397303,52397321,52397302,523973221,523973222,523973223,523973330,523973332,523973333,533903001,533903002,533903003,533903110,533903111,533903112,533903130,533903132,533903201,533903203,533903231,533903321,523973310,523973312,523973200,523973201,523973203,5239732201,5239732202,5239732203,5239733110,5239733112,5239733310,5239733312,5339030001,5339030002,5339030003,5339031130,5339031131,5339032001,5339032003,5339032021,5339032023,5339032301,5339032303,5339032330,5339032331,5339032333,5339033100,5339033101,5339033102,5339033120,5339033122,5339033200,5339033201,5339033202,5339033220,5339033231,5339033233,5339033300,5339033302,5339033320,5339033322,5339040000,5339040002,5339131010,5239733111,5239732020,5239732021,5239732023,52397233133,52397233311,52397322001,52397322003,52397331130,52397331300,52397331302,52397331320,52397331322,52397331323,52397333110,52397333112,52397333130,52397333132,52397422220,52397422222,52397422223,52397422232,53390300001,53390300002,53390300003,53390311320,53390311321,53390311322,53390311330,53390311331,53390313100,53390313102,53390313120,53390313122,53390313300,53390313302,53390313320,53390313322,53390320000,53390320001,53390320003,53390320021,53390320023,53390320201,53390320203,53390320221,53390320223,53390323000,53390323001,53390323003,53390323021,53390323210,53390323211,53390323213,53390323231,53390323320,53390323321,53390331030,53390331031,53390331032,53390331100,53390332030,53390332031,53390332220,53390332301,53390332323,53390400010,53390400012,53390400013,53390400030,53390400032,53390400200,53390400201,53390400202,53390400220,53391310110,53391310111,53391311000,52397331131,52397320220,52397320221,52397320223,
083,00,Į/,501356250,127753125,502171875,128221875,0,1,11,25,42,121,5339232,53392231,53392233,53392302,53392303,53392312,53392330,53392332,53393201,53393210,53393211,53393301,533922131,533922132,533922133,533922301,533922303,533922321,533922322,533922323,533923001,533923003,533923012,533923013,533923130,533923132,533923310,533932003,533932030,533932031,533932120,533932121,533933000,533933001,533933100,533933101,533933102,5339132221,5339132223,5339132232,5339132233,5339132322,5339221133,5339221232,5339221233,5339221303,5339222333,5339223203,5339230001,5339230003,5339230021,5339230022,5339230023,5339230100,5339230102,5339230113,5339231020,5339231022,5339231023,5339231032,5339231033,5339231102,5339231120,5339231122,5339231123,5339233320,5339233322,5339320011,5339320013,5339320211,5339330031,5339330033,5339330300,5339330301,5339331030,5339331031,5339331100,5339331101,5339331102,53391322023,53391322032,53391322033,53391322122,53391322201,53391322203,53391322221,53391322223,53391322300,53391322302,53391322303,53392211323,53392212311,53392212312,53392212313,53392213013,53392213022,53392213023,53392222323,53392222332,53392222333,53392223222,53392223223,53392223232,53392223233,53392223311,53392223312,53392223313,53392223322,53392223323,53392230213,53392230231,53392230233,53392232011,53392232012,53392232013,53392232021,53392232022,53392232023,53392300001,53392300003,53392300021,53392300023,53392300201,53392300203,53392301030,53392301032,53392301033,53392301123,53392310020,53392310022,53392310023,53392310032,53392310210,53392310212,53392310213,53392310302,53392310313,53392311002,53392311003,53392311210,53392311212,53392311213,53392311322,53392313100,53392313102,53392313120,53392313122,53392331200,53392331201,53392331202,53392331210,53392333002,53392333020,53392333022,53392333023,53392333232,53392333233,53392333322,53392333323,53393200101,53393200103,53393200121,53393200123,53393202100,53393202101,53393202103,53393202121,53393202130,53393202131,53393202133,53393202311,53393203200,53393203201,53393203210,53393203211,53393203300,53393213000,53393213002,53393213020,53393213022,53393300200,53393300201,53393300202,53393300210,53393300301,53393300303,53393300321,53393302110,53393302111,53393303100,53393303101,53393303110,53393303111,53393310330,53393311100,53393311200,53393312000,53393312001,53393312010,53393312011,
083,01,ܸ/Ϸ̾,500920312,127096875,501989062,127996875,1,4,16,34,93,213,533912,5339013,5339111,5339113,5339220,53390112,53390113,53390121,53390123,53390220,53390222,53390223,53390232,53390233,53390322,53391101,53391300,53391302,53391320,53392111,53392210,523971321,523971323,523971330,523971332,533901031,533901032,533901033,533901101,533901102,533901103,533901110,533901112,533902020,533902022,533902212,533902213,533902302,533902303,533911031,533911033,533911211,533911213,533913212,533913213,533913230,533913231,533913233,533921101,533921131,533922110,533922111,533922112,533922120,533922121,5239713032,5239713201,5239713203,5239713221,5239713223,5239713330,5239713332,5339010131,5339010132,5339010133,5339010233,5339010301,5339010303,5339011001,5339011003,5339011110,5339011112,5339011130,5339011132,5339011133,5339012011,5339012013,5339012213,5339012231,5339012233,5339020212,5339020230,5339020232,5339020233,5339020322,5339022100,5339022102,5339022103,5339022112,5339023002,5339023003,5339023012,5339023013,5339023103,5339023120,5339023122,5339032320,5339032322,5339110011,5339110013,5339110031,5339110033,5339110211,5339110300,5339110301,5339110303,5339110321,5339112310,5339112311,5339112313,5339130100,5339130102,5339130120,5339130322,5339132100,5339132102,5339132103,5339132112,5339132113,5339132200,5339132201,5339132210,5339132211,5339132213,5339132231,5339132320,5339132321,5339132323,5339211001,5339211031,5339211301,5339211303,5339211331,5339221130,5339221131,5339221220,5339221221,5339221230,5339221300,5339222001,5339222010,5339222100,5339222101,5339222103,5339222110,5339222112,5339230101,5339230110,52397130233,52397130302,52397130303,52397130332,52397132003,52397132021,52397132023,52397132223,52397133120,52397133122,52397133123,52397133310,52397133312,52397133313,52397133330,52397133331,53390101123,53390101132,53390101133,53390101232,53390101233,53390101301,53390101303,53390102312,53390102313,53390103001,53390103003,53390103021,53390103023,53390110001,53390110003,53390110021,53390110022,53390110023,53390111312,53390120310,53390120311,53390120313,53390120331,53390120333,53390122111,53390122113,53390200222,53390200223,53390202100,53390202102,53390202103,53390202132,53390202310,53390202312,53390203230,53390203231,53390203232,53390212203,53390212212,53390212221,53390212223,53390212230,53390212232,53390221010,53390221012,53390221131,53390221133,53390230001,53390230002,53390230003,53390230010,53390230012,53390230013,53390230102,53390230103,53390231002,53390231012,53390231013,53390231020,53390231022,53390231210,53390231211,53390231212,53390231230,53390231232,53390231323,53390231332,53390231333,53390323002,53390323020,53390323022,53390323023,53390323212,53390323230,53391100301,53391100303,53391100321,53391100323,53391102101,53391102103,53391103020,53391103021,53391103231,53391103233,53391121011,53391121013,53391121031,53391121033,53391121211,53391121213,53391121231,53391121233,53391123011,53391123120,53391123121,53391123123,53391123310,53391123311,53391123313,53391123331,53391301220,53391301222,53391303000,53391303002,53391303022,53391303200,53391303202,53391303230,53391303232,53391321010,53391321012,53391321013,53391322020,53391322021,53391322022,53391322030,53391322031,53391322120,53391322121,53391322123,53391322200,53391322202,53391322220,53391322222,53391322301,53391330020,53391330022,53391330200,53391330202,53391330220,53391330222,53391332000,53391332002,53391332020,53392110001,53392110003,53392110301,53392110330,53392110331,53392110333,53392112111,53392113000,53392113001,53392113003,53392113021,53392113022,53392113023,53392113201,53392113210,53392113211,53392113330,53392113331,53392113333,53392211320,53392211321,53392211322,53392212220,53392212221,53392212222,53392212230,53392212231,53392212310,53392213010,53392213011,53392213012,53392213020,53392213021,53392220000,53392220001,53392220003,53392220110,53392220111,53392220112,53392221020,53392221021,53392221023,53392221110,53392221111,53392221112,53392221130,53392221210,53392221211,53392221300,53392230000,53392300000,53392300002,53392300020,53392300022,53392300200,53392300202,53392301031,53392301110,53392301111,53392301112,53392301120,53392301121,53392301122,
084,00,/,500400000,122850000,502200000,125400000,15,7,0,0,0,0,523913,523903,513962,513972,513952,513921,513931,513942,513973,523902,523912,513932,513941,513920,513930,5139513,5139611,5139511,5139613,5139113,5139112,5139103,
085,00,/Ȭ,501750000,116400000,504000000,123000000,21,0,0,0,0,0,513904,513903,513913,513914,503964,503974,503965,503955,503954,493955,493956,493966,493965,493945,493946,493947,493957,483955,483956,483946,483945,
086,00,޸,504450000,87000000,512550000,110100000,59,0,0,0,0,0,414240,414241,414231,414230,414221,414211,404261,404260,404250,404251,404252,404242,404241,404240,404262,404201,404200,394271,394270,394261,394272,394262,394260,404202,404211,404231,404230,404232,404221,414201,404271,414222,414212,414220,404076,404077,404067,404066,364123,364133,364124,364134,374112,374102,374111,374122,374113,374103,374101,374121,374123,384112,384102,384101,384111,454052,454051,454062,454061,
087,00,ĸ,500104687,126600000,501581250,128175000,1,9,29,79,177,327,533910,5239703,5239712,5338171,5339001,5339002,5339003,5239613,5239710,5239612,52397011,52397012,52397013,52397021,52397023,53380732,53381730,53381731,53381733,53390001,53390003,53390100,53391120,53391122,53392000,53392001,53392010,53392011,53392100,53392101,53392103,53392131,52397110,52397111,52396103,52396102,52396112,52396101,52397112,523960131,523960132,523960133,523960310,523960311,523960323,523960332,523960333,523970023,523970032,523970033,523970101,523970102,523970103,523970201,523970203,523970221,523971132,523971300,523971301,523971310,523971312,533807231,533807332,533807333,533817320,533817321,533827111,533827113,533900001,533900003,533900021,533900023,533901010,533901020,533901021,533901022,533901200,533901202,533901220,533901222,533911000,533911002,533911020,533911022,533911023,533911232,533920021,533920030,533920031,533920120,533920121,533920122,533920130,533920131,533921020,533921021,533921023,533921102,533921120,533921122,533921123,533921211,533921300,533921301,533921303,533921331,533921333,533922202,533922203,533922220,533922221,533922222,533922230,533922231,533931111,533932000,523971130,523961003,5239601133,5239601213,5239601231,5239601233,5239601301,5239601302,5239601303,5239603011,5239603121,5239603130,5239603131,5239603133,5239603211,5239603212,5239603213,5239603220,5239603221,5239603223,5239603303,5239603311,5239603312,5239603313,5239610021,5239610022,5239610023,5239700212,5239700213,5239700221,5239700223,5239700300,5239700302,5239700303,5239700311,5239700312,5239700313,5239701001,5239701003,5239702001,5239702003,5239702231,5239702232,5239702233,5239713020,5239713021,5239713022,5239713031,5239713220,5338072330,5338072331,5338072333,5338073302,5338073303,5338073310,5338073312,5338073313,5338170111,5338170113,5338170131,5338170133,5338170331,5338170333,5338172111,5338172113,5338172131,5338172133,5338172311,5338173221,5338173230,5338173231,5338173233,5338271101,5338271103,5338271121,5339000021,5339000201,5339000203,5339000221,5339000223,5339010110,5339010111,5339010120,5339010121,5339010122,5339010230,5339010232,5339012010,5339012012,5339012030,5339012032,5339012210,5339012212,5339012230,5339012232,5339110010,5339110012,5339110212,5339110213,5339110320,5339110322,5339112100,5339112102,5339112120,5339112122,5339112300,5339112302,5339112303,5339112330,5339112332,5339200201,5339200203,5339200221,5339200230,5339200231,5339200232,5339200320,5339200321,5339200330,5339200331,5339200333,5339201230,5339201231,5339201232,5339201320,5339201321,5339201323,5339201330,5339201331,5339210220,5339210221,5339210223,5339211002,5339211003,5339211032,5339211210,5339211212,5339211213,5339211322,5339211323,5339211330,5339211332,5339212011,5339212100,5339212101,5339212103,5339212131,5339213020,5339213021,5339213023,5339213301,5339213303,5339213321,5339222002,5339222003,5339222012,5339222013,5339222120,5339222122,5339222123,5339222131,5339222132,5339222133,5339222230,5339222231,5339222320,5339222321,5339222330,5339223001,5339223002,5339223003,5339223020,5339223022,5339223200,5339311130,5339311131,5339320021,5239711310,5239610013,52396011232,52396011233,52396011322,52396011323,52396012121,52396012123,52396012301,52396012303,52396012321,52396013001,52396013002,52396013003,52396023311,52396023313,52396030131,52396031201,52396031321,52396031323,52396032023,52396032031,52396032032,52396032033,52396032101,52396032102,52396032103,52396032220,52396032221,52396032223,52396033002,52396033020,52396033022,52396033023,52396033101,52396100122,52396100201,52396100202,52396100203,52397001222,52397001223,52397001313,52397001331,52397001332,52397001333,52397002031,52397002033,52397002102,52397002103,52397002111,52397002112,52397002113,52397002203,52397002221,52397002223,52397003010,52397003012,52397003013,52397003103,52397010001,52397010003,52397010021,52397010022,52397010023,52397020210,52397020211,52397020213,52397020231,52397020233,52397022011,52397022013,52397022233,52397022301,52397022302,52397022303,52397113322,52397130230,52397130231,52397130232,52397130300,52397130301,52397130330,52397130331,52397130333,52397131120,52397131122,52397131300,52397131302,52397131320,52397131322,52397132000,52397132001,52397132002,52397132020,52397132022,52397132220,52397132221,52397132222,53380723011,53380723013,53380723031,53380723033,53380723211,53380723213,53380723321,53380723323,53380730222,53380730223,53380730232,53380733000,53380733002,53380733003,53380733012,53380733013,53380733112,53380733113,53381701101,53381701123,53381701301,53381701303,53381701321,53381701323,53381703110,53381703111,53381703113,53381703133,53381703303,53381703321,53381703323,53381723131,53381732201,53381732320,53381732321,53382710111,53382711000,53382711001,53382711003,53382711021,53382711023,53382711201,53382711203,53382711230,53382711231,53390000011,53390000013,53390000031,53390000032,53390000033,53390000230,53390000231,53390000233,53390002203,53390002221,53390002223,53390101120,53390101121,53390101122,53390101130,53390101131,53390101230,53390101231,53390101300,53390101302,53390102310,53390102311,53390103000,53390103002,53390103020,53390103022,53390110000,53390110002,53390110020,53390120312,53390120330,53390120332,53390122110,53390122112,53391100300,53391100302,53391100320,53391100322,53391102100,53391102102,53391103022,53391103023,53391103230,53391103232,53391121010,53391121012,53391121030,53391121032,53391121210,53391121212,53391121230,53391121232,53391123010,53391123012,53391123013,53391123122,53391123312,53391123330,53391123332,53391123333,53392002000,53392002001,53392002231,53392002330,53392002331,53392002332,53392003220,53392003221,53392003230,53392003231,53392003233,53392003320,53392003321,53392003323,53392012330,53392012331,53392012332,53392013220,53392013221,53392013320,53392013322,53392013331,53392030100,53392030101,53392031100,53392102220,53392102221,53392102223,53392110000,53392110002,53392110300,53392110302,53392110303,53392110332,53392112110,53392112112,53392112113,53392113002,53392113020,53392113200,53392113202,53392113203,53392113212,53392113213,53392113332,53392120001,53392120010,53392120011,53392120100,53392120101,53392120103,53392121020,53392121021,53392121023,53392121300,53392121301,53392121330,53392121331,53392130220,53392130221,53392130223,53392132111,53392133000,53392133001,53392133003,53392133021,53392133023,53392133231,53392133233,53392212223,53392212232,53392212233,53392220002,53392220113,53392221022,53392221113,53392221131,53392221132,53392221133,53392221212,53392221213,53392221301,53392221302,53392221303,53392222320,53392222321,53392222322,53392222330,53392222331,53392223220,53392223221,53392223230,53392223231,53392223310,53392223320,53392223321,53392230001,53392230002,53392230003,53392230210,53392230211,53392230212,53392230230,53392230232,53392232010,53392232020,53393111011,53393111013,53393111031,53393111320,53393111321,53393111323,53393111330,53393111331,53393200100,53393200102,53393200120,53393200122,53393200200,53393200201,53393200202,52397113120,52397113122,52397113110,52396100113,52396100123,
088,00,Ȣ,500315625,126609375,500821875,127040625,0,0,6,17,35,85,52396002,52396003,52396020,52396021,52396022,52397000,523867311,523867313,523867331,523867333,523877111,523877113,523960003,523960012,523960122,523960230,523960231,523960232,523960300,523960302,523960303,523970010,523970011,5238671313,5238671331,5238671333,5238673301,5238673303,5238673321,5238673323,5238771101,5238771103,5238771310,5238771311,5238771313,5239600013,5239600021,5239600023,5239600132,5239601202,5239602330,5239602332,5239602333,5239603010,5239603012,5239603122,5239603123,5239603200,5239603201,5239603301,5239700120,5239700121,5239700123,5239700130,5239700132,5239700200,5239700201,5239700202,52386713111,52386713113,52386713123,52386713301,52386713303,52386713321,52386713323,52386731031,52386731033,52386731211,52386731213,52386731231,52386731233,52387711210,52387711211,52387711213,52387711231,52387711233,52387713121,52387713123,52387713310,52387713311,52387713313,52396000113,52396000221,52396000222,52396000223,52396001020,52396001022,52396001023,52396001032,52396001302,52396001332,52396012002,52396012032,52396012300,52396012302,52396012320,52396012322,52396012323,52396023310,52396023312,52396030130,52396030132,52396030133,52396031200,52396031202,52396031203,52396031320,52396031322,52396032020,52396032021,52396032022,52396032030,52396032100,52396032222,52396033000,52396033001,52396033003,52396033021,52396033100,52396033102,52396033103,52397001220,52397001221,52397001310,52397001311,52397001312,52397001330,52397002030,52397002032,52397002100,52397002101,52397002110,52397002200,52397002201,52397002202,52397002220,52397003011,52397003100,52397003101,52397003102,52397010000,52397010002,52397010020,
089,00,/ϸ,500512500,126450000,501075000,126712500,0,1,3,8,22,41,5239512,52395032,52395033,52396010,523950231,523950232,523950233,523950312,523960011,523960110,523960111,523961000,5239502300,5239502301,5239502303,5239503022,5239503023,5239503031,5239503032,5239503033,5239503132,5239600100,5239600101,5239600131,5239601120,5239601121,5239601122,5239601130,5239601131,5239601201,5239601210,5239601211,5239610010,5239503133,52395021323,52395021331,52395021332,52395021333,52395023021,52395023023,52395030302,52395030303,52395031302,52395031303,52395031312,52396001021,52396001030,52396001031,52396001033,52396001300,52396001301,52396001303,52396001330,52396001331,52396001333,52396011230,52396011231,52396011320,52396011321,52396012000,52396012001,52396012003,52396012030,52396012031,52396012033,52396012120,52396012122,52396013000,52396100110,52396100120,52396100121,52396100200,52396100112,52396100111,52395031313,
090,00,Ǯ//Ʀ,499964062,124950000,501187500,126525000,0,13,32,39,74,173,5239102,5239203,5239301,5239501,5239403,5239401,5239310,5239212,5239201,5239103,5239100,5239002,5239312,52380733,52381703,52381711,52381712,52381713,52381721,52381730,52381731,52381733,52392000,52392001,52393033,52393032,52393031,52394100,52394103,52394121,52394102,52392102,52392100,52392103,52391012,52391010,52390032,52391013,52391122,52394130,52394112,52394120,52395100,52395102,52394122,523807312,523807313,523817023,523817101,523817103,523817201,523817203,523817221,523817230,523817231,523817320,523817321,523827110,523827111,523827113,523920030,523920031,523920033,523920211,523920213,523930013,523930233,523930300,523930301,523930303,523940033,523940211,523940213,523940231,523940233,523950011,523950013,523950031,523950033,523950211,523950300,523950301,523950310,523950311,5238073112,5238073231,5238073232,5238073233,5238170133,5238170203,5238170211,5238170212,5238170213,5238170221,5238170223,5238171001,5238171022,5238171023,5238172230,5238172231,5238172320,5238173220,5238173221,5238173230,5238173231,5238173233,5238271120,5238271121,5238271123,5239200200,5239200201,5239200211,5239200320,5239200321,5239200323,5239202101,5239202103,5239202311,5239202333,5239300111,5239300112,5239300113,5239300311,5239300313,5239302312,5239302313,5239303021,5239303023,5239400110,5239400111,5239400113,5239400131,5239400132,5239400133,5239400311,5239400313,5239400321,5239400323,5239402101,5239402103,5239402301,5239402303,5239402320,5239402321,5239402323,5239500101,5239500103,5239500121,5239500123,5239500301,5239500303,5239502121,5239502123,5239502130,5239502131,5239503020,5239503021,5238073113,52380730313,52380730331,52380731023,52380731032,52380731033,52380732113,52380732131,52380732132,52380732133,52380732231,52380732232,52380732233,52380732303,52381701223,52381701230,52381701232,52381701233,52381701312,52381701313,52381701321,52381701322,52381701323,52381702012,52381702013,52381702023,52381702101,52381702102,52381702103,52381702201,52381702203,52381702221,52381710031,52381710033,52381710202,52381710203,52381710211,52381710212,52381710213,52381720011,52381720013,52381720031,52381720033,52381720211,52381720212,52381720213,52381720230,52381720231,52381720233,52381722011,52381722013,52381722031,52381722033,52381722211,52381722320,52381722321,52381722330,52381722331,52381723211,52381723220,52381723310,52381723311,52381732320,52381732321,52381732323,52382710111,52382710133,52382710311,52382710313,52382711221,52382713101,52382713110,52382713111,52392002100,52392002101,52392002102,52392002131,52392002133,52392002311,52392002313,52392003220,52392003221,52392003223,52392021001,52392021211,52392021213,52392023101,52392023130,52392023131,52392023133,52392023311,52392023313,52392023323,52393001101,52393001103,52393003100,52393003101,52393003103,52393003121,52393003311,52393003313,52393003331,52393003333,52393021111,52393021113,52393021131,52393023033,52393023103,52393023110,52393023112,52393023113,52393023211,52393023213,52393023231,52393023233,52393030201,52394001011,52394001120,52394001121,52394001123,52394001301,52394001303,52394003033,52394003100,52394003101,52394003103,52394003121,52394003122,52394003123,52394021001,52394021003,52394021021,52394021023,52394021201,52394021210,52394021211,52394021213,52394021231,52394021232,52394021233,52394023001,52394023003,52394023021,52394023023,52394023220,52394023221,52394023223,52395001001,52395001003,52395001021,52395001023,52395003211,52395003233,52395021011,52395021013,52395021031,52395021032,52395021033,52395021201,52395021203,52395021221,52395021223,52395021320,52395021321,52395021322,52395021330,52395030300,52395030301,52395031300,52395031301,52395031310,52395031311,52380731113,52380731111,
092,00,/Ʀ,499387500,124425000,500512500,125175000,1,5,19,22,34,81,513876,5238070,5138773,5238071,5138772,5138770,52380601,52380610,52380611,52380720,52380721,52380723,51387712,52390000,52390002,51386633,51386632,51386722,51386623,52380600,52380511,51387531,51387533,51387513,51397022,523806020,523806021,523806030,523806031,523806032,523806120,523806121,523806130,523806131,523806133,523806311,523806313,523807221,523807223,523807300,523807301,523807302,523807320,523817010,523817011,523805131,523805130,5238060221,5238060230,5238060231,5238060233,5238060330,5238061231,5238061320,5238061321,5238063101,5238063103,5238063311,5238072200,5238072201,5238072203,5238072221,5238073030,5238073032,5238073100,5238073101,5238073110,5238073210,5238073212,5238073220,5238073221,5238073222,5238170011,5238170013,5238170031,5238170033,5238170120,5238170121,5238170130,5238171000,5238171002,52380513311,52380602200,52380602201,52380602203,52380602231,52380602320,52380602321,52380602323,52380603310,52380603311,52380612201,52380612210,52380612211,52380612300,52380612301,52380613220,52380613221,52380613230,52380613231,52380613233,52380620110,52380620111,52380620113,52380621000,52380621001,52380621010,52380621011,52380631003,52380631211,52380631213,52380633100,52380633101,52380633103,52380633121,52380633130,52380633131,52380633133,52380722020,52380722021,52380722023,52380722231,52380730310,52380730311,52380730312,52380730330,52380730332,52380730333,52380731020,52380731021,52380731022,52380731030,52380731031,52380731112,52380732110,52380732111,52380732112,52380732130,52380732230,52380732300,52380732301,52380732302,52381700100,52381700101,52381700103,52381700121,52381700123,52381700301,52381700303,52381701220,52381701221,52381701222,52381701231,52381701310,52381701311,52381701320,52381710030,52381710032,52381710200,52381710201,52381710210,52380731110,
093,00,//¾,499387500,125775000,500470312,127434375,0,19,36,51,124,232,5238563,5238570,5238572,5238661,5238670,5238672,5238761,5238763,5238770,5238772,5238773,5338070,5338071,5238362,5238460,5238461,5238463,5238560,5238561,52384722,52385621,52385623,52385730,52385732,52386601,52386631,52386632,52386633,52386710,52386711,52386712,52386730,52386732,52387603,52387621,52387623,52387710,52387712,53380600,53380601,53380610,53380611,53380613,53380731,52383632,52383602,52383531,52383513,52383533,52384702,52384720,52384621,52384623,52384513,52384511,523836330,523836332,523836333,523847000,523847002,523847232,523856201,523857102,523857120,523857122,523857123,523857312,523857330,523857332,523857333,523866031,523866231,523866233,523866301,523866302,523866303,523867130,523867132,523876011,523876012,523876013,523876023,523876201,523876203,523876221,523876223,523877130,523877132,533806020,533806021,533806030,533806031,533806120,533806121,533807210,533807211,533807213,533807300,533807301,533807303,523836302,523836300,523836122,523836033,523836032,523847003,5238363033,5238363122,5238363312,5238363313,5238372220,5238372222,5238372223,5238470010,5238470012,5238470013,5238470122,5238470322,5238472122,5238472300,5238472302,5238472303,5238472332,5238562001,5238562003,5238562031,5238562033,5238562211,5238571002,5238571212,5238573100,5238573102,5238573132,5238573310,5238573312,5238573313,5238660011,5238660013,5238660031,5238660033,5238660300,5238660301,5238660330,5238660331,5238660333,5238662132,5238662133,5238663000,5238663001,5238663003,5238671310,5238673100,5238673101,5238673102,5238673120,5238673122,5238673300,5238673302,5238673320,5238673322,5238760101,5238760102,5238760103,5238760211,5238760213,5238762201,5238762203,5238762221,5238762222,5238762223,5238771100,5238771102,5238771120,5238771122,5238771330,5238771332,5238771333,5239600000,5239600002,5239600020,5239702000,5239702002,5239702020,5239702022,5239702200,5239702202,5239702203,5239702220,5239702221,5239702222,5338051113,5338051131,5338051133,5338051311,5338051313,5338060321,5338060330,5338060331,5338061220,5338061221,5338061230,5338061231,5338061233,5338063100,5338063101,5338063110,5338072001,5338072010,5338072011,5338072013,5338072120,5338072121,5338073020,5338073021,5339000000,5339000002,5339000020,5339000022,5339000200,5339000202,5238361231,5238360300,5238360302,5238360303,5238363032,5238363030,5238363012,5238363010,5238361232,5238361230,52383630312,52383630313,52383631202,52383631203,52383631232,52383633100,52383633102,52383633103,52383722020,52383722022,52383722210,52383722212,52383722322,52384700110,52384700112,52384700113,52384701002,52384701020,52384701202,52384703000,52384703001,52384703002,52384703200,52384703202,52384703203,52384721000,52384721001,52384721002,52384721020,52384721022,52384721200,52384721202,52384721232,52384723010,52384723012,52384723013,52384723120,52384723122,52384723300,52384723302,52384723303,52384723330,52384723332,52384723333,52385620001,52385620003,52385620210,52385620211,52385620301,52385622131,52385622133,52385622311,52385622323,52385622332,52385622333,52385710012,52385710030,52385710032,52385710033,52385710322,52385712100,52385712102,52385712132,52385713220,52385713222,52385731030,52385731032,52385731302,52385733112,52385733113,52386600101,52386600103,52386602111,52386603030,52386603031,52386603033,52386603321,52386621111,52386621313,52386623031,52386623033,52386623211,52386623213,52386623231,52386623232,52386623233,52386630020,52386630021,52386630023,52386713110,52386713112,52386713120,52386713121,52386713122,52386713300,52386713302,52386713320,52386713322,52386731030,52386731032,52386731210,52386731212,52386731230,52386731232,52387600311,52387600313,52387600331,52387600332,52387600333,52387601001,52387601003,52387602121,52387602123,52387602233,52387620011,52387620013,52387620031,52387620033,52387620211,52387620213,52387620231,52387620232,52387620233,52387622021,52387622023,52387622201,52387622203,52387711212,52387711230,52387711232,52387713120,52387713122,52387713312,52395022022,52395022200,52395022202,52395022220,52395022222,52395022223,52396000012,52396000030,52396000032,52396000033,52396000220,52397002222,52397020212,52397020230,52397020232,52397022010,52397022012,52397022230,52397022231,52397022232,52397022300,53380511111,53380511112,53380511113,53380511321,53380511323,53380513121,53380602210,53380602211,53380602300,53380602301,53380602310,53380602311,53380603200,53380603201,53380612321,53380630110,53380630111,53380630113,53380631021,53380631030,53380631031,53380631110,53380631112,53380631120,53380720001,53380720121,53380720311,53380721221,53380721230,53380721231,53380721233,53380730220,53380730221,53380730230,53380730231,53380730233,53380733001,53380733010,53380733011,53380733110,53380733111,53390000010,53390000012,53390000030,53390000232,53390002200,53390002201,53390002202,53390002220,53390002222,52383630310,52383630132,52383630130,52383630112,52383630110,52383612332,52383612330,52383612132,52383612130,52383612123,52383612122,52383612033,52383612032,52383612023,52383612022,52383612020,52383603131,52383603133,52383603132,52383603123,52383603122,52383603120,52383603013,52383603010,52383603012,53380513101,53380513103,52383603102,
093,01,Ʀ,499275000,124912500,500034375,125803125,1,4,17,25,46,117,523816,5238260,5238262,5238153,5238053,52380623,52380630,52380632,52382610,52382632,52383601,52380622,52381511,52381513,52382511,52382513,52382531,52382533,52383600,52383511,52382512,52382530,523806200,523806202,523806203,523806211,523806212,523806213,523806330,523806332,523806333,523817000,523817002,523826110,523826111,523826112,523826120,523826121,523826122,523826300,523826302,523826303,523827000,523836100,523836101,523836102,523805132,5238051333,5238060222,5238060332,5238060333,5238061222,5238061223,5238061232,5238061233,5238062010,5238062012,5238062013,5238062102,5238062103,5238063102,5238063120,5238063122,5238063123,5238072220,5238072222,5238170032,5238170200,5238172000,5238172002,5238172020,5238172022,5238172200,5238172202,5238172220,5238172222,5238172223,5238261130,5238261132,5238261230,5238261232,5238261300,5238263010,5238263012,5238263013,5238361030,5238361032,5238361210,5238361200,5238361201,5238360311,5238051332,5238051330,52380513310,52380513312,52380513313,52380602202,52380602230,52380602232,52380602233,52380602322,52380603312,52380603313,52380612200,52380612202,52380612203,52380612212,52380612213,52380612302,52380612303,52380613222,52380613223,52380613232,52380620112,52380621002,52380621003,52380621012,52380621013,52380631000,52380631001,52380631002,52380631210,52380631212,52380633102,52380633120,52380633122,52380633123,52380633132,52380722022,52380722230,52380722232,52380722233,52381700102,52381700120,52381700122,52381700300,52381700302,52381702010,52381702011,52381702020,52381702021,52381702022,52381702100,52381702200,52381702202,52381702220,52381702222,52381702223,52381720010,52381720012,52381720030,52381720032,52381720210,52381720232,52381722010,52381722012,52381722030,52381722032,52381722210,52381722212,52381722213,52381722322,52382611310,52382611311,52382611312,52382611330,52382612310,52382612311,52382612312,52382612330,52382613010,52382613011,52382613020,52382630112,52382631022,52382631200,52382631202,52382631220,52382631222,52382633000,52382633002,52382633020,52382633022,52382633023,52382633200,52382633201,52382633202,52382633220,52382700100,52382700102,52382700120,52382700201,52383610310,52383610311,52383610312,52383610330,52383610332,52383612110,52383612112,52383612120,52383612121,52383612030,52383612031,52383612021,52383603130,52383603121,52383603011,52383603100,52383603101,52383603103,
093,02,Ʀ,499809375,125362500,500653125,126637500,0,7,23,41,109,245,5238272,5238273,5238370,5238371,5238373,5238471,5238473,52382701,52382702,52382703,52382712,52383611,52383613,52383720,52383721,52383723,52385711,52392020,52392022,52393000,52393002,52393020,52393022,52394000,52394002,52394020,52394022,52395000,52395002,52395020,523826131,523826132,523826133,523826311,523826313,523826331,523826333,523827003,523827100,523827102,523827130,523827132,523827133,523836310,523836311,523836313,523837221,523847011,523847013,523847031,523847033,523847211,523847213,523857101,523857130,523857131,523857133,523857311,523920022,523920230,523920232,523930010,523930012,523930030,523930032,523930210,523930212,523930213,523940012,523950221,523950223,5238172323,5238172330,5238172332,5238172333,5238173222,5238173223,5238261303,5238263100,5238263101,5238263103,5238263121,5238263123,5238263301,5238263303,5238263321,5238263323,5238270011,5238270013,5238270021,5238270022,5238270023,5238271010,5238271012,5238271030,5238271032,5238271033,5238271312,5238271313,5238363121,5238363311,5238372200,5238372201,5238372203,5238372230,5238372231,5238372233,5238470101,5238470103,5238470121,5238470123,5238470301,5238470302,5238470303,5238470321,5238470323,5238472101,5238472103,5238472121,5238472310,5238472311,5238472313,5238472331,5238571000,5238571030,5238571031,5238571033,5238571211,5238571320,5238571321,5238571323,5238573101,5238573131,5238573133,5239200202,5239200203,5239200212,5239200230,5239200232,5239200233,5239202102,5239202120,5239202122,5239202123,5239202312,5239202330,5239300330,5239300332,5239302110,5239302112,5239302300,5239302301,5239302302,5239302320,5239302322,5239303022,5239400100,5239400102,5239400103,5239400300,5239400301,5239400302,5239400320,5239400322,5239402122,5239500120,5239500122,5239500300,5239500302,5239500320,5239500322,5239502100,5239502102,5239502200,5239502201,5239502203,5239502221,5239502223,5239600010,5239600012,52381722323,52381722332,52381722333,52381723210,52381723212,52381723213,52381723221,52381723222,52381723223,52381723312,52381723313,52381732322,52382611313,52382611331,52382611332,52382611333,52382612313,52382612331,52382612332,52382612333,52382613012,52382613013,52382613021,52382613022,52382613023,52382630110,52382630111,52382630113,52382631020,52382631021,52382631023,52382631201,52382631203,52382631221,52382631223,52382633001,52382633003,52382633021,52382633203,52382633221,52382633222,52382633223,52382700101,52382700103,52382700121,52382700122,52382700123,52382700200,52382700202,52382700203,52382710110,52382710112,52382710113,52382710130,52382710131,52382710132,52382710310,52382710312,52382711220,52382711222,52382711223,52382713100,52382713102,52382713103,52382713112,52382713113,52383610313,52383610331,52383610333,52383612111,52383612113,52383612131,52383612133,52383612331,52383612333,52383630111,52383630113,52383630131,52383630133,52383630311,52383631200,52383631201,52383631230,52383631231,52383631233,52383633101,52383722021,52383722023,52383722211,52383722213,52383722320,52383722321,52383722323,52384700111,52384701000,52384701001,52384701003,52384701021,52384701022,52384701023,52384701200,52384701201,52384701203,52384703003,52384703201,52384721003,52384721021,52384721023,52384721201,52384721203,52384721230,52384721231,52384721233,52384723011,52384723121,52384723123,52384723301,52384723331,52385710010,52385710011,52385710013,52385710031,52385710320,52385710321,52385710323,52385712101,52385712103,52385712130,52385712131,52385712133,52385713221,52385713223,52385731031,52385731033,52385731300,52385731301,52385731303,52385733110,52385733111,52392002103,52392002130,52392002132,52392002310,52392002312,52392003222,52392021000,52392021002,52392021003,52392021210,52392021212,52392023100,52392023102,52392023103,52392023132,52392023310,52392023312,52392023320,52392023321,52392023322,52393001100,52393001102,52393003102,52393003120,52393003122,52393003123,52393003310,52393003312,52393003330,52393003332,52393021110,52393021112,52393021130,52393021132,52393021133,52393023030,52393023031,52393023032,52393023100,52393023101,52393023102,52393023111,52393023210,52393023212,52393023230,52393023232,52393030200,52393030202,52393030203,52394001010,52394001012,52394001013,52394001122,52394001300,52394001302,52394003030,52394003031,52394003032,52394003102,52394003120,52394021000,52394021002,52394021020,52394021022,52394021200,52394021202,52394021203,52394021212,52394021230,52394023000,52394023002,52394023020,52394023022,52394023222,52395001000,52395001002,52395001020,52395001022,52395003210,52395003212,52395003213,52395003230,52395003231,52395003232,52395021010,52395021012,52395021030,52395021200,52395021202,52395021220,52395021222,52395022020,52395022021,52395022023,52395022201,52395022203,52395022221,52395023020,52395023022,52396000010,52396000011,52396000013,52396000031,52396000110,52396000111,52396000112,
094,00,ٻε,498895312,127265625,500639062,128643750,2,12,27,82,164,346,533815,533816,5338053,5338062,5338260,5338261,5338263,5338270,5338272,5338273,5338370,5338371,5338372,5338470,53380522,53380523,53380632,53380633,53380722,53381413,53381431,53381700,53381702,53381720,53381722,53382500,53382510,53382511,53382712,53382713,53383601,53383610,53383611,53383613,53383730,53383731,53383732,53384710,53384721,53393000,53393001,533804331,533804333,533805120,533805122,533805123,533805132,533805133,533805213,533806300,533806302,533806303,533806312,533806313,533807202,533814111,533814113,533814330,533814331,533814333,533817010,533817012,533817030,533817032,533817210,533817212,533817230,533817232,533817233,533824111,533824113,533824130,533824131,533824133,533825010,533825011,533825020,533825121,533825130,533825131,533825133,533826200,533826201,533826210,533826211,533826213,533826231,533826233,533827100,533827102,533827103,533836030,533836031,533836120,533836121,533836123,533836310,533836311,533836313,533836331,533836333,533837330,533837331,533837332,533846111,533846113,533846131,533846133,533846311,533847110,533847120,533847121,533847122,533847200,533847201,533847203,533847300,533920200,533930020,533930022,533930200,533930202,533930220,5338043132,5338043133,5338043323,5338050311,5338050313,5338050331,5338050333,5338051212,5338051213,5338051303,5338052022,5338052111,5338052112,5338052113,5338060220,5338060222,5338060223,5338060232,5338060233,5338060322,5338060323,5338060332,5338060333,5338061222,5338061223,5338063010,5338063012,5338063013,5338063113,5338072002,5338072003,5338072030,5338072032,5338072033,5338072300,5338072302,5338072320,5338072322,5338072323,5338141033,5338141101,5338141103,5338141121,5338141122,5338141123,5338141211,5338141213,5338141231,5338141233,5338143011,5338143013,5338143031,5338143033,5338143320,5338143321,5338143323,5338170310,5338170312,5338172110,5338172112,5338172130,5338172132,5338172310,5338172312,5338173222,5338173223,5338241101,5338241103,5338241121,5338241123,5338241320,5338241321,5338241323,5338243101,5338243110,5338243111,5338250120,5338250121,5338250130,5338250131,5338250133,5338250210,5338250220,5338250222,5338251200,5338251201,5338251203,5338251231,5338251320,5338251321,5338251323,5338253110,5338253111,5338262030,5338262031,5338262120,5338262121,5338262303,5338262321,5338262322,5338262323,5338271010,5338271012,5338271013,5338271122,5338360011,5338360013,5338360031,5338360032,5338360033,5338360331,5338361220,5338361221,5338361223,5338363010,5338363011,5338363013,5338363121,5338363123,5338363301,5338363303,5338363321,5338363323,5338373330,5338373331,5338373332,5338461101,5338461103,5338463130,5338463131,5338471110,5338471112,5338471120,5338471121,5338471122,5338471230,5338471232,5338471300,5338472020,5338472021,5338472023,5338472211,5338472300,5338472301,5338473010,5338473020,5339200202,5339200220,5339200222,5339202010,5339202020,5339202021,5339202022,5339202200,5339202202,5339202220,5339202222,5339202223,5339300210,5339300211,5339300212,5339302212,5339302220,5339302221,53380431302,53380431303,53380431312,53380433011,53380433013,53380433031,53380433033,53380433211,53380433212,53380433213,53380501332,53380501333,53380503301,53380503303,53380503321,53380503323,53380512100,53380512102,53380512103,53380512112,53380513020,53380513022,53380513023,53380513122,53380513123,53380520230,53380520232,53380520233,53380520322,53380520323,53380520332,53380520333,53380521101,53380521103,53380521222,53380521223,53380521231,53380521232,53380521233,53380602212,53380602213,53380602302,53380602303,53380602312,53380602313,53380603202,53380603203,53380612320,53380612322,53380612323,53380630112,53380631020,53380631022,53380631023,53380631032,53380631033,53380631111,53380631113,53380631121,53380631122,53380631123,53380720000,53380720002,53380720003,53380720120,53380720122,53380720123,53380720310,53380720312,53380720313,53380721220,53380721222,53380721223,53380721232,53380723010,53380723012,53380723030,53380723032,53380723210,53380723212,53380723320,53380723322,53381411021,53381411023,53381411201,53381411202,53381411203,53381412101,53381412103,53381412121,53381412301,53381412303,53381412321,53381412323,53381430101,53381430103,53381430121,53381430123,53381430301,53381430303,53381430321,53381433221,53381701100,53381701102,53381701103,53381701120,53381701121,53381701122,53381701300,53381701302,53381701320,53381701322,53381703112,53381703130,53381703131,53381703132,53381703300,53381703301,53381703302,53381703320,53381703322,53381723130,53381723132,53381723133,53381732200,53381732202,53381732203,53381732322,53381732323,53382411021,53382411023,53382411201,53382411203,53382411221,53382411222,53382411223,53382412111,53382412113,53382412131,53382412133,53382412311,53382412313,53382413220,53382413221,53382413223,53382431001,53382431003,53382431021,53382431030,53382431031,53382431033,53382431120,53382431121,53382501231,53382501320,53382501321,53382502110,53382502120,53382502121,53382502122,53382502210,53382502211,53382502212,53382502230,53382502300,53382503111,53382503113,53382512020,53382512021,53382512023,53382512210,53382512211,53382512300,53382512301,53382512303,53382512331,53382513220,53382513221,53382520000,53382520001,53382531010,53382531011,53382531130,53382531131,53382620211,53382620320,53382620321,53382620330,53382620331,53382621230,53382621231,53382621233,53382622331,53382622332,53382622333,53382623011,53382623013,53382710110,53382710112,53382710113,53382711002,53382711020,53382711022,53382711200,53382711202,53382711232,53382711233,53383600301,53383600303,53383602111,53383603201,53383603210,53383603211,53383603300,53383603301,53383603303,53383603330,53383603331,53383612221,53383612223,53383630010,53383630011,53383630013,53383630121,53383630311,53383631200,53383631201,53383631203,53383631221,53383631223,53383633003,53383633021,53383633023,53383633201,53383633203,53383633221,53383633223,53383733330,53383733331,53383733332,53384611001,53384611003,53384611021,53384611210,53384611211,53384611213,53384613031,53384613033,53384613211,53384613213,53384613231,53384613233,53384631011,53384631013,53384631031,53384631033,53384631211,53384631320,53384631321,53384631330,53384631331,53384711230,53384711231,53384711232,53384711300,53384711301,53384711302,53384712310,53384712311,53384712312,53384712330,53384712332,53384713010,53384713012,53384713020,53384713021,53384713022,53384720220,53384720221,53384722011,53384722100,53384722101,53384722103,53384723100,53384723101,53384723102,53384723110,53384730110,53384730111,53384730112,53384730120,53384730121,53384730122,53384730130,53384730210,53384730211,53384730212,53384730220,53384730221,53392002002,53392002003,53392002230,53392002232,53392002233,53392020110,53392020112,53392020120,53392020121,53392020122,53392020230,53392020231,53392020232,53392020300,53392020302,53392022322,53392022323,53392022332,53392022333,53392023222,53393002300,53393002301,53393002302,53393002320,53393002322,53393003000,53393003001,53393003002,53393003010,53393003101,53393003110,53393003111,53393003113,53393010000,53393010002,53393010220,53393020100,53393020320,53393020322,53393022100,53393022102,53393022103,53393022220,53393022221,53393022300,53393022302,53380513120,
095,00,ٻ/ٻε,498698437,126300000,499739062,127593750,2,6,21,43,76,134,523865,523875,5238643,5238741,5238743,5338041,5238553,5238551,52385523,52386401,52386403,52386421,52386423,52386620,52386622,52387401,52387403,52387421,52387423,53380401,53380403,53380430,53380432,53380500,53380502,53380510,52385503,52385521,52385501,523855023,523855201,523855203,523855221,523855222,523855223,523856220,523856222,523866000,523866002,523866020,523866022,523866023,523866032,523866210,523866212,523876000,523876001,523876002,523876020,533804211,533804213,533804230,533804231,533804233,533804310,533804311,533804312,533805010,533805011,533805012,533805030,533805032,533805110,533805112,533805200,533805201,533805210,533814100,533814101,523855021,523855001,523855003,5238552001,5238552003,5238552021,5238552023,5238552201,5238552202,5238552203,5238562002,5238562020,5238562022,5238562023,5238562032,5238562210,5238562212,5238562230,5238660012,5238660030,5238660032,5238660210,5238660212,5238660213,5238660302,5238662110,5238662112,5238662113,5238662130,5238662300,5238662301,5238662302,5238662320,5238662322,5238760030,5238760032,5238760210,5238760220,5238760221,5238760222,5238762000,5238762002,5238762020,5238762022,5238762200,5338042100,5338042101,5338042103,5338042121,5338042123,5338042321,5338043300,5338043302,5338043320,5338043322,5338050130,5338050131,5338050132,5338050310,5338050312,5338051110,5338051112,5338051130,5338051300,5338051301,5338052020,5338052021,5338052030,5338052031,5338052120,5338052121,5338140111,5338141020,5338141021,5338141023,5338141030,5338141031,5338141032,5338141100,52385502213,52385502231,52385502233,52385520201,52385520203,52385520221,52385520223,52385522001,52385522003,52385620002,52385620212,52385620213,52385620300,52385620302,52385620303,52385622130,52385622132,52385622310,52385622312,52385622313,52385622320,52385622321,52385622322,52385622330,52385622331,52386600100,52386600102,52386602110,52386602112,52386602113,52386603032,52386603320,52386603322,52386603323,52386621110,52386621112,52386621113,52386621310,52386621311,52386621312,52386623030,52386623032,52386623210,52386623212,52386623230,52386630022,52387600310,52387600312,52387600330,52387601000,52387601002,52387602120,52387602122,52387602230,52387602231,52387602232,52387620010,52387620012,52387620030,52387620032,52387620210,52387620212,52387620230,52387622020,52387622022,52387622200,52387622202,53380402333,53380420111,53380421020,53380421021,53380421023,53380421201,53380421203,53380421221,53380421223,53380423200,53380423201,53380423203,53380423230,53380423231,53380431300,53380431301,53380431310,53380431311,53380431313,53380433010,53380433012,53380433030,53380433032,53380433210,53380501330,53380501331,53380503300,53380503302,53380503320,53380503322,53380511110,53380511320,53380511322,53380512101,53380512110,53380512111,53380512113,53380513021,53380520231,53380520320,53380520321,53380520330,53380520331,53380521100,53380521102,53380521220,53380521221,53380521230,53381401100,53381401101,53381401103,53381401130,53381401131,53381401133,53381401311,53381401313,53381410220,53381410221,53381411020,53381411022,53381411200,53381412011,53381412100,53381412102,53380513100,53380513102,52385620000,
096,00,,497446875,127856250,499921875,129318750,7,16,45,98,229,441,533834,533835,533843,533844,533845,533854,533855,5338323,5338331,5338332,5338333,5338362,5338420,5338421,5338423,5338460,5338462,5338531,5338533,5338560,5338562,5338640,5338651,53382432,53382433,53382521,53382522,53382523,53382530,53382532,53382533,53383133,53383213,53383222,53383223,53383302,53383303,53383632,53384111,53384113,53384131,53384220,53384221,53384610,53384612,53384630,53385211,53385213,53385300,53385301,53385303,53385630,53385632,53386310,53386311,53386410,53386411,53386412,53386420,53386421,53386430,53386500,53386501,53386531,53386600,53386601,53386602,53386610,533823332,533823333,533824213,533824222,533824223,533824231,533824233,533824300,533824302,533824303,533824312,533824313,533825030,533825032,533825033,533825201,533825202,533825203,533825312,533825313,533826220,533826221,533826222,533832111,533832112,533832113,533832120,533832121,533832123,533833002,533833003,533833011,533833012,533833013,533836000,533836002,533836020,533836022,533836023,533836302,533841101,533841103,533841121,533841122,533841123,533841300,533841301,533841303,533841330,533841331,533842220,533842221,533842230,533842231,533842233,533846320,533846321,533846322,533852100,533852101,533852103,533852121,533853020,533853021,533853211,533856122,533856123,533856132,533856310,533863120,533863121,533863130,533863131,533863133,533864130,533864131,533864132,533864220,533864221,533864223,533864230,533864231,533864310,533864312,533864320,533864321,533864330,533865020,533865021,533865030,533865031,533865300,533865301,533865303,533866030,533866110,533866200,533866201,5338232332,5338232333,5338233220,5338233222,5338233223,5338233231,5338233232,5338233233,5338233301,5338233303,5338233310,5338233312,5338233313,5338242112,5338242113,5338242202,5338242212,5338242213,5338242321,5338242322,5338242323,5338243012,5338243013,5338243113,5338250122,5338250213,5338250231,5338250232,5338250233,5338250310,5338250312,5338250313,5338251220,5338251222,5338251223,5338251232,5338252001,5338252002,5338252003,5338253100,5338253102,5338253103,5338253112,5338262020,5338262022,5338262023,5338262122,5338262230,5338262231,5338262232,5338262300,5338262302,5338262320,5338313122,5338313123,5338313211,5338313213,5338313231,5338313232,5338313233,5338321013,5338321020,5338321022,5338321031,5338321033,5338321102,5338321103,5338321221,5338321223,5338322022,5338322023,5338322032,5338322033,5338322122,5338322123,5338322132,5338322133,5338330002,5338330003,5338330012,5338330013,5338330101,5338330102,5338330103,5338360010,5338360012,5338360210,5338360212,5338360213,5338360322,5338360323,5338360332,5338363000,5338363002,5338363003,5338363030,5338363032,5338363033,5338411001,5338411003,5338411021,5338411023,5338411201,5338411203,5338412111,5338413021,5338413210,5338413211,5338413213,5338413320,5338413321,5338413323,5338413330,5338413331,5338422220,5338422221,5338422230,5338422231,5338422321,5338461120,5338461122,5338461123,5338461300,5338461301,5338461302,5338461320,5338461322,5338463100,5338463102,5338463120,5338463122,5338463230,5338463231,5338463300,5338520111,5338520113,5338521021,5338521023,5338521231,5338523100,5338523101,5338523110,5338523111,5338530220,5338530221,5338530222,5338530230,5338530231,5338532131,5338532133,5338561000,5338561002,5338561020,5338561202,5338561203,5338561212,5338561213,5338561302,5338561330,5338563120,5338563122,5338563300,5338563302,5338563320,5338563322,5338631220,5338631221,5338631230,5338631231,5338631320,5338631321,5338633111,5338633113,5338633131,5338633133,5338641330,5338641331,5338641332,5338642220,5338642221,5338642223,5338642320,5338642321,5338642330,5338642331,5338642333,5338643220,5338643221,5338643222,5338643230,5338643231,5338643233,5338643312,5338643320,5338643322,5338650220,5338650221,5338650230,5338650231,5338650320,5338650321,5338650322,5338650330,5338650331,5338650333,5338653020,5338653021,5338653023,5338653210,5338653211,5338653213,5338653300,5338653302,5338660310,5338660312,5338660320,5338660322,5338661120,5338661121,5338661122,5338661300,5338662020,5338662021,5338662022,5338662030,5338662031,5338662100,5338662102,5338662120,53382233233,53382233322,53382233323,53382233332,53382233333,53382323232,53382323233,53382323302,53382323303,53382323311,53382323312,53382323313,53382331232,53382331233,53382332210,53382332212,53382332213,53382332302,53382332303,53382333021,53382333022,53382333023,53382333112,53382333113,53382412223,53382412232,53382421031,53382421032,53382421033,53382421103,53382421111,53382421112,53382421113,53382421210,53382421211,53382421213,53382421231,53382421232,53382421233,53382422002,53382422032,53382422033,53382423010,53382423011,53382423013,53382423031,53382423033,53382423200,53382423202,53382423203,53382430102,53382430113,53382431002,53382431020,53382431022,53382431023,53382431032,53382431122,53382431123,53382501230,53382501232,53382501233,53382501322,53382501323,53382502111,53382502112,53382502113,53382502123,53382502213,53382502231,53382502232,53382502233,53382502301,53382502302,53382502303,53382503110,53382503112,53382512022,53382512212,53382512213,53382512302,53382512330,53382512332,53382512333,53382513222,53382513223,53382520002,53382520003,53382531012,53382531013,53382531132,53382531133,53382620210,53382620212,53382620213,53382620322,53382620323,53382620332,53382620333,53382621232,53382622330,53382623010,53382623012,53383130333,53383131322,53383131332,53383131333,53383132121,53383132123,53383132232,53383132233,53383132301,53383132302,53383132303,53383201313,53383201331,53383201333,53383203111,53383203113,53383203133,53383210113,53383210230,53383210232,53383210233,53383210323,53383211002,53383211003,53383211011,53383211012,53383211013,53383212200,53383212201,53383212203,53383212221,53383212222,53383212223,53383220313,53383221202,53383221303,53383221312,53383221313,53383300002,53383300012,53383300013,53383300102,53383300103,53383300112,53383300113,53383301002,53383301003,53383600300,53383600302,53383602110,53383602112,53383602113,53383603200,53383603202,53383603203,53383603212,53383603213,53383603302,53383603332,53383603333,53383612220,53383612222,53383630012,53383630120,53383630122,53383630123,53383630310,53383630312,53383630313,53383631202,53383631220,53383631222,53383633000,53383633001,53383633002,53383633020,53383633022,53383633200,53383633202,53383633220,53383633222,53384103313,53384103331,53384103332,53384103333,53384110201,53384110203,53384110221,53384112023,53384121130,53384121131,53384121133,53384130200,53384130201,53384130203,53384130230,53384130231,53384130233,53384132011,53384132311,53384133221,53384133223,53384133320,53384223200,53384223201,53384223203,53384223231,53384223233,53384611000,53384611002,53384611020,53384611022,53384611023,53384611212,53384613030,53384613032,53384613210,53384613212,53384613230,53384613232,53384631010,53384631012,53384631030,53384631032,53384631210,53384631212,53384631213,53384631230,53384631231,53384632320,53384632321,53384632330,53384633020,53384633021,53384633022,53385111010,53385111011,53385201100,53385201101,53385201103,53385201121,53385201311,53385210200,53385210201,53385210203,53385210221,53385212010,53385212011,53385212013,53385212031,53385212301,53385212330,53385212331,53385212333,53385230111,53385231031,53385231120,53385231121,53385231130,53385302230,53385302231,53385302232,53385320000,53385320001,53385321000,53385321001,53385321010,53385321011,53385321013,53385321301,53385323110,53385323111,53385323113,53385323131,53385323133,53385610010,53385610011,53385610012,53385610220,53385610221,53385610222,53385612000,53385612002,53385613030,53385613032,53385613033,53385613122,53385613320,53385613321,53385613322,53385631100,53385631102,53385631120,53385631210,53385631212,53385631230,53385631232,53385631233,53385633010,53385633230,53385633232,53385633233,53386301313,53386301331,53386301333,53386303111,53386303113,53386303131,53386303133,53386303311,53386303313,53386303331,53386312220,53386312221,53386312230,53386312231,53386313231,53386331100,53386331101,53386331103,53386331121,53386331123,53386333110,53386333111,53386333113,53386333131,53386333133,53386333311,53386333313,53386422221,53386422223,53386423220,53386423221,53386423230,53386423231,53386423320,53386423321,53386423323,53386431100,53386431102,53386431120,53386431122,53386431300,53386431302,53386431320,53386431322,53386432230,53386432321,53386432323,53386433100,53386433102,53386433103,53386433210,53386433211,53386433212,53386433230,53386433300,53386433301,53386502221,53386502230,53386502320,53386502321,53386502330,53386502331,53386503230,53386503231,53386521110,53386521111,53386521113,53386521131,53386521133,53386521311,53386521313,53386521331,53386530220,53386530221,53386530223,53386532010,53386532011,53386532013,53386532120,53386532121,53386532123,53386532301,53386532310,53386532311,53386533010,53386533011,53386533012,53386533100,53386533101,53386533110,53386533200,53386603110,53386603111,53386603112,53386603130,53386603132,53386603210,53386603211,53386603212,53386603300,53386611102,53386611120,53386611122,53386611230,53386611231,53386611232,53386611300,53386611302,53386611320,53386612000,53386612001,53386612010,53386612011,53386612013,53386612100,53386612101,53386612102,53386612110,53386612111,53386613010,53386613012,53386620230,53386620231,53386620320,53386620321,53386620330,53386620331,53387400010,53387400011,53387400013,53387400100,53387400101,53387401110,53387401111,53387410111,53387411000,
097,00,ȱ,497629687,126590625,498965625,128325000,2,13,47,75,139,311,533803,533813,5238633,5238731,5238732,5238733,5338021,5338023,5338121,5338123,5338142,5338221,5338230,5338231,5338240,52386312,52386313,52386321,52386323,52386420,52386422,52387223,52387233,52387301,52387302,52387303,52387400,52387402,52387420,52387422,53380201,53380202,53380203,53380220,53380221,53380223,53380400,53380422,53381201,53381203,53381221,53381223,53381400,53381402,53381403,53381432,53382201,53382203,53382221,53382222,53382223,53382230,53382231,53382232,53382320,53382321,53382322,53382330,53382410,53382420,53383200,53383202,523863031,523863032,523863033,523863102,523863103,523863112,523863113,523863203,523863221,523863223,523864020,523864022,523864023,523872212,523872221,523872223,523872322,523872323,523873001,523873002,523873003,533801133,533802001,533802003,533802221,533802223,533804020,533804021,533804022,533804200,533804202,533804203,533812001,533812003,533812021,533812022,533812023,533812201,533812203,533812221,533812223,533814010,533814012,533814122,533814300,533814302,533822001,533822003,533822021,533822023,533822201,533822202,533822203,533822330,533822331,533823230,533823231,533823310,533823311,533823313,533823320,533823321,533824120,533831311,533832010,533832011,533832012,533832030,533832032,533832033,533832100,533832200,533832201,533832210,533832211,5238630131,5238630133,5238630231,5238630233,5238631002,5238631102,5238631103,5238631111,5238631112,5238631113,5238632011,5238632012,5238632013,5238632223,5238640002,5238640020,5238640022,5238640023,5238640212,5238640213,5238721133,5238721311,5238721313,5238721331,5238721333,5238722033,5238722201,5238722203,5238722221,5238722222,5238722223,5238723131,5238723132,5238723133,5238723202,5238730001,5238730002,5238730003,5338013110,5338013111,5338013113,5338020001,5338020003,5338020021,5338020023,5338022200,5338022201,5338022203,5338022221,5338022223,5338040230,5338040231,5338040232,5338042010,5338042012,5338042013,5338042322,5338120001,5338120003,5338120021,5338120023,5338120201,5338120202,5338120203,5338122000,5338122001,5338122003,5338122021,5338122023,5338122201,5338122203,5338122221,5338140112,5338140130,5338140132,5338140133,5338141200,5338141202,5338141203,5338213313,5338213331,5338213333,5338220203,5338220221,5338222003,5338223320,5338223321,5338223322,5338223330,5338223331,5338232320,5338232321,5338232322,5338233120,5338233121,5338233122,5338233300,5338241100,5338241210,5338241212,5338241220,5338241221,5338241230,5338241232,5338241233,5338242100,5338242101,5338242102,5338242120,5338242122,5338242201,5338242210,5338242211,5338242300,5338242302,5338311111,5338311113,5338311131,5338311133,5338311311,5338311312,5338311313,5338311331,5338311332,5338311333,5338313130,5338313131,5338320130,5338320132,5338320310,5338320312,5338321010,5338321012,5338321021,5338321030,5338322020,5338322021,5338322030,5338322121,52385333323,52385333332,52385333333,52386301132,52386301133,52386301301,52386301303,52386301321,52386301323,52386302132,52386302133,52386302303,52386302321,52386302323,52386303022,52386303031,52386303032,52386303033,52386310032,52386310033,52386310122,52386310123,52386310131,52386310132,52386310133,52386311013,52386311101,52386311102,52386311103,52386320101,52386320102,52386320103,52386322013,52386322031,52386322033,52386322211,52386322212,52386322213,52386322223,52386400002,52386400210,52386400212,52386402102,52386402103,52386402112,52386402113,52387211133,52387211311,52387211313,52387220233,52387220311,52387220312,52387220313,52387220322,52387220323,52387221022,52387221023,52387221032,52387221320,52387221322,52387222003,52387222021,52387222023,52387222201,52387222202,52387222203,52387231111,52387231113,52387231131,52387231133,52387231223,52387231232,52387231233,52387232000,52387232002,52387232003,52387232032,52387232033,52387232113,52387232123,52387232131,52387232132,52387232133,52387300001,52387300002,52387300003,53380113123,53380113132,53380113133,53380113213,53380131121,53380131123,53380131310,53380131311,53380131313,53380131331,53380131333,53380133111,53380200001,53380200021,53380200023,53380200201,53380200203,53380200221,53380200222,53380200223,53380222021,53380402330,53380402331,53380402332,53380420110,53380420112,53380420113,53380421022,53380421200,53380421202,53380421220,53380421222,53380423202,53380423232,53380423233,53381113131,53381113133,53381113311,53381113313,53381113331,53381113333,53381131111,53381131113,53381202002,53381202003,53381220021,53381222230,53381222231,53381222233,53381401102,53381401132,53381401310,53381401312,53381410222,53381410223,53381412010,53381412012,53381412013,53381412120,53381412122,53381412123,53381412300,53381412302,53381412320,53381412322,53381430100,53381430102,53381430120,53381430122,53381430300,53381430302,53381430320,53381430322,53381430323,53381433220,53381433222,53381433223,53382131313,53382131331,53382131333,53382133111,53382133112,53382133113,53382133321,53382133323,53382200011,53382200013,53382200031,53382202011,53382202012,53382202013,53382202230,53382202231,53382202233,53382220011,53382220013,53382220023,53382233230,53382233231,53382233232,53382233320,53382233321,53382233330,53382233331,53382323230,53382323231,53382323300,53382323301,53382323310,53382331230,53382331231,53382332211,53382332300,53382332301,53382333020,53382333110,53382333111,53382411020,53382411022,53382411200,53382411202,53382411220,53382412110,53382412112,53382412130,53382412132,53382412220,53382412221,53382412222,53382412230,53382412231,53382412233,53382412310,53382412312,53382413222,53382421030,53382421100,53382421101,53382421102,53382421110,53382421212,53382421230,53382422000,53382422001,53382422003,53382422030,53382422031,53382423012,53382423030,53382423032,53382423201,53382430100,53382430101,53382430103,53382430110,53382430111,53382430112,53382431000,53383111101,53383111322,53383111323,53383113100,53383113101,53383113103,53383113213,53383113231,53383113233,53383113301,53383113302,53383113303,53383131011,53383131013,53383131031,53383131033,53383131211,53383131213,53383131320,53383131321,53383131323,53383131330,53383131331,53383201310,53383201311,53383201312,53383201330,53383201332,53383203110,53383203112,53383203130,53383203131,53383203132,53383210110,53383210111,53383210112,53383210231,53383210320,53383210321,53383210322,53383211000,53383211001,53383211010,53383212202,53383212220,53383220310,53383220311,53383220312,53383221200,53383221201,53383221203,53383221300,53383221301,53383221302,53383221310,53383221311,53383300000,53383300001,53383300003,53383300010,53383300011,53383300100,53383300101,53383300110,53383300111,53383301000,53383301001,
098,00,Ų,497109375,125803125,498375000,128306250,3,5,39,118,247,445,523842,523852,523862,5238711,5238712,5238713,5238720,5338211,52383223,52383232,52384113,52384131,52384133,52384302,52384320,52384322,52385111,52385113,52385131,52386131,52386133,52387033,52387103,52387210,52387212,52387230,53380100,53380101,53380103,53380110,53380111,53380112,53380121,53380123,53380130,53380132,53381101,53381103,53381110,53381111,53381112,53381130,53381132,53381133,53382101,53382103,53382130,523832211,523832212,523832213,523832221,523832222,523832223,523832300,523832302,523832332,523841103,523841111,523841112,523841113,523841121,523841123,523841301,523843002,523843003,523843012,523843030,523843032,523843033,523843210,523843211,523843212,523843230,523843232,523851101,523851103,523851121,523851123,523851300,523851301,523851331,523853000,523853002,523853020,523853022,523853200,523853202,523853220,523853222,523853223,523861122,523861131,523861132,523861133,523861301,523861303,523861321,523861323,523863000,523863001,523863002,523863020,523863022,523863200,523863202,523870313,523871012,523871013,523871021,523871023,523872110,523872112,523872130,523872132,523872200,523872201,523872211,523872310,533800111,533800113,533801020,533801021,533801130,533801223,533801310,533801312,533801330,533801332,533801333,533811001,533811002,533811003,533811020,533811021,533811023,533811130,533811132,533811211,533811213,533811231,533811232,533811233,533811310,533811312,533811313,533821211,533821212,533821213,533821230,533821231,533821310,533821311,533821312,533821320,533821321,533821323,533821330,533821332,533822002,533831101,533831103,533831110,533831112,533831123,533831130,5238320321,5238320323,5238320330,5238320332,5238320333,5238322031,5238322033,5238322101,5238322103,5238323030,5238323032,5238323122,5238323300,5238323302,5238323330,5238323332,5238323333,5238411012,5238411021,5238411023,5238411102,5238411103,5238411201,5238411203,5238413030,5238413031,5238413033,5238413211,5238413213,5238413231,5238413232,5238413233,5238430002,5238430003,5238430012,5238430013,5238430102,5238430130,5238430132,5238430310,5238430312,5238430313,5238432130,5238432132,5238432310,5238432312,5238432313,5238432330,5238432331,5238511003,5238511021,5238511023,5238511201,5238511203,5238511221,5238511222,5238511223,5238513021,5238513030,5238513031,5238513300,5238513301,5238513303,5238513330,5238513331,5238513333,5238530010,5238530011,5238530012,5238530030,5238530032,5238530101,5238530210,5238530212,5238530230,5238530232,5238532010,5238532012,5238532030,5238532032,5238532210,5238532212,5238611111,5238611113,5238611131,5238611132,5238611133,5238611202,5238611203,5238611232,5238611233,5238611303,5238613000,5238613001,5238613003,5238613222,5238613223,5238630030,5238630032,5238630210,5238630212,5238632200,5238632202,5238632220,5238703113,5238703121,5238703123,5238710013,5238710031,5238710032,5238710033,5238710102,5238710103,5238710112,5238710113,5238710223,5238721110,5238721111,5238721112,5238721130,5238721132,5238721310,5238721312,5238721330,5238721332,5238722020,5238722021,5238722022,5238722030,5238722100,5238722101,5238722130,5238722131,5238722133,5238723110,5238723112,5238723120,5238723121,5238723130,5238723201,5238723210,5338001100,5338001101,5338001103,5338001120,5338001121,5338001123,5338001310,5338001311,5338001313,5338010230,5338010231,5338010233,5338011310,5338011311,5338011320,5338011322,5338011323,5338012011,5338012013,5338012211,5338012212,5338012213,5338012221,5338013130,5338013132,5338013310,5338013312,5338013313,5338022220,5338022222,5338110002,5338110003,5338110220,5338110221,5338111310,5338111311,5338111312,5338111330,5338111332,5338112101,5338112103,5338112120,5338112121,5338112123,5338112232,5338112233,5338112301,5338112303,5338113110,5338113112,5338113113,5338120000,5338120002,5338120020,5338120022,5338122020,5338122022,5338122200,5338122202,5338122220,5338122222,5338210010,5338210011,5338210013,5338210031,5338210032,5338210033,5338210211,5338210213,5338212031,5338212033,5338212101,5338212102,5338212103,5338212321,5338212330,5338213130,5338213132,5338213220,5338213221,5338213223,5338213310,5338213312,5338213330,5338220000,5338220002,5338220200,5338220202,5338220220,5338220222,5338222000,5338311001,5338311003,5338311112,5338311130,5338311211,5338311212,5338311213,5338311320,5338311322,5338313010,5338313011,5338313013,5338313100,5338313102,5338313120,52383133313,52383133331,52383133332,52383133333,52383203033,52383203312,52383203313,52383212222,52383212223,52383220303,52383220321,52383220323,52383221001,52383221003,52383221021,52383221022,52383221023,52383222032,52383222033,52383230120,52383230122,52383230312,52383230330,52383230332,52383230333,52383233122,52383233312,52383233313,52383322202,52383322220,52383322222,52384110032,52384110033,52384110132,52384110201,52384110203,52384110221,52384110223,52384111000,52384111002,52384111003,52384111011,52384111012,52384111013,52384112210,52384112211,52384112213,52384112231,52384112233,52384130011,52384130013,52384130320,52384130321,52384130323,52384132101,52384132123,52384132301,52384132302,52384132303,52384300000,52384300002,52384300012,52384300013,52384300102,52384300103,52384301032,52384301312,52384301330,52384301332,52384303110,52384303112,52384303113,52384321310,52384321311,52384321312,52384321330,52384321332,52384321333,52384323110,52384323111,52384323112,52384323320,52384323321,52384323322,52384323330,52385110011,52385110012,52385110013,52385110021,52385110023,52385110201,52385110203,52385110221,52385110223,52385112201,52385112203,52385130201,52385130330,52385130331,52385130333,52385132111,52385133021,52385133023,52385133321,52385133323,52385300130,52385300132,52385300310,52385300312,52385300330,52385300332,52385301000,52385301001,52385301003,52385301030,52385301031,52385301100,52385302110,52385302112,52385302130,52385302132,52385302310,52385302312,52385302330,52385302332,52385320110,52385320112,52385322110,52385322112,52385322130,52385322132,52386103131,52386103133,52386103311,52386110232,52386110233,52386111123,52386111233,52386111301,52386111302,52386111303,52386112001,52386112002,52386112003,52386112010,52386112012,52386112013,52386112122,52386112300,52386112302,52386112303,52386112310,52386112312,52386112313,52386113011,52386113012,52386113013,52386130021,52386130210,52386130211,52386130213,52386132011,52386132211,52386132213,52386300310,52386300311,52386300312,52386300330,52386300332,52386302110,52386302112,52386302130,52386302300,52386302301,52386302302,52386302320,52386302322,52386320100,52386322010,52386322011,52386322012,52386322030,52386322032,52386322210,52386322220,52386322221,52386322222,52387031032,52387031033,52387031111,52387031112,52387031113,52387031122,52387031123,52387031222,52387031223,52387032113,52387032131,52387032132,52387032133,52387032310,52387032311,52387032313,52387032331,52387032333,52387100112,52387100113,52387100301,52387100302,52387100303,52387101002,52387101003,52387101012,52387101013,52387101111,52387101112,52387101113,52387102211,52387102212,52387102213,52387102223,52387211130,52387211131,52387211132,52387211310,52387211312,52387220230,52387220231,52387220232,52387220310,52387220320,52387220321,52387221020,52387221021,52387221030,52387221031,52387221033,52387221321,52387221323,52387222000,52387222001,52387222002,52387222020,52387222022,52387222200,52387231110,52387231112,52387231130,52387231132,52387231220,52387231221,52387231222,52387231230,52387231231,52387232001,52387232030,52387232031,52387232110,52387232111,52387232112,52387232120,52387232121,52387232122,52387232130,52387300000,53380010111,53380010113,53380011021,53380011023,53380011220,53380011221,53380011223,53380013011,53380013013,53380013121,53380013123,53380013311,53380102200,53380102201,53380102211,53380102320,53380102321,53380102323,53380113120,53380113121,53380113122,53380113130,53380113131,53380113210,53380113211,53380113212,53380120101,53380120103,53380120121,53380120310,53380120311,53380120313,53380120331,53380120332,53380120333,53380122031,53380122032,53380122033,53380122103,53380122231,53380131120,53380131122,53380131312,53380131330,53380131332,53380133110,53380133112,53380133113,53380200000,53380200002,53380200003,53380200020,53380200022,53380200200,53380200202,53380200220,53380222020,53380222022,53380222023,53381011131,53381011133,53381011311,53381011313,53381011333,53381013111,53381013113,53381013131,53381013133,53381013311,53381013313,53381013331,53381100012,53381100013,53381102220,53381102231,53381113130,53381113132,53381113310,53381113312,53381113330,53381113332,53381121001,53381121003,53381121021,53381121022,53381121023,53381121220,53381121221,53381121223,53381122312,53381122313,53381123001,53381123003,53381123021,53381123023,53381131110,53381131112,53381202000,53381202001,53381220020,53381220022,53381220023,53381222232,53382100121,53382100123,53382102100,53382102101,53382102103,53382102310,53382102311,53382102313,53382120122,53382120123,53382120131,53382120132,53382120133,53382120300,53382120301,53382121001,53382121002,53382121003,53382122110,53382122111,53382122113,53382122131,53382123201,53382123203,53382123221,53382123230,53382123231,53382123310,53382123320,53382123321,53382131310,53382131311,53382131312,53382131330,53382131332,53382132220,53382132221,53382132223,53382133110,53382133320,53382133322,53382200010,53382200012,53382200030,53382200032,53382200033,53382202010,53382202232,53382220010,53382220012,53382220020,53382220021,53382220022,53383110211,53383110213,53383111100,53383111102,53383111103,53383111320,53383111321,53383112101,53383112103,53383113102,53383113210,53383113211,53383113212,53383113230,53383113232,53383113300,53383130121,53383130311,53383131010,53383131012,53383131030,53383131032,53383131210,53383131212,
098,01,/ƣ/,497362500,125100000,498262500,126037500,0,6,17,40,45,124,5238220,5238222,5238311,5238221,5238123,5238121,52381221,52381222,52381223,52382113,52382131,52382132,52382133,52382230,52383130,52383131,52383200,52383202,52382300,52381322,52381320,52381302,52382302,523811333,523812032,523812033,523812201,523812202,523812203,523821111,523821112,523821113,523821123,523821231,523821233,523821301,523821303,523822320,523822321,523822322,523831010,523831011,523831013,523831031,523831033,523831211,523831320,523831321,523831323,523831330,523831331,523831332,523832010,523832011,523832012,523832200,523832201,523832202,523822312,523822310,523822311,523812031,523812013,5238113303,5238113311,5238113312,5238113313,5238120231,5238120233,5238120301,5238120302,5238120303,5238122003,5238211033,5238211103,5238211213,5238213003,5238213021,5238213022,5238213023,5238223230,5238310121,5238310123,5238310301,5238310303,5238310321,5238310323,5238312101,5238312131,5238313220,5238313221,5238313223,5238313330,5238313332,5238320300,5238320301,5238320302,5238320320,5238320322,5238321000,5238321002,5238322200,5238322201,5238322202,5238411001,5238411002,5238411010,5238411011,52381131313,52381131331,52381131332,52381131333,52381133023,52381133101,52381133102,52381133103,52381133201,52381133210,52381133211,52381133213,52381201231,52381201232,52381201233,52381202133,52381202303,52381202321,52381202322,52381202323,52381203001,52381203003,52381220011,52381220012,52381220013,52381220021,52381220023,52382110111,52382110113,52382110312,52382110313,52382111002,52382111003,52382111012,52382111013,52382111021,52382111023,52382112111,52382112112,52382112113,52382112121,52382112122,52382112123,52382121313,52382121322,52382121323,52382121331,52382121332,52382121333,52382123011,52382123012,52382123013,52382123031,52382123033,52382123211,52382123213,52382123223,52382123231,52382123232,52382123233,52382130013,52382130023,52382130201,52382130202,52382130203,52382232310,52382232320,52382232322,52383101200,52383101201,52383101203,52383101221,52383101223,52383103003,52383103021,52383103023,52383103201,52383121031,52383121033,52383121211,52383121300,52383121301,52383121303,52383121330,52383121331,52383121333,52383123111,52383123113,52383123131,52383123133,52383132221,52383132223,52383133310,52383133311,52383133312,52383133330,52383201300,52383201301,52383201302,52383201310,52383201311,52383203030,52383203031,52383203032,52383210200,52383220300,52383220301,52383220302,52383220320,52383220322,52383221000,52383221002,52383221020,52383222030,52383222031,52384110001,52384110003,52384110030,52384110031,52384110130,52384110131,52384110133,52384111001,52384111010,
098,02,Ų/ø,498234375,125775000,499106250,126750000,1,7,16,23,34,110,523854,5238433,5238531,5238641,5238442,5238440,5238443,5238342,52383333,52384311,52384312,52384313,52385303,52385321,52385323,52385330,52385331,52385332,52384412,52383432,52384410,52383430,52383402,52383403,523833312,523833313,523833323,523843101,523843102,523843103,523853012,523853013,523853330,523853331,523853332,523863010,523863012,523864001,523864003,523855020,523855002,523855000,523833311,523833131,523833133,523845222,523845220,5238333033,5238333101,5238333103,5238333211,5238333213,5238333223,5238431001,5238431002,5238431003,5238530102,5238530111,5238530112,5238530113,5238532013,5238532031,5238532033,5238533330,5238533331,5238550220,5238550222,5238552000,5238552002,5238630110,5238630111,5238630112,5238630300,5238630301,5238631000,5238631001,5238631010,5238631011,5238631100,5238640001,5238640003,52383313232,52383330311,52383330312,52383330313,52383330321,52383330323,52383332101,52383332103,52383332121,52383332122,52383332123,52383332203,52383332211,52383332213,52383332221,52383332223,52384301132,52384301133,52384301310,52384301311,52384301313,52384301331,52384301333,52384303111,52384310001,52384310003,52384321313,52384321331,52384323113,52384323323,52384323331,52384323332,52384323333,52385300131,52385300133,52385300311,52385300313,52385300331,52385300333,52385301002,52385301032,52385301033,52385301101,52385301102,52385301103,52385302111,52385302113,52385302131,52385302133,52385302311,52385302313,52385302331,52385302333,52385320111,52385320113,52385322111,52385322113,52385322131,52385322133,52385333320,52385333321,52385333322,52385333330,52385333331,52385502210,52385502211,52385502212,52385502230,52385502232,52385520200,52385520202,52385520220,52385520222,52385522000,52385522002,52386300313,52386300331,52386300333,52386301130,52386301131,52386301300,52386301302,52386301320,52386301322,52386302111,52386302113,52386302131,52386303020,52386303021,52386303023,52386303030,52386310030,52386310031,52386310120,52386310121,52386310130,52386311010,52386311011,52386311012,52386311100,52386400000,52386400001,52386400003,52386400211,52386400213,52386402100,52386402101,52386402110,52386402111,52383313233,
099,00,Ųؼ,497868750,125550000,498600000,126037500,0,2,11,18,36,59,5238330,5238232,52383211,52383213,52383320,52383321,52383323,52383312,52383310,52382233,52382332,52383311,52382333,523832031,523832101,523832103,523832120,523832121,523832123,523832310,523832311,523832313,523833220,523833221,523833223,523833300,523833301,523833302,523833320,523833130,523822313,5238223233,5238320132,5238320133,5238321001,5238321003,5238321021,5238321022,5238321023,5238321220,5238321221,5238321223,5238323010,5238323011,5238323013,5238323120,5238323121,5238323123,5238323301,5238323303,5238323310,5238323311,5238323313,5238332221,5238332223,5238333030,5238333100,5238333102,5238430011,5238430100,5238430101,5238430110,5238430111,5238430112,5238331321,5238331320,5238331322,52382232311,52382232312,52382232313,52382232321,52382232323,52383201303,52383201312,52383201313,52383203310,52383203311,52383210201,52383210202,52383210203,52383212220,52383212221,52383230121,52383230123,52383230310,52383230311,52383230313,52383230331,52383233120,52383233121,52383233123,52383233310,52383233311,52383322200,52383322201,52383322203,52383322221,52383322223,52383330310,52383330320,52383330322,52383332100,52383332102,52383332120,52383332200,52383332201,52383332202,52383332210,52383332212,52383332220,52383332222,52384300001,52384300003,52384300010,52384300011,52384300100,52384300101,52384301030,52384301031,52384301033,52384301130,52384301131,52384310000,52384310002,52383313230,52383313231,
100,00,/,496800000,124425000,497925000,127246875,0,22,43,82,208,411,5238111,5238203,5238210,5238301,5238303,5238401,5238403,5238410,5238412,5238501,5238503,5238510,5238512,5238601,5238603,5238612,5238701,5238022,5238013,5138713,5138711,5238011,52380121,52380123,52381101,52381103,52381121,52381122,52381123,52381130,52381132,52381200,52382012,52382013,52382120,52382122,52383003,52383021,52383100,52383102,52383120,52383122,52385021,52385023,52386001,52386023,52386100,52386101,52386102,52387001,52387003,52387021,52387030,52380203,52380202,52380200,51387222,51387220,51387202,51387200,51386222,51386133,51386132,51386123,51387101,513871031,523801031,523801032,523801033,523810331,523810333,523811001,523811201,523811202,523811203,523811310,523811311,523811312,523812020,523812022,523820033,523820103,523820111,523820112,523820113,523821100,523821102,523821120,523821122,523821210,523821211,523821212,523830011,523830012,523830013,523830201,523830203,523830230,523830231,523830233,523831230,523831232,523831233,523840011,523840012,523840013,523840031,523840213,523840231,523840233,523841302,523841320,523841322,523850033,523850201,523850203,523850221,523850223,523851320,523851322,523851323,523851332,523860001,523860030,523860031,523860033,523860211,523860213,523861030,523861032,523861100,523861101,523861103,523861110,523870003,523870021,523870230,523870231,523870233,523870320,523870322,523871000,523871002,523871020,533800100,523812011,523812010,5138710303,5138710331,5138710332,5138710333,5138712111,5138712112,5138712113,5138712130,5138712131,5138712133,5138712311,5238010111,5238010113,5238010131,5238010132,5238010133,5238010213,5238010231,5238010233,5238010301,5238010302,5238010303,5238012011,5238012013,5238012031,5238012033,5238012211,5238012213,5238012231,5238012232,5238012233,5238103113,5238103131,5238103133,5238103303,5238103321,5238103323,5238110031,5238110033,5238110211,5238110213,5238110231,5238110232,5238110233,5238112002,5238113130,5238113132,5238113300,5238113301,5238113322,5238113323,5238120120,5238120121,5238120122,5238120210,5238120211,5238120212,5238122000,5238200311,5238200313,5238201012,5238201013,5238201101,5238201102,5238201103,5238202111,5238202113,5238202131,5238202331,5238202332,5238202333,5238211010,5238211012,5238211013,5238211030,5238211032,5238211210,5238212130,5238212300,5238212302,5238212320,5238213000,5238300033,5238300211,5238300213,5238300231,5238300232,5238300233,5238302211,5238302321,5238302323,5238310322,5238312100,5238312102,5238312120,5238312122,5238312123,5238312132,5238312310,5238312312,5238400033,5238400101,5238400103,5238400300,5238400301,5238400303,5238400331,5238400333,5238402111,5238402112,5238402113,5238411200,5238411202,5238411220,5238411222,5238413000,5238413002,5238413003,5238500111,5238500113,5238500131,5238500312,5238500313,5238500323,5238502021,5238502023,5238502201,5238502203,5238502221,5238502223,5238511000,5238511200,5238511202,5238513022,5238513023,5238513032,5238513210,5238513212,5238513213,5238600001,5238600030,5238600031,5238600033,5238600321,5238600323,5238602101,5238602103,5238602121,5238602123,5238602213,5238602230,5238602231,5238602233,5238610310,5238610311,5238610312,5238610330,5238610332,5238610333,5238611020,5238611021,5238611022,5238611110,5238611120,5238611121,5238611122,5238611210,5238611211,5238611213,5238611300,5238611302,5238613020,5238613022,5238613023,5238613200,5238613202,5238613203,5238613220,5238700003,5238700011,5238700012,5238700013,5238700021,5238700230,5238700231,5238700233,5238702011,5238702013,5238702031,5238702321,5238702323,5238703100,5238703101,5238703102,5238703110,5238703120,5238703210,5238703212,5238703230,5238703232,5238710010,5238710012,5238710110,5238710220,5338000111,5338000113,5338001010,5138710301,51387103210,51387103211,51387103300,51387103301,51387103303,51387121100,51387121101,51387121103,51387121320,51387121321,51387121323,51387123101,51387123131,51387123133,51387123311,51387123313,51387123333,52380101103,52380101121,52380101123,52380101233,52380101301,52380101302,52380101303,52380103002,52380103003,52380120123,52380120301,52380120303,52380120321,52380120323,52380122101,52380122103,52380122121,52380122123,52380122231,52380122233,52380122301,52380122302,52380122303,52381031111,52381031113,52381031230,52381031231,52381031233,52381031303,52381031321,52381031322,52381031323,52381033011,52381033012,52381033013,52381033023,52381033223,52381100011,52381100013,52381100031,52381100033,52381100300,52381100301,52381100303,52381100321,52381100323,52381102101,52381102103,52381102121,52381102123,52381102301,52381102303,52381120000,52381120002,52381120003,52381120031,52381120033,52381131310,52381131311,52381131312,52381131330,52381133020,52381133021,52381133022,52381133100,52381133200,52381133202,52381133203,52381133212,52381201230,52381202130,52381202131,52381202132,52381202300,52381202301,52381202302,52381202320,52381203000,52381203002,52381220010,52381220020,52381220022,52382003101,52382003103,52382003121,52382003123,52382010033,52382010211,52382010213,52382010230,52382010231,52382010233,52382011001,52382011002,52382011003,52382021100,52382021101,52382021103,52382021121,52382021331,52382021333,52382023111,52382023113,52382023131,52382023132,52382023133,52382023233,52382023301,52382023303,52382110110,52382110112,52382110310,52382110311,52382111000,52382111001,52382111010,52382111011,52382111020,52382111022,52382112110,52382112120,52382121310,52382121311,52382121312,52382121320,52382121321,52382121330,52382123010,52382123030,52382123032,52382123210,52382123212,52382123220,52382123221,52382123222,52382123230,52382130010,52382130011,52382130012,52382130020,52382130021,52382130022,52382130200,52383000322,52383000323,52383001031,52383001033,52383002100,52383002101,52383002103,52383002121,52383002123,52383002300,52383002301,52383002303,52383020213,52383022100,52383022101,52383022103,52383022131,52383023201,52383023203,52383023223,52383101202,52383101220,52383101222,52383103000,52383103001,52383103002,52383103020,52383103022,52383103200,52383103202,52383103203,52383121030,52383121032,52383121210,52383121212,52383121213,52383121302,52383121332,52383123110,52383123112,52383123130,52383123132,52383132220,52383132222,52384000311,52384000313,52384000322,52384000323,52384001001,52384001003,52384001021,52384001022,52384001023,52384002101,52384002111,52384003021,52384003211,52384003300,52384003301,52384003303,52384003321,52384003323,52384021101,52384021103,52384021231,52384021233,52384023011,52384023013,52384110000,52384110002,52384110200,52384110202,52384110220,52384110222,52384112212,52384112230,52384112232,52384130010,52384130012,52384130322,52384132100,52384132102,52384132103,52384132120,52384132121,52384132122,52384132300,52385001100,52385001101,52385001103,52385001121,52385001123,52385001331,52385001333,52385003111,52385003112,52385003113,52385003211,52385003212,52385003213,52385003223,52385020011,52385020013,52385020031,52385020032,52385020033,52385020221,52385020223,52385022001,52385022003,52385022020,52385022021,52385022023,52385022201,52385022203,52385022221,52385110010,52385110020,52385110022,52385110200,52385110202,52385110220,52385110222,52385112200,52385112202,52385130200,52385130202,52385130203,52385130332,52385132110,52385132112,52385132113,52385133020,52385133022,52385133320,52385133322,52386000030,52386000031,52386000033,52386000321,52386000323,52386002110,52386002111,52386002113,52386003200,52386003201,52386003203,52386003221,52386021003,52386021021,52386021023,52386021201,52386021221,52386021222,52386021223,52386022111,52386022112,52386022113,52386022121,52386022122,52386022123,52386022320,52386022321,52386022323,52386103130,52386103132,52386103310,52386103312,52386103313,52386110230,52386110231,52386111120,52386111121,52386111122,52386111230,52386111231,52386111232,52386111300,52386112000,52386112011,52386112120,52386112121,52386112123,52386112301,52386112311,52386113010,52386130020,52386130022,52386130023,52386130212,52386132010,52386132012,52386132013,52386132210,52386132212,52387000021,52387000023,52387000101,52387000102,52387000103,52387000201,52387000231,52387002320,52387002321,52387002323,52387020101,52387020103,52387020121,52387020123,52387020331,52387020333,52387022111,52387022113,52387022131,52387023201,52387031030,52387031031,52387031110,52387031120,52387031121,52387031220,52387031221,52387032110,52387032111,52387032112,52387032130,52387032312,52387032330,52387032332,52387100110,52387100111,52387100300,52387101000,52387101001,52387101010,52387101011,52387101110,52387102210,52387102220,52387102221,52387102222,53380001101,53380010110,53380010112,53380010120,53380010121,53380010122,53380010200,53380010201,53380010210,53380010211,
101,00,/,496589062,124425000,497475000,125700000,0,9,23,43,78,180,5238000,5238001,5238003,5238100,5238101,5238102,5138703,5138702,5138701,51387120,51387122,52371711,52371713,52371731,52371733,52372711,52380021,52380023,52380100,52381030,52381032,52382000,52382001,52382002,52382020,51387102,51387100,51377731,51387002,51387003,51377713,51386122,513871210,513871212,513871230,513871232,523707111,523707112,523707113,523707130,523707131,523707133,523707311,523717121,523717123,523717301,523717303,523717321,523717323,523727130,523727131,523727133,523800200,523800201,523800203,523800221,523800223,523801010,523801020,523801022,523801200,523801202,523801220,523810310,523811002,523811020,523811022,523820030,523820032,523820210,523820212,523820221,523820230,513777333,513777331,5137773323,5138710302,5138710320,5138710322,5138710323,5138712312,5138712330,5138712332,5237071031,5237071033,5237071101,5237071102,5237071103,5237071321,5237073131,5237073323,5237073332,5237073333,5237171033,5237171221,5237171223,5237173001,5237173003,5237173021,5237173023,5237173201,5237271011,5237271013,5237271031,5237271321,5237273111,5237273113,5238002020,5238002021,5238002023,5238002221,5238002222,5238002223,5238010120,5238010121,5238010122,5238010210,5238010211,5238010212,5238010230,5238010232,5238012010,5238012220,5238012221,5238012222,5238103110,5238103112,5238103120,5238103121,5238103122,5238103300,5238103320,5238110000,5238110002,5238112001,5238201000,5238201001,5238201002,5238201010,5238201011,5238201020,5238201022,5238202130,5238202132,5238202201,5238202310,5238202312,5238202320,5238202321,5138710300,5137773321,5137773303,5137773301,51377733203,51377733221,51377733223,51387103212,51387103213,51387103302,51387121102,51387121322,51387123100,51387123102,51387123103,51387123130,51387123132,51387123310,51387123312,51387123330,51387123331,51387123332,52370710133,52370710303,52370710321,52370710323,52370711001,52370711002,52370711003,52370712111,52370713201,52370713233,52370731031,52370731033,52370731300,52370731301,52370731303,52370731331,52370733213,52370733222,52370733301,52370733302,52370733303,52370733312,52370733313,52371710111,52371710112,52371710113,52371710131,52371710133,52371710311,52371710312,52371710313,52371710321,52371710322,52371710323,52371712031,52371712033,52371712203,52371712221,52371712223,52371730001,52371732030,52371732031,52371732033,52371732211,52371732213,52372710101,52372710103,52372710330,52372710331,52372710333,52372712111,52372712113,52372713201,52372713231,52372731101,52372731311,52372731313,52380020220,52380020221,52380020223,52380022010,52380022011,52380022013,52380022031,52380022032,52380022033,52380022201,52380022202,52380022203,52380101100,52380101101,52380101102,52380101120,52380101122,52380101230,52380101231,52380101232,52380101300,52380103000,52380103001,52380120120,52380120121,52380120122,52380120300,52380120302,52380120320,52380120322,52380122100,52380122102,52380122120,52380122122,52380122230,52380122232,52380122300,52381031110,52381031112,52381031232,52381031300,52381031301,52381031302,52381031320,52381033010,52381033020,52381033021,52381033022,52381033220,52381033221,52381033222,52381100010,52381100012,52381100030,52381100032,52381100302,52381100320,52381100322,52381102100,52381102102,52381102120,52381102122,52381102300,52381102302,52381120001,52381120030,52381120032,52382003100,52382003102,52382003120,52382003122,52382010030,52382010031,52382010032,52382010210,52382010212,52382010232,52382011000,52382021102,52382021120,52382021122,52382021123,52382021330,52382021332,52382022031,52382022033,52382022211,52382022300,52382022301,52382022303,52382022310,52382022311,52382023110,52382023112,52382023130,52382023230,52382023231,52382023232,52382023300,52382023302,51377733201,51377733021,51377733023,51377733003,51377733001,
101,01,/ް,496040625,124575000,496968750,125896875,0,8,20,52,91,188,5237061,5237070,5237072,5237170,5237172,5237270,5137772,5137763,52370630,52370631,52370633,52370730,52370732,52371611,52371613,52371631,52371633,52372611,52372730,52372732,52372733,52373710,52373711,51377732,51377612,51377613,51377730,51377702,513776231,513776233,523706011,523706013,523706320,523706321,523706323,523707100,523707102,523707120,523707122,523707123,523707312,523707330,523707331,523716101,523716103,523716121,523716301,523716303,523716321,523716323,523717100,523717102,523726101,523726103,523726131,523727100,523727102,523727120,523727122,523727123,523727210,523727211,523727213,523727231,523727233,523727310,523727312,523737011,523737130,523737131,523737133,523830000,523830001,523830002,523830020,523830022,513776211,513776213,513776033,513776031,5137762303,5137762321,5137762323,5237060310,5237060311,5237060313,5237060331,5237060333,5237062111,5237063221,5237063223,5237071010,5237071011,5237071012,5237071210,5237071212,5237071213,5237071322,5237073100,5237073101,5237073102,5237073132,5237073320,5237161001,5237161231,5237161232,5237161233,5237171010,5237171012,5237171030,5237171200,5237171201,5237171202,5237173002,5237173020,5237173022,5237173200,5237173202,5237173220,5237173222,5237173223,5237261300,5237261301,5237261303,5237261330,5237261331,5237261333,5237271012,5237271030,5237271032,5237271210,5237271212,5237271213,5237271322,5237272011,5237272303,5237272321,5237272322,5237272323,5237273112,5237273130,5237273132,5237273133,5237370101,5237370131,5237370133,5237371200,5237371201,5237371210,5237371211,5237371320,5237371321,5237373110,5237373111,5238002200,5238002202,5238202200,5238202202,5238202220,5238202222,5238202223,5238202232,5238202233,5238202322,5238300030,5238300031,5238300100,5238300101,5238300102,5238302001,5238302003,51377621231,51377621233,51377623011,51377623013,51377733220,51377733222,52370601011,52370601013,52370601031,52370601033,52370601211,52370603120,52370603121,52370621130,52370621131,52370621133,52370621311,52370621313,52370621331,52370621333,52370623111,52370632201,52370632203,52370632221,52370710130,52370710131,52370710132,52370710300,52370710301,52370710302,52370710320,52370710322,52370711000,52370712110,52370712112,52370712113,52370713200,52370713202,52370713203,52370713230,52370713231,52370713232,52370731030,52370731032,52370731302,52370731330,52370731332,52370731333,52370733210,52370733211,52370733212,52370733220,52370733221,52370733223,52370733300,52370733310,52370733311,52371610031,52371610033,52371610211,52371610213,52371610231,52371610233,52371612011,52371612301,52371612303,52371630031,52371630033,52371710110,52371710130,52371710132,52371710310,52371710320,52371712030,52371712032,52371712200,52371712201,52371712202,52371712220,52371712222,52371730000,52371730002,52371730003,52371732032,52371732210,52371732212,52372612101,52372612110,52372612111,52372612113,52372613020,52372613021,52372613023,52372613320,52372613321,52372613323,52372710100,52372710102,52372710332,52372712110,52372712112,52372713200,52372713202,52372713203,52372713230,52372713232,52372713233,52372720000,52372720010,52372720011,52372720100,52372720101,52372720131,52372721201,52372721210,52372721211,52372723013,52372723023,52372723201,52372723203,52372731100,52372731102,52372731103,52372731310,52372731312,52373701000,52373701001,52373701003,52373701021,52373701030,52373701031,52373701301,52373703111,52373712030,52373712031,52373712120,52373712130,52373712131,52373712133,52373712311,52373713221,52373713230,52373731131,52380020222,52380022012,52380022030,52380022200,52382022030,52382022032,52382022210,52382022212,52382022213,52382022302,52382022312,52382022313,52383000320,52383000321,52383001030,52383001032,52383002102,52383002120,52383002122,52383002302,52383020000,52383020001,52383020002,52383020210,52383020211,51377733202,51377733022,51377733200,51377733020,51377733000,51377733002,51377621213,51377621211,51377621033,51377621031,51377621013,51377621011,51377603233,51377603231,51377603213,51377603211,51377603033,51377603031,51377603013,51377603011,
102,00,ڰ/,497812500,129871875,499148437,131100000,2,12,28,82,152,323,543823,543833,5438123,5438221,5438240,5438242,5438340,5438342,5438343,5438431,5438440,5438441,5438321,5438223,54381213,54381322,54381323,54381332,54381412,54381413,54381421,54381422,54381423,54382412,54382430,54382432,54383231,54383233,54383410,54383412,54384301,54384420,54384421,54384430,54384431,54383230,54382203,54382221,54382223,54383201,54383203,54383221,543812101,543812103,543812110,543812112,543812113,543812121,543812122,543812123,543812211,543812213,543812231,543812233,543813022,543813200,543813202,543813203,543813212,543813213,543813313,543813331,543813332,543813333,543814023,543814032,543814033,543814103,543814112,543814113,543814201,543814202,543814203,543814300,543814301,543814302,543814320,543814322,543815020,543822011,543822013,543824100,543824102,543824103,543824112,543824113,543824130,543824132,543824133,543824310,543824312,543824330,543832320,543832323,543834132,543835202,543835220,543835222,543842101,543843001,543843003,543843021,543843030,543843031,543843033,543843300,543843301,543843303,543843310,543843311,543843312,543844320,543844321,543844330,543844331,543845000,543845002,543845020,543845022,543845200,543845202,543845220,543832321,543822012,5438023233,5438023322,5438023323,5438120311,5438120313,5438120331,5438120333,5438121110,5438121112,5438121113,5438121202,5438121203,5438122121,5438122123,5438122301,5438122303,5438122321,5438122323,5438130022,5438130200,5438130202,5438130203,5438130230,5438130232,5438132010,5438132012,5438132013,5438132102,5438132103,5438132112,5438133022,5438133023,5438133112,5438133113,5438133121,5438133123,5438133301,5438133302,5438133303,5438140211,5438140212,5438140213,5438140221,5438140223,5438140300,5438140302,5438140303,5438140311,5438140312,5438140313,5438141022,5438141023,5438142001,5438142002,5438142003,5438143030,5438143031,5438143032,5438143100,5438143101,5438143210,5438150020,5438150022,5438150023,5438150220,5438150221,5438150222,5438220101,5438220103,5438241101,5438241103,5438241112,5438241113,5438241310,5438241312,5438243110,5438243320,5438243322,5438250002,5438250222,5438322311,5438323221,5438323223,5438341100,5438341102,5438341120,5438341122,5438341300,5438341302,5438341332,5438352000,5438352002,5438352003,5438352012,5438352030,5438352032,5438352210,5438352212,5438352230,5438352232,5438421001,5438421021,5438421023,5438421030,5438421031,5438421100,5438421101,5438421110,5438421111,5438430000,5438430001,5438430003,5438430021,5438430023,5438430231,5438430320,5438430321,5438430323,5438432111,5438433021,5438433023,5438433130,5438433131,5438442200,5438442201,5438442202,5438442210,5438442311,5438442313,5438443220,5438443221,5438443230,5438443231,5438443320,5438443321,5438443330,5438443331,5438450010,5438450012,5438450030,5438450032,5438450210,5438450212,5438450230,5438450232,5438452010,5438452012,5438452030,5438452032,5438452210,5438452220,5438452221,54380232232,54380232233,54380232321,54380232322,54380232323,54380233212,54380233213,54380233302,54380233320,54380233322,54380233323,54381203103,54381203121,54381203123,54381203301,54381203303,54381203321,54381203323,54381210010,54381210011,54381210013,54381210211,54381210213,54381210231,54381210233,54381211112,54381212000,54381212002,54381212003,54381212011,54381212012,54381212013,54381221013,54381221031,54381221033,54381221223,54381223001,54381223003,54381223021,54381223023,54381223201,54381223203,54381223221,54381223223,54381300022,54381300200,54381300202,54381300203,54381300230,54381300232,54381302010,54381302012,54381302013,54381302120,54381302122,54381302123,54381302310,54381302312,54381302330,54381302332,54381320112,54381320113,54381321001,54381321002,54381321003,54381321012,54381321013,54381321132,54381321133,54381330200,54381330202,54381330320,54381330322,54381330323,54381330332,54381330333,54381331031,54381331032,54381331033,54381331103,54381331112,54381331113,54381333000,54381333002,54381333003,54381401331,54381401332,54381401333,54381402013,54381402031,54381402032,54381402033,54381402102,54381402103,54381402221,54381402223,54381403010,54381403012,54381403013,54381403101,54381403102,54381403103,54381410123,54381410132,54381410133,54381410202,54381410203,54381410211,54381410212,54381410213,54381411022,54381411023,54381411032,54381411033,54381411122,54381411123,54381411132,54381411133,54381420001,54381420002,54381420003,54381430330,54381430331,54381430332,54381431020,54381431021,54381431022,54381431100,54381431101,54381431110,54381432110,54381432112,54381432120,54381432121,54381432122,54381432130,54381432300,54381432302,54381433233,54381500003,54381500021,54381500022,54381500023,54381500210,54381500212,54381500213,54381500302,54381500320,54381500322,54381502100,54381502102,54381502230,54381502232,54382201001,54382201003,54382201021,54382201023,54382410102,54382410120,54382410122,54382411001,54382411002,54382411003,54382411020,54382411021,54382411023,54382411100,54382411102,54382411103,54382411112,54382411113,54382413110,54382413112,54382413130,54382413132,54382431110,54382431112,54382431120,54382431121,54382431122,54382431300,54382431302,54382431320,54382431322,54382433100,54382433102,54382433120,54382433210,54382500002,54382500200,54382500202,54382500220,54382502202,54383223100,54383223101,54383223103,54383223121,54383223130,54383223131,54383223133,54383232200,54383232201,54383232203,54383232221,54383413032,54383413033,54383413300,54383413302,54383413330,54383413332,54383413333,54383502222,54383502223,54383520010,54383520012,54383520013,54383520100,54383520102,54383520132,54383520310,54383520312,54383522130,54383522132,54383522310,54383522312,54383522330,54384210030,54384210031,54384210033,54384210320,54384210322,54384211020,54384211022,54384211031,54384211120,54384211200,54384300021,54384302011,54384302013,54384302031,54384302300,54384302301,54384302303,54384302321,54384302330,54384303220,54384303221,54384303223,54384330200,54384330201,54384330203,54384330221,54384331320,54384331321,54384331322,54384331330,54384331331,54384331333,54384332010,54384332011,54384332013,54384332100,54384332101,54384332102,54384332110,54384332111,54384332120,54384332122,54384332300,54384333000,54384333001,54384333010,54384333111,54384333113,54384333131,54384333133,54384422030,54384422031,54384422032,54384422110,54384422200,54384422201,54384423100,54384423101,54384423103,54384423310,54384423311,54384423313,54384432220,54384432221,54384432230,54384432231,54384432320,54384432321,54384432330,54384432331,54384433220,54384433221,54384433223,54384433230,54384433231,54384433320,54384433321,54384433322,54384433330,54384500332,54384502110,54384502112,54384502130,54384502132,54384502310,54384502312,54384502330,54384520130,54384520132,54384520310,54384520312,54384520330,54384522120,54384522121,54384522122,54384522300,54382201022,
103,00,/ʿ,497025000,130237500,498445312,131587500,2,7,28,57,146,285,543841,543852,5438312,5438420,5438422,5438423,5438313,5438311,5438213,54383013,54383031,54383033,54383102,54383222,54384011,54384013,54384031,54384212,54384213,54384320,54384322,54384323,54386201,54386210,54386211,54383220,54383202,54382112,54382113,54383200,54382222,54382220,54382202,54383103,54383101,54382123,54382121,543830103,543830121,543830123,543830301,543830321,543830323,543832230,543832232,543832233,543840101,543840103,543840121,543840123,543840301,543840303,543842113,543843022,543843210,543843212,543843213,543851000,543851110,543851111,543851311,543851313,543851331,543851332,543851333,543853000,543853001,543853002,543853020,543853022,543853200,543853202,543853220,543853222,543862000,543862001,543862030,543862031,543862120,543862121,543862122,543862130,543862131,543862133,543863000,543863002,543863020,543863022,543863023,543863200,543821033,543821031,543821032,543831003,5438301120,5438301122,5438301123,5438301132,5438301133,5438301221,5438303031,5438303032,5438303033,5438303201,5438303203,5438303221,5438303223,5438401001,5438401003,5438401021,5438401023,5438403003,5438403021,5438403023,5438403201,5438403210,5438403211,5438403213,5438403300,5438403301,5438403302,5438403310,5438403311,5438403313,5438403331,5438403333,5438421000,5438421002,5438421020,5438421022,5438421033,5438421113,5438421121,5438421122,5438421123,5438430020,5438430022,5438430200,5438430202,5438432110,5438432112,5438432113,5438433200,5438433202,5438433203,5438433220,5438433221,5438501111,5438501113,5438501131,5438510010,5438510011,5438510012,5438510020,5438510021,5438510100,5438511000,5438511001,5438511010,5438511011,5438511013,5438511131,5438511331,5438511333,5438513231,5438513232,5438513233,5438513301,5438513302,5438513303,5438530030,5438530032,5438530100,5438530101,5438530102,5438530210,5438530212,5438530230,5438530232,5438532010,5438532012,5438532030,5438532230,5438532232,5438611010,5438611011,5438611012,5438611100,5438611101,5438611103,5438611110,5438611111,5438611112,5438620031,5438620033,5438620211,5438620320,5438620331,5438620333,5438621230,5438621231,5438621232,5438621320,5438621321,5438621323,5438623000,5438623110,5438623111,5438623113,5438630010,5438630012,5438630030,5438630032,5438630210,5438630212,5438630213,5438630302,5438632010,5438632011,5438632012,5438220031,5438220033,5438220032,5438220023,5438220022,5438211133,5438211132,5438211123,5438211122,5438211033,5438211032,5438210303,5438210301,5438310013,5438310011,5438212233,5438212231,5438310023,5438310022,5438212213,54383010123,54383010132,54383010133,54383010231,54383010233,54383011022,54383011212,54383011312,54383011313,54383012011,54383012013,54383012031,54383012032,54383012033,54383012231,54383012233,54383030011,54383030013,54383030233,54383030300,54383030301,54383030303,54383032203,54383032221,54383032223,54383223102,54383223120,54383223122,54383223123,54383223132,54383232202,54383232220,54383232222,54383232223,54384010001,54384010003,54384010021,54384010023,54384012011,54384012231,54384012233,54384030011,54384030012,54384030013,54384030203,54384030221,54384030222,54384030223,54384032000,54384032001,54384032003,54384032030,54384032031,54384032120,54384032121,54384032123,54384033030,54384033031,54384033032,54384033121,54384033123,54384033301,54384033303,54384033321,54384210032,54384210321,54384210323,54384211021,54384211023,54384211030,54384211032,54384211033,54384211121,54384211122,54384211123,54384211201,54384211202,54384211203,54384300020,54384300022,54384300023,54384302010,54384302012,54384302030,54384302032,54384302033,54384302302,54384302320,54384302322,54384302323,54384302331,54384302332,54384302333,54384303222,54384330202,54384330220,54384330222,54384330223,54384332012,54384332220,54384332221,54384332222,54384332230,54384332231,54384332302,54384332320,54385011121,54385011123,54385011301,54385011303,54385011331,54385100130,54385100131,54385100132,54385100220,54385100221,54385100223,54385100230,54385100232,54385100300,54385100301,54385100302,54385101010,54385101020,54385101100,54385101101,54385101110,54385101111,54385110120,54385110121,54385111200,54385111201,54385111210,54385111211,54385111300,54385111301,54385113113,54385113131,54385113132,54385113133,54385113321,54385113322,54385113323,54385131011,54385131013,54385131031,54385131033,54385131211,54385131213,54385131223,54385131231,54385131232,54385131233,54385132133,54385132303,54385133001,54385133003,54385300310,54385300312,54385300330,54385300332,54385301030,54385301100,54385301101,54385301102,54385301110,54385302110,54385302112,54385302130,54385302132,54385320112,54385320130,54385320320,54385320321,54385320322,54385322100,54385322102,54385322120,54385322122,54385322332,54386110013,54386110031,54386110033,54386110130,54386110131,54386111021,54386111023,54386111130,54386111131,54386111133,54386111210,54386111211,54386111300,54386200200,54386200201,54386200210,54386200211,54386200300,54386200301,54386200303,54386200321,54386200323,54386202101,54386202131,54386202133,54386202311,54386203210,54386203211,54386203300,54386203301,54386203303,54386203321,54386212330,54386212331,54386213220,54386213221,54386221110,54386221111,54386221113,54386230010,54386230011,54386230020,54386230100,54386231011,54386231013,54386231031,54386231120,54386231121,54386300110,54386300112,54386300130,54386300132,54386300310,54386300312,54386300330,54386300332,54386302110,54386302112,54386302113,54386303002,54386303200,54386303201,54386303202,54386303220,54386303222,54386303223,54386320130,54386321000,54386321002,54382200303,54382200302,54382200213,54382200212,54382110233,54382110232,54382110223,54382110222,54382101333,54382101332,54382101323,54382101322,54382101233,54382101232,54382101223,54382103001,54382103003,54382103021,54382103023,54382122113,54382122111,54383100123,54383100121,54382120333,54382120331,54382120313,54383100103,54383100213,54383100122,54383100101,54382122323,54382122321,54383100202,54383100203,54383100212,54383100211,
104,00,Ĺ,496462500,131034375,498389062,132281250,2,15,38,75,154,386,543860,543871,5437673,5437771,5438503,5438512,5438610,5438612,5438613,5438700,5438701,5438720,5438721,5438722,5538010,5538011,5538020,54375731,54375733,54376711,54376712,54376713,54377730,54377731,54377732,54385003,54385010,54385012,54385013,54385021,54385022,54385023,54385102,54385103,54385112,54385130,54386112,54386113,54386220,54386222,54386223,54386232,54386233,54386322,54387020,54387021,54387030,54387031,54387230,54387232,54387300,54387302,55380120,55380212,55380221,543757323,543767033,543767211,543777033,543777211,543777213,543777231,543777330,543777331,543777332,543840322,543840323,543840332,543850012,543850013,543850021,543850023,543850110,543850112,543850201,543850202,543850203,543851012,543851013,543851102,543851103,543851130,543851132,543851320,543851322,543861102,543861103,543862020,543862022,543862210,543862212,543862213,543862302,543862303,543862312,543862313,543863202,543863203,543863212,543863230,543863232,543870220,543870221,543870331,543870333,543872310,543872311,543872312,543873010,543873012,543873030,543873031,543873200,543873202,553800111,553800113,553801210,553801211,553801212,553801311,553802100,553802102,553802200,553802201,553802203,553802221,553802230,553802231,553802300,553802301,5437573013,5437573031,5437573032,5437573033,5437573210,5437573211,5437573213,5437670133,5437670311,5437670313,5437671011,5437671020,5437671022,5437671023,5437671033,5437672131,5437672133,5437672311,5437770131,5437770133,5437770311,5437770312,5437770313,5437770321,5437772121,5437772123,5437772301,5437772302,5437772303,5437772320,5437772331,5437773330,5437773331,5438403202,5438500023,5438500031,5438500032,5438500033,5438500111,5438500112,5438500113,5438500221,5438500223,5438501110,5438501132,5438502001,5438502002,5438502003,5438510031,5438510032,5438510033,5438510103,5438510112,5438510113,5438511002,5438511003,5438511122,5438511123,5438511132,5438511133,5438511310,5438511312,5438511330,5438513100,5438513102,5438513120,5438513210,5438513211,5438513212,5438611000,5438611002,5438611120,5438611122,5438611123,5438611131,5438611132,5438611133,5438620022,5438620023,5438620212,5438620230,5438620232,5438620233,5438620322,5438620323,5438622110,5438622112,5438622113,5438623003,5438623011,5438623012,5438623013,5438623100,5438623102,5438632102,5438632103,5438702300,5438702301,5438702302,5438702310,5438702311,5438703211,5438703300,5438703301,5438703303,5438723130,5438723131,5438723132,5438723300,5438723302,5438730132,5438730133,5438730320,5438730321,5438730322,5438730330,5438732010,5438732011,5438732012,5537071001,5537071011,5537071101,5538001101,5538001103,5538001121,5538001310,5538001311,5538001313,5538001331,5538001333,5538003111,5538012130,5538012200,5538012201,5538012203,5538012210,5538012211,5538012212,5538013000,5538013101,5538021010,5538021012,5538021030,5538021032,5538021033,5538021300,5538021302,5538021320,5538022021,5538022230,5538022321,5538022330,5538022331,5538023030,54375713222,54375713223,54375713231,54375713232,54375713233,54375713320,54375713322,54375713323,54375713332,54375713333,54375730111,54375730112,54375730113,54375730123,54375730233,54375730301,54375730303,54375732011,54375732013,54375732121,54375732123,54375732231,54375732233,54376701313,54376703101,54376703103,54376703121,54376703123,54376703211,54376703213,54376703231,54376703233,54376710101,54376710130,54376710131,54376710133,54376710313,54376710322,54376710323,54376721011,54376721013,54376721031,54376721033,54376721300,54376721301,54376721303,54376721321,54376721323,54376723101,54376723131,54376723133,54376723311,54376723313,54377701133,54377701301,54377701303,54377701321,54377701323,54377703031,54377703033,54377703101,54377703102,54377703103,54377703230,54377703231,54377703233,54377721011,54377721013,54377721031,54377721033,54377721203,54377721221,54377721223,54377723001,54377723003,54377723210,54377723211,54377723212,54377723301,54377723331,54377723333,54377733320,54377733321,54377733322,54377733330,54377733331,54384023313,54384023323,54384023331,54384023332,54384023333,54384032002,54384032032,54384032033,54384032122,54384033033,54384033120,54384033122,54384033300,54384033302,54384033320,54384033322,54384033323,54385001023,54385001031,54385001032,54385001033,54385001101,54385001102,54385001103,54385002010,54385002011,54385002013,54385002031,54385002033,54385002221,54385002223,54385011120,54385011122,54385011300,54385011302,54385011330,54385011332,54385011333,54385020001,54385020002,54385020003,54385100133,54385100222,54385100231,54385100233,54385100303,54385101011,54385101012,54385101013,54385101021,54385101022,54385101023,54385101102,54385101103,54385101112,54385101113,54385110122,54385110123,54385111202,54385111203,54385111212,54385111213,54385111302,54385111303,54385113110,54385113111,54385113112,54385113130,54385113320,54385131010,54385131012,54385131030,54385131032,54385131210,54385131212,54385131220,54385131221,54385131222,54385131230,54385132130,54385132131,54385132132,54385132300,54385132301,54385132302,54385133000,54385133002,54386110010,54386110011,54386110012,54386110030,54386110032,54386110132,54386110133,54386111020,54386111022,54386111132,54386111212,54386111213,54386111301,54386111302,54386111303,54386200202,54386200203,54386200212,54386200213,54386200302,54386200320,54386200322,54386202100,54386202102,54386202103,54386202130,54386202132,54386202310,54386202312,54386202313,54386203212,54386203213,54386203302,54386203320,54386203322,54386203323,54386212332,54386212333,54386213222,54386213223,54386221112,54386230012,54386230013,54386230021,54386230022,54386230023,54386230101,54386230102,54386230103,54386231010,54386231012,54386231030,54386231032,54386231033,54386231122,54386231123,54386320131,54386320132,54386320133,54386321001,54386321003,54386321012,54386321013,54386321120,54386321122,54386321300,54386321302,54386321320,54386321322,54386323100,54386323102,54386323322,54387022200,54387022201,54387022202,54387022210,54387022301,54387022310,54387023030,54387023031,54387023032,54387023120,54387023121,54387023130,54387032000,54387032001,54387032002,54387032010,54387032011,54387033211,54387033213,54387033231,54387033232,54387033233,54387231330,54387231331,54387231333,54387233010,54387233200,54387233201,54387301100,54387301102,54387301120,54387301122,54387301300,54387301302,54387301303,54387303230,54387303231,54387303232,54387303310,54387303311,54387303320,54387312002,54387312020,54387320130,54387320300,54387320302,54387320320,54387321000,54387321001,54387321002,54387321010,55370710000,55370710001,55370710100,55370710101,55370710103,55370711000,55370711001,55370711003,55380011230,55380011231,55380011233,55380013011,55380013120,55380013121,55380013123,55380013301,55380013303,55380031130,55380031131,55380031133,55380121310,55380121320,55380121321,55380121322,55380122130,55380123000,55380123001,55380123002,55380123010,55380130010,55380130011,55380130012,55380130020,55380130021,55380130100,55380130101,55380131000,55380131001,55380131003,55380131021,55380131030,55380131031,55380131033,55380210110,55380210112,55380210130,55380210132,55380210310,55380210312,55380210313,55380211220,55380211222,55380213030,55380213032,55380213220,55380213222,55380220200,55380220201,55380220203,55380220230,55380220231,55380220233,55380222011,55380222013,55380222031,55380222033,55380222211,55380222310,55380223200,55380223201,55380223203,55380230200,55380230201,55380230202,55380230210,55380230211,55380230212,55380230220,55380230222,55380230310,55380230311,55380231000,55380231002,55380231003,55380231020,55380232000,55380232002,55380232020,55380232022,55380232200,
105,00,ͱ/̯,496476562,131925000,498192187,133434375,2,12,37,70,171,334,553811,553821,5538000,5538002,5538100,5538101,5538103,5538201,5538320,5538411,5538313,5538311,5538310,5538203,55370712,55370713,55370730,55370731,55370733,55371711,55380010,55380012,55380030,55380032,55380033,55380132,55380133,55381020,55381021,55381023,55381200,55381202,55381220,55381222,55382001,55382003,55382200,55382202,55382220,55382222,55383011,55383212,55383230,55383221,55384101,55384200,55383222,55383220,55383123,55383121,55383120,543870232,543870233,543870322,543870323,553707011,553707013,553707031,553707102,553707103,553707111,553707112,553707113,553707321,553707323,553717130,553717131,553717133,553717311,553800132,553800310,553800312,553800313,553801222,553801223,553801231,553801232,553801233,553801302,553801303,553801312,553801313,553810220,553810221,553810223,553812010,553812012,553812030,553820211,553820212,553820213,553820230,553820231,553822012,553822030,553822032,553822210,553830101,553822212,553832112,553832130,553832132,553832310,553832103,553832102,553832311,553842200,553822232,553822230,553832230,553832231,553842020,553842021,553841311,553842022,553841310,553841301,553841300,553841031,553831221,553830311,5437772323,5437772332,5438702222,5438702223,5438702232,5438702233,5438703202,5438703203,5438703210,5438703212,5438703213,5438703302,5438703320,5438703322,5537070101,5537070301,5537070331,5537070333,5537071002,5537071003,5537071012,5537071013,5537071102,5537071103,5537072111,5537072113,5537073201,5537073203,5537171010,5537171011,5537171013,5537171031,5537171321,5537171323,5537173131,5537173133,5538001100,5538001102,5538001120,5538001122,5538001300,5538001302,5538001303,5538001332,5538003110,5538003112,5538012133,5538012202,5538012302,5538012303,5538013003,5538013011,5538013012,5538013013,5538022022,5538022200,5538022202,5538022220,5538022222,5538022223,5538022232,5538022233,5538022322,5538022323,5538022332,5538102221,5538120110,5538120112,5538120130,5538120132,5538120310,5538120312,5538120320,5538120321,5538120322,5538120330,5538122300,5538200010,5538200011,5538200013,5538200031,5538200032,5538200033,5538200210,5538200211,5538200213,5538200231,5538202031,5538202032,5538202033,5538202100,5538202101,5538202103,5538202211,5538202213,5538202321,5538202330,5538202331,5538220102,5538222112,5538301031,5538301033,5538301311,5538301313,5538301331,5538301333,5538222330,5538222333,5538321100,5538332020,5538332002,5538321333,5538321310,5538321132,5538321102,5538321013,5538321012,5538321003,5538321002,5538321312,5538321330,5538321332,5538312231,5538312233,5538410011,5538410032,5538410210,5538413131,5538413130,5538413121,5538413132,5538321000,5538222332,5538323200,5538323210,5538323201,5538323202,5538322321,5538322320,5538322322,5538420100,5538420102,5538420120,5538410013,5538410031,5538410033,5538410211,5538410300,5538410301,5538410303,5538410330,5538410321,5538410331,5538413120,5538413031,5538413030,5538413021,5538413020,5538413032,5538420231,5538420230,5538312201,5538312203,5538301310,5538303131,5538303130,5538422020,5538301301,5538202333,5538202320,5538202210,54377723213,54377723221,54377723300,54377723302,54377723303,54377723330,54377723332,54377733323,54377733332,54377733333,54387022203,54387022211,54387022212,54387022213,54387022300,54387022302,54387022303,54387022311,54387022312,54387022313,54387023033,54387023122,54387023123,54387023131,54387023132,54387023133,54387032003,54387032012,54387032013,54387033210,54387033212,54387033230,55370701030,55370701031,55370701033,55370701211,55370701213,55370701231,55370701232,55370701233,55370703031,55370703301,55370703303,55370703321,55370703323,55370710002,55370710003,55370710102,55370711002,55370721101,55370721310,55370721311,55370721313,55370721331,55370732000,55370732001,55370732003,55370732210,55370732211,55370732213,55371710121,55371710123,55371710331,55371713201,55371731010,55371731011,55371731013,55371731031,55371731033,55371731300,55371731301,55371731303,55371731321,55371733111,55371733113,55380011232,55380013010,55380013012,55380013013,55380013122,55380013300,55380013302,55380031132,55380121311,55380121312,55380121313,55380121323,55380122131,55380122132,55380122133,55380123003,55380123011,55380123012,55380123013,55380130013,55380130022,55380130023,55380130102,55380130103,55380131002,55380131020,55380131022,55380131023,55380131032,55380220202,55380220232,55380222010,55380222012,55380222030,55380222032,55380222210,55380222212,55380222213,55380222311,55380222312,55380222313,55380223202,55381022201,55381022203,55381022230,55381022231,55381022233,55381201130,55381201132,55381201310,55381201312,55381203110,55381203112,55381203130,55381203132,55381203230,55381203231,55381203320,55381221000,55381221001,55381221002,55381221020,55381221022,55381221200,55381221202,55381221222,55381221223,55381223020,55381223022,55381223200,55382000011,55382000121,55382000123,55382000301,55382000302,55382000303,55382002121,55382002331,55382020301,55382020302,55382020303,55382021021,55382021022,55382021023,55382023220,55382023221,55382023230,55382023231,55382023320,55382023321,55382201032,55382201033,55382201320,55382201322,55382203100,55382203102,55382221100,55382221102,55382221103,55382221300,55382221302,55382221320,55383010011,55383010013,55383010301,55383010303,55383013001,55382221322,55382223100,55382223102,55382223120,55382223123,55382223312,55382223122,55382232223,55382232222,55383210010,55382233223,55382233222,55382232333,55383210111,55383210113,55383210112,55383210103,55383210102,55383210013,55383210012,55383211012,55383211030,55383211032,55383211033,55383211300,55383211302,55383211303,55383211332,55383213110,55383213112,55383213130,55383213132,55383213310,55383213312,55383213313,55383302222,55383320000,55383320002,55383320210,55383320212,55383320221,55383231311,55383231310,55383231301,55383231300,55383231211,55383231210,55383231201,55383231200,55383231202,55383231220,55383232111,55383232110,55383122301,55384100303,55384100301,55384100123,55384100103,55384100101,55383122323,55383122303,55383122321,55384100121,55384102131,55384103020,55384103023,55384103230,55384103231,55384103320,55384103321,55384121313,55384121311,55384121133,55384103331,55384103330,55384130231,55384130332,55384132110,55384130331,55384131220,55384131221,55384131230,55384131233,55384131330,55384131331,55384201221,55384201222,55384203000,55384203002,55383223232,55383223230,55383223300,55383223301,55383223310,55384203020,55384202331,55384202330,55384202321,55384202320,55384202322,55384220100,55384220102,55384220120,55384220122,55384220123,55384220301,55384220220,55384220303,55384220330,55384220312,55384131231,55383223311,55383232120,55383232031,55383232032,55383232200,55383232030,55384201220,55384103021,55384130330,55383031033,55383031031,55383031013,55383013323,55383013321,55383013303,55383013301,55383013123,55383013121,55383013120,55383122001,55383031331,55383031330,55383031321,55383031211,55384220210,55384220211,55384220300,55383013003,55383013000,55383012111,55383010323,55383010321,55383012110,55383010300,55383010031,55383010010,55382023323,55382022123,55382022121,55382022311,55384130230,
106,00,ֲ⸶/ӻ,497812500,131793750,499303125,133275000,4,11,21,78,158,308,553803,553813,553814,553823,5538042,5538121,5538123,5538221,5538240,5538241,5538242,5538331,5538333,5538340,5538342,54387322,54387323,54387332,54387333,55380233,55380432,55380433,55380522,55381500,55381502,55381520,55381522,55382230,55382231,55382430,55382500,55382501,55383300,55383301,55383303,55383321,543872331,543872333,543873122,543873211,543873212,543873213,543873300,543873302,543874222,553802110,553802111,553802113,553802131,553802133,553802311,553802312,553802313,553802321,553802323,553804000,553804002,553804020,553804022,553804023,553804300,553804302,553804303,553804312,553804313,553805232,553805233,553812211,553812213,553812231,553812233,553815010,553815011,553815032,553815210,553815211,553815212,553815230,553815232,553822011,553822033,553822320,553822321,553822330,553822331,553822333,553824310,553824312,553824320,553824321,553824322,553825020,553825021,553832111,553833020,553833021,553833023,553833201,553833203,553833230,553833231,553834100,553834102,553834120,553834122,553834300,553834302,553834320,553843110,553843111,553844000,553844001,553844010,553844011,5438723303,5438723321,5438723322,5438723323,5438730333,5438731203,5438732031,5438732033,5438732102,5438732103,5438733030,5438733032,5438733033,5438742202,5438742203,5438742212,5438742230,5438742232,5538021120,5538021121,5538021123,5538021301,5538021321,5538021323,5538022333,5538023023,5538023032,5538023033,5538023101,5538023103,5538023201,5538023203,5538023221,5538023222,5538023223,5538040212,5538040320,5538040322,5538040323,5538043010,5538043012,5538043013,5538043102,5538043103,5538043112,5538052022,5538052023,5538052300,5538052302,5538052303,5538052312,5538052313,5538120111,5538120133,5538120331,5538120333,5538122101,5538122103,5538122121,5538122123,5538122301,5538122303,5538122321,5538122322,5538122323,5538150120,5538150121,5538150122,5538150300,5538150302,5538150332,5538152130,5538152131,5538152132,5538152310,5538152312,5538152330,5538152332,5538153020,5538220100,5538220101,5538220130,5538220131,5538220133,5538220311,5538220312,5538220313,5538222111,5538222113,5538222131,5538222133,5538222311,5538222313,5538223220,5538223221,5538223223,5538223230,5538223231,5538223232,5538223320,5538223321,5538223323,5538243110,5538243112,5538243130,5538243132,5538243230,5538243232,5538243300,5538243301,5538243310,5538250220,5538250221,5538250222,5538250230,5538250300,5538250301,5538250310,5538321131,5538330220,5538330221,5538330223,5538332001,5538332003,5538332211,5538332213,5538332321,5538332330,5538332331,5538332333,5538341010,5538341212,5538341230,5538341232,5538343010,5538343012,5538343030,5538343032,5538343210,5538343220,5538343222,5538431001,5538431010,5538431011,5538431013,5538431130,5538431131,5538440020,5538440021,5538440030,5538440031,5538440032,5538440120,5538440121,5538440130,5538440131,5538441000,5538441002,54387231332,54387233011,54387233012,54387233013,54387233202,54387233203,54387303233,54387303312,54387303313,54387303321,54387303322,54387303323,54387312021,54387312022,54387312023,54387312122,54387312300,54387312302,54387312320,54387312322,54387320131,54387320132,54387320133,54387320301,54387320303,54387320321,54387320322,54387320323,54387321003,54387321011,54387321012,54387321013,54387330100,54387330102,54387330120,54387330122,54387330123,54387330310,54387330312,54387330313,54387331220,54387331222,54387331223,54387331332,54387331333,54387422000,54387422002,54387422003,54387422012,54387422013,54387422102,54387422103,54387422130,54387422132,54387422310,54387422312,54387422313,54387422330,54387422331,55380210111,55380210113,55380210131,55380210133,55380210311,55380211221,55380211223,55380213031,55380213033,55380213221,55380213223,55380230203,55380230213,55380230221,55380230223,55380230312,55380230313,55380231001,55380231021,55380231022,55380231023,55380232001,55380232003,55380232021,55380232023,55380232201,55380232202,55380232203,55380400100,55380400102,55380400120,55380400122,55380400300,55380400302,55380400320,55380402102,55380402132,55380402133,55380403022,55380403023,55380403320,55380403322,55380403323,55380403332,55380412223,55380412232,55380412323,55380412332,55380430110,55380430112,55380430113,55380431013,55380431100,55380431102,55380431103,55380431132,55380520202,55380520203,55380520212,55380520213,55380520320,55380520322,55380520323,55380520332,55380523012,55380523013,55380523102,55380523103,55380523112,55380532022,55380532023,55380532200,55380532202,55380532220,55380532222,55381201131,55381201133,55381201311,55381201313,55381203111,55381203113,55381203131,55381203133,55381203232,55381203233,55381203321,55381203322,55381203323,55381221003,55381221021,55381221023,55381221201,55381221203,55381221220,55381221221,55381223021,55381223023,55381223201,55381223202,55381223203,55381501230,55381501231,55381501232,55381501300,55381501301,55381501302,55381503010,55381503012,55381503030,55381503032,55381503033,55381503302,55381503330,55381503332,55381510000,55381510002,55381521330,55381521331,55381521332,55381523312,55381523330,55381523332,55381523333,55381530020,55381530022,55382201030,55382201031,55382201321,55382201323,55382203101,55382203103,55382221101,55382221301,55382221303,55382221321,55382221323,55382223101,55382223103,55382223121,55382223310,55382223311,55382223313,55382232220,55382232221,55382232330,55382232331,55382232332,55382233220,55382233221,55382431110,55382431111,55382431112,55382431130,55382431132,55382432310,55382432312,55382432330,55382432332,55382502230,55382502231,55382502310,55382502312,55382502320,55382503020,55382503021,55382503030,55382503031,55382503110,55382503112,55382510000,55382510002,55382510020,55382510022,55382510200,55382510202,55382510220,55383210011,55383210100,55383210101,55383210110,55383211010,55383211011,55383211013,55383211031,55383211301,55383211330,55383211331,55383211333,55383213111,55383213113,55383213131,55383213133,55383213311,55383302220,55383302221,55383302223,55383320001,55383320003,55383320211,55383320213,55383320231,55383322310,55383322311,55383323200,55383323201,55383323231,55383323320,55383323321,55383410110,55383410120,55383410122,55383410300,55383410302,55383410320,55383410322,55383412100,55383412102,55383412103,55383432120,55383432122,55383432210,55383432212,55383432230,55384310001,55384310031,55384310120,55384310121,55384310123,55384310310,55384310311,55384311200,55384311201,55384311210,55384311211,55384311213,55384400220,55384400221,55384400230,55384400231,55384400233,55384400330,55384400331,55384400332,55384401220,55384401330,55384401331,55384410200,55384410201,55384410202,
107,00,/Ȭ,497460937,128671875,499457812,130134375,3,7,31,86,202,392,533873,543803,543804,5338522,5338621,5338632,5338742,5338743,5338750,5438131,53385113,53385131,53385133,53385200,53385202,53385203,53385232,53385233,53385322,53386200,53386201,53386231,53386233,53386300,53386302,53386330,53386332,53386520,53386522,53386523,53387402,53387403,53387412,53387413,53387510,53387520,53387521,53387522,54381301,54381303,54381400,533851111,533851113,533851123,533851301,533851303,533852010,533852012,533852122,533852300,533852302,533852303,533852312,533852313,533853201,533853202,533853203,533853212,533853230,533853232,533853233,533861110,533861111,533861113,533861131,533861133,533862020,533862022,533862031,533862300,533862301,533862303,533862321,533863010,533863011,533863012,533863030,533863032,533863310,533863312,533863330,533863332,533865210,533865212,533865322,533872110,533872111,533872113,533872131,533874002,533874003,533874010,533874012,533874013,533874100,533874102,533874103,533874111,533874112,533874113,533875112,533875120,533875121,533875122,533875230,533875231,533875232,533875300,533875302,543802131,543802133,543802311,543802313,543802330,543802331,543805000,543805001,543805002,543805202,543813001,543813003,543813300,543813301,543814010,543814011,543814012,543814100,5338413333,5338422222,5338422223,5338422232,5338422233,5338422322,5338511121,5338511122,5338511123,5338511211,5338511212,5338511213,5338511221,5338511222,5338511223,5338513000,5338513001,5338513003,5338513211,5338513212,5338513213,5338513230,5338513231,5338513233,5338520130,5338520132,5338520133,5338521200,5338521202,5338521232,5338523010,5338523012,5338523013,5338523102,5338530232,5338530233,5338532001,5338532002,5338532003,5338532102,5338532103,5338532132,5338532310,5338532312,5338611011,5338611121,5338611123,5338613111,5338620210,5338620211,5338620212,5338620230,5338620300,5338620301,5338620303,5338620330,5338620331,5338620333,5338622000,5338622111,5338623020,5338623021,5338623023,5338623231,5338623233,5338630130,5338630132,5338630310,5338630312,5338630330,5338630332,5338631232,5338631233,5338631322,5338633130,5338633132,5338633310,5338633312,5338633330,5338633332,5338633333,5338641333,5338643111,5338643113,5338643131,5338643133,5338643311,5338643313,5338643331,5338643332,5338643333,5338650332,5338652110,5338652112,5338652130,5338652132,5338653200,5338653202,5338653203,5338653232,5338653233,5338653322,5338721121,5338721123,5338721301,5338721303,5338721330,5338721331,5338721333,5338723111,5338723333,5338740000,5338740002,5338740003,5338740011,5338740012,5338740013,5338740110,5338740112,5338740113,5338741010,5338741012,5338741013,5338741101,5338741102,5338741103,5338751100,5338751102,5338751103,5338751230,5338751231,5338751232,5338751300,5338751302,5338751320,5338752330,5338752332,5338753010,5338753012,5338753030,5338753032,5338753200,5438021111,5438021113,5438021131,5438021132,5438021133,5438023101,5438023103,5438023121,5438023122,5438023123,5438023211,5438023213,5438023231,5438023320,5438023331,5438023333,5438050030,5438050100,5438050101,5438050110,5438050200,5438050202,5438050220,5438050222,5438052000,5438052002,5438052003,5438052200,5438052201,5438052202,5438052220,5438130000,5438130001,5438130003,5438130021,5438130210,5438130211,5438130213,5438132110,5438132111,5438133021,5438133030,5438133031,5438133100,5438133101,5438133102,5438133120,5438133122,5438140130,5438140131,5438140132,5438140200,5438140202,5438140220,5438141010,5438141011,5438141100,5438141101,5438141110,5438141111,53384133321,53384133322,53384133323,53384223202,53384223230,53384223232,53385103331,53385110333,53385111013,53385111033,53385111201,53385111203,53385112023,53385112031,53385112032,53385112033,53385112201,53385112202,53385112203,53385130020,53385130021,53385130023,53385130210,53385130211,53385130213,53385130231,53385132101,53385132102,53385132103,53385132321,53385201102,53385201120,53385201122,53385201123,53385201310,53385201312,53385201313,53385210202,53385210220,53385210222,53385210223,53385212012,53385212030,53385212032,53385212033,53385212300,53385212302,53385212303,53385212332,53385230110,53385230112,53385230113,53385231030,53385231032,53385231033,53385231122,53385231123,53385231131,53385231132,53385231133,53385302233,53385320002,53385320003,53385321002,53385321003,53385321012,53385321300,53385321302,53385321303,53385323112,53385323130,53385323132,53386110131,53386110133,53386111200,53386111201,53386111203,53386111221,53386111223,53386113010,53386113011,53386113013,53386113031,53386113033,53386113211,53386113213,53386113231,53386131100,53386131101,53386131103,53386131121,53386131130,53386131131,53386131133,53386202130,53386202131,53386202132,53386202310,53386202320,53386202321,53386202322,53386203211,53386203320,53386203321,53386203323,53386220010,53386220011,53386220012,53386220020,53386220021,53386220022,53386220100,53386221101,53386221130,53386221131,53386221133,53386221311,53386230221,53386232010,53386232011,53386232013,53386232300,53386232301,53386232303,53386232321,53386232323,53386301310,53386301311,53386301312,53386301330,53386301332,53386303110,53386303112,53386303130,53386303132,53386303310,53386303312,53386303330,53386303332,53386303333,53386312222,53386312223,53386312232,53386312233,53386313230,53386313232,53386313233,53386331102,53386331120,53386331122,53386333112,53386333130,53386333132,53386333310,53386333312,53386422220,53386422222,53386423222,53386423223,53386423232,53386423233,53386423322,53386431101,53386431103,53386431121,53386431123,53386431301,53386431303,53386431321,53386431323,53386432231,53386432232,53386432233,53386432320,53386432322,53386433101,53386433213,53386433231,53386433232,53386433233,53386433302,53386433303,53386502220,53386502222,53386502223,53386502231,53386502232,53386502233,53386502322,53386502323,53386502332,53386502333,53386503232,53386503233,53386521112,53386521130,53386521132,53386521310,53386521312,53386521330,53386521332,53386521333,53386530222,53386532012,53386532122,53386532300,53386532302,53386532303,53386532312,53386532313,53386533201,53386533202,53386533203,53387210110,53387210111,53387210113,53387210131,53387211200,53387211201,53387211203,53387211221,53387211223,53387213001,53387213003,53387213211,53387213320,53387213321,53387213323,53387231101,53387231103,53387231130,53387231131,53387231133,53387231311,53387231313,53387231331,53387231333,53387233133,53387233311,53387233312,53387233313,53387233323,53387400012,53387400102,53387400103,53387401112,53387401113,53387410110,53387410112,53387410113,53387411001,53387411002,53387411003,53387511012,53387511013,53387511120,53387511122,53387511300,53387511302,53387511320,53387512330,53387512331,53387512332,53387513010,53387513012,53387513030,53387513220,53387523310,53387523312,53387523330,53387530110,53387532010,53387532011,53387532012,53387532100,54380211101,54380211103,54380211121,54380211122,54380211123,54380211300,54380211301,54380211303,54380213033,54380213211,54380213213,54380213231,54380213233,54380230333,54380231003,54380231021,54380231023,54380231201,54380231203,54380232123,54380232301,54380232303,54380233210,54380233211,54380233300,54380233301,54380233303,54380233321,54380500310,54380500311,54380500320,54380501020,54380501021,54380501022,54380502230,54380502232,54380520010,54380520012,54380520013,54380520102,54380520120,54380520122,54380520300,54380520302,54380520320,54380520322,54380522030,54380522031,54380522032,54380522220,54380522221,54380522222,54381211110,54381211111,54381211113,54381300020,54381300021,54381300023,54381300201,54381300231,54381300233,54381302011,54381302121,54381302311,54381302313,54381302331,54381302333,54381320110,54381320111,54381321000,54381321010,54381321011,54381321130,54381321131,54381330201,54381330203,54381330321,54381330330,54381330331,54381331030,54381331100,54381331101,54381331102,54381331110,54381331111,54381333001,54381401330,54381402010,54381402011,54381402012,54381402030,54381402100,54381402101,54381402220,54381402222,54381403011,54381403100,54381410120,54381410121,54381410122,54381410130,54381410131,54381410200,54381410201,54381410210,54381411020,54381411021,54381411030,54381411031,54381411120,54381411121,54381411130,54381411131,54381420000,54381500000,54381500002,54381500020,
108,00,ˬ,496771875,128793750,498150000,130265625,1,12,32,74,136,331,543801,5338711,5338713,5338720,5338722,5438001,5438003,5438020,5438022,5438101,5438111,5438110,5438113,53386112,53386130,53386132,53386133,53386222,53386223,53387030,53387032,53387033,53387103,53387121,53387122,53387123,53387212,53387230,53387232,54380003,54380021,54380023,54380210,54380212,54381001,54381030,54381031,54381200,54381201,54381202,54381220,54381222,54381121,54381120,54381123,533851320,533851322,533861100,533861102,533861103,533861231,533861233,533861310,533861312,533861313,533862202,533862203,533862210,533862212,533862322,533870033,533870122,533870211,533870213,533870233,533870312,533870313,533871011,533871013,533871201,533871202,533871203,533872100,533872102,533872103,533872310,533872312,533872330,533872332,543800002,543800003,543800011,543800012,543800013,543800020,543800021,543800023,543800201,543800203,543800221,543802110,543802112,543802300,543802301,543802302,543802320,543810030,543810031,543810033,543810211,543810213,543810231,543810320,543810321,543810330,543810331,543811220,543812030,543812032,543811221,543811223,543821010,543821011,543821100,543821110,543821111,543822000,543822001,543821101,5338510331,5338512111,5338512112,5338512113,5338512131,5338512133,5338512311,5338512313,5338512331,5338512333,5338513020,5338513022,5338610111,5338610113,5338610331,5338611010,5338611012,5338611300,5338611302,5338611320,5338611322,5338612111,5338612113,5338612131,5338612132,5338612133,5338620233,5338620302,5338620320,5338620322,5338620323,5338622003,5338622011,5338622012,5338622013,5338622112,5338622130,5338622132,5338622133,5338623200,5338623202,5338623203,5338700313,5338700323,5338701202,5338702311,5338702313,5338702323,5338703102,5338703103,5338710103,5338710121,5338710122,5338710123,5338710211,5338710213,5338710232,5338710233,5338712001,5338712003,5338721010,5338721012,5338721302,5338721320,5338721322,5338721323,5338723112,5338723130,5338723132,5338723310,5338723311,5338723312,5338723330,5437071131,5438000002,5438000012,5438000101,5438000103,5438000220,5438000221,5438000223,5438002001,5438002003,5438002230,5438002231,5438021300,5438021301,5438021302,5438021320,5438021322,5438023030,5438023031,5438023032,5438023210,5438023220,5438023221,5438023222,5438100321,5438100323,5438102101,5438102103,5438102330,5438102331,5438102333,5438103220,5438103221,5438103321,5438103330,5438103331,5438112220,5438112221,5438121000,5438121002,5438121003,5438121020,5438121022,5438122100,5438122102,5438122120,5438210011,5438112223,5438210010,5438210013,5438210120,5438210121,5438210130,5438211020,5438210131,5438211021,5438211030,5438211031,5438211120,5438211130,5438211121,5438211131,5438220020,53385103133,53385103301,53385103303,53385103321,53385103323,53385103330,53385103332,53385103333,53385112020,53385112021,53385112022,53385112030,53385112200,53385121101,53385121102,53385121103,53385121301,53385121303,53385121321,53385121323,53385123101,53385123103,53385123121,53385123123,53385123301,53385123323,53385130022,53385130212,53385130230,53385130232,53385130233,53385132100,53385132320,53385132322,53385132323,53386101101,53386101103,53386101121,53386101123,53386101310,53386101311,53386101313,53386101331,53386101333,53386103123,53386103131,53386103132,53386103133,53386103301,53386103331,53386103332,53386103333,53386110130,53386110132,53386111202,53386111220,53386111222,53386113012,53386113030,53386113032,53386113210,53386113212,53386113230,53386113232,53386113233,53386121301,53386121303,53386123013,53386123031,53386123033,53386123231,53386123233,53386131102,53386131120,53386131122,53386131123,53386131132,53386202133,53386202311,53386202312,53386202313,53386202323,53386203210,53386203212,53386203213,53386203322,53386220013,53386220023,53386220101,53386220102,53386220103,53386221100,53386221102,53386221103,53386221132,53386221310,53386221312,53386221313,53386230220,53386230222,53386230223,53386232012,53386232302,53386232320,53386232322,53387003112,53387003113,53387003123,53387003211,53387003212,53387003213,53387003221,53387003223,53387012002,53387012032,53387012033,53387012300,53387012302,53387012320,53387012322,53387012323,53387012332,53387012333,53387021001,53387021010,53387021011,53387021013,53387023100,53387023101,53387023103,53387023121,53387023123,53387023223,53387031002,53387031122,53387031123,53387031133,53387100331,53387100332,53387100333,53387101011,53387101013,53387101023,53387101201,53387101202,53387101203,53387102232,53387102233,53387102303,53387102311,53387102312,53387102313,53387120003,53387120021,53387120022,53387120023,53387210112,53387210130,53387210132,53387210133,53387211202,53387211220,53387211222,53387213000,53387213002,53387213210,53387213212,53387213213,53387213322,53387231100,53387231102,53387231132,53387231310,53387231312,53387231330,53387231332,53387233130,53387233131,53387233132,53387233310,53387233320,53387233321,53387233322,54370711132,54370711133,54370711330,54370711331,54370711333,54370713111,54370713113,54370713131,54370713133,54380000031,54380000032,54380000033,54380000130,54380000132,54380000133,54380001001,54380001003,54380001021,54380001022,54380001023,54380002220,54380002221,54380002223,54380020001,54380020003,54380020021,54380020210,54380020211,54380020213,54380020231,54380022013,54380022330,54380022331,54380022333,54380211100,54380211102,54380211120,54380211302,54380213030,54380213031,54380213032,54380213210,54380213212,54380213230,54380213232,54380230330,54380230331,54380230332,54380231000,54380231001,54380231002,54380231020,54380231022,54380231200,54380231202,54380232120,54380232121,54380232122,54380232230,54380232231,54380232300,54380232302,54380232320,54381000111,54381000113,54381000131,54381000133,54381000311,54381000313,54381000331,54381003200,54381003201,54381003203,54381003221,54381003223,54381021001,54381021003,54381021021,54381021211,54381021213,54381021231,54381021233,54381023011,54381023013,54381023321,54381023323,54381032220,54381032222,54381032300,54381032311,54381033200,54381033201,54381033203,54381122220,54381122221,54381203100,54381203101,54381203102,54381203120,54381203122,54381203300,54381203302,54381203320,54381203322,54381210012,54381210210,54381210212,54381210230,54381210232,54381212001,54381212010,54381221010,54381221011,54381221012,54381221030,54381221032,54381221220,54381221221,54381221222,54381223000,54381223002,54381223020,54381223022,54381223200,54381223202,54381223220,54381223222,54382201000,54382201002,54382201020,54382100011,54382100121,54382100311,54382101221,54382101230,54382101231,54382101320,54382101321,54382101330,54382101331,54382110220,54382200210,54382200211,54382200300,54382200301,54382110221,54382110230,54382110231,
109,00,,495801562,129675000,497376562,131362500,3,13,26,83,186,371,543717,543727,543820,5437161,5437163,5437261,5437263,5437361,5437370,5437371,5437373,5437471,5437473,5438300,5438302,5438400,54370631,54370632,54370633,54370720,54370722,54370723,54370732,54370733,54371601,54371603,54371621,54373602,54373620,54373721,54373723,54374703,54375710,54375711,54375712,54381002,54381020,54381022,54384020,54384021,54384022,54382102,543706231,543706232,543706233,543706302,543706303,543707023,543707032,543707210,543707212,543707213,543707303,543707312,543707313,543716001,543716002,543716003,543716021,543716023,543716201,543716203,543716230,543716231,543716233,543726011,543726033,543726211,543726213,543726231,543726233,543735133,543735311,543735313,543735331,543736011,543736013,543736031,543736032,543736033,543736210,543736211,543736212,543736220,543736300,543736301,543736303,543736310,543736311,543736312,543737200,543737201,543737203,543747011,543747012,543747013,543747210,543747211,543747213,543747231,543747233,543757011,543757013,543757031,543757130,543757131,543757300,543800222,543810000,543810002,543810232,543830100,543830111,543831000,543840230,543840231,543840232,543850000,543850001,543821002,543821220,543821222,543821200,543821201,543821202,5437061322,5437061323,5437061332,5437062131,5437062133,5437062231,5437062232,5437062233,5437062302,5437063011,5437063012,5437063013,5437070212,5437070213,5437070223,5437070332,5437072110,5437072112,5437072113,5437073002,5437073012,5437073013,5437073020,5437073022,5437073023,5437073101,5437073102,5437073103,5437073110,5437073112,5437073113,5437160001,5437160002,5437160003,5437160201,5437160203,5437160221,5437160223,5437162001,5437162003,5437162211,5437162213,5437162320,5437162321,5437162323,5437260101,5437260103,5437260121,5437260131,5437260311,5437260312,5437260313,5437260321,5437260323,5437262101,5437262103,5437262123,5437262301,5437262303,5437262321,5437262323,5437351311,5437351313,5437351321,5437351323,5437353101,5437353103,5437353121,5437353123,5437353301,5437360300,5437360302,5437360303,5437362130,5437362131,5437362210,5437362211,5437362212,5437363020,5437363021,5437363130,5437363131,5437372020,5437372021,5437372211,5437470033,5437470101,5437470103,5437470211,5437470212,5437470213,5437472120,5437472121,5437472123,5437472301,5437472303,5437570101,5437570121,5437570122,5437570123,5437570331,5437571320,5437571321,5437571330,5437571331,5437572113,5437573010,5437573020,5437573021,5437573022,5437573200,5437573203,5438002020,5438002022,5438002200,5438002202,5438002203,5438002232,5438100010,5438100012,5438100030,5438100032,5438102120,5438102122,5438102300,5438102302,5438102303,5438103223,5438103232,5438103233,5438103322,5438103323,5438103332,5438103333,5438301010,5438301011,5438301020,5438301021,5438301022,5438301100,5438301101,5438301103,5438301130,5438301200,5438301202,5438301220,5438301222,5438303000,5438303002,5438303003,5438303020,5438303021,5438303022,5438303200,5438303202,5438401020,5438401022,5438401200,5438401202,5438401203,5438401220,5438401221,5438401222,5438402330,5438403000,5438403002,5438500020,5438500021,5438500022,5438500030,5438500100,5438500101,5438500200,5438500202,5438500220,5438210000,5438210002,5438210003,5438210030,5438210032,5438210033,5438212230,5438212210,5438212212,5438212030,5438212032,54370612333,54370613203,54370613212,54370613213,54370613302,54370613303,54370613330,54370613332,54370613333,54370621132,54370621133,54370621301,54370621323,54370622132,54370622133,54370622223,54370622231,54370622232,54370622233,54370622302,54370622303,54370623032,54370630022,54370630023,54370630032,54370630033,54370630102,54370630103,54370702033,54370702101,54370702102,54370702103,54370702110,54370702112,54370702113,54370702211,54370702212,54370702213,54370702222,54370702223,54370703020,54370703022,54370703023,54370703032,54370703302,54370703303,54370703330,54370703332,54370713223,54370713232,54370713233,54370713322,54370721110,54370721112,54370721113,54370730033,54370730113,54370730211,54370730213,54370731001,54370731002,54370731003,54370731112,54370731113,54371511133,54371511311,54371600001,54371600002,54371600003,54371602001,54371602003,54371602023,54371602201,54371602203,54371602221,54371602223,54371620001,54371620003,54371620211,54371620213,54371622100,54371622101,54371622103,54371622121,54371622123,54371622310,54371622311,54371622313,54371623221,54371623223,54372601001,54372601021,54372601023,54372601201,54372601300,54372601301,54372601303,54372601331,54372601332,54372601333,54372603032,54372603033,54372603101,54372603103,54372621211,54372621213,54372621223,54372623001,54372623003,54373513122,54373513123,54373513221,54373513223,54373531001,54373531003,54373531021,54373531023,54373531201,54373531203,54373531221,54373533031,54373533033,54373533211,54373533300,54373533310,54373533311,54373601011,54373601013,54373603012,54373603013,54373621320,54373621321,54373621330,54373622130,54373622131,54373622132,54373622200,54373622201,54373622210,54373622211,54373622300,54373623000,54373630221,54373630230,54373630231,54373630233,54373631320,54373631321,54373631330,54373631331,54373632110,54373632111,54373633000,54373633001,54373720220,54373722101,54373722103,54373722131,54373722132,54373722133,54373722310,54373722311,54373722313,54373722331,54374700313,54374700323,54374701000,54374701001,54374701003,54374701021,54374702101,54374702102,54374702103,54374702301,54374702310,54374702311,54374720133,54374720311,54374720313,54374720331,54374721220,54374721221,54374721223,54374723001,54374723003,54374723021,54374723211,54374723213,54374723231,54374723233,54375701031,54375701032,54375701033,54375701201,54375701202,54375701203,54375703000,54375703001,54375703010,54375703011,54375703013,54375703331,54375703333,54375713220,54375713221,54375713230,54375713321,54375713330,54375713331,54375721111,54375721113,54375721121,54375721123,54375721310,54375721311,54375721313,54375721331,54375730110,54375730120,54375730121,54375730122,54375730230,54375730231,54375730232,54375730300,54375730302,54375732010,54375732012,54375732020,54375732021,54375732120,54380020020,54380020022,54380020023,54380020212,54380020230,54380020232,54380020233,54380022010,54380022011,54380022012,54380022332,54381000110,54381000112,54381000130,54381000132,54381000310,54381000312,54381000330,54381000332,54381000333,54381003202,54381003220,54381003222,54381021000,54381021002,54381021020,54381021022,54381021023,54381021210,54381021212,54381021230,54381021232,54381023010,54381023012,54381023320,54381023322,54381032221,54381032223,54381032301,54381032302,54381032303,54381032310,54381032312,54381032313,54381033202,54381122222,54381122223,54383010120,54383010121,54383010122,54383010130,54383010131,54383010230,54383010232,54383011020,54383011021,54383011023,54383011210,54383011211,54383011213,54383011310,54383011311,54383012010,54383012012,54383012030,54383012230,54383012232,54383030010,54383030012,54383030230,54383030231,54383030232,54383030302,54383032200,54383032201,54383032202,54383032220,54383032222,54384010000,54384010002,54384010020,54384010022,54384012010,54384012012,54384012013,54384012230,54384012232,54384023310,54384023311,54384023312,54384023320,54384023321,54384023322,54384023330,54384030010,54384030200,54384030201,54384030202,54384030220,54385001020,54385001021,54385001022,54385001030,54385001100,54385002012,54385002030,54385002032,54385002220,54385002222,54385020000,54382100010,54382100012,54382100013,54382100120,54382100122,54382100123,54382100310,54382100312,54382100313,54382101220,54382101222,54382103000,54382103002,54382103020,54382103022,54382122110,54382122112,54383100120,54382120330,54382120332,54382120310,54382120311,54382120312,54383100100,54383100102,54383100210,54382122320,54382122322,54383100200,54383100201,
110,00,/,495182812,129618750,496110937,130912500,1,4,32,31,105,233,543725,5437052,5437150,5437152,5437153,54370502,54370503,54370512,54370530,54370532,54371411,54371412,54371413,54371431,54371433,54371510,54371512,54371513,54372411,54372413,54372431,54372600,54372602,54372620,54372622,54373500,54373501,54373503,54373510,54373511,54373512,54373521,54373523,54373530,54373532,54373600,54374510,543704131,543704133,543704311,543704333,543705012,543705013,543705102,543705132,543705310,543705312,543705330,543705332,543705333,543714101,543714102,543714103,543714300,543714301,543714303,543714321,543715110,543715112,543716220,543716222,543724123,543724301,543724331,543724333,543735021,543735130,543736012,5437041132,5437041133,5437041301,5437041303,5437041321,5437041323,5437043101,5437043131,5437043133,5437043233,5437043311,5437043313,5437043321,5437043322,5437043323,5437050033,5437050103,5437050112,5437051012,5437051030,5437051032,5437051033,5437051300,5437051302,5437053110,5437053112,5437053130,5437053132,5437053310,5437053312,5437140133,5437140311,5437140313,5437141003,5437142113,5437143020,5437143021,5437143023,5437143201,5437143231,5437151110,5437151111,5437151112,5437151130,5437151132,5437151133,5437162002,5437162020,5437162022,5437162023,5437162230,5437162232,5437162233,5437241211,5437241212,5437241213,5437243031,5437243300,5437243301,5437243303,5437243321,5437260122,5437260123,5437260132,5437260300,5437260301,5437260302,5437260320,5437260322,5437262100,5437262102,5437262120,5437262302,5437262320,5437262322,5437341110,5437341111,5437341113,5437350201,5437350203,5437350230,5437350231,5437350233,5437351310,5437351320,5437352011,5437352031,5437352033,5437352231,5437352233,5437353300,5437353302,5437353320,5437353322,5437353323,5437360100,5437360102,5437360103,5437450011,5437451100,5437451101,5437451102,5437451120,5437451201,5437451210,54370411303,54370413001,54370413003,54370413023,54370413201,54370413203,54370413221,54370413223,54370431001,54370431031,54370431033,54370431211,54370431300,54370431301,54370431303,54370431321,54370431323,54370432233,54370432313,54370432322,54370432323,54370433023,54370433032,54370433033,54370433101,54370433103,54370433121,54370433123,54370433201,54370433202,54370433203,54370500220,54370500222,54370500223,54370500321,54370500322,54370500323,54370501022,54370501023,54370501132,54370510031,54370510032,54370510033,54370510132,54370510310,54370510312,54370510313,54370511222,54370513032,54370513320,54370513322,54370533130,54370533132,54370533133,54370622202,54370622220,54370622221,54370622222,54371403101,54371403103,54371403121,54371403123,54371403310,54371403311,54371403313,54371403331,54371403333,54371410011,54371410012,54371410013,54371410023,54371421111,54371421113,54371421310,54371421311,54371421313,54371421331,54371430220,54371430221,54371430223,54371432030,54371432031,54371432033,54371432300,54371432301,54371432331,54371511130,54371511131,54371511132,54371511310,54371511312,54371511313,54371600000,54371602000,54371602002,54371602020,54371602021,54371602022,54371602200,54371602202,54371602220,54371602222,54371620000,54371620002,54371620210,54371620212,54371622102,54371622120,54371622122,54371622312,54371623220,54371623222,54372410131,54372410133,54372410311,54372410313,54372410331,54372412103,54372412211,54372412213,54372412231,54372412233,54372430011,54372430013,54372430031,54372430033,54372430303,54372430321,54372430330,54372430331,54372430333,54372432111,54372433021,54372433023,54372433201,54372433203,54372433231,54372433233,54372601000,54372601002,54372601003,54372601020,54372601022,54372601200,54372601202,54372601203,54372601302,54372601330,54372603030,54372603031,54372603100,54372603102,54372621210,54372621212,54372621220,54372621221,54372621222,54372623000,54372623002,54373411011,54373411121,54373411123,54373411301,54373411310,54373411311,54373411313,54373411331,54373502001,54373502003,54373502211,54373513120,54373513121,54373513220,54373513222,54373520130,54373520131,54373520133,54373522110,54373522111,54373522113,54373522131,54373522133,54373531000,54373531002,54373531020,54373531022,54373531200,54373531202,54373531220,54373531222,54373531223,54373533030,54373533032,54373533210,54373533212,54373533213,54373601010,54373601012,54373603010,54373603011,54374500101,54374500103,54374500121,54374500130,54374501000,54374501001,54374501002,54374501010,54374501011,54374501100,54374501101,54374501110,54374501111,54374501113,54374501131,54374501133,54374501311,54374511030,54374511031,54374511032,54374511210,54374511220,54374511221,54374512001,54374512003,54374512030,54374512031,54374512033,54374512110,54374512112,54374512120,54374512121,54374512122,
111,00,/̥ץ,495309375,130706250,496926562,132890625,3,11,50,102,206,456,543746,543756,543766,5437452,5437453,5437551,5437553,5437761,5437763,5537061,5537063,5537170,5537172,5537271,54374502,54374503,54374513,54374722,54375501,54375503,54375521,54375700,54375702,54375720,54375722,54375723,54376511,54376513,54376531,54376700,54376702,54376720,54376722,54377601,54377602,54377603,54377621,54377623,54377700,54377702,54377720,54377722,55370601,55370603,55370621,55370623,55370700,55370702,55370720,55370722,55370723,55371610,55371611,55371613,55371631,55371712,55371730,55371732,55372700,55372701,55372703,55372721,55372730,55372731,543736231,543736232,543736233,543736320,543736322,543736323,543736331,543736332,543736333,543737220,543737222,543744132,543744133,543744310,543744311,543744313,543744331,543744333,543745003,543745012,543745111,543745113,543745122,543745123,543747000,543747001,543747002,543747020,543747022,543747200,543747202,543755001,543755003,543755230,543755231,543755233,543757032,543757210,543757212,543765100,543765101,543765330,543765331,543765333,543767010,543767011,543767012,543767030,543767100,543767212,543767230,543767232,543776001,543776003,543776201,543776203,543776221,543776223,543777010,543777012,553706001,553706003,553706021,553706022,553706023,553706201,553706203,553706221,553706223,553707032,553707210,553707212,553716001,553716010,553716011,553716013,553716120,553716121,553716123,553716301,553716331,553716333,553717100,553717102,553717312,553717330,553717332,553717333,553727021,553727023,553727201,553727203,553727230,553727231,553820002,553820020,553820022,553820200,553820201,553820202,543765301,543765303,5437353332,5437353333,5437362222,5437362223,5437362231,5437362232,5437362233,5437362301,5437362302,5437362303,5437363210,5437363212,5437363213,5437363301,5437363302,5437363303,5437372023,5437372212,5437372230,5437372232,5437441233,5437441313,5437443011,5437443013,5437443120,5437443121,5437443123,5437450021,5437450022,5437450023,5437450102,5437450103,5437450112,5437450130,5437450132,5437450133,5437451123,5437451202,5437451213,5437470030,5437470232,5437470233,5437472010,5437472011,5437472012,5437472030,5437472032,5437472320,5437472322,5437550000,5437550001,5437550231,5437570100,5437570102,5437570302,5437570303,5437570330,5437570332,5437572110,5437572130,5437572132,5437573220,5437573221,5437573222,5437650110,5437650111,5437650113,5437651211,5437651213,5437653201,5437653210,5437653211,5437653213,5437653320,5437653321,5437653323,5437670130,5437670132,5437670320,5437670322,5437671012,5437671021,5437671030,5437672100,5437672102,5437672312,5437672330,5437672332,5437672333,5437760000,5437760001,5437760003,5437762001,5437762003,5437762021,5437762023,5437762201,5437762203,5437762221,5437770110,5437770111,5437770112,5437770300,5437770301,5437770302,5437770320,5437770322,5437772100,5437772102,5537060003,5537060021,5537060023,5537060201,5537060203,5537062000,5537062001,5537062003,5537062020,5537062021,5537062023,5537062201,5537062203,5537062221,5537062223,5537070100,5537070102,5537070120,5537070122,5537070300,5537070302,5537072112,5537072130,5537072132,5537073202,5537073220,5537073222,5537073223,5537160001,5537160003,5537160031,5537160120,5537160121,5537160310,5537160311,5537160313,5537161220,5537161221,5537163300,5537163301,5537163303,5537163321,5537171030,5537171032,5537171322,5537173100,5537173102,5537173310,5537173312,5537173313,5537261111,5537261113,5537261131,5537270201,5537270203,5537272001,5537272002,5537272003,5537272020,5537272021,5537272023,5537272201,5537272202,5537272203,5537272210,5537272211,5537272321,5537272330,5537273200,5537273201,5537273202,5537273301,5537273310,5537273311,5538102222,5538200000,5538200002,5538200003,5538200230,5538200232,5437653021,5437653023,5437653001,5437653003,5437651222,5437651223,5437651231,5437651232,5437651233,5437760021,5437760022,5437760023,5437550210,5437550211,5437550213,5437651031,5437651033,54373533301,54373533302,54373533303,54373533312,54373533313,54373621322,54373621323,54373621331,54373621332,54373621333,54373622133,54373622202,54373622203,54373622212,54373622213,54373622301,54373622302,54373622303,54373623001,54373623002,54373623003,54373630220,54373630222,54373630223,54373630232,54373631322,54373631323,54373631332,54373631333,54373632112,54373632113,54373633002,54373633003,54373720221,54373720222,54373720223,54373722100,54373722102,54373722130,54373722312,54373722330,54373722332,54373722333,54374412311,54374412312,54374412313,54374413033,54374413111,54374413113,54374413122,54374413123,54374430310,54374430311,54374431221,54374433010,54374433011,54374433013,54374433031,54374433033,54374433211,54374500031,54374500032,54374500033,54374500102,54374500120,54374500122,54374500123,54374500131,54374500132,54374500133,54374500201,54374500203,54374501003,54374501012,54374501013,54374501102,54374501103,54374501112,54374501130,54374501132,54374501310,54374501312,54374501313,54374511033,54374511211,54374511212,54374511213,54374511222,54374511223,54374512000,54374512002,54374512032,54374512111,54374512113,54374512123,54374700310,54374700311,54374700312,54374700320,54374700321,54374700322,54374701002,54374701020,54374701022,54374701023,54374702100,54374702300,54374702302,54374702303,54374702312,54374702313,54374720130,54374720131,54374720132,54374720310,54374720312,54374720330,54374720332,54374720333,54374721222,54374723000,54374723002,54374723020,54374723022,54374723023,54374723210,54374723212,54374723230,54374723232,54375411111,54375500030,54375500031,54375500033,54375502301,54375502331,54375520331,54375520333,54375522111,54375522113,54375522131,54375523201,54375523210,54375523211,54375523213,54375523231,54375523233,54375701030,54375701200,54375703002,54375703003,54375703012,54375703330,54375703332,54375721110,54375721112,54375721120,54375721122,54375721312,54375721330,54375721332,54375721333,54375732022,54375732023,54375732122,54375732230,54375732232,54376501011,54376501013,54376501120,54376501121,54376510211,54376512121,54376532121,54376532311,54376533221,54376701310,54376701311,54376701312,54376703100,54376703102,54376703120,54376703122,54376703210,54376703212,54376703230,54376703232,54376710100,54376710102,54376710103,54376710132,54376710310,54376710311,54376710312,54376710320,54376710321,54376721010,54376721012,54376721030,54376721032,54376721302,54376721320,54376721322,54376723100,54376723102,54376723103,54376723130,54376723132,54376723310,54376723312,54377511011,54377511100,54377511101,54377511110,54377511111,54377511333,54377513111,54377513113,54377513131,54377513133,54377513311,54377513313,54377513331,54377513333,54377600021,54377600023,54377620001,54377620003,54377620021,54377620023,54377620201,54377620203,54377622021,54377622023,54377622231,54377622233,54377701130,54377701131,54377701132,54377701300,54377701302,54377701320,54377701322,54377703030,54377703032,54377703100,54377703232,54377721010,54377721012,54377721030,54377721032,54377721200,54377721201,54377721202,54377721220,54377721222,54377723000,54377723002,54377723220,54377723222,54377723223,55370600011,55370600012,55370600013,55370600221,55370600223,55370602001,55370602022,55370602023,55370620021,55370620022,55370620023,55370620220,55370620221,55370620223,55370622001,55370622203,55370622221,55370622223,55370701032,55370701210,55370701212,55370701230,55370703030,55370703032,55370703033,55370703300,55370703302,55370703320,55370703322,55370721100,55370721102,55370721103,55370721312,55370721330,55370721332,55370721333,55370732002,55370732212,55371600001,55371600301,55371600331,55371601220,55371601221,55371601230,55371601231,55371601233,55371603121,55371603123,55371603310,55371603311,55371603313,55371612221,55371612230,55371612231,55371612233,55371630011,55371630310,55371630311,55371630313,55371630331,55371630333,55371632111,55371633020,55371633021,55371633023,55371633201,55371633230,55371633231,55371633233,55371710120,55371710122,55371710330,55371710332,55371710333,55371713200,55371713202,55371713203,55371731012,55371731030,55371731032,55371731302,55371731320,55371731322,55371731323,55371733110,55371733112,55372611100,55372611101,55372611103,55372611121,55372611123,55372611301,55372611330,55372611331,55372611333,55372631311,55372631313,55372631331,55372633133,55372633311,55372633313,55372702000,55372702001,55372702003,55372702210,55372702211,55372702213,55372702231,55372702232,55372702233,55372720001,55372720002,55372720003,55372720220,55372720221,55372720223,55372722001,55372722003,55372722120,55372722121,55372722130,55372722131,55372722133,55372722200,55372723201,55372723203,55372723231,55372723310,55372723311,55372723320,55372732030,55372732031,55372732032,55372732100,55372732200,55372732201,55372732210,55372733001,55372733003,55372733021,55372733030,55372733031,55372733120,55372733121,55372733130,55381022200,55381022202,55381022232,55382000010,55382000012,55382000013,55382000120,55382000122,55382000300,55382002120,55382002122,55382002123,55382002330,55382002332,55382002333,55382020300,55382021020,55382022000,55382022001,55382022010,55382022011,54376530221,54376530223,54376530201,54376530203,54376530021,54376530023,54376530000,54376530001,54376530003,54376512202,54376512203,54376512212,54376512213,54376512301,54376512302,54376512303,54377600201,54377600202,54377600203,54375502120,54375502121,54375502123,54376510321,54376510323,54376510300,54376510301,54376510303,54376512101,54376512102,54376512103,
112,00,/ŷε,495168750,126693750,497643750,129806250,17,21,76,156,323,670,523775,523776,533706,533707,533716,533717,533726,533727,533737,533747,533757,533767,533820,533830,533840,533850,533860,5237772,5337050,5337051,5337053,5337150,5337151,5337153,5337251,5337361,5337363,5337561,5337770,5337771,5337773,5338002,5338003,5338100,5338102,5338103,5338310,5338312,52376431,52376432,52376433,52376522,52376523,52376532,52376533,52376621,52376622,52376623,52376632,52376633,52377410,52377411,52377413,52377431,52377702,52377703,52377730,52377732,52377733,53370520,53370521,53370523,53371521,53371523,53372501,53372531,53372533,53373600,53373601,53373603,53374610,53374611,53374613,53374631,53374632,53374633,53375631,53375633,53377720,53377721,53377723,53380000,53380002,53380003,53380012,53381010,53381012,53381120,53384100,53384101,53384102,53384120,53384122,53384123,53385100,53385101,53385102,53385120,53385122,53386100,53386102,53386120,53386122,53387000,53387001,53387002,53387010,53387011,53387013,53387020,53387022,54370701,54370710,54370712,523764123,523764132,523764301,523764303,523765200,523765202,523765203,523765313,523766202,523766203,523766302,523766303,523766312,523766313,523767222,523774121,523774123,523774300,523774301,523774303,523774330,523774331,523774333,523777000,523777002,523777003,523777010,523777012,523777120,523777122,523777123,523777310,523777312,523777313,523870202,523870220,523870222,523870223,533704111,533704113,533704131,533704133,533704311,533705221,533705222,533705223,533714131,533714133,533715201,533715203,533715221,533715222,533715223,533725001,533725030,533725031,533725301,533725303,533725321,533735110,533735111,533735113,533736020,533736021,533736023,533736210,533736211,533736213,533746120,533746121,533746123,533746301,533746302,533746303,533756301,533756303,533766111,533766113,533766131,533766133,533766311,533766313,533766331,533766333,533776111,533776112,533776113,533776130,533776131,533776133,533776311,533777220,533777221,533777223,533800010,533800012,533800013,533800103,533800132,533801200,533801202,533810110,533810112,533810130,533810132,533811220,533811221,533811222,533821000,533821002,533821020,533821022,533821200,533821202,533821220,533821222,533821223,533831120,533831122,533831300,533831302,533831320,533841030,533841031,533841032,533841210,533841212,533841213,533841322,533851030,533851032,533851100,533851101,533851102,533851210,533851212,533851230,533851232,533861010,533861012,533861030,533861032,533861210,533861212,533870030,533870121,533870212,533870230,533871000,533871001,533871002,533871020,543707031,543707110,543707112,543707130,5237641212,5237641332,5237641333,5237642313,5237642331,5237642332,5237642333,5237643023,5237650232,5237652010,5237652012,5237652013,5237652122,5237652123,5237652132,5237653033,5237653113,5237653121,5237653122,5237653123,5237660231,5237660232,5237660233,5237660322,5237660323,5237660332,5237660333,5237662011,5237662012,5237662013,5237663000,5237663002,5237663003,5237663011,5237663012,5237663013,5237663102,5237672020,5237672022,5237672200,5237672201,5237672202,5237740110,5237740111,5237740113,5237741200,5237741201,5237741203,5237741221,5237741222,5237741223,5237743020,5237743021,5237743023,5237743201,5237743210,5237743211,5237743213,5237743320,5237743321,5237770010,5237770012,5237770013,5237770112,5237770130,5237770132,5237771320,5237771322,5237771323,5237773110,5237773112,5237773113,5238702002,5238702030,5238702032,5238702210,5238702212,5238702322,5337041101,5337041103,5337041121,5337041123,5337041301,5337041303,5337041321,5337041323,5337043013,5337043030,5337043031,5337043032,5337043101,5337043102,5337043103,5337043120,5337043121,5337043130,5337043131,5337052201,5337052203,5337141111,5337141113,5337141131,5337141132,5337141133,5337141301,5337141302,5337141303,5337141321,5337143111,5337152000,5337152001,5337152003,5337152021,5337152023,5337152201,5337152202,5337152203,5337250001,5337250031,5337250033,5337250211,5337253000,5337253001,5337253003,5337253021,5337253023,5337253201,5337253203,5337253231,5337351120,5337351121,5337351123,5337351301,5337351310,5337351311,5337351313,5337360221,5337360223,5337362011,5337362121,5337362310,5337362311,5337362313,5337362331,5337362333,5337460111,5337460113,5337460131,5337461220,5337461221,5337461223,5337462131,5337462133,5337462311,5337462313,5337463001,5337463003,5337563001,5337563211,5337563213,5337661101,5337661103,5337661121,5337661123,5337663101,5337663103,5337663121,5337663123,5337663301,5337663303,5337761013,5337761031,5337761032,5337761033,5337761102,5337761103,5337761210,5337761211,5337761213,5337761231,5337761320,5337761321,5337761323,5337763101,5337763131,5337763133,5337772221,5337772223,5338000112,5338001013,5338001022,5338001023,5338001300,5338001302,5338001303,5338001330,5338001332,5338001333,5338010222,5338010223,5338012030,5338012032,5338012200,5338012201,5338012202,5338012220,5338012222,5338101110,5338101111,5338101112,5338101130,5338101132,5338101310,5338101312,5338101330,5338101332,5338110000,5338112230,5338210030,5338210212,5338210230,5338210232,5338210233,5338212010,5338212011,5338212032,5338212210,5338212212,5338212333,5338311000,5338311002,5338311020,5338311022,5338311023,5338313030,5338313032,5338313210,5338313220,5338313221,5338313222,5338410330,5338410332,5338411000,5338411002,5338411200,5338412110,5338412112,5338413022,5338413200,5338413202,5338413203,5338413212,5338413230,5338413232,5338413233,5338510310,5338510311,5338510312,5338511030,5338511031,5338511032,5338511100,5338511102,5338511200,5338511201,5338511210,5338610130,5338610132,5338610310,5338610311,5338610332,5338612110,5338612112,5338612300,5338612302,5338612320,5338612321,5338612322,5338700310,5338700320,5338701201,5338701231,5338702102,5338702103,5338702320,5338702321,5338703101,5338703110,5338703111,5338710030,5338710031,5338710032,5338710100,5338710210,5338710212,5338710220,5338710221,5338710222,5437070010,5437070011,5437070013,5437070300,5437070301,5437070331,5437071110,5437071111,5437071112,5437071130,5437071132,5437071310,5437071312,5437071320,5437071321,5437071330,5437071331,5437071333,5437073000,5437073001,5437073010,5438000000,5438000001,5438000010,5438000011,52376412132,52376412133,52376413022,52376413023,52376413302,52376423112,52376423113,52376423123,52376423301,52376423303,52376430033,52376430211,52376430212,52376430213,52376430221,52376430223,52376502222,52376502223,52376502232,52376502233,52376502330,52376502332,52376520110,52376520112,52376520113,52376521002,52376521020,52376521022,52376521200,52376521202,52376521203,52376521212,52376521213,52376521332,52376521333,52376530222,52376530223,52376530232,52376530233,52376530322,52376530323,52376531023,52376531032,52376531033,52376531122,52376531123,52376531201,52376531203,52376602303,52376603200,52376603202,52376603203,52376603212,52376603213,52376603300,52376603302,52376603303,52376603312,52376612222,52376612223,52376620020,52376620022,52376620023,52376620032,52376620033,52376620100,52376620101,52376620103,52376630010,52376630012,52376630013,52376630101,52376630102,52376630103,52376631002,52376631032,52376631033,52376631122,52376631123,52376631131,52376631132,52376631133,52376720020,52376720022,52376720023,52376720210,52376720212,52376720230,52376720232,52376722030,52376722031,52376722032,52376722320,52376722322,52376723223,52376723232,52376723233,52377401120,52377401121,52377401311,52377401313,52377401331,52377401332,52377401333,52377403110,52377403111,52377403113,52377403331,52377403333,52377412021,52377412023,52377412201,52377412202,52377412203,52377421111,52377421113,52377421131,52377421133,52377421311,52377421313,52377421331,52377430220,52377430221,52377430223,52377432121,52377432311,52377432313,52377433220,52377433221,52377433230,52377433231,52377433233,52377700111,52377700112,52377700113,52377701100,52377701102,52377701330,52377701332,52377712120,52377712122,52377712123,52377712132,52377712133,52377713022,52377713320,52377713322,52377713323,52377731112,52387020032,52387020033,52387020120,52387020122,52387020330,52387020332,52387022110,52387022112,52387022130,52387022132,52387022133,52387023200,52387023202,52387023203,53370413021,53370413023,53370413201,53370413203,53370413221,53370413223,53370430330,53370430331,53370430332,53370431001,53370431002,53370431003,53370431220,53370431221,53370431230,53370431231,53370431320,53370431321,53370431331,53370432100,53370432101,53370433311,53370433313,53370433331,53370433332,53370433333,53371411123,53371411232,53371411233,53371411301,53371411302,53371411303,53371413001,53371413002,53371413003,53371413201,53371413231,53371431101,53371431130,53371431131,53371520020,53371520021,53371520203,53371520221,53371520223,53371522001,53371522002,53371522003,53372500001,53372500003,53372500030,53372500031,53372500033,53372500301,53372500303,53372500321,53372500323,53372502130,53372502131,53372502133,53372503310,53372503311,53372503313,53372503331,53372530020,53372530021,53372530023,53372530221,53372530223,53372532001,53372532003,53372532211,53372532300,53372532301,53372532303,53372532330,53372532331,53373510133,53373510311,53373510313,53373511220,53373511221,53373511223,53373513031,53373513120,53373513121,53373513123,53373513311,53373602200,53373602201,53373602203,53373620011,53373620100,53373620101,53373620103,53373620131,53373621201,53373621230,53373621231,53373621233,53373623011,53373623121,53373623123,53373623301,53373623303,53373623321,53374601330,53374601331,53374601333,53374612221,53374612223,53374621133,53374623310,53374623311,53374623313,53374623331,53374630001,53374630003,53374630021,53374630022,53374630023,53375601133,53375601311,53375601313,53375601331,53375601333,53375603111,53375603113,53375603131,53375603133,53375603311,53375603312,53375603313,53375603330,53375603331,53375630000,53375630001,53375630003,53375630031,53375630213,53375630231,53375630233,53375632100,53375632101,53375632103,53375632310,53375632311,53375632313,53376611001,53376611003,53376611021,53376611023,53376611201,53376611203,53376611221,53376611223,53376613001,53376613010,53376613011,53376613013,53376613031,53376613033,53376613211,53376613213,53376613231,53376613233,53376631023,53376631201,53376631203,53376631221,53376633211,53376633231,53376633233,53377610113,53377610301,53377610303,53377611002,53377611003,53377611011,53377611012,53377611013,53377612120,53377612121,53377612123,53377612331,53377613220,53377613221,53377613223,53377631001,53377631030,53377631031,53377631033,53377631301,53377631303,53377631321,53377631323,53377633111,53377633113,53377633131,53377633133,53377722200,53377722201,53377722203,53377722221,53377722223,53380001100,53380001102,53380001103,53380010123,53380010202,53380010203,53380010212,53380010213,53380011020,53380011022,53380011222,53380013010,53380013012,53380013120,53380013122,53380013310,53380013312,53380013313,53380102202,53380102203,53380102210,53380102212,53380102213,53380102322,53380120100,53380120102,53380120120,53380120122,53380120123,53380120312,53380120330,53380122030,53380122100,53380122101,53380122102,53380122230,53380122232,53380122233,53381011130,53381011132,53381011310,53381011312,53381011330,53381011331,53381011332,53381013110,53381013112,53381013130,53381013132,53381013310,53381013312,53381013330,53381013332,53381013333,53381100010,53381100011,53381102221,53381102222,53381102223,53381102230,53381102232,53381102233,53381121000,53381121002,53381121020,53381121222,53381122310,53381122311,53381123000,53381123002,53381123020,53381123022,53382100120,53382100122,53382102102,53382102312,53382120120,53382120121,53382120130,53382120302,53382120303,53382121000,53382122112,53382122130,53382122132,53382122133,53382123200,53382123202,53382123220,53382123222,53382123223,53382123232,53382123233,53382123311,53382123312,53382123313,53382123322,53382123323,53382132222,53383110210,53383110212,53383112100,53383112102,53383130120,53383130122,53383130123,53383130310,53383130312,53383130313,53383130330,53383130331,53383130332,53383132120,53383132122,53383132230,53383132231,53383132300,53384103310,53384103311,53384103312,53384103330,53384110200,53384110202,53384110220,53384110222,53384110223,53384112020,53384112021,53384112022,53384121132,53384130202,53384130232,53384132010,53384132012,53384132013,53384132310,53384132312,53384132313,53384133220,53384133222,53385103130,53385103131,53385103132,53385103300,53385103302,53385103320,53385103322,53385110330,53385110331,53385110332,53385111012,53385111030,53385111031,53385111032,53385111200,53385111202,53385121100,53385121300,53385121302,53385121320,53385121322,53385123100,53385123102,53385123120,53385123122,53385123300,53385123302,53385123303,53385123320,53385123321,53385123322,53386101100,53386101102,53386101120,53386101122,53386101312,53386101330,53386101332,53386103120,53386103121,53386103122,53386103130,53386103300,53386103302,53386103303,53386103330,53386121300,53386121302,53386123010,53386123011,53386123012,53386123030,53386123032,53386123230,53386123232,53387003110,53387003111,53387003120,53387003121,53387003122,53387003210,53387003220,53387003222,53387012000,53387012001,53387012003,53387012030,53387012031,53387012301,53387012303,53387012321,53387012330,53387012331,53387021000,53387021002,53387021003,53387021012,53387023102,53387023120,53387023122,53387023220,53387023221,53387023222,53387031000,53387031001,53387031003,53387031120,53387031121,53387031130,53387031131,53387031132,53387100330,53387101010,53387101012,53387101020,53387101021,53387101022,53387101200,53387102230,53387102231,53387102300,53387102301,53387102302,53387102310,53387120000,53387120001,53387120002,53387120020,54370700011,54370700120,54370700121,54370700123,54370700310,54370700311,54370700313,54370700331,54370700332,54370700333,54370702111,54370703021,54370703030,54370703031,54370703033,54370703300,54370703301,54370703331,54370703333,54370711130,54370711131,54370711332,54370713110,54370713112,54370713130,54370713132,54370713220,54370713221,54370713222,54370713230,54370713231,54370713320,54370713321,54370713323,54370721111,54370730030,54370730031,54370730032,54370730110,54370730111,54370730112,54370730210,54370730212,54370731000,54370731110,54370731111,54380000030,54380000131,54380001000,54380001002,54380001020,54380002222,54380020000,54380020002,
113,00,,494367187,127818750,496448437,129890625,6,19,39,89,227,424,533745,533754,533755,533764,533765,533775,5337252,5337341,5337343,5337350,5337352,5337353,5337441,5337442,5337443,5337533,5337562,5337630,5337631,5337660,5337662,5337741,5337760,5337762,5437060,53373401,53373403,53373512,53373622,53374401,53374402,53374403,53374600,53374602,53374603,53374620,53374622,53375233,53375303,53375311,53375312,53375313,53375321,53375322,53375323,53375600,53375602,53376321,53376610,53376612,53376630,53376632,53377401,53377403,53377430,53377431,53377433,53377630,53377632,54370610,54370611,54370620,53372431,53372433,533724132,533724133,533725002,533725020,533725022,533725023,533725032,533734021,533734210,533734211,533734213,533734231,533734233,533735100,533735102,533735132,533736202,533736203,533736232,533743313,533743331,533743332,533743333,533744003,533746010,533746012,533746210,533746212,533746230,533746232,533752312,533752313,533752321,533753102,533753103,533753202,533753203,533756010,533756012,533756030,533756032,533756320,533756322,533762111,533763200,533763201,533763300,533763301,533763310,533763311,533763313,533763331,533774000,533774001,533774003,533774211,533774213,533774320,533774321,533774323,533776100,533776102,533776120,533776122,533776312,533776330,533776332,533776333,543704110,543704111,543705000,543705001,543705110,543705111,543705113,543705131,543706120,543706121,543706122,543706130,543706131,543706210,543706212,543706220,543707002,533724321,533724323,533724301,533724303,5337241303,5337241311,5337241312,5337241313,5337250210,5337250212,5337250330,5337250332,5337253020,5337253202,5337253220,5337253222,5337253223,5337253232,5337340031,5337340032,5337340033,5337340231,5337340233,5337342121,5337342123,5337342303,5337342321,5337342322,5337342323,5337351010,5337351011,5337351012,5337351030,5337351032,5337351033,5337351300,5337351302,5337351330,5337351332,5337351333,5337360222,5337362000,5337362002,5337362003,5337362012,5337362122,5337362300,5337362302,5337362303,5337431331,5337431333,5337433111,5337433113,5337433301,5337433302,5337433303,5337440011,5337440012,5337440013,5337440021,5337440022,5337440023,5337460110,5337460112,5337460130,5337460132,5337462110,5337462111,5337462112,5337462130,5337462132,5337462310,5337462312,5337462330,5337462332,5337523013,5337523031,5337523032,5337523033,5337523102,5337523103,5337523110,5337523112,5337523113,5337523230,5337523231,5337523233,5337530133,5337530211,5337530212,5337530213,5337530231,5337530233,5337531002,5337531003,5337531012,5337531013,5337532002,5337532003,5337532011,5337532012,5337532013,5337560110,5337560111,5337560112,5337560130,5337560132,5337560310,5337560312,5337560330,5337560332,5337563002,5337563020,5337563022,5337563212,5337563230,5337563232,5337563233,5337621011,5337621013,5337621100,5337621101,5337621131,5337621133,5337621311,5337621313,5337621331,5337621333,5337623111,5337632021,5337632030,5337632031,5337632033,5337632301,5337632310,5337632311,5337633020,5337633021,5337633022,5337633030,5337633120,5337633121,5337633123,5337633200,5337633330,5337633331,5337633333,5337661302,5337661320,5337661322,5337663100,5337663300,5337663302,5337663320,5337663322,5337731111,5337740020,5337740021,5337740023,5337740211,5337742101,5337742310,5337742311,5337743221,5337761010,5337761012,5337761230,5337761232,5337763102,5337763310,5337763312,5437041011,5437041121,5437041123,5437041131,5437050020,5437050021,5437050023,5437050030,5437050031,5437050100,5437050101,5437050110,5437050111,5437051000,5437051001,5437051002,5437051010,5437051011,5437051120,5437051121,5437051123,5437051301,5437051330,5437051331,5437051333,5437053111,5437053113,5437053131,5437053133,5437053311,5437061230,5437061231,5437061232,5437061331,5437062110,5437062111,5437062112,5437062210,5437062211,5437062212,5437062221,5437062300,5437062301,5437063000,5437063001,5437070000,5437070002,5437070003,5437070030,5437070032,5437070200,5437070201,5437070202,5437070220,5337243221,5337243223,5337243201,5337243203,5337243023,5337241233,53372411313,53372411331,53372411333,53372413103,53372423223,53372500021,53372500022,53372500023,53372500032,53372500300,53372500302,53372500320,53372500322,53372502132,53372503312,53372503330,53372503332,53372503333,53372530022,53372530220,53372530222,53372532000,53372532002,53372532210,53372532212,53372532213,53372532302,53372532332,53372532333,53373400131,53373400132,53373400133,53373400301,53373400303,53373402300,53373402301,53373420110,53373420111,53373420113,53373420131,53373420133,53373422333,53373423011,53373423013,53373423201,53373423203,53373510130,53373510131,53373510132,53373510310,53373510312,53373511222,53373513030,53373513032,53373513033,53373513122,53373513310,53373513312,53373513313,53373602202,53373620010,53373620012,53373620013,53373620102,53373620130,53373620132,53373620133,53373621200,53373621202,53373621203,53373621232,53373623010,53373623012,53373623013,53373623120,53373623122,53373623300,53373623302,53373623320,53373623322,53373623323,53374311331,53374311333,53374313111,53374313113,53374313131,53374313132,53374313133,53374313303,53374313320,53374313321,53374313323,53374331101,53374331103,53374331121,53374331123,53374331213,53374331231,53374331232,53374331233,53374332133,53374332311,53374332331,53374332333,53374333001,53374333003,53374400033,53374400201,53374400202,53374400203,53374601332,53374612220,53374612222,53374621130,53374621131,53374621132,53374623312,53374623330,53374623332,53374623333,53374630000,53374630002,53374630020,53375230112,53375230113,53375230123,53375230231,53375230233,53375230301,53375230302,53375230303,53375231002,53375231003,53375231012,53375231013,53375231112,53375231113,53375232011,53375232321,53375232323,53375301233,53375301311,53375301313,53375301321,53375301322,53375301323,53375302101,53375302102,53375302103,53375302301,53375302303,53375302321,53375302323,53375310003,53375310012,53375310013,53375310111,53375310112,53375310113,53375320002,53375320012,53375320013,53375320101,53375320102,53375320103,53375601130,53375601131,53375601132,53375601310,53375601312,53375601330,53375601332,53375603110,53375603112,53375603130,53375603132,53375603310,53375603332,53375603333,53375630002,53375630030,53375630032,53375630033,53375630210,53375630211,53375630212,53375630230,53375630232,53375632102,53375632312,53376210101,53376210103,53376210121,53376211020,53376211021,53376211022,53376211030,53376211031,53376211301,53376211303,53376211321,53376213323,53376231101,53376231131,53376320201,53376320203,53376320230,53376320231,53376320320,53376320321,53376323000,53376323001,53376323031,53376323120,53376323121,53376323130,53376323131,53376330230,53376330231,53376330232,53376330310,53376330311,53376330313,53376331221,53376332010,53376332020,53376333011,53376333013,53376333031,53376333033,53376333320,53376333321,53376333323,53376611000,53376611002,53376611020,53376611022,53376611200,53376611202,53376611220,53376611222,53376613000,53376613002,53376613003,53376613012,53376613030,53376613032,53376613210,53376613212,53376613230,53376613232,53376631020,53376631021,53376631022,53376631200,53376631202,53376631220,53376631222,53376631223,53376633210,53376633212,53376633213,53376633230,53376633232,53377311101,53377311130,53377311131,53377311133,53377400220,53377400221,53377400223,53377402001,53377402010,53377402011,53377402100,53377402101,53377402130,53377402131,53377402133,53377402311,53377421001,53377421003,53377421031,53377421033,53377421211,53377421213,53377421231,53377421233,53377423011,53377423130,53377423131,53377423133,53377432201,53377610110,53377610111,53377610112,53377610300,53377610302,53377611000,53377611001,53377611010,53377612122,53377612330,53377612332,53377612333,53377613222,53377631000,53377631002,53377631003,53377631032,53377631300,53377631302,53377631320,53377631322,53377633110,53377633112,53377633130,53377633132,53377722202,53377722220,53377722222,54370410101,54370410131,54370411200,54370411201,54370411203,54370411221,54370411223,54370411300,54370411301,54370411302,54370500221,54370500320,54370501020,54370501021,54370501130,54370501131,54370501133,54370510030,54370510130,54370510131,54370510133,54370510311,54370511220,54370511221,54370511223,54370513030,54370513031,54370513033,54370513321,54370513323,54370533131,54370612330,54370612331,54370612332,54370613200,54370613201,54370613202,54370613210,54370613211,54370613300,54370613301,54370613331,54370621130,54370621131,54370621300,54370621302,54370621303,54370621320,54370621321,54370621322,54370622130,54370622131,54370622200,54370622201,54370622203,54370622230,54370622300,54370622301,54370623030,54370623031,54370623033,54370630020,54370630021,54370630030,54370630031,54370630100,54370630101,54370700010,54370700012,54370700013,54370700122,54370700312,54370700330,54370702030,54370702031,54370702032,54370702100,54370702210,54370702220,54370702221,53372423232,53372423233,53372413022,53372413023,53372412311,53372412312,53372412313,53372412303,53372412321,53372412322,53372412323,53372430011,53372430013,53372430031,53372430033,53372430211,53372430213,53372430223,53372432001,53372432003,53372432222,53372432223,53372423333,
114,00,/ģ,492693750,126628125,492876562,126834375,0,0,0,2,15,46,523667200,523667203,5236663111,5236663112,5236663113,5236663130,5236663131,5236670031,5236670203,5236670212,5236670221,5236670223,5236670230,5236670232,5236672012,5236672020,5236672021,52366613332,52366631320,52366631321,52366631330,52366631331,52366631333,52366700123,52366700132,52366700133,52366700301,52366700303,52366700321,52366700323,52366700330,52366700332,52366701022,52366701200,52366701202,52366702021,52366702022,52366702023,52366702101,52366702103,52366702110,52366702112,52366702130,52366702132,52366702201,52366702203,52366702222,52366702223,52366702310,52366702312,52366702330,52366720100,52366720102,52366720103,52366720112,52366720130,52366720132,52366720133,52366720220,52366720231,52366721200,52366722110,52366722111,
114,01,,492848437,126600000,492904687,126628125,0,0,0,0,1,8,5236670100,52366700111,52366700113,52366700131,52366701010,52366701012,52366701020,52366701021,52366701030,
114,02,,492848437,126571875,492904687,126600000,0,0,0,0,1,8,5236572322,52365722313,52365722331,52365722333,52365723202,52365723203,52365723212,52365723230,52365723232,
114,03,,492904687,126571875,492960937,126637500,0,0,0,0,3,10,5236572332,5236670110,5236670112,52365723213,52365723231,52365723233,52365723302,52366701011,52366701013,52366701031,52366701033,52366701110,52366701112,
114,04,,492820312,126571875,492848437,126628125,0,0,0,0,0,12,52365722303,52365722312,52365722321,52365722323,52365722330,52365722332,52366700101,52366700103,52366700110,52366700112,52366700121,52366700130,
114,05,//⻳,492820312,126487500,492904687,126571875,0,0,0,0,8,8,5236572031,5236572033,5236572120,5236572122,5236572211,5236572213,5236572300,5236572302,52365721210,52365721212,52365722123,52365722301,52365722310,52365722311,52365723200,52365723201,
114,06,,492876562,126618750,493087500,126703125,0,0,0,0,10,21,5236670113,5236670121,5236670130,5236670131,5236671020,5236671022,5236671023,5236671032,5236671033,5236671201,52366701023,52366701032,52366701201,52366701203,52366701320,52366701321,52366701330,52366701331,52366701333,52366710020,52366710022,52366710212,52366710213,52366710302,52366712000,52366712001,52366712003,52366712021,52366712030,52366712100,52366712101,
114,07,̶,492820312,126656250,493003125,126862500,0,0,0,4,17,49,523667030,523667031,523667032,523667210,5236670122,5236670123,5236670330,5236670331,5236670332,5236671220,5236672110,5236672112,5236672113,5236672121,5236672122,5236672123,5236672130,5236672132,5236672300,5236672301,5236672310,52366700331,52366700333,52366701322,52366701323,52366701332,52366702111,52366702113,52366702131,52366702133,52366702311,52366702313,52366702331,52366702332,52366702333,52366703330,52366703331,52366703332,52366712002,52366712020,52366712022,52366712023,52366712220,52366720101,52366720110,52366720111,52366720113,52366720131,52366721110,52366721112,52366721113,52366721201,52366721202,52366721203,52366721310,52366721311,52366721312,52366721330,52366723020,52366723021,52366723110,52366723112,52366723120,52366723121,52366723123,52366723130,52366723132,52366730020,52366730022,52366730200,
114,08,̾Ų,492735937,126553125,492820312,126703125,0,0,0,1,6,27,523667002,5236572221,5236572223,5236670001,5236670003,5236670200,5236670201,52365722122,52365722203,52365722221,52365722223,52365722300,52365722302,52365722320,52365722322,52366611331,52366611333,52366613111,52366613113,52366700001,52366700003,52366700021,52366700023,52366700100,52366700102,52366700120,52366700122,52366700300,52366700302,52366700320,52366700322,52366702020,52366702100,52366702102,
114,09,¼,492595312,126515625,492778125,126675000,0,0,0,4,11,31,523656330,523656332,523656333,523666111,5236563231,5236563233,5236563312,5236563313,5236661100,5236661101,5236661103,5236661121,5236661130,5236661131,5236661132,52365630323,52365630332,52365630333,52365631222,52365631223,52365632101,52365632110,52365632111,52365632113,52365632131,52365632132,52365632133,52365633100,52365633102,52365633103,52365722022,52365722200,52365722201,52365722202,52365722220,52365722222,52366610111,52366611021,52366611023,52366611231,52366611330,52366611332,52366700000,52366700002,52366700020,52366700022,
114,10,,492482812,126403125,492834375,126590625,0,0,0,8,34,51,523656300,523656301,523656302,523656310,523656311,523656313,523656320,523657202,5236560333,5236561223,5236561231,5236561232,5236561233,5236561320,5236561322,5236561323,5236561331,5236561332,5236561333,5236562111,5236562113,5236562131,5236562133,5236562313,5236562331,5236563030,5236563031,5236563120,5236563121,5236563123,5236563212,5236563220,5236563311,5236570220,5236570222,5236572000,5236572002,5236572032,5236572200,5236572201,5236572203,5236572210,52365603313,52365603321,52365603323,52365612132,52365612211,52365612213,52365612220,52365612222,52365612223,52365612300,52365612302,52365612303,52365613212,52365613213,52365621121,52365621123,52365621301,52365623330,52365623331,52365630320,52365630321,52365630322,52365630330,52365630331,52365631220,52365631221,52365632100,52365632102,52365632103,52365632112,52365632130,52365632220,52365632221,52365633101,52365702210,52365702212,52365702230,52365702232,52365720010,52365720012,52365720030,52365720032,52365720033,52365720301,52365720302,52365720303,52365722020,52365722021,52365722023,52365722120,52365722121,
114,11,,492454687,126093750,492890625,126440625,0,0,2,16,32,69,52365611,52364633,523646310,523646312,523647223,523656031,523656101,523656102,523656103,523656120,523656130,523656131,523657000,523657002,523657020,523647222,523646313,523646132,5236463113,5236463232,5236463233,5236472020,5236472022,5236472200,5236472212,5236472213,5236560131,5236560133,5236560330,5236561001,5236561002,5236561003,5236561210,5236561211,5236561212,5236561220,5236561330,5236570010,5236570011,5236570012,5236570030,5236570032,5236570210,5236472203,5236472202,5236463112,5236463110,5236461302,5236463231,5236463213,52364612313,52364612331,52364612333,52364613032,52364630111,52364630113,52364630131,52364630133,52364630311,52364631112,52364631113,52364632231,52364632232,52364632233,52364632302,52364632303,52364720002,52364720020,52364720022,52364722010,52364722012,52364722013,52364722102,52364722103,52364722112,52364723222,52364723223,52365601132,52365601133,52365601301,52365601303,52365601321,52365601322,52365601323,52365603013,52365603031,52365603310,52365603311,52365603312,52365610001,52365610003,52365612130,52365612131,52365612133,52365612210,52365612212,52365612221,52365612301,52365613210,52365613211,52365700130,52365700132,52365700310,52365700312,52365700330,52365700332,52365701000,52365701001,52365702110,52365702112,52365702120,52365702122,52364613322,52364613320,52364613323,52364613030,52364632301,52364632113,52364632111,
114,12,Ǯ,492792187,126393750,492918750,126496875,0,0,0,2,5,23,523657023,523657201,5236570213,5236570320,5236570322,5236572100,5236572102,52365702121,52365702123,52365702211,52365702213,52365702231,52365702233,52365703031,52365703032,52365703033,52365703210,52365703212,52365703230,52365703232,52365703233,52365720011,52365720013,52365720031,52365720300,52365721010,52365721011,52365721012,52365721030,52365721032,
114,13,,492848437,126234375,493031250,126412500,0,0,0,5,22,26,523647233,523657011,523657012,523657013,523657102,5236472302,5236472303,5236472312,5236472313,5236472320,5236472321,5236472323,5236473220,5236473222,5236570101,5236570102,5236570103,5236570300,5236570301,5236570302,5236570310,5236570311,5236571000,5236571002,5236571200,5236571201,5236571202,52364722113,52364723002,52364723003,52364723012,52364723013,52364723220,52364723221,52364732022,52365700131,52365700133,52365700311,52365700313,52365700331,52365700333,52365701002,52365701003,52365702111,52365702113,52365703030,52365703130,52365703131,52365703133,52365710030,52365710032,52365712030,52365712031,
114,14,ж,492904687,126140625,493298437,126384375,0,0,0,11,35,50,523647302,523647303,523647321,523647323,523647330,523647332,523647333,523657101,523657110,523657111,523750000,5236472131,5236472133,5236472310,5236472311,5236473001,5236473003,5236473011,5236473012,5236473013,5236473100,5236473102,5236473120,5236473122,5236473123,5236473200,5236473201,5236473203,5236473221,5236473223,5236473312,5236571001,5236571030,5236571031,5236571120,5236571121,5236571130,5236571131,5236571133,5237402220,5237402222,5237402223,5237500020,5237500021,5237500030,5237500032,52364712332,52364712333,52364713222,52364713223,52364721131,52364721133,52364721233,52364721321,52364721322,52364721323,52364723011,52364730022,52364730023,52364730100,52364730102,52364730103,52364731320,52364731322,52364732020,52364732021,52364732023,52364733100,52364733102,52364733103,52364733132,52364733133,52365710031,52365710033,52365711231,52365711320,52365711321,52365711323,52374022022,52374022023,52374022032,52374022210,52374022212,52375000100,52375000102,52375000120,52375000122,52375000123,52375000220,52375000230,52375000231,52375000233,52375000312,52375000330,52375000332,52375002101,
114,15,,493087500,126431250,493157812,126534375,0,0,0,0,5,8,5236573101,5236573102,5236573103,5236573121,5236573123,52365713221,52365713223,52365713232,52365731001,52365731003,52365731201,52365731300,52365733011,
114,16,/,493031250,126356250,493242187,126525000,0,0,0,3,11,30,523657130,523657133,523657311,5236571032,5236571033,5236571122,5236571210,5236571211,5236571310,5236571312,5236571321,5236573131,5236573132,5237502002,52365711230,52365711232,52365711233,52365711322,52365712130,52365712131,52365712133,52365713112,52365713130,52365713132,52365713133,52365713200,52365713201,52365713203,52365713230,52365713231,52365713233,52365731301,52365731302,52365731303,52365731330,52375002222,52375020000,52375020002,52375020003,52375020012,52375020030,52375020032,52375020200,52375020202,
114,17,ʿ/,493171875,126356250,493284375,126450000,0,0,0,1,1,20,523750020,5237500220,52365713110,52365713111,52365713113,52365713131,52375000221,52375000222,52375000223,52375000232,52375002100,52375002102,52375002103,52375002120,52375002122,52375002210,52375002211,52375002212,52375002220,52375002221,52375002223,52375002230,
114,18,,492904687,126421875,493059375,126478125,0,0,0,0,7,20,5236570333,5236571222,5236572110,5236572111,5236573000,5236573001,5236573010,52365703321,52365703322,52365703323,52365712203,52365712212,52365712230,52365712232,52365712233,52365721013,52365721031,52365721120,52365721121,52365721130,52365721131,52365730020,52365730021,52365730030,52365730031,52365730120,52365730121,
114,19,,492904687,126393750,493031250,126440625,0,0,0,0,3,14,5236570312,5236570330,5236570331,52365703132,52365703211,52365703213,52365703231,52365703320,52365712032,52365712033,52365712200,52365712201,52365712202,52365712210,52365712211,52365712213,52365712231,
114,20,,492890625,126496875,492975000,126571875,0,0,0,0,6,9,5236572123,5236572132,5236572301,5236572303,5236572310,5236572312,52365721213,52365721302,52365721303,52365723132,52365723133,52365723210,52365723211,52365723300,52365723301,
114,21,,492946875,126506250,493045312,126562500,0,0,0,0,4,13,5236572311,5236573022,5236573200,5236573201,52365721331,52365721332,52365721333,52365723130,52365723131,52365730230,52365730232,52365732020,52365732021,52365732030,52365732031,52365732033,52365732120,
114,22,۵,493017187,126487500,493087500,126562500,0,0,0,0,4,9,5236573030,5236573032,5236573210,5236573211,52365730231,52365730233,52365730312,52365730330,52365730332,52365732121,52365732123,52365732130,52365732132,
114,23,,492989062,126478125,493045312,126506250,0,0,0,0,1,6,5236573021,52365730023,52365730032,52365730033,52365730122,52365730201,52365730203,
114,24,Ȭ,493031250,126393750,493115625,126534375,0,0,0,1,4,16,523657123,5236571212,5236573011,5236573013,5236573122,52365712132,52365713202,52365713220,52365713222,52365730123,52365730310,52365730311,52365730313,52365730331,52365730333,52365731000,52365731002,52365731200,52365731202,52365731203,52365733000,
114,25,,492904687,126478125,492989062,126515625,0,0,0,0,1,12,5236572131,52365721033,52365721122,52365721123,52365721132,52365721133,52365721211,52365721300,52365721301,52365721330,52365730022,52365730200,52365730202,
114,26,/,492932812,126553125,493003125,126637500,0,0,0,0,4,9,5236572331,5236572333,5236573222,5236671000,52365723303,52365732022,52365732200,52365732202,52365732203,52366701111,52366701113,52366710021,52366710023,
114,27,Ӳ/в,492989062,126553125,493059375,126646875,0,0,0,0,7,10,5236573221,5236573223,5236573232,5236671001,5236671003,5236671010,5236671012,52365732023,52365732032,52365732122,52365732201,52365732300,52365732302,52365732303,52366710210,52366710211,52366710300,
114,28,ܻ,493045312,126534375,493129687,126675000,0,0,0,0,8,18,5236573231,5236573233,5236573322,5236671011,5236671013,5236671031,5236671102,5236671120,52365732131,52365732133,52365732301,52365733002,52365733020,52365733022,52365733200,52365733202,52365733232,52366710301,52366710303,52366711000,52366711002,52366711030,52366711032,52366711220,52366711221,52366711222,
114,29,컳/,493101562,126525000,493185937,126684375,0,0,0,0,9,30,5236573303,5236573312,5236573321,5236573330,5236573332,5236671101,5236671110,5236671121,5236671123,52365733001,52365733003,52365733010,52365733012,52365733013,52365733021,52365733023,52365733100,52365733102,52365733201,52365733203,52365733230,52365733231,52365733233,52365733312,52365733330,52366711001,52366711003,52366711031,52366711033,52366711110,52366711120,52366711121,52366711122,52366711223,52366711300,52366711302,52366711320,52366711322,52366713100,
114,30,/,493171875,126562500,493270312,126628125,0,0,0,0,5,14,5237502220,5237502222,5237502223,5237600000,5237600001,52365733311,52365733313,52365733331,52365733332,52365733333,52366711111,52366711113,52375022210,52375022212,52375022213,52375022302,52375022320,52376000030,52376000031,
114,31,ܶ/ƣ,493157812,126487500,493312500,126693750,0,0,0,2,18,44,523750220,523760002,5236573311,5236573313,5236671113,5236671131,5236671133,5236671311,5237502021,5237502022,5237502023,5237502030,5237502032,5237502210,5237502212,5237600002,5237600010,5237600012,5237600030,5237600032,52365731331,52365731332,52365731333,52365733101,52365733103,52365733310,52366711112,52366711123,52366711301,52366711303,52366711321,52366711323,52366713101,52366713103,52375020201,52375020203,52375020310,52375022112,52375022130,52375022132,52375022211,52375022300,52375022301,52375022303,52375022310,52375022312,52375022321,52375022322,52375022323,52375022330,52375022332,52375022333,52376000032,52376000033,52376000110,52376000112,52376000130,52376000132,52376000310,52376000312,52376000330,52376002000,52376002001,52376002002,
114,32,黳,492960937,126675000,493425000,126918750,0,0,0,9,37,52,523667123,523667130,523667132,523667133,523667311,523760202,523760221,523760223,523760232,5236671211,5236671212,5236671213,5236671221,5236671223,5236671312,5236671313,5236673000,5236673001,5236673010,5236673011,5236673100,5236673101,5236673130,5236673131,5236673133,5236673311,5237600201,5237600202,5237600203,5237600210,5237600211,5237600213,5237600220,5237600221,5237600222,5237602000,5237602002,5237602200,5237602201,5237602302,5237602312,5237602330,5237602332,5237700100,5237700101,5237700110,52366703333,52366712031,52366712032,52366712033,52366712102,52366712103,52366712221,52366712222,52366712223,52366713102,52366721111,52366731030,52366731031,52366731033,52366731211,52366733130,52366733131,52376002003,52376002122,52376002230,52376002232,52376003000,52376003002,52376003020,52376020030,52376020032,52376020033,52376020302,52376020320,52376020322,52376020323,52376020332,52376022020,52376022021,52376022030,52376022031,52376022033,52376022211,52376022213,52376022231,52376023002,52376023003,52376023030,52376023032,52376023033,52376023310,52376023312,52376023313,52376023330,52376023331,52377000111,52377000113,
115,00,쳤///η,492637500,125878125,493565625,126684375,0,0,10,39,82,184,52363723,52364701,52364702,52364703,52364710,52375003,52375021,52375023,52375032,52376001,523646113,523647001,523647002,523647003,523647110,523647112,523647120,523647121,523647122,523647130,523647131,523647133,523647201,523647203,523647210,523647311,523740022,523740200,523740202,523740203,523740221,523740223,523740230,523740232,523750010,523750012,523750013,523750023,523750102,523750120,523750122,523750201,523750300,523750302,523750303,523760100,523760101,523760102,523646131,5236372121,5236372123,5236372132,5236372211,5236372213,5236372231,5236372232,5236372233,5236373220,5236373222,5236373223,5236373232,5236461121,5236461331,5236461333,5236470001,5236470002,5236470003,5236471112,5236471130,5236471132,5236471230,5236471231,5236471232,5236471320,5236471321,5236471323,5236472001,5236472003,5236472021,5236472023,5236472110,5236472111,5236472112,5236472120,5236472121,5236472122,5236472130,5236473000,5236473101,5236473103,5236473121,5236473130,5236473131,5236473133,5236473311,5237400202,5237400232,5237402010,5237402012,5237402013,5237402120,5237402122,5237402123,5237402200,5237402201,5237402330,5237402332,5237500011,5237500013,5237500110,5237500112,5237500113,5237500211,5237500213,5237501030,5237501032,5237501210,5237501212,5237501230,5237501232,5237502033,5237503010,5237503011,5237503012,5237503122,5237503300,5237601030,5237601100,5236461123,5236461301,5236461330,52363721032,52363721203,52363721221,52363721222,52363721223,52363721302,52363721303,52363722121,52363722123,52363722231,52363722232,52363722301,52363722303,52363732020,52363732022,52363732023,52363732032,52363732210,52363732212,52363732213,52363732302,52363732332,52363733222,52363733223,52363733232,52363733233,52364611123,52364611131,52364611132,52364611133,52364631110,52364631111,52364700001,52364700002,52364700003,52364711102,52364711332,52364711333,52364712330,52364712331,52364713220,52364713221,52364720000,52364720001,52364720003,52364720021,52364720023,52364721130,52364721132,52364721230,52364721231,52364721232,52364721320,52364722011,52364722100,52364722101,52364722110,52364722111,52364723000,52364723001,52364723010,52364730020,52364730021,52364730101,52364731321,52364731323,52364733101,52364733130,52364733131,52374002000,52374002002,52374002003,52374002302,52374020110,52374020112,52374021022,52374021023,52374021212,52374022020,52374022021,52374022030,52374022031,52374022033,52374022211,52374022213,52374023102,52374023120,52374023122,52374023332,52375000101,52375000103,52375000121,52375000310,52375000311,52375000313,52375000331,52375000333,52375001110,52375001112,52375002121,52375002123,52375002213,52375002231,52375002232,52375002233,52375010022,52375010032,52375010312,52375010330,52375010332,52375012110,52375012112,52375012130,52375012132,52375012310,52375012312,52375012313,52375012330,52375012332,52375020001,52375020010,52375020011,52375020013,52375020031,52375020033,52375020311,52375020312,52375020313,52375022110,52375022111,52375022113,52375022131,52375022133,52375022311,52375022313,52375022331,52375030130,52375030132,52375031202,52375033020,52375033021,52375033022,52375033200,52375033202,52375033220,52375033222,52376000111,52376000113,52376000131,52376000133,52376000311,52376000313,52376000331,52376000332,52376000333,52376003001,52376003011,52376003100,52376003101,52376003110,52376010310,52376010311,52376010312,52376010320,52376010321,52376010322,52376010330,52376011020,52376011021,52376011022,52376012001,52376012010,52364611122,52364613033,52364613031,52364611201,52364611203,52364611221,52364611223,52364613321,52364611200,52364613003,52364613001,52363722233,
116,00,//,492032812,125925000,492960937,127321875,0,6,23,51,131,259,5236553,5236651,5236660,5236662,5236760,5236762,52364623,52365513,52365600,52365602,52365620,52365622,52366530,52366531,52366533,52366612,52366630,52366632,52366633,52367511,52367610,52367612,52367630,52367632,53360601,52364621,52364603,52364601,52363623,523646023,523646120,523646122,523646201,523646203,523646221,523646223,523646300,523646302,523646320,523655113,523655123,523656010,523656012,523656032,523656210,523656212,523656230,523656232,523665320,523665321,523665323,523666100,523666102,523666103,523666130,523666132,523666310,523666312,523667220,523667222,523667223,523667232,523675101,523675130,523675131,523675133,523675311,523676110,523676132,523676310,523676312,533606001,533606003,533606030,533606100,533606101,533606102,523646100,523646121,523646102,5236460033,5236460211,5236460213,5236461230,5236461232,5236462001,5236462003,5236462021,5236462023,5236462201,5236462203,5236462221,5236462222,5236462223,5236463010,5236463012,5236463030,5236463032,5236463220,5236463221,5236463222,5236551111,5236551113,5236551122,5236551123,5236551211,5236551213,5236552111,5236552113,5236552131,5236552133,5236552311,5236552313,5236552331,5236552333,5236560110,5236560111,5236560112,5236560300,5236560302,5236562110,5236562132,5236562310,5236562311,5236562312,5236562330,5236562332,5236563221,5236563223,5236563230,5236563232,5236650111,5236650113,5236650131,5236650133,5236650311,5236652311,5236652313,5236653220,5236653221,5236653223,5236661010,5236661012,5236661013,5236661120,5236661122,5236661310,5236661312,5236661313,5236661330,5236661331,5236661332,5236663110,5236672210,5236672212,5236672213,5236672303,5236672330,5236672332,5236751030,5236751031,5236751033,5236751211,5236751321,5236751323,5236753130,5236753131,5236753133,5236753311,5236761110,5236761111,5236761112,5236761120,5236761300,5236761302,5236761303,5236761332,5236763110,5236763112,5236763113,5236763130,5236763300,5236763301,5236763302,5236770000,5236770001,5236770003,5236770010,5236770012,5236770100,5236770101,5236770103,5236770110,5336060001,5336060003,5336060021,5336060210,5336060211,5336060213,5336060310,5336061030,5336061032,5236463210,5236463212,5236463033,5236363222,5236363220,5236460031,5236461032,5236461033,5236461030,52364533333,52364602121,52364602122,52364602123,52364602213,52364602231,52364602233,52364612310,52364612311,52364612312,52364612330,52364612332,52364620201,52364620203,52364620221,52364620223,52364622001,52364622003,52364622021,52364622022,52364622023,52364622200,52364622201,52364622203,52364630110,52364630310,52364630312,52364632230,52365510333,52365511103,52365511121,52365511122,52365511123,52365511211,52365511212,52365511213,52365512121,52365512123,52365512213,52365512222,52365512223,52365512231,52365512232,52365512233,52365521103,52365521121,52365521123,52365521301,52365521303,52365521321,52365521323,52365523101,52365523103,52365523121,52365523123,52365523301,52365523303,52365523321,52365523323,52365601130,52365601131,52365601300,52365601302,52365601320,52365603010,52365603011,52365603012,52365603030,52365603032,52365603033,52365603320,52365603322,52365610000,52365610002,52365621120,52365621122,52365621300,52365621302,52365621303,52365623332,52365623333,52365632222,52365632223,52366501101,52366501103,52366501121,52366501123,52366501301,52366501303,52366501321,52366501323,52366503101,52366503131,52366503313,52366503331,52366503333,52366521111,52366521113,52366521131,52366521133,52366521311,52366521313,52366521331,52366521333,52366523311,52366523313,52366532220,52366532221,52366532223,52366610110,52366610112,52366610113,52366611020,52366611022,52366611230,52366611232,52366611233,52366613110,52366613112,52366613330,52366613331,52366613333,52366631322,52366631323,52366631332,52366702200,52366702202,52366702220,52366702221,52366720221,52366720222,52366720223,52366720230,52366720232,52366720233,52366722112,52366722113,52366723022,52366723023,52366723122,52366723310,52366723312,52366723330,52366723332,52367510010,52367510011,52367510013,52367510031,52367510033,52367510320,52367510321,52367510323,52367512101,52367512103,52367512121,52367512130,52367512131,52367512133,52367513200,52367513201,52367513203,52367513221,52367531011,52367531013,52367531031,52367531321,52367531323,52367533101,52367533130,52367533131,52367533133,52367533311,52367611130,52367611131,52367611210,52367611220,52367611222,52367613122,52367613300,52367613302,52367613303,52367631112,52367631113,52367631310,52367631311,52367631312,52367631320,52367631322,52367633030,52367633031,52367633032,52367633200,52367633202,52367633220,52367633222,52367700021,52367700023,52367700110,52367700111,52367700112,52367700130,52367700210,52367701020,52367701021,52367701110,52367701112,52367701120,52367701121,52367701122,52367701130,52367701211,52367720002,52367720020,52367720022,53360600001,53360600003,53360600021,53360600231,53360600233,53360602011,53360602120,53360602121,53360602123,53360602310,53360602311,53360603110,53360603111,53360603200,53360603201,53360603210,53360603211,53360610312,53360610330,53360610332,53360612000,53360612001,53360612010,52364632300,52364632110,52364632112,52364630313,52364630132,52364630130,52364630112,52364610122,52364610120,52364610102,52363632232,52363632230,52363632233,52363632212,52364610312,52364610123,52364610313,52364613002,52364613000,52364611222,52364611220,52364611202,
117,00,Լ,491090625,125625000,492412500,126318750,1,6,13,32,54,120,523635,5236341,5236342,5236343,5236431,5236440,5236441,52363333,52363403,52364330,52364331,52364333,52364420,52364421,52364422,52364500,52364501,52362523,52362532,52363620,523624332,523624333,523633233,523633311,523633312,523633313,523633321,523633322,523633323,523634012,523634013,523634021,523634022,523634023,523643011,523643013,523643031,523643033,523643211,523643321,523643322,523643323,523645020,523645021,523645022,523645030,523645031,523645102,523645100,523625222,523625223,523636220,5236243222,5236243223,5236243232,5236243233,5236243312,5236243313,5236331332,5236331333,5236332312,5236332313,5236332321,5236333033,5236333101,5236333103,5236333202,5236333203,5236340033,5236340103,5236340111,5236340112,5236340113,5236432131,5236433201,5236433203,5236442300,5236442301,5236443000,5236443001,5236443002,5236443010,5236443011,5236443020,5236443100,5236450230,5236450231,5236450320,5236450321,5236450323,5236450330,5236450332,5236451200,5236531101,5236531110,5236531111,5236451012,5236451030,5236451011,5236451010,5236252202,5236252203,5236252212,5236252213,5236252211,5236362220,52362423333,52362432303,52362432311,52362432312,52362432313,52362433023,52362433032,52362433033,52363313231,52363313233,52363313303,52363313311,52363313312,52363313313,52363323012,52363323013,52363323031,52363323033,52363323102,52363323103,52363323231,52363330323,52363331021,52363331023,52363332011,52363332012,52363332013,52363400311,52363400312,52363400313,52363400321,52363400322,52363400323,52363401013,52363401021,52363401022,52363401023,52363401101,52363401102,52363401103,52363402031,52363402032,52363402033,52364301011,52364301013,52364301031,52364301033,52364301211,52364301213,52364301231,52364303013,52364303031,52364303033,52364303211,52364303213,52364303231,52364303233,52364321011,52364321013,52364321031,52364321301,52364321331,52364323331,52364332000,52364332001,52364332003,52364332021,52364332022,52364332023,52364423020,52364423021,52364423022,52364423100,52364423101,52364430030,52364430031,52364430032,52364430120,52364430121,52364430220,52364430222,52364431010,52364431011,52364431100,52364431101,52364431110,52364431111,52364502320,52364502321,52364502322,52364502330,52364502331,52364503220,52364503221,52364503310,52364503311,52364503312,52364512010,52364512012,52364512020,52364512021,52364512022,52364520000,52364521010,52364521011,52365311000,52365311001,52365400000,52365400001,52365400002,52365400010,52365400011,52365400100,52365400101,52362522013,52362522101,52362522102,52362522103,52363622220,52363622221,
117,01,̾,491076562,125925000,492412500,126918750,0,5,20,58,106,174,5236541,5236542,5236550,5236631,5236640,52364432,52364433,52364522,52364523,52364530,52364531,52364532,52365313,52365331,52365333,52365401,52365402,52365403,52365430,52365431,52365432,52366331,52366420,52364513,52364511,523644232,523644233,523644303,523644312,523644313,523645121,523645122,523645123,523645201,523645202,523645203,523645211,523645212,523645213,523645330,523645331,523645332,523653101,523653103,523653112,523653113,523653121,523653123,523653300,523653301,523653303,523653321,523653323,523654002,523654003,523654330,523654332,523655100,523655101,523655102,523655110,523655120,523655200,523655201,523655210,523663013,523663031,523663033,523663211,523663301,523664100,523664101,523664102,523664120,523664210,523664212,523664221,523646020,523646002,523646000,523646001,523636223,523636221,5236442303,5236442311,5236442312,5236442313,5236443013,5236443021,5236443023,5236443102,5236443103,5236443112,5236443113,5236450333,5236451203,5236452001,5236452002,5236452003,5236452100,5236452102,5236452103,5236453330,5236453331,5236453332,5236460032,5236460210,5236460220,5236460222,5236462000,5236462002,5236531001,5236531002,5236531003,5236531021,5236531023,5236531102,5236531103,5236531112,5236531113,5236531201,5236531203,5236531221,5236531223,5236533021,5236533023,5236533223,5236540002,5236540003,5236540011,5236540012,5236540013,5236543310,5236543312,5236551030,5236551031,5236551032,5236551120,5236551210,5236551220,5236552020,5236552021,5236552023,5236552030,5236552031,5236552033,5236552120,5236552121,5236552122,5236552211,5236552213,5236552231,5236552300,5236630123,5236630301,5236630303,5236632131,5236633000,5236633001,5236633030,5236633031,5236633033,5236633310,5236633311,5236641030,5236641031,5236641032,5236641100,5236641101,5236641102,5236641210,5236641220,5236642110,5236642111,5236642230,5236642231,5236642233,5236642300,5236642301,5236642302,5236642320,5236642322,5236460030,5236451033,5236451032,5236451031,5236451013,5236362223,5236362221,52364423023,52364423102,52364423103,52364430033,52364430122,52364430123,52364430221,52364430223,52364431012,52364431013,52364431102,52364431103,52364431112,52364431113,52364502323,52364502332,52364502333,52364503222,52364503223,52364503313,52364512011,52364512013,52364512023,52364520001,52364520002,52364520003,52364521012,52364521013,52364533330,52364533331,52364533332,52364602120,52364602210,52364602211,52364602212,52364602230,52364602232,52364620200,52364620202,52364620220,52364620222,52364622000,52364622002,52364622020,52364622202,52365310001,52365310002,52365310003,52365310200,52365310201,52365310203,52365310221,52365310223,52365311002,52365311003,52365312001,52365312003,52365312021,52365312023,52365312201,52365312222,52365312223,52365321111,52365321113,52365330201,52365332010,52365332011,52365400003,52365400012,52365400013,52365400102,52365400103,52365433110,52365433300,52365433302,52365510330,52365510331,52365510332,52365511100,52365511101,52365511102,52365511120,52365511210,52365512120,52365512122,52365512210,52365512211,52365512212,52365512220,52365512221,52365512230,52365520220,52365520221,52365520223,52365520320,52365520321,52365521100,52365521101,52365521102,52365521230,52365523020,52365523022,52365523200,52366301131,52366301132,52366301133,52366301211,52366301212,52366301213,52366301221,52366301223,52366303001,52366303210,52366303211,52366303213,52366303231,52366303233,52366321011,52366321013,52366321030,52366321031,52366321033,52366321301,52366330020,52366330030,52366330031,52366330033,52366330321,52366330323,52366332110,52366332111,52366332113,52366333000,52366333001,52366333003,52366333010,52366333011,52366333012,52366333120,52366410330,52366411030,52366411200,52366412120,52366412210,52366421120,52366421121,52366421122,52366421130,52366421131,52366421300,52366421302,52366421320,52366421322,52366422000,52366422001,52366422010,52366422011,52366422013,52366422031,52366422320,52366422321,52366422323,52366423030,52366423032,52366423100,52366423101,52366423210,52366423212,52367400110,52367400111,52367401000,52367401002,52363622222,52363622223,
117,02,뼯/,490556250,125250000,492187500,125943750,0,8,28,38,89,147,5236221,5236231,5236232,5236233,5236240,5236241,5236250,5236152,52361223,52361333,52361422,52361423,52362300,52362302,52362303,52362420,52362421,52362422,52362430,52362431,52363300,52363301,52363303,52363310,52363311,52363312,52362520,52361433,52361432,52361431,52362521,52362530,52362510,52362512,52361530,52361532,523612322,523612323,523612332,523612333,523613313,523613321,523613322,523613323,523614202,523622011,523622013,523622030,523622031,523622300,523622301,523622310,523622311,523622313,523623012,523623013,523624230,523624231,523624232,523624320,523624321,523633021,523633130,523633131,523633210,523633211,523633213,523633300,523633301,523633302,523634000,523634001,523634002,523614303,5236122033,5236122122,5236122123,5236122131,5236122132,5236122133,5236122210,5236122211,5236123200,5236123202,5236123203,5236123212,5236123213,5236123302,5236123303,5236123312,5236123313,5236132220,5236132222,5236132223,5236133113,5236133122,5236133123,5236133202,5236133203,5236142032,5236142033,5236142122,5236142123,5236142132,5236143021,5236143022,5236143023,5236220101,5236220103,5236220121,5236220123,5236220321,5236220330,5236220331,5236220333,5236223030,5236223031,5236223120,5236223121,5236223123,5236223310,5236223311,5236223313,5236223331,5236223333,5236230102,5236230103,5236230113,5236242330,5236242331,5236242332,5236243220,5236243221,5236243300,5236243301,5236243310,5236243311,5236252200,5236321111,5236330200,5236330201,5236330203,5236330231,5236330233,5236331320,5236331321,5236331322,5236332011,5236332121,5236332123,5236332311,5236333030,5236333031,5236333100,5236333200,5236340030,5236340100,5236340200,5236340201,5236340202,5236143012,5236143011,5236143013,52361220313,52361220322,52361220323,52361221202,52361221203,52361221303,52361222131,52361222133,52361222311,52361222313,52361222331,52361222333,52361230200,52361230202,52361230220,52361230222,52361230223,52361230230,52361230232,52361232010,52361232012,52361232013,52361232103,52361232112,52361232113,52361233002,52361233003,52361322020,52361322022,52361322023,52361322212,52361330233,52361330320,52361330322,52361330323,52361330331,52361330332,52361330333,52361331123,52361331202,52361331211,52361331212,52361331213,52361332011,52361332012,52361332013,52361420303,52361421202,52361421203,52361421212,52361421331,52361421332,52361421333,52361430203,52362201000,52362201001,52362201003,52362201023,52362201201,52362201203,52362201221,52362201222,52362201223,52362202111,52362202113,52362203201,52362203203,52362203320,52362203321,52362203323,52362221111,52362230210,52362230211,52362230330,52362230331,52362231220,52362231221,52362231223,52362233010,52362233011,52362233120,52362233121,52362233123,52362233301,52362233303,52362301013,52362301120,52362301122,52362301123,52362423330,52362423331,52362423332,52362432300,52362432301,52362432302,52362432310,52362433020,52362433021,52362433022,52362433030,52362433031,52362522010,52362522011,52362522012,52362522100,52363211131,52363211133,52363211311,52363211313,52363211331,52363213111,52363302021,52363302210,52363302211,52363302300,52363302301,52363302303,52363313230,52363313232,52363313300,52363313301,52363313302,52363313310,52363320131,52363320133,52363321200,52363321201,52363321203,52363321221,52363323010,52363323011,52363323100,52363323101,52363330320,52363330321,52363330322,52363331020,52363331022,52363332010,52363400310,52363400320,52363401010,52363401011,52363401012,52363401020,52363401100,52363402030,
118,00,///,492609375,126637500,493889062,127518750,0,4,23,61,108,254,5236771,5236773,5237603,5336071,52366732,52367702,52367703,52367721,52367722,52367723,52376013,52376021,52376120,52376122,52377002,52377003,52377010,52377011,52377020,52377021,52377022,52377100,53360611,53360700,53360701,53360703,53370000,523667303,523667330,523667332,523667333,523676113,523676331,523676333,523677003,523677013,523677201,523677202,523677203,523760023,523760032,523760033,523760112,523760121,523760122,523760123,523760201,523761020,523761022,523761023,523761210,523761212,523761230,523761232,523770000,523770002,523770003,523770012,523770013,523770120,523770121,523770122,523770130,523770131,523770133,523770230,523770231,523770232,523770300,523771010,523771012,523771020,533606131,533607020,533607021,533607023,533607300,533607301,533607310,533607311,533607312,533607332,533700010,533700012,533700020,533700021,533700022,533700030,5236673003,5236673012,5236673013,5236673021,5236673022,5236673023,5236673102,5236673120,5236673122,5236673123,5236673132,5236673310,5236673312,5236761123,5236761301,5236761310,5236761311,5236761313,5236761331,5236761333,5236763133,5236763321,5236763323,5236770020,5236770022,5236770023,5236770120,5236770122,5236770123,5236772001,5236772003,5237600303,5237600312,5237600313,5237601132,5237601133,5237601202,5237601203,5237602001,5237602031,5237602220,5237602222,5237602301,5237602310,5237602311,5237602313,5237610022,5237610212,5237610322,5237610323,5237612130,5237612132,5237612133,5237612310,5237612312,5237612330,5237612332,5237612333,5237700010,5237700012,5237700013,5237700102,5237700103,5237700111,5237700112,5237700113,5237701230,5237701231,5237701232,5237701320,5237701321,5237701323,5237702330,5237702331,5237702333,5237703020,5237703101,5237703110,5237703202,5237703220,5237703222,5237710110,5237710112,5237710210,5237710211,5237710220,5237710221,5237710222,5237710300,5237710301,5336061301,5336061331,5336070220,5336070221,5336072111,5336073021,5336073030,5336073031,5336073033,5336073130,5336073131,5336073132,5336073300,5336073302,5336171110,5337000230,5337000231,5337000232,52366721313,52366721331,52366721332,52366721333,52366723111,52366723113,52366723131,52366723133,52366723311,52366723313,52366723331,52366723333,52366730021,52366730023,52366730201,52366730202,52366730203,52366731032,52366731210,52366731212,52366731213,52366733132,52366733133,52367611132,52367611133,52367611211,52367611212,52367611213,52367611221,52367611223,52367613120,52367613121,52367613123,52367613301,52367631110,52367631111,52367631313,52367631321,52367631323,52367633033,52367633201,52367633203,52367633221,52367633223,52367700020,52367700022,52367700113,52367700131,52367700132,52367700133,52367700211,52367700212,52367700213,52367701022,52367701023,52367701111,52367701113,52367701123,52367701131,52367701132,52367701133,52367701210,52367701212,52367701213,52367720000,52367720001,52367720003,52367720021,52367720023,52376002120,52376002121,52376002123,52376002231,52376002233,52376003003,52376003010,52376003012,52376003013,52376003021,52376003022,52376003023,52376003102,52376003103,52376003111,52376003112,52376003113,52376010313,52376010323,52376010331,52376010332,52376010333,52376011302,52376012000,52376012002,52376012003,52376012011,52376012012,52376012013,52376020031,52376020300,52376020301,52376020303,52376020321,52376020330,52376020331,52376020333,52376022022,52376022023,52376022032,52376022210,52376022212,52376022230,52376022232,52376022233,52376023000,52376023001,52376023031,52376023311,52376023332,52376023333,52376100202,52376100203,52376100232,52376102102,52376102132,52376103202,52376103322,52376121100,52376121102,52376121120,52376121122,52376121123,52376121312,52376123130,52376123132,52376123310,52376123312,52376123313,52376132222,52377000110,52377000112,52377012330,52377012331,52377013220,52377013221,52377023320,52377023321,52377023322,52377030100,52377030102,52377030103,52377030120,52377030122,52377030123,52377030210,52377030220,52377030221,52377030222,52377031110,52377031111,52377032000,52377032002,52377032032,52377032210,52377032212,52377101110,52377101111,52377101112,52377101300,52377101302,52377101303,52377101320,52377101321,52377101322,52377102120,52377102121,52377102122,52377102130,52377102131,52377102230,52377103020,52377103021,52377103030,52377103100,53360610310,53360610311,53360610313,53360610331,53360610333,53360612111,53360613000,53360613001,53360613003,53360613030,53360613031,53360613301,53360702221,53360702230,53360702231,53360702233,53360721101,53360721131,53360730201,53360730320,53360730321,53360732111,53360732113,53360732131,53360732133,53360732311,53360732313,53360732331,53360732333,53360733010,53360733011,53360733012,53360733030,53360733032,53360733033,53360733100,53360733101,53360733300,53360733302,53360733320,53360733322,53361711000,53361711001,53361711010,53361711011,53361711112,53370001100,53370001102,53370001111,53370001120,53370001122,53370001300,53370001320,53370001322,53370002330,53370002331,53370003100,53370003102,53370003120,53370003200,53370010000,53370020000,53370020001,53370020002,53370020010,53370020011,53370020020,53370020022,53370020100,53370020200,
119,00,ǻ,493368750,126787500,495478125,128868750,3,22,45,124,248,501,533702,533703,533713,5237712,5237713,5237722,5237723,5237732,5237733,5337010,5337011,5337040,5337042,5337120,5337121,5337123,5337140,5337142,5337230,5337231,5337233,5337331,5337333,5337432,5337240,52377033,52377112,52377113,52377213,52377301,52377302,52377303,52377310,52377312,52377313,52377420,52377422,52377423,53370011,53370131,53370133,53370410,53370412,53371111,53371221,53371410,53371412,53371430,53371432,53371433,53372210,53372211,53372213,53372321,53372323,53372420,53372422,53373301,53374231,53374233,53374301,53374302,53374303,53374310,53374312,53374330,53375211,53375300,53372410,53372421,523763223,523763232,523763233,523763322,523763323,523770303,523770312,523770313,523770321,523770323,523771023,523771032,523771033,523771100,523771102,523771103,523771112,523772022,523772113,523772123,523773001,523773002,523773003,523773110,523773112,523773113,523774020,523774022,523774023,523774032,523774210,523774212,523774322,533700101,533700102,533700103,533700120,533700121,533700122,533700130,533700131,533700300,533701210,533701211,533701300,533701301,533701303,533701321,533701323,533704300,533704302,533704320,533704322,533704323,533704330,533704331,533704332,533711103,533711121,533711130,533711131,533711132,533712201,533712203,533712230,533712231,533712233,533714110,533714310,533714312,533714313,533722011,533722013,533722120,533722121,533722311,533722313,533723200,533723201,533724110,533724111,533724112,533733030,533733031,533733033,533733211,533733213,533733231,533733232,533733233,533734000,533734002,533734020,533734022,533734200,533734202,533734203,533734220,533734221,533734222,533742131,533742133,533743001,533743002,533743003,533743110,533743111,533743112,533743130,533743132,533743310,533743320,533743322,533752131,533752133,533753010,533753011,533753020,533753022,533724120,533724122,533724121,533724230,533724231,5237632133,5237632302,5237632311,5237632312,5237632313,5237633200,5237633202,5237633203,5237633322,5237703011,5237703013,5237703023,5237703100,5237703102,5237703103,5237703112,5237703113,5237703201,5237703223,5237710113,5237710131,5237710133,5237710311,5237710312,5237710313,5237711012,5237711013,5237711130,5237711132,5237711133,5237720200,5237720202,5237720232,5237720233,5237720322,5237720323,5237720332,5237720333,5237721103,5237721120,5237721121,5237721123,5237721212,5237721213,5237721221,5237721222,5237721223,5237730003,5237731112,5237731113,5237740020,5237740022,5237740023,5237740210,5237740212,5237740330,5237740331,5237740332,5237742110,5237742112,5237742130,5237742132,5237743200,5237743202,5237743203,5237743230,5237743232,5237743233,5337000113,5337000131,5337000133,5337000311,5337000313,5337000333,5337001001,5337001002,5337001003,5337001230,5337001320,5337001321,5337001331,5337012000,5337012120,5337012121,5337012130,5337012131,5337013020,5337013021,5337013023,5337013201,5337013203,5337041100,5337041102,5337041120,5337041122,5337041300,5337043010,5337043011,5337043012,5337043211,5337043212,5337043213,5337043330,5337043332,5337052200,5337052202,5337111011,5337111013,5337111231,5337111232,5337111233,5337111330,5337111331,5337113010,5337113011,5337113013,5337113100,5337113101,5337113103,5337122001,5337122003,5337122021,5337122210,5337122211,5337122213,5337122320,5337122321,5337122323,5337141110,5337141120,5337141121,5337141122,5337141322,5337143112,5337220101,5337220103,5337220121,5337220122,5337220123,5337220211,5337220300,5337220301,5337220310,5337220311,5337220313,5337221230,5337221231,5337221233,5337223100,5337223101,5337223103,5337223121,5337232020,5337232021,5337232022,5337232030,5337232031,5337232033,5337232211,5337232233,5337241130,5337241132,5337241301,5337330011,5337330012,5337330013,5337330030,5337330031,5337330033,5337330320,5337330321,5337330323,5337332101,5337332103,5337332121,5337332122,5337332123,5337332232,5337332233,5337332301,5337332303,5337340010,5337340011,5337340012,5337340232,5337342010,5337342012,5337342120,5337342122,5337342230,5337342231,5337342232,5337342300,5337342302,5337421131,5337421133,5337421303,5337421321,5337421322,5337421323,5337423011,5337423013,5337423031,5337423033,5337423211,5337423213,5337423230,5337423231,5337423233,5337430001,5337430002,5337430003,5337431130,5337431131,5337431132,5337431310,5337431312,5337433120,5337433122,5337433210,5337433211,5337433212,5337433230,5337433232,5337440000,5337440001,5337440002,5337440010,5337521011,5337521013,5337521301,5337521303,5337530120,5337530121,5337530122,5337530130,5337531010,5337241300,5337242320,5337242321,5337242330,5337242331,5337243220,5337242332,5337243020,5337243002,5337243000,5337243202,52376321310,52376321312,52376321313,52376321321,52376321323,52376322033,52376322122,52376322123,52376322132,52376322133,52376322211,52376322213,52376322231,52376323003,52376323030,52376323032,52376323033,52376323101,52376323102,52376323103,52376330202,52376330220,52376330222,52376330223,52376332010,52376332012,52376332013,52376332120,52376332122,52376332123,52376332132,52376333202,52376333232,52377012332,52377012333,52377013222,52377013223,52377023323,52377030101,52377030121,52377030211,52377030212,52377030213,52377030223,52377031112,52377031113,52377032001,52377032003,52377032030,52377032031,52377032033,52377032211,52377032213,52377101113,52377101301,52377101323,52377102123,52377102132,52377102133,52377102231,52377102232,52377102233,52377103022,52377103023,52377103031,52377103032,52377103033,52377103101,52377103102,52377103103,52377110100,52377110102,52377110103,52377111020,52377111022,52377111023,52377111032,52377111033,52377111122,52377111310,52377111312,52377200220,52377200222,52377200223,52377200232,52377202010,52377202012,52377202030,52377202032,52377202033,52377202300,52377202302,52377202303,52377202312,52377203202,52377203203,52377203212,52377211021,52377211022,52377211023,52377211120,52377211122,52377211123,52377211132,52377211133,52377211221,52377211223,52377212033,52377212103,52377212111,52377212112,52377212113,52377212202,52377212203,52377300011,52377300013,52377300021,52377300022,52377300023,52377311102,52377400212,52377403022,52377403023,52377403032,52377403033,52377403122,52377403123,52377403330,52377403332,52377421110,52377421112,52377421130,52377421132,52377421310,52377421312,52377421330,52377421332,52377421333,52377430222,52377432120,52377432122,52377432123,52377432310,52377432312,52377433222,52377433223,52377433232,53370001101,53370001103,53370001110,53370001112,53370001113,53370001121,53370001123,53370001301,53370001302,53370001303,53370001321,53370001323,53370003101,53370003103,53370003121,53370003310,53370003311,53370003313,53370010001,53370010002,53370010003,53370012310,53370012311,53370012312,53370012320,53370012322,53370013300,53370013301,53370013302,53370013331,53370013333,53370021111,53370021113,53370021131,53370030200,53370030201,53370030203,53370030210,53370030212,53370030221,53370030223,53370030230,53370031111,53370032000,53370032001,53370032002,53370120010,53370120011,53370120110,53370120111,53370120113,53370121221,53370121230,53370121232,53370130220,53370130221,53370130223,53370132001,53370132003,53370132210,53370132211,53370132213,53370132231,53370132233,53370413020,53370413022,53370413200,53370413202,53370413220,53370413222,53370430333,53370431000,53370431222,53370431223,53370431232,53370431233,53370431322,53370431323,53370431330,53370431332,53370431333,53370432102,53370432103,53370433310,53370433312,53370433330,53371110100,53371110101,53371110103,53371110121,53371110123,53371112033,53371112300,53371112301,53371112303,53371113320,53371113321,53371113322,53371113330,53371113331,53371113333,53371130121,53371130311,53371131020,53371131021,53371131022,53371131111,53371220000,53371220001,53371220003,53371220021,53371220230,53371220231,53371222121,53371222123,53371222301,53371222310,53371222311,53371222313,53371223220,53371223221,53371223223,53371411120,53371411121,53371411122,53371411230,53371411231,53371411300,53371413000,53371413200,53371413202,53371413203,53371413230,53371413232,53371413233,53371431100,53371431102,53371431103,53371431132,53371431133,53371520022,53371520023,53371520200,53371520201,53371520202,53371520220,53371520222,53371522000,53372200333,53372201001,53372201023,53372201201,53372201202,53372201203,53372202131,53372203020,53372203021,53372203030,53372203031,53372203120,53372203121,53372203311,53372212200,53372212211,53372212321,53372230111,53372231021,53372231023,53372231201,53372231203,53372231221,53372231230,53372231231,53372231233,53372320230,53372320231,53372320320,53372320321,53372322131,53372322133,53372322311,53372322313,53372411310,53372411311,53372411312,53372411330,53372411332,53372413100,53372413101,53372413102,53372423220,53372423222,53372500000,53372500002,53372500020,53373300101,53373300103,53373300320,53373300321,53373300323,53373302110,53373302111,53373302113,53373303221,53373320333,53373321201,53373321202,53373321203,53373322232,53373322233,53373322312,53373322313,53373323000,53373323001,53373323003,53373323021,53373323023,53373400130,53373400300,53373400302,53373402302,53373402303,53373420112,53373420130,53373420132,53373422330,53373422331,53373422332,53373423010,53373423012,53373423200,53373423202,53374211131,53374211132,53374211133,53374211321,53374211322,53374211323,53374212331,53374212332,53374212333,53374213003,53374213012,53374213013,53374213021,53374213022,53374213023,53374213201,53374213202,53374213203,53374230101,53374230303,53374230321,53374230323,53374232101,53374232103,53374232121,53374232123,53374232320,53374232321,53374232323,53374300001,53374300002,53374300003,53374311330,53374311332,53374313110,53374313112,53374313130,53374313300,53374313301,53374313302,53374313322,53374331100,53374331102,53374331120,53374331122,53374331210,53374331211,53374331212,53374331230,53374332130,53374332131,53374332132,53374332310,53374332312,53374332313,53374332330,53374332332,53374333000,53374333002,53374400030,53374400031,53374400032,53374400200,53375210101,53375210310,53375210311,53375210313,53375213001,53375213003,53375213211,53375213213,53375231110,53375231111,53375301230,53375301231,53375301232,53375301310,53375301312,53375301320,53375302100,53375302300,53375302302,53375302320,53375302322,53375310000,53375310001,53375310002,53375310010,53375310011,53375310110,53375320000,53375320001,53375320003,53375320010,53375320011,53375320100,53372423221,53372423230,53372423231,53372423332,53372423331,53372432220,53372432221,53372432002,53372432000,53372430222,53372430220,53372430221,53372430212,53372430210,53372430032,53372430030,53372430012,53372430010,53372412320,53372412302,53372412300,53372412301,53372412310,53372413020,53372413021,53372423330,
120,00,¿Ⱦ//,492187500,124650000,494296875,126046875,7,10,39,37,91,206,523710,523627,523617,523626,523616,523606,523607,5236370,5237200,5237110,5237002,5237111,5236361,5236360,5237003,5136773,5136772,52363710,52363711,52363712,52363720,52363730,52371120,52371121,52371133,52372010,52372012,52372111,52371131,52371220,52371130,52371202,52370123,52370122,52370002,52370000,51377022,52370003,52370012,52370132,52363621,52363630,52363631,52363633,52362533,51367633,52362531,52362513,52362511,52361533,52361531,52361513,51367632,51367631,52361511,52360533,523637130,523637131,523637132,523637211,523637220,523637310,523637321,523711220,523711321,523711323,523712212,523712220,523712221,523712222,523720112,523720130,523720132,523720200,523720201,523720202,523720210,523720211,523720220,523720222,523720300,523720301,523721101,523721130,523722000,523730000,523730001,523730002,523712210,523636320,523636321,523636323,523646110,5236371330,5236371331,5236372100,5236372101,5236372102,5236372131,5236372133,5236372210,5236372220,5236372221,5236372222,5236373120,5236373121,5236373122,5236373200,5236373201,5236373231,5236373300,5236373302,5236373303,5236373320,5236373321,5236461110,5236461111,5237112210,5237112211,5237112212,5237112220,5237112221,5237112222,5237112300,5237112310,5237112311,5237113200,5237113201,5237113203,5237113223,5237122230,5237122231,5237122232,5237122300,5237122301,5237122302,5237122320,5237122321,5237201100,5237201101,5237201102,5237201110,5237201132,5237201133,5237201310,5237201330,5237201332,5237201333,5237202030,5237202121,5237202130,5237202131,5237202133,5237202232,5237202233,5237202311,5237203100,5237203102,5237203121,5237203130,5237203132,5237203202,5237210000,5237210222,5237210223,5237211030,5237211031,5237211033,5237211211,5237211213,5237211310,5237211311,5237212000,5237212001,5237212003,5237220020,5237220022,5237220200,5237300100,5237300200,5237300201,5237300202,5236461011,5236461013,52363721030,52363721031,52363721033,52363721200,52363721201,52363721202,52363721220,52363721300,52363721301,52363722120,52363722122,52363722230,52363722300,52363722302,52363731230,52363731231,52363731232,52363732021,52363732030,52363732031,52363732033,52363732211,52363732300,52363732301,52363732303,52363732330,52363732331,52363732333,52363733010,52363733012,52363733013,52363733220,52363733221,52363733230,52363733231,52364611120,52364611121,52364611130,52364700000,52371122130,52371122131,52371122230,52371122231,52371122232,52371122300,52371122301,52371122302,52371122320,52371123011,52371123020,52371123120,52371123121,52371123130,52371123131,52371123132,52371132020,52371132211,52371132212,52371132213,52371221122,52371221300,52371221302,52371221320,52371222330,52371222331,52371222332,52371223030,52371223032,52371223033,52371223122,52371223123,52371223220,52371223221,52371223230,52371223231,52371223300,52371223301,52371223302,52371223320,52372011030,52372011032,52372011033,52372011110,52372011111,52372011122,52372011300,52372011311,52372011312,52372011313,52372013110,52372013111,52372013122,52372013123,52372013130,52372013131,52372013312,52372020310,52372020311,52372020312,52372020320,52372020322,52372021201,52372021231,52372021320,52372021321,52372021323,52372022100,52372022102,52372022122,52372022300,52372022302,52372022303,52372022312,52372023101,52372023131,52372030200,52372030202,52372030220,52372030222,52372030311,52372031010,52372031012,52372031030,52372031032,52372031033,52372031110,52372031111,52372031113,52372031122,52372031123,52372031200,52372031201,52372031203,52372031230,52372031231,52372031233,52372032000,52372032002,52372032200,52372032201,52372032203,52372033100,52372033101,52372033102,52372100010,52372100020,52372100202,52372100220,52372100222,52372102202,52372102203,52372102212,52372110011,52372110013,52372110031,52372110033,52372110210,52372110211,52372110213,52372110231,52372110320,52372110321,52372110323,52372112101,52372112103,52372112121,52372113120,52372113121,52372113130,52372113200,52372113201,52372113210,52372113211,52372120020,52372120021,52372120023,52372120210,52372120211,52372200100,52372200101,52372200102,52372200210,52372200212,52372200230,52373000300,52373000311,52373001020,52373001021,52373001022,52373001200,52373001202,52373002030,52373002200,52371221120,52371221102,52371221100,52363632211,52363632213,52364610101,52364610103,52364610100,52363632231,52363632210,52364610311,52364610310,52364610121,
121,00,˭/¾/ë/,493129687,125325000,495295312,127031250,7,9,38,108,204,506,523731,523732,523741,523742,523751,523752,523762,5237213,5237301,5237302,5237303,5237401,5237403,5237532,5237611,5237630,52372101,52372103,52372121,52372122,52372123,52372222,52372223,52372232,52372233,52372322,52373003,52373300,52374000,52374001,52374003,52374302,52374320,52374322,52374323,52375011,52375013,52375300,52375302,52375303,52376101,52376130,52376131,52376133,52376320,52377201,52377210,52376422,52376420,52376421,52376331,52376403,52376312,52376310,523637311,523637313,523637331,523637333,523711232,523711233,523720230,523720232,523720233,523720321,523720323,523720330,523720332,523720333,523721001,523721003,523721020,523721021,523721023,523721120,523721122,523721123,523721133,523721201,523721203,523722200,523722202,523722203,523722212,523722213,523722302,523723232,523730011,523730013,523730021,523730023,523733020,523733021,523733022,523733200,523733202,523733220,523733222,523740021,523740211,523740213,523743000,523743002,523743003,523743012,523743030,523743032,523743210,523743212,523743213,523750101,523750310,523750311,523750313,523750331,523750333,523753010,523753012,523753302,523753303,523753320,523753321,523753322,523760111,523761000,523761001,523761003,523761030,523761031,523761320,523761321,523761323,523763210,523763211,523763212,523763300,523763303,523772000,523772001,523772003,523772021,523772030,523772031,523774003,523774012,523763301,523763132,523763130,523763112,523763133,523764022,523764023,523764021,523764232,523764230,523774010,523774001,523763331,523763330,523763333,523774000,523764122,523764120,5236371332,5236371333,5236471111,5236471113,5236471131,5237112231,5237112233,5237112303,5237113220,5237113222,5237201113,5237202033,5237202122,5237202211,5237202213,5237202312,5237203021,5237203023,5237203030,5237203032,5237203033,5237203110,5237203113,5237203122,5237203131,5237203133,5237203201,5237203203,5237203221,5237203222,5237203223,5237203311,5237203312,5237203313,5237210003,5237210021,5237210023,5237211000,5237211002,5237211020,5237211022,5237211322,5237211323,5237212020,5237212022,5237212023,5237220202,5237220220,5237220222,5237220223,5237222013,5237222102,5237222103,5237222113,5237223002,5237223030,5237223032,5237223033,5237223132,5237223133,5237232021,5237232022,5237232023,5237232030,5237232032,5237232033,5237300032,5237300033,5237300101,5237300103,5237300121,5237300122,5237300123,5237300221,5237300222,5237300223,5237330100,5237330122,5237330230,5237330231,5237330232,5237330300,5237332012,5237332030,5237332032,5237332033,5237332232,5237400201,5237400203,5237400231,5237400233,5237402100,5237402101,5237402103,5237402311,5237402313,5237402331,5237430010,5237430012,5237430013,5237430130,5237430132,5237430310,5237430312,5237430313,5237430330,5237430332,5237432110,5237432112,5237433022,5237433200,5237433202,5237433220,5237501000,5237501001,5237503121,5237503123,5237503301,5237503303,5237503321,5237503323,5237530110,5237530111,5237530112,5237530130,5237530132,5237531202,5237531220,5237531222,5237533000,5237533002,5237533012,5237533230,5237601101,5237601103,5237601131,5237610021,5237610211,5237610321,5237610330,5237610331,5237610333,5237612111,5237612113,5237612311,5237613220,5237613221,5237613223,5237632130,5237632200,5237632201,5237632202,5237632210,5237632211,5237632220,5237632222,5237632301,5237633021,5237633023,5237633210,5237633211,5237711011,5237711100,5237711101,5237711110,5237711111,5237711113,5237720020,5237720021,5237720330,5237720331,5237721100,5237721101,5237721110,5237721111,5237721200,5237721201,5237721202,5237730000,5237643001,5237643020,5237740313,5237740213,5237740211,5237740300,5237740301,5237740310,5237740132,5237740130,5237731111,5237633321,5237642310,5237640033,5237640032,5237640023,5237640201,5237640203,5237631312,5237631102,5237631100,5237533233,5237533232,5237643002,5237643000,52363731233,52363733011,52364711100,52364711101,52364711103,52364711330,52364711331,52371122132,52371122133,52371122233,52371122303,52371122321,52371122322,52371122323,52371123010,52371123012,52371123013,52371123021,52371123022,52371123023,52371123122,52371123123,52371123133,52371132021,52371132022,52371132023,52371132210,52372011031,52372011112,52372011113,52372011120,52372011121,52372011123,52372011301,52372011302,52372011303,52372011310,52372013112,52372013113,52372013120,52372013121,52372013132,52372013133,52372013310,52372013311,52372013313,52372020313,52372020321,52372020323,52372021200,52372021202,52372021203,52372021230,52372021232,52372021233,52372021322,52372022101,52372022103,52372022120,52372022121,52372022123,52372022301,52372022310,52372022311,52372022313,52372023100,52372023102,52372023103,52372023130,52372023132,52372023133,52372030201,52372030203,52372030221,52372030223,52372030310,52372030312,52372030313,52372031011,52372031013,52372031031,52372031112,52372031120,52372031121,52372031202,52372031232,52372032001,52372032003,52372032202,52372033103,52372100011,52372100012,52372100013,52372100021,52372100022,52372100023,52372100200,52372100201,52372100203,52372100221,52372100223,52372102200,52372102201,52372102210,52372102211,52372102213,52372110010,52372110012,52372110030,52372110032,52372110212,52372110230,52372110232,52372110233,52372110322,52372112100,52372112102,52372112120,52372112122,52372112123,52372113122,52372113123,52372113131,52372113132,52372113133,52372113202,52372113203,52372113212,52372113213,52372120022,52372120212,52372120213,52372202030,52372202032,52372202210,52372202212,52372220120,52372220122,52372220123,52372221002,52372221003,52372221012,52372221110,52372221112,52372221113,52372221121,52372221122,52372221123,52372230032,52372230312,52372231123,52372231213,52372231220,52372231222,52372231223,52372231231,52372231232,52372231233,52372231301,52372231302,52372231303,52372231310,52372231312,52372231313,52372320033,52372320121,52372320122,52372320123,52372320132,52372320202,52372320310,52372320312,52372320313,52372323020,52372323022,52372323023,52372323032,52372323033,52373000301,52373000302,52373000303,52373000310,52373000312,52373000313,52373001023,52373001201,52373001203,52373002031,52373002032,52373002033,52373002201,52373002202,52373002203,52373301010,52373301011,52373301012,52373302330,52373302331,52373302332,52373303020,52373303202,52373303220,52373320100,52373320101,52373320102,52373320310,52373320312,52373322100,52373322300,52373322302,52374002001,52374002300,52374002301,52374002303,52374020111,52374020113,52374021020,52374021021,52374021210,52374021211,52374021213,52374023100,52374023101,52374023103,52374023121,52374023123,52374023330,52374023331,52374023333,52374300110,52374300112,52374301022,52374301023,52374301031,52374301032,52374301033,52374301122,52374301123,52374303112,52374303310,52374303311,52374303312,52374303330,52374303332,52374321110,52374321112,52374321130,52374321132,52374321133,52374330202,52374330232,52374332010,52374332012,52374332030,52374332032,52374332210,52374332220,52374332222,52375001111,52375001113,52375010020,52375010021,52375010023,52375010030,52375010031,52375010033,52375010310,52375010311,52375010313,52375010331,52375010333,52375012111,52375012113,52375012131,52375012133,52375012311,52375012331,52375012333,52375030131,52375030133,52375031200,52375031201,52375031203,52375033023,52375033201,52375033203,52375033221,52375033223,52375301130,52375301131,52375301132,52375301310,52375301312,52375301330,52375301332,52375301333,52375312000,52375312002,52375312003,52375312032,52375312210,52375312212,52375312230,52375312232,52375330010,52375330012,52375330032,52375330033,52375330132,52375331202,52375331220,52375331222,52375331223,52375332310,52375333000,52375333001,52375333002,52375333020,52376011023,52376011300,52376011301,52376011303,52376100200,52376100201,52376100230,52376100231,52376100233,52376102100,52376102101,52376102103,52376102130,52376102131,52376102133,52376103200,52376103201,52376103203,52376103320,52376103321,52376103323,52376121101,52376121103,52376121121,52376121310,52376121311,52376121313,52376123131,52376123133,52376123311,52376132220,52376132221,52376132223,52376321311,52376321320,52376321322,52376322030,52376322031,52376322032,52376322120,52376322121,52376322130,52376322131,52376322210,52376322212,52376322230,52376322232,52376322233,52376323000,52376323001,52376323002,52376323031,52376323100,52376330200,52376330201,52376330203,52376330221,52376332011,52376332121,52376332130,52376332131,52376332133,52377110101,52377111021,52377111030,52377111031,52377111120,52377111121,52377111123,52377111311,52377111313,52377200221,52377200230,52377200231,52377200233,52377202011,52377202013,52377202031,52377202301,52377202310,52377202311,52377202313,52377203200,52377203201,52377203210,52377203211,52377203213,52377211020,52377211121,52377211130,52377211131,52377211220,52377211222,52377212030,52377212031,52377212032,52377212100,52377212101,52377212102,52377212110,52377212200,52377212201,52377300010,52377300012,52377300020,52375332312,52375332313,52375333220,52375333222,52375333223,52376311012,52376311030,52376311032,52376311033,52376313100,52376311322,52376313102,52376313103,52376313130,52376313133,52376313132,52376402022,52376402023,52376402001,52376400223,52376400221,52376400303,52376400301,52376400312,52376401220,52376401222,52376401223,52376401322,52376401323,52376401332,52376401333,52376410222,52376410223,52376410232,52376410233,52376410322,52376412100,52376430210,52376430032,52376430031,52376430030,52376430222,52376430220,52376423111,52376423110,52376423121,52376423302,52376423300,52376423122,52376423120,52377412200,52377412022,52377412020,52377403112,52377403121,52377401330,52377401312,52377401310,52377401123,52377401122,52377403021,52377403020,52377403030,52377403031,52377403120,52377400213,52377400211,52377400210,52376333200,52376333201,52376333203,52376333230,52376333231,52376333233,52377311100,52377311101,52377311103,52373301020,52373301022,52373301200,52373301202,52373301203,52376400313,
122,00,˭//,493200000,124350000,496195312,126815625,6,31,58,85,186,443,523734,523744,523754,523755,513771,523702,5237030,5237032,5237123,5237130,5237132,5237221,5237230,5237231,5237233,5237242,5237243,5237331,5237333,5237352,5237431,5237450,5237452,5237651,5137732,5137723,5137722,5137720,5137612,5137701,5137603,5137602,5137700,5137703,5237011,5237121,5237010,52370310,52370312,52370330,52370332,52371310,52371312,52371330,52371332,52372201,52372203,52372321,52372402,52372403,52372412,52373321,52373323,52373502,52374331,52374333,52374512,52374530,52374532,52374533,52375310,52375311,52375313,52375602,52375620,52375622,52375623,52376411,52376500,52376501,52376503,52376600,51377332,51377330,51377212,51377213,51377302,51377331,51376132,51376133,51377021,51377023,52370011,52370010,52370131,52371203,52371201,52370133,52370130,52371200,51377020,52370001,52370121,52370013,52370120,523703112,523703130,523703132,523703310,523703312,523713132,523713310,523713312,523713330,523713332,523713333,523722003,523722021,523722023,523722301,523722310,523723231,523723233,523724000,523724002,523724003,523724012,523725202,523725220,523725222,523733011,523733013,523733031,523733033,523735000,523735002,523735003,523735032,523735302,523735320,523735322,523743300,523743301,523743303,523743321,523743323,523745100,523745102,523745310,523745312,523746222,523753121,523753123,523753310,523753311,523753313,523753331,523753333,523756000,523756002,523756003,523756012,523756030,523756032,523756210,523756212,523756213,523764131,523765020,523765021,523765211,523765300,523765301,523766010,523766012,523766020,523766021,523766022,523766030,523766031,523763111,523764000,523764001,523764010,523764011,523764100,523764101,523703110,513773332,513773330,5237031132,5237031310,5237031312,5237031330,5237031332,5237033110,5237033300,5237033302,5237033320,5237033322,5237122131,5237122133,5237122310,5237122311,5237122313,5237122331,5237122333,5237131100,5237131102,5237131120,5237131122,5237131300,5237131302,5237131303,5237131330,5237131332,5237133110,5237133112,5237133130,5237133132,5237133310,5237133312,5237133313,5237142222,5237220011,5237220012,5237220013,5237220201,5237222010,5237222011,5237222110,5237223000,5237223001,5237223110,5237223111,5237223113,5237223120,5237232000,5237232001,5237232002,5237232010,5237232011,5237232300,5237232301,5237240010,5237240012,5237240013,5237240103,5237240132,5237240133,5237241022,5237241023,5237241032,5237241033,5237241322,5237241323,5237252002,5237252230,5237252232,5237330121,5237330123,5237330301,5237330303,5237330321,5237330323,5237332011,5237332013,5237332211,5237332212,5237332213,5237332231,5237350010,5237350012,5237350013,5237350302,5237350330,5237350332,5237350333,5237353000,5237353002,5237430100,5237430101,5237430110,5237430111,5237430113,5237430131,5237430133,5237433021,5237433223,5237451032,5237451322,5237453130,5237453132,5237453133,5237462200,5237462202,5237462203,5237462230,5237462232,5237531201,5237533010,5237533011,5237533121,5237533123,5237533301,5237533303,5237560010,5237560012,5237560310,5237562113,5237563201,5237563202,5237563220,5237563222,5237563223,5237641211,5237641300,5237641301,5237641303,5237641331,5237650220,5237650221,5237650230,5237650231,5237652101,5237652103,5237652130,5237652131,5237653020,5237653021,5237653030,5237653031,5237653100,5237653101,5237653110,5237653111,5237660110,5237660111,5237660112,5237660130,5237660132,5237661000,5237661022,5237661200,5237661202,5237661220,5237661223,5237662000,5237662001,5237640020,5237640021,5237631311,5237533320,5237533321,5237533323,5237631130,5237631131,5237631133,5237640120,5237640121,5237640123,5237640130,5237640131,5237641020,5237641021,5237641030,5237641031,5237641033,5237332233,5237330103,5137733332,5137733330,5137733312,5137733310,5237122113,5237122111,52370311102,52370311120,52370311122,52370311300,52370311302,52370313132,52370313310,52370331120,52370333010,52370333012,52370333030,52370333032,52370333033,52370333210,52370333212,52371221123,52371221301,52371221303,52371221321,52371221322,52371221323,52371222333,52371223031,52371223120,52371223121,52371223222,52371223223,52371223232,52371223233,52371223303,52371223321,52371223322,52371223323,52371311012,52371311030,52371311032,52371311210,52371311212,52371311230,52371311232,52371313010,52371313012,52371313122,52371313310,52371313312,52371313330,52371313332,52371331110,52371331112,52371331130,52371331132,52371331332,52371333110,52371333112,52371333113,52371422020,52371422022,52371422200,52371422202,52371422232,52371422233,52371422322,52372200103,52372200211,52372200213,52372200231,52372200232,52372200233,52372202031,52372202033,52372202211,52372202213,52372220121,52372221000,52372221001,52372221010,52372221011,52372221013,52372221111,52372221120,52372230030,52372230031,52372230033,52372230310,52372230311,52372230313,52372231120,52372231121,52372231122,52372231210,52372231211,52372231212,52372231221,52372231230,52372231300,52372231311,52372320030,52372320031,52372320032,52372320120,52372320130,52372320131,52372320133,52372320200,52372320201,52372320203,52372320311,52372323021,52372323030,52372323031,52372400112,52372401022,52372401023,52372401300,52372401302,52372401303,52372410213,52372410302,52372410303,52372410312,52372413000,52372413002,52372413020,52372413022,52372413200,52372413202,52372413203,52372413322,52372413323,52372413332,52372520002,52372520003,52372520032,52372520302,52372520320,52372520322,52372522100,52372522102,52372522120,52372522122,52372522123,52372522312,52372522332,52373301013,52373302333,52373303021,52373303022,52373303023,52373303200,52373303201,52373303203,52373303221,52373303222,52373303223,52373320103,52373320311,52373320313,52373322101,52373322102,52373322103,52373322301,52373322303,52373500110,52373500112,52373500113,52373501220,52373501222,52373503000,52373503002,52373503003,52373503030,52373503032,52373503033,52373503121,52373503122,52373503123,52373503132,52373503310,52373503312,52373503313,52373512202,52373512220,52373512222,52373530030,52373530032,52373530122,52373530300,52373530301,52373530302,52373530320,52373532120,52373532122,52373532300,52373532301,52373532302,52374300111,52374300113,52374301020,52374301021,52374301030,52374301120,52374301121,52374303110,52374303111,52374303113,52374303313,52374303331,52374303333,52374321111,52374321113,52374321131,52374330200,52374330201,52374330203,52374330230,52374330231,52374330233,52374332011,52374332013,52374332031,52374332033,52374332211,52374332212,52374332213,52374332221,52374332223,52374510102,52374510120,52374510122,52374510300,52374510302,52374510303,52374510330,52374510332,52374513200,52374513202,52374513203,52374513230,52374513232,52374513233,52374531102,52374531120,52374531122,52374531123,52374531312,52374531313,52374620220,52374620222,52374620223,52374622010,52374622012,52374622013,52374622120,52374622122,52374622123,52374622132,52374622310,52374622312,52374622330,52374622332,52375301133,52375301311,52375301313,52375301331,52375312001,52375312030,52375312031,52375312033,52375312211,52375312213,52375312231,52375312233,52375330011,52375330013,52375330030,52375330031,52375330130,52375330131,52375330133,52375331200,52375331201,52375331203,52375331221,52375332311,52375333003,52375333021,52375333022,52375333023,52375600110,52375600112,52375600130,52375600132,52375600133,52375601032,52375601033,52375601320,52375601322,52375601323,52375603120,52375603122,52375603300,52375603302,52375603320,52375603322,52375621103,52375621112,52375621121,52375621122,52375621123,52375630200,52375630202,52375630220,52375630222,52375632000,52375632002,52375632003,52375632030,52375632031,52375632032,52375632102,52375632120,52375632210,52375632212,52375632213,52376412130,52376412131,52376413020,52376413021,52376413300,52376413301,52376413303,52376502220,52376502221,52376502230,52376502231,52376502331,52376502333,52376520111,52376521000,52376521001,52376521003,52376521021,52376521023,52376521201,52376521210,52376521211,52376521330,52376521331,52376530220,52376530221,52376530230,52376530231,52376530320,52376530321,52376531020,52376531021,52376531022,52376531030,52376531031,52376531120,52376531121,52376531200,52376531202,52376601130,52376601131,52376601132,52376601310,52376601312,52376601330,52376601332,52376601333,52376602300,52376602301,52376602302,52376603201,52376603210,52376603211,52376603301,52376603310,52376603311,52376603313,52376610010,52376610012,52376612030,52376612032,52376612210,52376612212,52376612213,52376612220,52376612221,52376612302,52376612320,52376612322,52376620021,52376620030,52376620031,52376620102,52376630011,52376630100,52375333221,52376311010,52376311011,52376311013,52376311031,52376313101,52376311320,52376311321,52376311323,52376313131,52376402020,52376402021,52376402000,52376402002,52376402003,52376400220,52376400222,52376400300,52376400302,52376400310,52376400311,52376401221,52376401320,52376401321,52376401330,52376401331,52376410220,52376410221,52376410230,52376410231,52376410320,52376410321,52376410323,52376412101,52376412102,52376412103,52373301023,52373301021,52373301201,52370311101,52370311100,52371221121,52371221101,52371221103,
123,00,;/̾,494915625,124575000,496195312,125887500,3,11,18,34,102,214,523715,523705,523704,5237140,5237141,5237143,5237160,5237162,5237250,5237251,5137753,5137752,5137743,5137742,52370600,52370602,52370620,52370622,52371420,52371421,52371423,52372411,52372521,52372523,52372530,52372531,52372532,51377620,51377602,51377622,51377513,51377512,523703313,523703331,523703333,523706030,523706032,523706210,523706212,523706230,523706232,523706233,523713111,523713113,523714221,523716122,523716302,523716320,523716322,523724011,523724100,523724101,523724131,523725201,523726000,523726001,523726002,523726010,523726020,523726100,523735010,523735011,523735013,523735100,523735102,523735120,5137762300,5137762302,5137762320,5137762322,5237031113,5237031131,5237031133,5237031311,5237031333,5237033111,5237033113,5237033323,5237060100,5237060102,5237060120,5237060122,5237060123,5237060330,5237060332,5237062110,5237062112,5237062130,5237062132,5237062310,5237062312,5237062313,5237131310,5237131311,5237131313,5237133131,5237142200,5237142201,5237142203,5237142221,5237142230,5237142231,5237142233,5237161000,5237161002,5237161020,5237161022,5237161200,5237161202,5237161203,5237163000,5237163001,5237163002,5237240100,5237240101,5237240131,5237241020,5237241301,5237241303,5237241321,5237241330,5237241331,5237252001,5237252031,5237252033,5237252211,5237252213,5237253300,5237253301,5237260030,5237260031,5237260032,5237260110,5237260111,5237260112,5237260121,5237260130,5237260220,5237260221,5237260222,5237261020,5237261021,5237350120,5237350121,5237350123,5237350301,5237350310,5237350311,5237351010,5237351011,5237351012,5237351221,5237351223,5237351232,5237353001,5137762120,5137762100,5137762102,5137760322,5137760320,5137760302,5137760300,5137762122,5237031111,5137733333,5137733331,5137733313,5137733311,51377621230,51377621232,51377623010,51377623012,52370311103,52370311121,52370311123,52370311301,52370311303,52370313130,52370313131,52370313133,52370313311,52370313312,52370313313,52370331121,52370331122,52370331123,52370333011,52370333013,52370333031,52370333211,52370333213,52370601010,52370601012,52370601030,52370601032,52370601210,52370601212,52370601213,52370603122,52370603123,52370621132,52370621310,52370621312,52370621330,52370621332,52370623110,52370623112,52370623113,52370632200,52370632202,52370632220,52370632222,52370632223,52371311010,52371311011,52371311013,52371311031,52371311033,52371311211,52371311213,52371311231,52371311233,52371313011,52371313013,52371313120,52371313121,52371313123,52371313311,52371313313,52371313331,52371313333,52371331111,52371331113,52371331131,52371331133,52371331330,52371331331,52371331333,52371333111,52371422021,52371422023,52371422201,52371422203,52371422230,52371422231,52371422320,52371422321,52371422323,52371610030,52371610032,52371610210,52371610212,52371610230,52371610232,52371612010,52371612012,52371612013,52371612300,52371612302,52371630030,52371630032,52372400110,52372400111,52372400113,52372401020,52372401021,52372401301,52372410210,52372410211,52372410212,52372410300,52372410301,52372410310,52372410311,52372410313,52372413001,52372413003,52372413021,52372413023,52372413201,52372413320,52372413321,52372413330,52372413331,52372413333,52372520000,52372520001,52372520030,52372520031,52372520033,52372520300,52372520301,52372520303,52372520321,52372520323,52372522101,52372522103,52372522121,52372522310,52372522311,52372522313,52372522330,52372522331,52372522333,52372533020,52372533021,52372533100,52372600330,52372601130,52372601132,52372601200,52372601201,52372601231,52372601233,52372601310,52372601312,52372601320,52372601321,52372602100,52372602102,52372602120,52372602122,52372602123,52372602230,52372602231,52372602300,52372602301,52372602302,52372602320,52372610220,52372610221,52372610223,52372610230,52372610231,52372620000,52372620002,52372620020,52373500111,52373501221,52373501223,52373503001,52373503031,52373503120,52373503130,52373503131,52373503133,52373503311,52373510130,52373510131,52373510300,52373510301,52373512100,52373512102,52373512120,52373512122,52373512200,52373512201,52373512203,52373512221,52373512223,52373512300,52373512302,52373530031,52373530033,52373530100,52373530101,52373530102,52373530120,51377621212,51377621210,51377621012,51377621010,51377621032,51377621030,51377603232,51377603230,51377603212,51377603032,51377603210,51377603030,51377603012,51377603010,
123,01,ŷε/̱,495731250,125418750,497010937,127078125,3,9,29,62,137,318,523736,523747,523757,5237263,5237372,5237460,5237461,5237463,5237561,5237670,5237671,5237673,52372603,52372621,52372622,52372623,52372722,52373511,52373513,52373531,52373533,52373700,52373702,52373730,52373732,52373733,52374511,52374621,52374623,52375631,52375633,52376611,52376613,52376721,52377710,52377711,52384020,52384022,52385000,52385002,52386020,523725332,523725333,523726120,523726122,523726123,523726132,523726201,523726202,523726203,523727202,523727203,523737012,523737030,523737032,523737033,523737122,523737310,523737312,523737313,523745130,523745131,523745133,523746200,523746201,523746203,523756011,523756300,523756301,523756303,523756323,523766101,523766103,523766121,523767201,523767203,523767221,523767230,523767231,523767233,523777131,523830220,523830222,523830223,523840000,523840001,523840002,523840020,523840022,523840023,523840210,523840232,523850010,523850012,523850030,523860002,523860020,523860022,523860023,523860220,523860222,523870020,523870022,5237253303,5237253311,5237253312,5237253313,5237260122,5237260133,5237260211,5237260213,5237260231,5237260233,5237261212,5237261213,5237262001,5237262003,5237272002,5237272003,5237272012,5237272122,5237272123,5237272300,5237351031,5237351032,5237351033,5237351211,5237351213,5237351231,5237351233,5237353011,5237353013,5237353031,5237353033,5237353210,5237353211,5237353213,5237353231,5237353232,5237353233,5237370132,5237370310,5237370312,5237370313,5237371202,5237371230,5237371232,5237371233,5237373112,5237451011,5237451013,5237451031,5237451321,5237453111,5237453113,5237462020,5237462021,5237462023,5237462210,5237462211,5237560100,5237560101,5237560102,5237560130,5237560131,5237560133,5237560311,5237560313,5237560331,5237560333,5237563021,5237563023,5237563211,5237563213,5237661002,5237661003,5237661020,5237661021,5237661023,5237661201,5237661231,5237661233,5237663101,5237663110,5237663111,5237672000,5237672001,5237672003,5237672230,5237672231,5237672233,5237672320,5237672321,5237770111,5237770113,5237770131,5237771210,5237771211,5237771300,5237771301,5237771303,5237771321,5237771330,5237771331,5237771333,5238302002,5238302020,5238302022,5238302023,5238302212,5238400030,5238400212,5238400213,5238400320,5238400322,5238400323,5238402120,5238402121,5238402122,5238402300,5238402302,5238402303,5238500130,5238500132,5238500310,5238500320,5238502000,5238502002,5238502020,5238600000,5238600002,5238600210,5238600212,5238600213,5238602210,5238700000,5238700001,5238700022,5238702000,5238702001,52372533022,52372533023,52372533101,52372533102,52372533103,52372600331,52372600332,52372600333,52372601131,52372601133,52372601202,52372601203,52372601230,52372601232,52372601311,52372601313,52372601322,52372601323,52372602101,52372602103,52372602121,52372602232,52372602233,52372602303,52372602321,52372602322,52372602323,52372610222,52372610232,52372610233,52372612100,52372612102,52372612103,52372612112,52372613022,52372613322,52372620001,52372620003,52372620021,52372620022,52372620023,52372720001,52372720002,52372720003,52372720012,52372720013,52372720102,52372720103,52372720130,52372720132,52372720133,52372721200,52372721202,52372721203,52372721212,52372721213,52372723010,52372723011,52372723012,52372723020,52372723021,52372723022,52372723200,52372723202,52373510132,52373510133,52373510302,52373510303,52373512101,52373512103,52373512121,52373512123,52373512301,52373512303,52373530103,52373530121,52373530123,52373530303,52373530321,52373530322,52373530323,52373532121,52373532123,52373532303,52373701002,52373701020,52373701022,52373701023,52373701032,52373701033,52373701300,52373701302,52373701303,52373703110,52373703112,52373703113,52373712032,52373712033,52373712121,52373712122,52373712123,52373712132,52373712310,52373712312,52373712313,52373713220,52373713222,52373713223,52373713231,52373713232,52373713233,52373731130,52373731132,52373731133,52374510100,52374510101,52374510103,52374510121,52374510123,52374510301,52374510331,52374510333,52374513201,52374513231,52374531100,52374531101,52374531103,52374531121,52374531310,52374531311,52374620221,52374622011,52374622121,52374622130,52374622131,52374622133,52374622311,52374622313,52374622331,52374622333,52375600111,52375600113,52375600131,52375601030,52375601031,52375601321,52375603121,52375603123,52375603301,52375603303,52375603321,52375603323,52375621100,52375621101,52375621102,52375621110,52375621111,52375621113,52375621120,52375630201,52375630203,52375630221,52375630223,52375632001,52375632033,52375632100,52375632101,52375632103,52375632121,52375632122,52375632123,52375632211,52376601133,52376601311,52376601313,52376601331,52376610011,52376610013,52376612031,52376612033,52376612211,52376612300,52376612301,52376612303,52376612321,52376612323,52376631000,52376631001,52376631003,52376631030,52376631031,52376631120,52376631121,52376631130,52376720021,52376720211,52376720213,52376720231,52376720233,52376722033,52376722321,52376722323,52376723220,52376723221,52376723222,52376723230,52376723231,52377700110,52377701101,52377701103,52377701331,52377701333,52377712121,52377712130,52377712131,52377713020,52377713021,52377713023,52377713321,52377731110,52377731111,52377731113,52383020003,52383020212,52383022102,52383022130,52383022132,52383022133,52383023200,52383023202,52383023220,52383023221,52383023222,52384000310,52384000312,52384000320,52384000321,52384001000,52384001002,52384001020,52384002100,52384002102,52384002103,52384002110,52384002112,52384002113,52384003020,52384003022,52384003023,52384003210,52384003212,52384003213,52384003302,52384003320,52384003322,52384021100,52384021102,52384021230,52384021232,52384023010,52384023012,52385001102,52385001120,52385001122,52385001330,52385001332,52385003110,52385003210,52385003220,52385003221,52385003222,52385020010,52385020012,52385020030,52385020220,52385020222,52385022000,52385022002,52385022022,52385022200,52385022202,52385022220,52385022222,52385022223,52386000032,52386000320,52386000322,52386002112,52386003202,52386003220,52386003222,52386003223,52386021000,52386021001,52386021002,52386021020,52386021022,52386021200,52386021202,52386021203,52386021220,52386022110,52386022120,52386022322,52387000020,52387000022,52387000100,52387000200,52387000202,52387000203,52387000230,52387000232,52387000233,52387002322,52387020030,52387020031,52387020100,52387020102,
124,00,,491442187,126862500,493073437,128896875,1,16,33,91,216,432,533635,5336051,5336053,5336062,5336063,5336151,5336153,5336160,5336161,5336162,5336251,5336253,5336260,5336343,5336441,5336443,5336450,52367523,52367530,52367532,53360521,53360523,53360720,53360722,53360723,53361501,53361503,53361632,53361700,53362503,53362521,53362523,53362620,53362621,53362622,53363411,53363413,53363600,53363602,53363620,53364510,53364512,53364520,53364521,53364522,53365401,53365410,53365411,53365500,53365502,523675011,523675102,523675120,523675122,523675123,523675211,523675213,523675223,523675312,523675330,523675332,533605011,533605013,533605031,533605033,533605223,533606022,533606033,533606122,533606123,533606132,533607210,533607212,533607213,533607320,533607322,533615001,533615003,533615210,533615211,533615213,533615231,533615233,533616300,533616302,533617010,533617011,533625011,533625012,533625013,533625221,533625222,533625223,533626100,533626101,533626102,533626230,533626232,533634101,533634103,533634121,533634122,533634123,533634213,533634231,533634232,533634233,533636030,533636032,533636210,533636212,533636220,533636221,533636222,533636230,533644010,533644011,533644013,533644031,533644033,533644211,533644213,533644231,533644233,533645110,533645111,533645112,533645230,533645232,533645233,533646000,533654003,533654121,533654130,533654131,533654132,533655010,533655011,533655012,533655030,533655201,5236652332,5236652333,5236750101,5236750103,5236750130,5236750131,5236750133,5236750311,5236750313,5236750331,5236750333,5236751000,5236751002,5236752033,5236752122,5236752123,5236752211,5236752212,5236752213,5236753100,5236753102,5236753312,5236753330,5236753332,5236753333,5336050101,5336050102,5336050103,5336050121,5336050123,5336050301,5336050303,5336050321,5336050323,5336052030,5336052031,5336052033,5336052211,5336052213,5336060020,5336060022,5336060200,5336060202,5336060203,5336060230,5336060232,5336060233,5336060312,5336060313,5336060322,5336060323,5336061202,5336061203,5336061210,5336061212,5336061213,5336061302,5336061332,5336061333,5336072112,5336073022,5336073023,5336073210,5336073212,5336073230,5336150210,5336150211,5336150213,5336150231,5336150233,5336152011,5336152120,5336152121,5336152123,5336152301,5336152303,5336152321,5336152323,5336163010,5336163012,5336163030,5336163032,5336163033,5336163100,5336163101,5336170120,5336170121,5336170122,5336170130,5336170200,5336170201,5336170202,5336170210,5336170220,5336171000,5336171001,5336243232,5336243233,5336243322,5336243323,5336243331,5336243332,5336243333,5336250033,5336250101,5336250102,5336250103,5336250231,5336250233,5336252010,5336252011,5336252013,5336252031,5336252032,5336252033,5336261030,5336261031,5336261032,5336261100,5336261101,5336261200,5336261201,5336262310,5336262311,5336263020,5336263022,5336341001,5336341003,5336341021,5336341023,5336341201,5336341202,5336341203,5336342113,5336342123,5336342233,5336342301,5336342303,5336360100,5336360101,5336360102,5336360120,5336360122,5336360123,5336360132,5336360310,5336360312,5336360330,5336360332,5336362110,5336362112,5336362130,5336362132,5336362230,5336362231,5336362232,5336362310,5336362312,5336362320,5336440011,5336440013,5336440031,5336440120,5336440121,5336440123,5336440301,5336440303,5336440321,5336440323,5336442100,5336442101,5336442103,5336442121,5336442123,5336442301,5336442303,5336442321,5336442322,5336442323,5336451130,5336451131,5336451300,5336451302,5336451320,5336451322,5336452310,5336452312,5336453000,5336453001,5336453002,5336453010,5336453011,5336460010,5336460012,5336540011,5336540013,5336540210,5336540211,5336540213,5336540231,5336540300,5336540301,5336540302,5336540310,5336540311,5336540313,5336541200,5336541201,5336541231,5336541233,5336541330,5336541331,5336543101,5336550130,5336550131,5336550132,52366523231,52366523232,52366523233,52366523301,52366523302,52366523303,52366523310,52366523312,52366532222,52367501001,52367501003,52367501021,52367501211,52367501321,52367503301,52367503303,52367503321,52367503323,52367510012,52367510030,52367510032,52367510322,52367512100,52367512102,52367512120,52367512122,52367512123,52367512132,52367513202,52367513220,52367513222,52367513223,52367520313,52367520321,52367520323,52367521031,52367521033,52367521202,52367521203,52367521211,52367521212,52367521213,52367522101,52367522102,52367522103,52367531010,52367531012,52367531030,52367531032,52367531033,52367531320,52367531322,52367533100,52367533102,52367533103,52367533132,52367533310,52367533312,52367533313,53360500101,53360500110,53360500111,53360501000,53360501001,53360501003,53360501201,53360501203,53360501221,53360501223,53360503001,53360503003,53360503021,53360503023,53360503201,53360503203,53360503221,53360503223,53360520113,53360520123,53360520131,53360520132,53360520133,53360520321,53360520323,53360522101,53360522103,53360522121,53360522123,53360522233,53360600000,53360600002,53360600020,53360600022,53360600023,53360600230,53360600232,53360602010,53360602012,53360602013,53360602122,53360602312,53360602313,53360603112,53360603113,53360603202,53360603203,53360603212,53360603213,53360612002,53360612003,53360612011,53360612012,53360612013,53360612110,53360612112,53360612113,53360613002,53360613032,53360613033,53360613300,53360613302,53360613303,53360702220,53360702222,53360702223,53360702232,53360721100,53360721102,53360721103,53360721130,53360721132,53360721133,53360730200,53360730202,53360730203,53360730322,53360730323,53360732110,53360732112,53360732130,53360732132,53360732310,53360732312,53361500011,53361500013,53361500031,53361500033,53361500211,53361500213,53361500231,53361500233,53361502011,53361502013,53361502031,53361502120,53361502121,53361502123,53361502301,53361520131,53361520133,53361520311,53361521220,53361521221,53361521223,53361523001,53361523003,53361523021,53361523221,53361523223,53361630110,53361630111,53361630112,53361630132,53361630310,53361630312,53361630313,53361631021,53361631030,53361631100,53361631101,53361631110,53361631111,53361633200,53361633202,53361633220,53361633222,53361633322,53361701230,53361701231,53361701232,53361701310,53361702030,53361702032,53361702110,53361702111,53361702113,53361702210,53361702212,53361702213,53361702220,53361702221,53361702222,53361702230,53361703000,53361703001,53361703002,53361710020,53361710021,53361710022,53361710030,53361710031,53361710033,53362432231,53362432232,53362432233,53362432312,53362432313,53362433133,53362433202,53362433203,53362433212,53362433213,53362433301,53362433302,53362433303,53362500311,53362500312,53362500313,53362500321,53362500323,53362501001,53362502110,53362502111,53362502113,53362502131,53362502133,53362502301,53362502303,53362502321,53362502322,53362502323,53362520011,53362520013,53362520301,53362520302,53362520303,53362522011,53362522021,53362522022,53362522023,53362522032,53362522033,53362611020,53362611100,53362611102,53362612020,53362612021,53362612022,53362612100,53362612102,53362630002,53362630020,53362630022,53362630230,53362632000,53363410001,53363410003,53363410021,53363410023,53363410201,53363410202,53363410203,53363410220,53363410221,53363410223,53363412001,53363412003,53363421111,53363421112,53363421113,53363421121,53363421123,53363421213,53363422311,53363422312,53363422313,53363422323,53363423021,53363423022,53363423023,53363601030,53363601032,53363601100,53363601102,53363601210,53363601212,53363601213,53363601302,53363603110,53363603112,53363603130,53363603132,53363603310,53363603312,53363603330,53363603332,53363621110,53363621112,53363621130,53363621132,53363621310,53363621312,53363621330,53363621332,53363622330,53363622331,53363622332,53363623110,53363623112,53363623130,53363623210,53363623211,53363623212,53363623220,53363623300,53364400101,53364400103,53364400121,53364400331,53364401220,53364401221,53364403201,53364403203,53364403221,53364403223,53364421020,53364421021,53364421023,53364421201,53364421203,53364421221,53364423003,53364423021,53364423023,53364423201,53364423202,53364423203,53364511320,53364511322,53364513010,53364513011,53364513100,53364513210,53364513212,53364513230,53364513232,53364513233,53364523110,53364523111,53364523112,53364523130,53364523132,53364530030,53364530031,53364530120,53364530121,53364530131,53364530220,53364531000,53364531001,53364531010,53364531011,53364531012,53364532220,53364532222,53364532223,53364600200,53364600211,53364600300,53364600301,53365400121,53365400122,53365400123,53365400231,53365400233,53365402011,53365402121,53365402123,53365402301,53365403030,53365403031,53365403032,53365403120,53365403121,53365403123,53365403200,53365403201,53365403202,53365412020,53365412021,53365412030,53365412031,53365413320,53365413321,53365413322,53365430111,53365431000,53365431001,53365431003,53365501330,53365501331,53365503100,53365503200,53365503201,53365503202,53365503210,53365503211,53365503220,53365503222,53365510000,53365510001,53365510002,53365520000,53365520001,53365520010,53365520011,53365520013,53365520300,53365520301,53365520310,53365521000,53365521002,
124,01,ǻ,490598437,126468750,492075000,128859375,4,17,38,113,220,528,533604,533614,533633,533643,5236643,5236731,5236733,5236741,5236742,5236743,5336031,5336131,5336133,5336231,5336233,5336240,5336241,5336242,5336323,5336340,5336421,52366323,52366413,52366500,52366502,52366520,52366522,52367301,52367303,52367402,52367403,52367500,52367502,53360331,53360332,53360333,53360502,53361323,53361522,53362233,53362301,53362303,53362321,53362322,53362323,53362430,53362431,53363211,53363213,53363420,53364231,53364233,53364402,53364420,53364422,53365211,53365300,53365301,53365310,523655220,523655222,523663212,523663221,523663223,523663302,523663320,523663322,523663323,523663332,523663333,523664111,523664113,523664123,523664222,523664233,523665010,523665012,523665030,523665032,523665210,523665212,523665230,523673210,523673211,523673213,523673231,523673233,523674000,523674002,523674003,523674011,523674012,523674013,523675030,523675032,523675200,523675201,523675202,523675220,523675222,533603011,533603013,533603031,533603233,533603301,533603303,533605000,533605002,533605003,533605200,533605202,533605220,533613011,533613013,533613211,533613212,533613213,533613221,533613223,533615022,533615200,533615202,533622303,533622310,533622312,533622321,533622323,533623023,533623201,533623202,533623203,533624320,533624321,533624330,533625000,533625001,533625002,533625020,533625022,533625202,533632033,533632101,533632103,533632121,533632123,533632211,533632213,533632230,533632231,533632233,533634210,533634220,533634221,533634222,533642011,533642013,533642301,533642303,533642321,533642323,533644000,533644002,533652101,533652103,533652131,533653020,533653021,533653022,533653030,533653110,533653111,533653112,5236543313,5236543331,5236543332,5236543333,5236552210,5236552212,5236552230,5236552232,5236552233,5236552301,5236552303,5236552321,5236552322,5236552323,5236632032,5236632033,5236632132,5236632133,5236632203,5236632221,5236633210,5236633212,5236633213,5236633302,5236633303,5236633313,5236641121,5236641122,5236641123,5236641211,5236641213,5236641222,5236641223,5236642131,5236642133,5236642202,5236642311,5236642312,5236642313,5236642323,5236650312,5236650330,5236650332,5236652110,5236652112,5236652130,5236652132,5236652310,5236652312,5236652320,5236652321,5236652322,5236730011,5236730013,5236730031,5236730033,5236730211,5236730213,5236730230,5236730231,5236730233,5236732011,5236732120,5236732121,5236732123,5236732301,5236732303,5236732321,5236732323,5236740010,5236740012,5236740013,5236740101,5236740102,5236740103,5236750120,5236750122,5236750123,5236750310,5236750312,5236752030,5236752100,5236752101,5236752102,5336030123,5336030301,5336030303,5336030321,5336030330,5336030331,5336030333,5336032311,5336032313,5336032323,5336033000,5336033001,5336033003,5336033021,5336033022,5336033023,5336050012,5336050013,5336052010,5336052220,5336052221,5336052222,5336130101,5336130310,5336130311,5336130313,5336130331,5336130332,5336130333,5336132031,5336132033,5336132102,5336132103,5336150000,5336150002,5336150020,5336150022,5336150200,5336150202,5336150232,5336152010,5336152012,5336152030,5336152032,5336152033,5336152320,5336221320,5336221322,5336221323,5336223001,5336223003,5336223012,5336223013,5336223021,5336223023,5336223112,5336223130,5336223132,5336223133,5336223201,5336230011,5336230013,5336230033,5336230211,5336230212,5336230213,5336230221,5336230223,5336232001,5336232002,5336232003,5336243220,5336243221,5336243222,5336243230,5336243310,5336243311,5336243312,5336250030,5336250210,5336250212,5336252000,5336252002,5336252003,5336252012,5336252200,5336320321,5336320323,5336321001,5336321003,5336321021,5336321023,5336321201,5336321221,5336321222,5336321223,5336322101,5336322102,5336322103,5336322121,5336322122,5336322123,5336322321,5336322323,5336342110,5336342120,5336342122,5336342230,5336342300,5336420101,5336420311,5336420313,5336423001,5336423003,5336423223,5336440030,5336440032,5336440300,5336440302,5336521001,5336521003,5336521301,5336521303,5336521330,5336521331,5336530230,5336530231,5336530310,5336531130,5336531131,5336531132,5336531210,5336531211,5336531310,5336540001,5336540010,52365433111,52365433112,52365433113,52365433301,52365433303,52365520222,52365520322,52365520323,52365521120,52365521122,52365521231,52365521232,52365521233,52365521300,52365521302,52365521320,52365521322,52365523021,52365523023,52365523100,52365523102,52365523120,52365523122,52365523201,52365523202,52365523203,52365523300,52365523302,52365523320,52365523322,52366320311,52366320312,52366320313,52366321021,52366321023,52366321032,52366321300,52366321302,52366321303,52366322011,52366322012,52366322013,52366322023,52366322201,52366322203,52366322221,52366322230,52366322231,52366330021,52366330022,52366330023,52366330032,52366330320,52366330322,52366332112,52366333002,52366333013,52366333121,52366333122,52366333123,52366410331,52366410332,52366410333,52366411031,52366411032,52366411033,52366411201,52366411202,52366411203,52366412121,52366412122,52366412123,52366412211,52366412212,52366412213,52366421123,52366421132,52366421133,52366421301,52366421303,52366421321,52366421323,52366422002,52366422003,52366422012,52366422030,52366422032,52366422033,52366422322,52366423031,52366423033,52366423102,52366423103,52366423211,52366423213,52366501100,52366501102,52366501120,52366501122,52366501300,52366501302,52366501320,52366501322,52366503100,52366503102,52366503103,52366503130,52366503132,52366503133,52366503310,52366503311,52366503312,52366503330,52366503332,52366521110,52366521112,52366521130,52366521132,52366521310,52366521312,52366521330,52366521332,52366523230,52366523300,52367300100,52367300101,52367300103,52367300121,52367300123,52367300301,52367300303,52367300321,52367300323,52367302101,52367302103,52367302121,52367302123,52367302320,52367302321,52367302323,52367320101,52367320130,52367320131,52367320133,52367321220,52367321221,52367321223,52367323201,52367323203,52367400112,52367400113,52367401001,52367401003,52367501000,52367501002,52367501020,52367501022,52367501023,52367501210,52367501212,52367501213,52367501320,52367501322,52367501323,52367503300,52367503302,52367503320,52367503322,52367520310,52367520311,52367520312,52367520320,52367520322,52367521030,52367521032,52367521200,52367521201,52367521210,52367522100,53360301011,53360301013,53360301031,53360301033,53360301203,53360301212,53360301221,53360301223,53360303001,53360303230,53360303231,53360303320,53360303321,53360321111,53360321333,53360323101,53360323103,53360323121,53360323122,53360323123,53360323213,53360323223,53360330021,53360330023,53360330201,53360330203,53360500100,53360500102,53360500103,53360500112,53360500113,53360501002,53360501200,53360501202,53360501220,53360501222,53360503000,53360503002,53360503020,53360503022,53360503200,53360503202,53360503220,53360503222,53360520110,53360520111,53360520112,53360520120,53360520121,53360520122,53360520130,53360520320,53360520322,53360522100,53360522102,53360522120,53360522122,53360522230,53360522231,53360522232,53361301001,53361301003,53361301030,53361301031,53361301033,53361301211,53361301213,53361301231,53361303121,53361303123,53361303301,53361303302,53361303303,53361320131,53361320133,53361320323,53361321012,53361321013,53361322013,53361322031,53361322033,53361322211,53361322213,53361500010,53361500012,53361500030,53361500032,53361500210,53361500212,53361500230,53361500232,53361502010,53361502012,53361502030,53361502032,53361502033,53361502122,53361502300,53361502302,53361502303,53361520130,53361520132,53361520310,53361520312,53361520313,53361521222,53361523000,53361523002,53361523020,53361523022,53361523023,53361523220,53361523222,53362212232,53362212233,53362212311,53362212313,53362212322,53362212331,53362212333,53362213210,53362213212,53362213213,53362213302,53362213320,53362213322,53362230001,53362230003,53362230021,53362230023,53362230100,53362230102,53362230103,53362230111,53362230112,53362230113,53362230201,53362230203,53362230221,53362231100,53362231102,53362231103,53362231312,53362231313,53362232030,53362232031,53362232033,53362232211,53362232213,53362232231,53362232233,53362300100,53362300101,53362300103,53362300310,53362300311,53362300313,53362302032,53362302033,53362302221,53362302223,53362320001,53362320002,53362320003,53362432230,53362432310,53362432311,53362433130,53362433131,53362433132,53362433200,53362433201,53362433210,53362433211,53362433300,53362500310,53362500320,53362500322,53362501000,53362501002,53362501003,53362502112,53362502130,53362502132,53362502300,53362502302,53362502320,53362520010,53362520012,53362520300,53362522010,53362522012,53362522013,53362522020,53362522030,53362522031,53363203122,53363203123,53363203223,53363210221,53363210223,53363212001,53363212030,53363212031,53363212033,53363212202,53363212203,53363221001,53363221003,53363221200,53363221201,53363221203,53363222111,53363222113,53363222131,53363222133,53363223200,53363223201,53363223203,53363223221,53363410000,53363410002,53363410020,53363410022,53363410200,53363410222,53363412000,53363412002,53363421110,53363421120,53363421122,53363421210,53363421211,53363421212,53363422310,53363422320,53363422321,53363422322,53363423020,53364201031,53364201033,53364201211,53364201213,53364201231,53364201233,53364203011,53364203100,53364203101,53364203103,53364203121,53364203123,53364203310,53364203311,53364203313,53364203331,53364203333,53364221111,53364230000,53364230001,53364230003,53364230210,53364230211,53364230213,53364230231,53364232013,53364232031,53364232033,53364232211,53364232212,53364232213,53364400100,53364400102,53364400120,53364400122,53364400123,53364400330,53364400332,53364400333,53364401222,53364401223,53364403200,53364403202,53364403220,53364403222,53364421022,53364421200,53364421202,53364421220,53364421222,53364421223,53364423000,53364423001,53364423002,53364423020,53364423022,53364423200,53365210210,53365210211,53365210213,53365210231,53365210233,53365212100,53365212101,53365212103,53365212110,53365212111,53365212112,53365213000,53365213001,53365213003,53365213021,53365213211,53365213213,53365213330,53365213331,53365213333,53365302320,53365302322,53365302330,53365302331,53365303110,53365303111,53365303112,53365303120,53365303121,53365303122,53365303200,53365311330,53365311331,53365311332,53365312000,53365312001,53365312010,53365312011,53365313000,53365313010,53365313011,53365320000,53365320001,53365320010,53365400000,53365400001,53365400002,53365400020,53365400022,53365400031,53365400033,53365400120,53365400200,
125,00,ǻ,492004687,127303125,494690625,129834375,10,23,53,157,348,710,533627,533637,533647,533657,533667,533710,533720,533721,533732,533750,5336172,5336173,5336361,5336363,5336461,5336462,5336463,5336560,5336561,5336563,5336761,5336763,5336770,5337110,5337112,5337222,5337300,5337302,5337311,5337402,5337600,5337601,5337602,53361712,53361713,53362613,53362631,53362633,53364533,53364601,53364602,53364603,53365511,53365513,53366611,53366613,53366631,53366633,53367621,53367623,53367710,53367712,53367720,53367721,53367722,53370022,53370023,53370033,53370122,53370123,53371132,53371133,53372232,53372233,53373010,53373011,53373012,53373100,53373101,53373103,53373130,53373131,53373133,53374000,53374001,53374002,53374032,53374201,53374210,53376030,53376031,53377000,53377001,54360600,54360601,54360602,533616312,533616313,533616330,533616331,533617023,533617031,533617032,533617033,533617101,533617102,533617103,533617112,533617113,533626112,533626113,533626122,533626123,533626233,533626301,533626303,533626321,533626322,533626323,533645133,533645303,533645311,533645312,533645313,533645320,533645321,533645323,533655101,533655102,533655103,533655120,533655121,533655123,533655311,533656200,533656211,533656213,533656231,533666101,533666123,533666301,533666303,533666321,533666322,533666323,533675333,533676011,533676013,533676023,533676031,533676032,533676033,533676201,533676203,533676221,533676222,533676223,533677230,533677231,533677232,533677300,533677302,533700203,533700210,533700212,533700213,533700301,533700303,533700310,533700312,533700313,533700321,533700322,533700323,533701202,533701203,533711100,533711102,533711122,533711300,533711302,533711312,533711313,533712220,533712222,533722000,533722001,533722002,533722020,533722022,533722023,533722032,533722300,533722302,533722303,533723220,533723222,533730130,533730131,533730300,533730301,533730302,533730320,533730322,533730323,533731020,533731021,533731211,533731321,533731323,533733000,533733002,533733020,533733022,533733023,533733200,533733201,533733202,533733220,533733221,533740030,533740032,533740033,533740100,533740330,533740332,533740333,533742000,533742001,533742003,533742110,533742112,533742120,533742121,533760320,533760331,533761020,533761021,533761022,533761200,533770021,533770030,533770031,543605111,543605113,543605131,543605133,543606030,543606032,543606200,543607000,543607001,543607003,5336073133,5336073232,5336073311,5336073312,5336073313,5336073331,5336073333,5336163112,5336163113,5336163321,5336163323,5336163330,5336163331,5336163333,5336170132,5336170133,5336170212,5336170213,5336170301,5336170302,5336170303,5336171102,5336171103,5336171112,5336171113,5336261033,5336261103,5336261111,5336261112,5336261113,5336261203,5336261211,5336261212,5336261213,5336262312,5336262313,5336263001,5336263003,5336263021,5336263201,5336263202,5336263203,5336360111,5336360112,5336360113,5336360131,5336360133,5336362323,5336362331,5336362332,5336362333,5336451133,5336451303,5336451311,5336451312,5336451313,5336453020,5336453021,5336453023,5336453102,5336453103,5336453220,5336453221,5336453223,5336460011,5336460013,5336460022,5336460023,5336460031,5336460032,5336460033,5336550311,5336550312,5336550313,5336550330,5336550331,5336551001,5336551002,5336551003,5336551220,5336551221,5336551223,5336553100,5336553101,5336553103,5336562010,5336562011,5336562012,5336562021,5336562030,5336562100,5336562101,5336562103,5336562330,5336562331,5336562333,5336660111,5336661000,5336661001,5336661003,5336661030,5336661031,5336661033,5336661211,5336661213,5336662333,5336663001,5336663023,5336663201,5336663203,5336753321,5336760101,5336760103,5336760121,5336760123,5336760222,5336760223,5336760303,5336762000,5336762001,5336762003,5336762021,5336762023,5336762201,5336762202,5336762203,5336771100,5336771102,5336771111,5336771120,5336771122,5336772330,5336772332,5336773010,5336773011,5336773012,5336773030,5336773200,5337000321,5337000322,5337000323,5337000330,5337000332,5337001233,5337001322,5337001323,5337001332,5337002003,5337002011,5337002012,5337002013,5337002021,5337002022,5337002023,5337002110,5337002112,5337003110,5337003112,5337003113,5337003201,5337003202,5337003203,5337012002,5337012003,5337012010,5337012012,5337012013,5337012132,5337012133,5337013202,5337013220,5337013222,5337111200,5337111201,5337111202,5337113030,5337113032,5337113033,5337113110,5337113112,5337113113,5337122020,5337122022,5337122232,5337122233,5337220030,5337220031,5337220032,5337220210,5337220212,5337220330,5337220332,5337220333,5337221222,5337221223,5337223010,5337223012,5337223013,5337232210,5337232212,5337232230,5337232232,5337301320,5337301321,5337301331,5337303030,5337303031,5337303032,5337303210,5337303212,5337303213,5337303322,5337310220,5337310230,5337310231,5337310233,5337312011,5337312100,5337312101,5337312131,5337313201,5337313223,5337330210,5337330212,5337330213,5337332030,5337332031,5337332032,5337332100,5337332102,5337332220,5337332221,5337332222,5337332230,5337400310,5337400312,5337401010,5337401011,5337401012,5337401020,5337401021,5337401100,5337401220,5337401222,5337403000,5337403002,5337403020,5337403022,5337403023,5337403032,5337403033,5337403122,5337403312,5337403313,5337411011,5337411100,5337411101,5337411102,5337411110,5337411111,5337412220,5337412222,5337420020,5337420021,5337420023,5337420210,5337420311,5337420313,5337421110,5337421111,5337421112,5337421130,5337421221,5337421230,5337421231,5337510000,5337510002,5337510020,5337510022,5337510200,5337510202,5337510220,5337510222,5337512000,5337512002,5337512020,5337603210,5337603212,5337603220,5337603222,5337603300,5337603301,5337603303,5337603321,5337603322,5337603323,5337603330,5337610002,5337610020,5337610022,5337610023,5337610032,5337610033,5337610120,5337610122,5337610230,5337610231,5337610232,5337610300,5337612010,5337612020,5337612022,5337700201,5337700231,5337700320,5337700330,5337701000,5337701002,5337701020,5337701022,5436053110,5436053111,5436053113,5436053131,5436060310,5436060311,5436060332,5436061000,5436061001,5436061002,5436061010,5436061101,5436061110,5436061111,5436061113,5436062010,5436062011,5436062012,5436062020,5436062021,5436062023,5436062100,5436062101,5436070021,5436070100,5436070101,5436070102,5436070110,53360732330,53360732332,53360733013,53360733031,53360733102,53360733103,53360733301,53360733303,53360733321,53360733323,53361630113,53361630130,53361630131,53361630133,53361630311,53361631020,53361631022,53361631023,53361631031,53361631032,53361631033,53361631102,53361631103,53361631112,53361631113,53361633201,53361633203,53361633221,53361633223,53361633320,53361633321,53361633323,53361701233,53361701311,53361701312,53361701313,53361702031,53361702033,53361702112,53361702211,53361702223,53361702231,53361702232,53361702233,53361703003,53361710023,53361710032,53361711002,53361711003,53361711012,53361711013,53361711110,53361711111,53361711113,53362611021,53362611022,53362611023,53362611101,53362611103,53362612023,53362612101,53362612103,53362630000,53362630001,53362630003,53362630021,53362630023,53362630231,53362630232,53362630233,53362632001,53362632002,53362632003,53363601031,53363601033,53363601101,53363601103,53363601211,53363601300,53363601301,53363601303,53363603111,53363603113,53363603131,53363603133,53363603311,53363603313,53363603331,53363603333,53363621111,53363621113,53363621131,53363621133,53363621311,53363621313,53363621331,53363621333,53363622333,53363623111,53363623113,53363623131,53363623132,53363623133,53363623213,53363623221,53363623222,53363623223,53363623301,53363623302,53363623303,53364511321,53364511323,53364513012,53364513013,53364513101,53364513102,53364513103,53364513211,53364513213,53364513231,53364523113,53364523131,53364523133,53364530032,53364530033,53364530122,53364530123,53364530130,53364530132,53364530133,53364530221,53364530222,53364530223,53364531002,53364531003,53364531013,53364532221,53364600201,53364600202,53364600203,53364600210,53364600212,53364600213,53364600302,53364600303,53365501332,53365501333,53365503101,53365503102,53365503103,53365503213,53365503320,53365503321,53365503323,53365503330,53365503331,53365503332,53365510003,53365512220,53365512221,53365530011,53365530100,53365530110,53365530111,53365531020,53365531021,53365531023,53365531201,53365531203,53365531210,53365531211,53365531212,53365531300,53365531301,53365531311,53365620130,53365620131,53365620132,53365620200,53365620201,53365620203,53365620230,53365620231,53365620310,53365620311,53365620320,53365621211,53365621213,53365623321,53365623323,53366601101,53366601103,53366601121,53366601123,53366601130,53366601131,53366601132,53366610020,53366610021,53366610321,53366610323,53366612101,53366612103,53366612121,53366612122,53366612123,53366612231,53366612232,53366612233,53366623312,53366623313,53366623321,53366623323,53366630030,53366630031,53366630033,53366630211,53366630213,53366632001,53366632003,53366632021,53366632023,53367533123,53367533132,53367533133,53367533231,53367533233,53367601001,53367601003,53367601021,53367601023,53367601201,53367601203,53367602123,53367602132,53367602133,53367602203,53367602211,53367602212,53367602213,53367603011,53367603013,53367603022,53367603023,53367620020,53367620021,53367620023,53367620201,53367620203,53367620221,53367620223,53367622001,53367622003,53367711010,53367711101,53367711130,53367711131,53367713000,53367713002,53367713020,53367713022,53367713200,53367713202,53367713220,53367723310,53367723311,53367723312,53367723330,53367723332,53367730130,53367730131,53367730132,53367730310,53367730312,53367730320,53367730321,53367732010,53367732020,53367732021,53367732022,53370002332,53370002333,53370003122,53370003123,53370003201,53370003202,53370003203,53370003312,53370012313,53370012321,53370012323,53370013303,53370013330,53370013332,53370020003,53370020012,53370020013,53370020021,53370020023,53370020101,53370020102,53370020103,53370020201,53370020202,53370020203,53370021110,53370021112,53370021130,53370021132,53370021133,53370030202,53370030211,53370030213,53370030220,53370030222,53370030231,53370030232,53370030233,53370031110,53370031112,53370031113,53370032003,53370120012,53370120013,53370120112,53370121220,53370121222,53370121223,53370121231,53370121233,53370130222,53370132000,53370132002,53370132212,53370132230,53370132232,53371110102,53371110120,53371110122,53371112030,53371112031,53371112032,53371112302,53371113323,53371113332,53371130120,53371130122,53371130123,53371130310,53371130312,53371130313,53371131023,53371131110,53371131112,53371131113,53371220002,53371220020,53371220022,53371220023,53371220232,53371220233,53371222120,53371222122,53371222300,53371222302,53371222303,53371222312,53371223222,53372200330,53372200331,53372200332,53372201000,53372201002,53372201003,53372201020,53372201021,53372201022,53372201200,53372202130,53372202132,53372202133,53372203022,53372203023,53372203032,53372203033,53372203122,53372203123,53372203310,53372203312,53372203313,53372212201,53372212202,53372212203,53372212210,53372212212,53372212213,53372212320,53372212322,53372212323,53372230110,53372230112,53372230113,53372231020,53372231022,53372231200,53372231202,53372231220,53372231222,53372231223,53372231232,53372320232,53372320233,53372320322,53372320323,53372322130,53372322132,53372322310,53372322312,53373013220,53373013221,53373013222,53373013230,53373013231,53373013300,53373013301,53373013302,53373013320,53373030330,53373030331,53373030332,53373031022,53373031200,53373031202,53373032110,53373032112,53373033022,53373033200,53373033202,53373033203,53373102210,53373102211,53373102213,53373102320,53373102321,53373102323,53373120101,53373121021,53373121030,53373121031,53373121301,53373121330,53373121331,53373121333,53373132001,53373132003,53373132031,53373132033,53373132210,53373132211,53373132213,53373300100,53373300102,53373300322,53373302112,53373303220,53373303222,53373303223,53373320330,53373320331,53373320332,53373321200,53373322230,53373322231,53373322310,53373322311,53373323002,53373323020,53373323022,53374003110,53374003132,53374010130,53374010131,53374010220,53374010222,53374010300,53374010301,53374010302,53374011020,53374011021,53374011023,53374030030,53374030032,53374030210,53374030212,53374030213,53374030302,53374030303,53374030312,53374031232,53374031233,53374031322,53374033100,53374033102,53374033103,53374033112,53374033113,53374110011,53374110100,53374110101,53374110103,53374110121,53374110130,53374110131,53374111030,53374111031,53374111032,53374111120,53374111121,53374111131,53374122022,53374122023,53374122032,53374122232,53374200220,53374200221,53374200223,53374202010,53374202011,53374202110,53374202111,53374202121,53374203010,53374203011,53374203100,53374203101,53374203103,53374203310,53374203311,53374211130,53374211320,53374212200,53374212201,53374212203,53374212230,53374212231,53374212320,53374212321,53374212323,53374212330,53374213000,53374213001,53374213002,53374213010,53374213011,53374213020,53374213200,53374300000,53375102210,53375120220,53375120222,53375122000,53375122002,53375122003,53375122020,53375122022,53375122202,53376032210,53376032211,53376032212,53376032230,53376032232,53376032300,53376033020,53376033021,53376033023,53376033201,53376033202,53376033203,53376033310,53376033311,53376033312,53376100000,53376100002,53376100210,53376100212,53376100213,53376100302,53376100303,53376100311,53376100312,53376100313,53376101022,53376101210,53376101212,53376101230,53376101232,53376102330,53376102332,53376103010,53376103012,53376103020,53376103021,53376103022,53376103200,53376120210,53376120212,53376120230,53376122000,53376122001,53376122002,53376122020,53377002001,53377002030,53377002031,53377002033,53377002301,53377002303,53377002321,53377002330,53377002331,53377002332,53377003210,53377003211,53377003212,53377003220,53377003310,53377003312,53377003321,53377003323,53377003330,53377011000,53377011001,53377011003,53377011010,53377011012,53377011021,53377011030,53377012000,53377012001,53377012002,54360511011,54360511013,54360511031,54360511033,54360511211,54360511213,54360511231,54360531120,54360531121,54360531123,54360531301,54360531331,54360603120,54360603121,54360603122,54360603130,54360603300,54360603302,54360610030,54360610031,54360610110,54360610112,54360610120,54360610121,54360610200,54360611000,54360611001,54360611003,54360611031,54360611120,54360611121,54360611123,54360611310,54360611311,54360620130,54360620131,54360620132,54360620220,54360620221,54360620223,54360620300,54360620301,54360620302,54360620310,54360620320,54360620322,54360621020,54360621021,54360621022,54360621030,54360621031,54360621100,54360621102,54360621120,54360622010,54360622011,54360700200,54360700201,54360700203,54360700230,54360700231,54360701030,54360701031,54360701032,54360701110,54360701120,54360701200,54360701202,54360702101,54360702110,
126,00,,492314062,128221875,495548437,131268750,16,45,82,228,431,994,533771,533772,543617,543627,543700,543701,543702,543703,543710,543720,543723,543731,543732,543733,543741,543742,5337410,5337413,5337422,5337511,5337513,5337520,5337522,5337611,5337613,5337620,5337622,5337702,5337703,5337730,5337732,5337733,5436063,5436071,5436072,5436073,5436161,5436163,5436370,5436372,5437040,5437042,5437110,5437131,5437210,5437212,5437213,5437221,5437222,5437223,5437240,5437242,5437301,5437303,5437340,5437342,5437343,5437430,5437431,5437432,5437440,53367731,53367733,53373122,53373123,53374013,53374112,53374113,53374120,53374121,53374123,53375101,53375103,53375121,53375123,53375212,53376121,53376123,53376212,53376230,53376232,53376233,53376322,53377013,53377310,53377312,53377313,53377420,53377422,54360612,54360613,54360623,54360703,54361601,54361603,54362610,54362611,54362613,54363613,54363631,54363633,54363710,54363711,54363730,54370412,54370430,54371120,54371211,54371300,54371301,54371331,54371332,54371333,54371400,54371402,54371420,54371422,54371423,54372112,54372113,54372201,54372202,54372203,54373000,54373001,54373003,54373021,54373410,54373412,54373413,54374010,54374011,54374013,54374330,54374331,54374410,54374411,54374420,54375101,54375111,54375200,54375201,54375203,533677113,533677131,533677133,533677321,533677322,533677323,533730311,533730313,533730331,533730333,533731200,533731202,533731203,533731212,533740111,533740112,533740113,533740120,533740121,533740123,533740301,533740310,533740311,533741102,533741103,533741112,533741113,533741221,533741223,533742022,533742023,533742032,533742300,533742302,533742320,533742322,533751001,533751003,533751021,533751023,533751201,533751203,533751221,533751223,533752100,533752102,533752300,533752322,533761001,533761011,533761013,533761031,533761033,533761203,533761221,533761222,533761223,533762100,533762102,533762103,533762112,533762130,533762132,533762310,533762312,533762313,533763232,533763233,533763321,533763322,533763323,533763332,533770022,533770101,533770103,533770111,533770112,533770113,533770121,533770122,533770123,533773110,533773112,533773113,533774022,533774232,533774233,543606103,543606112,543606212,543606213,543606221,543606223,543607013,543607020,543607022,543607023,543616001,543616003,543616211,543616213,543616230,543616231,543616233,543626121,543626123,543626310,543626311,543626313,543626331,543626333,543636111,543636112,543636113,543636121,543636122,543636123,543636301,543637120,543637122,543637131,543637320,543637322,543646110,543646111,543647001,543647010,543647011,543647012,543704100,543704102,543704103,543704320,543704321,543711100,543711101,543711102,543711210,543711211,543711212,543711220,543711222,543712010,543712011,543712013,543712100,543712101,543712322,543712323,543712332,543712333,543713021,543713030,543713031,543713033,543713222,543713223,543713231,543713232,543713233,543713300,543713301,543713303,543714010,543714011,543714012,543714030,543714032,543714210,543714212,543714322,543721100,543721102,543721103,543722001,543722003,543724100,543724102,543724120,543724302,543724320,543724322,543724323,543730020,543730021,543730023,543730201,543730231,543734112,543735200,543735202,543735220,543735222,543740120,543740121,543740123,543740311,543740313,543740331,543743320,543743321,543744120,543744121,543744122,543744210,543744211,543744220,543744222,543744300,543751001,543751030,543751031,543751100,543751101,543751102,543752020,543752021,543752101,543752110,543752111,543752113,543753000,543753001,543753002,543753020,543743330,543743331,543743333,5336771103,5336771112,5336771121,5336771123,5336771301,5336771303,5336771321,5336771323,5336773033,5336773203,5337301333,5337303100,5337303101,5337303103,5337303121,5337303122,5337303123,5337303300,5337303301,5337303303,5337303321,5337303323,5337310222,5337310223,5337312012,5337312013,5337312132,5337313202,5337313220,5337313222,5337401023,5337401031,5337401032,5337401033,5337401101,5337401103,5337401221,5337401223,5337403001,5337403120,5337403121,5337403130,5337403131,5337403133,5337411000,5337411002,5337411003,5337412200,5337412201,5337412221,5337420200,5337420202,5337420203,5337420213,5337420300,5337420302,5337420303,5337420312,5337420330,5337420332,5337420333,5337421222,5337423012,5337510001,5337510003,5337510021,5337510023,5337510201,5337510203,5337510223,5337512001,5337512003,5337512021,5337512023,5337512201,5337512203,5337512221,5337512222,5337512223,5337521012,5337521030,5337521032,5337521033,5337521302,5337521320,5337521322,5337521323,5337523010,5337523020,5337523021,5337523022,5337523200,5337523202,5337523203,5337603211,5337603213,5337603231,5337603232,5337603233,5337603332,5337603333,5337610001,5337610003,5337610100,5337610101,5337610103,5337610303,5337610321,5337610322,5337610323,5337612011,5337612012,5337612013,5337612201,5337612203,5337621310,5337621312,5337621330,5337623112,5337632022,5337632302,5337633032,5337633033,5337633203,5337633300,5337633302,5337700202,5337700323,5337701001,5337701003,5337701021,5337701023,5337701201,5337701202,5337701203,5337731112,5337740202,5337740203,5337740212,5337740230,5337740232,5337740233,5337742102,5337742120,5337742122,5337742300,5337742302,5337742303,5337742312,5337743222,5337743223,5436060331,5436060333,5436061013,5436061021,5436061022,5436061023,5436061102,5436061130,5436061132,5436061133,5436062033,5436062111,5436062113,5436062223,5436070022,5436070113,5436070121,5436070122,5436070123,5436070212,5436070213,5436160001,5436160003,5436160021,5436160211,5436162101,5436162103,5436162121,5436162123,5436162320,5436162321,5436260111,5436260113,5436261201,5436263011,5436263120,5436263121,5436263123,5436263301,5436263303,5436361023,5436361032,5436361033,5436361103,5436361201,5436361202,5436361203,5436362111,5436362113,5436363000,5436363001,5436363031,5436363033,5436371210,5436371212,5436371230,5436371232,5436371331,5436373210,5436373211,5436373212,5436373230,5436373232,5436461133,5436470000,5436470001,5436470031,5436470130,5436471000,5436471001,5436471002,5437041012,5437043102,5437043120,5437043122,5437043123,5437043220,5437043221,5437043222,5437043230,5437043300,5437043301,5437111030,5437111101,5437111110,5437111111,5437111113,5437111200,5437111202,5437111220,5437111222,5437111223,5437112130,5437112210,5437112211,5437112212,5437112230,5437112232,5437112233,5437112300,5437112323,5437112332,5437112333,5437113000,5437113001,5437113222,5437120000,5437120002,5437120011,5437120120,5437120121,5437120123,5437121020,5437121021,5437121030,5437121031,5437121300,5437121301,5437121303,5437121310,5437121311,5437122323,5437122332,5437122333,5437123203,5437123212,5437123213,5437123302,5437123303,5437123312,5437130200,5437130201,5437130320,5437130321,5437130323,5437132111,5437132212,5437133021,5437140130,5437140131,5437140132,5437140330,5437140332,5437141000,5437142110,5437142112,5437142130,5437142132,5437143200,5437143202,5437143232,5437211010,5437211012,5437211013,5437211122,5437211123,5437211132,5437220023,5437241010,5437241011,5437241012,5437241030,5437241032,5437241220,5437241222,5437243000,5437243002,5437243210,5437243212,5437243213,5437243322,5437300220,5437300221,5437300223,5437302031,5437302033,5437302301,5437302331,5437302333,5437341100,5437341102,5437341103,5437341132,5437350202,5437350220,5437350222,5437350223,5437350232,5437352010,5437352012,5437352030,5437352032,5437352210,5437352212,5437352230,5437352232,5437400111,5437400113,5437400131,5437400133,5437401220,5437401221,5437401223,5437403010,5437403011,5437403100,5437403101,5437403103,5437403121,5437403122,5437403123,5437403331,5437433220,5437433221,5437433230,5437433231,5437441230,5437441232,5437441300,5437441301,5437441302,5437441310,5437442120,5437442121,5437442122,5437442210,5437442211,5437442212,5437443010,5437443012,5437443030,5437450000,5437450001,5437450002,5437510001,5437510003,5437510021,5437510211,5437510321,5437511200,5437511201,5437511202,5437511301,5437511331,5437520220,5437520222,5437521000,5437521001,5437521120,5437521121,5437521220,5437521222,5437521310,5437521311,5437521313,5437530030,5437530032,5437530100,5437530101,5437530210,5437530212,5437530221,5437530230,5437531101,5437531110,5437531111,5437540000,5437540001,5437510030,5437510031,5437510033,5437511310,5437511311,5437511313,5437520230,5437520231,5437520233,5437433320,5437433321,5437433323,53367711011,53367711012,53367711013,53367711100,53367711102,53367711103,53367711132,53367711133,53367713001,53367713003,53367713021,53367713023,53367713201,53367713203,53367713221,53367713222,53367713223,53367723313,53367723331,53367723333,53367730133,53367730311,53367730313,53367730322,53367730323,53367732011,53367732012,53367732013,53367732023,53373013223,53373013232,53373013233,53373013303,53373013321,53373013322,53373013323,53373030333,53373031020,53373031021,53373031023,53373031201,53373031203,53373032111,53373032113,53373033020,53373033021,53373033023,53373033201,53373102212,53373102322,53373120100,53373120102,53373120103,53373121020,53373121022,53373121023,53373121032,53373121033,53373121300,53373121302,53373121303,53373121332,53373132000,53373132002,53373132030,53373132032,53373132212,53374003111,53374003112,53374003113,53374003130,53374003131,53374003133,53374010132,53374010133,53374010221,53374010223,53374010303,53374011022,53374030031,53374030033,53374030211,53374030300,53374030301,53374030310,53374030311,53374030313,53374031230,53374031231,53374031320,53374031321,53374031323,53374033101,53374033110,53374033111,53374110010,53374110012,53374110013,53374110102,53374110120,53374110122,53374110123,53374110132,53374110133,53374111033,53374111122,53374111123,53374111130,53374111132,53374111133,53374122020,53374122021,53374122030,53374122031,53374122033,53374122230,53374122231,53374122233,53374200222,53374202012,53374202013,53374202112,53374202113,53374202120,53374202122,53374202123,53374203012,53374203013,53374203102,53374203312,53374203313,53374212202,53374212232,53374212233,53374212322,53374230100,53374230102,53374230103,53374230300,53374230301,53374230302,53374230320,53374230322,53374232100,53374232102,53374232120,53374232122,53374232322,53375102211,53375102212,53375102213,53375120221,53375120223,53375122001,53375122021,53375122023,53375122200,53375122201,53375122203,53375210100,53375210102,53375210103,53375210312,53375213000,53375213002,53375213210,53375213212,53375230110,53375230111,53375230120,53375230121,53375230122,53375230230,53375230232,53375230300,53375231000,53375231001,53375231010,53375231011,53375232010,53375232012,53375232013,53375232320,53375232322,53376032213,53376032231,53376032233,53376032301,53376032302,53376032303,53376033022,53376033200,53376033313,53376100001,53376100003,53376100211,53376100300,53376100301,53376100310,53376101020,53376101021,53376101023,53376101211,53376101213,53376101231,53376101233,53376102331,53376102333,53376103011,53376103013,53376103023,53376103201,53376103202,53376103203,53376120211,53376120213,53376120231,53376120232,53376120233,53376122003,53376122021,53376122022,53376122023,53376210100,53376210102,53376210120,53376210122,53376210123,53376211023,53376211032,53376211033,53376211300,53376211302,53376211320,53376211322,53376211323,53376213320,53376213321,53376213322,53376231100,53376231102,53376231103,53376231130,53376231132,53376231133,53376320200,53376320202,53376320232,53376320233,53376320322,53376320323,53376323002,53376323003,53376323030,53376323032,53376323033,53376323122,53376323123,53376323132,53376323133,53376330233,53376330312,53376331220,53376331222,53376331223,53376332011,53376332012,53376332013,53376332021,53376332022,53376332023,53376333010,53376333012,53376333030,53376333032,53376333322,53377002000,53377002002,53377002003,53377002032,53377002300,53377002302,53377002320,53377002322,53377002323,53377002333,53377003213,53377003221,53377003222,53377003223,53377003311,53377003313,53377003320,53377003322,53377003331,53377003332,53377003333,53377011002,53377011011,53377011013,53377011020,53377011022,53377011023,53377011031,53377011032,53377011033,53377012003,53377311100,53377311102,53377311103,53377311132,53377400222,53377402000,53377402002,53377402003,53377402012,53377402013,53377402102,53377402103,53377402132,53377402310,53377402312,53377402313,53377421000,53377421002,53377421030,53377421032,53377421210,53377421212,53377421230,53377421232,53377423010,53377423012,53377423013,53377423132,53377432200,53377432202,53377432203,54360603123,54360603131,54360603132,54360603133,54360603301,54360603303,54360610032,54360610033,54360610111,54360610113,54360610122,54360610123,54360610201,54360610202,54360610203,54360611002,54360611030,54360611032,54360611033,54360611122,54360611312,54360611313,54360620133,54360620303,54360620311,54360620312,54360620313,54360620321,54360620323,54360621023,54360621032,54360621033,54360621101,54360621103,54360621121,54360621122,54360621123,54360622033,54360622211,54360622212,54360622213,54360622223,54360700202,54360700232,54360700233,54360701033,54360701111,54360701112,54360701113,54360701121,54360701122,54360701123,54360701201,54360701203,54360702100,54360702102,54360702103,54360702111,54360702112,54360702113,54361600001,54361600003,54361600021,54361600230,54361600231,54361600233,54361602131,54361602133,54361602311,54361602313,54361602331,54361621001,54361621003,54361621021,54361621023,54361621201,54361621203,54361621221,54361621222,54361621223,54361622113,54361622131,54361622133,54361622310,54361622311,54361623231,54362601310,54362601311,54362601313,54362601331,54362612001,54362612003,54362612030,54362612031,54362612231,54362630101,54362630130,54362630131,54362630133,54362630311,54362630313,54362631220,54362631221,54362631223,54362633001,54362633210,54362633211,54362633233,54363603313,54363603323,54363603331,54363603332,54363603333,54363610311,54363610312,54363610313,54363611011,54363611012,54363611013,54363611023,54363612001,54363612002,54363612003,54363621101,54363621103,54363621120,54363621121,54363621123,54363630020,54363630021,54363630030,54363630031,54363630301,54363630303,54363632110,54363632111,54363632113,54363632131,54363712110,54363712111,54363712310,54363712312,54363712330,54363712332,54363712333,54363713000,54363713001,54363713010,54363713011,54363713013,54363713031,54363713300,54363713301,54363713303,54363731020,54363731022,54363731200,54363731202,54363731203,54363731220,54363731221,54363731222,54363732130,54363732132,54363732310,54363733000,54364610113,54364610131,54364610133,54364610311,54364611200,54364611201,54364611210,54364611300,54364611301,54364611310,54364611311,54364611312,54364613111,54364613113,54364613131,54364613133,54364700020,54364700021,54364700022,54364700031,54364700200,54364700222,54364700301,54364700331,54364701310,54364701311,54364701312,54364701320,54364701321,54364702000,54364703000,54364703001,54364710030,54364710031,54364710032,54364710100,54364710200,54364710201,54370410100,54370410102,54370410103,54370410130,54370410132,54370410133,54370411202,54370411220,54370411222,54370413000,54370413002,54370413020,54370413021,54370413022,54370413200,54370413202,54370413220,54370413222,54370431000,54370431002,54370431003,54370431030,54370431032,54370431210,54370431212,54370431213,54370431302,54370431320,54370431322,54370432230,54370432231,54370432232,54370432310,54370432311,54370432312,54370432320,54370432321,54370433020,54370433021,54370433022,54370433030,54370433031,54370433100,54370433102,54370433120,54370433122,54370433200,54371110320,54371111000,54371111001,54371111031,54371111120,54371111121,54371112010,54371112011,54371112012,54371112210,54371112212,54371121310,54371121311,54371121320,54371122130,54371122132,54371122310,54371122312,54371123010,54371123011,54371123222,54371123223,54371123303,54371123312,54371123313,54371130020,54371130022,54371132200,54371132202,54371132203,54371132230,54371132232,54371132233,54371132320,54371132322,54371132323,54371200010,54371200011,54371200012,54371200030,54371200032,54371200100,54371200101,54371200103,54371200130,54371200131,54371200133,54371200200,54371200201,54371200210,54371200211,54371201220,54371201221,54371201223,54371203001,54371203010,54371203011,54371203101,54371203110,54371203111,54371210220,54371210221,54371210222,54371210230,54371210231,54371210320,54371210330,54371210331,54371210333,54371212111,54371213021,54371213120,54371213121,54371213130,54371213131,54371223213,54371223222,54371223223,54371223302,54371223303,54371223311,54371223312,54371223313,54371232021,54371232023,54371232102,54371232112,54371233012,54371233013,54371233102,54371233130,54371233132,54371233133,54371302021,54371302030,54371302031,54371302301,54371302310,54371302311,54371303221,54371321011,54371321100,54371321101,54371321103,54371321121,54371321130,54371321131,54371321323,54371321332,54371321333,54371322022,54371322023,54371322032,54371322033,54371322130,54371322132,54371322133,54371323022,54371323033,54371330201,54371330222,54371330231,54371330233,54371403100,54371403102,54371403120,54371403122,54371403312,54371403330,54371403332,54371410010,54371410020,54371410021,54371410022,54371421110,54371421112,54371421312,54371421330,54371421332,54371421333,54371430222,54371432032,54371432302,54371432303,54371432330,54371432332,54371432333,54372110110,54372110112,54372111022,54372111200,54372111202,54372111203,54372111211,54372111212,54372111213,54372111300,54372111302,54372111303,54372111330,54372111332,54372111333,54372200013,54372200031,54372200033,54372200211,54372200213,54372410130,54372410132,54372410310,54372410312,54372410330,54372410332,54372410333,54372412100,54372412101,54372412102,54372412210,54372412212,54372412230,54372412232,54372430010,54372430012,54372430030,54372430032,54372430300,54372430301,54372430302,54372430320,54372430322,54372430323,54372430332,54372432110,54372432112,54372432113,54372433020,54372433022,54372433200,54372433202,54372433230,54372433232,54373020011,54373020013,54373020031,54373020300,54373020301,54373020303,54373020321,54373020323,54373022101,54373022103,54373022110,54373022111,54373022112,54373023000,54373023001,54373023031,54373023033,54373023300,54373023301,54373023303,54373023321,54373023323,54373411010,54373411012,54373411013,54373411120,54373411122,54373411300,54373411302,54373411303,54373411312,54373411330,54373411332,54373411333,54373502000,54373502002,54373502210,54373502212,54373502213,54373520132,54373522112,54373522130,54373522132,54374001101,54374001103,54374001121,54374001123,54374001301,54374001303,54374003111,54374003113,54374003131,54374003133,54374003311,54374003313,54374012220,54374012221,54374031021,54374031023,54374031201,54374031202,54374031203,54374033011,54374033013,54374033321,54374332231,54374332320,54374412310,54374413030,54374413031,54374413032,54374413110,54374413112,54374413120,54374413121,54374421230,54374421232,54374421300,54374421301,54374421310,54374422130,54374422131,54374422132,54374422300,54374422301,54374422302,54374430210,54374430211,54374430213,54374500030,54374500100,54374500200,54374500202,54375100231,54375102131,54375103200,54375103201,54375103203,54375110311,54375110313,54375110331,54375112030,54375112031,54375112032,54375112210,54375112212,54375113001,54375210020,54375210031,54375211231,54375213120,54375213121,54375213123,54375213310,54375213311,54375220000,54375230000,54375300310,54375300311,54375300312,54375301020,54375301021,54375301022,54375301110,54375301111,54375302320,54375302321,54375302322,54375310000,54375311001,54375311030,54375311031,54375311131,54375400020,54375400021,54375400030,54374030011,54374033300,54374033301,54374033303,54374033330,54374033331,54374033333,54375100000,54375100001,54375100003,54375100320,54375100321,54375100323,54375102101,54375102103,54375103300,54375103301,54375103302,54375103310,54375103311,54375112200,54375112201,54375112203,54375110320,54375110322,54375110300,54375110302,54375113120,54375113121,54375113123,54375113330,54375113331,54375113333,54375202210,54375202211,54375202213,54375202320,54375202321,54375202323,54375220110,54375220111,54375221000,54375221001,54375221002,54375221110,54375221111,54375212020,54375212022,54375212023,54375212000,54375212002,54375210310,54375210311,54375210313,54375302200,54375302201,54375301100,54375301101,54375301102,54374332220,54374332221,54374332222,54374333220,54374333221,54374333223,54374423000,54374423001,54374423002,
126,01,⻳,493748437,129909375,494817187,130275000,0,0,10,23,50,157,54371113,54371131,54371133,54371202,54371220,54371221,54371222,54371230,54371231,54371320,543711112,543711113,543711121,543711123,543711231,543711301,543711302,543711303,543711320,543711321,543712003,543712032,543712033,543712120,543712122,543712123,543712132,543712133,543712230,543712231,543713022,543713212,543721111,5437111031,5437111033,5437111102,5437111203,5437112133,5437112302,5437112303,5437112320,5437112321,5437113003,5437113221,5437113230,5437113231,5437113233,5437120012,5437120022,5437120023,5437120302,5437120303,5437120312,5437120313,5437121210,5437121212,5437121213,5437122320,5437123200,5437123201,5437123300,5437123311,5437130232,5437130233,5437132100,5437132102,5437132103,5437132130,5437132131,5437132200,5437132201,5437132210,5437132211,5437132300,5437132301,5437211100,5437211101,5437211103,5437211131,5437220000,5437220002,5437220020,5437220022,54371110321,54371110322,54371110323,54371111002,54371111003,54371111030,54371111032,54371111033,54371111122,54371111123,54371112013,54371112211,54371112213,54371121312,54371121313,54371121321,54371121322,54371121323,54371122131,54371122133,54371122311,54371122313,54371123012,54371123013,54371123220,54371123221,54371123300,54371123301,54371123302,54371123310,54371123311,54371130021,54371130023,54371132201,54371132231,54371132321,54371200013,54371200031,54371200033,54371200102,54371200132,54371200202,54371200203,54371200212,54371200213,54371201222,54371203000,54371203002,54371203003,54371203012,54371203013,54371203100,54371203102,54371203103,54371203112,54371203113,54371210223,54371210232,54371210233,54371210321,54371210322,54371210323,54371210332,54371212110,54371212112,54371212113,54371213020,54371213022,54371213023,54371213122,54371213123,54371213132,54371213133,54371223210,54371223211,54371223212,54371223220,54371223221,54371223300,54371223301,54371223310,54371232020,54371232022,54371232100,54371232101,54371232103,54371232110,54371232111,54371232113,54371233010,54371233011,54371233100,54371233101,54371233103,54371233131,54371302020,54371302022,54371302023,54371302032,54371302033,54371302300,54371302302,54371302303,54371302312,54371302313,54371303220,54371303222,54371303223,54371321010,54371321012,54371321013,54371321102,54371321120,54371321122,54371321123,54371321132,54371321133,54371321320,54371321321,54371321322,54371321330,54371321331,54371322020,54371322021,54371322030,54371322031,54371322131,54371323020,54371323021,54371323023,54371323030,54371323031,54371323032,54371330200,54371330202,54371330203,54371330220,54371330221,54371330223,54371330230,54371330232,54372110111,54372110113,54372111020,54372111021,54372111023,54372111201,54372111210,54372111301,54372111331,54372200010,54372200011,54372200012,54372200030,54372200032,54372200210,54372200212,
127,00,//,489262500,128362500,491273437,129825000,4,18,29,74,136,255,533651,533661,533662,533660,5336413,5336520,5336522,5336523,5336632,5336700,5336701,5336703,5336710,5336711,5336720,5336503,5336502,5335671,5335673,5335771,5335773,5435071,53364113,53364121,53364123,53364202,53364220,53364222,53364223,53365322,53366300,53366302,53367020,53367021,53367022,53367120,53367121,53367131,53367300,53367301,53365013,53365012,53355733,53357703,53357721,53357701,53357723,54350731,54350701,54350703,54350730,533641032,533641033,533641113,533641121,533641122,533641123,533641203,533641221,533641222,533641223,533642001,533642002,533642003,533642032,533642210,533642212,533642213,533650113,533652120,533652122,533652123,533653201,533653202,533653203,533653210,533653211,533653212,533653230,533653232,533663010,533663012,533663013,533663030,533663032,533663033,533663322,533670230,533670231,533670233,533671220,533671221,533671230,533671231,533671300,533671301,533671302,533671320,533672100,533672101,533672102,533672110,533672111,533672113,533672120,533672200,533672201,533672202,533672210,533673020,533673021,543600000,543600002,543600023,543600100,543600101,543600102,543600201,533650103,533650112,533650033,543600022,543600020,543600200,543600202,5336322233,5336410213,5336410231,5336410233,5336410303,5336411031,5336411032,5336411033,5336411113,5336411121,5336411122,5336411123,5336411201,5336411203,5336412011,5336412012,5336412013,5336412021,5336412023,5336412201,5336412203,5336420001,5336420002,5336420003,5336420100,5336420102,5336420120,5336420122,5336420300,5336420302,5336420303,5336420330,5336420332,5336422110,5336422112,5336422113,5336423002,5336423020,5336423022,5336423200,5336423202,5336423220,5336423222,5336501111,5336501113,5336521000,5336521002,5336521020,5336521022,5336521212,5336521213,5336521320,5336521322,5336521323,5336521332,5336530321,5336530322,5336530323,5336530332,5336532002,5336532003,5336532130,5336532131,5336532132,5336532310,5336532312,5336532330,5336532332,5336630110,5336630112,5336630113,5336630310,5336630312,5336630313,5336633000,5336633002,5336633200,5336633202,5336633232,5336702320,5336702321,5336702323,5336712220,5336712221,5336712222,5336712321,5336712330,5336712331,5336713030,5336713031,5336713032,5336713210,5336713300,5336713301,5336713303,5336713310,5336721030,5336721032,5336721120,5336721121,5336721123,5336721210,5336721212,5336721220,5336721221,5336721222,5336721310,5336721311,5336721313,5336722030,5336722110,5336722111,5336722112,5336723000,5336730300,5336730301,5336730302,5336731000,5336731001,5336731002,5336731020,5436000010,5436000012,5436000032,5436000110,5436000111,5436000113,5436000131,5436000210,5436000212,5436000213,5436001030,5436001100,5436001200,5436001201,5436002030,53363222311,53363222312,53363222313,53363222321,53363222322,53363222323,53363223202,53363223220,53363223222,53363223223,53364033331,53364033332,53364033333,53364102123,53364102301,53364103003,53364103012,53364103013,53364103021,53364103022,53364103023,53364110233,53364111032,53364111033,53364111112,53364111113,53364111121,53364111122,53364111123,53364111201,53364111202,53364111203,53364112023,53364120031,53364120032,53364120033,53364120101,53364120102,53364120103,53364122022,53364122023,53364200002,53364200003,53364201030,53364201032,53364201210,53364201212,53364201230,53364201232,53364203010,53364203012,53364203013,53364203102,53364203120,53364203122,53364203312,53364203330,53364203332,53364221110,53364221112,53364221113,53364230002,53364230212,53364230230,53364230232,53364230233,53364232010,53364232011,53364232012,53364232030,53364232032,53364232210,53365011123,53365210212,53365210230,53365210232,53365212102,53365212113,53365213002,53365213020,53365213022,53365213023,53365213210,53365213212,53365213332,53365302321,53365302323,53365302332,53365302333,53365303201,53365303202,53365303203,53365303300,53365303302,53365303332,53365320002,53365320003,53365320011,53365320012,53365320013,53365321330,53365323130,53365323132,53365323332,53366301110,53366301112,53366303110,53366303112,53366310200,53366310202,53366310220,53366312022,53366312200,53366312202,53366312220,53366312222,53366312223,53366330200,53366330222,53366332032,53366332300,53366332302,53366332303,53366332312,53366332330,53366332332,53367023220,53367023221,53367122230,53367122231,53367122232,53367122300,53367122301,53367122310,53367122311,53367123200,53367123201,53367123203,53367123221,53367123231,53367123320,53367123321,53367123323,53367123330,53367123331,53367123332,53367130330,53367130331,53367130333,53367132111,53367132120,53367132200,53367133020,53367133021,53367133023,53367133110,53367133111,53367133120,53367133121,53367133122,53367210310,53367210311,53367210312,53367210330,53367210332,53367212110,53367212112,53367212130,53367212132,53367212230,53367212231,53367212232,53367212300,53367212301,53367212310,53367213010,53367213011,53367213013,53367213031,53367213120,53367213121,53367213123,53367220310,53367220311,53367220312,53367220320,53367220321,53367220322,53367220330,53367221200,53367221201,53367221210,53367221211,53367221300,53367230010,53367230012,53367302200,53367302201,53367302210,53367302211,53367302300,53367302301,53367302310,53367303030,53367303100,53367310030,53367310100,53367310101,53367310102,53367310110,53367310220,54360000110,54360000111,54360000112,54360000300,54360000302,54360001011,54360001121,54360001123,54360001330,54360001331,54360001333,54360002110,54360002112,54360003111,54360003113,54360003202,54360003220,54360003222,54360010310,54360010311,54360010320,54360010321,54360010322,54360011010,54360011011,54360011020,54360011021,54360011022,54360011100,54360011110,54360011111,54360011200,54360020310,54360020311,54360020312,54360021000,54360021002,54360021020,54360021022,54360100000,54360100001,54360100010,54360020322,54360020320,
128,00,ʡ//,489487500,129459375,491203125,130725000,3,15,20,41,99,234,543611,543621,543610,5436003,5436011,5436012,5436013,5436020,5436022,5436120,5436122,5436220,5436222,5436201,5436203,5436310,5436301,5436311,53367222,53367223,54360013,54360023,54360101,54360102,54360103,54361230,54361231,54361232,54361320,54361322,54360022,54362001,54351711,54350733,54362003,54363130,54363121,54351713,533671323,533671332,533671333,533672302,533672320,543600012,543600030,543600033,543600113,543600121,543600122,543600123,543600211,543600212,543600213,543601001,543601002,543601003,543612120,543612122,543612123,543612132,543612330,543612331,543612332,543613210,543613212,543613230,543622100,543622101,543622102,543622120,543622122,543622300,543622302,543632000,543632001,543632002,543632010,543631310,543631312,5336712232,5336712233,5336713213,5336713221,5336713222,5336713223,5336713313,5336722113,5336722122,5336722123,5336722131,5336722132,5336722133,5336723002,5336723003,5336723030,5336723032,5336723212,5436000013,5436000031,5436000033,5436000100,5436000102,5436000103,5436000130,5436000132,5436000310,5436000312,5436000313,5436000321,5436000323,5436001033,5436001103,5436001112,5436001113,5436001121,5436001122,5436001123,5436001202,5436001203,5436002033,5436002101,5436002103,5436010002,5436010003,5436021222,5436023000,5436023002,5436023020,5436023022,5436121002,5436121020,5436121022,5436121023,5436121210,5436121212,5436121213,5436121302,5436121332,5436123330,5436123331,5436123333,5436130222,5436130223,5436130232,5436130233,5436132112,5436132113,5436132130,5436132131,5436132132,5436132310,5436132320,5436132322,5436133002,5436133020,5436221030,5436221031,5436221032,5436221100,5436221210,5436221212,5436221230,5436223010,5436223012,5436223030,5436223032,5436223200,5436223202,5436223220,5436320030,5436320031,5436320110,5436320200,5436320201,5436320202,5436320220,5436313110,5436313112,53367023222,53367023223,53367122233,53367122302,53367122303,53367122312,53367122313,53367123202,53367123220,53367123222,53367123223,53367123230,53367123232,53367123233,53367123322,53367123333,53367130332,53367132110,53367132112,53367132113,53367132121,53367132122,53367132123,53367132201,53367132202,53367132203,53367133022,53367133112,53367133113,53367133123,53367220313,53367220323,53367220331,53367220332,53367220333,53367221202,53367221203,53367221212,53367221213,53367221301,53367221302,53367221303,53367230013,53367230120,53367230122,53367230123,53367230310,53367230312,53367230330,53367230332,53367232100,53367232101,53367232102,53367232200,53367232202,53367232211,53367232300,53367232301,54360000113,54360000301,54360000303,54360001010,54360001012,54360001013,54360001120,54360001122,54360001332,54360002111,54360002113,54360003110,54360003112,54360003200,54360003201,54360003203,54360003221,54360003223,54360010312,54360010313,54360010323,54360011012,54360011013,54360011023,54360011101,54360011102,54360011103,54360011112,54360011113,54360011201,54360011202,54360011203,54360020313,54360020321,54360020323,54360021001,54360021003,54360021021,54360021023,54360100002,54360100003,54360100011,54360100012,54360100013,54360210020,54360210022,54360210200,54360210202,54360210220,54360210222,54360212000,54360212022,54360212200,54360212202,54360212203,54360212230,54360212232,54360230010,54360230012,54360230030,54360230032,54360230210,54360230212,54360230230,54360232000,54360232001,54360232002,54360232020,54360232222,54361210000,54361210002,54361210003,54361210032,54361210210,54361210212,54361210322,54361212110,54361212112,54361212113,54361213002,54361213003,54361213030,54361213032,54361213033,54361213300,54361213302,54361213303,54361213332,54361213333,54361233320,54361233321,54361233322,54361303222,54361303223,54361321102,54361321103,54361321112,54361321113,54361321330,54361321331,54361321332,54361323110,54361323112,54361323120,54361323121,54361323210,54361323212,54361323230,54361323232,54361330220,54362210330,54362210332,54362210333,54362211010,54362211011,54362211020,54362211022,54362211110,54362211111,54362212110,54362212111,54362212112,54362212130,54362212132,54362212320,54362212322,54362212323,54362230330,54362230332,54362232010,54362232011,54362232012,54362232030,54362232032,54362232100,54362232210,54362300000,54362300001,54362300101,54362300110,54362300111,54362301000,54362301001,54362301003,54362301010,54363131110,54363131111,54363200320,54363200321,54363200322,54363201110,54363201112,54363201120,54363201121,54363201122,54363201130,54363201200,54363201201,54363202030,54363202031,54363202032,54363202100,54363202102,54363202120,54363202210,54363202212,54363202213,54363202220,54363202221,54363202222,54363202230,54363202231,54363131112,54363131130,54363131300,54363131301,
129,00,//ʿ,490725000,128709375,492595312,130171875,5,10,44,76,177,398,533664,533665,533674,543603,543604,5336533,5336542,5336732,5336733,5336750,5336751,5336752,5436050,5436131,5436140,53365432,53365433,53365522,53365523,53365532,53365533,53365622,53366311,53366313,53366331,53366333,53366600,53366602,53366603,53366620,53366621,53366622,53367231,53367233,53367311,53367312,53367313,53367530,53367531,53367532,53367600,54360211,54360213,54360231,54360233,54360510,54360512,54360520,54360521,54360522,54360530,54361211,54361300,54361301,54361410,54361411,54361412,54361420,54361421,533653122,533653123,533653132,533653133,533654022,533654033,533654122,533654300,533654302,533654303,533654311,533654312,533654313,533655202,533655211,533655212,533655213,533655302,533655303,533656230,533656232,533663100,533663101,533663103,533663121,533663123,533663301,533663303,533663321,533666010,533666012,533666013,533666102,533666120,533666230,533666231,533666232,533672132,533672133,533673032,533673033,533673103,533675330,533676020,543602101,543602103,543602121,543602123,543602301,543602303,543602321,543602323,543605130,543605132,543605310,543605312,543605320,543605321,543605330,543605331,543612101,543612131,543613020,543613021,543613030,543613031,543613033,543613301,543613310,543613311,543613313,543613331,543614130,543614132,543614300,543615000,5336530313,5336530331,5336531202,5336531203,5336531212,5336531213,5336531302,5336531303,5336531311,5336531312,5336531313,5336532311,5336532331,5336540021,5336540022,5336540200,5336540202,5336540203,5336540232,5336540233,5336540321,5336540322,5336540323,5336541230,5336541232,5336541333,5336543010,5336543012,5336543013,5336543102,5336543103,5336550323,5336552002,5336552003,5336552032,5336552033,5336552101,5336552102,5336552103,5336553000,5336553002,5336553003,5336553012,5336553013,5336553122,5336553123,5336553132,5336553133,5336562022,5336562033,5336562102,5336562120,5336562122,5336562123,5336631021,5336631023,5336631200,5336631201,5336631203,5336631221,5336631223,5336633001,5336633003,5336633021,5336633023,5336633201,5336661220,5336661221,5336661222,5336662330,5336663000,5336663002,5336663020,5336663022,5336721122,5336721232,5336721233,5336721300,5336721302,5336723010,5336723011,5336723013,5336723211,5336723213,5336723222,5336723223,5336723231,5336723232,5336723233,5336730222,5336730223,5336730232,5336730233,5336730311,5336730312,5336730313,5336731012,5336731013,5336731021,5336731023,5336753310,5336753311,5336753320,5336753322,5336760122,5336760210,5336760211,5336760300,5436021000,5436021001,5436021003,5436021021,5436021023,5436021201,5436021203,5436021221,5436023201,5436023203,5436023220,5436023221,5436023223,5436051100,5436051102,5436051120,5436051122,5436052300,5436052301,5436052302,5436052310,5436052311,5436052320,5436052322,5436053132,5436053231,5436053320,5436053321,5436053330,5436053331,5436062200,5436062202,5436062220,5436121001,5436121030,5436121031,5436121033,5436121301,5436121331,5436130220,5436130221,5436130230,5436130231,5436130320,5436130321,5436130323,5436133000,5436133001,5436133003,5436133120,5436133121,5436133123,5436133301,5436141310,5436141312,5436142301,5436142310,5436142311,5436143010,5436143011,5436143012,5436143020,5436143021,5436143022,5436143100,5436150010,5436150011,5436150012,5436150020,53365303113,53365303123,53365303301,53365303303,53365303330,53365303331,53365303333,53365311333,53365312002,53365312003,53365312012,53365312013,53365313001,53365313002,53365313003,53365313012,53365313013,53365321331,53365321332,53365321333,53365323131,53365323133,53365323330,53365323331,53365323333,53365400003,53365400021,53365400023,53365400030,53365400032,53365400201,53365400202,53365400203,53365400230,53365400232,53365402010,53365402012,53365402013,53365402120,53365402122,53365402300,53365402302,53365402303,53365403033,53365403122,53365403203,53365412022,53365412023,53365412032,53365412033,53365413323,53365430110,53365430112,53365430113,53365431002,53365503203,53365503212,53365503221,53365503223,53365503322,53365503333,53365512222,53365512223,53365520002,53365520003,53365520012,53365520302,53365520303,53365520311,53365520312,53365520313,53365521001,53365521003,53365530010,53365530012,53365530013,53365530101,53365530102,53365530103,53365530112,53365530113,53365531022,53365531200,53365531202,53365531213,53365531302,53365531303,53365531310,53365531312,53365531313,53365620133,53365620202,53365620232,53365620233,53365620312,53365620313,53365620321,53365620322,53365620323,53365621210,53365621212,53365623320,53365623322,53366301111,53366301113,53366303111,53366303113,53366310201,53366310203,53366310221,53366310222,53366310223,53366312020,53366312021,53366312023,53366312201,53366312203,53366312221,53366330201,53366330202,53366330203,53366330220,53366330221,53366330223,53366332030,53366332031,53366332033,53366332301,53366332310,53366332311,53366332313,53366332331,53366332333,53366601100,53366601102,53366601120,53366601122,53366601133,53366610022,53366610023,53366610320,53366610322,53366612100,53366612102,53366612120,53366612230,53366623310,53366623311,53366623320,53366623322,53366630032,53366630210,53366630212,53366632000,53366632002,53366632020,53366632022,53367210313,53367210331,53367210333,53367212111,53367212113,53367212131,53367212133,53367212233,53367212302,53367212303,53367212311,53367212312,53367212313,53367213012,53367213030,53367213032,53367213033,53367213122,53367230011,53367230121,53367230311,53367230313,53367230331,53367230333,53367232103,53367232201,53367232203,53367232210,53367232212,53367232213,53367232302,53367232303,53367302202,53367302203,53367302212,53367302213,53367302302,53367302303,53367302311,53367302312,53367302313,53367303031,53367303032,53367303033,53367303101,53367303102,53367303103,53367310031,53367310032,53367310033,53367310103,53367310111,53367310112,53367310113,53367310221,53367310222,53367310223,53367533120,53367533121,53367533122,53367533130,53367533131,53367533230,53367533232,53367601000,53367601002,53367601020,53367601022,53367601200,53367601202,53367602120,53367602121,53367602122,53367602130,53367602131,53367602200,53367602201,53367602202,53367602210,53367603010,53367603012,53367603020,53367603021,53367620022,53367620200,53367620202,53367620220,53367620222,53367622000,53367622002,54360210021,54360210023,54360210201,54360210203,54360210221,54360210223,54360212001,54360212002,54360212003,54360212020,54360212021,54360212023,54360212201,54360212231,54360212233,54360230011,54360230013,54360230031,54360230033,54360230211,54360230213,54360230231,54360230232,54360230233,54360232003,54360232021,54360232022,54360232023,54360232220,54360232221,54360232223,54360511010,54360511012,54360511030,54360511032,54360511210,54360511212,54360511230,54360511232,54360511233,54360523130,54360523131,54360531122,54360531300,54360531302,54360531303,54360531330,54360531332,54360531333,54360532300,54360532301,54360532303,54360532330,54360532331,54360533220,54360533221,54360533230,54360533231,54360533320,54360533321,54360533330,54360533331,54360533333,54360620222,54360622012,54360622013,54360622030,54360622031,54360622032,54360622210,54360622220,54360622221,54360622222,54361210001,54361210030,54361210031,54361210033,54361210211,54361210213,54361210320,54361210321,54361210323,54361212111,54361213000,54361213001,54361213031,54361213301,54361213330,54361213331,54361303220,54361303221,54361321100,54361321101,54361321110,54361321111,54361330210,54361330211,54361330300,54361330311,54361330313,54361331220,54361331221,54361331223,54361333031,54361333301,54361333310,54361413110,54361413300,54361413301,54361413302,54361422000,54361422001,54361422010,54361422100,54361422101,54361422110,54361422111,54361422112,54361423000,54361423001,54361423120,54361423121,54361423130,54361430130,54361430131,54361430132,54361430230,54361430231,54361430300,54361430301,54361430302,54361431010,54361431011,54361431012,54361432000,54361432002,54361500130,54361500131,54361500132,54361500210,54361500211,54361500212,54361500220,54361500221,54361500222,54361500230,54361500300,54361500301,54361501000,54361501002,54361600000,
130,00,/ò/ǽ,490387500,130087500,491892187,131400000,2,16,25,42,114,214,543633,543643,5436231,5436232,5436233,5436240,5436242,5436321,5436323,5436440,5436442,5436540,5436322,5436420,5436421,5436423,5436531,5436530,54361332,54362213,54362231,54362233,54362302,54362303,54362432,54363203,54363400,54363401,54363402,54363410,54363420,54363422,54364432,54365410,54365411,54365412,54365211,54364221,54365321,54365330,54363133,54365320,54365213,543613233,543613332,543614222,543614223,543614232,543622112,543622113,543622323,543623002,543623003,543623011,543623012,543623013,543624300,543624302,543624303,543624332,543632013,543632023,543634030,543634031,543634032,543634110,543634120,543634210,543634212,543634230,543634232,543634233,543644100,543644102,543644120,543644122,543644300,543644302,543644303,543644330,543644332,543654130,543654131,543653231,543653230,5436132313,5436133023,5436133032,5436133033,5436133300,5436133302,5436133332,5436133333,5436142202,5436142203,5436142212,5436142213,5436142302,5436142303,5436142330,5436142332,5436221103,5436221110,5436221112,5436221113,5436221231,5436221233,5436223011,5436223013,5436223031,5436223211,5436223212,5436223213,5436223222,5436223223,5436230001,5436230002,5436230003,5436230012,5436230013,5436230102,5436230103,5436241200,5436241202,5436241220,5436241222,5436241223,5436243010,5436243012,5436243013,5436243102,5436243120,5436243122,5436243300,5436243302,5436320033,5436320121,5436320122,5436320123,5436320211,5436320213,5436340330,5436340332,5436341112,5436341120,5436341122,5436341210,5436341211,5436341212,5436341300,5436342110,5436342112,5436342130,5436342131,5436342132,5436342310,5436342312,5436343222,5436441012,5436441030,5436441032,5436441210,5436441212,5436441230,5436441232,5436441233,5436443010,5436443012,5436443120,5436443122,5436443123,5436443312,5436443330,5436443332,5436443333,5436533100,5436533101,5436533102,5436533110,5436541320,5436541321,5436541322,5436541330,5436542000,5436542001,5436542010,5436550020,5436550022,5436313132,5436313133,5436313131,5436533202,5436533210,5436533201,5436533200,5436532330,5436532321,5436532322,5436532320,54361233323,54361321333,54361323111,54361323113,54361323122,54361323123,54361323211,54361323213,54361323231,54361323233,54361330212,54361330213,54361330221,54361330222,54361330223,54361330301,54361330302,54361330303,54361330310,54361330312,54361331222,54361333030,54361333032,54361333033,54361333300,54361333302,54361333303,54361333311,54361333312,54361333313,54361422002,54361422003,54361422011,54361422012,54361422013,54361422102,54361422103,54361422113,54361423002,54361423003,54361423122,54361423123,54361423312,54361423330,54361423332,54362210331,54362211012,54362211013,54362211021,54362211023,54362211112,54362211113,54362212113,54362212131,54362212133,54362212321,54362230331,54362230333,54362232013,54362232031,54362232033,54362232101,54362232102,54362232103,54362232211,54362232212,54362232213,54362300002,54362300003,54362300100,54362300102,54362300103,54362300112,54362300113,54362301002,54362301011,54362301012,54362301013,54362410202,54362410220,54362410222,54362412032,54362412210,54362412212,54362412213,54362412320,54362412322,54362412323,54362430112,54362430113,54362431002,54362431003,54362431212,54362431230,54362431232,54362433010,54362433012,54362433030,54362433032,54363131113,54363200323,54363201111,54363201113,54363201123,54363201131,54363201132,54363201133,54363201202,54363201203,54363202033,54363202101,54363202103,54363202121,54363202122,54363202123,54363202211,54363202223,54363202232,54363202233,54363403312,54363403330,54363403332,54363411102,54363411103,54363411210,54363411212,54363412130,54363412131,54363412200,54363412201,54363412210,54363412211,54363421110,54363421112,54363421132,54363421330,54363421332,54363423110,54363423130,54363423132,54363423133,54363432200,54363432202,54363432230,54363432232,54363432233,54364410100,54364410102,54364410103,54364412312,54364412313,54364430110,54364430112,54364430130,54364430132,54364430133,54364431022,54364433102,54364433132,54364433310,54364433312,54364522220,54364522222,54365331030,54365331031,54365331110,54365331111,54365331120,54365331200,54365413230,54365413231,54365413310,54365413311,54365413312,54365413320,54365413321,54365420030,54365420031,54365420110,54365420111,54365420112,54365420120,54365420121,54365420130,54365421000,54365421001,54365421010,54365421011,54365421100,54365421101,54365421110,54365421111,54365430000,54365430011,54365430100,54365430101,54365500000,54365500002,54365500020,54365500022,54365500023,54365500032,54365500210,54365500212,54365500230,54365500232,54365502000,54365502001,54365502002,54363131303,54363131302,54363131133,54363131132,54363131131,
131,01,//,491512500,131625000,492525000,132225000,0,3,20,19,32,50,5436751,5436743,5436752,54366622,54367600,54367602,54366533,54366532,54367530,54367503,54367501,54367502,54367412,54367413,55360500,55360501,55360502,54367421,54367403,55360410,55360411,55360413,55360431,543675320,543666230,543666232,543676010,543676012,543676200,543675311,543675310,543675003,543674111,543674112,543674110,543674101,543674103,553605030,553605032,553605200,553605201,553605202,5536050312,5536050310,5536050311,5536051020,5536051002,5536051000,5436753222,5436753223,5436753220,5436753210,5436662310,5436760300,5436760302,5436760320,5436760322,5436762100,5436762010,5436762011,5436753130,5436753131,5436753121,5436753122,5436753120,5436750023,5436750021,5436741132,5436741130,5436741022,5436741021,5436741023,5536052100,5536052030,55360503300,55360503132,55360503130,55360503131,55360512000,55360512002,55360510222,55360510220,55360510221,55360510212,55360510210,55360510032,55360510010,54367532212,54367532210,54367532120,54366623111,54366623110,54366623112,54366623122,54366623300,54366623302,54366623320,54366623322,54367601100,54367601102,54367603030,54367603012,54367603010,54367621010,54367621012,54367621020,54367620131,54367620130,54367620121,54367620120,54367620122,54367620211,54367620210,54367620201,54367620200,54367531320,54367531231,54367531230,54367532111,54367410011,54367410013,54367410031,54367410032,54367410033,
131,02,/¢/컳,491821875,131625000,492075000,131775000,0,0,1,3,10,0,54366523,543675000,543675001,543665223,5436750020,5436750022,5436741133,5436741131,5436652222,5436652223,5436652221,5436652212,5436652211,5436652213,
131,03,Į/˷,491934375,131587500,491990625,131625000,0,0,0,0,3,1,5436652033,5436652120,5436652122,54366520313,
131,04,ϻ/Ω/Τ/Ͱ,491990625,131250000,492567187,131625000,0,2,9,14,13,27,5436651,5436553,54366621,54366603,54365620,54365622,54366602,54366600,54366620,54366530,54366531,543666012,543666010,543656232,543656230,543656212,543656210,543655231,543655233,543665033,543665031,543665013,543665011,543665213,543665211,5436663020,5436663002,5436663000,5436661222,5436660132,5436660130,5436562310,5436562312,5436562132,5436562110,5436562112,5436652123,5436652121,54366630220,54366630032,54366630030,54366630012,54366612202,54366612200,54366612022,54366612020,54366601332,54366601330,54366601123,54366601122,54366601120,54366601102,54366601100,54365623323,54365623322,54365623320,54365623302,54365623300,54365623301,54365623132,54365623130,54365623112,54365623110,54365621300,54365621302,
131,05,/Į/ͭ,491400000,130800000,492525000,131775000,0,1,15,44,62,118,5436551,54365602,54364602,54364620,54364533,54364531,54364532,54365503,54365521,54366500,54366502,54366433,54366423,54367401,54367400,54366432,543656030,543656003,543656002,543646230,543646221,543656000,543646222,543646220,543646212,543646210,543646032,543646030,543646012,543646003,543645133,543645132,543645303,543645302,543645233,543655011,543655013,543655203,543655221,543655230,543655222,543655223,543655232,543665010,543665012,543665030,543665032,543665210,543665200,543665201,543665220,543665202,543664311,543664313,543664312,543664303,543664302,543664213,543664223,543664222,5436560323,5436560322,5436560320,5436560122,5436560012,5436560010,5436462320,5436462231,5436462232,5436462230,5436462130,5436462112,5436462110,5436460332,5436460330,5436460311,5436460312,5436460310,5436460132,5436460011,5436460102,5436460013,5436460023,5436460021,5436460022,5436451311,5436451313,5436453011,5436453013,5436452311,5436452312,5436452313,5436452303,5436452323,5436550102,5436550122,5436550123,5436550121,5436550103,5436550101,5436550211,5436550213,5436550233,5436552012,5436552013,5436552011,5436552201,5436552203,5436543333,5436641111,5436641113,5436652030,5436652032,5436652210,5436652220,5436643103,5436643101,5436642123,5436741000,5436741002,5436741020,5436642213,54365603323,54365603322,54365603320,54365603212,54365603213,54365603210,54365603120,54365603102,54365603100,54365601233,54365601232,54365601230,54365601202,54365601203,54365601200,54365601022,54365600133,54365600112,54365600110,54364622332,54364622330,54364622331,54364623220,54364623210,54364623102,54364623100,54364621322,54364621320,54364621321,54364603310,54364603132,54364603130,54364603131,54364601333,54364601332,54364601330,54364601302,54364601303,54364601300,54364601000,54364601002,54364601003,54364601032,54364600123,54364600121,54364600103,54364600122,54364600203,54364600201,54364511333,54364513103,54364513121,54364513123,54364513122,54364513033,54364512332,54364512333,54364512331,54364512313,54364530032,54364521313,54364521331,54364521333,54364521332,54364521323,54364523101,54364523103,54364523102,54364523211,54364523210,54364523213,54364523013,54364523012,54364523221,54364523223,54365501001,54365501003,54365501002,54365501201,54365501203,54365500333,54365500332,54365502311,54365502313,54365502312,54365502323,54365502322,54365520100,54365520101,54365520103,54365520211,54365520213,54365520231,54365522021,54365522023,54365522022,54365433312,54365433313,54365433311,54366520310,54366520311,54366520312,54366421211,54366422022,54366422023,54366422032,54366422033,54366422122,54366422123,54366422121,54366422103,54366422112,54366422113,54366421223,54366421213,54367410010,54367410012,54367410030,
131,06,/Ǥ,491062500,131240625,491850000,131700000,0,2,9,21,45,71,5436640,5436631,54365422,54365423,54366413,54366412,54366410,54365333,54366420,54366331,54366301,543653313,543654202,543654203,543654212,543664211,543654213,543664301,543664300,543664113,543664110,543664112,543654323,543654302,543654320,543654322,543664210,543653322,543653323,543663331,543663330,543663301,5436533113,5436533121,5436533123,5436542002,5436542102,5436542103,5436542112,5436542113,5436543011,5436543100,5436543013,5436543012,5436543003,5436543002,5436543330,5436543332,5436643100,5436643102,5436641110,5436641112,5436543323,5436543322,5436543212,5436543210,5436543032,5436543030,5436642120,5436532323,5436533203,5436532331,5436532332,5436532333,5436533211,5436533212,5436533213,5436533122,5436642200,5436642201,5436633331,5436633330,5436633321,5436633320,5436633031,5436633030,5436633333,54365331113,54365331112,54365331123,54365331121,54365331122,54365331033,54365331032,54365331203,54365331201,54365331202,54365420032,54365420033,54365420122,54365420123,54365420133,54365420132,54365420131,54365420113,54365421002,54365421003,54365421012,54365421013,54365421102,54365421103,54365421112,54365421113,54365430002,54365430003,54365430001,54365430010,54365430012,54365430013,54365430102,54365430103,54365413232,54365431010,54365431021,54365431020,54365431022,54365430310,54365430312,54365430330,54365430332,54365432110,54365432112,54365432130,54365432132,54365432133,54365433022,54365433200,54365433202,54365433203,54365433212,54365433213,54366421210,54366421212,54366422020,54366422110,54366422021,54366422030,54366422031,54366422120,54366421220,54366421222,54366422111,54366421221,54366422100,54366422101,54366422102,54366333323,54366333321,
132,00,ϼ/,491596875,129843750,492693750,131371875,2,5,22,65,124,274,543625,543635,5436151,5436152,5436153,5436262,5436450,54361433,54361502,54361503,54361620,54362411,54362413,54362600,54362602,54362603,54362632,54363430,54363431,54363433,54363600,54363601,54363602,54363620,54363622,54364411,54364413,54364510,54364520,543605233,543605322,543614311,543614312,543614313,543614321,543614322,543614323,543615011,543615012,543615013,543616020,543616022,543616220,543616222,543624100,543624101,543624103,543624121,543624311,543624313,543624331,543624333,543626010,543626012,543626300,543626302,543634113,543634123,543634131,543634132,543634133,543634320,543634321,543634323,543636030,543636031,543636032,543636100,543636101,543636210,543636212,543636230,543644311,543644313,543645110,543645111,543645112,543645120,543645121,543645122,543645210,543645211,543645212,543645220,543645221,543645223,543646000,543654311,543654312,543654313,543654331,543655001,543655022,543655200,5436052303,5436052312,5436052321,5436052323,5436053232,5436141313,5436141331,5436141332,5436141333,5436143031,5436143032,5436143033,5436143102,5436143103,5436143201,5436143202,5436143203,5436150031,5436150032,5436150033,5436150101,5436150102,5436150103,5436160020,5436160022,5436160210,5436160212,5436160230,5436160232,5436162210,5436162212,5436162230,5436162232,5436162233,5436162322,5436241021,5436241023,5436241201,5436241230,5436241231,5436241233,5436243101,5436243103,5436260110,5436260112,5436260130,5436260132,5436261202,5436261220,5436261221,5436261222,5436263012,5436263030,5436263032,5436263033,5436263302,5436263320,5436263322,5436341111,5436341113,5436341123,5436341222,5436341223,5436341301,5436341302,5436341303,5436343221,5436360330,5436361020,5436361021,5436361022,5436361030,5436361100,5436362320,5436362322,5436441011,5436441013,5436441031,5436441033,5436441211,5436441213,5436443100,5436443101,5436443103,5436443121,5436443311,5436451130,5436451131,5436451132,5436451230,5436451232,5436451300,5436451301,5436451302,5436452130,5436452220,5436452221,5436452223,5436452300,5436452302,5436452320,5436453000,5436453001,5436453002,5436453010,5436453012,5436541333,5436543103,5436543300,5436543301,5436543303,5436550001,5436550030,5436550031,5436550032,5436550201,5436550202,5436550203,5436550210,5436550212,5436550230,5436552020,5436552022,5436552200,54360523132,54360523133,54360532302,54360532332,54360532333,54360533222,54360533223,54360533232,54360533233,54360533322,54360533323,54360533332,54361413111,54361413112,54361413113,54361413303,54361423131,54361423132,54361423133,54361423310,54361423311,54361423313,54361423331,54361423333,54361430133,54361430232,54361430233,54361430303,54361431013,54361432001,54361432003,54361500133,54361500213,54361500223,54361500231,54361500232,54361500233,54361500302,54361500303,54361501001,54361501003,54361600002,54361600020,54361600022,54361600023,54361600232,54361602130,54361602132,54361602310,54361602312,54361602330,54361602332,54361602333,54361621000,54361621002,54361621020,54361621022,54361621200,54361621202,54361621220,54361622110,54361622111,54361622112,54361622130,54361622132,54361622312,54361622313,54361623230,54361623232,54361623233,54362410200,54362410201,54362410203,54362410221,54362410223,54362412030,54362412031,54362412033,54362412211,54362412321,54362430110,54362430111,54362431000,54362431001,54362431210,54362431211,54362431213,54362431231,54362431233,54362433011,54362433013,54362433031,54362433033,54362601312,54362601330,54362601332,54362601333,54362612000,54362612002,54362612032,54362612033,54362612230,54362612232,54362612233,54362630100,54362630102,54362630103,54362630132,54362630310,54362630312,54362631222,54362633000,54362633002,54362633003,54362633212,54362633213,54362633230,54362633231,54362633232,54363403310,54363403311,54363403313,54363403331,54363403333,54363411100,54363411101,54363411211,54363411213,54363412132,54363412133,54363412202,54363412203,54363412212,54363412213,54363421111,54363421113,54363421130,54363421131,54363421133,54363421331,54363421333,54363423111,54363423112,54363423113,54363423131,54363432201,54363432203,54363432231,54363603310,54363603311,54363603312,54363603320,54363603321,54363603322,54363603330,54363610310,54363611010,54363611020,54363611021,54363611022,54363612000,54363621100,54363621102,54363623210,54363623212,54363623230,54363623232,54364410101,54364412310,54364412311,54364430111,54364430113,54364430131,54364431020,54364431021,54364431023,54364433100,54364433101,54364433103,54364433130,54364433131,54364433133,54364433311,54364433313,54364511330,54364511331,54364511332,54364512310,54364512311,54364512312,54364512330,54364513030,54364513031,54364513032,54364513100,54364513101,54364513102,54364513120,54364521310,54364521311,54364521312,54364521320,54364521321,54364521322,54364521330,54364522221,54364522223,54364523010,54364523011,54364523100,54364523212,54364523220,54364523222,54364530030,54364530031,54364530033,54364600100,54364600101,54364600102,54364600120,54364600200,54364600202,54364601001,54364601010,54364601012,54364601030,54365413233,54365413313,54365413322,54365413323,54365430311,54365430313,54365430331,54365430333,54365431011,54365431012,54365431013,54365431023,54365432111,54365432113,54365432131,54365433020,54365433021,54365433023,54365433201,54365433210,54365433211,54365433310,54365500001,54365500003,54365500021,54365500030,54365500031,54365500033,54365500211,54365500213,54365500231,54365500233,54365500330,54365500331,54365501000,54365501200,54365501202,54365502003,54365502310,54365502320,54365502321,54365520102,54365520210,54365520212,54365520230,54365520232,54365520233,54365522020,
133,00,Ȩ/ۤ/,491850000,131831250,492820312,134025000,1,20,37,48,134,279,553655,5536060,5536160,5536162,5536263,5536462,5536053,5536151,5536260,5536262,5536153,5536251,5536360,5536362,5536460,5536353,5536351,5536253,5536451,5536453,5536650,54367533,54367622,54367623,55360511,55360513,55360620,55360622,55360623,55361610,55361612,55361630,55361632,55362610,55362612,55363630,55363632,55364610,55364612,55365600,55365602,55365620,55365622,55366510,55366511,55366600,55366603,55360523,55361501,55361503,55360522,55361500,55361521,55364523,55364521,55364503,55366520,55361523,543675323,543676203,543676212,553605101,553605103,553605121,553605122,553605123,553606100,553606210,553606212,553606320,553606322,553606323,553616330,553616332,553626110,553626112,553636110,553636111,553636112,553646132,553646320,553656010,553656232,553665130,553666021,553666300,553626130,553626132,553626133,553666010,553666012,553646300,553646301,553646302,553636120,553636122,553636100,553636101,553665120,553665121,553665122,553665210,553665211,553605211,553605213,553605212,5436753133,5436753213,5436762022,5436762023,5436762103,5436762110,5436762112,5436762113,5436762130,5436762132,5436762133,5436763220,5436763222,5436763223,5536050331,5536050333,5536051023,5536051201,5536051202,5536051203,5536061020,5536061021,5536061200,5536061202,5536062110,5536062132,5536062133,5536063022,5536063023,5536161100,5536161102,5536161120,5536161122,5536161300,5536161302,5536163120,5536163122,5536261112,5536261130,5536261132,5536272220,5536272221,5536361130,5536361131,5536363322,5536461100,5536461102,5536560110,5536560120,5536560122,5536562100,5536562102,5536562300,5536562302,5536651320,5536651321,5536653000,5536653001,5536660231,5536661202,5536661203,5536662101,5536663020,5536272020,5536272022,5536272200,5536272202,5536270220,5536270222,5536261310,5536261312,5536261313,5536272000,5536272002,5536272003,5536163100,5536163102,5536660110,5536660112,5536660130,5536660132,5536463220,5536463210,5536463100,5536463101,5536463102,5536463030,5536463031,5536463032,5536461120,5536461122,5536461300,5536461302,5536461303,5536363100,5536363102,5536361301,5536361230,5536361232,5536361233,5536361030,5536361031,5536361033,5536361020,5536361022,5536361023,5536651310,5536651312,5536660201,5536653010,5536653011,5536653013,5536651230,5536651231,5536651232,5536662110,5536662111,5536662113,5536661220,5536661222,5536161320,5536161322,5536161323,5536652130,5536652120,5536652121,5536652122,5536052032,5536052031,5536052102,5536052101,5536052103,5536050332,5536052033,54367531232,54367531233,54367531321,54367531322,54367531323,54367532110,54367532112,54367532113,54367532121,54367532122,54367532123,54367532211,54367532213,54367603230,54367603232,54367620123,54367620132,54367620133,54367620202,54367620203,54367620212,54367620213,54367621011,54367621013,54367621021,54367621022,54367621023,54367621310,54367621311,54367630220,54367630222,54367632000,54367632002,54367632020,54367632022,54367632023,54367632212,54367632213,54367632320,54367632322,55360503133,55360503301,55360503302,55360503303,55360510011,55360510012,55360510013,55360510030,55360510031,55360510033,55360510211,55360510213,55360510223,55360512001,55360512003,55360610100,55360610102,55360610120,55360610220,55360610222,55360610223,55360612200,55360612201,55360612202,55360612220,55360621110,55360621111,55360621120,55360621121,55360621122,55360621300,55360621302,55360621303,55360621312,55360621313,55360630202,55360630203,55360630212,55360630213,55360632122,55360632123,55360632132,55360632133,55360633220,55360633222,55361611030,55361611032,55361611210,55361611212,55361611230,55361611232,55361613010,55361613012,55361613030,55361613032,55361631210,55361631212,55361631230,55361631232,55362611310,55362611312,55362722302,55362722320,55363611320,55363611321,55363611330,55363700200,55363700202,55364611010,55364611012,55364611030,55364611032,55365601130,55365601230,55365623032,55366530020,55366530021,55366612012,55366612122,55366621000,55366621001,55366621003,55366621310,55366621311,55366621313,55362702230,55362702232,55362702212,55362702022,55362613112,55362720010,55362720012,55362720210,55362720212,55362722032,55361631030,55361631032,55366612000,55366612002,55366612003,55366601330,55366601332,55365623320,55365623322,55365621200,55365621202,55365621220,55365621222,55365621223,55365603222,55365603223,55365603020,55365603000,55365603001,55365603002,55365601210,55365601211,55365601212,55365601120,55365601121,55365601122,55365601110,55365601111,55365601112,55364632220,55364632210,55364632211,55364632212,55364632120,55364632121,55364632122,55364632130,55364631030,55364631031,55364631200,55364631202,55364631220,55364632110,55364632112,55364630332,55364613302,55364631100,55364631102,55364613320,55364613322,55364611210,55364611212,55364611230,55364611232,55364613010,55364613012,55363633000,55363633002,55363633020,55363633022,55363633200,55363633202,55363631220,55363631222,55363631012,55363631030,55363631200,55363631201,55363631202,55363700020,55363700022,55363700000,55363700002,55362722220,55362722221,55362722222,55363613220,55363613222,55363612310,55363612312,55363612313,55363613031,55363612120,55363612122,55363612100,55363612102,55363612110,55363612111,55363610321,55363610322,55363613000,55363613001,55363613003,55363610210,55363610211,55363610212,55366530120,55366530121,55366530123,55366530030,55366530031,55366512330,55366512332,55366513300,55366513301,55366513110,55366513111,55366513112,55366602000,55366602001,55366602003,55366602030,55366602031,55366602301,55366602330,55366602331,55366621030,55366621031,55366621033,55366621120,55366621121,55366621123,55366630210,55366630211,55366630212,55366612230,55366612232,55366612210,55366612211,55366612212,55362611100,55362611102,55362611103,55361633320,55361633322,55361633300,55361633302,55361633120,55361633122,55361631010,55361631011,55361631012,55361613210,55361613212,
134,00,/ǽ/ǽ,492412500,132881250,493650000,133903125,4,4,9,29,72,168,553647,553657,553750,553740,5536372,5536563,5536561,5537303,55363702,55363730,55363732,55363733,55373020,55373022,55366610,55364633,55373023,553636313,553636331,553636333,553637012,553637030,553637032,553637033,553637132,553637310,553637312,553637313,553646111,553646313,553730211,553730212,553656031,553656033,553656211,553656213,553656231,553656013,553646323,553646131,553646113,553636311,553637003,553636131,553636133,553730213,5536363123,5536363301,5536363303,5536370001,5536370003,5536370010,5536370012,5536370013,5536370021,5536370022,5536370023,5536370102,5536370132,5536370310,5536370312,5536371220,5536371222,5536371223,5536371231,5536371232,5536371233,5536371302,5536371303,5536373110,5536373112,5536373113,5536463111,5536463113,5536463123,5537302102,5537302103,5536560321,5536560303,5536562331,5536562333,5536661210,5536661211,5536661300,5536661122,5536661120,5536661102,5536661100,5536661101,5536661110,5536661111,5536670000,5536660111,5536660113,5536660131,5536562330,5536562301,5536562123,5536562121,5536562103,5536562101,5536560323,5536560320,5536560301,5536463223,5536463121,5536461333,5536461331,5536463112,5536363321,5536363323,5536363121,5536272223,5536361323,5536361321,5536361213,5536361302,5536361320,55362722322,55362722323,55363611323,55363611331,55363611332,55363611333,55363700110,55363700112,55363700113,55363700201,55363700203,55363701032,55363701033,55363701302,55363703110,55363703112,55363703130,55363703132,55363703133,55363712022,55363712132,55363712133,55363712210,55363712212,55363712213,55363712301,55363712302,55363712303,55363713003,55363713012,55363713300,55363713302,55363713320,55363713322,55363731113,55364611011,55364611013,55364611031,55364611033,55373002223,55373002232,55373002233,55373003321,55373003322,55373003323,55373003330,55373003332,55373021000,55373021002,55373021003,55373021011,55373021012,55373021013,55365601133,55365601132,55365601233,55365623031,55366612010,55366612011,55366612121,55366612120,55366612130,55366612131,55366613020,55366611210,55366611032,55366611030,55366611130,55366611131,55366700