package Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Purple;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-06'; # DATE
our $DIST = 'Graphics-ColorNamesCMYK-ToutesLesCouleursCom'; # DIST
our $VERSION = '0.001'; # VERSION

our $NAMES_CMYK_TABLE = {
  'purple' => 0x21640028, # 33,100,0,40
  'amethyst' => 0x13360023, # 19,54,0,35
  'aubergine' => 0x00641b4e, # 0,100,27,78
  'persian blue' => 0x3c640000, # 60,100,0,0
  'byzantine' => 0x00490d1a, # 0,73,13,26
  'byzantium' => 0x003f0c38, # 0,63,12,56
  'cherry' => 0x004e370d, # 0,78,55,13
  'colombin' => 0x00230c3a, # 0,35,12,58
  'fuchsia' => 0x004b2a01, # 0,75,42,1
  'glycine' => 0x091b000e, # 9,27,0,14
  'flax grey' => 0x0b0e0007, # 11,14,0,7
  'heliotrope' => 0x0d370000, # 13,55,0,0
  'indigo' => 0x33590003, # 51,89,0,3
  'indigo' => 0x3964003a, # 57,100,0,58
  'indigo web' => 0x2a640031, # 42,100,0,49
  'lavender' => 0x242c0007, # 36,44,0,7
  'wine lie' => 0x00533c21, # 0,83,60,33
  'lilas' => 0x0d330012, # 13,51,0,18
  'magenta' => 0x00640000, # 0,100,0,0
  'dark magenta' => 0x00640032, # 0,100,0,50
  'magenta fuchsia' => 0x00642f0e, # 0,100,47,14
  'purple' => 0x002e0011, # 0,46,0,17
  'orchid' => 0x0031020f, # 0,49,2,15
  'parma' => 0x0b1f0009, # 11,31,0,9
  'purple' => 0x005b3b26, # 0,91,59,38
  'prune' => 0x00542431, # 0,84,36,49
  'candy pink' => 0x004a2502, # 0,74,37,2
  'hot pink' => 0x00643200, # 0,100,50,0
  'red-violet' => 0x00592116, # 0,89,33,22
  'bishop violet' => 0x002e0c37, # 0,46,12,55
  'violine' => 0x00601225, # 0,96,18,37
  'zizolin' => 0x09620035, # 9,98,0,53
};


1;
# ABSTRACT: CMYK colors from http://toutes-les-couleurs.com/ (purple)

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Purple - CMYK colors from http://toutes-les-couleurs.com/ (purple)

=head1 VERSION

This document describes version 0.001 of Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Purple (from Perl distribution Graphics-ColorNamesCMYK-ToutesLesCouleursCom), released on 2024-05-06.

=head1 DESCRIPTION

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SEE ALSO

Other C<Graphics::ColorNamesCMYK::ToutesLesCoulersCom::*> modules.

Other C<Graphics::ColorNamesCMYK::*> modules.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNamesCMYK-ToutesLesCouleursCom>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
