#!/usr/bin/perl

package eBay::API::XML::DataType::AdditionalAccountType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AdditionalAccountType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::AdditionalAccountType

=head1 DESCRIPTION

Contains the data for one additional account. An additional account is
created when the user has an active account and changes country of
registry (i.e., registers with the eBay site for the new country). A
new account is created and the old account becomes inactive as an
additional account. A user who never changes country of residency while
having an account will never have any additional accounts.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::AdditionalAccountType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::Enum::CurrencyCodeType;


my @gaProperties = ( [ 'AccountCode', 'xs:string', '', '', '' ]
	, [ 'Balance', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'Currency', 'ns:CurrencyCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CurrencyCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAccountCode()

Indicates the unique identifier for the additional account (the account ID).

#    Argument: 'xs:string'

=cut

sub setAccountCode {
  my $self = shift;
  $self->{'AccountCode'} = shift
}

=head2 getAccountCode()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getAccountCode {
  my $self = shift;
  return $self->{'AccountCode'};
}


=head2 setBalance()

Indicates the current balance of the additional account.

#    Argument: 'ns:AmountType'

=cut

sub setBalance {
  my $self = shift;
  $self->{'Balance'} = shift
}

=head2 getBalance()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'ns:AmountType'

=cut

sub getBalance {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Balance'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setCurrency()

Indicates the currency in which monetary amounts for the additional account
are expressed.

#    Argument: 'ns:CurrencyCodeType'

=cut

sub setCurrency {
  my $self = shift;
  $self->{'Currency'} = shift
}

=head2 getCurrency()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'ns:CurrencyCodeType'

=cut

sub getCurrency {
  my $self = shift;
  return $self->{'Currency'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
